/*************************************************************************
 *
 *  $RCSfile: htmlpiec.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <precomp.h>
#include <csi/html/htmlpiec.hxx>

// NOT FULLY DECLARED SERVICES
#include <cosv/file.hxx>


namespace csi
{
namespace html_old
{


char Text::cReplacable[256] =
	{
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,	// 0 - 49
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,    // 'CR' --> '<BR>'
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  1,  	0,  0,  0,  1,  0,    // ", &
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,

	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,	// 50 - 99
	  1,  0,  1,  0,  0,  	0,  0,  0,  0,  0,	  // <, >
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,

	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,  // 100 - 149
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,

	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,

	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  	0,  0,  0,  0,  0,

	  0,  0,  0,  0,  0,  	1					// &nbsp;
	};




Styled::Styled( StyleType	i_pStyle )
	:	sStyle(i_pStyle ? i_pStyle : "")
{
	if (sStyle.length() > 0 AND *sStyle.c_str() != ' ')
    {
		sStyle = StreamLock(200)() << ' ' << sStyle << c_str;
    }
}

Field::~Field()
{
	Delete_dyn(dpData);
}

void
Field::WriteOut( csv::bostream & io_aFile )
{
	Write_BeginTag(io_aFile);
	dpData->WriteOut(io_aFile);
	io_aFile.write("</");
	io_aFile.write(sTag);
	io_aFile.write(">\n");
}

Field::Field( DYN Piece &		let_drData,
						TagType			i_sTag,
						StyleType		i_pStyle )
	:	Styled(i_pStyle),
		sTag(i_sTag),
		dpData(&let_drData)
{
}

void
Field::Write_BeginTag( csv::bostream & io_aFile )
{
	io_aFile.write("<");
	io_aFile.write(sTag);
	Write_SpecificStyle(io_aFile);
	io_aFile.write(Style());
	io_aFile.write(">");
}

void
Field::Write_SpecificStyle( csv::bostream & io_aFile )
{
	// Default: Does nothing.
}

Tag::Tag( DYN Piece &		let_drData,
					TagType			i_sTag,
					StyleType		i_pStyle )
	: 	Field(let_drData, i_sTag, i_pStyle)
{
}



void
List::WriteOut( csv::bostream &	io_aFile )
{
	io_aFile.write("<");
	io_aFile.write(sListTag);
	io_aFile.write(sListStyle);
	io_aFile.write(">\n");
	for ( csv::SweList_dyn<Element>::iterator iter = aRows.begin();
		  iter != aRows.end();
		  ++iter )
	{
		io_aFile.write("\t");
		(*iter)->WriteOut(io_aFile);
	}
	io_aFile.write("</");
	io_aFile.write(sListTag);
	io_aFile.write(">\n");
}

List::List( TagType	i_sListTag,
					  StyleType	i_sListStyle )
	:	sListTag(i_sListTag),
		sListStyle(i_sListStyle ? i_sListStyle : "")
		// aRows
{
}

void
List::Add_Elem( DYN Piece &	let_drElement,
					 TagType		i_sTag,
					 StyleType		i_sStyle )
{
	aRows.push_back(new Element(let_drElement,i_sTag,i_sStyle));
}

List::Element::Element( DYN Piece &	let_drElementsContent,
							 TagType		i_sTag,
							 StyleType		i_pStyle )
	:	Field(let_drElementsContent, i_sTag, i_pStyle)
{
}


AnyTag::AnyTag( DYN Piece &		let_drData,
						  TagType			i_sTag,
						  StyleType			i_pStyle )
	: 	Tag(let_drData, i_sTag, i_pStyle)
{
}



Body::Body( StyleType		i_pStyle )
	:   Field( *new MultiPiece, "BODY", i_pStyle ),
		pData(0)
{
	pData = dynamic_cast<MultiPiece*>(&const_cast<Piece&>(Data()));
}

HorizontalLine::HorizontalLine( StyleType		i_pStyle )
	:	Styled(i_pStyle)
{
}

void
HorizontalLine::WriteOut( csv::bostream & io_aFile )
{
	io_aFile.write("<HR");
	io_aFile.write(Style());
	io_aFile.write(">");
}


Image::Image( const udmstri &		i_sSrc,
						const udmstri &      i_sWidth,
						const udmstri &      i_sHeight,
						const udmstri &      i_sAlign,
						const udmstri &      i_sBorder,
						const udmstri &      i_sAlt )
	:	sSrc(i_sSrc),
		sWidth(i_sWidth),
		sHeight(i_sHeight),
		sAlign(i_sAlign),
		sBorder(i_sBorder),
		sAlt(i_sAlt)
{
}

void
Image::WriteOut( csv::bostream & io_aFile )
{
	io_aFile.write("<IMG SRC=\"");
	io_aFile.write(sSrc);
	io_aFile.write("\" WIDTH=\"");
	io_aFile.write(sWidth);
	io_aFile.write("\" HEIGHT=\"");
	io_aFile.write(sHeight);
	io_aFile.write("\" ALIGN=\"");
	io_aFile.write(sAlign);
	io_aFile.write("\" BORDER=\"");
	io_aFile.write(sBorder);
	io_aFile.write("\" ALT=\"");
	io_aFile.write(sAlt);
	io_aFile.write("\">\n");
}

void
LineBreak::WriteOut( csv::bostream & io_aFile )
{
	io_aFile.write("<BR>\n");
}

Label::Label( DYN Piece & let_drShowedData,
					  const udmstri &  i_sDestinaton,
					  StyleType	  i_pStyle )
	:	Styled(i_pStyle),
		dpShowedData(&let_drShowedData),
		sName(i_sDestinaton)
{
}

Label::~Label()
{
	Delete_dyn(dpShowedData);
}

void
Label::WriteOut( csv::bostream &	io_aFile )
{
	io_aFile.write("<A NAME=\"");
	io_aFile.write(sName);
	io_aFile.write("\"");
	io_aFile.write(Style());
	io_aFile.write(">");
	dpShowedData->WriteOut(io_aFile);
	io_aFile.write("</A>\n");
}

Link::Link( DYN Piece & let_drShowedData,
					  const udmstri &  i_sDestinaton,
					  StyleType	  i_pStyle )
	:	Styled(i_pStyle),
		dpShowedData(&let_drShowedData),
		sDestination(i_sDestinaton)
{
}

Link::~Link()
{
	Delete_dyn(dpShowedData);
}

void
Link::WriteOut( csv::bostream &	io_aFile )
{
	io_aFile.write("<A HREF=\"");
	io_aFile.write(sDestination);
	io_aFile.write("\"");
	io_aFile.write(Style());
	io_aFile.write(">");
	dpShowedData->WriteOut(io_aFile);
	io_aFile.write("</A>");
}

void
MultiPiece::AddData( DYN Piece & let_drDatum )
{
	aData.push_back(&let_drDatum);
}

void
MultiPiece::WriteOut( csv::bostream & io_aFile )
{
	for ( Vector::iterator iter = aData.begin();
		  iter != aData.end();
		  ++iter )
	{
		(*iter)->WriteOut(io_aFile);
	}
}

Text::Text( const udmstri & i_sText )
	:	sText(i_sText)
{
}

void
Text::WriteOut( csv::bostream &	io_aFile )
{
	const char * pStart = sText.c_str();
	const char * pOut = 0;

	for ( pOut = pStart ; *pOut != '\0'; ++pOut )
	{
		if ( cReplacable[*pOut] )
		{
			if ( pOut != pStart )
			{
				io_aFile.write( pStart, pOut-pStart );
			}

			switch (UINT8(*pOut))
			{
				case '<': 	io_aFile.write("&lt;");		break;
				case '>':   io_aFile.write("&gt;");		break;
				case '"':   io_aFile.write("&quot;");	break;
				case '&':   io_aFile.write("&amp;");	    break;
				case 255:   io_aFile.write("&nbsp;");	break;
			}

			pStart = pOut+1;
		}	// endif (cReplacable[*pOut])
	}	// end for

	if ( pOut != pStart )
	{
		io_aFile.write( pStart, pOut-pStart );
	}
}

TextWithHtml::TextWithHtml( const udmstri & i_sText )
	:	sText(i_sText)
{
}

void
TextWithHtml::WriteOut( csv::bostream &	io_aFile )
{
	io_aFile.write(sText);
}

DefList::DefList(	StyleType i_pStyle )
	:	List("DL",i_pStyle)
{
}

void
DefList::AddTerm( DYN Piece & let_drElement,
					   StyleType   i_pStyle )
{
	Add_Elem(let_drElement, "DT", i_pStyle);
}

void
DefList::AddDefinition( DYN Piece & let_drElement,
							 StyleType	 i_pStyle )
{
	Add_Elem(let_drElement, "DD", i_pStyle);
}


SimpleList::SimpleList( TagType	i_sDifferentTag,
								  StyleType	i_pStyle )
	:	List("UL",i_pStyle)
{
}

void
SimpleList::AddElement( DYN Piece & let_drElement,
							 StyleType	 i_pStyle )
{
	Add_Elem(let_drElement, "LI", i_pStyle );
}

TableCell::TableCell( DYN Piece &		let_drData,
								StyleType		i_pStyle )
	:	Field( let_drData, "TD", i_pStyle )
{
}

void
TableRow::AddCell( DYN TableCell * let_dpData )
{
	aCells.push_back(let_dpData);
}

void
TableRow::WriteOut( csv::bostream & io_aFile )
{
	io_aFile.write("<TR>\n");
	for ( csv::SweList_dyn< TableCell >::iterator iter = aCells.begin();
		  iter != aCells.end();
		  ++iter )
	{
		(*iter)->WriteOut(io_aFile);
	}
	io_aFile.write("</TR>\n");
}

Table::Table( const udmstri &		i_sBorder,
			  const udmstri &		i_sWidth,
			  const udmstri &		i_sCellPadding,
			  const udmstri &		i_sCellSpacing,
			  StyleType		        i_pAdditionalStyle )
{
	StreamStr sTable(1000);
	sTable << " BORDER=" 		<< i_sBorder
		   << " WIDTH="         << i_sWidth
		   << " CELLPADDING="   << i_sCellPadding
		   << " CELLSPACING="   << i_sCellSpacing
		   << i_pAdditionalStyle;
	SetStyle( sTable.c_str() );
}

void
Table::AddRow( DYN TableRow *	let_dpData )
{
	aRows.push_back(let_dpData);
}

void
Table::WriteOut( csv::bostream & io_aFile )
{
	io_aFile.write("<TABLE ");
	io_aFile.write(Style());
	io_aFile.write(">\n");
	for ( csv::SweList_dyn< TableRow >::iterator iter = aRows.begin();
		  iter != aRows.end();
		  ++iter )
	{
		(*iter)->WriteOut(io_aFile);
	}
	io_aFile.write("\n</TABLE>\n");
}


}   // namespace html_old
}   // namespace csi







