/*************************************************************************
 *
 *  $RCSfile: dht_impl.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "dht_impl.hxx"


// NOT FULLY DEFINED SERVICES
#include <ary_i/ce2.hxx>
#include <ary_i/uidl/gate.hxx>
#include <ary_i/uidl/cenamesp.hxx>
#include <csi/dis_html/htmlpie2.hxx>
#include <cosv/file.hxx>
#include "di_whole.hxx"
#include "di_docu.hxx"
#include <ary_i/codeinf2.hxx>
#include <ary_i/ci_text2.hxx>
#include <ary_i/ci_atag2.hxx>






namespace display
{
namespace dsapi
{


HtmlDisplay_Impl::~HtmlDisplay_Impl()
{
	Delete_dyn(dpData);
}

void
HtmlDisplay_Impl::Init(	const S_ActiveModule & i_rCurModule )
{
	Delete_dyn(dpData);
	dpData = new Html_MultiPiece;
	pCurModule = &i_rCurModule;
}

void
HtmlDisplay_Impl::Release( Html_MultiPiece & o_rReceiver )
{
	o_rReceiver.AddData(*dpData);
	dpData = 0;
}

const String  &
HtmlDisplay_Impl::DisplayCe( csi::uidl::Display & o_rDisplay,
							 ary::Cei			  i_nCeId )
{
	ary::CodeEntity2 * ce = GetAryGate().FindCe(i_nCeId);
	if (ce != 0)
	{
		ce->DisplayAt(o_rDisplay);
		return ce->Name();
	}
	return String ::Null_();
}

void
HtmlDisplay_Impl::DisplayInformationParagraphs( const ary::info::CodeInformation * i_pDocu )
{
	if (i_pDocu == 0)
		return;

	DYN Html_DefList * dpDefList = new Html_DefList;

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;

    bool bHaveDescrTitle = false;
	if ( NOT i_pDocu->Short().IsEmpty() )
	{
    	dpDefList->AddTerm( *new Html_AnyTag( TextOH("Description"),"H4") );
        bHaveDescrTitle = true;

		DYN Html_MultiPiece * dpShort = new Html_MultiPiece;
		DisplayShort(*dpShort, i_pDocu->Short());
		dpText->AddData(*new Html_AnyTag(*dpShort,"P"));
	}

	if ( NOT i_pDocu->Description().IsEmpty() )
	{
        if (NOT bHaveDescrTitle)
        	dpDefList->AddTerm( *new Html_AnyTag( TextOH("Description"),"H4") );

		DYN Html_MultiPiece * dpDescr = new Html_MultiPiece;
		DisplayDescription(*dpDescr, i_pDocu->Description());
		dpText->AddData(*dpDescr);
	}

	dpDefList->AddDefinition(*dpText);
	Destination().AddData( *dpDefList );

	DocuDisplay aAtTags(CurModule());
	for ( std::vector< ary::info::AtTag2* >::const_iterator
				iter = i_pDocu->Tags().begin();
		  iter != i_pDocu->Tags().end();
		  ++iter )
	{
		if ( strlen( (*iter)->Title() ) > 0 )
			(*iter)->DisplayAt(aAtTags);
	}
	aAtTags.Release(Destination());
}

HtmlDisplay_Impl::HtmlDisplay_Impl(const S_ActiveModule & i_rCurModule)
	:	dpData(new Html_MultiPiece),
		pCurModule(&i_rCurModule)
{
}

HtmlDisplay_Impl::HtmlDisplay_Impl( const S_ActiveModule * i_pCurModule )
	: 	dpData(new Html_MultiPiece),
		pCurModule(i_pCurModule)
{
}

uintt
HtmlDisplay_Impl::Depth() const
{
	return pCurModule->nSubLevel;
}

DYN HtmlPiece *
HtmlDisplay_Impl::FullNameTypeLink( ary::Cei i_nType )
{
	if ( i_nType == 0 )
		return 0;

	bool bIsPredefined = false;
	String  sFullName = FullTypeName(i_nType, &bIsPredefined);
	if (bIsPredefined)
		return &TextOH(sFullName);
	else
	{
		const char * pStart = strrchr(sFullName,'<');
		const char * pStop = strchr(sFullName,'>');
		if ( pStart != 0 AND pStop != 0 )
		{
			DYN Html_MultiPiece * pMulti = new Html_MultiPiece;
			String  s1 = sFullName.substr(0, pStart-sFullName+1);
			String  s2 = sFullName.substr(pStart-sFullName+1, pStop-pStart-1);
			String  s3 = sFullName.substr(pStop-sFullName);
			pMulti->AddData( TextOH(s1) );
			pMulti->AddData( Create_TextLink( s2, TypeLink(i_nType) ) );
			pMulti->AddData( TextOH(s3) );
			return pMulti;
		}
		else
		{
			return &Create_TextLink( sFullName, TypeLink(i_nType) );
		} 	// endif (pStart != 0 AND pStop != 0) else
	}	// endif (bIsPredefined) else
}


const char *
HtmlDisplay_Impl::FullTypeName( ary::Cei i_nTypeId,
								bool *	 o_bIsPredefined )
{
	String  sName;
	uintt   nSequenceCount = 0;
	ary::uidl::CeNamespace * pNsp
			= GetAryGate().FindNameAndNamespaceOfType(sName,nSequenceCount,i_nTypeId);

	if (pNsp == 0 OR sName.length() == 0)
		return "";

	if (o_bIsPredefined != 0)
	{
		if ( pNsp->Id() == 1 )
			*o_bIsPredefined = true;
		else
			*o_bIsPredefined = false;
	}

    StreamLock aFullNameLock(500);
	StreamStr & aFullName = aFullNameLock();
	aFullName.seekp(0);
	for (uintt s = 0; s < nSequenceCount; ++s )
	{
		aFullName << "sequence< ";
	}
	uintt nPos = aFullName.tellp();
	pNsp->GetFullName(aFullName,"::");
	if (aFullName.tellp() > nPos)
		aFullName << "::";
	aFullName << sName;
	for (uintt s2 = 0; s2 < nSequenceCount; ++s2 )
	{
		aFullName << " >";
	}
	aFullName << " ";
	return aFullName.c_str();
}

const char *
HtmlDisplay_Impl::TypeLink( ary::Cei i_nTypeId )
{
	String  sName;
	uintt	nSequenceCount;
	ary::uidl::CeNamespace * pNsp
			= GetAryGate().FindNameAndNamespaceOfType(sName,nSequenceCount,i_nTypeId);

	if (pNsp == 0 OR sName.length() == 0)
		return "";

	static StreamStr aFullName(500);
	aFullName.seekp(0);
	pNsp->GetFullName(aFullName,"/");
	aFullName << "/" << sName << ".html";
	return RelaLink(Depth(),aFullName.c_str());
}

DYN Html_Link &
HtmlDisplay_Impl::LocalLink( const char * i_sName )
{
    StreamLock aSum(100);
	return Create_TextLink( i_sName,
                            aSum() << "#" << i_sName << c_str,
                            C_sMemberLink );
}

DYN Html_Table &
HtmlDisplay_Impl::CreateTable( const char *	i_sWidth )
{
	String  sBorder("0");
	String  sWidth(i_sWidth);
	String  sCellPadding("4");
	String  sCellSpacing("0");
	return *new Html_Table(sBorder,sWidth,sCellPadding,sCellSpacing);
}

void
HtmlDisplay_Impl::DisplayShort( Html_MultiPiece &			o_rDestination,
								const ary::info::DocuTex2 & i_rDocu )
{
	DocuDisplay aShort(CurModule());
	i_rDocu.DisplayAt(aShort);
	aShort.Release(o_rDestination);
}

void
HtmlDisplay_Impl::DisplayDescription( Html_MultiPiece &			  o_rDestination,
									  const ary::info::DocuTex2 & i_rDocu )
{
	DocuDisplay aDescription(CurModule());
	i_rDocu.DisplayAt(aDescription);
	aDescription.Release(o_rDestination);
}


}   // namespace dsapi
}   // namespace display



Html_Inverse::Html_Inverse(	DYN HtmlPiece &		let_drInhalt,
							const String 		i_sBgColor )
	:	dpInhalt(&let_drInhalt),
		sBgColor(i_sBgColor)
{
}

Html_Inverse::~Html_Inverse()
{
	Delete_dyn(dpInhalt);
}

void
Html_Inverse::WriteOut( csv::File & io_aFile )
{
	io_aFile.write( "<TABLE WIDTH=100% BORDER=0 CELLPADDING=4 CELLSPACING=0>"
					" <TR> <TD BGCOLOR=\"");
	io_aFile.write( sBgColor );
	io_aFile.write( "\" VALIGN=\"MIDDLE\">\r\n");
	dpInhalt->WriteOut(io_aFile);
	io_aFile.write( "\r\n</TD></TR></TABLE>\r\n" );
}


const char *
RelaLink( uintt 		nDepth,
		  const char *  i_sRootPath )
{
	static StreamStr  aLink(500);
	aLink.seekp(0);
	for (uintt i = 0; i < nDepth; ++i )
	{
		aLink << "../";
	}
	aLink << i_sRootPath;
	return aLink.c_str();
}



