/*************************************************************************
 *
 *  $RCSfile: html_env.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:03:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "html_env.hxx"


// NOT FULLY DEFINED SERVICES
#include <cosv/ploc_dir.hxx>
#include <display/keys_gl.hxx>



namespace
{

const String C_s_com("com");
const String C_s_sun("sun");
const String C_s_star("star");
const String C_s_index_files("index-files");

const String C_sModuleFileName("module-ix.html");
const String C_sUseFileSuffix("-use.html");
const String C_IndexA_FileName("index-1.html");



//************************         CheshireCat          ********************//

#if 0
struct InNamespaceTree
{
    enum E_Type
    {
        t_none,
        t_namespace,
        t_type,
        t_operations,
        t_data
    };

                        InNamespaceTree();
                        ~InNamespaceTree();
    void                GoDown(
                            const String &      i_rModuleName )
                                                { aModules.push(i_rModuleName); EraseCurCe(); }
    void                GoUp()                  { aModules.pop(); EraseCurCe(); }
    void                Go2Top()                { aModules.erase_all(); EraseCurCe(); }

  private:
    void                EraseCurCe()            { sCurCe_Name.erase(); eCurCeType = t_none; }

    EStack< String >    aModules; /// never empty.
    String              sCurCe_Name;
    E_Type              eCurCeType;
};

InNamespaceTree::InNamespaceTree()
    :   aModules(),
        sCurCe_Name(),
        eCurCeType(t_none)
{
}

InNamespaceTree::~InNamespaceTree()
{
}

#endif // 0
}   // anonymous namespace



struct HtmlEnvironment::CheshireCat
{
    csv::ploc::Directory
                aOutputRoot;
    csv::ploc::Directory
                aCurDirectory;
//    csv::StreamStr
//                aFileName;

    const ary::uidl::Gate *
                        pGate;
    const display::CorporateFrame *
                        pLayout;
    intt                nDepth;

                        CheshireCat(
                            const csv::ploc::Path &
                                                io_rOutputDir,
                            const ary::uidl::Gate &
                                                i_rGate,
                            const display::CorporateFrame &
                                                i_rLayout );
                        ~CheshireCat();
};

HtmlEnvironment::
CheshireCat::CheshireCat( const csv::ploc::Path &           io_rOutputDir,
                          const ary::uidl::Gate &           i_rGate,
                          const display::CorporateFrame &   i_rLayout )
    :   aOutputRoot(io_rOutputDir),
        aCurDirectory(io_rOutputDir),
//        aFileName(),
        pGate(&i_rGate),
        pLayout(&i_rLayout),
        nDepth(0)
{
}

HtmlEnvironment::
CheshireCat::~CheshireCat()
{
}



//******************        HtmlEnvironment        ********************//

HtmlEnvironment::HtmlEnvironment( const csv::ploc::Path &         io_rOutputDir,
                                  const ary::uidl::Gate &         i_rGate,
                                  const display::CorporateFrame & i_rLayout )
    :   pi( new CheshireCat(io_rOutputDir,i_rGate,i_rLayout) )
{
    if ( NOT pi->aOutputRoot.Exists() )
        pi->aOutputRoot.PhysicalCreate();
}

HtmlEnvironment::~HtmlEnvironment()
{
}

void
HtmlEnvironment::MoveDir_2Root()
{
    pi->aCurDirectory -= pi->nDepth;
    pi->nDepth = 0;
}

void
HtmlEnvironment::MoveDir_2Top_Names()
{
    MoveDir_2Root();
}

void
HtmlEnvironment::MoveDir_Down2( const String & i_rModule )
{
    pi->aCurDirectory += i_rModule;
    ++pi->nDepth;
}

void
HtmlEnvironment::MoveDir_Up()
{
    pi->aCurDirectory -= 1;
    --pi->nDepth;
}

void
HtmlEnvironment::MoveDir_2Top_Index()
{
    pi->aCurDirectory -= pi->nDepth;
    pi->aCurDirectory += C_s_index_files;
    pi->nDepth = 1;
}

void
HtmlEnvironment::CreateCurDirectory() const
{
    if ( NOT pi->aCurDirectory.Exists() )
       pi->aCurDirectory.PhysicalCreate(false);
}

const display::CorporateFrame &
HtmlEnvironment::Layout() const
{
    csv_assert(pi->pLayout != 0);
    return *pi->pLayout;
}

uintt
HtmlEnvironment::Depth() const
{
    return pi->nDepth;
}


const csv::ploc::Directory &
HtmlEnvironment::OutputRoot() const
{
    return pi->aOutputRoot;
}

const csv::ploc::Directory &
HtmlEnvironment::CurDirectory() const
{
    return pi->aCurDirectory;
}

const ary::uidl::Gate &
HtmlEnvironment::Gate() const
{
    return * pi->pGate;
}

void
HtmlEnvironment::Get_Link2Top( StreamStr & o_link ) const
{
    for ( intt i = 3; i < pi->nDepth; ++i )
    {
        o_link << "../";
    }

    if ( pi->nDepth < 1)
        o_link << C_s_com << "/";
    if ( pi->nDepth < 2)
        o_link << C_s_sun << "/";
    if ( pi->nDepth < 3)
        o_link << C_s_star << "/";

    Get_Link2CurModule(o_link);
}

void
HtmlEnvironment::Get_Link2CurModule( StreamStr & o_link ) const
{
    o_link << C_sModuleFileName;
}

void
HtmlEnvironment::Get_Link2Use( StreamStr &          o_link,
                               const String &       i_ce ) const
{
    o_link << i_ce << C_sUseFileSuffix;
}

void
HtmlEnvironment::Get_Link2Manual( StreamStr &         o_link,
                                  const String &      i_ce ) const
{
    // KORR
}

void
HtmlEnvironment::Get_Link2Index( StreamStr & o_link ) const
{
    for ( intt i = 0; i < pi->nDepth; ++i )
    {
        o_link << "../";
    }

    o_link << C_s_index_files << "/" << C_IndexA_FileName;
}

void
HtmlEnvironment::Get_Link2Type( StreamStr &         o_Link,
                                const char *        i_sScope,
                                const char *        i_sLinkText )
{
    Get_RelativeLinkToNamespaceDir( o_Link, i_sScope );
    o_Link << i_sLinkText << ".html";
}

void
HtmlEnvironment::Get_Link2Member( StreamStr &         o_Link,
                                  const char *        i_sScope,
                                  const char *        i_sType,
                                  const char *        i_sMember )
{
    Get_RelativeLinkToNamespaceDir( o_Link, i_sScope );
    o_Link << i_sType << ".html#" << i_sMember;

    size_t nMemNameLen = strlen(i_sMember);
    if ( nMemNameLen > 2 ? strcmp("()",i_sMember+(nMemNameLen-2)) == 0 : false )
        o_Link.seekp(-2,csv::cur);
}

void
HtmlEnvironment::Get_Link2AnyFromText( StreamStr &         o_Link,
                                       String &            o_sDisplayText,
                                       const char *        i_sLinkText )
{
    const ary::uidl::CeNamespace *
            pNsp = & const_cast< ary::uidl::Gate& >(Gate()).GlobalNamespace();
    const char *
            pNextNsp = i_sLinkText;
    bool bGoon = true;
    StreamLock
            slScope(300);

    while (bGoon)
    {
        if ( strncmp(pNextNsp,"::", 2) == 0 )
            pNextNsp += 2;

        const char *
                pEnd = strchr(pNextNsp,':');
        size_t  nLen = pEnd == 0
                            ?   strlen(pNextNsp)
                            :   pEnd - pNextNsp;
        String  sPart(pNextNsp, nLen);

        ary::uidl::CeNamespace *
                pSub = pNsp->SubNamespace(sPart);
        if (pSub != 0)
        {
            pNsp = pSub;
            pNextNsp += nLen;

            slScope() << "::" << sPart;
        }
        else
        {
            bGoon = false;
        }
    }

    o_sDisplayText = pNextNsp;

    if ( strchr(pNextNsp,':') == 0 )
    {
        Get_Link2Type(o_Link, slScope().c_str(), o_sDisplayText);
    }
    else
    {
        const char * pTrenner = strstr( pNextNsp, "::" );

        if (pTrenner == 0)
        {
            o_Link << " " << i_sLinkText << " ";
            return;
        }

        udmstri sType = o_sDisplayText.substr(0, pTrenner - pNextNsp);

        Get_Link2Member( o_Link, slScope().c_str(), sType, pTrenner+2 );
    }
}

void
HtmlEnvironment::Get_RelativeLinkToNamespaceDir( StreamStr &         o_Link,
                                                 const char *        i_sDestinationNamespace )
{
    if ( strlen(i_sDestinationNamespace) == 0 )
        return;

    uintt   nDifferentPath = Depth();
    StringVector::const_iterator
            itEnd = CurDirectory().MyPath().DirChain().End();
    StringVector::const_iterator
            itMyPath = itEnd - nDifferentPath;
    const char * pDestination = i_sDestinationNamespace;
    bool bGoon = true;

    while (bGoon AND itMyPath != itEnd)
    {
        if ( strncmp(pDestination,"::", 2) == 0 )
            pDestination += 2;
        if ( strncmp(pDestination, (*itMyPath).c_str(), (*itMyPath).length()) == 0 )
        {
            nDifferentPath--;
            pDestination += (*itMyPath).length();
            ++itMyPath;
        }
        else
        {
            bGoon = false;
        }
    }   // while

    for ( uintt i = 0; i < nDifferentPath; ++i )
    {
        o_Link << "../";
    }

    if ( strncmp(pDestination,"::", 2) == 0 )
        pDestination += 2;
    if (*pDestination == '\0')
        pDestination = 0;
    while ( pDestination != 0 )
    {
        o_Link.operator_add_token(pDestination,':')
            << "/";
        pDestination = strchr(pDestination,':');
        if (pDestination != 0)
            pDestination += 2;
    }   // end while
}



