/*************************************************************************
 *
 *  $RCSfile: oodbimpl.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_OODBIMPL_HXX
#define OODB_OODBIMPL_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <template/dicty.hxx>
#include <template/listinbl.hxx>
#include <template/bin_list.hxx>
#include <cosv/cosvfile.hxx>
#include <cosv/plocinfo.hxx>
	// PARAMETERS
#include <oodb/odbtypes.hxx>

#include <oodb/freenums.hxx>
class OodbArea;



struct S_ObjectPosition
{
						S_ObjectPosition(
							UINT32				i_nDataPosition = UINT_MAX);

	void				Clear();

	UINT32				nDataPosition;	// in a<n>.dat file
	UINT32              nDataEnd;      // in a<n>.inx file
};





/**	Verwaltet alle Areas, prueft, welche gerade aktiv sind
	in dem Sinne, da ihre Dateien geffnet sind.
**/
struct S_AreaAdmin
{
  public:
						S_AreaAdmin(
							const DiskLocation &
												i_rDirectory);
						~S_AreaAdmin();

	OodbArea *		   	operator[](
							OodbAreaNr			i_nArea);

	bool              	Add(
							const CosvList<String> &
												i_rNewAreaNames);
	bool              	Delete(
							const CosvList<String> &
												i_rAreaToDeleteNames);
	bool				Exists(
							const String &		i_sAreaName) const;
	OodbAreaNr			Nr(
							const String &		i_sAreaName) const;
	void				List(
							CosvList<intt> *	o_rAreaNrs,
							CosvList<String> *	o_rAreaNames ) const;

  private:
	void				LoadList();
	void				SaveList();

	CosvAutoDelList<OodbArea>
						aAreas;
	AVL_Tree<OodbArea*,String>
						aAreasKey;
	FreeNumbers			aFreeNumbers;
	DiskLocation		aDirectory;
};


struct S_AreaOnCallAdmin
{
  public:
						S_AreaOnCallAdmin();
						~S_AreaOnCallAdmin();

	void				Insert(
							OodbArea & 			i_rArea);
	void				Remove(
							OodbArea & 			i_rArea);

	void				List(
							CosvList<intt> *	o_rAreaNrs,
							CosvList<String> *	o_rAreaNames ) const;
	bool				Find(
							OodbArea * &		o_pArea,
							OodbId				i_nObject );
  private:
	BinaryList<OodbArea,intt>
						aAreasOnCall;
};


struct S_Handles
{
  public:
						S_Handles(
							const DiskLocation &
												i_rDirectory);
						~S_Handles();

	bool				AddHandle(
							intt			   	i_nHandle,
							OodbId			   	i_nObject );
	bool				RemoveHandles(
							const CosvList<intt> &
												i_nHandles );

	OodbId				Get(
							intt				i_nHandle) const;

  private:
	AVL_Tree<OodbId,intt>
						aUserHandles;
	CosvFile			aHandlesFile;
};

struct S_Activity
{
  public:
	enum E_Activity
	{
		idle = 0,
		adding = 1,
		updating = 2,
		reading = 3
	};

	virtual CosvFile *	Start() const = 0;
	virtual bool		Finish() const = 0;
	virtual E_Activity	Type() const = 0;
};

struct S_AddingData : public S_Activity
{
  public:
						S_AddingData(
							OodbArea &			i_rArea,
							OodbId &			o_nObjectId );

	virtual CosvFile *	Start() const;
	virtual bool		Finish() const;
	virtual E_Activity	Type() const;

  private:
	OodbArea &			rArea;
	OodbId &			out_nObject;
};

struct S_UpdatingData : public S_Activity
{
  public:
						S_UpdatingData(
							OodbArea &			i_rArea,
							OodbLocalId			i_nObjectId );

	virtual CosvFile *	Start() const;
	virtual bool		Finish() const;
	virtual E_Activity	Type() const;

  private:
	OodbArea &			rArea;
	OodbLocalId			nObject;
};

struct S_ReadingData : public S_Activity
{
  public:
						S_ReadingData(
							OodbArea &			i_rArea,
							OodbLocalId	 		i_nObjectId ); // 0 if this is a new object.

	virtual CosvFile *	Start() const;
	virtual bool		Finish() const;
	virtual E_Activity	Type() const;

  private:
	OodbArea &			rArea;
	OodbLocalId			nObject;
};



#endif

