/*************************************************************************
 *
 *  $RCSfile: oodbload.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_OODBLOAD_HXX
#define OODB_OODBLOAD_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <oodb\reflprov.hxx>
	// PARAMETERS
#include <oodb\oodb.hxx>
#include <oodb\odbtypes.hxx>


/**	@task
**/
template <class DEST>
class OodbLoader
{
  public:
	// LIFEYCLE
						OodbLoader(
							Oodb &				io_rData,
							const ReflectionProvider &
												i_rReflections );
						~OodbLoader();
	// OPERATORS
	bool				operator()(
							DEST &				o_rDestination,
							OodbId				i_nDatabaseId );

	// OPERATIONS

	// INQUIRY


  private:
	// DATA
	Oodb *				pDatabase;
	const ReflectionProvider *
						pReflections;
};

template <class DEST>
OodbLoader<DEST>::OodbLoader( Oodb &	 				  io_rData,
							  const ReflectionCatalogue & i_rReflections )
	: 	pDatabase(&io_rData),
		pReflections(&i_rReflections)
{
}

template <class DEST>
OodbLoader<DEST>::~OodbLoader()
	: 	pDatabase(&io_rData),
		pReflections(&i_rReflections)
{
}

template <class DEST>
bool
OodbLoader<DEST>::operator()( DEST & o_rDestination,
							  OodbId i_nDatabaseId )
{
	assert(pDatabase != 0);
	assert(pReflections != 0);

#if 0
	intt nSchemeId;
	bool bFound = pDatabase->OpenObject( i_nDatabaseId,
										 nSchemeId );
	if (NOT bFound)
	{
		pDatabase->CloseObject();
		return false;
	}

	StdReflection<TYPE> * pRefl = FindReflection(nSchemeId,i_pRefl);
	if (pRefl == 0)
	{
		pDatabase->CloseObject();
		return false;
	}

	for ( intt nElementId = NextElementId();
		  nElementId != 0;
		  nElementId = NextElementId() )
	{
		MemberAccessor<TYPE> * pAccessor = (*pRefl)[nElementId];
		if (pAccessor == 0)
			continue;
		pAccessor->ReadSerialized(o_rDestination,this);
	}
#endif // 0
	return true;
}


#endif


