/*************************************************************************
 *
 *  $RCSfile: scheme.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_SCHEMA_HXX
#define OODB_SCHEMA_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS

enum E_OodbType
{
	ODBT_none	 	    = 0,

	ODBT_int8	 	    = 1,
	ODBT_uint8          = 2,
	ODBT_int16          = 3,
	ODBT_uint16         = 4,
	ODBT_int32          = 5,
	ODBT_uint32         = 6,
	ODBT_int64          = 7,
	ODBT_uint64         = 8,

	ODBT_char8          = 24,
	ODBT_char16         = 25,
	ODBT_char32         = 26,

	ODBT_bool           = 41,

	ODBT_real32         = 48,
	ODBT_real64         = 49,
	ODBT_real80         = 50,

	ODBT_string         = 64,
	ODBT_rawdata        = 96,

	ODBT_ListWS         = 0x0100 + 1,
	ODBT_ListNT         = 0x0100 + 2,
	ODBT_Struct         = 0x0200 + 1,
};


/**	@task
	class Oodb provides an object oriented database.
**/
class OodbScheme
{
  public:
	// LIFEYCLE
	virtual				~OodbScheme();

	// OPERATORS

	// OPERATIONS

	// INQUIRY
	virtual intt	   	NrofMembers() const = 0;
	virtual E_OodbType	operator[](
							UINT8       		i_nMemberId ) const = 0;
};





#endif


