/*************************************************************************
 *
 *  $RCSfile: intelx86.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dbo $ $Date: 2001/04/18 11:05:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _RTL_ALLOC_H_
#include <rtl/alloc.h>
#endif

#include "c_bridge.hxx"

namespace c_uno
{

//==================================================================================================
extern "C" cuno_ErrorCode SAL_CALL call_c_function(
	void * fptr, void * pParams, sal_Int32 nParams ) SAL_THROW_EXTERN_C()
{
	cuno_ErrorCode retVal;
	
#ifdef MSC
__asm
	{
		mov		eax, nParams
		// copy values
		mov		ecx, eax
		shl		eax, 2			 // *4
		add		eax, pParams     // params stack
Lcopy:	sub		eax, 4
		push	dword ptr [eax]
		dec		ecx
		jne		Lcopy
		// call
		mov		eax, fptr
		call	eax
		mov		retVal, eax
		mov		eax, nParams
		shl		eax, 2			 // *4
		add		esp, eax
	}
#elif GCC
	__asm__
	(
		"mov %2, %%eax\n\t"
		"mov %%eax, %%ecx\n\t"
		"shl $2, %%eax\n\t"
		"add %1, %%eax\n"
		"Lcopy:\n\t"
		"sub $4, %%eax\n\t"
		"pushl (%%eax)\n\t"
		"dec %%ecx\n\t"
		"jne Lcopy\n\t"
		"mov %0, %%eax\n\t"
		"call *%%eax\n\t"
		"mov %%eax, %3\n"
		"mov %2, %%eax\n\t"
		"shl $2, %%eax\n\t"
		"add %%eax, %%esp\n\t"
		: : "m"(fptr), "m"(pParams), "m"(nParams), "m"(retVal)
	);
#else
#error "### unsupported x86 compiler!"
#endif
	
	return retVal;
}

//--------------------------------------------------------------------------------------------------
static inline void writeLong( unsigned char * p, sal_uInt32 l ) SAL_THROW( () )
{
	p[ 0 ] = (unsigned char)l;
	p[ 1 ] = (unsigned char)(l >> 8);
	p[ 2 ] = (unsigned char)(l >> 16);
	p[ 3 ] = (unsigned char)(l >> 24);
}
//__________________________________________________________________________________________________
struct _com_sun_star_uno_XInterface_ftab * Ftables::getFtable( sal_uInt32 nSize ) SAL_THROW( () )
{
	if (_nCurrent < nSize)
	{
		__TRACE( "> need larger ftable! <\n" );
		
		::osl::MutexGuard aGuard( _aMutex );
		if (_nCurrent < nSize)
		{
			nSize = (nSize +1) & 0xfffffffe;
			void ** pft = (void **)::rtl_allocateMemory( (nSize * sizeof (void *)) + (nSize *16) );
			
			// setup ftable and code
			for ( sal_uInt32 nPos = 0; nPos < nSize; ++nPos )
			{
				unsigned char * codeSnip = ((unsigned char *)(pft + nSize)) + (nPos *16);
				pft[ nPos ] = codeSnip;
				
				/**
				 * ftable calls detonate on the following code snippets
				 */
				// push esp
				*codeSnip++ = 0x54;
				// push nPos
				*codeSnip++ = 0x68;
				writeLong( codeSnip, nPos );
				codeSnip += sizeof (sal_uInt32);
				// call rel32 proxy_ftable_call
				*codeSnip++ = 0xe8;
				writeLong( codeSnip, ((unsigned char *)proxy_ftable_call) - codeSnip - sizeof (sal_uInt32) );
				codeSnip += sizeof (sal_uInt32);
				// add esp, 8
				*codeSnip++ = 0x83;
				*codeSnip++ = 0xc4;
				*codeSnip++ = 0x08;
				// ret
				*codeSnip++ = 0xc3;
			}
			_pCurrent = pft;
			_nCurrent = nSize;
			_aSpaces.push_back( pft );
		}
	}
	return (struct _com_sun_star_uno_XInterface_ftab *)_pCurrent;
}
//__________________________________________________________________________________________________
Ftables::~Ftables() SAL_THROW( () )
{
	__TRACE( "> calling ~Ftables(): freeing ftables... <\n" );
	
	::osl::MutexGuard aGuard( _aMutex );
	
	// this MUST be the absolute last one which is called!
	for ( t_pSpacesList::iterator iPos( _aSpaces.begin() ); iPos != _aSpaces.end(); ++iPos )
	{
		::rtl_freeMemory( *iPos );
	}
}

}
