/*************************************************************************
 *
 *  $RCSfile: exports.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: dbo $ $Date: 2001/10/26 07:22:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include <osl/diagnose.h>

#include <rtl/string.hxx>
#include <rtl/ustring.hxx>

#include <uno/lbnames.h>
#include <java_uno_environment.hxx>

#include <java_uno_mapping.hxx>

#include <com/sun/star/java/XJavaMapper.hpp>

using namespace ::com::sun::star::java;
using namespace ::com::sun::star::uno;

using namespace ::java;
using namespace ::rtl;

extern "C" SAL_DLLEXPORT void SAL_CALL uno_initEnvironment(
	uno_Environment * pEnvironment)
{
	java_environment_init(pEnvironment);
}


static const OUString uno_lb_java(OUString::createFromAscii(UNO_LB_JAVA));
static const OUString uno_lb_uno(OUString::createFromAscii(UNO_LB_UNO));


extern "C" SAL_DLLEXPORT void SAL_CALL uno_ext_getMapping(
	uno_Mapping ** ppMapping,	
	uno_Environment * pFrom,
	uno_Environment * pTo)
{
	if (*ppMapping)
		((*ppMapping)->release)(*ppMapping);

	*ppMapping = NULL;

	try	{
		OUString fromName(pFrom->pTypeName);
		OUString toName(pTo->pTypeName);

		if ((fromName.equalsIgnoreAsciiCase(uno_lb_java) && toName.equalsIgnoreAsciiCase(uno_lb_uno))
		||  (fromName.equalsIgnoreAsciiCase(uno_lb_uno)  && toName.equalsIgnoreAsciiCase(uno_lb_java)))
		{
			*ppMapping = reinterpret_cast<uno_Mapping *>(new java_Mapping(pFrom, pTo));
			(*ppMapping)->acquire(*ppMapping);
		}
	}
	catch(RuntimeException & runtimeException) {
		OString message = OUStringToOString(runtimeException.Message, RTL_TEXTENCODING_ASCII_US);
		fprintf(stderr, "java_uno bridge - could not create java mapping cause %s", message.getStr());
	}
}
