/*************************************************************************
 *
 *  $RCSfile: java_uno_mapping.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: dbo $ $Date: 2001/10/26 07:22:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef __JAVA_UNO_MAPPING_HXX
#define __JAVA_UNO_MAPPING_HXX

#include <uno/dispatcher.h>
#include <uno/environment.h>
#include <uno/mapping.h>
#include <uno/lbnames.h>

#include <osl/interlck.h>

#include <com/sun/star/uno/RuntimeException.hpp>

namespace java
{
	struct java_Mapping 
	{
		java_Mapping(uno_Environment * pFrom, uno_Environment * pTo) throw(::com::sun::star::uno::RuntimeException);
		~java_Mapping();

		uno_Mapping _uno_mapping;

		uno_Environment * _pFrom;
		uno_Environment * _pTo;

		uno_Interface * _pMapper;

		typelib_TypeDescription * _pXJavaMapper_mapIntToObject;
		typelib_TypeDescription * _pXJavaMapper_mapObjectToInt;

		oslInterlockedCount	_refCount;
	};

	void java_Mapping_init(java_Mapping * pJava_mapping, 
						   uno_Environment * pFrom,
						   uno_Environment * pTo) throw (::com::sun::star::uno::RuntimeException);

	extern "C" void SAL_CALL java_Mapping_acquire(uno_Mapping * pUno_mapping);

	extern "C" void SAL_CALL java_Mapping_release(uno_Mapping * pUno_mapping);

	extern "C" void SAL_CALL java_Mapping_free(uno_Mapping * pUno_mapping);

	extern "C" void SAL_CALL java_Mapping_mapInterface_from(uno_Mapping * pUno_mapping,
															void ** ppOut, void * pInterface,
															typelib_InterfaceTypeDescription * pInterfaceTypeDescr);
	
	extern "C" void SAL_CALL java_Mapping_mapInterface_to(uno_Mapping * pUno_mapping,
														  void ** ppOut, void * pInterface,
														  typelib_InterfaceTypeDescription * pInterfaceTypeDescr);
}

#endif
