/*************************************************************************
 *
 *  $RCSfile: testmarshal.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:28:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>
#include <stdio.h>

#include <osl/diagnose.h>
#include <osl/time.h>
#include <uno/data.h>

#include <cppuhelper/servicefactory.hxx>

#include <bridges/remote/marshal.hxx>
#include <bridges/remote/unmarshal.hxx>

#include <com/sun/star/corba/giop/RequestHeader_1_2.hpp>
#include <com/sun/star/corba/giop/MsgType_1_1.hpp>
#include <com/sun/star/corba/CorbaString8.hpp>
#include <com/sun/star/corba/giop/TargetAddress.hpp>
#include <com/sun/star/corba/giop/TargetAddressGroup.hpp>

#include <com/sun/star/lang/XComponent.hpp>

#include <com/sun/star/beans/Property.hpp>

#include <typelib/typedescription.hxx>

#include "urp_bridgeimpl.hxx"
#include "urp_unmarshal.hxx"

using namespace ::com::sun::star::beans;
using namespace ::rtl;
using namespace ::cppu;
using namespace ::bridges_remote;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::corba::giop;
using namespace ::com::sun::star::corba;

class TestUnmarshaler
{
public:
	virtual ~TestUnmarshaler()
		{}
	virtual void set( const Sequence < sal_Int8 > & ) = 0;
	virtual sal_Bool unpackAndDestruct( void *pDest , const ::com::sun::star::uno::Type &rType )= 0;
};

class TestMarshaler
{
public:
	virtual ~TestMarshaler()
		{}
	virtual void pack( void *pSource , const ::com::sun::star::uno::Type &rType ) = 0;
	virtual Sequence < sal_Int8 > remove() = 0;
};

template < class C >
inline void operator <<= (TestMarshaler & r,  C& value)
{
	r.pack( &value, getCppuType( &value ) );
}

template < class C >
inline sal_Bool operator >>= (TestUnmarshaler & r,  C& value)
{
	return r.unpackAndDestruct( &value, getCppuType( &value ) );
}


class UrpTestUnmarshaler : public TestUnmarshaler
{
public:
	UrpTestUnmarshaler() :
		m_bridgeImpl( 256 , 4096 ),
		m_unmarshal( &m_bridgeImpl , 0 , 0 )
		{}
	~UrpTestUnmarshaler()
		{}
public:
	void set( const Sequence < sal_Int8 > &seq )
		{
			m_unmarshal.setSize( seq.getLength() );
			memcpy( m_unmarshal.getBuffer() , seq.getConstArray(), seq.getLength() );
		}
	sal_Bool unpackAndDestruct( void *pDest , const ::com::sun::star::uno::Type &rType )
		{
			return m_unmarshal.unpackAndDestruct( pDest, rType );
		}
	
private:
	::bridges_urp::urp_BridgeImpl m_bridgeImpl;
	::bridges_urp::Unmarshal  m_unmarshal;
};

class UrpTestMarshaler : public TestMarshaler
{
public:
	UrpTestMarshaler() :
		m_bridgeImpl( 256, 4096 )
		{}
public:
	virtual void pack( void *pSource , const ::com::sun::star::uno::Type &rType )
		{
			m_bridgeImpl.m_blockMarshaler.pack( pSource , rType );
		}
	virtual Sequence < sal_Int8 > remove()
		{
			m_bridgeImpl.m_blockMarshaler.finish();
			sal_Int32 nOffset = 1;
			if( m_bridgeImpl.m_blockMarshaler.getBuffer()[0] == 0xff )
			{
				nOffset = 5;
			}
			Sequence < sal_Int8 > seq( m_bridgeImpl.m_blockMarshaler.getSize()-nOffset );
			memcpy( seq.getArray() ,
					m_bridgeImpl.m_blockMarshaler.getBuffer() +nOffset ,
					m_bridgeImpl.m_blockMarshaler.getSize() -nOffset );
			m_bridgeImpl.m_blockMarshaler.restart();
			return seq;
		}
private:
	::bridges_urp::urp_BridgeImpl m_bridgeImpl;
};


class TestFactory
{
public:
	TestMarshaler *createMarshaler( char *pName )
		{
			if( ! strcmp( pName , (char*)"urp" ) )
			{
				return new UrpTestMarshaler();
			}
			else if( ! strcmp( pName , (char*)"iiop" ) )
			{
				return 0;
			}
			return 0;
		}

	TestUnmarshaler *createUnmarshaler( char * pName )
		{
			if( ! strcmp( pName , "urp" ) )
			{
				return new UrpTestUnmarshaler;
			}
			return 0;
		}
};



template < class type >
type testAny( const type & value , TestMarshaler & marsh , TestUnmarshaler &unm )
{
	Any any;
	any <<=  value;

	marsh.pack( &any , getCppuType( &any ) );

	Sequence < sal_Int8 > seq = marsh.remove();

	unm.set( seq );
	unm.unpackAndDestruct( &any , getCppuType( &any ) );

	type valueNew;
	any >>= valueNew;

	return valueNew;
}


void performTest( TestMarshaler *pMarshal , TestUnmarshaler *pUnmarshal )
{
	TypeDescription descr1( getCppuType( (Reference< XInterface >* ) 0 ) );
	TypeDescription descr2( getCppuType( (Reference< XComponent >* ) 0 ) );
	typelib_typedescription_isAssignableFrom( descr1.get() , descr2.get() );

	printf( "%d\n" , typelib_typedescription_isAssignableFrom( descr1.get() , descr2.get() ) );
	printf( "%d\n" , typelib_typedescription_isAssignableFrom( descr2.get() , descr1.get() ) );
	

	sal_Int32 nInt32 = 5;
	sal_Int16 nInt16 = -165;
	sal_Int8 nInt8 = 2;
	sal_Bool b = sal_True;
	sal_uInt32 nuInt32 = 12930;
	float fFloat = (float)12.2;
	double fDouble = 231.21;
	OUString str ( RTL_CONSTASCII_USTRINGPARAM("this is my teststring !") );
	Sequence < sal_Int8 > seq( 5 );
	RequestHeader_1_2 hdr;
	MsgType_1_1 msgtype = MsgType_1_1_CloseConnection;

	
	CorbaString8 string8;
	string8.theString = str;
	TargetAddress targetAddress;
	iop::TaggedProfile profile;
	profile.tag = 1;
	profile.profile_data = seq;
	
	targetAddress.nDiscriminator = TargetAddressGroup::KeyAddr;
	targetAddress.object_key = seq;
	targetAddress.profile = profile;
	
	seq.getArray()[0] = 1;
	seq.getArray()[1] = 2;
	seq.getArray()[2] = 3;
	seq.getArray()[3] = 4;
	seq.getArray()[4] = 5;
	hdr.request_id = 2;
	hdr.target.nDiscriminator = 0;
	hdr.target.object_key = seq;
	hdr.operation = str;	
		
	TestMarshaler & marsh = *pMarshal;
	marsh <<= targetAddress;
	marsh <<= nInt32;
	marsh <<= nInt16;
	marsh <<= nInt8;
	marsh.pack( &b, getCppuBooleanType() );
	marsh <<= nuInt32;
	marsh <<= fFloat;
	marsh <<= fDouble;
	marsh <<= seq;
	marsh <<= hdr;
	marsh <<= str;
	marsh <<= msgtype;
	marsh <<= string8;

	Sequence < sal_Int8 > seqMarsh = marsh.remove();
	
	TestUnmarshaler & unm = *pUnmarshal;
	unm.set( seqMarsh );
	
	sal_Int32 nNewInt32;
	sal_Int16 nNewInt16;
	sal_Int8 nNewInt8;
	sal_Bool bNew;
	sal_uInt32 nuNewInt32;
	float fNewFloat;
	double fNewDouble;
	OUString strNew;
	Sequence < sal_Int8 > seqNew;
	RequestHeader_1_2 hdrNew;
	MsgType_1_1 msgtypeNew;
	CorbaString8 string8New;
	TargetAddress targetAddressNew;

	unm >>= targetAddressNew;
	unm >>= nNewInt32;
	unm >>= nNewInt16;
	unm >>= nNewInt8;
	unm.unpackAndDestruct( &bNew , getCppuBooleanType() );
	unm >>= nuNewInt32;
	unm >>= fNewFloat;
	unm >>= fNewDouble;
	unm >>= seqNew;
	unm >>= hdrNew;
	unm >>= strNew;
	unm >>= msgtypeNew;
	OSL_ASSERT( unm >>= string8New );
	{
//  		RequestHeader_1_2 request;
//  		OSL_ASSERT( ! (unm >>= request) );
//  		Property prop;
//  		OSL_ASSERT( ! ( unm >>= prop ) );
//  		//OUString aString = OUString::createFromAscii( "bla blubs" );
//  		CorbaString8 aNewString8;
//  		OSL_ASSERT( ! ( unm >>= aNewString8 ) );
	}

	OSL_ASSERT( targetAddress.nDiscriminator == targetAddressNew.nDiscriminator );
	OSL_ASSERT( targetAddress.object_key == targetAddressNew.object_key );
	OSL_ASSERT( ! (targetAddress.profile.tag == targetAddressNew.profile.tag &&
		       targetAddress.profile.profile_data == targetAddressNew.profile.profile_data ) );
	
	OSL_ASSERT( nInt32 == nNewInt32 );
	OSL_ASSERT( nInt16 == nNewInt16 );
	OSL_ASSERT( nInt8 == nNewInt8 );
	OSL_ASSERT( b == bNew );
	printf( "%0x == %0x\n" , nuInt32, nuNewInt32 );
	OSL_ASSERT( nuInt32 == nuNewInt32 );
	OSL_ASSERT( fFloat == fNewFloat );
	OSL_ASSERT( fDouble == fNewDouble );
	OSL_ASSERT( str == strNew );
	OSL_ASSERT( seq == seqNew );
	OSL_ASSERT( hdr.request_id == hdrNew.request_id);
	OSL_ASSERT( hdr.target.object_key == hdrNew.target.object_key);
	OSL_ASSERT( hdr.operation.theString == hdrNew.operation.theString);
	OSL_ASSERT( msgtype == msgtypeNew );
	OSL_ASSERT( string8.theString == string8New.theString);

	OSL_ASSERT( nInt8 == testAny( nInt8 , marsh , unm ) );
	OSL_ASSERT( nInt32 == testAny( nInt32 , marsh, unm ) );
	OSL_ASSERT( nInt16 == testAny( nInt16 , marsh , unm ) );

	OSL_ASSERT( nuInt32 == testAny( nuInt32, marsh , unm ) );
	OSL_ASSERT( fFloat == testAny( fFloat, marsh, unm  ) );
	OSL_ASSERT( str == testAny( str , marsh, unm ) );
	OSL_ASSERT( seq == testAny( seq , marsh , unm ) );

	hdrNew = testAny( hdr , marsh , unm );
	OSL_ASSERT( hdr.request_id == hdrNew.request_id);
	OSL_ASSERT( hdr.target.object_key == hdrNew.target.object_key);
	OSL_ASSERT( hdr.operation.theString == hdrNew.operation.theString );

	OSL_ASSERT( msgtype == testAny( msgtype , marsh , unm ) );
	string8New = testAny( string8 , marsh, unm );
	OSL_ASSERT( string8New.theString == string8New.theString );


}


void main( char *argv[])
{	
	Reference< XMultiServiceFactory > rSMgr = createRegistryServiceFactory(
		OUString( RTL_CONSTASCII_USTRINGPARAM ("client.rdb")) );

	TestFactory factory;

	TestMarshaler *pMarshal = factory.createMarshaler( "urp" );
	TestUnmarshaler *pUnmarshal = factory.createUnmarshaler( "urp" );

	performTest( pMarshal , pUnmarshal );

	Reference< XComponent > rComp( rSMgr , UNO_QUERY );
	rComp->dispose();
}
