/*************************************************************************
 *
 *  $RCSfile: continfo.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/03/01 15:25:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 ChaosPropertySetInfo::Notify -> CNT_ACTION_DELETED
  - remove propertyset from propertyset registry

 ChaosPropertySetInfo::getProperties
  - Performance!

 *************************************************************************/

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPROPERTYSETREGISTRY_HPP_
#include <com/sun/star/ucb/XPropertySetRegistry.hpp>
#endif

#ifndef _CNTPOOL_HXX
#include "cntpool.hxx"
#endif

#include "continfo.hxx"

#ifndef _CONTENT_HXX
#include "content.hxx"
#endif
#ifndef _PROVIDER_HXX
#include "provider.hxx"
#endif

using namespace chaos;
using namespace rtl;
using namespace vos;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::ucb;

//============================================================================
//
// Table containing command info for commands introduced by UCB
//
//============================================================================

static const Type& void_getCppuType()
{
	return getCppuVoidType();
}

static const Type& sequence_Property_getCppuType()
{
	return getCppuType( static_cast< Sequence< Property > * >( 0 ) );
}

static const Type& sequence_PropertyValue_getCppuType()
{
	return getCppuType( static_cast< Sequence< PropertyValue > * >( 0 ) );
}

static CntItemMapEntry __READONLY_DATA aUcbCommandTable_Impl[] =
{
	{ "getCommandInfo",		-1,	0,	&void_getCppuType },
	{ "getPropertySetInfo",	-1,	0,	&void_getCppuType },
	{ "getPropertyValues",	-1,	0,	&sequence_Property_getCppuType },
	{ "setPropertyValues",	-1,	0,	&sequence_PropertyValue_getCppuType },
	{ 0, 0, 0, 0 }
};

static const CntItemMap aUcbCommandsMap_Impl( &aUcbCommandTable_Impl[ 0 ] );

//=========================================================================
//=========================================================================
//
// class Properties_Impl.
//
//=========================================================================
//=========================================================================

class Properties_Impl
{
	Sequence< Property >* m_pProps;
	const CntItemMap* 	  m_pData;

public:
	Properties_Impl( const CntItemMap* pData )
	: m_pProps( NULL ), m_pData( pData ) {}
	~Properties_Impl() { delete m_pProps; }

	const Sequence< Property >& getProperties();
};

//=========================================================================
//=========================================================================
//
// class Commands_Impl.
//
//=========================================================================
//=========================================================================

class Commands_Impl
{
	Sequence< CommandInfo >* m_pCommands;
	const CntItemMap* 		 m_pData;

public:
	Commands_Impl( const CntItemMap* pData )
	: m_pCommands( NULL ), m_pData( pData ) {}
	~Commands_Impl() { delete m_pCommands; }

	const Sequence< CommandInfo >& getCommands();
};

//=========================================================================
//=========================================================================
//
// Properties_Impl Implementation.
//
//=========================================================================
//=========================================================================

const Sequence< Property >& Properties_Impl::getProperties()
{
	if ( !m_pProps )
	{
		ULONG nCount  = m_pData->Count();
		ULONG nArrPos = 0;

		m_pProps = new Sequence< Property >( nCount );
		Property* pProps = m_pProps->getArray();

		for ( ULONG n = 0; n < nCount; ++n )
		{
			const CntItemMapEntry* pEntry = m_pData->GetObject( n );
			if ( pEntry->IsProperty() )
			{
				Property& rProp = pProps[ nArrPos ];

				rProp.Name		 = UniString::CreateFromAscii( pEntry->pName );
				rProp.Handle     = pEntry->nWhich;
				rProp.Type       = pEntry->pGetCppuType();
				rProp.Attributes = pEntry->nAttributes;

				++nArrPos;
			}
		}

		m_pProps->realloc( nArrPos );
	}

	return *m_pProps;
}

//=========================================================================
//=========================================================================
//
// Commands_Impl Implementation.
//
//=========================================================================
//=========================================================================

const Sequence< CommandInfo >& Commands_Impl::getCommands()
{
	if ( !m_pCommands )
	{
		ULONG nCount  = m_pData->Count();
		ULONG nArrPos = 0;

		m_pCommands = new Sequence< CommandInfo >( nCount );
		CommandInfo* pCommands = m_pCommands->getArray();

		for ( ULONG n = 0; n < nCount; ++n )
		{
			const CntItemMapEntry* pEntry = m_pData->GetObject( n );
			if ( pEntry->IsFunction() )
			{
				CommandInfo& rCommand = pCommands[ nArrPos ];

				rCommand.Name    = OUString::createFromAscii( pEntry->pName );
				rCommand.Handle  = pEntry->nWhich;
				rCommand.ArgType = pEntry->pGetCppuType();

				++nArrPos;
			}
		}

		m_pCommands->realloc( nArrPos );
	}

	return *m_pCommands;
}

//============================================================================
//
// Global objects for property and command infos.
//
//============================================================================

// All CHAOS properties
static Properties_Impl  __aProps( CNT_ITEMMAP() );

// All CHAOS commands
static Commands_Impl    __aCommands( CNT_ITEMMAP() );

// All UCB commands
static Commands_Impl 	__aUcbCommands( &aUcbCommandsMap_Impl );

//=========================================================================
//=========================================================================
//
// ChaosPropertySetInfo Implementation.
//
//=========================================================================
//=========================================================================

ChaosPropertySetInfo::ChaosPropertySetInfo(
						const Reference< XMultiServiceFactory >& rxSMgr,
						ChaosContentProvider* pProvider,
						CntAnchor* pAnchor )
: m_xSMgr( rxSMgr ),
  m_pChaosProps( NULL ),
  m_pUcbProps( NULL ),
  m_xAnchor( pAnchor ),
  m_aRanges( pAnchor->REAL_RANGES() ),
  m_pProvider( pProvider )
{
	const String aViewURL( pAnchor->GetViewURL( TRUE ) );
	m_bHasViewData = ( aViewURL.Len() > 0 );
	StartListening( *pAnchor );
}

//=========================================================================
// virtual
ChaosPropertySetInfo::~ChaosPropertySetInfo()
{
	if ( m_xAnchor.Is() )
		EndListening( *m_xAnchor );

	delete m_pChaosProps;
	delete m_pUcbProps;
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_2( ChaosPropertySetInfo,
				   XTypeProvider,
				   XPropertySetInfo );

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_IMPL_2( ChaosPropertySetInfo,
	 		   		  XTypeProvider,
	 		   		  XPropertySetInfo );

//=========================================================================
//
// XPropertySetInfo methods.
//
//=========================================================================

// virtual
Sequence< Property > SAL_CALL ChaosPropertySetInfo::getProperties()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	// Get propertyset info from CHAOS anchor
	getChaosProperties();

	// Get dynamic propertyset info.
	getUcbProperties();

	sal_uInt32 nDynProps = m_pUcbProps->getLength();
	if ( nDynProps )
	{
		sal_uInt32 nChaosProps = m_pChaosProps->getLength();

		Sequence< Property > aProps( *m_pChaosProps );
		aProps.realloc( nDynProps + nChaosProps );

		Property* pProps = aProps.getArray();
		const Property* pDynProps = m_pUcbProps->getConstArray();

		for ( sal_uInt32 n = 0, m = nChaosProps; n < nDynProps; ++n, ++m )
			pProps[ m ] = pDynProps[ n ];

		return aProps;
	}

	// Only static properties present.
	return *m_pChaosProps;
}

//=========================================================================
// virtual
Property SAL_CALL ChaosPropertySetInfo::getPropertyByName(
													const OUString& aName )
	throw( UnknownPropertyException, RuntimeException )
{
	Property aProp;
	if ( queryProperty( aName, aProp ) )
		return aProp;

	throw UnknownPropertyException();
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ChaosPropertySetInfo::hasPropertyByName(
													const OUString& Name )
	throw( RuntimeException )
{
	Property aProp;
	return queryProperty( Name, aProp );
}

//=========================================================================
//
// SfxListener methods.
//
//=========================================================================

// virtual
void ChaosPropertySetInfo::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	//////////////////////////////////////////////////////////////////////
	// CntItemStateChangedHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( CntItemStateChangedHint ) )
	{
		const CntItemStateChangedHint* pHint =
								(const CntItemStateChangedHint*)&rHint;
		CntItemStateAction eAction = pHint->GetAction();
		switch ( eAction )
		{
			case CNT_ITEM_CLEARED:
			case CNT_ITEM_DISABLED:
				if ( m_pChaosProps )
				{
					const CntItemMapEntry* pEntry =
							CNT_ITEMMAP()->Which2Prop( pHint->GetWhich() );
					if ( pEntry && pEntry->IsProperty() )
					{
						// Stored property info is invalid!
						vos::OGuard aGuard( m_aMutex );
						resetChaosPropertyInfo();
					}
				}
				break;

			default:
				break;
		}
	}

	//////////////////////////////////////////////////////////////////////
	// CntAnchorHint handling.
	//////////////////////////////////////////////////////////////////////

    else if ( rHint.ISA( CntAnchorHint ) )
    {
        const CntAnchorHint* pAnchorHint = (const CntAnchorHint*)&rHint;
		const CntAction eAction = pAnchorHint->GetAction();
		switch ( eAction )
		{
			case CNT_ACTION_DELETED:
				// @@@@@ remove persistent property set from storage.
			case CNT_ACTION_REMOVED:
			{
				vos::OGuard aGuard( m_aMutex );

				if ( m_xAnchor.Is() )
				{
					EndListening( *m_xAnchor );
					m_xAnchor.Clear();
				}
				resetChaosPropertyInfo();
				m_bHasViewData = sal_False;
				break;
			}

			case CNT_ACTION_EXCHANGED:
			{
				// Stored property info is invalid!
				vos::OGuard aGuard( m_aMutex );

				resetChaosPropertyInfo();
				resetUcbPropertyInfo();

				if ( m_xAnchor.Is() )
				{
					const String aViewURL( m_xAnchor->GetViewURL( TRUE ) );
					m_bHasViewData = ( aViewURL.Len() > 0 );
				}
				else
					m_bHasViewData = sal_False;

				break;
			}

			default:
				break;
		}
	}
}

//=========================================================================
//
// Private methods.
//
//=========================================================================

sal_Bool ChaosPropertySetInfo::isHandleValid( sal_uInt16 nHandle ) const
{
	if ( m_aRanges.Contains( nHandle ) )
	{
		if ( m_xAnchor.Is() )
		{
			if ( m_xAnchor->GetItemState( nHandle ) > SFX_ITEM_DISABLED )
			{
#if 1
				// Filter View Properties.

				// Check for special id's.
				switch ( nHandle )
				{
					case WID_TITLE:
						// Is always available, though it is a view prop.
						return sal_True;

					default:
						break;
				}

				if ( m_xAnchor->IsItemFlag(	nHandle, CNT_ITEM_AUTO_VIEWPROP ) )
				{
					if ( m_bHasViewData )
						return sal_True;
				}
				else
					return sal_True;
#else
				return sal_True;
#endif
			}
		}
	}
	return sal_False;
}

//=========================================================================
sal_Bool ChaosPropertySetInfo::isEntryValid(
				const CntItemMapEntry* pEntry, sal_Bool bCheckHandle ) const
{
	if ( pEntry && pEntry->IsProperty() )
	{
		if ( bCheckHandle )
			return isHandleValid( pEntry->nWhich );
		else
			return sal_True;
	}
	return sal_False;
}

//=========================================================================
const Sequence< Property >& ChaosPropertySetInfo::getChaosProperties()
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pChaosProps )
	{
		// Assemble properties ...
		const Sequence< Property >& rProps = __aProps.getProperties();
		const Property* pAllProps = rProps.getConstArray();

		ULONG nCount  = rProps.getLength();
		ULONG nArrPos = 0;

		// Note: +1, because of additional property "MediaType".
		m_pChaosProps = new Sequence< Property >( nCount + 1 );
		Property* pMyProps = m_pChaosProps->getArray();

		for ( ULONG n = 0; n < nCount; ++n )
		{
			const Property& rProp = pAllProps[ n ];
			if ( isHandleValid( (USHORT)rProp.Handle ) )
			{
				pMyProps[ nArrPos ] = rProp;
				++nArrPos;
			}
		}

		// Append "MediaType" ( Supported by all ChaosContents ).
		Property aMediaType( OUString::createFromAscii( "MediaType" ),
							 -1, // no handle
							 getCppuType( static_cast< OUString * >( 0 ) ),
							 PropertyAttribute::BOUND
							 	/*| PropertyAttribute::READONLY*/ );
		pMyProps[ nArrPos ] = aMediaType;
		++nArrPos;

		m_pChaosProps->realloc( nArrPos );
	}

	return *m_pChaosProps;
}

//=========================================================================
const Sequence< Property >& ChaosPropertySetInfo::getUcbProperties()
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pUcbProps )
	{
		// Query dynamic properties ...
		Reference< XPropertySetRegistry > xReg(
							m_pProvider->getPropertySetRegistry() );
		if ( xReg.is() )
		{
			const String aViewURL( m_xAnchor->GetViewURL( FALSE ) );

			// Open property set, if exists.
		    Reference< XPersistentPropertySet > xSet(
								xReg->openPropertySet( aViewURL, sal_False ) );
			if ( xSet.is() )
			{
				// Get property set info.
				Reference< XPropertySetInfo > xInfo(
								xSet->getPropertySetInfo() );
				if ( xInfo.is() )
				{
					const Sequence< Property >& rProps = xInfo->getProperties();
					m_pUcbProps = new Sequence< Property >( rProps );
				}
			}
		}

		if ( !m_pUcbProps )
			m_pUcbProps = new Sequence< Property >();
	}

	return *m_pUcbProps;
}

//=========================================================================
sal_Bool ChaosPropertySetInfo::queryProperty(
								const OUString& rName, Property& rProp )
{
	vos::OGuard aGuard( m_aMutex );

	// Check static properties.
	getChaosProperties();
	const Property* pProps = m_pChaosProps->getConstArray();
	sal_uInt32 nCount = m_pChaosProps->getLength();
	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		const Property& rCurrProp = pProps[ n ];
		if ( rCurrProp.Name == rName )
		{
			rProp = rCurrProp;
			return sal_True;
		}
	}

	// Check dynamic properties.
	getUcbProperties();
	pProps = m_pUcbProps->getConstArray();
	nCount = m_pUcbProps->getLength();
	for ( sal_uInt32 i = 0; i < nCount; ++i )
	{
		const Property& rCurrProp = pProps[ i ];
		if ( rCurrProp.Name == rName )
		{
			rProp = rCurrProp;
			return sal_True;
		}
	}

	return sal_False;
}

//=========================================================================
//=========================================================================
//
// ChaosCommandInfo Implementation.
//
//=========================================================================
//=========================================================================

ChaosCommandInfo::ChaosCommandInfo(
		const Reference< XMultiServiceFactory >& rxSMgr, CntAnchor* pAnchor )
: m_xSMgr( rxSMgr ),
  m_pChaosCommands( NULL ),
  m_pUcbCommands( NULL ),
  m_xAnchor( pAnchor ),
  m_aRanges( pAnchor->REAL_RANGES() )
{
	const String aViewURL( pAnchor->GetViewURL( TRUE ) );
	m_bHasViewData = ( aViewURL.Len() > 0 );
	StartListening( *pAnchor );
}

//=========================================================================
// virtual
ChaosCommandInfo::~ChaosCommandInfo()
{
	if ( m_xAnchor.Is() )
		EndListening( *m_xAnchor );

	delete m_pChaosCommands;
	delete m_pUcbCommands;
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_2( ChaosCommandInfo,
				   XTypeProvider,
				   XCommandInfo );

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_IMPL_2( ChaosCommandInfo,
			   		  XTypeProvider,
			   		  XCommandInfo );

//=========================================================================
//
// XCommandInfo methods.
//
//=========================================================================

// virtual
Sequence< CommandInfo > SAL_CALL ChaosCommandInfo::getCommands()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	// Get command info from CHAOS anchor
	getChaosCommands();

	// Get command info for commands introduced by a UCB content.
	getUcbCommands();

	sal_uInt32 nUcbCommands = m_pUcbCommands->getLength();
	if ( nUcbCommands )
	{
		sal_uInt32 nChaosCommands = m_pChaosCommands->getLength();

		Sequence< CommandInfo > aCommands( *m_pChaosCommands );
		aCommands.realloc( nUcbCommands + nChaosCommands );

		CommandInfo* pCommands = aCommands.getArray();
		const CommandInfo* pUcbCommands = m_pUcbCommands->getConstArray();

		for ( sal_uInt32 n = 0, m = nChaosCommands; n < nUcbCommands; ++n, ++m )
			pCommands[ m ] = pUcbCommands[ n ];

		return aCommands;
	}

	// Only CHAOS commands present.
	return *m_pChaosCommands;
}

//=========================================================================
// virtual
CommandInfo SAL_CALL ChaosCommandInfo::getCommandInfoByName(
													const OUString& Name )
	throw( UnsupportedCommandException, RuntimeException )
{
	CommandInfo aInfo;
	if ( queryCommand( Name, aInfo ) )
		return aInfo;

	throw UnsupportedCommandException();
}

//=========================================================================
// virtual
CommandInfo SAL_CALL ChaosCommandInfo::getCommandInfoByHandle(
													sal_Int32 Handle )
	throw( UnsupportedCommandException, RuntimeException )
{
	CommandInfo aInfo;
	if ( queryCommand( Handle, aInfo ) )
		return aInfo;

	throw UnsupportedCommandException();
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ChaosCommandInfo::hasCommandByName( const OUString& Name )
	throw( RuntimeException )
{
	CommandInfo aInfo;
	return queryCommand( Name, aInfo );
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ChaosCommandInfo::hasCommandByHandle( sal_Int32 Handle )
	throw( RuntimeException )
{
	CommandInfo aInfo;
	return queryCommand( Handle, aInfo );
}

//=========================================================================
//
// SfxListener methods.
//
//=========================================================================

// virtual
void ChaosCommandInfo::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	//////////////////////////////////////////////////////////////////////
	// CntItemStateChangedHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( CntItemStateChangedHint ) )
	{
		const CntItemStateChangedHint* pHint =
								(const CntItemStateChangedHint*)&rHint;
		CntItemStateAction eAction = pHint->GetAction();
		switch ( eAction )
		{
			case CNT_ITEM_CLEARED:
			case CNT_ITEM_DISABLED:
				if ( m_pChaosCommands )
				{
					const CntItemMapEntry* pEntry =
							CNT_ITEMMAP()->Which2Prop( pHint->GetWhich() );
					if ( pEntry && pEntry->IsFunction() )
					{
						// Stored command info is invalid!
						vos::OGuard aGuard( m_aMutex );
						resetChaosCommandInfo();
					}
				}
				break;

			default:
				break;
		}
	}

	//////////////////////////////////////////////////////////////////////
	// CntAnchorHint handling.
	//////////////////////////////////////////////////////////////////////

    else if ( rHint.ISA( CntAnchorHint ) )
    {
        const CntAnchorHint* pAnchorHint = (const CntAnchorHint*)&rHint;
		const CntAction eAction = pAnchorHint->GetAction();
		switch ( eAction )
		{
			case CNT_ACTION_DELETED:
			case CNT_ACTION_REMOVED:
			{
				vos::OGuard aGuard( m_aMutex );

				if ( m_xAnchor.Is() )
				{
					EndListening( *m_xAnchor );
					m_xAnchor.Clear();
				}
				// Stored command info is invalid!
				resetChaosCommandInfo();
				m_bHasViewData = sal_False;
				break;
			}

			case CNT_ACTION_EXCHANGED:
			{
				// Stored command info is invalid!
				vos::OGuard aGuard( m_aMutex );

				resetChaosCommandInfo();
// ucb commands are common to all contents at the moment.
//				resetUcbCommandInfo();

				if ( m_xAnchor.Is() )
				{
					const String aViewURL( m_xAnchor->GetViewURL( TRUE ) );
					m_bHasViewData = ( aViewURL.Len() > 0 );
				}
				else
					m_bHasViewData = sal_False;

				break;
			}

			default:
				break;
		}
	}
}

//=========================================================================
//
// Private methods.
//
//=========================================================================

sal_Bool ChaosCommandInfo::isHandleValid( sal_uInt16 nHandle ) const
{
	if ( m_aRanges.Contains( nHandle ) )
	{
		if ( m_xAnchor.Is() )
		{
			if ( m_xAnchor->GetItemState( nHandle ) > SFX_ITEM_DISABLED )
			{
#if 1
				// Filter View Properties.

				if ( m_xAnchor->IsItemFlag(	nHandle, CNT_ITEM_AUTO_VIEWPROP ) )
				{
					if ( m_bHasViewData )
						return sal_True;
				}
				else
					return sal_True;
#else
				return sal_True;
#endif
			}
		}
	}
	return sal_False;
}

//=========================================================================
sal_Bool ChaosCommandInfo::isEntryValid(
				const CntItemMapEntry* pEntry, sal_Bool bCheckHandle ) const
{
	if ( pEntry &&  pEntry->IsFunction() )
	{
		if ( bCheckHandle )
			return isHandleValid( pEntry->nWhich );
		else
			return sal_True;
	}
	return sal_False;
}

//=========================================================================
const Sequence< CommandInfo >& ChaosCommandInfo::getChaosCommands()
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pChaosCommands )
	{
		// Assemble commands ...
		const Sequence< CommandInfo >& rCommands = __aCommands.getCommands();
		const CommandInfo* pAllCommands = rCommands.getConstArray();
		ULONG nCount  = rCommands.getLength();
		ULONG nArrPos = 0;

		m_pChaosCommands = new Sequence< CommandInfo >( nCount );
		CommandInfo* pMyCommands = m_pChaosCommands->getArray();

		for ( ULONG n = 0; n < nCount; ++n )
		{
			const CommandInfo& rCommand = pAllCommands[ n ];
			if ( isHandleValid( (USHORT)rCommand.Handle ) )
			{
				pMyCommands[ nArrPos ] = rCommand;
				++nArrPos;
			}
		}

		m_pChaosCommands->realloc( nArrPos );
	}

	return *m_pChaosCommands;
}

//=========================================================================
const Sequence< CommandInfo >& ChaosCommandInfo::getUcbCommands()
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pUcbCommands )
	{
		m_pUcbCommands
			= new Sequence< CommandInfo >( __aUcbCommands.getCommands() );
	}

	return *m_pUcbCommands;
}

//=========================================================================
sal_Bool ChaosCommandInfo::queryCommand(
							const OUString& rName, CommandInfo& rCommand )
{
	vos::OGuard aGuard( m_aMutex );

	// Check CHAOS commands.
	const CntItemMapEntry* pEntry =	CNT_ITEMMAP()->Prop2Which( rName );
	if ( isEntryValid( pEntry, sal_True ) )
	{
		rCommand.Name 	 = rName;
		rCommand.Handle  = pEntry->nWhich;
		rCommand.ArgType = pEntry->pGetCppuType();

		return sal_True;
	}

	// Check UCB commands.
	getUcbCommands();
	const CommandInfo* pUcbCommands = m_pUcbCommands->getConstArray();
	sal_uInt32 nCount = m_pUcbCommands->getLength();
	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		const CommandInfo& rCurrCmd = pUcbCommands[ n ];
		if ( rCurrCmd.Name == rName )
		{
			rCommand = rCurrCmd;
			return sal_True;
		}
	}

	return sal_False;
}

//=========================================================================
sal_Bool ChaosCommandInfo::queryCommand(
							sal_Int32 nHandle, CommandInfo& rCommand )
{
	vos::OGuard aGuard( m_aMutex );

	// Check CHAOS commands.
	const CntItemMapEntry* pEntry =	CNT_ITEMMAP()->Which2Prop( nHandle );
	if ( isEntryValid( pEntry, sal_True ) )
	{
		rCommand.Name    = OUString::createFromAscii( pEntry->pName );
		rCommand.Handle  = nHandle;
		rCommand.ArgType = pEntry->pGetCppuType();

		return sal_True;
	}

	// Check UCB commands.
	getUcbCommands();
	const CommandInfo* pUcbCommands = m_pUcbCommands->getConstArray();
	sal_uInt32 nCount = m_pUcbCommands->getLength();
	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		const CommandInfo& rCurrCmd = pUcbCommands[ n ];
		if ( rCurrCmd.Handle == nHandle )
		{
			rCommand = rCurrCmd;
			return sal_True;
		}
	}

	return sal_False;
}

