/*************************************************************************
 *
 *  $RCSfile: rsultset.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: sb $ $Date: 2001/11/23 13:25:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Kai Sommerfeld ( kso@sun.com )
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

	- rowUpdated, rowInserted, rowDeleted not implemented.

 *************************************************************************/

#include <vector>
#include <hash_map>

#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDENVIRONMENT_HPP_
#include <com/sun/star/ucb/XCommandEnvironment.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include <com/sun/star/ucb/OpenCommandArgument2.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_RESULTSETEXCEPTION_HPP_
#include <com/sun/star/ucb/ResultSetException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_SEARCHCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/SearchCommandArgument.hpp>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _UCBHELPER_RESULTSETMETADATA_HXX
#include <ucbhelper/resultsetmetadata.hxx>
#endif
#ifndef _UCBHELPER_PROPERTYVALUESET_HXX
#include <ucbhelper/propertyvalueset.hxx>
#endif

#include "rsultset.hxx"

#ifndef _TASKS_HXX
#include "tasks.hxx"
#endif
#ifndef CHAOS_TASKBASE_HXX
#include "taskbase.hxx"
#endif
#ifndef _CONTENT_HXX
#include "content.hxx"
#endif
#ifndef _CNTPOOL_HXX
#include "cntpool.hxx"
#endif

using namespace com::sun::star::beans;
using namespace com::sun::star::container;
using namespace com::sun::star::io;
using namespace com::sun::star::lang;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::task;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using namespace com::sun::star::util;
using namespace cppu;
using namespace rtl;

using namespace chaos;

//=========================================================================

//  The mutex to synchronize access to containers.
static osl::Mutex& getContainerMutex()
{
	static osl::Mutex* pMutex = NULL;
	if( !pMutex )
	{
		osl::Guard< osl::Mutex > aGuard( osl::Mutex::getGlobalMutex() );
		if( !pMutex )
		{
			static osl::Mutex aMutex;
			pMutex = &aMutex;
		}
	}

	return *pMutex;
}

//=========================================================================

static const com::sun::star::uno::Type& sal_uInt32_getCppuType()
{
	// ! uInt -> Int, because of Java !!!
	return getCppuType( static_cast< const sal_Int32 * >( 0 ) );
}

static const com::sun::star::uno::Type& sal_Bool_getCppuType()
{
	return getCppuBooleanType();
}

static CntItemMapEntry __READONLY_DATA aPropertyMap_Impl[] =
{
	{ "IsRowCountFinal",
	  1000,
	  PropertyAttribute::BOUND | PropertyAttribute::READONLY,
	  &sal_Bool_getCppuType
	},
	{ "RowCount",
	  1001,
	  PropertyAttribute::BOUND | PropertyAttribute::READONLY,
	  &sal_uInt32_getCppuType
	},
	{ 0,
	  0,
	  0,
	  0
	}
};

// Properties:
static const CntItemMap aItemMap_Impl( &aPropertyMap_Impl[ 0 ] );

namespace chaos {

//=========================================================================
//
// CommandTaskThread_Impl.
//
//=========================================================================

class CommandTaskThread_Impl : public ChaosCommandTask,
							   public vos::OThread
{
	TaskClient_Impl* m_pClient;

protected:
	// OThread : Working method.
	virtual void SAL_CALL run();

public:
	void* operator new(size_t n) { return rtl_allocateMemory(n); }
	void operator delete(void* p) { rtl_freeMemory(p); }
	CommandTaskThread_Impl(
			const Reference< XMultiServiceFactory >& rxSMgr,
			TaskClient_Impl* pClient,
			ChaosContent* pOwner,
			const Command& rCommand,
			ResultAcceptor* pAcceptor,
			const Reference< XCommandEnvironment >& rxEnv );
	virtual ~CommandTaskThread_Impl();
};

//=========================================================================
//
// PropertyChangeListenerContainer_Impl.
//
//=========================================================================

struct equalStr_Impl
{
	bool operator()( const OUString& s1, const OUString& s2 ) const
  	{
		return !!( s1 == s2 );
	}
};

struct hashStr_Impl
{
	size_t operator()( const OUString& rName ) const
	{
		return rName.hashCode();
	}
};

typedef OMultiTypeInterfaceContainerHelperVar
<
	OUString,
	hashStr_Impl,
	equalStr_Impl
> PropertyChangeListenerContainer_Impl;

//=========================================================================
//
// class PropertyChangeListeners_Impl
//
//=========================================================================

class PropertyChangeListeners_Impl : public PropertyChangeListenerContainer_Impl
{
public:
	PropertyChangeListeners_Impl()
	: PropertyChangeListenerContainer_Impl( getContainerMutex() ) {}
};

//=========================================================================
//
// PropertyValues_Impl.
//
//=========================================================================

struct equalLong_Impl
{
	bool operator()( const sal_uInt32& rn1, const sal_uInt32& rn2 ) const
	{
		return ( rn1 == rn2 );
	}
};

struct hashLong_Impl
{
	size_t operator()( const sal_uInt32& rn ) const
	{
		return (size_t)rn;
	}
};

typedef std::hash_map
<
	sal_uInt32,
	Reference< XRow >,
	hashLong_Impl,
	equalLong_Impl
>
PropertyValues_Impl;

//=========================================================================
//
// TaskClient_Impl.
//
//=========================================================================

typedef std::vector< Any > ResultList_Impl;

class TaskClient_Impl : public cppu::OWeakObject,
				   		public XCommandEnvironment,
						public XInteractionHandler,
				   		public ResultAcceptor,
				   		public ContentTaskStatusListener
{
	enum TaskState { CREATED, RUNNING, FINISHED };

	Reference< XMultiServiceFactory >	m_xSMgr;
	vos::OMutex							m_aMutex;
	vos::OCondition						m_aNewResult;
	vos::OCondition						m_aFinished;
	vos::OCondition             		m_aInteracted;
	ResultList_Impl						m_aResults;
	PropertyValues_Impl					m_aPropValues;
	Sequence< Property > 				m_aProps;
	Reference< XCommandEnvironment >	m_xEnv;
	Reference< XInteractionRequest > 	m_xInteractionRequest;
	TaskState							m_eTaskState;
	CommandTaskThread_Impl*				m_pTask;
	ResultSet*							m_pOwner;
	PropertyChangeListeners_Impl*    	m_pPropertyChangeListeners;
	Any 								m_aException;
	sal_Bool							m_bThrowException;

private:
	void propertyChanged( const PropertyChangeEvent& rEvt );
	void done();

public:
	TaskClient_Impl( const Reference< XMultiServiceFactory >& rxSMgr,
					 ResultSet* pOwner,
					 ChaosContent* pContent,
					 const Command& rCommand,
					 const Reference< XCommandEnvironment >& Env );
	virtual ~TaskClient_Impl();

	// XInterface
	XINTERFACE_DECL()

 	// XCommandEnvironment
    virtual Reference< XInteractionHandler > SAL_CALL
	getInteractionHandler()
		throw( RuntimeException );
    virtual Reference< XProgressHandler > SAL_CALL
	getProgressHandler()
		throw( RuntimeException );

	// XInteractionHandler
    virtual void SAL_CALL
	handle( const Reference< XInteractionRequest >& Request )
		throw( RuntimeException );

	// ContentTaskStatusListener
    virtual void contentTaskStatusChange( const ContentTaskStatus& rOld,
										  const ContentTaskStatus& rNew );

	// ResultAcceptor
    virtual sal_Bool usePartialResultChannel();
    virtual void partialResult( const Any& Result );
    virtual void completeResult( const Any& Result );

	// Non-interface nethods

	const Sequence< Property >& getProperties() const { return m_aProps; }

	const Any& queryResult( sal_uInt32 nIndex );

	sal_Bool hasResult( sal_uInt32 nIndex )
			 { return queryResult( nIndex ).hasValue(); }

	sal_uInt32 totalCount();
	sal_uInt32 currentCount() const { return m_aResults.size(); }
	sal_Bool   isCountFinal() const { return ( m_eTaskState == FINISHED ); }

	Reference< XRow > queryPropertyValues  ( sal_uInt32 nIndex );
	void			  releasePropertyValues( sal_uInt32 nIndex );

	void close();

	void setException( const com::sun::star::uno::Exception& rException );
	void validate();

    void
	addPropertyChangeListener( const OUString& aPropertyName,
							   const Reference<
						   			XPropertyChangeListener >& xListener );
    void
	removePropertyChangeListener( const OUString& aPropertyName,
								  const Reference<
							  		XPropertyChangeListener >& aListener );

	inline Command const & accessCommand() const
	{ return m_pTask->accessCommand(); }
};

}

//=========================================================================
//
// PropertySetInfo_Impl
//
//=========================================================================

class PropertySetInfo_Impl : public OWeakObject,
							 public XTypeProvider,
							 public XPropertySetInfo
{
	Reference< XMultiServiceFactory > m_xSMgr;
	Sequence< Property >* 			  m_pProps;

private:
	sal_Bool queryProperty(	const rtl::OUString& aName, Property& rProp );

public:
	PropertySetInfo_Impl( const Reference< XMultiServiceFactory >& rxSMgr,
						  const CntItemMap& rProps );
	virtual ~PropertySetInfo_Impl();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

	// XPropertySetInfo
    virtual Sequence< Property > SAL_CALL getProperties()
		throw( RuntimeException );
    virtual Property SAL_CALL getPropertyByName( const rtl::OUString& aName )
		throw( UnknownPropertyException, RuntimeException );
    virtual sal_Bool SAL_CALL hasPropertyByName( const rtl::OUString& Name )
		throw( RuntimeException );
};

//=========================================================================
//=========================================================================
//
// ResultSet Implementation.
//
//=========================================================================
//=========================================================================

ResultSet::ResultSet( const Reference< XMultiServiceFactory >& rxSMgr,
					  ChaosContent* pOwner,
					  const Command& rCommand,
					  const Reference< XCommandEnvironment >& Environment )
: m_xSMgr( rxSMgr ),
  m_pDisposeEventListeners( NULL ),
  m_nPos( 0 ), // Position is one-based. Zero means: before first element.
  m_bPossiblyTheLastValueWasNull( sal_False ),
  m_bAfterLast( sal_False )
{
  	m_pClient
		= new TaskClient_Impl( rxSMgr, this, pOwner, rCommand, Environment );
  	m_pClient->acquire();
}

//=========================================================================
// virtual
ResultSet::~ResultSet()
{
	delete m_pDisposeEventListeners;
	m_pClient->release();
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_9( ResultSet,
				   XTypeProvider,
				   XServiceInfo,
				   XComponent,
				   XContentAccess,
				   XResultSet,
				   XResultSetMetaDataSupplier,
				   XRow,
				   XCloseable,
				   XPropertySet );

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_IMPL_9( ResultSet,
					  XTypeProvider,
				   	  XServiceInfo,
					  XComponent,
					  XContentAccess,
					  XResultSet,
					  XResultSetMetaDataSupplier,
					  XRow,
					  XCloseable,
					  XPropertySet );

//=========================================================================
//
// XServiceInfo methods.
//
//=========================================================================

XSERVICEINFO_NOFACTORY_IMPL_1( ResultSet,
					 		   OUString::createFromAscii(
								"com.sun.star.comp.chaos.ResultSet" ),
					 		   OUString::createFromAscii(
								RESULTSET_SERVICE_NAME ) );

//=========================================================================
//
// XComponent methods.
//
//=========================================================================

// virtual
void SAL_CALL ResultSet::dispose()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pDisposeEventListeners && m_pDisposeEventListeners->getLength() )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XComponent * >( this );
		m_pDisposeEventListeners->disposeAndClear( aEvt );
	}

	m_pClient->close();
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::addEventListener(
							const Reference< XEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pDisposeEventListeners )
		m_pDisposeEventListeners =
					new OInterfaceContainerHelper( getContainerMutex() );

	m_pDisposeEventListeners->addInterface( Listener );
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::removeEventListener(
							const Reference< XEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pDisposeEventListeners )
		m_pDisposeEventListeners->removeInterface( Listener );
}

//=========================================================================
//
// XResultSetMetaDataSupplier methods.
//
//=========================================================================

// virtual
Reference< XResultSetMetaData > SAL_CALL ResultSet::getMetaData()
	throw( SQLException, RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_xMetaData.is() )
		m_xMetaData = new ::ucb::ResultSetMetaData(
									m_xSMgr, m_pClient->getProperties() );

	return m_xMetaData;
}

//=========================================================================
//
// XResultSet methods.
//
//=========================================================================

// virtual
sal_Bool SAL_CALL ResultSet::next()
	throw( SQLException, RuntimeException )
{
	// Note: Cursor is initially positioned before the first row.
	//       First call to 'next()' moves it to first row.

	vos::OGuard aGuard( m_aMutex );

	if ( m_bAfterLast )
	{
		m_pClient->validate();
		return sal_False;
	}

	// hasResult works zero-based!
	if ( !m_pClient->hasResult( m_nPos ) )
	{
		m_bAfterLast = sal_True;
		m_pClient->validate();
		return sal_False;
	}

	m_nPos++;
	m_pClient->validate();
	return sal_True;
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::isBeforeFirst()
	throw( SQLException, RuntimeException )
{
	if ( m_bAfterLast )
	{
		m_pClient->validate();
		return sal_False;
	}

	// hasResult works zero-based!
	if ( !m_pClient->hasResult( 0 ) )
	{
		m_pClient->validate();
		return sal_False;
	}

	m_pClient->validate();
	return ( m_nPos == 0 );
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::isAfterLast()
	throw( SQLException, RuntimeException )
{
	m_pClient->validate();
	return m_bAfterLast;
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::isFirst()
	throw( SQLException, RuntimeException )
{
	if ( m_bAfterLast )
	{
		m_pClient->validate();
		return sal_False;
	}

	m_pClient->validate();
	return ( m_nPos == 1 );
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::isLast()
	throw( SQLException, RuntimeException )
{
	if ( m_bAfterLast )
	{
		m_pClient->validate();
		return sal_False;
	}

	sal_Int32 nCount = m_pClient->totalCount();
	if ( nCount == 0 )
	{
		m_pClient->validate();
		return sal_False;
	}

	m_pClient->validate();
	return ( m_nPos == nCount );
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::beforeFirst()
	throw( SQLException, RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );
	m_bAfterLast = sal_False;
	m_nPos = 0;
	m_pClient->validate();
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::afterLast()
	throw( SQLException, RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );
	m_bAfterLast = sal_True;
	m_pClient->validate();
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::first()
	throw( SQLException, RuntimeException )
{
	// hasResult works zero-based!
	if ( m_pClient->hasResult( 0 ) )
	{
		vos::OGuard aGuard( m_aMutex );
		m_bAfterLast = sal_False;
		m_nPos = 1;
		m_pClient->validate();
		return sal_True;
	}

	m_pClient->validate();
	return sal_False;
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::last()
	throw( SQLException, RuntimeException )
{
	sal_uInt32 nCount = m_pClient->totalCount();
	if ( nCount )
	{
		vos::OGuard aGuard( m_aMutex );
		m_bAfterLast = sal_False;
		m_nPos = nCount;
		m_pClient->validate();
		return sal_True;
	}

	m_pClient->validate();
	return sal_False;
}

//=========================================================================
// virtual
sal_Int32 SAL_CALL ResultSet::getRow()
	throw( SQLException, RuntimeException )
{
	if ( m_bAfterLast )
	{
		m_pClient->validate();
		return 0;
	}

	m_pClient->validate();
	return m_nPos;
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::absolute( sal_Int32 row )
	throw( SQLException, RuntimeException )
{
/*
	If the row number is positive, the cursor moves to the given row number
	with respect to the beginning of the result set. The first row is row 1,
	the second is row 2, and so on.

	If the given row number is negative, the cursor moves to an absolute row
	position with respect to the end of the result set. For example, calling
	absolaute( -1 ) positions the cursor on the last row, absolaute( -2 )
	indicates the next-to-last row, and so on.

	An attempt to position the cursor beyond the first/last row in the result
	set leaves the cursor before/after the first/last row, respectively.

	Calling absolute( 1 ) is the same as calling first().

    Calling absolute( -1 ) is the same as calling last().
*/
	if ( row < 0 )
	{
		sal_Int32 nCount = m_pClient->totalCount();

		if ( ( row * -1 ) > nCount )
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_False;
			m_nPos = 0;
			m_pClient->validate();
			return sal_False;
		}
		else // |row| <= nCount
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_False;
			m_nPos = ( nCount + row + 1 );
			m_pClient->validate();
			return sal_True;
		}
	}
	else if ( row == 0 )
	{
	    // @throws SQLException
		//		... if row is 0 ...
		throw SQLException();
	}
	else // row > 0
	{
		sal_Int32 nCount = m_pClient->totalCount();

		if ( row <= nCount )
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_False;
			m_nPos = row;
			m_pClient->validate();
			return sal_True;
		}
		else // row > nCount
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_True;
			m_pClient->validate();
			return sal_False;
		}
	}

	// unreachable...
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::relative( sal_Int32 rows )
	throw( SQLException, RuntimeException )
{
/*
	Attempting to move beyond the first/last row in the result set
	positions the cursor before/after the the first/last row.

	Calling relative( 0 ) is valid, but does not change the cursor position.

    Calling relative( 1 ) is different from calling next() because it makes
	sense to call next() when there is no current row, for example,	when
	the cursor is positioned before the first row or after the last	row of
	the result set.
*/
	if ( m_bAfterLast || ( m_nPos == 0 ) )
	{
		// "No current row".
		throw SQLException();
	}

	if ( rows < 0 )
	{
		if ( ( m_nPos + rows ) > 0 )
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_False;
			m_nPos = ( m_nPos + rows );
			m_pClient->validate();
			return sal_True;
		}
		else
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_False;
			m_nPos = 0;
			m_pClient->validate();
			return sal_False;
		}
	}
	else if ( rows == 0 )
	{
		// nop.
		m_pClient->validate();
		return sal_True;
	}
	else // rows > 0
	{
		sal_Int32 nCount = m_pClient->totalCount();
		if ( ( m_nPos + rows ) <= nCount )
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_False;
			m_nPos = ( m_nPos + rows );
			m_pClient->validate();
			return sal_True;
		}
		else
		{
			vos::OGuard aGuard( m_aMutex );
			m_bAfterLast = sal_True;
			m_pClient->validate();
			return sal_False;
		}
	}

	// unreachable...
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::previous()
	throw( SQLException, RuntimeException )
{
/*
	previous() is not the same as relative( -1 ) because it makes sense
	to call previous() when there is no current row.
*/
	vos::OGuard aGuard( m_aMutex );

	if ( m_bAfterLast )
	{
		m_bAfterLast = sal_False;
		sal_uInt32 nCount = m_pClient->totalCount();
		m_nPos = nCount;
	}
	else if ( m_nPos )
		m_nPos--;

	if ( m_nPos )
	{
		m_pClient->validate();
		return sal_True;
	}

	m_pClient->validate();
	return sal_False;
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::refreshRow()
	throw( SQLException, RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );
	if ( m_bAfterLast || ( m_nPos == 0 ) )
		return;

	m_pClient->releasePropertyValues( m_nPos );
	m_pClient->validate();
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::rowUpdated()
	throw( SQLException, RuntimeException )
{
// @@@ - requires property-change listener

	m_pClient->validate();
	return sal_False;
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::rowInserted()
	throw( SQLException, RuntimeException )
{
// @@@ - requires content-event listener

	m_pClient->validate();
	return sal_False;
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::rowDeleted()
	throw( SQLException, RuntimeException )
{
// @@@ - requires content-event listener

	m_pClient->validate();
	return sal_False;
}

//=========================================================================
// virtual
Reference< XInterface > SAL_CALL ResultSet::getStatement()
	throw( SQLException, RuntimeException )
{
/*
	returns the Statement that produced this ResultSet object. If the
	result set was generated some other way, ... this method returns null.
*/
	m_pClient->validate();
	return Reference< XInterface >();
}

//=========================================================================
//
// XRow methods.
//
//=========================================================================

// virtual
sal_Bool SAL_CALL ResultSet::wasNull()
	throw( SQLException, RuntimeException )
{
	// This method can not be implemented correctly!!! Imagine different
	// threads doing a getXYZ - wasNull calling sequence on the same
	// implementation object...

	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_pClient->validate();
			return xValues->wasNull();
		}
	}

	m_pClient->validate();
	return m_bPossiblyTheLastValueWasNull;
}

//=========================================================================
// virtual
OUString SAL_CALL ResultSet::getString( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getString( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return OUString();
}

//=========================================================================
// virtual
sal_Bool SAL_CALL ResultSet::getBoolean( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getBoolean( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return sal_False;
}

//=========================================================================
// virtual
sal_Int8 SAL_CALL ResultSet::getByte( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getByte( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return 0;
}

//=========================================================================
// virtual
sal_Int16 SAL_CALL ResultSet::getShort( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getShort( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return 0;
}

//=========================================================================
// virtual
sal_Int32 SAL_CALL ResultSet::getInt( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getInt( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return 0;
}

//=========================================================================
// virtual
sal_Int64 SAL_CALL ResultSet::getLong( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getLong( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return 0;
}

//=========================================================================
// virtual
float SAL_CALL ResultSet::getFloat( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getFloat( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return 0;
}

//=========================================================================
// virtual
double SAL_CALL ResultSet::getDouble( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getDouble( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return 0;
}

//=========================================================================
// virtual
Sequence< sal_Int8 > SAL_CALL
ResultSet::getBytes( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getBytes( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Sequence< sal_Int8 >();
}

//=========================================================================
// virtual
Date SAL_CALL ResultSet::getDate( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getDate( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Date();
}

//=========================================================================
// virtual
Time SAL_CALL ResultSet::getTime( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getTime( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Time();
}

//=========================================================================
// virtual
com::sun::star::util::DateTime SAL_CALL
ResultSet::getTimestamp( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getTimestamp( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return com::sun::star::util::DateTime();
}

//=========================================================================
// virtual
Reference< XInputStream > SAL_CALL
ResultSet::getBinaryStream( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getBinaryStream( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Reference< XInputStream >();
}

//=========================================================================
// virtual
Reference< XInputStream > SAL_CALL
ResultSet::getCharacterStream( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getCharacterStream( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Reference< XInputStream >();
}

//=========================================================================
// virtual
Any SAL_CALL ResultSet::getObject( sal_Int32 columnIndex,
	   				 			   const Reference< XNameAccess >& typeMap )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getObject( columnIndex, typeMap );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Any();
}

//=========================================================================
// virtual
Reference< XRef > SAL_CALL ResultSet::getRef( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getRef( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Reference< XRef >();
}

//=========================================================================
// virtual
Reference< XBlob > SAL_CALL ResultSet::getBlob( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getBlob( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Reference< XBlob >();
}

//=========================================================================
// virtual
Reference< XClob > SAL_CALL ResultSet::getClob( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getClob( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Reference< XClob >();
}

//=========================================================================
// virtual
Reference< XArray > SAL_CALL ResultSet::getArray( sal_Int32 columnIndex )
	throw( SQLException, RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		Reference< XRow > xValues(
							m_pClient->queryPropertyValues( m_nPos - 1 ) );
		if ( xValues.is() )
		{
			m_bPossiblyTheLastValueWasNull = sal_False;
			m_pClient->validate();
			return xValues->getArray( columnIndex );
		}
	}

	m_bPossiblyTheLastValueWasNull = sal_True;
	m_pClient->validate();
	return Reference< XArray >();
}

//=========================================================================
//
// XCloseable methods.
//
//=========================================================================

// virtual
void SAL_CALL ResultSet::close()
	throw( SQLException, RuntimeException )
{
	// Abort the task executed by the client.
	m_pClient->close();
	m_pClient->validate();
}

//=========================================================================
//
// XContentAccess methods.
//
//=========================================================================

// virtual
OUString SAL_CALL ResultSet::queryContentIdentifierString()
	throw( RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		const Any& rAny = m_pClient->queryResult( m_nPos - 1 );
		if ( rAny.hasValue() )
		{
			Reference< XContent > xContent;
			if ( rAny >>= xContent )
				return xContent->getIdentifier()->getContentIdentifier();
		}
	}
	return OUString();
}

//=========================================================================
// virtual
Reference< XContentIdentifier > SAL_CALL ResultSet::queryContentIdentifier()
	throw( RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		const Any& rAny = m_pClient->queryResult( m_nPos - 1 );
		if ( rAny.hasValue() )
		{
			Reference< XContent > xContent;
			if ( rAny >>= xContent )
				return xContent->getIdentifier();
		}
	}
	return Reference< XContentIdentifier >();
}

//=========================================================================
// virtual
Reference< XContent > SAL_CALL ResultSet::queryContent()
	throw( RuntimeException )
{
	if ( m_nPos && !m_bAfterLast )
	{
		const Any& rAny = m_pClient->queryResult( m_nPos - 1 );
		if ( rAny.hasValue() )
		{
			Reference< XContent > xContent;
			if ( rAny >>= xContent )
				return xContent;
		}
	}
	return Reference< XContent >();
}

//=========================================================================
//
// XPropertySet methods.
//
//=========================================================================

// virtual
Reference< XPropertySetInfo > SAL_CALL ResultSet::getPropertySetInfo()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_xPropSetInfo.is() )
		m_xPropSetInfo = new PropertySetInfo_Impl( m_xSMgr, aPropertyMap_Impl );

	return m_xPropSetInfo;
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::setPropertyValue( const OUString& aPropertyName,
										   const Any& aValue )
	throw( UnknownPropertyException,
		   PropertyVetoException,
		   IllegalArgumentException,
		   WrappedTargetException,
		   RuntimeException )
{
	if ( !aPropertyName.getLength() )
		throw UnknownPropertyException();

	if ( aPropertyName.equals(
				OUString::createFromAscii( "RowCount" ) ) )
	{
		// property is read-only.
		throw IllegalArgumentException();
	}
	else if ( aPropertyName.equals(
				OUString::createFromAscii( "IsRowCountFinal" ) ) )
	{
		// property is read-only.
		throw IllegalArgumentException();
	}
	else
	{
		throw UnknownPropertyException();
	}
}

//=========================================================================
// virtual
Any SAL_CALL ResultSet::getPropertyValue( const OUString& PropertyName )
	throw( UnknownPropertyException,
		   WrappedTargetException,
		   RuntimeException )
{
	if ( !PropertyName.getLength() )
		throw UnknownPropertyException();

	Any aValue;

	if ( PropertyName.equals(
				OUString::createFromAscii( "RowCount" ) ) )
	{
		aValue <<= m_pClient->currentCount();
	}
	else if ( PropertyName.equals(
				OUString::createFromAscii( "IsRowCountFinal" ) ) )
	{
		aValue <<= m_pClient->isCountFinal();
	}
	else
	{
		throw UnknownPropertyException();
	}

	return aValue;
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::addPropertyChangeListener(
						const OUString& aPropertyName,
					   	const Reference< XPropertyChangeListener >& xListener )
	throw( UnknownPropertyException,
		   WrappedTargetException,
		   RuntimeException )
{
	BOOL bValid = !aPropertyName.getLength();

	if ( !bValid )
		bValid = !!aItemMap_Impl.Prop2Which( aPropertyName );

	if ( bValid )
		m_pClient->addPropertyChangeListener( aPropertyName, xListener );
	else
		throw UnknownPropertyException();
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::removePropertyChangeListener(
						const OUString& aPropertyName,
						const Reference< XPropertyChangeListener >& xListener )
	throw( UnknownPropertyException,
		   WrappedTargetException,
		   RuntimeException )
{
	BOOL bValid = !aPropertyName.getLength();

	if ( !bValid )
		bValid = !!aItemMap_Impl.Prop2Which( aPropertyName );

	if ( bValid )
		m_pClient->removePropertyChangeListener( aPropertyName, xListener );
	else
		throw UnknownPropertyException();
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::addVetoableChangeListener(
						const OUString& PropertyName,
						const Reference< XVetoableChangeListener >& aListener )
	throw( UnknownPropertyException,
		   WrappedTargetException,
		   RuntimeException )
{
	//	No constrained props. at the moment.
}

//=========================================================================
// virtual
void SAL_CALL ResultSet::removeVetoableChangeListener(
						const OUString& PropertyName,
						const Reference< XVetoableChangeListener >& aListener )
	throw( UnknownPropertyException,
		   WrappedTargetException,
		   RuntimeException )
{
	//	No constrained props. at the moment.
}

//=========================================================================
// virtual
Command const & ResultSet::accessCommand() const
{
	return m_pClient->accessCommand();
}

//=========================================================================
//=========================================================================
//
// CommandTaskThread_Impl implementation.
//
//=========================================================================
//=========================================================================

CommandTaskThread_Impl::CommandTaskThread_Impl(
			const Reference< XMultiServiceFactory >& rxSMgr,
			TaskClient_Impl* pClient,
			ChaosContent* pOwner,
			const Command& rCommand,
			ResultAcceptor* pAcceptor,
			const Reference< XCommandEnvironment >& rxEnv )
: ChaosCommandTask( rxSMgr, pOwner, rCommand, rxEnv, pClient, pAcceptor ),
  m_pClient( pClient )
{
//	// Create worker thread.
//	create();
}

//=========================================================================
// virtual
CommandTaskThread_Impl::~CommandTaskThread_Impl()
{
	// Cleanup thread.
	terminate();
}

//=========================================================================
// virtual
void SAL_CALL CommandTaskThread_Impl::run()
{
	// Thread worker function.

	if ( schedule() )
	{
		// Execute task.
		try
		{
			execute();
		}
		catch ( com::sun::star::uno::Exception& rEx )
		{
			acquire();

			// creator thread will take over the exception!
			m_pClient->setException( rEx );

			release();
		}
	}
}

//=========================================================================
//=========================================================================
//
// TaskClient_Impl implementation.
//
//=========================================================================
//=========================================================================

TaskClient_Impl::TaskClient_Impl(
						const Reference< XMultiServiceFactory >& rxSMgr,
						ResultSet* pOwner,
					 	ChaosContent* pContent,
						const Command& rCommand,
					 	const Reference< XCommandEnvironment >& Env )
: m_xSMgr( rxSMgr ),
  m_xEnv( Env ),
  m_eTaskState( CREATED ),
  m_pOwner( pOwner ),
  m_pPropertyChangeListeners( NULL ),
  m_bThrowException( sal_False )
{
	OpenCommandArgument2 aOpenCommand;
	SearchCommandArgument aSearchCommand;
	if ( rCommand.Argument >>= aOpenCommand )
		m_aProps = aOpenCommand.Properties;
	else if ( rCommand.Argument >>= aSearchCommand )
		m_aProps = aSearchCommand.Properties;

  	m_pTask = new CommandTaskThread_Impl(
						rxSMgr, this, pContent, rCommand, this, this );
	m_pTask->acquire();

	m_aResults.reserve( 1024 );
}

//=========================================================================
// virtual
TaskClient_Impl::~TaskClient_Impl()
{
	if ( m_pTask )
    {
        m_pTask->join();
		m_pTask->release();
    }

	delete m_pPropertyChangeListeners;
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_2( TaskClient_Impl,
				   XCommandEnvironment,
				   XInteractionHandler );

//=========================================================================
//
// ResultAcceptor methods.
//
//=========================================================================

// virtual
sal_Bool TaskClient_Impl::usePartialResultChannel()
{
	// Always use partialResult to notify results.
	return sal_True;
}

//=========================================================================
// virtual
void TaskClient_Impl::partialResult( const Any& Result )
{
	vos::OGuard aGuard( m_aMutex );

	// Remember result.
	m_aResults.push_back( Result );

	// Announce new count.
	propertyChanged( PropertyChangeEvent(
  						   static_cast< OWeakObject * >( m_pOwner ),
						   OUString::createFromAscii( "RowCount" ),
						   sal_False,
						   1001,
						   makeAny( sal_Int32( m_aResults.size() - 1 ) ),
						   makeAny( sal_Int32( m_aResults.size() ) ) ) );
	// Announce result.
	m_aNewResult.set();
}

//=========================================================================
// virtual
void TaskClient_Impl::completeResult( const Any& Result )
{
	DBG_ERROR( "TaskClient_Impl::completeResult - mission impossible!" );
}

//=========================================================================
//
// XCommandEnvironment methods.
//
//=========================================================================

// virtual
Reference< XInteractionHandler > SAL_CALL
TaskClient_Impl::getInteractionHandler()
	throw( RuntimeException )
{
	return m_xEnv.is() ? Reference< XInteractionHandler >( this )
					   : Reference< XInteractionHandler >();
}

//=========================================================================
// virtual
Reference< XProgressHandler > SAL_CALL TaskClient_Impl::getProgressHandler()
	throw( RuntimeException )
{
	return m_xEnv.is() ? m_xEnv->getProgressHandler()
					   : Reference< XProgressHandler >();
}

//=========================================================================
//
// XInteractionHandler methods.
//
//=========================================================================

// virtual
void SAL_CALL TaskClient_Impl::handle(
						const Reference< XInteractionRequest >& Request )
	throw( RuntimeException )
{
	if ( m_xEnv.is() && m_xEnv->getInteractionHandler().is() )
	{
		m_xInteractionRequest = Request;

		// Wake up main thread and wait until it has handled the
		// interaction request...

		m_aInteracted.reset();
		m_aNewResult.set();
		m_aFinished.set();
		m_aInteracted.wait();

		m_xInteractionRequest = 0;
	}
}

//=========================================================================
//
// Non-interface nethods
//
//=========================================================================

static Any aEmptyAny_Impl;

const Any& TaskClient_Impl::queryResult( sal_uInt32 nIndex )
{
	{
		vos::OGuard aGuard( m_aMutex );

		if ( m_eTaskState == CREATED )
		{
			// Task not running yet - start it;
			m_pTask->create();
			m_eTaskState = RUNNING;
		}
	}

	for ( ;; )
	{
		{
			vos::OGuard aGuard( m_aMutex );

			m_aNewResult.reset();

			if ( m_aResults.size() > nIndex )
			{
				// Element available.
			 	return m_aResults[ nIndex ];
			}

			if ( m_eTaskState == FINISHED )
			{
				// Task already finished - index is out of range.
				return aEmptyAny_Impl;
			}

			DBG_ASSERT( m_eTaskState == RUNNING,
						"TaskClient_Impl::queryResult - wrong state!" );

			// Release mutex to allow task to insert new results / to finish!
		}

		// Wait for next result / task finish / interaction request.
		m_aNewResult.wait();

		if ( m_xInteractionRequest.is() )
		{
			// Interaction request from task worker thread...

			// Handle the request.
			Reference< XInteractionHandler > xHandler;
			if ( m_xEnv.is() )
				xHandler = m_xEnv->getInteractionHandler();

			if ( xHandler.is() )
				xHandler->handle( m_xInteractionRequest );

			// Wake up sleeping worker thread...
			m_aFinished.reset();
			m_aNewResult.reset();
			m_aInteracted.set();
		}
	}

	// Unreachable code...
}

//=========================================================================
sal_uInt32 TaskClient_Impl::totalCount()
{
	{
		vos::OGuard aGuard( m_aMutex );

		if ( m_eTaskState == CREATED )
		{
			// Task not running yet - start it;
			m_pTask->create();
			m_eTaskState = RUNNING;
		}

		// Release mutex to allow task to finish!
	}

	sal_Bool bContinue;

	do
	{
		bContinue = sal_False;

		// Wait for task to finish / interaction request.
		m_aFinished.wait();

		if ( m_xInteractionRequest.is() )
		{
			// Interaction request from task worker thread...

			// Handle the request.
			Reference< XInteractionHandler > xHandler;
			if ( m_xEnv.is() )
				xHandler = m_xEnv->getInteractionHandler();

			if ( xHandler.is() )
				xHandler->handle( m_xInteractionRequest );

			// Wake up sleeping worker thread...
			m_aFinished.reset();
			m_aNewResult.reset();
			m_aInteracted.set();

			// Go on....
			bContinue = sal_True;
		}
	}
	while ( bContinue );

	return m_aResults.size();
}

//=========================================================================
Reference< XRow > TaskClient_Impl::queryPropertyValues(	sal_uInt32 nIndex )
{
	vos::OGuard aGuard( m_aMutex );

	// Values already available?
	const PropertyValues_Impl::const_iterator it = m_aPropValues.find( nIndex );
	if ( it != m_aPropValues.end() )
		return (*it).second;

	// Obtain values.
	Reference< XRow > xResult;

	const Any& rContent = queryResult( nIndex );
	Reference< XContent > xContent;
	if ( rContent >>= xContent )
	{
		// Autsch!
		ChaosContent* pContent = static_cast< ChaosContent* >( xContent.get() );
		if ( pContent )
		{
			vos::ORef< ChaosPropertyTask > xTask
				= new ChaosPropertyTask( m_xSMgr, pContent, m_xEnv, m_aProps );
			try
			{
				xTask->execute();
			}
			catch ( RuntimeException & )
			{
			}
			catch ( Exception & )
			{
			}

		    const Sequence< PropertyValueInfo > aProps = xTask->getProperties();
			sal_Int32 nCount = aProps.getLength();
			if ( nCount )
			{
				Sequence< PropertyValue > aValues( nCount );

				const PropertyValueInfo* pProps = aProps.getConstArray();
				PropertyValue* pValues = aValues.getArray();

				for ( sal_Int32 n = 0; n < nCount; ++n )
					pValues[ n ] = pProps[ n ];

				// Create and remember return value.
				xResult = new ::ucb::PropertyValueSet( m_xSMgr, aValues );
			}
			else
				xResult = new ::ucb::PropertyValueSet( m_xSMgr );

		}
	}

	m_aPropValues[ nIndex ] = xResult;
	return xResult;
}

//=========================================================================
void TaskClient_Impl::releasePropertyValues( sal_uInt32 nIndex )
{
	vos::OGuard aGuard( m_aMutex );

	// Values available?
	PropertyValues_Impl::iterator it = m_aPropValues.find( nIndex );
	if ( it != m_aPropValues.end() )
		m_aPropValues.erase( it );
}

//=========================================================================
void TaskClient_Impl::close()
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pPropertyChangeListeners )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XPropertySet * >( m_pOwner );
		m_pPropertyChangeListeners->disposeAndClear( aEvt );
	}

	if ( m_pTask )
		m_pTask->abort();
}

//=========================================================================
void TaskClient_Impl::setException(
						const com::sun::star::uno::Exception& rException )
{
	// Note: This method will be called in the context of the command thread.
	//       The transferred exception shell be thrown sometimes later in
	//       the thread  context of the task client. ( See below. )

	vos::OGuard aGuard( m_aMutex );

	DBG_ASSERT( !m_bThrowException && !m_aException.hasValue(),
				"TaskClient_Impl::setException - Already set!" );

	m_bThrowException = sal_True;
	m_aException <<= rException;

	done();
}

//=========================================================================
void TaskClient_Impl::validate()
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_bThrowException )
		throw ResultSetException( OUString(),
							  	  Reference< XInterface >(),
							  	  OUString(),
							  	  0,
							  	  m_aException );
}

//=========================================================================
void TaskClient_Impl::done()
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pTask )
	{
		m_eTaskState = FINISHED;

		// Announce, that row count is final.
		propertyChanged(
			PropertyChangeEvent( static_cast< OWeakObject * >( m_pOwner ),
							 	 OUString::createFromAscii( "IsRowCountFinal" ),
							 	 sal_False,
							 	 1000,
							 	 makeAny( sal_False ),		// old value
							 	 makeAny( sal_True ) ) );   // new value
		m_aNewResult.set();
		m_aFinished.set();
	}
}

//=========================================================================
void TaskClient_Impl::addPropertyChangeListener(
						const OUString& aPropertyName,
					   	const Reference< XPropertyChangeListener >& xListener )
{
	// Note: An empty property name means a listener for "all" properties.

	vos::OGuard aGuard( m_aMutex );

	if ( !m_pPropertyChangeListeners )
		m_pPropertyChangeListeners = new PropertyChangeListeners_Impl;

	m_pPropertyChangeListeners->addInterface( aPropertyName, xListener );
}

//=========================================================================
void TaskClient_Impl::removePropertyChangeListener(
						const OUString& aPropertyName,
						const Reference< XPropertyChangeListener >& aListener )
{
	// Note: An empty property name means a listener for "all" properties.

	vos::OGuard aGuard( m_aMutex );

	if ( m_pPropertyChangeListeners )
		m_pPropertyChangeListeners->removeInterface( aPropertyName, aListener );
}

//=========================================================================
void TaskClient_Impl::propertyChanged( const PropertyChangeEvent& rEvt )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pPropertyChangeListeners )
		return;

	// Notify listeners interested especially in the changed property.
	OInterfaceContainerHelper* pPropsContainer =
			m_pPropertyChangeListeners->getContainer( rEvt.PropertyName );
	if ( pPropsContainer )
	{
		OInterfaceIteratorHelper aIter( *pPropsContainer );
		while ( aIter.hasMoreElements() )
		{
			Reference< XPropertyChangeListener > xListener(
													aIter.next(), UNO_QUERY );
			if ( xListener.is() )
				xListener->propertyChange( rEvt );
		}
	}

	// Notify listeners interested in all properties.
	pPropsContainer = m_pPropertyChangeListeners->getContainer( OUString() );
	if ( pPropsContainer )
	{
		OInterfaceIteratorHelper aIter( *pPropsContainer );
		while ( aIter.hasMoreElements() )
		{
			Reference< XPropertyChangeListener > xListener(
													aIter.next(), UNO_QUERY );
			if ( xListener.is() )
				xListener->propertyChange( rEvt );
		}
	}
}

//=========================================================================
// virtual
void TaskClient_Impl::contentTaskStatusChange(
										  const ContentTaskStatus& rOld,
										  const ContentTaskStatus& rNew )
{
	switch ( rNew )
	{
    	case ContentTaskStatus_DONE:
    	case ContentTaskStatus_ABORTED:
			done();
			break;

		default:
			break;
	}
}

//=========================================================================
//=========================================================================
//
// PropertySetInfo_Impl Implementation.
//
//=========================================================================
//=========================================================================

PropertySetInfo_Impl::PropertySetInfo_Impl(
						const Reference< XMultiServiceFactory >& rxSMgr,
						const CntItemMap& rProps )
: m_xSMgr( rxSMgr )
{
	sal_uInt32 nCount = rProps.Count();
	m_pProps = new Sequence< Property >( nCount );

	if ( nCount )
	{
		Property* pProps = m_pProps->getArray();

		for ( sal_uInt32 n = 0; n < nCount; ++n )
		{
			const CntItemMapEntry* pEntry = rProps.GetObject( n );
			Property& rProp = pProps[ n ];

			rProp.Name		 = rtl::OUString::createFromAscii( pEntry->pName );
    		rProp.Handle	 = pEntry->nWhich;
    		rProp.Type		 = pEntry->pGetCppuType();
    		rProp.Attributes = pEntry->nAttributes;
		}
	}
}

//=========================================================================
// virtual
PropertySetInfo_Impl::~PropertySetInfo_Impl()
{
	delete m_pProps;
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_2( PropertySetInfo_Impl,
				   XTypeProvider,
				   XPropertySetInfo );

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_IMPL_2( PropertySetInfo_Impl,
				   	  XTypeProvider,
				   	  XPropertySetInfo );

//=========================================================================
//
// XPropertySetInfo methods.
//
//=========================================================================

// virtual
Sequence< Property > SAL_CALL PropertySetInfo_Impl::getProperties()
	throw( RuntimeException )
{
	return Sequence< Property >( *m_pProps );
}

//=========================================================================
// virtual
Property SAL_CALL PropertySetInfo_Impl::getPropertyByName(
												const OUString& aName )
	throw( UnknownPropertyException, RuntimeException )
{
	Property aProp;
	if ( queryProperty( aName, aProp ) )
		return aProp;

	throw UnknownPropertyException();
}

//=========================================================================
// virtual
sal_Bool SAL_CALL PropertySetInfo_Impl::hasPropertyByName(
												const OUString& Name )
	throw( RuntimeException )
{
	Property aProp;
	return queryProperty( Name, aProp );
}

//=========================================================================
sal_Bool PropertySetInfo_Impl::queryProperty(
							const OUString& aName, Property& rProp )
{
	sal_uInt32 nCount = m_pProps->getLength();
	const Property* pProps = m_pProps->getConstArray();
	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		const Property& rCurr = pProps[ n ];
		if ( rCurr.Name == aName )
		{
			rProp = rCurr;
			return sal_True;
		}
	}

	return sal_False;
}

