/*************************************************************************
 *
 *  $RCSfile: tasks.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Kai Sommerfeld ( kso@sun.com )
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#include <list>

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYACCESS_HPP_
#include <com/sun/star/beans/XPropertyAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_CHAOSPROGRESSSTART_HPP_
#include <com/sun/star/ucb/CHAOSProgressStart.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_CONTENTACTION_HPP_
#include <com/sun/star/ucb/ContentAction.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include <com/sun/star/ucb/OpenCommandArgument2.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_OPENMODE_HPP_
#include <com/sun/star/ucb/OpenMode.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INSERTCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/InsertCommandArgument.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_SEARCHCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/SearchCommandArgument.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_UNSUPPORTEDDATASINKEXCEPTION_HPP_
#include <com/sun/star/ucb/UnsupportedDataSinkException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_UNSUPPORTEDOPENMODEEXCEPTION_HPP_
#include <com/sun/star/ucb/UnsupportedOpenModeException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XINTERACTIONHANDLERSUPPLIER_HPP_
#include <com/sun/star/ucb/XInteractionHandlerSupplier.hpp>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _CPPUHELPER_EXC_HLP_HXX_
#include <cppuhelper/exc_hlp.hxx>
#endif
#ifndef _UCBHELPER_CANCELCOMMANDEXECUTION_HXX_
#include <ucbhelper/cancelcommandexecution.hxx>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SFXCANCEL_HXX
#include <svtools/cancel.hxx>
#endif
#ifndef _SFXNRANGES_HXX
#include <svtools/nranges.hxx>
#endif
#ifndef SVTOOLS_INSTRM_HXX
#include <svtools/instrm.hxx>
#endif

#include "tasks.hxx"

#ifndef _CONTENT_HXX
#include "content.hxx"
#endif
#ifndef _PROVIDER_HXX
#include "provider.hxx"
#endif
#ifndef _CNTJOB_HXX // USE_JOB_DISPATCHER
#include "cntjob.hxx"
#endif
#ifndef _CNTPOOL_HXX
#include "cntpool.hxx"
#endif
#ifndef _ILSTITEM_HXX
#include "ilstitem.hxx"
#endif
#ifndef _CSTRITEM_HXX
#include "cstritem.hxx"
#endif
#ifndef CHAOS_EHDLI_HXX
#include "ehdli.hxx"
#endif
#ifndef _CHAOS_STRMITEM_HXX
#include "strmitem.hxx"
#endif
#ifndef CHAOS_TASKBASE_HXX
#include "taskbase.hxx"
#endif

#ifndef USE_JOB_DISPATCHER

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx> /* Application::Yield() /*/
#endif

#endif

using namespace chaos;
using namespace rtl;
using namespace vos;
using namespace cppu;
using namespace com::sun::star::io;
using namespace com::sun::star::uno;
using namespace com::sun::star::beans;
using namespace com::sun::star::task;
using namespace com::sun::star::lang;
using namespace com::sun::star::ucb;

//=========================================================================

//  The mutex to synchronize access to containers.
static osl::Mutex& getContainerMutex()
{
	static osl::Mutex* pMutex = NULL;
	if( !pMutex )
	{
		osl::Guard< osl::Mutex > aGuard( osl::Mutex::getGlobalMutex() );
		if( !pMutex )
		{
			static osl::Mutex aMutex;
			pMutex = &aMutex;
		}
	}

	return *pMutex;
}

//=========================================================================
//
// class ResultSupplier_Impl.
//
//=========================================================================

typedef std::list< Any > ResultList_Impl;

namespace chaos {

class ResultSupplier_Impl
{
	OMutex						m_aMutex;
	ResultAcceptor*				m_pAcceptor;
	ResultList_Impl*            m_pResults;
	sal_Bool					m_bCollectResults : 1;

public:
	ResultSupplier_Impl( ResultAcceptor* pAcceptor );
	~ResultSupplier_Impl();

	void result( const Any& rResult );
	void done();
	void abort();
};
 
} // namespace chaos

//=========================================================================
//=========================================================================
//
// ResultSupplier_Impl Implementation.
//
//=========================================================================
//=========================================================================

ResultSupplier_Impl::ResultSupplier_Impl( ResultAcceptor* pAcceptor )
: m_pAcceptor( pAcceptor ),
  m_pResults( NULL ),
  m_bCollectResults( !pAcceptor->usePartialResultChannel() )
{
}

//=========================================================================
ResultSupplier_Impl::~ResultSupplier_Impl()
{
	DBG_ASSERT( !m_pResults,
				"~ResultSupplier_Impl - ResultSupplier_Impl::done pending!" );

	delete m_pResults;
}

//=========================================================================
void ResultSupplier_Impl::result( const Any& rResult )
{
	OGuard aGuard( m_aMutex );

	if ( m_bCollectResults )
	{
		// Collect results and supply them when 'done' is called.
		if ( !m_pResults )
			m_pResults = new ResultList_Impl;

		m_pResults->push_back( rResult );
	}
	else
	{
		// Supply result a.s.a.p.
		m_pAcceptor->partialResult( rResult );
	}
}

//=========================================================================
void ResultSupplier_Impl::done()
{
	OGuard aGuard( m_aMutex );

	if ( m_bCollectResults && m_pResults )
	{
		// Create Sequence< Any > from result list and supply it.
		sal_uInt32 nCount = m_pResults->size();
		com::sun::star::uno::Sequence< Any > aSeq( m_pResults->size() );
		Any* pInfo = aSeq.getArray();

		ResultList_Impl::const_iterator iter = m_pResults->begin();
		for ( sal_uInt32 n = 0; n < nCount; n++, iter++ )
			pInfo[ n ] = (*iter);

		// Destroy result list.
		delete m_pResults;
		m_pResults = NULL;

		// Supply result.
		Any aResult;
		aResult <<= aSeq;
		m_pAcceptor->completeResult( aResult );
	}
}

//=========================================================================
void ResultSupplier_Impl::abort()
{
	OGuard aGuard( m_aMutex );

	// Destroy result list.
	delete m_pResults;
	m_pResults = NULL;
}

//=========================================================================
//
// class ChaosPropertyTaskProxy.
//
//=========================================================================

namespace chaos {

class ChaosPropertyTaskProxy :
	public cppu::OWeakObject,
	public com::sun::star::beans::XPropertyChangeListener
{
	ChaosPropertyTask* m_pOwner;

public:
	ChaosPropertyTaskProxy( ChaosPropertyTask* pOwner );
	virtual ~ChaosPropertyTaskProxy();

	// XInterface
	XINTERFACE_DECL()

	// XEventListenerListner ( base interface of XPropertyChangeListner )
    virtual void SAL_CALL disposing( const EventObject& Source )
		throw( com::sun::star::uno::RuntimeException );

	// XPropertyChangeListner
    virtual void SAL_CALL propertyChange( const PropertyChangeEvent& evt )
		throw( com::sun::star::uno::RuntimeException );
};
 
} // namespace chaos

//=========================================================================
//=========================================================================
//
// ChaosPropertyTaskProxy Implementation.
//
//=========================================================================
//=========================================================================

ChaosPropertyTaskProxy::ChaosPropertyTaskProxy( ChaosPropertyTask* pOwner )
: m_pOwner( pOwner )
{
	m_pOwner->acquire();
}

//=========================================================================
// virtual
ChaosPropertyTaskProxy::~ChaosPropertyTaskProxy()
{
	m_pOwner->release();
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_1( ChaosPropertyTaskProxy,
				   XPropertyChangeListener );

//=========================================================================
//
// XEventListenerListner methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosPropertyTaskProxy::disposing( const EventObject& Source )
	throw( com::sun::star::uno::RuntimeException )
{
}

//=========================================================================
//
// XPropertyChangeListener methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosPropertyTaskProxy::propertyChange(
										const PropertyChangeEvent& evt )
	throw( com::sun::star::uno::RuntimeException )
{
	m_pOwner->propertyChange( evt );
}

//=========================================================================
//=========================================================================
//
// ChaosTaskBase Implementation.
//
//=========================================================================
//=========================================================================

ChaosTaskBase::ChaosTaskBase(
					ChaosContent* pOwner,
					ContentTask* pTask,
    				const Reference< XCommandEnvironment >& xEnv,
					ContentTaskStatusListener* pListener )
: m_xEnv( xEnv ),
  m_eState( ContentTaskStatus_CREATED ),
  m_pOwner( pOwner ),
  m_pTask( pTask ),
  m_pListener( pListener ),
  m_pCancellable( 0 ),
  m_eCallbackReason( NONE ),
  m_nProgressState( PROGRESS_NONE ),
  m_nMainThreadId( osl_getThreadIdentifier( 0 ) ),
  m_bStarted( sal_False ),
  m_bExecSync( sal_True )
{
	m_pOwner->acquire();
}

//=========================================================================
// virtual
ChaosTaskBase::~ChaosTaskBase()
{
	DBG_ASSERT( m_eState != ContentTaskStatus_RUNNING,
				"~ChaosTaskBase - task is running!!!" );

	if ( m_pOwner )
		m_pOwner->release();

	// Note: Do not delete m_pCancellable!
}

//=========================================================================
Any ChaosTaskBase::run( const OUString& rName, sal_Int32 nHandle,
					    const Any& rValue, sal_Bool bSynchronous )
    throw ( Exception )
{
	if ( !queryRun() )
	{
		DBG_ERROR( "ChaosPropertyTask::run - No multiple runs!!!" );
		return Any();
	}

	USHORT nWhich = ( nHandle == -1 ) ? 0 : (USHORT)nHandle;

	if ( !nWhich )
	{
		const CntItemMapEntry* pEntry =	CNT_ITEMMAP()->Prop2Which( rName );
		if ( pEntry )
			nWhich = pEntry->nWhich;
	}

	if ( !nWhich )
	{
        if ( bSynchronous )
        {
            ucbhelper::cancelCommandExecution(
                makeAny( UnsupportedCommandException(
                            rtl::OUString(),
                            static_cast< cppu::OWeakObject * >( m_pOwner ) ) ),
                m_xEnv );
            // Unreachable
        }

        DBG_ERROR( "ChaosTaskBase::run - Not supported!" );
        setStatus( ContentTaskStatus_ABORTED );
        return Any();
	}

	// Check whether the anchor (currently) supports the command/property.
	if ( !m_pOwner->isHandleValid( nWhich ) )
	{
        if ( bSynchronous )
        {
            ucbhelper::cancelCommandExecution(
                makeAny( UnsupportedCommandException(
                            rtl::OUString(),
                            static_cast< cppu::OWeakObject * >( m_pOwner ) ) ),
                m_xEnv );
            // Unreachable
        }

        DBG_ERROR( "ChaosTaskBase::run - Not supported!" );
        setStatus( ContentTaskStatus_ABORTED );
        return Any();
	}

	SfxItemPool* pPool = getOwner()->getAnchor()->GetPool();
	SfxPoolItem* pItem = 0;

	switch ( nWhich )
	{
		// Special cases...

		case WID_OPEN:
		case WID_SYNCHRONIZE:
		case WID_UPDATE:
		{
			OpenCommandArgument2 aArgument;
			if (rValue >>= aArgument)
			{
                // Check mode...
				CntOpenMode eMode = CNT_OPEN_ALL;
				switch ( aArgument.Mode )
				{
					case OpenMode::ALL:
//						eMode = CNT_OPEN_ALL;
						break;

					case OpenMode::FOLDERS:
						eMode = CNT_OPEN_FOLDERS;
						break;

					case OpenMode::DOCUMENTS:
						eMode = CNT_OPEN_DOCUMENTS;
						break;

					case OpenMode::DOCUMENT:
						eMode = CNT_OPEN_DOCUMENT;
						break;

					// Never supported by CHAOS objects.
					case OpenMode::DOCUMENT_SHARE_DENY_NONE:
					case OpenMode::DOCUMENT_SHARE_DENY_WRITE:
                        if ( bSynchronous )
                        {
                            ucbhelper::cancelCommandExecution(
                                makeAny( UnsupportedOpenModeException(
                                            rtl::OUString(),
                                            static_cast< cppu::OWeakObject * >(
                                                m_pOwner ),
                                            sal_Int16( aArgument.Mode ) ) ),
                                m_xEnv );
                            // Unreachable
                        }

                        setStatus( ContentTaskStatus_ABORTED );
                        return Any();

					default:
						DBG_ERROR( "ChaosTaskBase::run - Unknown open mode!" );
//						eMode = CNT_OPEN_ALL;
						break;
				}

                // Check data sink...
                if ( bSynchronous && aArgument.Sink.is() )
                {
                    // CHAOS objects only support XOutputStream and
                    // XActiveDataSink.

                    Reference< XOutputStream > xOut(
                                            aArgument.Sink, UNO_QUERY );
                    if ( !xOut.is() )
                    {
                        Reference< XActiveDataSink > xDataSink(
                                            aArgument.Sink, UNO_QUERY );
                        if ( !xDataSink.is() )
                        {
                            ucbhelper::cancelCommandExecution(
                                makeAny( UnsupportedDataSinkException(
                                            rtl::OUString(),
                                            static_cast< cppu::OWeakObject * >(
                                                m_pOwner ),
                                         aArgument.Sink ) ),
                                m_xEnv );
                            // Unreachable
                        }
                    }
                }

				pItem = new CntOpenModeItem(
					            nWhich,
								eMode,
								sal_uInt16(
									aArgument.Priority < 0 ? 0 :
									aArgument.Priority >
									        CntOpenModeItem::LOWEST_PRIO ?
									    CntOpenModeItem::LOWEST_PRIO :
									    aArgument.Priority),
								aArgument.Sink);
			}
			break;
		}

		case WID_SEARCH:
		{
			SearchCommandArgument aArgument;
			if (rValue >>= aArgument)
			{
				CntSearchData aData;
				if (aData.putValue(aArgument.Info))
					pItem = new CntSearchDataItem(nWhich, aData);
			}
			break;
		}

		case WID_INSERT:
		{
			InsertCommandArgument aArg;
			if ( rValue >>= aArg )
			{
				// Data supplied?
				if ( aArg.Data.is() )
				{
					pItem = new CntInStreamItem(
									nWhich, new SvInputStream( aArg.Data ) );
				}
			}
			else
			{
                if ( bSynchronous )
                {
                    ucbhelper::cancelCommandExecution(
                        makeAny( IllegalArgumentException(
                                    rtl::OUString::createFromAscii(
                                        "Wrong argument type!" ),
                                    static_cast< cppu::OWeakObject * >(
                                        m_pOwner ),
                                    -1 ) ),
                        m_xEnv );
                    // Unreachable
                }

				DBG_ERROR( "ChaosTaskBase::run - Wrong parameter!" );
				setStatus( ContentTaskStatus_ABORTED );
				return Any();
			}
			break;
		}

		case WID_HTTP_POST:
			// Value not void?
			if ( rValue.hasValue() )
			{
				// Note: Pool default is SfxVoidItem.
				pItem = new CntPostStreamItem(nWhich);
				if (!pItem->PutValue(rValue))
				{
					delete pItem;
					pItem = 0;
				}
			}
			break;

		case WID_HTTP_COOKIE:
			// Note: Pool default is CntCookieManagerItem.
			pItem = new CntStringItem( WID_HTTP_SET_COOKIE, UniString() );
			if ( !pItem->PutValue( rValue ) )
			{
                if ( bSynchronous )
                {
                    ucbhelper::cancelCommandExecution(
                        makeAny( IllegalArgumentException(
                                    rtl::OUString::createFromAscii(
                                        "Wrong argument type!" ),
                                    static_cast< cppu::OWeakObject * >(
                                        m_pOwner ),
                                    -1 ) ),
                        m_xEnv );
                    // Unreachable
                }

				DBG_ERROR( "ChaosTaskBase::run - Not PutValue!" );
				delete pItem;
				setStatus( ContentTaskStatus_ABORTED );
				return Any();
			}
			break;

		default:
			break;
	}

	if ( pItem == 0 )
	{
		// Get item from anchor and clone it ( Virtual ctor ).
		pItem = pPool->GetDefaultItem( nWhich ).Clone();

		if ( !pItem->ISA( SfxVoidItem ) )
		{
			// Set item value as Any.
			if ( !pItem->PutValue( rValue ) )
			{
                if ( bSynchronous )
                {
                    ucbhelper::cancelCommandExecution(
                        makeAny( IllegalArgumentException(
                                    rtl::OUString::createFromAscii(
                                        "Wrong argument type!" ),
                                    static_cast< cppu::OWeakObject * >(
                                        m_pOwner ),
                                    -1 ) ),
                        m_xEnv );
                    // Unreachable
                }

				DBG_ERROR( "ChaosTaskBase::run - Not PutValue!" );
				delete pItem;
				setStatus( ContentTaskStatus_ABORTED );
				return Any();
			}
		}
	}

	// Workaround: Aenderungen von folgenden Properties koennen
	//             ein "Exchange" ausloesen. Die Services sind
	//             aber derzeit (503K) so implementiert, dass sie
	//			   diese WID's nur in einem WID_PUTDATA auswerten.
	if ( ( nWhich == WID_SERVERNAME ) || ( nWhich == WID_USERNAME ) )
	{
		// In WID_PUTDATA verpacken...
		CntItemListItem* pPutDataItem =
								new CntItemListItem( WID_PUTDATA, pPool );
		pPutDataItem->Append( pItem );
		pItem = pPutDataItem;
	}

	Any aResult = run( *pItem, bSynchronous );
	delete pItem;

	// Cleanup...
	switch ( nWhich )
	{
		case WID_INSERT:
		{
			InsertCommandArgument aArg;
			if ( ( rValue >>= aArg ) && aArg.Data.is() )
			{
				try
				{
					aArg.Data->closeInput();
				}
				catch ( NotConnectedException const & )
				{
				}
				catch ( IOException const & )
				{
				}
			}
			break;
		}

		default:
			break;
	}

	return aResult;
}

//=========================================================================
Any ChaosTaskBase::run( const SfxPoolItem& rItem, sal_Bool bSynchronous )
    throw ( Exception )
{
	// Hold task until operation was done/aborted.
	m_pTask->acquire();

	m_bExecSync = bSynchronous;
	m_bStarted  = sal_True;

	StartListening( *getOwner()->getAnchor() );

	// Put item into anchor. This starts executing a job inside CHAOS.
	SfxPoolItem* pRet = const_cast<	SfxPoolItem * >(
		getOwner()->getAnchor()->Put( rItem,
									  LINK( this, ChaosTaskBase, ErrorHandler ),
									  &m_pCancellable,
									  this ) );
	if ( m_pCancellable )
	{
		if ( bSynchronous )
		{
			sal_Bool bContinue;

			do
			{
				bContinue = sal_False;

				// Block until task has finished...
				waitForCompletion();

				switch ( m_eCallbackReason )
				{
					case NONE:
						// Task (worker thread) finished.
						m_aInteracted.set();
						break;

					case EXCEPTION:
                    {
                        // Ensure 'this' is not detroyed while in this block!
                        // (m_aInteracted.set() may release the last reference
                        // to m_pTask, which will delete 'this' in it's dtor!)
                        vos::ORef< ContentTask > xTask( m_pTask );

						m_aInteracted.set();

                        cppu::throwException( m_aException );
                        // Unreachable
                    }

					case INTERACTION:
					{
						// Interaction request from task worker thread...

						// Handle the request.
						Reference< XInteractionHandler > xHandler;
						if ( m_xEnv.is() )
							xHandler = m_xEnv->getInteractionHandler();

						if ( xHandler.is() )
							xHandler->handle( m_xInteractionRequest );

						// Wake up sleeping worker thread...
						m_aFinished.reset();
						m_aInteracted.set();

						// Once again.
						bContinue = sal_True;
						break;
					}

					default:
						DBG_ERROR(
							"ChaosTaskBase::run - Unknown callback reason!" );
						break;
				}
			} while ( bContinue );
		}

		if ( pRet )
		{
			// Synchronous job with return value finished.

			Any aResult;

			if ( !pRet->QueryValue( aResult ) )
			{
				DBG_ERROR( "ChaosTaskBase::run - Not QueryValue!" );
			}

			delete pRet;
			return aResult;
		}
	}
	else
	{
		// There was no job created inside CHAOS. "Emulate" one...
		setStatus( ContentTaskStatus_RUNNING );
		setStatus( ContentTaskStatus_DONE );
	}
	return Any();
}

//=========================================================================
sal_Bool ChaosTaskBase::setStatus( const ContentTaskStatus& rNewStatus )
{
	if ( m_eState == rNewStatus )
		return sal_False;

	sal_Bool bFinished = sal_False;

	switch ( rNewStatus )
	{
		case ContentTaskStatus_CREATED:
			DBG_ERROR( "ChaosTaskBase::setStatus - Wrong status change!" );
			return sal_False;

		case ContentTaskStatus_RUNNING:
			break;

		case ContentTaskStatus_DONE:
			if ( m_eState != ContentTaskStatus_RUNNING )
			{
				DBG_ERROR( "ChaosTaskBase::setStatus - Wrong status change!" );
				return sal_False;
			}

			// fall-through...

		case ContentTaskStatus_ABORTED:
			// final cleanup.
			EndListening( *getOwner()->getAnchor() );

			m_pOwner->release();
			m_pOwner = NULL;

			bFinished = sal_True;
			break;

		default:
			break;
	}

	if ( m_pListener )
	{
		// Inform listener about status change.
		m_pListener->contentTaskStatusChange( m_eState, rNewStatus );
	}

	m_eState = rNewStatus;

	if ( bFinished )
	{
        m_eCallbackReason = NONE;

        // !!! May destroy 'this' !!!
        finalCleanup();
	}

	return sal_True;
}

//============================================================================
void ChaosTaskBase::notifyContentEvent(
								sal_Int32 nAction,
								const Reference< XContent >& rContent,
								const Reference< XContentIdentifier >& rId )
{
	m_pOwner->notifyContentEvent( nAction, rContent, rId );
}

//=========================================================================
//
// SfxListener methods.
//
//=========================================================================

// virtual
void ChaosTaskBase::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	//////////////////////////////////////////////////////////////////////
	// CntStatusHint handling.
	//////////////////////////////////////////////////////////////////////

    if ( rHint.ISA( CntStatusHint ) )
    {
        const CntStatusHint* pStatusHint = (const CntStatusHint*)&rHint;

		SfxCancellable* pCancelable = pStatusHint->GetCancelable();

		if ( !m_pCancellable || pCancelable != m_pCancellable )
			return;

        const CntStatus eStatus = pStatusHint->GetStatus();
		switch ( eStatus )
		{
			case CNT_STATUS_STARTED:
				setStatus( ContentTaskStatus_RUNNING );
				break;

			case CNT_STATUS_DONE:
				setStatus( ContentTaskStatus_DONE );
				break;

			case CNT_STATUS_ERROR:
			    if ( pStatusHint->GetError() == ERRCODE_ABORT )
				{
					setStatus( ContentTaskStatus_ABORTED );
				}
				else
				{
					// Other error - ignore. It will be handled
					// using own error handler link.
				}
				break;

			default:
				DBG_ERROR( "ChaosTaskBase::Notify - Unknown StatusHint!" );
				break;
		}
	}
	else if (rHint.ISA(CntStatusBarHint))
	{
		Reference<XProgressHandler> xHandler;
		if (m_xEnv.is())
			xHandler = m_xEnv->getProgressHandler();
		if (xHandler.is())
		{
			const CntStatusBarHint & rStatusHint
				= *SAL_STATIC_CAST(const CntStatusBarHint *, &rHint);
			switch (rStatusHint.GetAction())
			{
				case CNT_STATUSBARACTION_PROGRESS_START:
				{
					if (m_nProgressState != PROGRESS_NONE)
						xHandler->pop();
					m_nProgressState = rStatusHint.GetHintId();
					CHAOSProgressStart aStatus;
					const String& rText = rStatusHint.GetProgressText();
					aStatus.Text = rText;
					aStatus.Minimum = sal_Int32(rStatusHint.GetProgressMin());
					aStatus.Maximum
						= sal_Int32(rStatusHint.GetProgressMax()
									        < 0x7FFFFFFF ?
									    rStatusHint.GetProgressMax() :
									    0x7FFFFFFF);
					xHandler->push(makeAny(aStatus));
					break;
				}

				case CNT_STATUSBARACTION_PROGRESS_SET:
					if (m_nProgressState == rStatusHint.GetHintId())
						xHandler->
							update(makeAny(sal_Int32(
								               rStatusHint.GetProgressCur()
											           < 0x7FFFFFFF ?
											       rStatusHint.
											           GetProgressCur() :
											       0x7FFFFFFF)));
					break;

				case CNT_STATUSBARACTION_PROGRESS_END:
					if (m_nProgressState == rStatusHint.GetHintId())
					{
						xHandler->pop();
						m_nProgressState = PROGRESS_NONE;
					}
					break;

				case CNT_STATUSBARACTION_SHOW_STATUS_TEXT:
					if (rStatusHint.GetStatusText().Len() == 0)
					{
						if (m_nProgressState == PROGRESS_TEXT)
						{
							xHandler->pop();
							m_nProgressState = PROGRESS_NONE;
						}
					}
					else if (m_nProgressState == PROGRESS_NONE)
					{
						const String& rText = rStatusHint.GetStatusText();
						m_nProgressState = PROGRESS_TEXT;
						xHandler->push(makeAny(OUString(rText)));
					}
					else if (m_nProgressState == PROGRESS_TEXT)
					{
						const String& rText = rStatusHint.GetStatusText();
						xHandler->update(makeAny(OUString(rText)));
					}
					break;
			}
		}
	}
}

//=========================================================================
//
// Other methods.
//
//=========================================================================

IMPL_LINK( ChaosTaskBase, ErrorHandler, const CntErrorData*, pData )
{
	ORef< InteractionRequest_Impl > xRequest
		= new InteractionRequest_Impl( pData );
	Reference< XInteractionHandler > xHandler;
	if ( m_xEnv.is() )
		xHandler = m_xEnv->getInteractionHandler();

	if ( xHandler.is() )
	{
		m_xInteractionRequest = xRequest.getBodyPtr();

		// Wake up main thread and wait until it has handled the
		// interaction request...

		m_eCallbackReason = INTERACTION;

		m_aInteracted.reset();
		m_aFinished.set();
		m_aInteracted.wait();

		m_eCallbackReason = NONE;

		ORef< InteractionContinuation_Impl > xSelection
			= xRequest->getSelection();
		if ( xSelection.isValid() )
			return xSelection->getButton();

		m_xInteractionRequest = 0;
	}

	Reference< XInteractionHandlerSupplier > xSupplier( m_xEnv, UNO_QUERY );
	if ( xSupplier.is() && !xSupplier->hasInteractionHandler() )
		return ERRCODE_CHAOS_NOT_HANDLED;

	if ( isSynchronous() )
	{
		m_eState = ContentTaskStatus_ABORTED;

		EndListening( *getOwner()->getAnchor() );
/*
	// Not necessary. Will be done by CHAOS.
		if ( m_pCancellable != 0 )
			m_pCancellable->Cancel();
*/
		m_pOwner->release();
		m_pOwner = 0;

		m_eCallbackReason = EXCEPTION;
		if ( xRequest.isValid() )
			m_aException = xRequest->getRequest();

        // !!! May destroy 'this' !!!
        finalCleanup();
	}

	return ERRCODE_BUTTON_CANCEL;
}

//=========================================================================
void ChaosTaskBase::initIDFactory()
{
	if (!m_xIDFactory.is())
	{
		Reference< com::sun::star::uno::XInterface > xUCB;
		if (m_pOwner->m_xSMgr.is())
			//@@@ The broker service should be created using
			// createInstanceWithArguments(), specifing whether and how the
			// broker should be configured.  Not supplying these arguments
			// implies that the broker service must already be instantiated
			// and configured when this call is made:
			xUCB = m_pOwner->m_xSMgr->
				       createInstance(
						   OUString::createFromAscii(
							   "com.sun.star.ucb.UniversalContentBroker"));
		m_xIDFactory = Reference< XContentIdentifierFactory >(xUCB,
															  UNO_QUERY);
	}
}

//=========================================================================
Reference< XContent > ChaosTaskBase::getContent() const
{
	return Reference< XContent >(
				static_cast< OWeakObject * >( m_pOwner ), UNO_QUERY );
}

//=========================================================================
void ChaosTaskBase::waitForCompletion()
{
#if defined USE_JOB_DISPATCHER && !defined USE_SOLAR_MUTEX

	// Only works in a multithreaded environment!!!
	m_aFinished.wait();

#else

	// Needs VCL!
	while ( ( m_eState != ContentTaskStatus_DONE ) &&
	   		( m_eState != ContentTaskStatus_ABORTED ) )
		Application::Yield();

#endif
}

//=========================================================================
void ChaosTaskBase::finalCleanup()
{
    // Sync with waiting main thread...
    m_aInteracted.reset();
    m_aFinished.set();

    // This method may be called from the same thread as ChaosTaskBase::run().
    // If so, no other thread that would set m_aInteracted would be activated
    // after setting m_aFinished here and we would get a DEADLOCK!
    if ( m_nMainThreadId != osl_getThreadIdentifier( 0 ) )
        m_aInteracted.wait();

    m_eCallbackReason = NONE;

    m_xEnv = 0;

    if ( m_bStarted )
    {
        // !!! May destroy 'this' !!!
        ContentTask * pTheTask = m_pTask;
        m_pTask = 0;
        pTheTask->release();
    }
}

//=========================================================================
//=========================================================================
//
// ChaosCommandTask Implementation.
//
//=========================================================================
//=========================================================================

ChaosCommandTask::ChaosCommandTask(
					const Reference< XMultiServiceFactory >& rxSMgr,
					ChaosContent* pOwner,
					const Command& rCommand,
					const Reference< XCommandEnvironment >& rxEnv,
					ContentTaskStatusListener* pListener,
					ResultAcceptor* pAcceptor )
: m_xSMgr( rxSMgr ),
  m_pImpl( 0 ),
  m_aCommand( rCommand ),
  m_pResultSupplier( 0 )
{
	m_pImpl = new ChaosTaskBase( pOwner, this, rxEnv, pListener );

#ifdef DBG_UTIL
	if ( rCommand.Name == OUString::createFromAscii( "open" ) )
	{
		// All open tasks must supply a result acceptor or a data sink.

		if ( !pAcceptor )
		{
			OpenCommandArgument2 aArgument;
			rCommand.Argument >>= aArgument;

			if ( !aArgument.Sink.is() )
				DBG_ERROR( "ChaosCommandTask - 'open' - Invalid parameters!" );
		}
	}
#endif

	if ( pAcceptor )
	{
		m_pResultSupplier = new ResultSupplier_Impl( pAcceptor );
		StartListening( *pOwner->getAnchor() );
	}

	m_bSearchCommand = rCommand.Handle == WID_SEARCH
		               || rCommand.Name.compareToAscii("search") == 0;
}

//=========================================================================
// virtual
ChaosCommandTask::~ChaosCommandTask()
{
//  !!! m_pImpl->m_pOwner is already NULL !!! But there is no need
//  to call EndListening here, because my SfxListener dtor deregisters
//  'this' at any broadcasters it is still listening.
//	EndListening( *m_pImpl->getOwner()->getAnchor() );

	delete m_pResultSupplier;
    delete m_pImpl;
}

//=========================================================================
//
// ContentTask methods.
//
//=========================================================================

// virtual
void ChaosCommandTask::start()
{
	Any aResult = m_pImpl->run( m_aCommand.Name,
				  			  	m_aCommand.Handle,
				  			  	m_aCommand.Argument,
				  			  	sal_False ); // no forced synchronous processing
	DBG_ASSERT( !aResult.hasValue(),
				"ChaosCommandTask::start - result not supported!" );
}

//=========================================================================
// virtual
void ChaosCommandTask::execute()
	throw( Exception )
{
	Any aResult = m_pImpl->run( m_aCommand.Name,
				  			  	m_aCommand.Handle,
				  			 	m_aCommand.Argument,
				  			  	sal_True ); // forced synchronous processing

	DBG_ASSERT( !aResult.hasValue(),
				"ChaosCommandTask::execute - result not supported!" );
}

//=========================================================================
// virtual
void ChaosCommandTask::abort()
{
	m_pImpl->abort();
}

//=========================================================================
// virtual
const ContentTaskStatus& ChaosCommandTask::getStatus() const
{
	return m_pImpl->getStatus();
}

//=========================================================================
// virtual
Reference< XCommandEnvironment > ChaosCommandTask::getEnvironment() const
{
	return m_pImpl->getEnvironment();
}

//=========================================================================
//
// SfxListener methods.
//
//=========================================================================

// virtual
void ChaosCommandTask::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	// Currently(!), there is nothing to do in this method, if no
	// result supplier exists.

	if ( !m_pResultSupplier )
		return;

	//////////////////////////////////////////////////////////////////////
	// CntAnchorHint handling.
	//////////////////////////////////////////////////////////////////////

    if ( rHint.ISA( CntAnchorHint ) )
    {
        const CntAnchorHint* pAnchorHint = (const CntAnchorHint*)&rHint;
		const CntAction eAction = pAnchorHint->GetAction();
		switch ( eAction )
		{
			case CNT_ACTION_INSERTED:
				if ( m_pResultSupplier && !m_bSearchCommand )
				{
					CntNodeJob* pJob = pAnchorHint->GetJob();
					DBG_ASSERT( pJob, "ChaosCommandTask::Notify - No job!" );

					if ( !pJob )
						return;

					// Belongs event to right job?
					if ( pJob->GetCancellable( sal_False )
						 				!= m_pImpl->getCancellable() )
						return;

					// Create a ChaosContent for the inserted anchor.
					ChaosContent* pParent = m_pImpl->getOwner();
					Reference< XContent > xChild(
						pParent->getProvider()->queryContent(
									pParent, pAnchorHint->GetAnchor() ) );

					DBG_ASSERT( xChild.is(),
								"ChaosCommandTask::Notify - No child!" );

					// Let result supplier handle the child.
					Any aResult;
					aResult <<= xChild;
					m_pResultSupplier->result( aResult );
				}
				break;

			default:
				break;
		}
	}

	//////////////////////////////////////////////////////////////////////
	// CntSearchMatchedURLHint handling.
	//////////////////////////////////////////////////////////////////////

    else if ( rHint.ISA( CntSearchMatchedURLHint ) )
    {
        const CntSearchMatchedURLHint* pMatchedHint
			= (const CntSearchMatchedURLHint*)&rHint;
		if ( ( m_pImpl->getOwner()->getAnchor() == &rBC ) &&
			 m_pResultSupplier && m_bSearchCommand )
		{
			// Create a ChaosContent for the inserted anchor.
			CntAnchorRef
				xChildAnchor(new CntAnchor(0, pMatchedHint->getURL()));
			ChaosContent* pParent = m_pImpl->getOwner();
			Reference< XContent > xChild(
				pParent->getProvider()->queryContent(
							pParent, &xChildAnchor ) );

			DBG_ASSERT( xChild.is(),
						"ChaosCommandTask::Notify - No child!" );

			// Let result supplier handle the child.
			Any aResult;
			aResult <<= xChild;
			m_pResultSupplier->result( aResult );
		}
	}

	//////////////////////////////////////////////////////////////////////
	// CntStatusHint handling.
	//////////////////////////////////////////////////////////////////////

    else if ( rHint.ISA( CntStatusHint ) )
    {
        const CntStatusHint* pStatusHint = (const CntStatusHint*)&rHint;

		SfxCancellable* pCancelable = pStatusHint->GetCancelable();
		if ( pCancelable != m_pImpl->getCancellable() )
			return;

        const CntStatus eStatus = pStatusHint->GetStatus();
		switch ( eStatus )
		{
			case CNT_STATUS_DONE:
				if ( m_pResultSupplier )
					m_pResultSupplier->done();

				break;

			case CNT_STATUS_ERROR:
				if ( m_pResultSupplier )
					m_pResultSupplier->abort();

				break;

			default:
				break;
		}
	}
}

//=========================================================================
//
// Private methods.
//
//=========================================================================

//=========================================================================
//=========================================================================
//
// ChaosPropertyTask Implementation.
//
//=========================================================================
//=========================================================================

#define INIT_PROPERTYTASK() \
  m_xSMgr( rxSMgr ), \
  m_pImpl( 0 ), \
  m_aProps( Properties.getLength() ), \
  m_pUcbProps( 0 )

//=========================================================================
ChaosPropertyTask::ChaosPropertyTask(
			const Reference< XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const Reference< XCommandEnvironment >& xEnv,
		    PropertyTaskType Type,
		    const com::sun::star::uno::Sequence< PropertyValue >& Properties,
			ContentTaskStatusListener* pListener )
: INIT_PROPERTYTASK(),
  m_eType( Type )
{
	m_pImpl = new ChaosTaskBase( pOwner, this, xEnv, pListener );

	sal_Int32 nCount = Properties.getLength();

	PropertyValueInfo*   pInfos  = m_aProps.getArray();
	const PropertyValue* pValues = Properties.getConstArray();

	for ( sal_Int32 n = 0; n < nCount; ++n )
	{
		PropertyValueInfo&   rCurrInfo  = pInfos[ n ];
		const PropertyValue& rCurrValue = pValues[ n ];

		// PropertyValue memebrs
		rCurrInfo.Name		 = rCurrValue.Name;
		rCurrInfo.Handle     = rCurrValue.Handle;
		rCurrInfo.Value	     = rCurrValue.Value;
		rCurrInfo.State      = rCurrValue.State;
		// PropertyValueInfo memebrs
		rCurrInfo.ValueState = PropertyValueState_UNPROCESSED;
	}
}

//=========================================================================
ChaosPropertyTask::ChaosPropertyTask(
			const Reference< XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const Reference< XCommandEnvironment >& xEnv,
		    const com::sun::star::uno::Sequence< Property >& Properties,
			ContentTaskStatusListener* pListener )
: INIT_PROPERTYTASK(),
  m_eType( PropertyTaskType_GET )
{
	m_pImpl = new ChaosTaskBase( pOwner, this, xEnv, pListener );

	sal_Int32 nCount = Properties.getLength();

	PropertyValueInfo* pInfos = m_aProps.getArray();
	const Property*    pProps = Properties.getConstArray();

	for ( sal_Int32 n = 0; n < nCount; ++n )
	{
		PropertyValueInfo& rCurrInfo = pInfos[ n ];
		const Property&    rCurrProp = pProps[ n ];

		// Property memebrs
		rCurrInfo.Name		 = rCurrProp.Name;
		rCurrInfo.Handle     = rCurrProp.Handle;
		// PropertyValue memebrs
		rCurrInfo.Value	     = Any();
		rCurrInfo.State      = PropertyState_DIRECT_VALUE;
		// PropertyValueInfo memebrs
		rCurrInfo.ValueState = PropertyValueState_UNPROCESSED;
	}
}

//=========================================================================
ChaosPropertyTask::ChaosPropertyTask(
			const Reference< XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const Reference< XCommandEnvironment >& xEnv,
		    PropertyTaskType Type,
		    const com::sun::star::uno::Sequence< OUString >& Properties,
			const com::sun::star::uno::Sequence< Any >& Values,
			ContentTaskStatusListener* pListener )
: INIT_PROPERTYTASK(),
  m_eType( Type )
{
	m_pImpl = new ChaosTaskBase( pOwner, this, xEnv, pListener );

	sal_Int32 nCount = Properties.getLength();

	PropertyValueInfo* pInfos  = m_aProps.getArray();
	const OUString*    pNames  = Properties.getConstArray();
	const Any*         pValues = Values.getConstArray();

	for ( sal_Int32 n = 0; n < nCount; ++n )
	{
		PropertyValueInfo& rCurrInfo = pInfos[ n ];

		// PropertyValue memebrs
		rCurrInfo.Name		 = pNames[ n ];
		rCurrInfo.Handle     = -1; /* unknown */
		rCurrInfo.Value	     = pValues[ n ];
		rCurrInfo.State      = PropertyState_DIRECT_VALUE;
		// PropertyValueInfo memebrs
		rCurrInfo.ValueState = PropertyValueState_UNPROCESSED;
	}
}

//=========================================================================
// virtual
ChaosPropertyTask::~ChaosPropertyTask()
{
	delete m_pImpl;
	delete m_pUcbProps;
}

//=========================================================================
com::sun::star::uno::Sequence< PropertyValueInfo >
ChaosPropertyTask::getProperties()
{
	return m_aProps;
}

//=========================================================================
//
// ContentTask methods.
//
//=========================================================================

// virtual
void ChaosPropertyTask::start()
{
	run( sal_False );
}

//=========================================================================
// virtual
void ChaosPropertyTask::execute()
	throw( Exception )
{
	run( sal_True );
}

//=========================================================================
// virtual
void ChaosPropertyTask::abort()
{
	m_pImpl->abort();
}

//=========================================================================
// virtual
const ContentTaskStatus& ChaosPropertyTask::getStatus() const
{
	return m_pImpl->getStatus();
}

//=========================================================================
// virtual
Reference< XCommandEnvironment > ChaosPropertyTask::getEnvironment() const
{
	return m_pImpl->getEnvironment();
}

//=========================================================================
//
// Private methods.
//
//=========================================================================

sal_Bool ChaosPropertyTask::isChaosProperty(
							const OUString& rName, sal_Int32& rHandle )
{
	// Note: If a handle was given, property name will be ignored.

	if ( rHandle != -1 )
	{
		// Handle for a Chaos-Property?
        const CntItemMapEntry* pEntry
            = CNT_ITEMMAP()->Which2Prop( USHORT( rHandle ) );
		if ( pEntry && pEntry->IsProperty() )
		{
			// Chaos-Property valid for this content?
            if ( m_pImpl->getOwner()->isHandleValid( USHORT( rHandle ) ) )
				return sal_True;
		}
	}
	else
	{
		// Name for a Chaos-Property?
		rHandle = ChaosContent::queryChaosPropertyHandle( rName );
		if ( rHandle != -1 )
		{
			// Chaos-Property valid for this content?
            if ( m_pImpl->getOwner()->isHandleValid( USHORT( rHandle ) ) )
				return sal_True;
		}
	}

	return sal_False;
}

//=========================================================================
sal_Bool ChaosPropertyTask::isUcbProperty(
		const OUString& rName, sal_Int32 nHandle, PropertyValue& rProperty )
{
	if ( !m_pUcbProps )
	{
		// Cache UCB-Property values, if exist.

		Reference< XPersistentPropertySet > xSet(
					m_pImpl->getOwner()->getDynamicPropertySet( sal_False ) );
		if ( xSet.is() )
		{
			Reference< XPropertyAccess > xPropAccess( xSet, UNO_QUERY );

			DBG_ASSERT( xPropAccess.is(),
						"ChaosPropertyTask::isUcbProperty - "
						"No XPropertyAccess!" );

			if ( xPropAccess.is() )
			{
				const com::sun::star::uno::Sequence<
					PropertyValue > aValues = xPropAccess->getPropertyValues();
				m_pUcbProps = new com::sun::star::uno::Sequence<
												PropertyValue >( aValues );
			}
		}

		if ( !m_pUcbProps )
			m_pUcbProps = new com::sun::star::uno::Sequence< PropertyValue >();
	}

	if ( m_pUcbProps->getLength() )
	{
		// Note: If a handle was given, property name will be ignored.

		if ( nHandle != -1 )
		{
			// Handle for a Ucb-Property?
			sal_uInt32 nCount = m_pUcbProps->getLength();
			if ( nCount )
			{
				const PropertyValue* pValues = m_pUcbProps->getConstArray();
				for ( sal_uInt32 n = 0; n < nCount; ++n )
				{
					const PropertyValue& rValue = pValues[ n ];
					if ( rValue.Handle == nHandle )
					{
						rProperty = rValue;
						return sal_True;
					}
				}
			}
		}
		else
		{
			// Name for a Ucb-Property?
			sal_uInt32 nCount = m_pUcbProps->getLength();
			if ( nCount )
			{
				const PropertyValue* pValues = m_pUcbProps->getConstArray();
				for ( sal_uInt32 n = 0; n < nCount; ++n )
				{
					const PropertyValue& rValue = pValues[ n ];
					if ( rValue.Name == rName )
					{
						rProperty = rValue;
						return sal_True;
					}
				}
			}
		}
	}

	return sal_False;
}

//=========================================================================
sal_Bool ChaosPropertyTask::getPropertyValues()
{
	// Note that properties always will be gotten synchronously,
	// because CntAnchor::Get(...) always works synchronous, unlike
	// CntAnchor::Put(...).

	ChaosContent* pOwner  = m_pImpl->getOwner();
	CntAnchor*    pAnchor = pOwner->getAnchor();

	// Notify the begin of the task.
	m_pImpl->setStatus( ContentTaskStatus_RUNNING );

  // 1. GETDATA am Anker erzeugt ItemChanged-Hints, die am Owner ankommen
  // und von ihm an seine listener propagiert werden!!! Von dieser Methode
  // propagierte Aenderungen (s.u.) sind also u.U. redundant!!!

	// Let CHAOS retrieve data. This is always done synchronously!
	pAnchor->Put( SfxVoidItem( WID_GETDATA ) );

	sal_uInt32 nProcessed = 0;

	// Process properties.
	PropertyValueInfo* pInfos = m_aProps.getArray();
	sal_Int32 		   nCount = m_aProps.getLength();

	PropertyChangeEvent* pEvents = new PropertyChangeEvent[ nCount ];

	sal_Bool bQueriedUcbProps = sal_False;

	//////////////////////////////////////////////////////////////////////
	// Iterate over sequence and process properties to get.
	//////////////////////////////////////////////////////////////////////

	for ( sal_Int32 n = 0; n < nCount; ++n )
	{
		PropertyValueInfo& rCurrInfo = pInfos[ n ];

		const OUString& rName = rCurrInfo.Name;
		sal_Int32 nHandle 	  = rCurrInfo.Handle;

		//////////////////////////////////////////////////////////////////
		// CHAOS-Property?
		//////////////////////////////////////////////////////////////////

		sal_Bool bValidProp = isChaosProperty( rName, nHandle );

		if ( bValidProp )
		{
			//////////////////////////////////////////////////////////////
			// Get CHAOS-Property value.
			//////////////////////////////////////////////////////////////

			DBG_ASSERT( nHandle != -1,
						"ChaosPropertyTask::getPropertyValues - Invalid WID!" );

			// Special cases...

			switch ( nHandle )
			{
				case WID_HTTP_COOKIE:
					// This synchronously(!) fills WID_HTTP_COOKIE!
					pAnchor->Put( SfxVoidItem( WID_HTTP_GET_COOKIE ) );
					break;

				default:
					break;
			}

			const SfxPoolItem* pItem = NULL;
			SfxItemState eState =
				pAnchor->GetItemState( (sal_uInt16)nHandle, TRUE, &pItem );

			if ( !pItem )
				pItem = &pAnchor->Get( (sal_uInt16)nHandle );

			// Get item value as Any.
			if ( !pItem->QueryValue( rCurrInfo.Value ) )
			{
				DBG_ERROR(
					"ChaosPropertyTask::getPropertyValues - Not QueryValue!" );
				rCurrInfo.ValueState = PropertyValueState_INVALID_TYPE;
				continue;
			}

			switch ( eState )
			{
				case SFX_ITEM_DEFAULT:
					rCurrInfo.State = PropertyState_DEFAULT_VALUE;
					break;

				case SFX_ITEM_SET:
				default:
					rCurrInfo.State = PropertyState_DIRECT_VALUE;
					break;
			}
		}
		else
		{
			nHandle = rCurrInfo.Handle;

			//////////////////////////////////////////////////////////////
			// UCB-Property?
			//////////////////////////////////////////////////////////////

			PropertyValue aValue;
			bValidProp = isUcbProperty( rName, nHandle, aValue );

			if ( bValidProp )
			{
				//////////////////////////////////////////////////////
				// Get UCB-Property value.
				//////////////////////////////////////////////////////
				rCurrInfo.State = aValue.State;
				rCurrInfo.Value = aValue.Value;
			}
		}

		if ( !bValidProp )
		{
			// Neither a CHAOS- nor a UCB-Property!
			rCurrInfo.ValueState = PropertyValueState_INVALID_NAME;
			continue;
		}

		//////////////////////////////////////////////////////////////////
		// Property successfully gotten!
		//////////////////////////////////////////////////////////////////

		ChaosContent::translatePropertyValue(
							rName, rCurrInfo.Value, TRANSLATE_TO_EXTERNAL );
		rCurrInfo.ValueState = PropertyValueState_PROCESSED;

		// Special handling for content type...

		if ( rName.compareToAscii( "ContentType" ) == 0 )
		{
			OUString aValue;
			if ( rCurrInfo.Value >>= aValue )
			{
				if ( aValue.getLength() == 0 )
				{
					// Empty content type string ==> translatePropertyValue
					// found any non ".chaos" type and erased that value, which
					// is illegal for content type property value. We can only
					// try to obtain the original ".chaos" type from the
					// anchors CntDefaults object...
					const SfxItemSet* pDefaults = pAnchor;
					while ( pDefaults->SfxItemSet::GetParent() )
						pDefaults = pDefaults->SfxItemSet::GetParent();

					const SfxPoolItem& rItem = pDefaults->Get(
														WID_CONTENT_TYPE );
					rItem.QueryValue( rCurrInfo.Value );
					ChaosContent::translatePropertyValue(
							rName, rCurrInfo.Value, TRANSLATE_TO_EXTERNAL );
				}
			}
		}

		PropertyChangeEvent& rEvent = pEvents[ nProcessed ];

		// Fill event object for processed property...
		rEvent.Source 	      = *m_pImpl->getOwner();
		rEvent.PropertyName   = rCurrInfo.Name;
		rEvent.PropertyHandle = rCurrInfo.Handle;
		rEvent.Further        = sal_False;
		rEvent.OldValue       = Any(); // ???
		rEvent.NewValue       = rCurrInfo.Value;

		nProcessed++;
	}

	if ( !nProcessed )
	{
		delete [] pEvents;
		pEvents = 0;
//		m_pImpl->setStatus( ContentTaskStatus_ABORTED );
//		return sal_False;
	}

	if ( pEvents )
	{
		// Notify the properties successfully gotten.
		const com::sun::star::uno::Sequence<
					PropertyChangeEvent > aEvents( pEvents, nProcessed );
		delete [] pEvents;

		m_pImpl->getOwner()->notifyPropertiesChange( aEvents );
	}

	m_pImpl->setStatus( ContentTaskStatus_DONE );
	return sal_True;
}

//----------------------------------------------------------------------------
sal_Bool ChaosPropertyTask::setPropertyValues( sal_Bool bSynchronous )
{
	ChaosContent* pOwner  = m_pImpl->getOwner();
	CntAnchor*    pAnchor = pOwner->getAnchor();

	PropertyValueInfo* pInfos = m_aProps.getArray();
	sal_Int32 nCount = m_aProps.getLength();

	SfxItemSet aSet( *pAnchor->GetPool(), pAnchor->REAL_RANGES() );
	SfxPoolItem* pItem = NULL;

	com::sun::star::uno::Sequence< PropertyValue > aUcbProps( nCount );
	PropertyValue* pUcbProps = aUcbProps.getArray();
	sal_uInt32 nUcbProps = 0;

	for ( sal_Int32 n = 0; n < nCount; ++n )
	{
		PropertyValueInfo& rCurrInfo = pInfos[ n ];

		const OUString& rName = rCurrInfo.Name;
		sal_Int32 nHandle 	  = rCurrInfo.Handle;

		//////////////////////////////////////////////////////////////////
		// CHAOS-Property?
		//////////////////////////////////////////////////////////////////

		sal_Bool bValidProp = isChaosProperty( rName, nHandle );

		if ( bValidProp )
		{
			// Get item from anchor and clone it ( Virtual ctor ).
			pItem =
				pAnchor->GetPool()->GetDefaultItem( (USHORT)nHandle ).Clone();
			if ( pItem )
			{
				Any aValue( rCurrInfo.Value );

				ChaosContent::translatePropertyValue(
								rName, aValue, TRANSLATE_TO_INTERNAL );

				// Set item value as Any.
				if ( !pItem->PutValue( aValue ) )
				{
					DBG_ERROR( "ChaosPropertyTask::setPropertyValues - "
				           	   "Not PutValue!" );
					rCurrInfo.ValueState = PropertyValueState_INVALID_TYPE;
					continue;
				}

				aSet.Put( *pItem );
			}
		}
		else
		{
			nHandle = rCurrInfo.Handle;

			//////////////////////////////////////////////////////////////
			// UCB-Property?
			//////////////////////////////////////////////////////////////

			PropertyValue aValue;
			bValidProp = isUcbProperty( rName, nHandle, aValue );

			if ( bValidProp )
			{
				Any aValue( rCurrInfo.Value );
				ChaosContent::translatePropertyValue(
								rName, aValue, TRANSLATE_TO_INTERNAL );

				PropertyValue& rProp = pUcbProps[ nUcbProps ];
				rProp 		= rCurrInfo;
				rProp.Value = aValue;
				nUcbProps++;
			}
		}

		if ( !bValidProp )
		{
			rCurrInfo.ValueState = PropertyValueState_INVALID_NAME;
			continue;
		}
	}

	ULONG nChaosProps = aSet.Count();

	if ( !nChaosProps && !nUcbProps )
	{
		m_pImpl->setStatus( ContentTaskStatus_RUNNING );
		m_pImpl->setStatus( ContentTaskStatus_DONE );
		return sal_True;
	}

	if ( nUcbProps )
	{
		aUcbProps.realloc( nUcbProps );

		Reference< XPersistentPropertySet > xPropSet(
					m_pImpl->getOwner()->getDynamicPropertySet( sal_False ) );
		if ( xPropSet.is() )
		{
			Reference< XPropertyAccess > xPropAccess( xPropSet, UNO_QUERY );

			DBG_ASSERT( xPropAccess.is(),
						"ChaosPropertyTask::setPropertyValues - "
						"No XPropertyAccess!" );

			if ( xPropAccess.is() )
			{
				m_pImpl->setStatus( ContentTaskStatus_RUNNING );

				// Create a proxy for property change notifications.
				Reference< XPropertyChangeListener > xProxy(
										new ChaosPropertyTaskProxy( this ) );
				try
				{
					xPropSet->addPropertyChangeListener( OUString(), xProxy );
					xPropAccess->setPropertyValues( aUcbProps );
				}
				catch ( UnknownPropertyException& )
				{
				}
				catch ( PropertyVetoException& )
				{
				}
				catch ( IllegalArgumentException& )
				{
				}
				catch ( WrappedTargetException& )
				{
				}

				try
				{
					xPropSet->removePropertyChangeListener(
													OUString(), xProxy );
				}
				catch ( WrappedTargetException& )
				{
				}
				catch ( UnknownPropertyException& )
				{
				}

				if ( !nChaosProps )
					m_pImpl->setStatus( ContentTaskStatus_DONE );
			}
		}
	}

	if ( nChaosProps )
	{
		if ( nChaosProps == 1 )
		{
			DBG_ASSERT( pItem,
						"ChaosPropertyTask::setPropertyValues - No item!" );

			// Set single CHAOS-Property.
			m_pImpl->run( *pItem, bSynchronous );

			// Do not delete pItem!
		}
		else
		{
			// Create PUTDATA-Request from itemset. This is the
			// way CHAOS handles multiple items to put at once.
			CntItemListItem aPutDataItem( WID_PUTDATA, aSet );

			m_pImpl->run( aPutDataItem, bSynchronous );
		}
	}

	return sal_True;
}

//=========================================================================
void ChaosPropertyTask::run( sal_Bool bSynchronous )
{
	if ( !m_pImpl->queryRun() )
	{
		DBG_ERROR( "ChaosPropertyTask::run - No multiple runs!!!" );
		return;
	}

	if ( m_eType == PropertyTaskType_GET )
	{
		getPropertyValues();
	}
	else
	{
		setPropertyValues( bSynchronous );
	}
}

//=========================================================================
void ChaosPropertyTask::propertyChange( const PropertyChangeEvent& evt )
{
	const OUString& rName = evt.PropertyName;
	sal_Int32 nHandle = evt.PropertyHandle;

	const PropertyValueInfo* pInfos = m_aProps.getConstArray();
	sal_Int32 nCount = m_aProps.getLength();
	for ( sal_Int32 n = 0; n < nCount; ++n )
	{
		const PropertyValueInfo& rInfo = pInfos[ n ];
		if ( ( rInfo.Handle == nHandle ) || ( rInfo.Name == rName ) )
		{
			PropertyChangeEvent aEvt( evt );
			aEvt.Source = *m_pImpl->getOwner();

			ChaosContent::translatePropertyValue( aEvt.PropertyName,
												  aEvt.OldValue,
												  TRANSLATE_TO_EXTERNAL );
			ChaosContent::translatePropertyValue( aEvt.PropertyName,
												  aEvt.NewValue,
												  TRANSLATE_TO_EXTERNAL );

			m_pImpl->getOwner()->notifyPropertyChange( aEvt );
		}
	}
}

