/*************************************************************************
 *
 *  $RCSfile: tasks.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Kai Sommerfeld ( kso@sun.com )
 *
 *
 ************************************************************************/

#ifndef _TASKS_HXX
#define _TASKS_HXX

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMAND_HPP_
#include <com/sun/star/ucb/Command.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_PROPERTYVALUEINFO_HPP_
#include <com/sun/star/ucb/PropertyValueInfo.hpp>
#endif

#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif

#ifndef CHAOS_TASKBASE_HXX
#include "taskbase.hxx"
#endif

namespace com { namespace sun { namespace star {
	namespace beans { struct PropertyChangeEvent;
					  struct Property; }
	namespace ucb 	{ class XCommandEnvironment; }
} } }


namespace chaos {

class ChaosPropertyTaskProxy;

//=========================================================================

class ResultAcceptor
{
public:
    virtual sal_Bool usePartialResultChannel() = 0;
    virtual void partialResult( const ::com::sun::star::uno::Any& Result ) = 0;
    virtual void completeResult( const ::com::sun::star::uno::Any& Result )  = 0;
};

//=========================================================================

class ChaosContent;
class ResultSupplier_Impl;

class ChaosCommandTask : public ContentTask, public SfxListener
{
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > m_xSMgr;
	com::sun::star::ucb::Command m_aCommand;
	ChaosTaskBase*				 m_pImpl;
	ResultSupplier_Impl*		 m_pResultSupplier;
	sal_Bool					 m_bSearchCommand;

public:
	ChaosCommandTask(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const com::sun::star::ucb::Command& rCommand,
			const com::sun::star::uno::Reference<
				com::sun::star::ucb::XCommandEnvironment >& rxEnv,
			ContentTaskStatusListener* pListener = 0,
			ResultAcceptor* pAcceptor = 0 );
	virtual ~ChaosCommandTask();

    com::sun::star::ucb::Command getCommand() const { return m_aCommand; }

	// ContentTask
    virtual void start();
    virtual void execute()
		throw( com::sun::star::uno::Exception );
    virtual void abort();
    virtual const ContentTaskStatus& getStatus() const;
    virtual com::sun::star::uno::Reference<
		com::sun::star::ucb::XCommandEnvironment > getEnvironment() const;

	// SfxListener
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	// Non-interface nethods
	inline com::sun::star::ucb::Command const & accessCommand() const
	{ return m_aCommand; }
};

//=========================================================================

enum PropertyTaskType
{
    PropertyTaskType_GET = 0,
    PropertyTaskType_SET = 1
};

//=========================================================================

class ChaosPropertyTask : public ContentTask
{
	friend class chaos::ChaosPropertyTaskProxy;

	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > m_xSMgr;
	PropertyTaskType m_eType;
	com::sun::star::uno::Sequence< com::sun::star::ucb::PropertyValueInfo > m_aProps;
	com::sun::star::uno::Sequence< com::sun::star::beans::PropertyValue >* m_pUcbProps;
	ChaosTaskBase*	m_pImpl;

private:
	sal_Bool isChaosProperty( const rtl::OUString& rName,
							  sal_Int32& rHandle );
	sal_Bool isUcbProperty  ( const rtl::OUString& rName,
							  sal_Int32 nHandle,
							  com::sun::star::beans::PropertyValue& rProperty );
	sal_Bool getPropertyValues();
	sal_Bool setPropertyValues( sal_Bool bSynchronous );
	void run( sal_Bool bSynchronous );
    void propertyChange( const com::sun::star::beans::PropertyChangeEvent& evt );

public:
	ChaosPropertyTask(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const com::sun::star::uno::Reference<
				com::sun::star::ucb::XCommandEnvironment >& aEnv,
		   	PropertyTaskType Type,
			const com::sun::star::uno::Sequence<
				com::sun::star::beans::PropertyValue >& Properties,
			ContentTaskStatusListener* pListener = 0 );
	ChaosPropertyTask(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const com::sun::star::uno::Reference<
				com::sun::star::ucb::XCommandEnvironment >& aEnv,
			const com::sun::star::uno::Sequence<
				com::sun::star::beans::Property >& Properties,
			ContentTaskStatusListener* pListener = 0 );
	ChaosPropertyTask(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const com::sun::star::uno::Reference<
				com::sun::star::ucb::XCommandEnvironment >& aEnv,
			PropertyTaskType Type,
			const com::sun::star::uno::Sequence< rtl::OUString >& Properties,
			const com::sun::star::uno::Sequence< com::sun::star::uno::Any >& Values,
			ContentTaskStatusListener* pListener = 0 );
	virtual ~ChaosPropertyTask();

    const PropertyTaskType& getType() const { return m_eType; }
    com::sun::star::uno::Sequence< com::sun::star::ucb::PropertyValueInfo >
	getProperties();

	// ContentTask
    virtual void start();
    virtual void execute()
		throw( com::sun::star::uno::Exception );
    virtual void abort();
    virtual const ContentTaskStatus& getStatus() const;
    virtual com::sun::star::uno::Reference<
		com::sun::star::ucb::XCommandEnvironment > getEnvironment() const;
};

} // namespace chaos

#endif /* !_TASKS_HXX */
