/*************************************************************************
 *
 *  $RCSfile: cntbase.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:19:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SVTOOLS_STRCRYPT_HXX_
#include <svtools/strcrypt.hxx>
#endif

#include <cntbase.hxx>

#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CNTDATA_HXX
#include <cntdata.hxx>
#endif
#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

namespace unnamed_chaos_cntbase {} using namespace unnamed_chaos_cntbase;
	// unnamed namespaces don't work well yet...

using namespace chaos;

//============================================================================
ByteString chaos::CntStringDecode(bool bNew, ByteString const & rSource)
{
	if (bNew)
		return SvStringDecode(rSource);
	else
	{
		static sal_Char const aCodeKey[] = "_:;*?()/&[&";

		ByteString aTarget;
		sal_Char * p = aTarget.AllocBuffer(rSource.Len() / 2);
		sal_Char const * q = aCodeKey;
		for (xub_StrLen i = 0; i + 1 < rSource.Len(); i += 2)
		{
			*p++ = (((rSource.GetChar(i) - 'a') << 4)
					        | (rSource.GetChar(i + 1) - 'a'))
				       ^ *q;
			if (*++q == '\0')
				q = aCodeKey;
		}
		return aTarget;
	}
}

//============================================================================
BOOL chaos::NormalizeURL( String& rURL )
{
	// This function converts a given URL to a CHAOS-conform one.
	// It is called very often and must be as fast as possible!

	if ( rURL.Len() < 3 )
	{
		DBG_WARNING( "NormalizeURL - Invalid URL!" );
		return FALSE;
	}

	// Dummy URL?
	if ( ( rURL.GetChar( rURL.Len() - 3 ) == ':' ) &&
		 ( rURL.GetChar( rURL.Len() - 2 ) == '/' ) &&
		 ( rURL.GetChar( rURL.Len() - 1 ) == '/' ) )
		return TRUE;

	String aURL( rURL );
	String aExtProt;

	// Is there one of our own protocol prefixes in URL?
	if ( rURL.GetChar( 0 ) == '.' )
	{
		xub_StrLen nPos = rURL.Search( ':' );
		if ( nPos != STRING_NOTFOUND )
		{
			nPos++;
			aExtProt = rURL.Copy( 0, nPos );
			if ( ( aExtProt.EqualsAscii( STG_PROTOCOL_USER ) ) ||
				 	// user data node
				 ( aExtProt.EqualsAscii( STG_PROTOCOL_CACHE ) ) )
					// cache/directory node
				aURL = rURL.Copy( nPos );
			else
				aExtProt.Erase();
		}
	}

	CntURLTransformer::ToInternalURL( aURL );

	INetURLObject aURLObject( aURL );
	if ( aURLObject.HasError() )
	{
		DBG_WARNING( "NormalizeURL - Invalid URL!" );
		return FALSE;
	}

	const String aOrigURL( rURL );

	INetProtocol eProt = aURLObject.GetProtocol();
	if ( eProt == INET_PROT_DB )
	{
		// Workaround: URL Object returns garbage when calling any
		//			   methods for DB URL's ( last checked: 397C )!
		return TRUE;
	}

	aURLObject.SetHost(aURLObject.GetHost(INetURLObject::DECODE_WITH_CHARSET).
					       ToLowerAscii(),
					   INetURLObject::ENCODE_ALL);

#ifndef CASE_SENSITIVE_USERNAMES
	if (!aURLObject.IsEmptyUser() && eProt != INET_PROT_VIM)
		aURLObject.
			SetUser(aURLObject.GetUser(INetURLObject::DECODE_WITH_CHARSET).
					    ToLoweAscii(),
					INetURLObject::ENCODE_ALL);
#endif /* CASE_SENSITIVE_USERNAMES */

	// URL-Object does some normalization by itself :-)
	aURL = aURLObject.GetMainURL(INetURLObject::NO_DECODE);

	// add special protocol tag, if any
	rURL = aExtProt;
	rURL += aURL;

	switch ( eProt )
	{
		case INET_PROT_NEWS:
			// No '/' after "news:"? - Not very clean method, but fast!
			if ( aURL.GetChar( 5 ) != '/' )
			{
				// news:group_name -> news://default_servername/group_name
				// news:message-id -> news://default_servername/message_id

				// get default news server from global user settings
				String aHost( CNT_RNM()->GetIniManager()
							            ->getEntry( CNT_KEY_INET_NNTPSERVER ) );

				if ( aHost.Len() == 0 )
				{
					// error - unable to get default server
					DBG_WARNING( "NormalizeURL - Invalid URL!" );
					return FALSE;
				}

// Bug im URL-Objekt: Es werden nicht die beiden slashes eingefuegt!
//					aURLObject.SetHost( aHost );
//					aURL = aURLObject.GetMainURL();

				xub_StrLen nPos = aURL.Search( ':' );
				aHost += '/';
				nPos++; 				// now after news:
				aURL.InsertAscii( "//", nPos );
				nPos += 2; 				// now after news://
				aURL.Insert( aHost.ToLowerAscii(), nPos );
				nPos += aHost.Len();  	// now after news://server/

				// message_id?
				if ( aURL.Search( '@', nPos ) != STRING_NOTFOUND )
				{
					// message_id not included in <>?
					if ( aURL.GetChar( nPos ) != '<' )
						aURL.Insert( '<', nPos );

					if ( aURL.GetChar( aURL.Len() - 1 ) != '>' )
						aURL += '>';
				}

				// add special protocol tag, if any
				rURL = aExtProt;
				rURL += aURL;

				break;
			}

			// Note: fall-thru is okay, to check server name.

		case INET_PROT_POP3:
		case INET_PROT_FTP:
			if ( aURLObject.GetHost().Len() == 0 )
  			{
				DBG_WARNING( "NormalizeURL - Invalid URL!" );
				return FALSE;
			}
			break;

		case INET_PROT_IMAP:
		{
			String aCanonicURL;
			if (!CntIMAPAcntNode::makeCanonicURL(aURL, aCanonicURL))
				return FALSE;
			rURL = aExtProt;
			rURL += aCanonicURL;
			break;
		}

		case INET_PROT_HTTP:
		case INET_PROT_HTTPS:
			rURL = aExtProt;
			rURL.
				AppendAscii(RTL_CONSTASCII_STRINGPARAM(URL_PREFIX_PRIV_SOFFICE
													       "httpcache#"));
			rURL += aURLObject.GetMainURL(INetURLObject::NO_DECODE);
			break;

	} // end switch

	return TRUE;
}

//============================================================================
//
//  Checking Protocol Specific Values for Validity
//
//============================================================================

namespace unnamed_chaos_cntbase {

ErrCode checkProtSpecINetHost(const String & rValue)
{
	if (rValue.Len() == 0)
		return ERRCODE_NONE;

	sal_Unicode const * p = rValue.GetBuffer();
	sal_Unicode const * pEnd = p + rValue.Len();
	String aCanonic;
	return INetURLObject::parseHost(p, pEnd, false, INetURLObject::ENCODE_ALL,
									RTL_TEXTENCODING_UTF8, aCanonic)
		   && p == pEnd ?
		       ERRCODE_NONE : ERRCODE_CHAOS_SERVERNAME_SYNTAX;
}

ErrCode checkProtSpecINetHostPort(const String & rValue, BOOL bMustBeNonEmpty)
{
	if (rValue.Len() == 0)
		return bMustBeNonEmpty ? ERRCODE_CHAOS_EMPTY_SERVERNAME :
		                         ERRCODE_NONE;

	sal_Unicode const * p = rValue.GetBuffer();
	sal_Unicode const * pEnd = p + rValue.Len();
	String aCanonic;
	if (!INetURLObject::parseHost(p, pEnd, false, INetURLObject::ENCODE_ALL,
								  RTL_TEXTENCODING_UTF8, aCanonic))
		return ERRCODE_CHAOS_SERVERNAME_SYNTAX;

	if (p != pEnd)
		if (*p == ':')
			while (p != pEnd)
			{
				if (!INetMIME::isDigit(rValue.GetChar(*p++)))
					return ERRCODE_CHAOS_SERVER_PORT_SYNTAX;
			}
		else
			return ERRCODE_CHAOS_SERVERNAME_SYNTAX;

	return ERRCODE_NONE;
}

enum CheckProtSpecMode { CheckProtSpec_User,
						 CheckProtSpec_NonEmpty_User,
						 CheckProtSpec_Password,
						 CheckProtSpec_Account };

ErrCode checkProtSpecINet(const String & rValue, CheckProtSpecMode eMode)
{
	if (eMode == CheckProtSpec_NonEmpty_User && rValue.Len() == 0)
		return ERRCODE_CHAOS_EMPTY_USERNAME;
	for (xub_StrLen i = 0; i < rValue.Len(); ++i)
		if (INetMIME::isControl(rValue.GetChar(i)))
			switch (eMode)
			{
				case CheckProtSpec_Password:
					return ERRCODE_CHAOS_PASSWORD_SYNTAX;

				case CheckProtSpec_Account:
					return ERRCODE_CHAOS_ACCOUNT_SYNTAX;

				default:
					return ERRCODE_CHAOS_USERNAME_SYNTAX;
			}
	return ERRCODE_NONE;
}

ErrCode checkProtSpecHTTP(const String & rValue, CheckProtSpecMode eMode)
{
	if (eMode == CheckProtSpec_NonEmpty_User && rValue.Len() == 0)
		return ERRCODE_CHAOS_EMPTY_USERNAME;
	for (xub_StrLen i = 0; i < rValue.Len(); ++i)
	{
		sal_Unicode cChar = rValue.GetChar(i);
		if (INetMIME::isControl(cChar)
			|| cChar == ':' && eMode != CheckProtSpec_Password)
			return eMode == CheckProtSpec_Password ?
				       ERRCODE_CHAOS_PASSWORD_SYNTAX :
			           ERRCODE_CHAOS_USERNAME_SYNTAX;
	}
	return ERRCODE_NONE;
}

ErrCode checkProtSpecVIM(const String & rValue, CheckProtSpecMode eMode)
{
	if (eMode == CheckProtSpec_NonEmpty_User && rValue.Len() == 0)
		return ERRCODE_CHAOS_EMPTY_USERNAME;
	for (xub_StrLen i = 0; i < rValue.Len(); ++i)
	{
		if (rValue.GetChar(i) == '\0')
			return eMode == CheckProtSpec_Password ?
				       ERRCODE_CHAOS_PASSWORD_SYNTAX :
			           ERRCODE_CHAOS_USERNAME_SYNTAX;
	}
	return ERRCODE_NONE;
}

enum CheckProtSpecProtocol { CheckProtSpec_IMAP,
							 CheckProtSpec_POP3,
							 CheckProtSpec_SMTP,
							 CheckProtSpec_NNTP,
							 CheckProtSpec_FTP,
							 CheckProtSpec_HTTP,
							 CheckProtSpec_FILE,
							 CheckProtSpec_VIM,
							 CheckProtSpec_other };

ErrCode checkProtSpecValue(CheckProtSpecProtocol eProto, USHORT nWhich,
						   const String & rValue)
{
	switch (eProto)
	{
		case CheckProtSpec_IMAP:
			switch (nWhich)
			{
				case WID_SERVERNAME:
					return checkProtSpecINetHostPort(rValue, TRUE);

				case WID_USERNAME:
					return rValue.Len() ?
					        ERRCODE_NONE : ERRCODE_CHAOS_EMPTY_USERNAME;

				case WID_PASSWORD:
					return ERRCODE_NONE;
			}
			break;

		case CheckProtSpec_POP3:
			switch (nWhich)
			{
				case WID_SERVERNAME:
					return checkProtSpecINetHostPort(rValue, TRUE);

				case WID_USERNAME:
					return checkProtSpecINet(rValue,
											 CheckProtSpec_NonEmpty_User);

				case WID_PASSWORD:
					return checkProtSpecINet(rValue, CheckProtSpec_Password);
			}
			break;

		case CheckProtSpec_SMTP:
			switch (nWhich)
			{
				case WID_SEND_SERVERNAME:
					return checkProtSpecINetHostPort(rValue, FALSE);
			}
			break;

		case CheckProtSpec_NNTP:
			switch (nWhich)
			{
				case WID_SERVERNAME:
					return checkProtSpecINetHostPort(rValue, TRUE);

				case WID_USERNAME:
					return checkProtSpecINet(rValue, CheckProtSpec_User);

				case WID_PASSWORD:
					return checkProtSpecINet(rValue, CheckProtSpec_Password);

				case WID_SEND_SERVERNAME:
					return checkProtSpecINetHostPort(rValue, FALSE);

				case WID_SEND_USERNAME:
					return checkProtSpecINet(rValue, CheckProtSpec_User);

				case WID_SEND_PASSWORD:
					return checkProtSpecINet(rValue, CheckProtSpec_Password);
			}
			break;

		case CheckProtSpec_FTP:
			switch (nWhich)
			{
				case WID_SERVERNAME:
					return checkProtSpecINetHostPort(rValue, TRUE);

				case WID_USERNAME:
					return checkProtSpecINet(rValue, CheckProtSpec_User);

				case WID_PASSWORD:
					return checkProtSpecINet(rValue, CheckProtSpec_Password);

				case WID_FTP_ACCOUNT:
					return checkProtSpecINet(rValue, CheckProtSpec_Account);
			}
			break;

		case CheckProtSpec_HTTP:
			switch (nWhich)
			{
				case WID_SERVERNAME:
					return checkProtSpecINetHostPort(rValue, TRUE);

				case WID_USERNAME:
					return checkProtSpecHTTP(rValue, CheckProtSpec_User);

				case WID_PASSWORD:
					return checkProtSpecHTTP(rValue, CheckProtSpec_Password);
			}
			break;

		case CheckProtSpec_FILE:
			switch (nWhich)
			{
				case WID_SERVERNAME:
					return checkProtSpecINetHost(rValue);
			}
			break;

		case CheckProtSpec_VIM:
			switch (nWhich)
			{
				case WID_USERNAME:
					return checkProtSpecVIM(rValue,
											CheckProtSpec_NonEmpty_User);

				case WID_PASSWORD:
					return checkProtSpecVIM(rValue, CheckProtSpec_Password);

				case WID_SEND_USERNAME:
					return checkProtSpecVIM(rValue, CheckProtSpec_User);

				case WID_SEND_PASSWORD:
					return checkProtSpecVIM(rValue, CheckProtSpec_Password);
			}
			break;
	}
	return ERRCODE_NONE;
}

}

ErrCode chaos::CheckProtSpecValue(CntMsgProtocolType eProtocol, USHORT nWhich,
								  const String & rValue)
{
	CheckProtSpecProtocol eProto;
	switch (eProtocol)
	{
		case CNT_MSG_PROTOCOL_IMAP:
			eProto = CheckProtSpec_IMAP;
			break;

		case CNT_MSG_PROTOCOL_POP3:
			eProto = CheckProtSpec_POP3;
			break;

		case CNT_MSG_PROTOCOL_SMTP:
			eProto = CheckProtSpec_SMTP;
			break;

		case CNT_MSG_PROTOCOL_NNTP:
			eProto = CheckProtSpec_NNTP;
			break;

		case CNT_MSG_PROTOCOL_VIM:
			eProto = CheckProtSpec_VIM;
			break;

		default:
			eProto = CheckProtSpec_other;
			break;
	}
	return checkProtSpecValue(eProto, nWhich, rValue);
}

ErrCode chaos::CheckProtSpecValue(INetProtocol eProtocol, USHORT nWhich,
								  const String & rValue)
{
	CheckProtSpecProtocol eProto;
	switch (eProtocol)
	{
		case INET_PROT_IMAP:
			eProto = CheckProtSpec_IMAP;
			break;

		case INET_PROT_POP3:
			eProto = CheckProtSpec_POP3;
			break;

		case INET_PROT_NEWS:
			eProto = CheckProtSpec_NNTP;
			break;

		case INET_PROT_FTP:
			eProto = CheckProtSpec_FTP;
			break;

		case INET_PROT_HTTP:
			eProto = CheckProtSpec_HTTP;
			break;

		case INET_PROT_FILE:
			eProto = CheckProtSpec_FILE;
			break;

		case INET_PROT_VIM:
			eProto = CheckProtSpec_VIM;
			break;

		default:
			eProto = CheckProtSpec_other;
			break;
	}
	return checkProtSpecValue(eProto, nWhich, rValue);
}

//============================================================================
//
// CntInterface Implementation.
//
//============================================================================

TYPEINIT0( CntInterface );

//----------------------------------------------------------------------------
CntInterface::CntInterface()
: SfxItemSet( *CNT_POOL(), TRUE ) // use complete pool range
{
}

//----------------------------------------------------------------------------
CntInterface::CntInterface( const USHORT *pRanges )
: SfxItemSet( *CNT_POOL(), pRanges )
{
}

//----------------------------------------------------------------------------
// virtual
CntInterface::~CntInterface()
{
}

//----------------------------------------------------------------------------
// virtual
void CntInterface::Changed( const SfxPoolItem& rOld, const SfxPoolItem& rNew )
{
	BROADCAST( this, SfxItemChangedHint( rOld, rNew ) );
}

//----------------------------------------------------------------------------
// virtual
void CntInterface::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	if ( rHint.ISA( SfxItemChangedHint ) )
	{
		if ( rBC.ISA( CntInterface ) )
		{
			CntInterface* pBC = (CntInterface*)&rBC;
			if ( pBC == SfxItemSet::GetParent() )
			{
				const SfxItemChangedHint *pItemHint =
									(const SfxItemChangedHint*)&rHint;
				if ( GetItemState( pItemHint->GetNewItem().Which(), FALSE )
					 == SFX_ITEM_SET )
				{
					// Suppress hint in case I have a "hard" value for the
					// property just changed in my parent's itemset. That
					// value will not be accessable by my listeners!
					return;
				}
			}
		}

		CntInterfaceRef xRef( this );
		Broadcast( rHint );
	}
	else if ( rHint.ISA( CntItemStateChangedHint ) )
	{
		CntInterfaceRef xRef( this );
		Broadcast( rHint );
	}
}

//----------------------------------------------------------------------------
// virtual
int CntInterface::Put( const SfxItemSet& rSet, BOOL bInvalidAsDefault )
{
	// This Put is needed to avoid the creation of new jobs, when Put is called
	// for an anchor to store an itemset. ( CntAnchor::Put creates new jobs and
	// is called from SfxItemSet::Put()! )

	BOOL bRet = FALSE;
	SfxItemIter aIter( rSet );

	for ( const SfxPoolItem *pItem = aIter.FirstItem();
		  pItem;
		  pItem = aIter.NextItem() )
	{
		if (IsInvalidItem (pItem))
		{
			USHORT nWhich = rSet.GetWhichByPos (aIter.GetCurPos());
			SfxItemSet::InvalidateItem (nWhich);
		}
		else
		{
			bRet |= !!SfxItemSet::Put (*pItem, pItem->Which());
		}
	}

	return bRet;
}

//----------------------------------------------------------------------------
// virtual
FASTBOOL CntInterface::IsItemFlag( USHORT nWID, USHORT nFlag ) const
{
	return GetPool()->IsItemFlag( nWID, nFlag );
}

//----------------------------------------------------------------------------
// virtual
void CntInterface::DisableItem( USHORT nWhich )
{
	SfxItemState eOldState = GetItemState( nWhich );

	SfxItemSet::DisableItem( nWhich );

	if ( eOldState > SFX_ITEM_DISABLED )
		Broadcast( CntItemStateChangedHint( nWhich, CNT_ITEM_DISABLED ) );
}

//----------------------------------------------------------------------------
// virtual
USHORT CntInterface::ClearItem( USHORT nWhich )
{
	SfxItemState eOldState = GetItemState( nWhich );

	USHORT nRet = SfxItemSet::ClearItem( nWhich );

	if ( eOldState <= SFX_ITEM_DISABLED )
		Broadcast( CntItemStateChangedHint( nWhich, CNT_ITEM_CLEARED ) );

	return nRet;
}

//============================================================================
//
// CntItemStateChangedHint Implementation.
//
//============================================================================

TYPEINIT1( CntItemStateChangedHint, SfxHint );

//============================================================================
//
// CntTransferHint Implementation.
//
//============================================================================

TYPEINIT1( CntTransferHint, SfxHint );

//============================================================================
//
// CntStatusHint Implementation.
//
//============================================================================

TYPEINIT1( CntStatusHint, SfxHint );

//============================================================================
//
// CntStatusBarHint Implementation.
//
//============================================================================

TYPEINIT1( CntStatusBarHint, SfxHint );

//----------------------------------------------------------------------------
//static
USHORT CntStatusBarHint::CreateHintId()
{
	static USHORT nId = 0;
	nId++;
	return nId;
}

//============================================================================
//
// CntFolderStateHint Implementation.
//
//============================================================================

TYPEINIT1( CntFolderStateHint, SfxHint );

