/*************************************************************************
 *
 *  $RCSfile: cntdefs.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif

#include <cntdefs.hxx>

#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif

using namespace chaos;

//============================================================================

CntDefaults::CntDefaults( CntNode &rNode,
						  const USHORT* pWhichPairTable,
						  const CntDefaults * pParent /* = NULL */ )
:	SfxItemSet( *rNode.GetPool(),
				pWhichPairTable ? pWhichPairTable : rNode.GetRanges() ),
	_aType( rNode.Type() )
{
	if ( pParent )
	{
		// Transfer values from parent to me.
		Put( *pParent );
	}

	ULONG nFacCount = rNode.FactoryCount();
	if ( nFacCount )
	{
		// Item for New-Menu
		CntItemListItem aNewMenuItem( WID_CREATE_NEW, GetPool() );
		for ( ULONG n = 0; n < nFacCount; ++n )
		{
			CntNodeFactory* pFac = rNode.GetFactory( n );

			if ( !pFac->GetId() )
				continue;

			// Only "standard" flag set indicates that the factory cannot
			// create nodes via New-Menu.
			if ( pFac->GetFlags() == CNT_CREATION_FLAG_STANDARD )
				continue;

			CntItemListItem *pSubNodeFacItem =
						new CntItemListItem( WID_CREATE_NEW, GetPool() );

			pSubNodeFacItem->Append(
						new CntUInt16Item( WID_FACTORY_NO, pFac->GetId() ) );
			pSubNodeFacItem->Append(
				 		new CntStringItem( WID_FACTORY_NAME,
										   pFac->GetUIFactoryName() ) );
			pSubNodeFacItem->Append(
				 		new CntUInt16Item( WID_CREATION_FLAGS,
										   pFac->GetFlags() ) );
			pSubNodeFacItem->Append(
				 		new CntUInt32Item( WID_FACTORY_HELP_ID,
										   pFac->GetHelpId() ) );

			aNewMenuItem.Append( pSubNodeFacItem );
		}

		if ( aNewMenuItem.Count() )
			Put( aNewMenuItem );
	}

	rNode.SetDefaults( this );
	rNode.SfxItemSet::SetParent( this );
}

//---------------------------------------------------------------------------
// virtual
CntDefaults::~CntDefaults()
{
}

