/*************************************************************************
 *
 *  $RCSfile: cntdocnd.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif

#include <cntdocnd.hxx>

#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif
#ifndef _CNTDEFS_HXX
#include <cntdefs.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif

using namespace chaos;

//============================================================================
//
// CntDocumentNode Implementation.
//
//============================================================================

TYPEINIT1_AUTOFACTORY( CntDocumentNode, CntNode );

//----------------------------------------------------------------------------
// ranges array
USHORT __READONLY_DATA aDocRanges_Impl[] =
{
	WID_TITLE,				WID_TITLE,
	WID_ALL_START,			WID_ALL_END,
	WID_INSERT,				WID_INSERT,
	WID_USERNAME,			WID_SERVERNAME, // --> i.e., for HTTP
	WID_UNDELETE,			WID_REOPEN,
	WID_PROPERTYLIST,		WID_PROPERTYLIST,
	WID_DOCUMENT_HEADER,	WID_DOCUMENT_SIZE,
	WID_ACCOUNT,			WID_ACCOUNT, // --> for HTTP
	0
};

//----------------------------------------------------------------------------
CNT_NODE_SUBCLASS_IMPL( CntDocumentNode )
{
	// No factories to register...
}

//----------------------------------------------------------------------------
CntDocumentNode::CntDocumentNode(const USHORT * pRanges)
:	CntNode( pRanges ? pRanges : aDocRanges_Impl )
{
    // No class defaults set?
	CntDefaults *pClassDefs = GetDefaults();
	if ( pClassDefs == NULL )
	{
        // Create class defaults
		pClassDefs = new CntDefaults( *this, aDocRanges_Impl );

        // Set defaults for a document
		pClassDefs->Put( CntContentTypeItem( WID_CONTENT_TYPE,
											 CONTENT_TYPE_X_CNT_DOCUMENT ) );
		pClassDefs->Put( CntBoolItem( WID_FLAG_IS_FOLDER, FALSE ) );
		pClassDefs->Put( CntBoolItem( WID_FLAG_IS_DOCUMENT, TRUE ) );

		// Set property tab pages wanted
		pClassDefs->Put(
			CntIdentifierListItem( WID_PROPERTYLIST, CNT_TABPAGE_GENERAL, 0 ) );
	}
	CntInterface::SetParent( pClassDefs );
}

//----------------------------------------------------------------------------
// virtual
CntDocumentNode::~CntDocumentNode()
{
}

//----------------------------------------------------------------------------
// virtual
const SfxPoolItem* CntDocumentNode::InsertJob( CntNodeJob *pJob )
{
	// user- or view-property?
	const SfxPoolItem* pReq   = pJob->GetRequest();
	USHORT             nWhich = pReq->Which();

	BOOL bIsViewProp = IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP );
	BOOL bIsUserProp = IsItemFlag( nWhich, CNT_ITEM_AUTO_USERPROP );
	if ( bIsViewProp || bIsUserProp || ( nWhich == WID_REFERED_URL ) )
	{
		// handled by myself
		return CntNode::InsertJob( pJob );
	}
	else
	{
		// handled by parent
		return GetParent()->InsertJob( pJob );
	}
}

