/*************************************************************************
 *
 *  $RCSfile: cntpool.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif

#ifndef _COM_SUN_STAR_UNO_TYPE_HXX_
#include <com/sun/star/uno/Type.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_SORTINGINFO_HPP_
#include <com/sun/star/ucb/SortingInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_CROSSREFERENCE_HPP_
#include <com/sun/star/ucb/CrossReference.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_DOCUMENTHEADERFIELD_HPP_
#include <com/sun/star/ucb/DocumentHeaderField.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_FOLDERLIST_HPP_
#include <com/sun/star/ucb/FolderList.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_RECIPIENTINFO_HPP_
#include <com/sun/star/ucb/RecipientInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_RULESET_HPP_
#include <com/sun/star/ucb/RuleSet.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_SENDMEDIATYPES_HPP_
#include <com/sun/star/ucb/SendMediaTypes.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_SENDINFO_HPP_
#include <com/sun/star/ucb/SendInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_SEARCHCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/SearchCommandArgument.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include <com/sun/star/ucb/TransferInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_EXPORTSTREAMINFO_HPP_
#include <com/sun/star/ucb/ExportStreamInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMAND_HPP_
#include <com/sun/star/ucb/Command.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INSERTCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/InsertCommandArgument.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include <com/sun/star/ucb/OpenCommandArgument2.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_POSTCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/PostCommandArgument.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_SEARCHCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/SearchCommandArgument.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERRESULT_HPP_
#include <com/sun/star/ucb/TransferResult.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XDATACONTAINER_HPP_
#include <com/sun/star/ucb/XDataContainer.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_DATETIMERANGE_HPP_
#include <com/sun/star/util/DateTimeRange.hpp>
#endif

#ifndef _DATETIMEITEM_HXX //autogen
#include <svtools/dateitem.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _LCKBITEM_HXX //autogen
#include <svtools/lckbitem.hxx>
#endif
#ifndef _DTRITEM_HXX //autogen
#include <svtools/dtritem.hxx>
#endif
#ifndef _FRQITEM_HXX //autogen
#include <svtools/frqitem.hxx>
#endif
#ifndef _CSTITEM_HXX //autogen
#include <svtools/cstitem.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _BINTITEM_HXX
#include <svtools/bintitem.hxx>
#endif
#ifndef _SFONTITM_HXX
#include <svtools/sfontitm.hxx>
#endif
#ifndef _CNTWALL_HXX
#include <svtools/cntwall.hxx>
#endif
#ifndef SVTOOLS_TRESITEM_HXX
#include <svtools/tresitem.hxx>
#endif

#include <cntpool.hxx>

#ifndef _CNTIDS_HRC
#include <cntids.hrc>
#endif
#ifndef _CNTRIDS_HRC
#include <cntrids.hrc>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif
#ifndef _CNTDATA_HXX
#include <cntdata.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif

#ifndef _CNTXREF_HXX
#include <cntxref.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef _OUTITEMS_HXX
#include <outitems.hxx>
#endif
#ifndef _THRDITEM_HXX
#include <thrditem.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CNTRANGE_HXX
#include <cntrange.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif
#ifndef _CNTSIITEM_HXX
#include <cntsitem.hxx>
#endif
#ifndef _CHAOS_IMAPMITM
#include <imapmitm.hxx>
#endif
#ifndef _CNTMMITM_HXX
#include <cntmmitm.hxx>
#endif
#ifndef CHAOS_FLSTITEM_HXX
#include <flstitem.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_SILITEM_HXX
#include <silitem.hxx>
#endif
#ifndef _CNTSDITM_HXX
#include <cntsditm.hxx>
#endif
#ifndef _DHDRITEM_HXX
#include <dhdritem.hxx>
#endif
#ifndef _CNTCOOK_HXX
#include <cntcook.hxx>
#endif
#ifndef _CNTTRITM_HXX
#include <cnttritm.hxx>
#endif
#ifndef _CNTWMITM_HXX
#include <cntwmitm.hxx>
#endif
#ifndef _CNTNCITM_HXX
#include <cntncitm.hxx>
#endif
#ifndef _IPOSITEM_HXX
#include <ipositem.hxx>
#endif
#ifndef _DSIZITEM_HXX
#include <dsizitem.hxx>
#endif
#ifndef _LAYITEM_HXX
#include <layitem.hxx>
#endif
#ifndef _CHAOS_HTTPITEM_HXX
#include <httpitem.hxx>
#endif
#ifndef _CNTCCITM_HXX
#include <cntccitm.hxx>
#endif
#ifndef _CHAOS_STRMITEM_HXX
#include <strmitem.hxx>
#endif
#ifndef _ALSTITEM_HXX
#include <alstitem.hxx>
#endif
#ifndef CHAOS_SLSTITEM_HXX
#include <slstitem.hxx>
#endif
#ifndef CHAOS_TFRMITEM_HXX
#include <tfrmitem.hxx>
#endif
#ifndef _CNTRULES_HXX
#define ITEMID_RULESET WID_RULES
#include <cntrules.hxx>
#endif

using namespace chaos;

using namespace com::sun::star::beans;

//=========================================================================

static String aEmpty;

//=========================================================================
//
// class CntStaticPoolDefaults_Impl
//
//=========================================================================

namespace chaos {

class CntStaticPoolDefaults_Impl
{
	ULONG		  m_nItems;
	SfxPoolItem** m_ppDefaults;
	SfxItemInfo*  m_pItemInfos;

private:
	// Forbidden and not implemented...
	CntStaticPoolDefaults_Impl( const CntStaticPoolDefaults_Impl& );
    CntStaticPoolDefaults_Impl&	operator=( const CntStaticPoolDefaults_Impl& );

	inline void Insert( SfxPoolItem* pItem, USHORT nSID, USHORT nFlags );

public:
	CntStaticPoolDefaults_Impl( CntItemPool* pPool );
	~CntStaticPoolDefaults_Impl();

	SfxPoolItem** 	   GetDefaults() const  { return m_ppDefaults; }
	const SfxItemInfo* GetItemInfos() const { return m_pItemInfos; }
};

}

//=========================================================================
//
// CntStaticPoolDefaults_Impl implementation.
//
//=========================================================================

inline void CntStaticPoolDefaults_Impl::Insert(
	 	SfxPoolItem* pItem, 		/* Static Pool Default Item */
     	USHORT nSID, USHORT nFlags  /* Item Info */	)
{
	DBG_ASSERT( ( pItem->Which() >= WID_CHAOS_START ) &&
				( pItem->Which() <= WID_CHAOS_END ),
				"CntStaticPoolDefaults_Impl::Insert - Id out of range!" );

	USHORT nPos = pItem->Which() - WID_CHAOS_START;

	DBG_ASSERT( !m_ppDefaults[ nPos ],
				"CntStaticPoolDefaults_Impl::Insert - Already inserted!" );

	m_ppDefaults[ nPos ]         = pItem;
	m_pItemInfos[ nPos ]._nSID   = nSID;
	m_pItemInfos[ nPos ]._nFlags = nFlags;
}

//-------------------------------------------------------------------------
CntStaticPoolDefaults_Impl::~CntStaticPoolDefaults_Impl()
{
	for ( ULONG n = 0; n < m_nItems; ++n )
		delete m_ppDefaults[ n ];

	delete [] m_ppDefaults;
	delete [] m_pItemInfos;
}

//-------------------------------------------------------------------------
CntStaticPoolDefaults_Impl::CntStaticPoolDefaults_Impl( CntItemPool* pPool )
: m_nItems( WID_CHAOS_END - WID_CHAOS_START + 1 ),
  m_ppDefaults( new SfxPoolItem* [ m_nItems ] ),
  m_pItemInfos( new SfxItemInfo  [ m_nItems ] )
{
	rtl_zeroMemory( m_ppDefaults, sizeof( m_ppDefaults ) * m_nItems );
	rtl_zeroMemory( m_pItemInfos, sizeof( m_pItemInfos ) * m_nItems );

	//====================================================================
	//
	//	Notes on item flags:
	//
	//	SFX_ITEM_POOLABLE:
	//		- Items are shareable and poolable.
	//	SFX_ITEM_NOT_POOLABLE
	//		- Items are not shareable and not poolable.
	//	0
	//		- Items are not shareable, but poolable. Should not be of
	//        interest for our items.
	//
	//====================================================================

	Insert(
		new	CntStringItem( WID_DUMMY_ARG1, aEmpty ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new	CntUInt16Item( WID_FACTORY_NO, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new	CntStringItem( WID_FACTORY_NAME, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntCrossReferenceItem( WID_NEWS_XREF, aEmpty, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt16Item( WID_CREATION_FLAGS, CNT_CREATION_FLAG_STANDARD ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntUInt32Item( WID_FACTORY_HELP_ID, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_MAIL_REPLY ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_POST_REPLY ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_FORWARD ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_MARK_THREAD_READ ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_HIDE_THREAD ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_HIDE_AUTHOR ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_HIDE_SUBJECT ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_RESEND_MSG ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_MARK_THREAD_UNREAD ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntPriorityItem( WID_PRIORITY, CNT_PRIO_NORMAL ),
		SID_PRIORITY,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntBoolItem( WID_RULE_APPLIED, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_USERPROP );

	Insert(
		new CntBoolItem( WID_MSG_LOCK, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntSeenStatusItem( WID_SEEN_STATUS, CNT_NONE_SEEN ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_REPLY_TO, aEmpty ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_IN_REPLY_TO, aEmpty ),
		SID_IN_REPLY_TO,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_MESSAGE_ID, aEmpty ),
		SID_MESSAGE_ID,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_BCC, aEmpty ),
		SID_BCC,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_CC, aEmpty ),
		SID_CC,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_TO, aEmpty ),
		SID_TO,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_GARBLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntNameItem( WID_FROM, aEmpty ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_TITLE, aEmpty ),
		SID_TITLE,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_RULES_RELEVANT | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntMessageBodyItem( WID_MESSAGEBODY, aEmpty ),
		SID_MESSAGEBODY,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_REFERENCES, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_NEWSGROUPS, aEmpty ),
		SID_NEWSGROUPS,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntItemListItem( WID_NEWS_XREFLIST, pPool ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntOutMsgInternalStateItem(	WID_OUTMSGINTERNALSTATE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntRecipientListItem( WID_RECIPIENTLIST ),
		SID_RECIPIENTLIST,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntUShortListItem( WID_DEFAULT ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntOpenModeItem( WID_OPEN ),
		SID_OPEN_CNT,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntBoolItem( WID_DELETE, FALSE ),
		SID_DELETE,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_CUT ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_COPY ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_PASTE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntUShortListItem( WID_RENAME ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntBoolItem( WID_HAS_DATA, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new SfxVoidItem( WID_GETDATA ),
		0,
		SFX_ITEM_NOT_POOLABLE  | CNT_ITEM_SYNCHRON );

	Insert(
		new CntItemListItem( WID_PUTDATA, pPool ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_INTERIM_URL, aEmpty ),
		SID_INTERIM_URL,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntContentTypeItem( WID_CONTENT_TYPE,
								CONTENT_TYPE_X_CNT_DOCUMENT ),
		SID_CONTENT_TYPE,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_OWN_URL, aEmpty ),
		SID_OWN_URL,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_REAL_URL, aEmpty ),
		SID_REAL_URL,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_OBSOLETE_TITLE, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntBoolItem( WID_FLAG_READONLY, FALSE ),
		SID_FLAG_READONLY,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_REFERED_URL, aEmpty ),
		SID_REFERED_URL,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt32Item( WID_REFERER_COUNT, 0 ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntBoolItem( WID_FLAG_IS_FOLDER, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntBoolItem( WID_FLAG_HAS_FOLDER, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntBoolItem( WID_FLAG_IS_MESSAGE, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntBoolItem( WID_FLAG_HAS_MESSAGES, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new SfxDateTimeItem( WID_DATE_CREATED, DateTime( 0, 0 ) ),
		SID_DATE_CREATED,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new SfxDateTimeItem( WID_DATE_MODIFIED, DateTime( 0, 0 ) ),
		SID_DATE_MODIFIED,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntViewDescriptionItem( WID_VIEW_DESCRIPTION ),
		SID_VIEW_DESCRIPTION,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntBoolItem( WID_IS_READ, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_RULES_RELEVANT | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntBoolItem( WID_IS_MARKED, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new SfxVoidItem( WID_SYNCHRONIZE ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntItemListItem( WID_CREATE_NEW, pPool ),
		SID_CREATE_NEW,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_SYNCHRON );

	Insert(
		new SfxVoidItem( WID_INSERT ),
		SID_INSERT,
		SFX_ITEM_POOLABLE | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_UPDATE ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntInStreamItem( WID_IMPORT ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_DUMMY_PROPFOLDERVIEW1 ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntThreadingItem( WID_THREADING ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_SYNCHRON );

	Insert(
		new CntUShortListItem( WID_MSG_COLUMN_INFO,
							   WID_FROM, WID_TITLE, WID_DATE_CREATED, 0 ),
		SID_MSG_COLUMN_INFO,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntUShortListItem( WID_FLD_COLUMN_INFO, WID_TITLE, 0 ),
		SID_FLD_COLUMN_INFO,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntFolderViewModeItem( WID_FOLDERVIEW_MODE,
								   CNT_VIEW_ALL_FOLDERS ),
		SID_FOLDERVIEW_MODE,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_MULTISELECTION | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntMsgViewModeItem( WID_MESSAGEVIEW_MODE ),
		SID_MESSAGEVIEW_MODE,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_MULTISELECTION | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntSentMsgViewModeItem( WID_SENTMESSAGEVIEW_MODE ),
		SID_SENTMESSAGEVIEW_MODE,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_MULTISELECTION | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntSortingItem( WID_SORTING ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntBoolItem( WID_THREADED, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT | CNT_ITEM_SYNCHRON | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntBoolItem( WID_FILTERED, TRUE ),
		SID_FILTERED,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntRuleSetItem( WID_RULES ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntUInt32Item( WID_SUBSCRNEWSGROUPCOUNT, (ULONG)-1 ),
		SID_SUBSCRNEWSGROUPCOUNT,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntBoolItem( WID_FLAG_SUBSCRIBED, FALSE ),
		SID_FLAG_SUBSCRIBED,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP| CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntBoolItem( WID_FLAG_SUPPORTMODE, FALSE ),
		SID_FLAG_SUPPORTMODE,
		SFX_ITEM_POOLABLE );

	Insert(
		new SfxVoidItem( WID_DUMMY_FOLDERDIR1 ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntUInt32Item( WID_TOTALCONTENTCOUNT ),
		SID_TOTALCONTENTCOUNT,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntUInt32Item( WID_NEWSGROUPCOUNT, 0 ),
		SID_NEWSGROUPCOUNT,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt32Item( WID_ARTICLECOUNT, 0 ),
		SID_ARTICLECOUNT,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntRangesItem( WID_KNOWN_RANGES ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntIMAPMboxDataItem( WID_IMAPFOLDERINFO ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new SfxVoidItem( WID_DUMMY_FOLDERUSER1 ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntUInt32Item( WID_SEENCONTENTCOUNT, 0 ),
		SID_SEENCONTENTCOUNT,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntRangesItem( WID_READ_RANGES ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntRangesItem( WID_MARK_RANGES ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_PREPARE_MOVE ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_SYNCHRON );

	Insert(
		new CntBoolItem( WID_OUTTRAY_WANTED, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_USERNAME, aEmpty ),
		SID_RECEIVE_USERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_PASSWORD, aEmpty ),
		SID_RECEIVE_PASSWORD,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_AUTO_GARBLE );

	Insert(
		new CntStringItem( WID_SERVERNAME, aEmpty ),
		SID_RECEIVE_SERVERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntUInt16Item( WID_SERVERPORT, 0 ),
		SID_SERVERPORT,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntStringItem( WID_MAILSEND_USERNAME, aEmpty ),
		SID_MAILSEND_USERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_MAILSEND_PASSWORD, aEmpty ),
		SID_MAILSEND_PASSWORD,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_AUTO_GARBLE );

	Insert(
		new CntStringItem( WID_MAILSEND_SERVERNAME, aEmpty ),
		SID_MAILSEND_SERVERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_NEWSSEND_USERNAME, aEmpty ),
		SID_NEWSSEND_USERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_NEWSSEND_PASSWORD, aEmpty ),
		SID_NEWSSEND_PASSWORD,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_AUTO_GARBLE );

	Insert(
		new CntStringItem( WID_NEWSSEND_SERVERNAME, aEmpty ),
		SID_NEWSSEND_SERVERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_SERVERBASE, aEmpty ),
		SID_CHAOS_SERVERBASE,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_SMTP_GATEWAY, aEmpty ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_FROM_DEFAULT, aEmpty ),
		SID_FROM,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_REPLY_TO_DEFAULT, aEmpty ),
		SID_REPLY_TO,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntUInt32Item( WID_AUTOUPDATE_INTERVAL, 15 * 60 ),
		SID_AUTOUPDATE_INTERVAL,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT | CNT_ITEM_SYNCHRON );

	Insert(
		new CntBoolItem( WID_UPDATE_ENABLED, FALSE ),
		SID_UPDATE_ENABLED,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT | CNT_ITEM_SYNCHRON );

	Insert(
		new CntConnModeItem( WID_CONNECTION_MODE, CNT_CONN_MODE_ONLINE ),
		SID_INTERNET_ONLINE,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntFolderListItem( WID_NEWS_GROUPLIST, sal_False ),
		SID_NEWS_GROUPLIST,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntMsgStoreModeItem( WID_MESSAGE_STOREMODE,
								 CNT_MESSAGE_STOREMODE_REMOTE ),
		SID_MESSAGE_STOREMODE,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntBoolItem( WID_DELETE_ON_SERVER, FALSE ),
		SID_DELETE_ON_SERVER,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON| CNT_ITEM_MULTISELECTION );

	Insert(
		new CntOutMsgExternalStateItem( WID_OUTMSGEXTERNALSTATE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringListItem( WID_RNM_UPDATETIMER_LIST ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntRangesItem( WID_SERVER_RANGES ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxDateTimeItem( WID_LAST_UPDATE, DateTime( 0, 0 ) ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_LAST_MSGID, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_LAST_UID, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_UNDELETE ),
		SID_UNDELETE,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_CLOSE ),
		SID_CLOSECNT,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_REOPEN ),
		SID_REOPEN,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringListItem( WID_RNM_FILECONVERSION_LIST ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntBoolItem( WID_SHOW_MSGS_HAS_TIMELIMIT, TRUE ),
		SID_SHOW_MSGS_HAS_TIMELIMIT,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntUInt16Item( WID_SHOW_MSGS_TIMELIMIT, 250 ),
		SID_SHOW_MSGS_TIMELIMIT,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntBoolItem( WID_STORE_MSGS_HAS_TIMELIMIT, FALSE ),
		SID_STORE_MSGS_HAS_TIMELIMIT,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntUInt16Item( WID_STORE_MSGS_TIMELIMIT, 14 ),
		SID_STORE_MSGS_TIMELIMIT,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntUShortListItem( WID_MSG_COLUMN_WIDTHS,
		   					   150, 330, 100, 100, 100, 100,
							   100, 100, 100, 100, 100, 100, 0  ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntIdentifierListItem( WID_PROPERTYLIST ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt16Item( WID_SEND_PUBLIC_PROT_ID,
						   (UINT16)CNT_OUTMSG_PROTOCOL_NNTP ),
		SID_SEND_PUBLIC_PROT_ID,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntUInt16Item( WID_SEND_PRIVATE_PROT_ID,
						   (UINT16)CNT_OUTMSG_PROTOCOL_SMTP ),
		SID_SEND_PRIVATE_PROT_ID,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntBoolItem( WID_SEND_PUBLIC_OUTBOXPROPS, TRUE ),
		SID_SEND_PUBLIC_OUTBOXPROPS,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntBoolItem( WID_SEND_PRIVATE_OUTBOXPROPS, TRUE ),
		SID_SEND_PRIVATE_OUTBOXPROPS,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntSendInfoListItem( WID_SEND_SERVERNAME ),
		SID_SEND_SERVERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntSendInfoListItem( WID_SEND_USERNAME ),
		SID_SEND_USERNAME,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntSendInfoListItem( WID_SEND_PASSWORD ),
		SID_SEND_PASSWORD,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntSendInfoListItem( WID_SEND_REPLY_TO_DEFAULT ),
		SID_SEND_REPLY_TO_DEFAULT,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntSendInfoListItem( WID_SEND_FROM_DEFAULT ),
		SID_SEND_FROM_DEFAULT,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_VIM_POPATH, aEmpty ),
		SID_VIM_POPATH,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_SEND_VIM_POPATH, aEmpty ),
		SID_SEND_VIM_POPATH,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new SfxVoidItem( WID_PURGE ),
		SID_PURGE,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION| CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_CLEAN_CACHE ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntSearchDataItem( WID_SEARCH ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_JOURNAL ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_LOCALBASE, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntDocHeaderItem( WID_DOCUMENT_HEADER, NULL ),
		SID_DOCUMENT_HEADER,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxLockBytesItem( WID_DOCUMENT_BODY, NULL ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt32Item( WID_DOCUMENT_SIZE, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntUInt16Item( WID_PRJ_MEDIUM ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntNamingConventionItem( WID_PRJ_FILENAMECONVENTION ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new SfxBigIntItem( WID_FSYS_DISKSPACE_LEFT, BigInt( 0 ) ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntTransferItem( WID_TRANSFER, aEmpty,
							 TRUE, CntTransferItem::REPLACE_RENAME ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntStringItem( WID_KEYWORDS, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntBoolItem( WID_IS_PROTECTED, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntRuleSetItem( WID_SEARCH_CRITERIA ),
		SID_SEARCH_CRITERIA,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntStringListItem( WID_SEARCH_LOCATIONS ),
		SID_SEARCH_LOCATIONS,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntBoolItem( WID_SEARCH_RECURSIVE, FALSE ),
		SID_SEARCH_RECURSIVE,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntBoolItem( WID_SEARCH_FOLDER_VIEW, FALSE ),
		SID_SEARCH_FOLDER_VIEW,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntBoolItem( WID_SEARCH_DOCUMENT_VIEW, FALSE ),
		SID_SEARCH_DOCUMENT_VIEW,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new SfxDateTimeRangeItem( WID_SCHEDULE_RANGE,
								  DateTime( 0, 0 ),	DateTime( 0, 0 ) ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new SfxDateTimeRangeItem( WID_ALLOWED_SCHEDULE_RANGE,
								  DateTime( 0, 0 ),	DateTime( 0, 0 ) ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntStringItem( WID_TARGET_URL, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new SfxFrequencyItem( WID_FREQUENCY ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntByteItem( WID_HTTP_CONNECTION_LIMIT, 4 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntHTTPCookieManagerItem( WID_HTTP_COOKIE_MANAGER, NULL ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxColumnDateTimeItem( WID_COLUMN_NEXT_UPD,	DateTime( 0, 0 ) ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new SfxCrawlStatusItem( WID_CRAWL_STATUS, CSTAT_NEVER_UPD ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntUInt16Item( WID_CRAWL_LEVEL, 0 ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntBoolItem( WID_CRAWL_MODE, TRUE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntUInt16Item( WID_CRAWL_MAX_VOLUME, 0 ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntBoolItem( WID_CRAWL_IMAGE, TRUE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntUInt16Item( WID_CRAWL_LINK_OUT, 1 ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntUInt16Item( WID_NOTIFICATION_MODE, 0 ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntStringItem( WID_NOTIFICATION_ADDRESS, aEmpty ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntStringItem( WID_ACCOUNT, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt32Item( WID_FSYS_KIND, 0 ),
		SID_FSYS_KIND,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntUInt32Item( WID_FSYS_FLAGS, 0 ),
		SID_FSYS_FLAGS,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_VIEWDATA, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntWhoIsMasterItem( WID_WHO_IS_MASTER, CNT_NONE_IS_MASTER ),
		SID_WHO_IS_MASTER,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_HTTP_POST ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_SUPPORTED_FUNCS ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt32Item( WID_SIZE_LIMIT, (ULONG)-1 ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntUInt32Item( WID_MARKED_DOCUMENT_COUNT, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUInt32Item( WID_FOLDER_COUNT, 0 ),
		SID_FOLDER_COUNT,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntBoolItem( WID_FSYS_SHOW_HIDDEN, FALSE ),
		SID_FSYS_SHOW_HIDDEN,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_MULTISELECTION | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new SfxVoidItem( WID_TRASHCAN_EMPTY_TRASH ),
		SID_TRASHCAN_EMPTY_TRASH,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntBoolItem( WID_TRASHCAN_FLAG_AUTODELETE, FALSE ),
		SID_TRASHCAN_FLAG_AUTODELETE,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntBoolItem( WID_TRASHCAN_FLAG_CONFIRMEMPTY, TRUE ),
		SID_TRASHCAN_FLAG_CONFIRMEMPTY,
		SFX_ITEM_POOLABLE );

	Insert(
		new SfxVoidItem( WID_TRASHCAN_DUMMY1 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_TRASHCAN_DUMMY2 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_TRASH_RESTORE ),
		SID_TRASH_RESTORE,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntStringItem( WID_TRASH_ORIGIN, aEmpty ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new SfxVoidItem( WID_TRASH_DUMMY2 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntTargetFrameItem( WID_TARGET_FRAMES,
								UniString(),
								UniString::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM( "_top" ) ),
								UniString::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM( "_blank" ) ) ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntExpStreamItem( WID_EXPORT ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntCmpCommandItem( WID_COMPONENT_COMMAND ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new /* CntCmpMenuItem */ SfxVoidItem( WID_COMPONENT_MENU ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_HREF, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntViewColumnsListItem( WID_VIEW_COLS_BEAMER,
									WID_FROM, 150,
									WID_TITLE, 330,
									WID_DATE_CREATED, 100, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntViewColumnsListItem( WID_VIEW_COLS_FILEDLG,
									WID_TITLE, 330,
									WID_DATE_CREATED, 100, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntViewColumnsListItem( WID_VIEW_COLS_FLDWIN,
									WID_FROM, 150,
									WID_TITLE, 330,
									WID_DATE_CREATED, 100, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntBoolItem( WID_VIEW_MODE_FLDWIN, TRUE /* details*/ ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntLayoutItem( WID_VIEW_LAYOUT_FLDWIN ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntIconPosItem( WID_VIEW_ICON_POS_FLDWIN ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntSortingItem( WID_VIEW_SORT_BEAMER ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntSortingItem( WID_VIEW_SORT_FILEDLG ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntSortingItem( WID_VIEW_SORT_FLDWIN_DETAILS ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntSortingItem( WID_VIEW_SORT_FLDWIN_ICON ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntDocItemsSizeItem( WID_VIEW_WINDOW_POS_FLDWIN ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	Insert(
		new CntBoolItem( WID_IS_INVALID, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_VIEW_TIPHELP, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntBoolItem( WID_PUBLISHER_SCHEDULE, TRUE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntUInt16Item( WID_GETMODE, 0 ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntBoolItem( WID_READ_OFFLINE, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntStringItem( WID_REAL_NAME, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntBoolItem( WID_FLAG_UPDATE_ON_OPEN, TRUE ),
		SID_FLAG_UPDATE_ON_OPEN,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntActionListItem( WID_ACTION_LIST ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_EDIT_STRING, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntUShortListItem( WID_SET_AS_DEFAULT ),
		SID_CNT_SET_AS_DEFAULT,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntWallpaperItem( WID_VIEW2_FLD_PIC ),
		SID_VIEW_FLD_PIC,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntBoolItem( WID_FLAG_EXPANDED, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntItemListItem( WID_CHILD_DEFAULTS, pPool ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntBoolItem( WID_HTTP_KEEP_EXPIRED, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntHTTPVerifyModeItem( WID_HTTP_VERIFY_MODE,
								   CNTHTTP_VERIFY_ONCE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_HTTP_NOCACHE_LIST, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_HTTP_REFERER, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntBoolItem( WID_FSYS_VALUE_FOLDER, FALSE ),
		SID_FSYS_VALUE_FOLDER,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntBoolItem( WID_FSYS_SHOW_EXTENSION, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntValueAddedModeItem( WID_VALUE_ADDED_MODE, CNT_VALUE_ADDED_NONE ),
		SID_VALUE_ADDED_MODE,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_FSYS_DUMMY3 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_FSYS_DUMMY4 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_HTTP_GET_COOKIE ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_SYNCHRON );

	Insert(
		new CntStringItem( WID_HTTP_SET_COOKIE, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_HTTP_COOKIE, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_HTTP_DUMMY_1 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_USER_SORT_CRITERIUM, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntBoolItem( WID_SEARCH_INDIRECTIONS, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntSendMediaTypesItem( WID_SEND_FORMATS ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntSendInfoListItem( WID_SEND_COPY_TARGET ),
		SID_SEND_COPY_TARGET,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new CntTransferResultItem( WID_TRANSFER_RESULT ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	///////////////////////////////////
	// WID_HEADER_CONFIG

	CntStringListItem* pHdrCfg = new CntStringListItem( WID_HEADER_CONFIG );
	Insert(
		pHdrCfg,
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_AUTO_INHERIT );

	UniString aStr( 't' );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Subject:\001b" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "From:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "To:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "cc:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Date:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "NonRFC-Size" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Newsgroups:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Priority:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Expires:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Keywords:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Comments:" ) );
	aStr += _CR;
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "NonRFC-UserFields" ) );

	pHdrCfg->SetString( aStr );

	// WID_HEADER_CONFIG
	///////////////////////////////////

	Insert(
		new CntUInt32Item( WID_GROUPVIEW_CONFIG, 0 ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntStringItem( WID_FLD_WEBVIEW_TEMPLATE, aEmpty ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new CntIconPosItem( WID_VIEW_ICON_POS_GRPWIN ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntBoolItem( WID_SHOW_IN_EXPLORER, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new SfxFontItem( WID_FLD_FONT ),
		SID_ATTR_FONT,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP );

	Insert(
		new CntBoolItem( WID_FLD_WEBVIEW_USE_GLOBAL, TRUE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP );

	Insert(
		new SfxVoidItem( WID_VIEW3_DUMMY2 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_VIEW3_DUMMY3 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_FTP_ACCOUNT, aEmpty ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_AUTO_GARBLE );

	Insert(
		new CntBoolItem( WID_STORE_MARKED, FALSE ),
		SID_STORE_MARKED,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_SYNCHRON );

	Insert(
		new SfxVoidItem( WID_REPLICATION_1 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_REPLICATION_2 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_REPLICATION_3 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_REPLICATION_4 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_REPLICATION_5 ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	//////////////////////////////////////////////////////////////////////

#ifdef DBG_UTIL
	for ( ULONG n = 0; n < m_nItems; ++n )
	{
		SfxPoolItem* pCurr = m_ppDefaults[ n ];
		if ( !pCurr )
		{
			DBG_ERROR( "Static default items list incomplete!" );
			break;
		}
	}
#endif
}

//////////////////////////////////////////////////////////////////////////
//
// The following table enables mapping of our item pool to a
// UNO "XPropertySet" Interface implementation. It must(!!!) contain every
// WID of our pool, which represents a FUNCTION our a PROPERTY accessable
// from outside CHAOS.
//
// The table must be sorted by property name - case is important.
// Function names must start with a lowercase letter
// Property names must start with an uppercase letter.
//
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
// CPPU types.
//
//////////////////////////////////////////////////////////////////////////

static const com::sun::star::uno::Type& void_getCppuType()
{
	return getCppuVoidType();
}

static const com::sun::star::uno::Type& OUString_getCppuType()
{
	return getCppuType( static_cast< const rtl::OUString * >( 0 ) );
}

static const com::sun::star::uno::Type& sal_uInt64_getCppuType()
{
	// ! uInt -> Int, because of Java !!!
	return getCppuType( static_cast< const sal_Int64 * >( 0 ) );
}

static const com::sun::star::uno::Type& sal_uInt32_getCppuType()
{
	// ! uInt -> Int, because of Java !!!
	return getCppuType( static_cast< const sal_Int32 * >( 0 ) );
}

static const com::sun::star::uno::Type& sal_uInt16_getCppuType()
{
	// ! uInt -> Int, because of Java !!!
	return getCppuType( static_cast< const sal_Int16 * >( 0 ) );
}

static const com::sun::star::uno::Type& enum_getCppuType()
{
	// ! enum -> Int, because of Java !!!
	return getCppuType( static_cast< const sal_Int16 * >( 0 ) );
}

static const com::sun::star::uno::Type& sal_Bool_getCppuType()
{
	return getCppuBooleanType();
}

static const com::sun::star::uno::Type& byte_getCppuType()
{
	return getCppuType( static_cast< const sal_Int8 * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_OWString_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence< rtl::OUString > * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_byte_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence< sal_Int8 > * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_Int16_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence< sal_Int16 > * >( 0 ) );
}

static const com::sun::star::uno::Type& DateTime_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::util::DateTime * >( 0 ) );
}

static const com::sun::star::uno::Type& DateTimeRange_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::util::DateTimeRange * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_SortingInfo_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence<
						com::sun::star::ucb::SortingInfo > * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_CrossReference_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence<
						com::sun::star::ucb::CrossReference > * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_DocumentHeaderField_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence<
						com::sun::star::ucb::DocumentHeaderField > * >( 0 ) );
}

static const com::sun::star::uno::Type& FolderList_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::FolderList * >( 0 ) );
}

static const com::sun::star::uno::Type& XDataContainer_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Reference<
			com::sun::star::ucb::XDataContainer > * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_RecipientInfo_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence<
						com::sun::star::ucb::RecipientInfo > * >( 0 ) );
}

static const com::sun::star::uno::Type& RuleSet_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::RuleSet * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_SendMediaTypes_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence<
						com::sun::star::ucb::SendMediaTypes > * >( 0 ) );
}

static const com::sun::star::uno::Type& Sequence_SendInfo_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Sequence<
						com::sun::star::ucb::SendInfo > * >( 0 ) );
}

static const com::sun::star::uno::Type& SearchCommandArgument_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::SearchCommandArgument * >( 0 ) );
}

static const com::sun::star::uno::Type& TransferInfo_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::TransferInfo * >( 0 ) );
}

static const com::sun::star::uno::Type& Command_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::Command * >( 0 ) );
}

static const com::sun::star::uno::Type& InsertCommandArgument_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::InsertCommandArgument * >( 0 ) );
}

static const com::sun::star::uno::Type& OpenCommandArgument2_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::OpenCommandArgument2 * >( 0 ) );
}

static const com::sun::star::uno::Type& ExportStreamInfo_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::ExportStreamInfo * >( 0 ) );
}

static const com::sun::star::uno::Type& XInputStream_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::uno::Reference<
			com::sun::star::io::XInputStream > * >( 0 ) );
}

static const com::sun::star::uno::Type& PostCommandArgument_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::PostCommandArgument * >( 0 ) );
}

static const com::sun::star::uno::Type& TransferResult_getCppuType()
{
	return getCppuType(
		static_cast< com::sun::star::ucb::TransferResult * >( 0 ) );
}

//-------------------------------------------------------------------------

#define ATTR_DEFAULT ( PropertyAttribute::BOUND | PropertyAttribute::MAYBEVOID | PropertyAttribute::MAYBEDEFAULT )

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	  Name,			   		WID,	 	 			Attributes,		CPPU type info
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static CntItemMapEntry __READONLY_DATA aItemMap_Impl[] =
{
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Properties:
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////

	{ "Account",   			WID_ACCOUNT,			ATTR_DEFAULT,	&OUString_getCppuType },
// Internally used only:
//	{ "ActionList",   		WID_ACTION_LIST,		ATTR_DEFAULT,	NULL },
	{ "AllowedScheduleRange",
						 	WID_ALLOWED_SCHEDULE_RANGE,
													ATTR_DEFAULT,	&DateTimeRange_getCppuType },
// Not used:
//	{ "ArticleCount",		WID_ARTICLECOUNT,   	ATTR_DEFAULT,	&sal_uInt32_getCppuType },
	{ "AutoUpdateInterval",	WID_AUTOUPDATE_INTERVAL,ATTR_DEFAULT,	&sal_uInt32_getCppuType },
// Internally used only:
//	{ "AutoUpdateList",	   	WID_RNM_UPDATETIMER_LIST,
//													ATTR_DEFAULT,	&OUString_getCppuType },
// Obsolete.
//	{ "BeamerColumns",	   	WID_VIEW_COLS_BEAMER,   ATTR_DEFAULT,	&Sequence_ColumnConfig_getCppuType },
	{ "BeamerSort",	   		WID_VIEW_SORT_BEAMER,   ATTR_DEFAULT,	&Sequence_SortingInfo_getCppuType },
// Internally used only:
//	{ "ChildDefaults",	   	WID_CHILD_DEFAULTS,     ATTR_DEFAULT,	NULL },
// Not used:
//	{ "ColumnWidths",		WID_MSG_COLUMN_WIDTHS,  ATTR_DEFAULT,	&Sequence_OWString_getCppuType },
// Not used yet, but reserved for later holding all supported funcs of a
// node in an UShortListItem.
//	{ "Commands",			WID_SUPPORTED_FUNCS,	ATTR_DEFAULT,	NULL },
	{ "ConfirmEmpty",		WID_TRASHCAN_FLAG_CONFIRMEMPTY,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "ConnectionLimit",	WID_HTTP_CONNECTION_LIMIT,
													ATTR_DEFAULT,	&byte_getCppuType },
	{ "ConnectionMode",	  	WID_CONNECTION_MODE,	ATTR_DEFAULT,	&enum_getCppuType },
	{ "ContentCountLimit",	WID_SHOW_MSGS_TIMELIMIT,ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "ContentType",		WID_CONTENT_TYPE,   	ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Cookie",			    WID_HTTP_COOKIE,        ATTR_DEFAULT,	&OUString_getCppuType },
//!	{ "Cookies",			WID_HTTP_COOKIE_MANAGER,ATTR_DEFAULT,	NULL },
	{ "CrawlLevel",			WID_CRAWL_LEVEL,   		ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "CrawlLinkOut",		WID_CRAWL_LINK_OUT,		ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "CrawlMaxVolume",		WID_CRAWL_MAX_VOLUME,   ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "CrawlState",			WID_CRAWL_STATUS,   	ATTR_DEFAULT,	&enum_getCppuType },
// Internally used only:
//	{ "CrossReference",		WID_NEWS_XREF,			ATTR_DEFAULT,	NULL },
	{ "CrossReferences", 	WID_NEWS_XREFLIST,		ATTR_DEFAULT,	&Sequence_CrossReference_getCppuType },
	{ "DateCreated",		WID_DATE_CREATED,   	ATTR_DEFAULT,	&DateTime_getCppuType },
	{ "DateModified",		WID_DATE_MODIFIED,  	ATTR_DEFAULT,	&DateTime_getCppuType },
	{ "DeleteOnServer",		WID_DELETE_ON_SERVER,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "DocumentBody",		WID_DOCUMENT_BODY,  	ATTR_DEFAULT,	&Sequence_byte_getCppuType },
// Not used:
//	{ "DocumentColumnInfo", WID_MSG_COLUMN_INFO,	ATTR_DEFAULT,	&Sequence_OWString_getCppuType },
	{ "DocumentCount", 		WID_TOTALCONTENTCOUNT,	ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_uInt32_getCppuType },
	{ "DocumentCountMarked",
							WID_MARKED_DOCUMENT_COUNT,
													ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_uInt32_getCppuType },
	{ "DocumentHeader",		WID_DOCUMENT_HEADER,	ATTR_DEFAULT,	&Sequence_DocumentHeaderField_getCppuType },
	{ "DocumentStoreMode",	WID_MESSAGE_STOREMODE,  ATTR_DEFAULT,	&enum_getCppuType },
	{ "DocumentViewMode",	WID_MESSAGEVIEW_MODE,	ATTR_DEFAULT,	&enum_getCppuType },
// Internally used only:
//	{ "EditString",			WID_EDIT_STRING,		ATTR_DEFAULT,	&OUString_getCppuType },
	{ "FTPAccount",			WID_FTP_ACCOUNT,		ATTR_DEFAULT,	&OUString_getCppuType },
// Internally used only:
//	{ "FileConversionList",	WID_RNM_FILECONVERSION_LIST,
//													ATTR_DEFAULT,	&OUString_getCppuType },
// Office-UI specific.
//	{ "FileDlgColumns",		WID_VIEW_COLS_FILEDLG,	ATTR_DEFAULT,	&Sequence_ColumnConfig_getCppuType },
// Office-UI specific.
//	{ "FileDlgSort",		WID_VIEW_SORT_FILEDLG,  ATTR_DEFAULT,	&Sequence_SortingInfo_getCppuType },
	{ "FileName",			WID_REAL_NAME,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Flags",				WID_FSYS_FLAGS,		   	ATTR_DEFAULT,	&sal_uInt32_getCppuType },
// Obsolete.
//	{ "FolderBackground",	WID_VIEW2_FLD_PIC,		ATTR_DEFAULT,	&WallPaper_getCppuType },
// Not used:
//	{ "FolderColumnInfo",	WID_FLD_COLUMN_INFO,	ATTR_DEFAULT,	&Sequence_OWString_getCppuType },
	{ "FolderCount",		WID_FOLDER_COUNT,		ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_uInt32_getCppuType },
	{ "FolderList",			WID_NEWS_GROUPLIST,	  	ATTR_DEFAULT,	&FolderList_getCppuType },
// Office-UI specific.
//	{ "FolderSizeInfo",		WID_VIEW_WINDOW_POS_FLDWIN,
//													ATTR_DEFAULT,	NULL },
	{ "FolderViewMode",		WID_FOLDERVIEW_MODE,	ATTR_DEFAULT,	&enum_getCppuType },
	{ "FolderWebViewTemplate",
							WID_FLD_WEBVIEW_TEMPLATE,
													ATTR_DEFAULT,	&OUString_getCppuType },
	{ "FolderWebViewUseGlobal",
							WID_FLD_WEBVIEW_USE_GLOBAL,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
// Obsolete.
//	{ "FolderWinColumns",	WID_VIEW_COLS_FLDWIN,	ATTR_DEFAULT,	&Sequence_ColumnConfig_getCppuType },
	{ "FolderWinDetailsSort",
							WID_VIEW_SORT_FLDWIN_DETAILS,
													ATTR_DEFAULT,	&Sequence_SortingInfo_getCppuType },
// Obsolete.
//	{ "FolderWinIconPos",	WID_VIEW_ICON_POS_FLDWIN,
//													ATTR_DEFAULT,	&Sequence_IconPosInfo_getCppuType },
	{ "FolderWinIconsSort",	WID_VIEW_SORT_FLDWIN_ICON,
													ATTR_DEFAULT,	&Sequence_SortingInfo_getCppuType },
	{ "FolderWinLayout",	WID_VIEW_LAYOUT_FLDWIN,	ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "FolderWinViewMode",	WID_VIEW_MODE_FLDWIN,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "FreeSpace",			WID_FSYS_DISKSPACE_LEFT,ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_uInt64_getCppuType },
//!	{ "Frequency",			WID_FREQUENCY,			ATTR_DEFAULT,	NULL },
	{ "GetMode",			WID_GETMODE,			ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "GroupViewConfig",	WID_GROUPVIEW_CONFIG,	ATTR_DEFAULT,	&sal_uInt32_getCppuType },
// Obsolete.
//	{ "GroupViewIconPos",	WID_VIEW_ICON_POS_GRPWIN,
//													ATTR_DEFAULT,	&Sequence_IconPosInfo_getCppuType },
// Internally used only:
//	{ "HasData",			WID_HAS_DATA,			ATTR_DEFAULT | PropertyAttribute::READONLY,
//																							&sal_Bool_getCppuType },
	{ "HasDocuments",		WID_FLAG_HAS_MESSAGES,	ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_Bool_getCppuType },
	{ "HasFolders",			WID_FLAG_HAS_FOLDER,	ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_Bool_getCppuType },
	{ "HeaderConfiguration",WID_HEADER_CONFIG,		ATTR_DEFAULT,	&OUString_getCppuType },
// Internally used only:
//	{ "IMAPFolderInfo",		WID_IMAPFOLDERINFO,		ATTR_DEFAULT,	NULL },
// Internally used only:
//	{ "InterimURL",			WID_INTERIM_URL,		ATTR_DEFAULT | PropertyAttribute::READONLY,
//																							&OUString_getCppuType },
	{ "IsAutoDelete",		WID_TRASHCAN_FLAG_AUTODELETE,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsAutoUpdate",		WID_UPDATE_ENABLED,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsCrawlImage",		WID_CRAWL_IMAGE,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsCrawlMode",		WID_CRAWL_MODE,			ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsDocument",			WID_FLAG_IS_MESSAGE,	ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_Bool_getCppuType },
	{ "IsExpanded",			WID_FLAG_EXPANDED,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsFiltered",			WID_FILTERED,			ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsFolder",			WID_FLAG_IS_FOLDER,		ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_Bool_getCppuType },
// Internally used only:
//	{ "IsInvalid",			WID_IS_INVALID,			ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsKeepExpired",		WID_HTTP_KEEP_EXPIRED,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsLimitedContentCount",
							WID_SHOW_MSGS_HAS_TIMELIMIT,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsLocked",			WID_MSG_LOCK,			ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsMarked",			WID_IS_MARKED,			ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsProtected",		WID_IS_PROTECTED,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsPublisherSchedule",WID_PUBLISHER_SCHEDULE,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsRead",				WID_IS_READ,			ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsReadOffline",		WID_READ_OFFLINE,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsReadOnly",			WID_FLAG_READONLY,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsSubscribed",		WID_FLAG_SUBSCRIBED,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
// Internally used only:
//	{ "IsSupportMode",		WID_FLAG_SUPPORTMODE,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsThreaded",			WID_THREADED,			ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "IsTimeLimitedStore", WID_STORE_MSGS_HAS_TIMELIMIT,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
// Obsolete: Use "ValueAddedMode" instead.
//	{ "IsValueAddedFolder", WID_FSYS_VALUE_FOLDER, 	ATTR_DEFAULT,	&sal_Bool_getCppuType },
// Not used:
//	{ "Journal",			WID_JOURNAL,			ATTR_DEFAULT,	NULL },
	{ "Keywords",			WID_KEYWORDS,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Kind",				WID_FSYS_KIND,			ATTR_DEFAULT,	&sal_uInt32_getCppuType },
// Internally used only:
//	{ "LastMsgId",			WID_LAST_MSGID,			ATTR_DEFAULT,	&OUString_getCppuType },
// Internally used only:
//	{ "LastUID",			WID_LAST_UID,			ATTR_DEFAULT,	&OUString_getCppuType },
// Internally used only:
//	{ "LastUpdate",			WID_LAST_UPDATE,		ATTR_DEFAULT,	&DateTime_getCppuType },
	{ "LocalBase",			WID_LOCALBASE,			ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "MailSendPassword",	WID_MAILSEND_PASSWORD,	ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "MailSendServerName", WID_MAILSEND_SERVERNAME,ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "MailSendUserName",	WID_MAILSEND_USERNAME,	ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "Medium",				WID_PRJ_MEDIUM,			ATTR_DEFAULT,	&sal_uInt16_getCppuType },
// Obsolete: "Component" specific.
//	{ "Menu",				WID_COMPONENT_MENU,		ATTR_DEFAULT,	&MenuDescriptor_getCppuType },
	{ "MessageBCC",		   	WID_BCC,				ATTR_DEFAULT,	&OUString_getCppuType },
	{ "MessageBody",		WID_MESSAGEBODY,		ATTR_DEFAULT,	&XDataContainer_getCppuType },
	{ "MessageCC",			WID_CC,					ATTR_DEFAULT,	&OUString_getCppuType },
	{ "MessageFrom",		WID_FROM,				ATTR_DEFAULT,	&OUString_getCppuType },
	{ "MessageId",			WID_MESSAGE_ID,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "MessageInReplyTo",	WID_IN_REPLY_TO,		ATTR_DEFAULT,	&OUString_getCppuType },
	{ "MessageReplyTo",		WID_REPLY_TO,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "MessageTo",			WID_TO,					ATTR_DEFAULT,	&OUString_getCppuType },
	{ "NamingConvention",	WID_PRJ_FILENAMECONVENTION,
													ATTR_DEFAULT,	&enum_getCppuType },
// Not used:
//	{ "NewsGroupCount",		WID_NEWSGROUPCOUNT,		ATTR_DEFAULT,	&sal_uInt32_getCppuType },
	{ "NewsGroups",			WID_NEWSGROUPS,			ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "NewsSendPassword",	WID_NEWSSEND_PASSWORD,	ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "NewsSendServerName",	WID_NEWSSEND_SERVERNAME,ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "NewsSendUserName",	WID_NEWSSEND_USERNAME,	ATTR_DEFAULT,	&OUString_getCppuType },
	{ "NextUpdate",			WID_COLUMN_NEXT_UPD,	ATTR_DEFAULT,	&DateTime_getCppuType },
	{ "NoCacheList",		WID_HTTP_NOCACHE_LIST,	ATTR_DEFAULT,	&OUString_getCppuType },
	{ "NotifyAddress",		WID_NOTIFICATION_ADDRESS,
													ATTR_DEFAULT,	&OUString_getCppuType },
	{ "NotifyMode",			WID_NOTIFICATION_MODE,	ATTR_DEFAULT,	&sal_uInt16_getCppuType },
// Not used:
//	{ "ObsoleteTitle",		WID_OBSOLETE_TITLE,	  	ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Origin",				WID_TRASH_ORIGIN,		ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&OUString_getCppuType },
// Internally used only:
//	{ "OutgoingMessageExternalState",
//							WID_OUTMSGEXTERNALSTATE,ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "OutgoingMessageRecipients",
							WID_RECIPIENTLIST,		ATTR_DEFAULT,	&Sequence_RecipientInfo_getCppuType },
	{ "OutgoingMessageState",
							WID_OUTMSGINTERNALSTATE,ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&enum_getCppuType },
	{ "OutgoingMessageViewMode",
							WID_SENTMESSAGEVIEW_MODE,
													ATTR_DEFAULT,	&enum_getCppuType },
// Internally used only:
//	{ "OwnURL",				WID_OWN_URL,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Password",			WID_PASSWORD,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "PresentationURL",	WID_REAL_URL,			ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&OUString_getCppuType },
	{ "Priority",         	WID_PRIORITY,			ATTR_DEFAULT,	&enum_getCppuType },
// Used to transport id's of the property tabpages for the object type.
	{ "Properties",			WID_PROPERTYLIST,		ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&Sequence_Int16_getCppuType },
// Internally used only:
//	{ "RangesKnown",		WID_KNOWN_RANGES,		ATTR_DEFAULT,	NULL },
// Internally used only:
//	{ "RangesMarked",		WID_MARK_RANGES,		ATTR_DEFAULT,	NULL },
// Internally used only:
//	{ "RangesServer",		WID_SERVER_RANGES,	   	ATTR_DEFAULT,	NULL },
// Internally used only:
//	{ "RangesRead",			WID_READ_RANGES,		ATTR_DEFAULT,	NULL },
// Internally used only:
//	{ "ReferedURL",			WID_REFERED_URL,		ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Reference",			WID_HREF,				ATTR_DEFAULT,	&OUString_getCppuType },
	{ "References",			WID_REFERENCES,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Referer",			WID_HTTP_REFERER,		ATTR_DEFAULT,	&OUString_getCppuType },
// Internally used only:
//	{ "Referers",			WID_REFERER_COUNT,		ATTR_DEFAULT,	&sal_uInt32_getCppuType },
	{ "RenameableProps",	WID_RENAME,			   	ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&Sequence_OWString_getCppuType },
	{ "RequiresOutBox",		WID_OUTTRAY_WANTED,	  	ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_Bool_getCppuType },
// Not used:
//	{ "RuleApplied",		WID_RULE_APPLIED,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "Rules",				WID_RULES,				ATTR_DEFAULT,	&RuleSet_getCppuType },
// Not used:
//	{ "SMTPGateway",		WID_SMTP_GATEWAY,		ATTR_DEFAULT,	&OUString_getCppuType },
	{ "ScheduleRange",		WID_SCHEDULE_RANGE,		ATTR_DEFAULT,	&DateTimeRange_getCppuType },
	{ "SearchCriteria",		WID_SEARCH_CRITERIA,	ATTR_DEFAULT,	&RuleSet_getCppuType },
	{ "SearchIndirections",	WID_SEARCH_INDIRECTIONS,ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "SearchLocations", 	WID_SEARCH_LOCATIONS,	ATTR_DEFAULT,	&OUString_getCppuType },
	{ "SearchRecursive",	WID_SEARCH_RECURSIVE,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "SeenCount", 			WID_SEENCONTENTCOUNT,	ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_uInt32_getCppuType },
// Internally used only:
//	{ "SeenState",			WID_SEEN_STATUS,		ATTR_DEFAULT,	&enum_getCppuType },
	{ "SendCopyTarget",		WID_SEND_COPY_TARGET,	ATTR_DEFAULT,	&Sequence_SendInfo_getCppuType },
// Not used:
//	{ "SendFrom",			WID_FROM_DEFAULT,		ATTR_DEFAULT,	&OUString_getCppuType },
	{ "SendFormats",		WID_SEND_FORMATS,		ATTR_DEFAULT,	&Sequence_SendMediaTypes_getCppuType },
	{ "SendFroms",			WID_SEND_FROM_DEFAULT,	ATTR_DEFAULT,	&Sequence_SendInfo_getCppuType },
	{ "SendPasswords",		WID_SEND_PASSWORD,		ATTR_DEFAULT,	&Sequence_SendInfo_getCppuType },
	{ "SendProtocolPrivate",WID_SEND_PRIVATE_PROT_ID,
													ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "SendProtocolPublic", WID_SEND_PUBLIC_PROT_ID,
													ATTR_DEFAULT,	&sal_uInt16_getCppuType },
// Not used:
//	{ "SendReplyTo",		WID_REPLY_TO_DEFAULT,	ATTR_DEFAULT,	&OUString_getCppuType },
	{ "SendReplyTos",		WID_SEND_REPLY_TO_DEFAULT,
													ATTR_DEFAULT,	&Sequence_SendInfo_getCppuType },
	{ "SendServerNames",	WID_SEND_SERVERNAME,	ATTR_DEFAULT,	&Sequence_SendInfo_getCppuType },
	{ "SendUserNames",		WID_SEND_USERNAME,		ATTR_DEFAULT,	&Sequence_SendInfo_getCppuType },
	{ "SendVIMPostOfficePath",
							WID_SEND_VIM_POPATH,	ATTR_DEFAULT,	&OUString_getCppuType },
	{ "ServerBase",			WID_SERVERBASE,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "ServerName",			WID_SERVERNAME,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "ServerPort",			WID_SERVERPORT,			ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "ShowExtensions", 	WID_FSYS_SHOW_EXTENSION,ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "ShowHiddenObjects",	WID_FSYS_SHOW_HIDDEN,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "ShowInExplorer",		WID_SHOW_IN_EXPLORER,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "Size",				WID_DOCUMENT_SIZE,		ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_uInt64_getCppuType },
	{ "SizeLimit",			WID_SIZE_LIMIT,			ATTR_DEFAULT,	&sal_uInt64_getCppuType },
	{ "SortCriteria",		WID_SORTING,			ATTR_DEFAULT,	&Sequence_SortingInfo_getCppuType },
	{ "StoreOnlyIfMarked",	WID_STORE_MARKED,		ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "SubscribedCount", 	WID_SUBSCRNEWSGROUPCOUNT,
													ATTR_DEFAULT | PropertyAttribute::READONLY,
																							&sal_uInt32_getCppuType },
	{ "SynchronizePolicy",	WID_WHO_IS_MASTER,	   	ATTR_DEFAULT,	&enum_getCppuType },
	{ "TargetFrames",		WID_TARGET_FRAMES,		ATTR_DEFAULT,	&OUString_getCppuType },
	{ "TargetURL",			WID_TARGET_URL,			ATTR_DEFAULT,	&OUString_getCppuType },
// Obsolete.
//	{ "ThreadingInfo",		WID_THREADING,			ATTR_DEFAULT,	&Sequence_ThreadingInfo_getCppuType },
	{ "TimeLimitStore",		WID_STORE_MSGS_TIMELIMIT,
													ATTR_DEFAULT,	&sal_uInt16_getCppuType },
	{ "TipHelp",			WID_VIEW_TIPHELP,		ATTR_DEFAULT,	&OUString_getCppuType },
	{ "Title",				WID_TITLE,				ATTR_DEFAULT,	&OUString_getCppuType },
	{ "UpdateOnOpen",		WID_FLAG_UPDATE_ON_OPEN,ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "UseDocumentViewSettingsOnSearch",
							WID_SEARCH_DOCUMENT_VIEW,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "UseFolderViewSettingsOnSearch",
							WID_SEARCH_FOLDER_VIEW,	ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "UseOutBoxPrivateProtocolSettings",
							WID_SEND_PRIVATE_OUTBOXPROPS,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "UseOutBoxPublicProtocolSettings",
							WID_SEND_PUBLIC_OUTBOXPROPS,
													ATTR_DEFAULT,	&sal_Bool_getCppuType },
	{ "UserName",			WID_USERNAME,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "UserSortCriterium",	WID_USER_SORT_CRITERIUM,ATTR_DEFAULT,	&OUString_getCppuType },
	{ "VIMPostOfficePath",	WID_VIM_POPATH,			ATTR_DEFAULT,	&OUString_getCppuType },
	{ "ValueAddedMode",     WID_VALUE_ADDED_MODE,	ATTR_DEFAULT,	&enum_getCppuType },
	{ "VerificationMode",	WID_HTTP_VERIFY_MODE,	ATTR_DEFAULT,	&enum_getCppuType },
// Not used.
//	{ "ViewData",			WID_VIEWDATA,			ATTR_DEFAULT,	&OUString_getCppuType },
// Not used:
//	{ "ViewDescription",	WID_VIEW_DESCRIPTION,	ATTR_DEFAULT,	NULL },

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Commands:
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////

	{ "clearDiskCache",		WID_CLEAN_CACHE,	   	0,				&void_getCppuType },
	{ "close",				WID_CLOSE,			   	0,				&void_getCppuType },
	{ "copy",				WID_COPY,				0,				&void_getCppuType },
// Implemented directly...
//	{ "createNew",			WID_CREATE_NEW,			0,				NULL },
	{ "cut", 				WID_CUT,				0,				&void_getCppuType },
	{ "default",  			WID_DEFAULT,			0,				&Sequence_OWString_getCppuType },
	{ "delete",				WID_DELETE,				0,				&sal_Bool_getCppuType },
	{ "emptyTrash",			WID_TRASHCAN_EMPTY_TRASH,
													0,				&void_getCppuType },
	// !!! Different types in CHAOS-StarOne-API and UCB-API !!! Old: OUString
	{ "export",				WID_EXPORT,				0,				&ExportStreamInfo_getCppuType },
// Implemented outside CHAOS!
//	{ "forward",			WID_FORWARD,			0,				&void_getCppuType },
	{ "hideAuthor",			WID_HIDE_AUTHOR,		0,				&void_getCppuType },
	{ "hideSubject",		WID_HIDE_SUBJECT,		0,				&void_getCppuType },
	{ "hideThread",			WID_HIDE_THREAD,		0,				&void_getCppuType },
	// !!! Different types in CHAOS-StarOne-API and UCB-API !!! Old: OUString
	{ "import",				WID_IMPORT,				0,				&XInputStream_getCppuType },
// Internally used only:
//	{ "initialize", 		WID_GETDATA,			0,				&void_getCppuType },
	// !!! Different types in CHAOS-StarOne-API and UCB-API !!! Old: Void
	{ "insert",				WID_INSERT,				0,				&InsertCommandArgument_getCppuType },
// Implemented outside CHAOS!
//	{ "mailReply", 			WID_MAIL_REPLY,			0,				&void_getCppuType },
	{ "markThreadRead",   	WID_MARK_THREAD_READ,	0,				&void_getCppuType },
	{ "markThreadUnread", 	WID_MARK_THREAD_UNREAD,	0,				&void_getCppuType },
	// !!! Different types in CHAOS-StarOne-API and UCB-API !!! Old: enum OpenMode
	{ "open",				WID_OPEN,				0,				&OpenCommandArgument2_getCppuType },
	{ "paste",				WID_PASTE,				0,				&void_getCppuType },
	// !!! Different types in CHAOS-StarOne-API and UCB-API !!! Old: Void
	{ "post",				WID_HTTP_POST,			0,				&PostCommandArgument_getCppuType },
// Implemented outside CHAOS!
//	{ "postReply",    		WID_POST_REPLY,			0,				&void_getCppuType },
	{ "prepareMove",		WID_PREPARE_MOVE,		0,				&void_getCppuType },
// Internally used only:
// 	{ "putData", 			WID_PUTDATA,			0,				NULL },
// Obsolete:
//	{ "reopen",				WID_REOPEN,				0,				&void_getCppuType },
	{ "reorganizeData",		WID_PURGE,				0,				&void_getCppuType },
	{ "resendMessage",		WID_RESEND_MSG,			0,				&void_getCppuType },
	{ "restore",			WID_TRASH_RESTORE,		0,				&void_getCppuType },
	{ "search",				WID_SEARCH,				0,				&SearchCommandArgument_getCppuType },
	{ "setAsDefault",		WID_SET_AS_DEFAULT,		0,				&Sequence_OWString_getCppuType },
	{ "setTransferResult",	WID_TRANSFER_RESULT,	0,				&TransferResult_getCppuType },
	// !!! Different types in CHAOS-StarOne-API and UCB-API !!! Old: Void
	{ "synchronize",		WID_SYNCHRONIZE,		0,				&OpenCommandArgument2_getCppuType },
	{ "transfer",			WID_TRANSFER,			0,				&TransferInfo_getCppuType },
	{ "undelete",			WID_UNDELETE,			0,				&void_getCppuType },
	// !!! Different types in CHAOS-StarOne-API and UCB-API !!! Old: Void
	{ "update",				WID_UPDATE,				0,				&OpenCommandArgument2_getCppuType },
	{ "userCommand",		WID_COMPONENT_COMMAND,	0,				&Command_getCppuType },

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// EOT.
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////

	{ 0, 0, 0, 0 }
};

static const CntItemMap aMap_Impl( &aItemMap_Impl[ 0 ] );

//=========================================================================
//
//	CntItemPool implementation
//
//=========================================================================

static CntStaticPoolDefaults_Impl* pPoolDefs_Impl = NULL;

// static member!
CntItemPool* CntItemPool::_pThePool = NULL;

//-------------------------------------------------------------------------
CntItemPool::CntItemPool()
: SfxItemPool(
	UniString::CreateFromAscii(	RTL_CONSTASCII_STRINGPARAM( "chaos" ) ),
	WID_CHAOS_START, WID_CHAOS_END, NULL ),
  _nRefs( 0 )
{
    SetFileFormatVersion( SOFFICE_FILEFORMAT_50 );

	FreezeIdRanges();

	// Create static defaults.
	pPoolDefs_Impl = new CntStaticPoolDefaults_Impl( this );

	// Set item infos.
	SetItemInfos( pPoolDefs_Impl->GetItemInfos() );

	// Set static pool default items.
	SetDefaults( pPoolDefs_Impl->GetDefaults() );
}

//-------------------------------------------------------------------------
//virtual
CntItemPool::~CntItemPool()
{
	// Release static pool default items.
	ReleaseDefaults( FALSE );
}

//-------------------------------------------------------------------------
// static
CntItemPool* CntItemPool::Acquire()
{
	if ( !_pThePool )
		_pThePool = new CntItemPool;

	_pThePool->_nRefs++;

	return _pThePool;
}

//-------------------------------------------------------------------------
// static
USHORT CntItemPool::Release()
{
	if ( !_pThePool )
		return 0;

	USHORT& nRefs = _pThePool->_nRefs;

	if ( nRefs )
		--nRefs;

	if ( !nRefs )
	{
		DELETEZ( _pThePool );
		DELETEZ( pPoolDefs_Impl );
		return 0;
	}

	return nRefs;
}

//-------------------------------------------------------------------------
SfxItemPresentation CntItemPool::GetPresentation(
	const SfxPoolItem&	rItem,
	SfxItemPresentation ePresentation,
	SfxMapUnit			ePresentationMetric,
	XubString&			rText,
    const IntlWrapper * ) const
{
	USHORT nWhich = rItem.Which();

	DBG_ASSERT( ( nWhich >= GetFirstWhich() ) && ( nWhich <= GetLastWhich() ),
		        "Bad which in GetPresentation" );

	if ( nWhich == WID_CREATE_NEW )
	{
		const CntItemListItem *pCreateItem =
									PTR_CAST( CntItemListItem, &rItem );
		if ( pCreateItem )
		{
			const CntStringItem *pNameItem =
				(const CntStringItem*)pCreateItem->Get( WID_FACTORY_NAME );
			rText = pNameItem->GetValue();
			return SFX_ITEM_PRESENTATION_NAMELESS;
		}
	}

	USHORT nResId = nWhich - GetFirstWhich() + RID_CNT_POOL_PRES_NAME_START;
	rText = String( CntResId( nResId ) );
	return SFX_ITEM_PRESENTATION_NAMEONLY;
}

//-------------------------------------------------------------------------
const SfxPoolItem& CntItemPool::Put( const SfxPoolItem& rItem, USHORT nWhich )
{
	// Da wir nur einen Pool haben, muss ein Item, dass einen RefCount hat,
	// schon in diesem Pool sein!
	if ( /* rItem.GetRef() */ IsPooledItem( &rItem ) )
	{
		AddRef( rItem );
		return rItem;
	}
	else
		return SfxItemPool::Put( rItem, nWhich );
}

//-------------------------------------------------------------------------
// static
const CntItemMap* CntItemPool::GetItemMap()
{
	return &aMap_Impl;
}

//=========================================================================
//
//	CntItemMap implementation
//
//=========================================================================

namespace chaos {

struct CntWhich2PropEntry
{
	USHORT nWhich;
	ULONG  nPropMapIndex;

	CntWhich2PropEntry( USHORT nWID, ULONG nIndex )
	: nWhich( nWID ), nPropMapIndex( nIndex ) {}
};

DECLARE_LIST( CntWhich2PropList, CntWhich2PropEntry* )

}

//-------------------------------------------------------------------------
CntItemMap::CntItemMap( const CntItemMapEntry* pPropMap )
:  _nCount( 0 ),
  _pWhichList( NULL ),
  _pPropMap( pPropMap )
{
	const CntItemMapEntry *pCurr = &_pPropMap[ 0 ];
	while ( pCurr->pName )
	{
#ifdef DBG_UTIL
		if ( ( pCurr + 1 )->pName )
		{
			UniString aName( UniString::CreateFromAscii( pCurr->pName ) );
			if ( aName.CompareToAscii( ( pCurr + 1 )->pName ) != COMPARE_LESS )
			{
				ByteString aTmp(
					RTL_CONSTASCII_STRINGPARAM(
					  	"CntItemMap: Item map not sorted! -> " ) );
				aTmp += ( pCurr + 1 )->pName;
				DBG_ERROR( aTmp.GetBuffer() );
			}
		}
#endif
		pCurr++;
		_nCount++;
	}
}

//-------------------------------------------------------------------------
CntItemMap::~CntItemMap()
{
	if ( _pWhichList )
	{
		for ( ULONG n = 0; n < _pWhichList->Count(); ++n )
			delete _pWhichList->GetObject( n );

		delete _pWhichList;
	}
}

//-------------------------------------------------------------------------
const CntItemMapEntry* CntItemMap::Prop2Which( const UniString& rProp ) const
{
	if ( !_nCount || !_pPropMap )
		return NULL;

	// Binary search...

	StringCompare nCompVal = COMPARE_GREATER;
	const CntItemMapEntry *pMid = NULL;

	long nMid;
	long nStart = 0;
	long nEnd   = _nCount - 1;

	while ( ( nCompVal != COMPARE_EQUAL ) && ( nStart <= nEnd ) )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;
		pMid = &_pPropMap[ nMid ];

		nCompVal = rProp.CompareToAscii( pMid->pName );

		if ( nCompVal == COMPARE_GREATER )
			nStart = nMid + 1;
		else
			nEnd = nMid - 1;
	}

	if ( nCompVal == COMPARE_EQUAL )
		return pMid;
	else
		return NULL;
}

//-------------------------------------------------------------------------
const CntItemMapEntry* CntItemMap::Which2Prop( USHORT nWhich ) const
{
	if ( !_nCount || !_pPropMap )
		return NULL;

	if ( !_pWhichList )
	{
		CntItemMap* pVarThis = CONST_CAST( CntItemMap*, this );

		// Dynamically create a list sorted by WID's from static
		// table, which is sorted by property strings.
		for ( ULONG n = 0; n < _nCount; ++n )
			pVarThis->InsertInWhichList_Impl(
				new CntWhich2PropEntry( _pPropMap[ n ].nWhich, n ) );
	}

	// Binary search...

	long nMid;
	long nStart = 0;
	long nEnd   = _nCount - 1;

	while ( nStart <= nEnd )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;

		CntWhich2PropEntry* pMid = _pWhichList->GetObject( nMid );
		if ( pMid->nWhich == nWhich )
		{
			// Gotcha!
			return &_pPropMap[ pMid->nPropMapIndex ];
		}
		else if ( pMid->nWhich < nWhich )
			nStart = nMid + 1;
		else
			nEnd = nMid - 1;
	}

//	DBG_ERROR( "CntItemMap::Which2Prop - entry not found!" );
	return NULL;
}

//-------------------------------------------------------------------------
const CntItemMapEntry* CntItemMap::GetObject( ULONG nIndex ) const
{
	if ( !_nCount || !_pPropMap )
		return NULL;

	if ( ( nIndex + 1 ) > _nCount )
	{
		DBG_ERROR( "CntItemMap::GetObject - index out of range!" );
		return NULL;
	}

	return &( _pPropMap[ nIndex ] );
}

//-------------------------------------------------------------------------
void CntItemMap::InsertInWhichList_Impl( CntWhich2PropEntry* pEntry )
{
	if ( !_pWhichList )
	{
		_pWhichList = new CntWhich2PropList( (USHORT)_nCount );
		_pWhichList->Insert( pEntry );
	}
	else
	{
		// Binary insert...

		BOOL bLess  = FALSE;
		long nStart = 0;
		long nEnd	= _pWhichList->Count() - 1;
		long nMid	= nEnd / 2;

		while ( nStart <= nEnd )
		{
			nMid = ( nEnd - nStart ) / 2 + nStart;
			CntWhich2PropEntry* pData = _pWhichList->GetObject( nMid );

            if ( pData->nWhich > pEntry->nWhich )
            {
				bLess = FALSE;
				nEnd  = nMid - 1;
			}
			else
			{
				bLess  = TRUE;
				nStart = nMid + 1;
			}
		}

		if ( bLess )
			_pWhichList->Insert( pEntry, nMid + 1 );
		else
			_pWhichList->Insert( pEntry, nMid );
	}
}

