/*************************************************************************
 *
 *  $RCSfile: cntrnmgr.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _VOS_TIMER_HXX_
#include <vos/timer.hxx>
#endif
#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif
#ifndef _TOOLS_SIMPLERESMGR_HXX_
#include <tools/simplerm.hxx>
#endif
#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _UNOTOOLS_INTLWRAPPER_HXX
#include <unotools/intlwrapper.hxx>
#endif

#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _LOGINERR_HXX //autogen
#include <svtools/loginerr.hxx>
#endif
#ifndef _SFXCANCEL_HXX //autogen
#include <svtools/cancel.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _ADRPARSE_HXX
#include <svtools/adrparse.hxx>
#endif

#include <cntrnmgr.hxx>

#ifndef _CNTDATA_HXX
#include <cntdata.hxx>
#endif
#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif
#ifndef _CHAOS_SILITEM_HXX
#include <silitem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CNTCOOK_HXX
#include <cntcook.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTDEFS_HXX
#include <cntdefs.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CNTDISP_HXX
#include <cntdisp.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif
#ifndef _CNTINET_HXX
#include <cntinet.hxx>
#endif
#ifndef CHAOS_SLSTITEM_HXX
#include <slstitem.hxx>
#endif

// service dependencies...
#ifndef _CNTOUT_HXX
#include <cntout.hxx>
#endif

using namespace chaos;

using namespace com::sun::star::lang;
using namespace com::sun::star::uno;

//=========================================================================

// Remove passwords from requesting jobs immediately after the
// job is done/cancelled. ( part. fix for #42895# )
#define AUTO_REMOVE_PASSWORDS

// late initialization of update timers.
#define LAZY_UPDATETIMER_INIT_DELAY ( (ULONG)60 ) /* seconds */

// file name for RNM's storage
#define RNM_STG_FILE_NAME "rootstg"

// Number of worker threads for the job dispatcher.
#define JOB_DISPATCHER_WORKER_COUNT  4

// Misc streams
#define CNT_TRANSACTION_LIST_VERSION 2
#define CNT_TRANSACTION_LIST_STREAM  ".Transactions"
#define CNT_OUTTRAY_URL_STREAM		 ".Outbox"
#define CNT_AUTOUPDATE_LIST_VERSION	 2
#define CNT_AUTOUPDATE_STREAM	 	 ".AutoUpdates"
#define CNT_FILENAMETABLE_VERSION	 2
#define CNT_FILENAMETABLE_STREAM 	 ".FileNameTable"
#define CNT_VIEW_LIST_VERSION	 	 2
#define CNT_VIEW_LIST_STREAM 	 	 ".Views"
#define CNT_EXPLORER_LIST_VERSION 	 2
#define CNT_EXPLORER_LIST_STREAM  	 ".Explorers"

TYPEINIT1( CntUpdateHint, SfxHint );

//=========================================================================

namespace chaos
{

//=========================================================================

class CntUpdateTimer : public NAMESPACE_VOS( OTimer ), public SfxListener
#ifndef USE_JOB_DISPATCHER
					 , public CntThreadSwitcher
#endif
{
private:
	String	  		_aTargetURL;
	CntAnchorRef	_xAnchor;
	ULONG			_nNewMessages;
	ULONG			_nInterval;

protected:
	virtual ~CntUpdateTimer();
	virtual void SAL_CALL onShot();

#ifndef USE_JOB_DISPATCHER
	virtual void SwitchedToMain();
#endif

public:
	CntUpdateTimer( const String& rTargetURL, ULONG nInterval );

	void Update();

	const String& GetURL() const { return _aTargetURL; }
	CntAnchor*	  GetAnchor() const { return _xAnchor; }
	ULONG		  GetTimeout() const { return _nInterval; }
	inline void	  SetTimeout( ULONG nInterval );

	virtual void  Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

inline void	CntUpdateTimer::SetTimeout( ULONG nInterval )
{
	_nInterval = nInterval,	setRemainingTime( nInterval );
}

//=========================================================================

class CntUpdateInitTimer : public NAMESPACE_VOS( OTimer )
#ifndef USE_JOB_DISPATCHER
					     , public CntThreadSwitcher
#endif
{
private:
	CntUpdateList* _pList;

	void StartAutoUpdate();

protected:
	virtual ~CntUpdateInitTimer();
	virtual void SAL_CALL onShot();

#ifndef USE_JOB_DISPATCHER
	virtual void SwitchedToMain();
#endif

public:
	CntUpdateInitTimer( CntUpdateList *pList );
};

//=========================================================================

struct CntUpdateEntry
{
	String  								_aURL;
	NAMESPACE_VOS( ORef )< CntUpdateTimer > _xTimer;

	CntUpdateEntry( const String& rURL,
					const NAMESPACE_VOS( ORef )< CntUpdateTimer >& rTimer )
	: _aURL( rURL ), _xTimer( rTimer ) {}
};

//=========================================================================

struct CntFileNameEntry
{
	String _aLongName;
	String _aShortName;

	CntFileNameEntry( const String& rLongName, const String& rShortName )
	: _aLongName( rLongName ), _aShortName( rShortName ) {}
};

//=========================================================================

struct CntPasswordEntry
{
	String _aURL;
	String _aServer;
	String _aRealm;
	String _aUser;
	String _aPassword;
	String _aAccount;
	ULONG  _nSubmitter;

	CntPasswordEntry( const String& rURL,
					  const String& rServer,
					  const String& rRealm,
	                  const String& rUser,
	                  const String& rPassword,
					  const String& rAccount,
	                  ULONG nSubmitter )
	: _aURL( rURL ), _aServer( rServer ), _aRealm( rRealm ), _aUser( rUser ),
	  _aPassword( rPassword ), _aAccount( rAccount ), _nSubmitter( nSubmitter )
	{}
};

//=========================================================================

struct CntErrorHandler
{
	const CntInterface* _pClient;
	Link   		  		_aLink;

	CntErrorHandler( const CntInterface* pClient,
					 const Link& rLink )
	: _pClient( pClient ),
	  _aLink( rLink )
	{
	}
};

//============================================================================
 
} // namespace chaos

//============================================================================
//
// CntRootNodeMgr Implementation.
//
//============================================================================

TYPEINIT1_AUTOFACTORY( CntRootNodeMgr, CntNode );

//----------------------------------------------------------------------------
CNT_NODE_SUBCLASS_IMPL( CntRootNodeMgr )
{
	// Nothing to do. (RNM has no factories to register)
}

//----------------------------------------------------------------------------
// static members !!!
CntSystemData_Impl* CntRootNodeMgr::_pSysData  = NULL;
CntRootNodeMgr*     CntRootNodeMgr::_pTheRNM   = NULL;

//----------------------------------------------------------------------------
CntRootNodeMgr::CntRootNodeMgr()
:	CntNode( NULL ),
    _eConnMode( CNT_CONN_MODE_ONLINE ),
	_xStorage( 0 ),
	_aUpdateList( 0 ),
	_pInitTimer( NULL ),
	_aFileEntryList( 0 ),
	_aPasswordList( 0 ),
	_aSchedulerList( 0 ),
	_pErrorHandlerList( NULL ),
#ifdef USE_JOB_DISPATCHER
	_pDispatcher( new CntJobDispatcher( JOB_DISPATCHER_WORKER_COUNT ) ),
#else
	_pDispatcher( NULL ),
#endif
	_aViewTypesList( 0 ),
	_aViewList( 0 ),
	_aExplorerList( 0 ),
	_bKeepPassword( TRUE ),
	_bLazyInitDone( FALSE )
{
	// Remember me!
	_pTheRNM = this;

	// Get/create System data.
	GetOrCreateSystemData();

	// Register factories for service nodes.
	RegisterFactories();

	// Get list of registered file types.
	ULONG nCount = FactoryCount();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		const UniString aPattern1(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( "file:///*" ) ) );
		const UniString aPattern2(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( "file:///*.scs" ) ) );
		const UniString aPattern3(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( "file://" ) ) );

        String aWild = GetFactory( n )->GetWildCard();
        if ( ( aWild != aPattern1 ) &&         // FSYS-RootNode
             ( aWild != aPattern2 ) &&   // Non-View-StorageNodes
             ( aWild.Search( aPattern3 ) == 0 ) )
            _aViewTypesList.Insert( new String( aWild ), LIST_APPEND );
	}

	// Create "Create New" item.
	CntDefaults *pClassDefs = GetDefaults();
	if ( pClassDefs == NULL )
	{
		// Create new class defaults
		pClassDefs = new CntDefaults( *this, NULL );
	}
	CntInterface::SetParent( pClassDefs );
}

//----------------------------------------------------------------------------
// virtual
CntRootNodeMgr::~CntRootNodeMgr()
{
	// Save transactions
	SaveTransActionList_Impl();

	if ( _pInitTimer )
		_pInitTimer->release();

	ULONG n;

	// delete update request list...
	for ( n = 0; n < _aUpdateList.Count(); n++ )
		delete _aUpdateList.GetObject( n );

	// delete file name conversion list...
	for ( n = 0; n < _aFileEntryList.Count(); n++ )
		delete _aFileEntryList.GetObject( n );

	// delete password list...
	for ( n = 0; n < _aPasswordList.Count(); n++ )
		delete _aPasswordList.GetObject( n );

	// delete error handler list...
	if ( _pErrorHandlerList )
	{
		DBG_ERROR( "~CntRootNodeMgr - Error handler list not empty!" );
		for ( n = 0; n < _pErrorHandlerList->Count(); n++ )
			delete _pErrorHandlerList->GetObject( n );
	}

	// delete list of views...
	for ( n = 0; n < _aViewList.Count(); n++ )
		delete _aViewList.GetObject( n );

	// delete list of explorers...
	for ( n = 0; n < _aExplorerList.Count(); n++ )
		delete _aExplorerList.GetObject( n );

	// delete list of registered view file types...
	for ( n = 0; n < _aViewTypesList.Count(); n++ )
		delete _aViewTypesList.GetObject( n );

	// destroy job dispatcher...
	delete _pDispatcher;

	// release our storage BEFORE we die...
	_xStorage = NULL;

	// next CntRootNodeMgr::Get() will create a new RNM
	_pTheRNM = NULL;

	// No more INI manager notifications, please...
	CntIniManager*& rpIniMgr = CNT_DATA()->_pIniMgr;
	if ( rpIniMgr )
		rpIniMgr->stopSettingsChangeListener();

	// delete CHAOS system data
	delete _pSysData;
	_pSysData = NULL;
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::Deinitialize()
{
	// Any action taken here can destroy this!
	CntNodeRef xThis = this;

	// System Cleanup:
	// When the application deinitializes, any Application::PostUserEvent(...)
	// calls will not work any longer. Because scheduling of jobs is done by
	// posting events, there may be jammed jobs, which hold references on
	// nodes. These jobs must be freed here (at least in order to free the
	// nodes)!
	// (1) Active auto-update timers hold a reference on an Cntanchor until
	//     the update job is done. The anchor holds its refered nodes.
	//     Anyway, this should never happen, because the appliction has
	//	   already cancelled all SfxCancellables when this method is called.
#ifdef USE_JOB_DISPATCHER
	// (2) A CntJobDispatcher holds references to jobs and nodes. It uses
	//     threads for job execution. The references must be released and
	//     the thread must be terminated here.
#else
	// (2) CntJobReschedulers are timers holding references on jobs and nodes.
	//	   Timers use PostUserEvent to activate the "Timeout-handler". A
	//	   CntJobRescheduler destroys itself in that handler!
#endif /* USE_JOB_DISPATCHER */
	// (3) CntNodeJobs have an asynchronous dtor, which uses PostUserEvent.
	//	   The "Done-handler" generally frees the job.

	ULONG nCount = 0,
	      n      = 0;

	//////////////////////////////////////////////////////////////////////
	// (1) Delete update requests.
	//////////////////////////////////////////////////////////////////////

	nCount = _aUpdateList.Count();
	for ( n = 0; n < nCount; n++ )
	{
		CntUpdateEntry* pEntry = _aUpdateList.GetObject( 0 );
		delete pEntry;
		_aUpdateList.Remove( pEntry );
	}

	DBG_ASSERT( _aUpdateList.Count() == 0,
				"CntRootNodeMgr::Deinitialize() - update list not empty!" );

#ifdef USE_JOB_DISPATCHER
	//////////////////////////////////////////////////////////////////////
	// (2) Destroy job dispatcher.
	//////////////////////////////////////////////////////////////////////
	DELETEZ( _pDispatcher );
#else
	//////////////////////////////////////////////////////////////////////
	// (2) Delete job schedulers.
	//////////////////////////////////////////////////////////////////////

	nCount = _aSchedulerList.Count();
	for ( n = 0; n < nCount; n++ )
	{
		CntJobRescheduler* pSched = _aSchedulerList.GetObject( 0 );
		delete pSched;

		// Dying scheduler removes itself from list!
	}

	DBG_ASSERT( _aSchedulerList.Count() == 0,
				"CntRootNodeMgr::Deinitialize() - scheduler list not empty!" );
#endif

	//////////////////////////////////////////////////////////////////////
	// (3) Release jammend jobs.
	//////////////////////////////////////////////////////////////////////

    // All living jobs of the systen are kept in RNM's job queue, which is
    // not used for other purposes ( RNM does never execute jobs ).
	while ( JobCount() )
	{
		CntNodeJob* pJammed = GetJob( 0 );

		// This is really hard stuff, but our last chance!
		pJammed->ReleaseRef();

		// Dying job removes itself from job queue!
	}
}

//----------------------------------------------------------------------------
// static
BOOL CntRootNodeMgr::IsCHAOS()
{
    CntSystemData_Impl* pData = CNT_DATA();
    if ( !pData )
    	return FALSE;

	if ( !pData->_bCHAOSAvail )
	{
		// display error message
		CntRootNodeMgr::Get()->HandleError( ERRCODE_CHAOS_NOTAVAILABLE, NULL );
		return FALSE;
	}
	return TRUE;
};

//----------------------------------------------------------------------------
void CntRootNodeMgr::RestoreProperties_Impl()
{
	if ( _xStorage.Is() )
		return;

	// Create a storage node for our own persistent data...
	String aStorageURL( GetUserDataDirectory() );
	aStorageURL.AppendAscii(
					RTL_CONSTASCII_STRINGPARAM( RNM_STG_FILE_NAME ) );
	aStorageURL += '.';
	aStorageURL.AppendAscii(
					RTL_CONSTASCII_STRINGPARAM( STG_NOTVIEW_FILE_EXTENSION ) );

	CntRootStorageNode* pStorage = new CntRootStorageNode;
	_xStorage = pStorage;
    _xStorage->CntNode::Put(
            CntStringItem( WID_OWN_URL, aStorageURL ), WID_OWN_URL );
	_xStorage->SetChildDelims( '/' );

	// Not setting 'this' as parent of the new node avoids it from
	// holding a ref on me -> otherwise I would never die automatically!
	ErrCode nError = ERRCODE_NONE;
	if ( !pStorage->Initialize( NULL, aStorageURL, nError ) )
	{
		if ( nError == ERRCODE_IO_LOCKVIOLATION )
		{
			// CHAOS cannot be initialized!!!
			// ( Sharing violation on my storage file... )
			CNT_DATA()->_bCHAOSAvail = FALSE;
		}

		_xStorage = NULL;
		return;
	}

	///////////////////////////////////////////////////////////////////
	// restore global connection mode
	///////////////////////////////////////////////////////////////////

	const SfxPoolItem& rItem = _xStorage->Get( WID_CONNECTION_MODE );
	CntNode::Put( rItem, WID_CONNECTION_MODE );
	SetConnMode_Impl( (CntConnMode)ITEM_VALUE( CntConnModeItem, rItem ) );

	CntStorageNode* pStg 	= (CntStorageNode*)&_xStorage;
    SvStream* 		pStream = NULL;

	///////////////////////////////////////////////////////////////////
	// restore filename conversion list
	///////////////////////////////////////////////////////////////////

	CntStringListItem& rListItm = ( (CntStringListItem&)
					( _xStorage->Get( WID_RNM_FILECONVERSION_LIST ) ) );
	List* pList = rListItm.GetList();

	ULONG nCount = pList->Count();
	for ( ULONG i = 0; i < nCount; ++i )
	{
		String aString = *(String*)pList->GetObject( i );
		USHORT nIndex = 0;

		String aLongName ( aString.GetToken( 0, '/', nIndex ) );
		String aShortName( aString.GetToken( 0, '/', nIndex ) );

		_aFileEntryList.Insert(
					new CntFileNameEntry( aLongName, aShortName ) );
	}

	///////////////////////////////////////////////////////////////////
	// restore list of update timers
	///////////////////////////////////////////////////////////////////

	BOOL bSave = FALSE;

	CntStringListItem& rListItem = ( (CntStringListItem&)
					( _xStorage->Get( WID_RNM_UPDATETIMER_LIST ) ) );
	pList = rListItem.GetList();

	nCount = pList->Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		String aString = *(String*)pList->GetObject( n );
		xub_StrLen nTokens = aString.GetTokenCount( ' ' );

		// There must be at least 2 tokens ( <url> <interval> )
		if ( nTokens < 2 )
		{
			// Remove invalid string from list.
			bSave = TRUE;
			continue;
		}

		String aURL( aString.GetToken( 0, ' ' ) );
		xub_StrLen nToken = 1;
		while ( nToken < ( nTokens - 1 ) )
		{
			aURL += ' ';
			aURL += aString.GetToken( nToken, ' ' );
			nToken++;
		}

		// Is there one of our own protocol prefixes in URL?
		if ( aURL.GetChar( 0 ) == '.' )
		{
			// Ignore the entry. Now (>371) we are using always
			// file: - URL's. The old .cache: - URL's cannot be
			// translated. Sorry. The appropriate autoupdate-
			// client will adapt itself upon its next Open-Job.
			bSave = TRUE;
			continue;
		}
		else
		{
			INetURLObject aURLObject( aURL );
			if ( aURLObject.HasError() )
			{
				// Remove invalid URL from list.
				bSave = TRUE;
				continue;
			}

			// Error handling for file-URL's.
			if ( aURLObject.GetProtocol() == INET_PROT_FILE )
			{
				const UniString aPattern(
								UniString::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM( "#/" ) ) );
				if ( aURL.Search( aPattern ) != STRING_NOTFOUND )
				{
					// Compatibility: In versions < 381, there the
					// refered URL's in view URL's were stored relative.
					bSave = TRUE;
					continue;
				}

				if ( !CntViewBase::ViewFileExists( aURL ) )
				{
					// Somebody killed the file represented
					// by the URL!!!
					bSave = TRUE;
					continue;
				}
			}
		}

		ULONG nInterval = ULONG( aString.GetToken( nTokens-1, ' ' ).ToInt64() );
		vos::ORef< CntUpdateTimer > xTimer =
								new CntUpdateTimer( aURL, nInterval );
		_aUpdateList.Insert( new CntUpdateEntry( aURL, xTimer ) );
	}

	if ( bSave )
		SaveUpdateRequesterList_Impl();

	///////////////////////////////////////////////////////////////////
	// restore out tray URL
	///////////////////////////////////////////////////////////////////

    pStream = pStg->openStream(
				UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( CNT_OUTTRAY_URL_STREAM ) ),
				STREAM_STD_READ );
	if ( pStream )
	{
		SfxPoolItem::readByteString( *pStream, _pSysData->_aOutTrayURL );
		delete pStream;
	}

	///////////////////////////////////////////////////////////////////
	// restore view list
	///////////////////////////////////////////////////////////////////

	bSave = FALSE;

    pStream = pStg->openStream(
				UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( CNT_VIEW_LIST_STREAM ) ),
				STREAM_STD_READ );

	if ( pStream )
	{
		ULONG nVersion = CNT_VIEW_LIST_VERSION;
		ULONG nCount   = 0;
		*pStream >> nVersion;
		*pStream >> nCount;

		for ( ULONG n = 0; n < nCount; ++n )
		{
			String aViewURL;
			SfxPoolItem::readUnicodeString(
									*pStream, aViewURL, nVersion >= 2 );
			String aContentType;
			SfxPoolItem::readUnicodeString(
									*pStream, aContentType, nVersion >= 2 );

			// Check, whether file decribed by aViewURL exists.
			if ( CntViewBase::ViewFileExists( aViewURL ) )
			{
				_aViewList.Insert(
						new CntViewEntry( aViewURL, aContentType ) );
			}
			else
			{
				bSave = TRUE;
			}
		}

		delete pStream;

		if ( bSave )
			SaveViewList_Impl();
	}

	///////////////////////////////////////////////////////////////////
	// restore explorer list
	///////////////////////////////////////////////////////////////////

	bSave = FALSE;

    pStream = pStg->openStream(
				UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( CNT_EXPLORER_LIST_STREAM ) ),
				STREAM_STD_READ );

	if ( pStream )
	{
		ULONG nVersion = CNT_EXPLORER_LIST_VERSION;
		ULONG nCount   = 0;
		*pStream >> nVersion;
		*pStream >> nCount;

		for ( ULONG n = 0; n < nCount; ++n )
		{
			String aDirURL;
			SfxPoolItem::readUnicodeString( *pStream, aDirURL, nVersion >= 2 );

			// Check - whether directory does exist... n.y.i.

			_aExplorerList.Insert( new String( aDirURL ) );
		}

		delete pStream;

		if ( bSave )
			SaveExplorerList_Impl();
	}

	// lazy init of auto update --> performance improvement for
	// application startup, because an update triggers network
	// activities.
	if ( !_pInitTimer )
	{
		_pInitTimer = new CntUpdateInitTimer( &_aUpdateList );
		_pInitTimer->acquire();
	}

	if ( !_pInitTimer->isTicking() )
		_pInitTimer->start();
}

//----------------------------------------------------------------------------
// virtual
void CntRootNodeMgr::Inserted(
				CntNode *pNewNode, CntNodeJob* pJob, BOOL bBroadcast )
{
	// Do not Broadcast the new child!!!
	CntNode::Inserted( pNewNode, pJob, FALSE );

	// Tell the child about global settings ...
	pNewNode->SetConnMode( _eConnMode );

	const String& rURL = OWN_URL( pNewNode );
	if ( IsViewNode( rURL, TRUE ) )
	{
		// View Root node inserted...
		if ( INetURLObject::CompareProtocolScheme( rURL ) == INET_PROT_FILE )
		{
			// Let the folder in which the view node resides propagate it.
			INetURLObject aURLObj( rURL );
			String aPath = aURLObj.GetPartBeforeLastName();

			CntNodeRef xPathNode( Query( aPath ) );
			if ( xPathNode.Is() )
				xPathNode->Broadcast( CntNodeHint( pNewNode,
												   CNT_ACTION_INSERTED,
												   pJob ) );
		}
		else
			DBG_ERROR( "CntRootNodeMgr::Inserted - Unknown View Rootnode!" );
	}
}

//----------------------------------------------------------------------------
String GetDirURLFromIni_Impl( CntSettingKey eKey )
{
	String aDirURL;

	CntIniManager* pIniMgr = CntRootNodeMgr::GetIniManager();
	if ( !pIniMgr )
	{
		DBG_ERROR( "GetDirURLFromIni: no Ini Manager!" );
		return aDirURL;
	}

	// Get key value from INI.
	String aDir( pIniMgr->getEntry( eKey ) );
	if ( !aDir.Len() )
		return aDirURL;

	DirEntry aDirEntry( aDir );

	// Create dir, if it does not exist.
	if ( !aDirEntry.Exists() )
		aDirEntry.MakeDir();

	aDirURL = aDirEntry.GetFull( FSYS_STYLE_URL, TRUE );

	if ( !aDirEntry.IsCaseSensitive() )
		aDirURL.ToLowerAscii();

	return aDirURL;
}

//----------------------------------------------------------------------------
// static
CntRootNodeMgr* CntRootNodeMgr::GetOrCreate()
{
	if ( _pTheRNM )
		return _pTheRNM;

	// Make sure we have our item pool. Otherwise CHAOS can't work.
	CntItemPool* pItemPool = CNT_POOL();
	if ( !pItemPool )
	{
		DBG_ERROR( "CHAOS without item pool? Mission impossible!" );
		return NULL;
	}

	// Create new RNM.
	_pTheRNM = new CntRootNodeMgr;

	// A RootNode-Manager neither has a parent nor a URL...
	_pTheRNM->Initialize( NULL, String() );

	// RestoreProperties_Impl() needs INI-Manager!
	CntIniManager* pIniMgr = GetIniManager();

	// Get our persistent data from storage node...
	_pTheRNM->RestoreProperties_Impl();

	// Obtain values from application's INI and set them as dynamic
	// pool defaults. So all nodes will "have" them automatically.
	// Changes of INI values are handled in CntRootNodeMgr::Put(...)
	if ( pIniMgr )
 	{
		// INI manager notifications, please...
		pIniMgr->startSettingsChangeListener();

		// default receive server
		pItemPool->SetPoolDefaultItem(
			CntStringItem( WID_SERVERNAME,
						   pIniMgr->getEntry( CNT_KEY_INET_POPSERVER) ) );

		CntSendInfoListItem aServerItem( WID_SEND_SERVERNAME );
		// default mail send (SMTP) server
		aServerItem[CNT_OUTMSG_PROTOCOL_SMTP]
		 = pIniMgr->getEntry( CNT_KEY_INET_SMTPSERVER );
		// default news send (NNTP) server
		aServerItem[CNT_OUTMSG_PROTOCOL_NNTP]
		 = pIniMgr->getEntry( CNT_KEY_INET_NNTPSERVER );
		pItemPool->SetPoolDefaultItem( aServerItem );

		// default user name (for sending and receiving)
		String aValue( pIniMgr->getEntry( CNT_KEY_INET_MAILUSERNAME ) );
		pItemPool->SetPoolDefaultItem(
			CntStringItem( WID_USERNAME, aValue ) );

		CntSendInfoListItem aUserItem( WID_SEND_USERNAME );
		aUserItem[CNT_OUTMSG_PROTOCOL_NNTP] = aValue;
		pItemPool->SetPoolDefaultItem( aUserItem );

		// default password (for sending and receiving)
		aValue = pIniMgr->getEntry( CNT_KEY_INET_MAILPASSWORD );

		pItemPool->SetPoolDefaultItem(
			CntStringItem( WID_PASSWORD, aValue ) );

		CntSendInfoListItem aPassItem( WID_SEND_PASSWORD );
		aPassItem[CNT_OUTMSG_PROTOCOL_NNTP] = aValue;
		pItemPool->SetPoolDefaultItem( aPassItem );

		// default sender address
		String aPhrase(pIniMgr->getEntry(CNT_KEY_USER_FIRSTNAME));
		String aSurname(pIniMgr->getEntry(CNT_KEY_USER_NAME));
		if (aPhrase.Len() > 0 && aSurname.Len() > 0)
			aPhrase += ' ';
		aPhrase += aSurname;
		if (!SvAddressParser::createRFC822Mailbox(
			     aPhrase, pIniMgr->getEntry(CNT_KEY_ADDRESS_EMAIL), aValue))
			aValue.Erase();

		CntSendInfoListItem aSenderItem( WID_SEND_FROM_DEFAULT );
		aSenderItem[CNT_OUTMSG_PROTOCOL_SMTP] = aValue;
		aSenderItem[CNT_OUTMSG_PROTOCOL_NNTP] = aValue;
		pItemPool->SetPoolDefaultItem( aSenderItem );

		// default mail formats
		setSendFormats(
			pIniMgr->getEntry( CNT_KEY_INET_MAILTEXTFORMAT ).ToInt32() );
	}

	return _pTheRNM;
}

//----------------------------------------------------------------------------
// static
CntSystemData_Impl*	CntRootNodeMgr::GetOrCreateSystemData()
{
	if ( !_pSysData )
		_pSysData = new CntSystemData_Impl;

	return _pSysData;
}

//----------------------------------------------------------------------------
// static
void CntRootNodeMgr::setSendFormats(USHORT nFormats)
{
	CntSendMediaTypesItem aItem(WID_SEND_FORMATS);
	for (CntOutMsgProtocolType eProtocol = CNT_OUTMSG_PROTOCOL_SMTP;
		 eProtocol < CNT_OUTMSG_PROTOCOL_END;
		 eProtocol = CntOutMsgProtocolType(eProtocol + 1))
	{
		if (nFormats & 1) // TXTFORMAT_ASCII in <goodies/mailenum.hxx>
			aItem[eProtocol].insert(CONTENT_TYPE_TEXT_PLAIN);
		if (nFormats & 2) // TXTFORMAT_HTML in <goodies/mailenum.hxx>
			aItem[eProtocol].insert(CONTENT_TYPE_TEXT_HTML);
		if (nFormats & 4) // TXTFORMAT_RTF in <goodies/mailenum.hxx>
			aItem[eProtocol].insert(CONTENT_TYPE_APP_RTF);
		if (nFormats & 8) // TXTFORMAT_OFFICE in <goodies/mailenum.hxx>
			aItem[eProtocol].insert(CONTENT_TYPE_APP_VND_WRITER); //@@@
	}
	CNT_POOL()->SetPoolDefaultItem(aItem);
}

//----------------------------------------------------------------------------
// static
Reference< XMultiServiceFactory > CntRootNodeMgr::getProcessServiceManager()
{
//	return usr::getProcessServiceFactory();

	XMultiServiceFactory*& rpMgr = GetOrCreateSystemData()->_pProcessServiceMgr;
	if ( rpMgr )
		return Reference< XMultiServiceFactory >( rpMgr );

	DBG_ERROR( "CntRootNodeMgr::getProcessServiceManager - No manager!!!" );
	return Reference< XMultiServiceFactory >();

}

//----------------------------------------------------------------------------
// static
void CntRootNodeMgr::setProcessServiceManager(
						const Reference< XMultiServiceFactory >& rFactory )
{
	XMultiServiceFactory*& rpMgr = GetOrCreateSystemData()->_pProcessServiceMgr;

	if ( rpMgr )
	{
		if ( rFactory.is() )
		{
			DBG_ASSERT( rFactory == Reference< XMultiServiceFactory >( rpMgr ),
						"CntRootNodeMgr::setProcessServiceManager - "
						"Service Manager already set!!!" );
			return;
		}

		rpMgr->release();
	}

	if ( rFactory.is() )
		rFactory->acquire();

	rpMgr = rFactory.get();
}

//----------------------------------------------------------------------------
//static
CntIniManager* CntRootNodeMgr::GetIniManager()
{
	CntIniManager*& rpIniMgr = GetOrCreateSystemData()->_pIniMgr;
	if ( !rpIniMgr )
		rpIniMgr = new CntIniManager();

	return rpIniMgr;
}

//----------------------------------------------------------------------------
//static
void CntRootNodeMgr::SetCancelManager( SfxCancelManager* pCancelMgr )
{
	GetOrCreateSystemData()->_pExtCancelMgr = pCancelMgr;
}

//----------------------------------------------------------------------------
//static
SfxCancelManager* CntRootNodeMgr::GetCancelManager()
{
	SfxCancelManager* pCancelMgr = GetOrCreateSystemData()->_pExtCancelMgr;
	if ( pCancelMgr )
		return pCancelMgr;

	return GetOwnCancelManager();
}

//----------------------------------------------------------------------------
//static
SfxCancelManager* CntRootNodeMgr::GetOwnCancelManager()
{
	SfxCancelManager*& rpCancelMgr = GetOrCreateSystemData()->_pOwnCancelMgr;
	if ( !rpCancelMgr )
		rpCancelMgr = new SfxCancelManager;

	return rpCancelMgr;
}

//----------------------------------------------------------------------------
//static
SimpleResMgr * CntRootNodeMgr::GetResManager()
{
	SimpleResMgr *& rResMgr = GetOrCreateSystemData()->_pResMgr;
	if (!rResMgr)
	{
		rtl::OUString aImageName;
		UniString aTheImageName;
		UniString * pAppName;
		if (vos::OStartupInfo().getExecutableFile(aImageName)
			    == vos::OStartupInfo::E_None)
		{
			aTheImageName = UniString(aImageName);
			pAppName = &aTheImageName;
		}
		else
			pAppName = 0;
		rResMgr = new SimpleResMgr(CREATEVERSIONRESMGR_NAME(cnt),
								   GetIniManager()->
                                       getIntlWrapper().getLanguage(),
								   pAppName);
	}
	return rResMgr;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::getINetWrapper( NAMESPACE_INET( INetWrapper )*&rpWrapper )
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

	if ( !_pSysData->_pINetWrapper )
	{
		_pSysData->_pINetWrapper = new NAMESPACE_INET( INetWrapper );
		CntINetConfig::load( _pSysData->_pINetWrapper, _pSysData->_pIniMgr );
	}

	rpWrapper = _pSysData->_pINetWrapper;
	return !!rpWrapper;
}

//----------------------------------------------------------------------------
BOOL IsInTrash_Impl( const String& rURL )
{
	String aTrashURL( CNT_RNM()->GetTrashDirectory() );
	if ( !aTrashURL.Len() )
		return FALSE;

	if ( aTrashURL.GetChar( aTrashURL.Len() - 1 ) != '/' )
		aTrashURL += '/';

	// In Trash folder?
	if ( rURL.Search( aTrashURL ) != STRING_NOTFOUND )
		return TRUE;

	return FALSE;
}

//----------------------------------------------------------------------------
const String& CntRootNodeMgr::GetOutTrayURL( BOOL bCheck )
{
	String& rOutURL = _pSysData->_aOutTrayURL;
	if ( bCheck && rOutURL.Len() )
	{
		// Check, whether file represented by URL exists.
		if ( !CntStorageNode::StorageFileExists( rOutURL ) )
			SetOutTrayURL( UniString() );
	}

	return rOutURL;
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SetOutTrayURL( const String& rURL )
{
	if ( !_xStorage.Is() )
		return;

	String& rOutURL = _pSysData->_aOutTrayURL;

	if ( rURL.Len() == 0 )
	{
		// URL is to be reset. Check for other nodes which refer
		// to an OutTray.
		BOOL  bFound = FALSE;

		ULONG nCount = SubNodeCount();
		for ( ULONG n = 0; n < nCount; n++ )
		{
			CntNode* pChild = GetSubNode( n );
			if ( pChild->GetMostReferedNode()->ISA( CntOutTrayNode ) )
			{
				String aOutURL( OWN_URL( pChild ) );
				if ( IsInTrash_Impl( aOutURL ) )
					continue;

				if ( !CntViewStorageNode::IsRootViewURL( aOutURL ) )
					continue;

				if ( aOutURL != rOutURL )
				{
					rOutURL = aOutURL;
					bFound = TRUE;
					break;
				}
			}
		}

		if ( !bFound )
			rOutURL.Erase();
	}
	else
	{
		if ( !CntViewStorageNode::IsRootViewURL( rURL ) )
			return;

		rOutURL = rURL;
	}

	CntStorageNode* pStg = (CntStorageNode*)&_xStorage;

	const UniString aStreamName(
		UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( CNT_OUTTRAY_URL_STREAM ) ) );

	pStg->remove( aStreamName );

	// Store URL.
	if ( rOutURL.Len() )
	{
   		SvStream* pStream =	pStg->openStream( aStreamName );
		if ( pStream )
		{
			SfxPoolItem::writeByteString( *pStream, rOutURL );
			delete pStream;
		}
	}
}

//----------------------------------------------------------------------------
const String& CntRootNodeMgr::GetCacheDirectory()
{
	if ( !_aCacheDir.Len() )
	{
		// application's "store" directory
		_aCacheDir = GetDirURLFromIni_Impl( CNT_KEY_STORAGE_DIR );
	}

	DBG_ASSERT( _aCacheDir.Len(), "GetCacheDirectory: Empty URL!" );
	return _aCacheDir;
}

//----------------------------------------------------------------------------
const String& CntRootNodeMgr::GetUserDataDirectory()
{
	if ( !_aConfigDir.Len() )
	{
		// application's "config" directory
//		_aConfigDir = GetDirURLFromIni_Impl( CNT_KEY_USERCONFIG_PATH );
		_aConfigDir = GetCacheDirectory();
		if ( _aConfigDir.Len() )
		{
			 if ( _aConfigDir.GetChar( _aConfigDir.Len() - 1 ) != '/' )
				_aConfigDir += UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( "/user/" ) );
			 else
				_aConfigDir += UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( "user/" ) );

			// Create dir, if it does not exist.
			DirEntry aDirEntry( _aConfigDir, FSYS_STYLE_URL );
			if ( !aDirEntry.Exists() )
				aDirEntry.MakeDir();
		}
	}

	DBG_ASSERT( _aConfigDir.Len(), "GetCacheDirectory: Empty URL!" );
	return _aConfigDir;
}

//----------------------------------------------------------------------------
const String& CntRootNodeMgr::GetTrashDirectory()
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

	String& rTrashDirURL = _pSysData->_aTrashDirURL;
	if ( rTrashDirURL.Len() == 0 )
	{
		// application's "trash" directory
//		rTrashDirURL = GetDirURLFromIni_Impl( CNT_KEY_TRASH_DIR );
		rTrashDirURL = GetCacheDirectory();
		if ( rTrashDirURL.Len() )
		{
			 if ( rTrashDirURL.GetChar( rTrashDirURL.Len() - 1 ) != '/' )
				rTrashDirURL += UniString::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM( "/trash/" ) );
			 else
				rTrashDirURL += UniString::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM( "trash/" ) );

			// Create dir, if it does not exist.
			DirEntry aDirEntry( rTrashDirURL, FSYS_STYLE_URL );
			if ( !aDirEntry.Exists() )
				aDirEntry.MakeDir();
		}
	}
	return rTrashDirURL;
}

//----------------------------------------------------------------------------
CntNode* CntRootNodeMgr::createNew( const CntItemListItem& rItem )
{
	// Find factory for given node type.
	INetContentType eType =
			(INetContentType)ITEM_VALUE( CntUInt16Item,
									 	 *( rItem.Get( WID_FACTORY_NO ) ) );

	CntNodeFactory* pFac = NULL;
	ULONG nFacs = FactoryCount();
	for ( ULONG i = 0; i < nFacs; i++ )
	{
		pFac = GetFactory( i );
		if ( pFac->GetId() == eType )
			break;
		else
			pFac = NULL;
	}

	if ( !pFac )
	{
		DBG_ERROR( "CntRootNodeMgr::createNew - No factory!" );
		return NULL;
	}

	String aURL( pFac->GetWildCard() );

	// Compatibility stuff.
	if ( aURL.GetChar( aURL.Len() - 1 ) == '*' )
		aURL.Erase( aURL.Len() - 1 );

	return Query( aURL );
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::IsViewNode( const String& rURL, BOOL bRoot )
{
	String aURL( rURL );
	aURL.ToLowerAscii();

	ULONG nCount = _aViewTypesList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		String aCurr( *_aViewTypesList.GetObject( n ) );
		aCurr.ToLowerAscii();

		if ( !bRoot )
		{
			aCurr += '#';
			aCurr += '*';
		}

		WildCard aWild( aCurr );
		if ( aWild.Matches( aURL ) )
		{
			// Gotcha!
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
CntNode* CntRootNodeMgr::QueryViewNode( const String& rURL, BOOL bCreate )
{
	if ( IsViewNode( rURL, TRUE ) )
		return Query( rURL );

	return NULL;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::AddView( CntNode* pRootViewNode )
{
	if ( pRootViewNode->IsDummy() )
		return FALSE;

	if ( !pRootViewNode->IsRootNode() )
		return FALSE;

	const String& rViewURL = OWN_URL( pRootViewNode );

	if ( IsInTrash_Impl( rViewURL ) )
		return FALSE;

	if ( !IsViewNode( rViewURL, TRUE ) )
		return FALSE;

	ULONG nCount = _aViewList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntViewEntry* pEntry = _aViewList.GetObject( n );
		if ( pEntry->aViewURL == rViewURL )
		{
			// View already in list.
			return TRUE;
		}
	}

	// Add new entry to list.
	const String& rType = ITEMSET_VALUE( pRootViewNode, CntContentTypeItem,
										 WID_CONTENT_TYPE );
	_aViewList.Insert( new CntViewEntry( rViewURL, rType ), LIST_APPEND );

	SaveViewList_Impl();
	return TRUE;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::RemoveView( CntNode* pRootViewNode )
{
	if ( !pRootViewNode )
		return FALSE;

	return RemoveView( OWN_URL( pRootViewNode ) );
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::RemoveView( const String& rRootViewURL )
{
	if ( !IsViewNode( rRootViewURL, TRUE ) )
		return FALSE;

	ULONG nCount = _aViewList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntViewEntry* pEntry = _aViewList.GetObject( n );
		if ( pEntry->aViewURL == rRootViewURL )
		{
			_aViewList.Remove( pEntry );
			delete pEntry;
			SaveViewList_Impl();
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::AddExplorer( const String& rDirURL )
{
	String aDirURL( rDirURL );
	if ( aDirURL.GetChar( aDirURL.Len() - 1 ) != '/' )
		aDirURL += '/';

	DirEntry aDir( aDirURL, FSYS_STYLE_URL );
	if ( !aDir.IsCaseSensitive() )
		aDirURL.ToLowerAscii();

	ULONG nCount = _aExplorerList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		String* pEntry = _aExplorerList.GetObject( n );
		if ( *pEntry == aDirURL )
		{
			// View already in list.
			return;
		}
	}

	// Add new entry to list.
	_aExplorerList.Insert( new String( aDirURL ), LIST_APPEND );
	SaveExplorerList_Impl();
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::RemoveExplorer( const String& rDirURL )
{
	String aDirURL( rDirURL );
	if ( aDirURL.GetChar( aDirURL.Len() - 1 ) != '/' )
		aDirURL += '/';

	DirEntry aDir( aDirURL, FSYS_STYLE_URL );
	if ( !aDir.IsCaseSensitive() )
		aDirURL.ToLowerAscii();

	ULONG nCount = _aExplorerList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		String* pEntry = _aExplorerList.GetObject( n );
		if ( *pEntry == aDirURL )
		{
			_aExplorerList.Remove( pEntry );
			delete pEntry;
			SaveExplorerList_Impl();
			return;
		}
	}
}

//----------------------------------------------------------------------------
// virtual
const SfxPoolItem* CntRootNodeMgr::Put( const SfxPoolItem& rProp,
										USHORT nWhich )
{
	// set item
	CntNode::Put( rProp, nWhich );

	switch ( nWhich )
	{
		case WID_CONNECTION_MODE:
		{
			CntConnMode eNewMode =
					(CntConnMode)ITEM_VALUE( CntConnModeItem, rProp );

//			DBG_ASSERT( eNewMode != _eConnMode,
//						"WID_CONNECTION_MODE - old value == new value" );

			if ( eNewMode != _eConnMode )
				SetConnMode_Impl( eNewMode );

			break;
		}

		case WID_UPDATE:
		{
			// Send "update" request to all registered nodes
			ULONG nCount = _aUpdateList.Count();
			for ( ULONG n = 0; n < nCount; ++n )
			{
				CntUpdateEntry* pEntry = _aUpdateList.GetObject( n );
				if ( !UpdateAllowed_Impl( pEntry ) )
				{
					if ( _eConnMode != CNT_CONN_MODE_ONLINE )
					{
						if ( ErrorHandler::HandleError( ERRCODE_CHAOS_OFFLINE )
 					 		 == ERRCODE_BUTTON_YES )
						{
							// Go online...
							Put( CntConnModeItem( WID_CONNECTION_MODE,
										  		  CNT_CONN_MODE_ONLINE ) );
						}
						else
						{
							// User does not want to go online. Cancel
							// the whole request... #65373#
							return NULL;
						}
					}
				}

				if ( UpdateAllowed_Impl( pEntry ) )
				{
					if ( INetURLObject::CompareProtocolScheme(
											pEntry->_aURL ) == INET_PROT_FILE )
					{
						if ( !CntViewBase::ViewFileExists( pEntry->_aURL ) )
						{
							// Somebody killed the file represented by the URL!
							continue;
						}
					}

					// do the update...
					NAMESPACE_VOS( ORef )< CntUpdateTimer > xTimer
														= pEntry->_xTimer;
					xTimer->stop();
					xTimer->setRemainingTime( 0 );
					xTimer->start();
				}
			}
			return NULL;
		}

#ifdef WID_CLEAR_PASSWORDS
		case WID_CLEAR_PASSWORDS:
			for ( ULONG n = 0; n < _aPasswordList.Count(); n++ )
			{
				CntPasswordEntry *pEntry =
						 	(CntPasswordEntry*)_aPasswordList.Remove( n );
				delete pEntry;
			}
			return NULL;
#endif

		// Compatibility stuff ...

		// INI key values have changed...
		case WID_SERVERNAME:
		case WID_MAILSEND_SERVERNAME:
		case WID_NEWSSEND_SERVERNAME:
		case WID_USERNAME:
		case WID_PASSWORD:
			return NULL;

		// End of Compatibility stuff ...

		default:
			break;
	}

	// Store item
	return _xStorage->Put( rProp );
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SetConnMode_Impl( CntConnMode eConnMode )
{
	CntConnMode ePrev = _eConnMode;

	_eConnMode = eConnMode;

	// Tell all root nodes about the change
	ULONG nCount = SubNodeCount();
	for ( ULONG n = 0; n < nCount; ++n )
		GetSubNode( n )->SetConnMode( eConnMode );

	switch ( eConnMode )
	{
		case CNT_CONN_MODE_ONLINE:
		{
			// go online...

			// start update timers (delayed)
			if ( !_pInitTimer )
			{
				_pInitTimer = new CntUpdateInitTimer( &_aUpdateList );
				_pInitTimer->acquire();
			}

			if ( !_pInitTimer->isTicking() )
				_pInitTimer->start();

#ifdef TF_CHAOS_TRANS

			// This code is for testing purposes only!!!

			if ( ePrev != CNT_CONN_MODE_ONLINE )
			{
				// Process transactions.
				CntTransActionMgr* pTransMgr = GetTransManager();
				pTransMgr->Reset(); // reset interrupted transactions
				pTransMgr->Play();
			}
#endif

			break;
		}

		case CNT_CONN_MODE_OFFLINE:
		case CNT_CONN_MODE_OFFLINE_TRANSACTED:
		{
			// go offline...

			// stop possibly running auto-update init timer
			if ( _pInitTimer )
				_pInitTimer->stop();

			// stop all update timers
			ULONG nCount = _aUpdateList.Count();
			for ( ULONG n = 0; n < nCount; ++n )
			{
				NAMESPACE_VOS( ORef )< CntUpdateTimer > xTimer =
									_aUpdateList.GetObject( n )->_xTimer;
				if ( xTimer->GetTimeout() )
					xTimer->stop();
			}

#ifdef TF_CHAOS_TRANS

			// This code is for testing purposes only!!!

			if ( ePrev == CNT_CONN_MODE_ONLINE )
			{
				// Stop transactions.
				GetTransManager()->Stop();
			}
#endif
			break;
		}

		default:
			DBG_ERROR( "SetConnMode_Impl: unknown connection mode!" );
			break;
	}
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::UpdateAllowed_Impl( CntUpdateEntry* pEntry )
{
	return ( _eConnMode == CNT_CONN_MODE_ONLINE );
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::RemoveChildRequests_Impl( const String& rParentURL )
{
	BOOL  bModified = FALSE;
	xub_StrLen nLen = rParentURL.Len();

	for ( ULONG n = 1; n <= _aUpdateList.Count(); ++n )
	{
		CntUpdateEntry* pEntry = _aUpdateList.GetObject( n - 1 );

		// Is entry for a child of rParentURL?
		xub_StrLen nPos = pEntry->_aURL.Match( rParentURL );
		if ( nPos == nLen )
		{
			// remove child's timer from list
			_aUpdateList.Remove( pEntry );
			delete pEntry;

			// once again...
			n--;

			bModified = TRUE;
		}
	}

	return bModified;
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::RequestAutoUpdate( CntAnchor* pAnchor, ULONG nInterval )
{
	if ( !pAnchor || !pAnchor->GetNode() )
		return;

	CntNode* pMostRef = pAnchor->GetNode()->GetMostReferedNode();

	BOOL bView =
 	   pMostRef->IsItemFlag( WID_AUTOUPDATE_INTERVAL, CNT_ITEM_AUTO_VIEWPROP );

	String aURL;
	if ( bView )
		aURL = pAnchor->GetViewURL( TRUE );
	else
	{
		if ( pMostRef->IsDummy() &&
	     	( nInterval != CNT_UPDATEREQUEST_REMOVE ) &&
		 	( nInterval != CNT_UPDATEREQUEST_REMOVEALL ) )
		{
			// Dummy nodes cannot process auto-updates.
			return;
		}

		aURL = OWN_URL( pMostRef );
	}

	if ( !aURL.Len() )
		return;

	if ( bView && !pAnchor->IsRootAnchor() &&
	     ( nInterval != CNT_UPDATEREQUEST_REMOVE ) &&
		 ( nInterval != CNT_UPDATEREQUEST_REMOVEALL ) )
	{
		const String aParentViewURL( pAnchor->GetParentViewURL( TRUE ) );
		CntAnchorRef xParent( new CntAnchor( NULL, aParentViewURL ) );
		if ( !xParent->GetError() )
		{
			// Note: This GETDATA is essential for proper work and
			//       MUST not be removed!
			xParent->Put( SfxVoidItem( WID_GETDATA ) );
			ULONG nParInterval = ITEMSET_VALUE( xParent, CntUInt32Item,
										   	    WID_AUTOUPDATE_INTERVAL );
			BOOL  nEnabled     = ITEMSET_VALUE( xParent, CntBoolItem,
												WID_UPDATE_ENABLED );
			if ( nEnabled && ( nParInterval == nInterval ) )
			{
				// Force remove of my request.
				nInterval = CNT_UPDATEREQUEST_REMOVE;
			}
		}
	}

	BOOL bSave = FALSE;

	// Release requests for all children of pAnchor, too.
	if ( nInterval == CNT_UPDATEREQUEST_REMOVEALL )
	{
		bSave = RemoveChildRequests_Impl( aURL );
		bSave |= RemoveChildRequests_Impl( OWN_URL( pMostRef ) );
	}

	CntUpdateEntry* pEntry = NULL;

	ULONG nCount = _aUpdateList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		pEntry = _aUpdateList.GetObject( n );

		NAMESPACE_VOS( ORef )< CntUpdateTimer > xTimer = pEntry->_xTimer;
		String aEntryURL( pEntry->_aURL );

		// Is pAnchor already in list ?
		BOOL bFound = FALSE;
		if ( aEntryURL == aURL )
		{
			bFound = TRUE;
		}
		else
		{
			// Compatibility: In former versions ( <358z ), there the protocol
			//                nodes requested auto-updates, so it is possible,
			//                that a view-node URL is passed and a
			//                protocol-URL is stored in list...

			CntNode* pCurr = pAnchor->GetNode()->GetMostReferedNode();
			String aRefURL( OWN_URL( pCurr ) );

			if ( aEntryURL == aRefURL )
				bFound = TRUE;
		}

		if ( bFound )
		{
			if ( ( nInterval == CNT_UPDATEREQUEST_REMOVE ) ||
				 ( nInterval == CNT_UPDATEREQUEST_REMOVEALL ) )
			{
				// completely remove the request
				//	x / 0 --> -1

				_aUpdateList.Remove( pEntry );
				delete pEntry;
				pEntry = NULL;

				bSave = TRUE;
			}
			else
			{
				// remove/modify update request

				if ( xTimer->GetTimeout() != ( nInterval * 1000 ) )
				{
					// x --> 0 / x
					xTimer->stop();
					xTimer->SetTimeout( nInterval * 1000 );

					if ( nInterval && UpdateAllowed_Impl( pEntry ) )
						xTimer->start();

					bSave = TRUE;
				}
			}

			break;
		}
		else
			pEntry = NULL;

	} // endfor

	if ( !pEntry &&
		 ( nInterval != CNT_UPDATEREQUEST_REMOVE ) &&
		 ( nInterval != CNT_UPDATEREQUEST_REMOVEALL ) )
	{
		// new node requests auto-update...
		NAMESPACE_VOS( ORef )< CntUpdateTimer > xTimer =
							new CntUpdateTimer( aURL, nInterval * 1000 );
		pEntry = new CntUpdateEntry( aURL, xTimer );
		if ( nInterval && UpdateAllowed_Impl( pEntry ) )
			xTimer->start();

		_aUpdateList.Insert( pEntry );
		bSave = TRUE;
	}

	if ( bSave )
		SaveUpdateRequesterList_Impl();
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SyncAutoUpdate( CntAnchor* pAnchor,
									 const String& rOldURL )
{
	if ( ( rOldURL.Len() == 0 ) || !pAnchor || !pAnchor->GetNode() )
		return;

	CntNode* pMostRef = pAnchor->GetNode()->GetMostReferedNode();
	BOOL bView =
 	   pMostRef->IsItemFlag( WID_AUTOUPDATE_INTERVAL, CNT_ITEM_AUTO_VIEWPROP );

	String aNewURL;
	if ( bView )
		aNewURL = pAnchor->GetViewURL( TRUE );
	else
		aNewURL = OWN_URL( pMostRef );

	if ( !aNewURL.Len() )
		return;

	String aOldURL( rOldURL );
	xub_StrLen nLen = aOldURL.Len();

	CntUpdateList aTempList;
	BOOL bModified = FALSE;

	for ( ULONG n = 1; n <= _aUpdateList.Count(); ++n )
	{
		String aNewTimerURL;
		CntUpdateEntry* pEntry = _aUpdateList.GetObject( n - 1 );

		xub_StrLen nPos = pEntry->_aURL.Match( aOldURL );
		if ( nPos == STRING_MATCH )
		{
			// Entry matches rOldURL.
			aNewTimerURL = aNewURL;
		}
		else if ( nPos == nLen )
		{
			// Entry matches a child of rOldURL.

			aNewTimerURL = aNewURL;
			aNewTimerURL += pEntry->_aURL.Copy( nPos );
		}

		if ( aNewTimerURL.Len() )
		{
			// remove child's timer from list
			_aUpdateList.Remove( pEntry );

			NAMESPACE_VOS( ORef )< CntUpdateTimer > xTimer =
					new CntUpdateTimer(
								aNewTimerURL, pEntry->_xTimer->GetTimeout() );
			aTempList.Insert( new CntUpdateEntry( aNewTimerURL, xTimer ) );

			if ( xTimer->GetTimeout() && UpdateAllowed_Impl( pEntry ) )
				xTimer->start();

			delete pEntry;

			// once again...
			--n;

			bModified = TRUE;
		}
	}

	if ( bModified )
	{
		// Transfer entries from aTempList to _aUpdateList.
		while ( aTempList.Count() )
		{
			CntUpdateEntry* pEntry = aTempList.GetObject( 0 );
			_aUpdateList.Insert( pEntry );
			aTempList.Remove( pEntry );
		}
		SaveUpdateRequesterList_Impl();
	}
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::ResetUpdateResults( CntAnchor* pAnchor, BOOL bRecursive )
{
	if ( !pAnchor || !pAnchor->GetNode() ||
		 !ITEMSET_VALUE( pAnchor, CntBoolItem, WID_FLAG_IS_FOLDER ) )
		return FALSE;

	CntNode* pMostRef = pAnchor->GetNode()->GetMostReferedNode();

	BOOL bView =
 	   pMostRef->IsItemFlag( WID_AUTOUPDATE_INTERVAL, CNT_ITEM_AUTO_VIEWPROP );

	String aURL;
	if ( bView )
		aURL = pAnchor->GetViewURL( TRUE );
	else
		aURL = OWN_URL( pMostRef );

	if ( !aURL.Len() )
		return FALSE;

	ULONG nCount = _aUpdateList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntUpdateEntry* pEntry = _aUpdateList.GetObject( n );
		BOOL bFound = FALSE;

		if ( aURL.Len() == pEntry->_aURL.Len() )
		{
			if ( aURL == pEntry->_aURL )
				bFound = TRUE;
		}
		else if ( aURL.Len() > pEntry->_aURL.Len() )
		{
			if ( aURL.Match( pEntry->_aURL ) == pEntry->_aURL.Len() )
				bFound = TRUE;
		}

		if ( bFound )
		{
			// Broadcast an empty "result" to indicate that there are
			// no more new entries...
			CntUpdateResult aResult;
			aResult.aTargetURL = aURL;

			if ( bRecursive )
				aResult.nNewMessages = CNT_RESET_NEWMESSAGES_RECURSIVE;
			else
				aResult.nNewMessages = CNT_RESET_NEWMESSAGES;

			Broadcast( CntUpdateHint( &aResult ) );
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
void CntRootNodeMgr::Flush()
{
	CntNode::Flush();
	if( _xStorage )
		_xStorage->Flush();
}

//----------------------------------------------------------------------------
// virtual
void CntRootNodeMgr::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    //////////////////////////////////////////////////////////////////////
    // CntNodeJob notifications handling.
    //////////////////////////////////////////////////////////////////////

	CntNodeJob *pBroadcastingJob = NULL;
	if ( rBC.ISA( CntNodeJob ) )
		pBroadcastingJob = (CntNodeJob*)&rBC;

	if ( pBroadcastingJob )
	{
	    if ( rHint.ISA( CntStatusHint ) )
	    {
			BOOL bCanceled = FALSE;
			BOOL bDone     = FALSE;

	        const CntStatusHint* pStatusHint = (const CntStatusHint*)&rHint;
	        const CntStatus eStatus = pStatusHint->GetStatus();

			if ( eStatus == CNT_STATUS_DONE )
			{
		        // Job done.
				bDone = TRUE;
			}
			else if ( ( eStatus == CNT_STATUS_ERROR ) &&
			          ( pStatusHint->GetError() == ERRCODE_ABORT ) )
			{
		        // Job canceled.
				bCanceled = TRUE;
			}

			if ( bDone || bCanceled )
			{
#ifdef AUTO_REMOVE_PASSWORDS
				// The only thing the RNM is interested in (starts listening)
				// is to remove temporaryly set passwords from nodes after the
				// job which requested the pw is done.
				CntAnchor* pAnchor = (CntAnchor*)pBroadcastingJob->GetClient();
				CntNode*   pNode   = pAnchor->GetNode();
				if ( pNode )
				{
					pNode = pNode->GetRootNode()->GetMostReferedNode();
					pNode->CntNode::Put( CntStringItem(
											WID_PASSWORD, UniString() ),
										 WID_PASSWORD );
				}
#endif
				EndListening( *pBroadcastingJob );

				// Note: Do not call the base class here. RNM only listens on
				//       the job, but is not its owner!!!
				return;
			}
		}
 	}

	CntNode::Notify( rBC, rHint );
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::AddLoggedJob( CntNodeJob* pJob )
{
#ifdef TF_CHAOS_TRANS
	if ( GetTransManager()->Record( pJob ) )
	{
		SaveTransActionList_Impl();
		return TRUE;
	}
#endif
	return FALSE;
}

#ifdef DBG_CHAOS_LOG_OFFLINE_ERRORS
//----------------------------------------------------------------------------
void DBG_DumpJob( CntNodeJob* pJob )
{
	if ( !pJob )
		return;

	SvFileStream aDump( "c:\\chaoserr.log", STREAM_STD_READWRITE );
	aDump.Seek( STREAM_SEEK_TO_END );
	String aLine( "--------------------------------------------------------" );
	aDump.WriteLine( aLine );
	DateTime aCurrDateTime;
	aLine =  aCurrDateTime.GetDate();
	aLine += " : ";
	aLine += aCurrDateTime.GetTime();
	aDump.WriteLine( aLine );
	aLine = "requ: ";
	aLine += pJob->GetRequest()->Which();
	aDump.WriteLine( aLine );
	aLine = "valu: ";
	String aText;
	if( pJob->GetRequest()->ISA(CntStringItem) )
		aText = ITEM_VALUE( CntStringItem, *(pJob->GetRequest()) );
	else
		pJob->GetRequest()->GetPresentation( SFX_ITEM_PRESENTATION_COMPLETE,
											 SFX_MAPUNIT_APPFONT,
											 SFX_MAPUNIT_APPFONT,
											 aText );
	aLine += aText;
	aDump.WriteLine( aLine );
	aLine = "clnt: ";
	aLine += OWN_URL( ( (CntAnchor*)pJob->GetClient() )->GetNode() );
	aDump.WriteLine( aLine );
	aLine = "subj: ";
	aLine += OWN_URL( pJob->GetSubject() );
	aDump.WriteLine( aLine );
}
#endif

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::GetLoginInfo( const String& rTargetURL,
								   String& rUser,
					   			   String& rPassword )
{
	if ( !rTargetURL.Len() )
	{
		DBG_ERROR( "GetLoginInfo: Empty target URL!" );
		return FALSE;
	}

	String aAccount;
	return GetLoginInfo_Impl( rTargetURL,
	                          String(), String(),
	                          rUser, rPassword, aAccount,
	                          NULL, String(), String(), false );
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::GetLoginInfo( const String& rServer,
								   const String& rRealm,
								   String& rUser,
					   			   String& rPassword )
{
	if ( !rServer.Len() )
	{
		DBG_ERROR( "GetLoginInfo: Empty server!" );
		return FALSE;
	}

	if ( !rRealm.Len() )
	{
		DBG_ERROR( "GetLoginInfo: Empty realm!" );
		return FALSE;
	}

	String aAccount;
	return GetLoginInfo_Impl( String(),
	                          rServer, rRealm,
	                          rUser, rPassword, aAccount,
							  NULL, String(), String(), false );
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::GetLoginInfo_Impl( const String& rTargetURL,
										const String& rServer,
									    const String& rRealm,
						   			    String& rUser,
						   			    String& rPassword,
										String& rAccount,
						   			    const CntNodeJob* pJob,
						   			    const String& rStoredPw,
										const String& rStoredAc,
                                        bool bErrorHandler )
{
	BOOL bMatchURL = !( rServer.Len() && rRealm.Len() );
	BOOL bFound    = FALSE;

	// Note: count of list may be decreased during iteration!
	for ( ULONG n = 0; n < _aPasswordList.Count(); ++n )
	{
		CntPasswordEntry *pEntry =
							(CntPasswordEntry*)_aPasswordList.GetObject( n );

		// Matches info the possibly given user?
		if ( rUser.Len() && ( rUser != pEntry->_aUser ) )
			continue;

		if ( bMatchURL )
		{
			// Matches URL?
			if ( pEntry->_aURL.Len() <= rTargetURL.Len() )
			{
				xub_StrLen nPos = pEntry->_aURL.Match( rTargetURL );

				if ( ( nPos == STRING_MATCH ) ||
				     ( nPos == ( rTargetURL.Len() - 1  ) ) )
				{
					// Gotcha!
					bFound = TRUE;
				}
			}
		}
		else
		{
			// Matches <server,realm> pair?
			if ( pEntry->_aServer.Len() &&
			     pEntry->_aRealm.Len() &&
			     ( pEntry->_aServer == rServer ) &&
			     ( pEntry->_aRealm == rRealm ) )
			{
				// Gotcha!
				bFound = TRUE;
			}
		}

		if ( bFound )
		{
			// 1) Did the same job already request a password? Then the
			//    password entered on previous try was wrong!
			// 2) Did the user change a permanently saved password or account?
			if ( !bErrorHandler
                 && ( ( pJob && ( pEntry->_nSubmitter == (ULONG)pJob ) ) ||
                      ( rStoredPw.Len() && ( rStoredPw != pEntry->_aPassword ) ) ||
                      ( rStoredAc.Len() && ( rStoredAc != pEntry->_aAccount ) ) ) )
			{
				_aPasswordList.Remove( n );
				delete pEntry;

				return FALSE;
			}
			else
			{
				rUser     = pEntry->_aUser;
				rPassword = pEntry->_aPassword;
				rAccount  = pEntry->_aAccount;

				return TRUE;
			}
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::RemoveLoginInfo( const String& rTargetURL )
{
	DBG_ASSERT( rTargetURL.Len(),
	            "RemoveLoginInfo: empty target URL!" );

	ULONG nCount = _aPasswordList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntPasswordEntry *pEntry =
							(CntPasswordEntry*)_aPasswordList.GetObject( n );
		if ( pEntry->_aURL == rTargetURL )
		{
			_aPasswordList.Remove( n );
			delete pEntry;
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
CntErrorHandler* CntRootNodeMgr::GetErrorHandler_Impl(
											const CntInterface* pClient ) const
{
	if ( !_pErrorHandlerList )
		return NULL;

	ULONG nCount = _pErrorHandlerList->Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntErrorHandler* pHandler = _pErrorHandlerList->GetObject( n );
		if ( pHandler->_pClient == pClient )
			return pHandler;
	}

	return NULL;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::RegisterErrorHandler( const CntInterface* pClient,
										   const Link& rLink )
{
	if ( GetErrorHandler_Impl( pClient ) )
	{
		DBG_ERROR( "RegisterErrorHandler - Already a handler registered!" );
		return FALSE;
	}

	if ( !_pErrorHandlerList )
		_pErrorHandlerList = new CntErrorHandlerList;

	_pErrorHandlerList->Insert( new CntErrorHandler( pClient, rLink ) );
	return TRUE;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::DeregisterErrorHandler( const CntInterface* pClient )
{
	CntErrorHandler* pHandler = GetErrorHandler_Impl( pClient );
	if ( !pHandler )
	{
		DBG_ERROR( "DeregisterErrorHandler - No handler registered!" );
		return FALSE;
	}

	_pErrorHandlerList->Remove( pHandler );
	delete pHandler;

	if ( !_pErrorHandlerList->Count() )
	{
		delete _pErrorHandlerList;
		_pErrorHandlerList = NULL;
	}

	return TRUE;
}

//----------------------------------------------------------------------------
const Link* CntRootNodeMgr::QueryErrorHandler(
										const CntInterface* pClient ) const
{
	CntErrorHandler* pHandler = GetErrorHandler_Impl( pClient );
	if ( pHandler )
		return &(pHandler->_aLink);

	return NULL;
}

//----------------------------------------------------------------------------
ErrCode CntRootNodeMgr::PropagateError_Impl( ErrCode       nError,
										   	 CntNodeJob*   pJob,
										   	 const String* pErrorStr,
										   	 void*         pData)
{
	ErrCode nResult = ERRCODE_CHAOS_NOT_HANDLED;

 	if ( pJob )
 	{
		CntNodeJob* pBC = NULL;

		if ( ( nError == ERRCODE_ABORT ) || !pJob->GetParent() )
		{
			// ABORT and errors occured in root jobs will be
			// propagated directly by the job.
			pBC = pJob;
		}
		else
		{
			// Errors occured in child jobs will be propagated
			// by the root job of the child job.
 			pBC = pJob->GetParent();
 			while ( pBC->GetParent() )
 				pBC = pBC->GetParent();
 		}

 		if ( pBC )
 			pBC->Broadcast( CntStatusHint( pBC->GetCancelable(),
										   pBC->GetRequest(),
							   			   CNT_STATUS_ERROR,
										   nError ) );

		// Already canceled by a listener?
		if ( pJob->IsCanceled() )
			nResult = ERRCODE_BUTTON_CANCEL;
		else
			// Try to get a special error handler.
			for ( CntNodeJob* pOuterJob = pJob; pOuterJob;
				  pOuterJob = pOuterJob->GetParent() )
			{
				const Link* pHandler = pOuterJob->QueryErrorHandler();
				if ( pHandler )
				{
					CntErrorData aInfo( nError,
										pJob->GetRequest(),
										pJob->GetCancelable(),
										pErrorStr,
										pData );

					nResult = (ErrCode)pHandler->Call( &aInfo );

					// Canceled by error handler?
					if ( pJob->IsCanceled() )
						nResult = ERRCODE_BUTTON_CANCEL;

					break;
				}
			}
	}

	return nResult;
}

//----------------------------------------------------------------------------
USHORT CntRootNodeMgr::HandleError( ErrCode       nError,
									CntNodeJob*   pJob,
									const String* pErrorStr /* = NULL */,
									void*         pData /* = NULL */,
									bool		  bCancelJob /* = true */ )
{
	ACQUIRE_SOLAR_MUTEX();

	ErrCode nResult = ERRCODE_BUTTON_RETRY;

	switch ( nError )
	{
		//////////////////////////////////////////////////////////////////
		// Handle "login" error...
		//////////////////////////////////////////////////////////////////

		case ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE:
		case ERRCODE_CHAOS_LOGINFAIL_NOEXCH:
		case ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT:
		case ERRCODE_CHAOS_LOGINFAIL_ACCOUNT_NOEXCH:
		{
			BOOL bModifyUser
			 = nError == ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE
			   || nError == ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT;
			BOOL bModifyAccount
			 = nError == ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT
			   || nError == ERRCODE_CHAOS_LOGINFAIL_ACCOUNT_NOEXCH;

			if ( !pData )
			{
				DBG_ERROR( "Login error: No target given!" );

				nResult = ERRCODE_BUTTON_CANCEL;
				break;
			}

			CntNode* pTarget = (CntNode*)pData;
			CntAnchorRef xTarget( new CntAnchor( NULL, pTarget ) );

			//////////////////////////////////////////////////////////////
			// Obtain misc values from target.
			//////////////////////////////////////////////////////////////

			const SfxPoolItem* pItem = NULL;

			// Server name
			String aServer;
			if ( pTarget->GetItemState(
						WID_SERVERNAME, TRUE, &pItem ) > SFX_ITEM_DEFAULT )
				aServer = ITEM_VALUE( CntStringItem, *pItem );

			pItem = NULL;

			// Realm
			String aRealm;
			if ( pTarget->GetItemState(
						WID_ACCOUNT, TRUE, &pItem )	> SFX_ITEM_DEFAULT )
				aRealm = ITEM_VALUE( CntStringItem, *pItem );

			pItem = NULL;

			SfxPoolItem* pStickyItem = NULL;

			String aStoredUser;
			if ( pTarget->IsItemSticky( pJob, WID_USERNAME, &pStickyItem ) )
				aStoredUser = ITEM_VALUE( CntStringItem, *pStickyItem );

			DELETEZ( pStickyItem );

			String aStoredPw;
			if ( pTarget->IsItemSticky( pJob, WID_PASSWORD, &pStickyItem ) )
				aStoredPw = ITEM_VALUE( CntStringItem, *pStickyItem );

			DELETEZ( pStickyItem );

			String aStoredAc;
			if ( bModifyAccount )
			{
				if ( pTarget->IsItemSticky( pJob, WID_FTP_ACCOUNT, &pStickyItem ) )
					aStoredAc = ITEM_VALUE( CntStringItem, *pStickyItem );

				DELETEZ( pStickyItem );
			}

			String aUserName;
			if ( aStoredUser.Len() )
			    aUserName = aStoredUser;
			else
			{
				if ( pTarget->GetItemState(
							WID_USERNAME, TRUE, &pItem ) > SFX_ITEM_DEFAULT )
					aUserName = ITEM_VALUE( CntStringItem, *pItem );

				pItem = NULL;
			}

			String aPassword;
			String aAccount;

			//////////////////////////////////////////////////////////////
			// Try to get the missing info from password list.
			//////////////////////////////////////////////////////////////

			String aTargetURL( OWN_URL( pTarget ) );

			GetLoginInfo_Impl( aTargetURL, aServer,	aRealm,
							   aUserName, aPassword, aAccount,
							   bModifyAccount ? 0 : pJob,
							   aStoredPw, aStoredAc, true );

			if ( aStoredPw.Len() && ( aPassword != aStoredPw ) )
				aPassword = aStoredPw;
			if ( aStoredAc.Len() && ( aAccount != aStoredAc ) )
				aAccount = aStoredAc;

			//////////////////////////////////////////////////////////////
			// Show login dialog, if any information is missing or an
			// error occured.
			//////////////////////////////////////////////////////////////

			BOOL bDoExchange = FALSE;

			if ( pErrorStr || !aUserName.Len() || !aPassword.Len() ||
				 ( bModifyAccount && !aAccount.Len() ) )
			{
				//////////////////////////////////////////////////////
				// Fill login error info.
				//////////////////////////////////////////////////////

				LoginErrorInfo aErrorInfo;

				aErrorInfo.SetTitle   ( aServer );
				aErrorInfo.SetServer  ( aServer );
				aErrorInfo.SetUserName( aUserName );
				aErrorInfo.SetPassword( aPassword );

				if ( pErrorStr )
					aErrorInfo.SetErrorText( *pErrorStr );

				if ( aStoredPw.Len() )
				{
					aErrorInfo.SetPersistentPassword( TRUE );
					aErrorInfo.SetSavePassword( FALSE );
				}
				else
				{
					aErrorInfo.SetPersistentPassword( FALSE );
					aErrorInfo.SetSavePassword( _bKeepPassword );
				}

				if ( bModifyAccount )
				{
					aErrorInfo.SetAccount( aAccount );
					aErrorInfo.SetModifyAccount(TRUE);
				}
				else
					aErrorInfo.SetAccount( aRealm );

				aErrorInfo.SetModifyUserName(bModifyUser);

				//////////////////////////////////////////////////////
				// Handle error (display and process login dialog).
				//////////////////////////////////////////////////////

				CntLoginErrorData aLoginErrorData(pTarget, aErrorInfo);
				ULONG nRet = PropagateError_Impl(nError, pJob, pErrorStr,
												 &aLoginErrorData);
				if (nRet == ERRCODE_CHAOS_NOT_HANDLED)
					Broadcast( CntLoginErrorHint( &aErrorInfo ) );
				else
					aErrorInfo.SetResult(USHORT(nRet));

				// Note: Broadcast's are synchronous - so the result is
				//       immediately available.

				if ( aErrorInfo.GetResult() == ERRCODE_BUTTON_RETRY )
				{
					// Obtaining values is not possible at the moment -
					// maybe UI is captured, etc.

					// "Breaking" will asynchronous re-call this method.
					break;
				}

				if ( aErrorInfo.GetResult() == ERRCODE_BUTTON_OK )
				{
					bDoExchange = ( aUserName != aErrorInfo.GetUserName() );

					aUserName = aErrorInfo.GetUserName();
					aPassword = aErrorInfo.GetPassword();

					if ( bModifyAccount )
						aAccount = aErrorInfo.GetAccount();

					// Remember, whether the user wants it's pw's kept.
					_bKeepPassword = aErrorInfo.GetIsSavePassword();

					if ( _bKeepPassword )
					{
						if ( bDoExchange )
						{
							// By typing a different username in the
							// dialog the URL to save has changed.
							INetURLObject aURLObject( aTargetURL );
							if ( aURLObject.GetHost().Len() )
							{
								aURLObject.SetUser(
									aUserName, INetURLObject::ENCODE_ALL );
								aTargetURL = aURLObject.GetMainURL();
							}
							else
								bDoExchange = FALSE;
						}

						// Remember login info.
						CntPasswordEntry* pEntry =
									new CntPasswordEntry( aTargetURL,
									 					  aServer,
									 					  aRealm,
									 					  aUserName,
										 				  aPassword,
														  aAccount,
										 				  (ULONG)pJob );
						_aPasswordList.Insert( pEntry );
					}
				}
				else
					nResult = ERRCODE_BUTTON_CANCEL;
			}

			if ( nResult == ERRCODE_BUTTON_CANCEL )
			{
				// Login aborted.
				break;
			}

			//////////////////////////////////////////////////////////////
			// Login not aborted. All required values are available now.
			//////////////////////////////////////////////////////////////

			// Was the password stored permanently in requester?
			if ( aStoredPw.Len() && _bKeepPassword )
			{
				// Set and store the password in requester.
				xTarget->Put(
					CntStringItem( WID_PASSWORD, aPassword ), WID_PASSWORD );
			}
			else
			{
				if ( !aStoredPw.Len() &&
					 !ITEMSET_VALUE(
					 		pTarget, CntBoolItem, WID_FLAG_IS_DOCUMENT ) )
				{
		 			// Make sure the node "above" pTarget does not have a pw.
		 			UniString aCacheURL(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								STG_PROTOCOL_CACHE ) ) );
		 			aCacheURL += OWN_URL( pTarget );
		 			if ( CntStorageNode::StorageFileExists( aCacheURL ) )
		 			{
		 				CntNodeRef xCache = Query( aCacheURL );
		 				if ( xCache.Is() )
		 				{
							if ( xCache->GetItemState(
										WID_PASSWORD, FALSE ) == SFX_ITEM_SET )
								xCache->Put( CntStringItem(
									WID_PASSWORD, String() ), WID_PASSWORD );
		 				}
		 			}
				}

	 			// Set the pw in pTarget, but do not store it.
	 			pTarget->CntNode::Put(
					CntStringItem( WID_PASSWORD, aPassword ), WID_PASSWORD );

#ifdef AUTO_REMOVE_PASSWORDS
				if ( !_bKeepPassword )
				{
					// Remove the temp. password from requester when the
					// job is done.
					StartListening( *pJob );

					// Remove pw from password list.
					ULONG nCount = _aPasswordList.Count();
					for ( ULONG n = 0; n < nCount; ++n )
					{
						CntPasswordEntry *pEntry =
							(CntPasswordEntry*)_aPasswordList.GetObject( n );
						if ( ( pEntry->_aURL == aTargetURL ) ||
							 ( aServer.Len() && aRealm.Len() &&
							 ( pEntry->_aServer == aServer ) &&
							 ( pEntry->_aRealm == aRealm ) ) )
						{
							_aPasswordList.Remove( n );
							delete pEntry;
							break;
						}
					}
				}
#endif
			}

			if ( bModifyAccount )
			{
				// Was the account stored permanently in requester?
				if ( aStoredAc.Len() && _bKeepPassword )
				{
					// Set and store the account in requester.
					xTarget->Put( CntStringItem(
							WID_FTP_ACCOUNT, aPassword ), WID_FTP_ACCOUNT );
				}
				else
				{
					if ( !aStoredAc.Len() &&
							!ITEMSET_VALUE( pTarget, CntBoolItem,
											WID_FLAG_IS_DOCUMENT ) )
					{
						// Make sure the node "above" pTarget does not
						// have an ac.
		 				UniString aCacheURL(
							UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM(
									STG_PROTOCOL_CACHE ) ) );
						aCacheURL += OWN_URL( pTarget );
						if ( CntStorageNode::StorageFileExists( aCacheURL ) )
						{
							CntNodeRef xCache = Query( aCacheURL );
							if ( xCache.Is() )
							{
								if ( xCache->GetItemState(
												WID_FTP_ACCOUNT, FALSE )
									 == SFX_ITEM_SET )
									xCache->Put( CntStringItem(
												WID_FTP_ACCOUNT, String() ),
												WID_FTP_ACCOUNT );
							}
						}
					}

					// Set the ac in pTarget, but do not store it.
					pTarget->CntNode::Put( CntStringItem(
								WID_FTP_ACCOUNT, aAccount ), WID_FTP_ACCOUNT );
				}
			}

			//////////////////////////////////////////////////////////////
			// If the user name was changed during login, then the job
			// will be restarted with the new identity.
			//////////////////////////////////////////////////////////////

			if ( bDoExchange )
			{
				CntAnchor* pClient = PTR_CAST( CntAnchor,
												pJob->GetClient() );
				if ( pClient )
				{
					// Find right target for the data. The target given
					// is almost the service node, but I want the topmost
					// node above the target here...

					CntNode* pNode = pClient->GetNode();
					if ( pNode )
					{
						CntNode* pCurr = pNode;
						while ( pCurr != this )
						{
							CntNode* pRef = pCurr;
							while ( pRef )
							{
								if ( pRef == pTarget )
								{
									// Bingo!
									break;
								}

								pRef = pRef->GetReferedNode();
							}

							if ( pRef )
							{
								// Success!
								xTarget = new CntAnchor( NULL, pCurr );

								// Escape from loop.
								pCurr = this;
							}
							else
								pCurr = pCurr->GetParent();
						}
					}
				}

				// Exchange identity of requester. Note that the new user
				// name must be putted as an itemset, because most services
				// only react on WID_USERNAME in case it is provided with
				// a WID_PUTDATA request.
				SfxItemSet aSet( *GetPool(), WID_USERNAME, WID_USERNAME );
				aSet.Put( CntStringItem( WID_USERNAME, aUserName ) );
				xTarget->Put( aSet );

    			// Once again (with the new identity)
				pJob->GetClient()->Put( *pJob->GetRequest() );

				// Cancel the "original" job.
				nResult = ERRCODE_BUTTON_CANCEL;
				break;
			}

			//////////////////////////////////////////////////////////////
			// Set the username in target.
			//////////////////////////////////////////////////////////////

			pTarget->CntNode::Put(
				CntStringItem( WID_USERNAME, aUserName ), WID_USERNAME );

			// Done.
			break;
		}

		//////////////////////////////////////////////////////////////////
		// Handle "offline" error...
		//////////////////////////////////////////////////////////////////

		case ERRCODE_CHAOS_OFFLINE:
#ifdef DBG_CHAOS_LOG_OFFLINE_ERRORS
			DBG_DumpJob( pJob );
#endif
			nResult = PropagateError_Impl(
									nError, pJob, pErrorStr, pData );
			if ( nResult == ERRCODE_CHAOS_NOT_HANDLED )
				nResult = ErrorHandler::HandleError( nError );

			if ( nResult == ERRCODE_BUTTON_YES )
			{
				// Go online...
				Put( CntConnModeItem( WID_CONNECTION_MODE,
									  CNT_CONN_MODE_ONLINE ) );
			}

#ifdef TF_CHAOS_TRANS

			// This code is for testing purposes only!!!

			else
			{
				// Transaction!
				pJob->Log();
			}
#endif
			break;

		//////////////////////////////////////////////////////////////////
		// Handle "cookie request" error...
		//////////////////////////////////////////////////////////////////
		case ERRCODE_CHAOS_HTTP_COOKIE_REQUEST:
		{
			ErrCode nRet = PropagateError_Impl(
									nError, pJob, pErrorStr, pData );
			if ( nRet == ERRCODE_CHAOS_NOT_HANDLED )
			{
				if ( !pData )
				{
					DBG_ERROR( "cookie request: No cookie given!" );

					nResult = ERRCODE_BUTTON_CANCEL;
					break;
				}

				CntHTTPCookieRequest* pCookieReq = (CntHTTPCookieRequest*)pData;

				// Show and process "Cookie" dialog.

				// Note: Broadcast's are synchronous - so the result is
				//       immediately available.
				Broadcast( CntHTTPCookieHint( pCookieReq ) );
			}

			// Job will never be cancelled when processing cookie errors.
			return ERRCODE_BUTTON_OK;
		}

		default:
			nResult = PropagateError_Impl(
									nError, pJob, pErrorStr, pData );
			if ( nResult == ERRCODE_CHAOS_NOT_HANDLED )
				nResult = ErrorHandler::HandleError( nError );
			break;
	}

	if ( bCancelJob && pJob )
	{
	 	if ( ( nResult == ERRCODE_BUTTON_CANCEL ) ||
		     ( nResult == ERRCODE_BUTTON_NO ) )
			pJob->Cancel();
	}

	return nResult;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::AddFileEntry( const String& rLongName,
								   const String& rShortName )
{
#ifdef DBG_UTIL
	ULONG nCnt = _aFileEntryList.Count();
	for ( ULONG i = 0; i < nCnt; i++ )
	{
		CntFileNameEntry* pEntry =
						  (CntFileNameEntry*)_aFileEntryList.GetObject( i );
		if ( pEntry->_aLongName == rLongName )
		{
			DBG_ERROR( "AddFileEntry: Longname already in list!");

			if ( pEntry->_aShortName != rShortName )
			{
				DBG_ERROR( "Panic: Shortname in list differs from given name!");
				return FALSE;
			}
			return TRUE;
		}
	}
#endif

	_aFileEntryList.Insert( new CntFileNameEntry( rLongName, rShortName ) );

	// make list persistent!
	SaveFileEntryList_Impl();

	return TRUE;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::RemoveFileEntry( const String& rName )
{
	ULONG nCount = _aFileEntryList.Count();
	for ( ULONG i = 0; i < nCount; i++ )
	{
		CntFileNameEntry* pEntry =
						  (CntFileNameEntry*)_aFileEntryList.GetObject( i );
		if ( ( pEntry->_aLongName == rName ) ||
			 ( pEntry->_aShortName == rName ) )
		{
			_aFileEntryList.Remove( pEntry );
			delete pEntry;

			// make list persistent!
			SaveFileEntryList_Impl();

			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
BOOL CntRootNodeMgr::GetFileEntry( String& rLongName, String& rShortName )
{
	DBG_ASSERT( !( rLongName.Len() && rShortName.Len() ),
				"GetFileEntry - either rLongName or rShortName!!!" );

	ULONG nCount = _aFileEntryList.Count();
	if ( rLongName.Len() )
	{
		// get short name
		for ( ULONG i = 0; i < nCount; i++ )
		{
			CntFileNameEntry* pEntry =
						  (CntFileNameEntry*)_aFileEntryList.GetObject( i );
			if ( pEntry->_aLongName == rLongName )
			{
				rShortName = pEntry->_aShortName;
				return TRUE;
			}
		}

    	rShortName.Erase();
		return FALSE;
	}
	else if ( rShortName.Len() )
	{
		// get long name
		for ( ULONG i = 0; i < nCount; i++ )
		{
			CntFileNameEntry* pEntry =
						  (CntFileNameEntry*)_aFileEntryList.GetObject( i );
			if ( pEntry->_aShortName == rShortName )
			{
				rLongName = pEntry->_aLongName;
				return TRUE;
			}
		}

    	rLongName.Erase();
		return FALSE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
//virtual
CntJobDispatcher* CntRootNodeMgr::getJobDispatcher() const
{
	return _pDispatcher;
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SaveFileEntryList_Impl()
{
	if ( !_xStorage.Is() )
	{
		DBG_ERROR( "SaveFileEntryList: no storage!" );
		return;
	}

	String aString;

	ULONG nCount = _aFileEntryList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntFileNameEntry* pEntry =
						  (CntFileNameEntry*)_aFileEntryList.GetObject( n );

		// CntStringListItem is somewhat curious... --> '\n'
		if ( n )
			aString += '\n';

		aString += pEntry->_aLongName;
		aString += '/';
		aString += pEntry->_aShortName;
	}

	// save in storage...
	CntStringListItem aItem( WID_RNM_FILECONVERSION_LIST );
	aItem.SetString( aString );
	_xStorage->Put( aItem );
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SaveUpdateRequesterList_Impl()
{
	if ( !_xStorage.Is() )
	{
		DBG_ERROR( "SaveUpdateRequesterList: no storage!" );
		return;
	}

	String aString;

	ULONG nCount = _aUpdateList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntUpdateEntry *pEntry = _aUpdateList.GetObject( n );
		vos::ORef< CntUpdateTimer > xTimer = pEntry->_xTimer;

		// CntStringListItem is somewhat curious... --> '\n'
		if ( n )
			aString += '\n';

		aString += pEntry->_aURL;
		aString += ' ';

		if ( xTimer.isValid() )
			aString += String::CreateFromInt32( xTimer->GetTimeout() );
		else
			aString += '0';
	}

	// save in storage...
	CntStringListItem aItem( WID_RNM_UPDATETIMER_LIST );
	aItem.SetString( aString );

	_xStorage->Put( aItem );
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SaveViewList_Impl()
{
	if ( !_xStorage.Is() )
	{
		DBG_ERROR( "SaveViewList: no storage!" );
		return;
	}

	CntStorageNode* pStg = (CntStorageNode*)&_xStorage;

	const UniString aStreamName(
		UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( CNT_VIEW_LIST_STREAM ) ) );

	// destroy stream
	pStg->remove( aStreamName );

	ULONG nCount = _aViewList.Count();
	if ( nCount )
	{
	    SvStream* pStream =	pStg->openStream( aStreamName );
		if ( !pStream )
			return;

		ULONG nVersion = CNT_VIEW_LIST_VERSION;
		*pStream << nVersion;
		*pStream << nCount;

		for ( ULONG n = 0; n < nCount; ++n )
		{
			CntViewEntry* pEntry = _aViewList.GetObject( n );

			SfxPoolItem::writeUnicodeString( *pStream, pEntry->aViewURL );
			SfxPoolItem::writeUnicodeString( *pStream, pEntry->aContentType );
		}

		delete pStream;
	}
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SaveExplorerList_Impl()
{
	if ( !_xStorage.Is() )
	{
		DBG_ERROR( "SaveExplorerList: no storage!" );
		return;
	}

	CntStorageNode* pStg = (CntStorageNode*)&_xStorage;

	const UniString aStreamName(
		UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( CNT_EXPLORER_LIST_STREAM ) ) );

	// destroy stream
	pStg->remove( aStreamName );

	ULONG nCount = _aExplorerList.Count();
	if ( nCount )
	{
	    SvStream* pStream =	pStg->openStream( aStreamName );
		if ( !pStream )
			return;

		ULONG nVersion = CNT_EXPLORER_LIST_VERSION;
		*pStream << nVersion;
		*pStream << nCount;

		for ( ULONG n = 0; n < nCount; ++n )
			SfxPoolItem::writeUnicodeString( *pStream,
											 *_aExplorerList.GetObject( n ) );

		delete pStream;
	}
}

//----------------------------------------------------------------------------
void CntRootNodeMgr::SaveTransActionList_Impl()
{
#ifdef TF_CHAOS_TRANS
	if ( !_xStorage.Is() )
	{
		DBG_ERROR( "SaveTransActionList: no storage!" );
		return;
	}

	CntStorageNode* pStg = (CntStorageNode*)&_xStorage;

	// destroy stream
	pStg->remove( CNT_TRANSACTION_LIST_STREAM );

	CntTransActionMgr* pTransMgr = GetTransManager();

	ULONG nCount = pTransMgr->TransActionCount();
	if ( nCount )
	{
	    SvStream* pStream =	pStg->openStream( CNT_TRANSACTION_LIST_STREAM );
		if ( !pStream )
			return;

		pTransMgr->Store( *pStream, CNT_TRANSACTION_LIST_VERSION );

		delete pStream;
	}
#endif
}

/*========================================================================
 *
 * CntUpdateTimer Implementation.
 *
 *======================================================================*/

CntUpdateTimer::CntUpdateTimer( const String& rTargetURL, ULONG nInterval )
: _aTargetURL( rTargetURL ),
  _xAnchor( NULL ),
  _nNewMessages( 0 ),
  _nInterval( nInterval )
{
	setRemainingTime( nInterval );
}

//----------------------------------------------------------------------------
// virtual
CntUpdateTimer::~CntUpdateTimer()
{
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL CntUpdateTimer::onShot()
{
#ifdef USE_JOB_DISPATCHER
	Update();
#else
	SwitchToMain();
#endif
}

#ifndef USE_JOB_DISPATCHER
//----------------------------------------------------------------------------
// virtual
void CntUpdateTimer::SwitchedToMain()
{
	Update();
}
#endif

//----------------------------------------------------------------------------
void CntUpdateTimer::Update()
{
	// Do not send an Update-Request in case there is already one in progress
	if ( !_xAnchor )
	{
		CntRootNodeMgr* pRNM = CNT_RNM();

		if ( INetURLObject::CompareProtocolScheme(
											_aTargetURL ) == INET_PROT_FILE )
		{
			if ( !CntViewBase::ViewFileExists( _aTargetURL ) )
			{
				// Somebody killed the file!
				return;
			}
		}

		// Create node-chain
		_xAnchor = new CntAnchor( NULL, _aTargetURL );
		StartListening( *&_xAnchor );
		_xAnchor->Put( SfxVoidItem( WID_GETDATA ) );

		// No threading - Performance!
		_xAnchor->DontThread();

		///////////////////////////////////////////////////////////////////////
		// Try to get a permanent password...
		///////////////////////////////////////////////////////////////////////

		// permanent pw set? --> use it!
		const SfxPoolItem* pItem = NULL;
		if ( _xAnchor->GetItemState( WID_PASSWORD, TRUE, &pItem )
			 != SFX_ITEM_SET )
		{
			CntNode* pNode = _xAnchor->GetNode();
			while ( pNode &&
					!( (const CntBoolItem&)pNode->Get( WID_HAS_DATA, FALSE ) )
				   		.GetValue() )
				pNode = pNode->GetReferedNode();

			if ( pNode )
			{
				String   aUser;
				String   aPassword;
				CntNode* pMostRef = pNode->GetMostReferedNode();
				String   aURL( OWN_URL ( pMostRef ) );

				pRNM->GetLoginInfo( aURL, aUser, aPassword );
				if ( aPassword.Len() )
				{
					// set password before update
					pNode->CntInterface::Put(
					  CntStringItem( WID_PASSWORD, aPassword ), WID_PASSWORD );
				}
			}
		}

		// Do the update...
		_xAnchor->Put( CntUpdateItem( WID_UPDATE ) );
	}
}

//----------------------------------------------------------------------------
void GetViewURL_Impl( CntAnchor* pAnchor, String& rURL )
{
	String aRootURL( CntViewBase::GetRootViewURL( pAnchor->GetViewURL() ) );
	if ( aRootURL.Len() )
	{
		String aViewURL( CntViewBase::MakeViewURL( aRootURL, rURL ) );
		if ( aViewURL.Len() )
			rURL = aViewURL;
	}
}

//----------------------------------------------------------------------------
//virtual
void CntUpdateTimer::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	if ( _xAnchor && ( (CntAnchor*)&rBC == &_xAnchor ) )
	{
		// CntAnchorHint?
		const CntAnchorHint *pAnchorHint = PTR_CAST( CntAnchorHint, &rHint );
		if ( pAnchorHint )
		{
			switch ( pAnchorHint->GetAction() )
			{
				case CNT_ACTION_INSERTED:
				{
					CntAnchor* pAnchor = pAnchorHint->GetAnchor();
			        if ( ITEMSET_VALUE( pAnchor, CntBoolItem,
			        					WID_FLAG_IS_MESSAGE ) )
					{
						// There's a new message...!
						_nNewMessages++;
					}
					break;
				}

				default:
					break;
			}

			return;
		}

		// CntStatusHint?
		const CntStatusHint *pStatusHint = PTR_CAST( CntStatusHint, &rHint );
		if ( pStatusHint )
		{
	        const CntStatus eStatus = pStatusHint->GetStatus();
			if ( ( ( eStatus == CNT_STATUS_DONE ) &&
			       ( pStatusHint->GetRequest()->Which() == WID_UPDATE ) ) ||
			     ( ( eStatus == CNT_STATUS_ERROR ) &&
			       ( pStatusHint->GetError() == ERRCODE_ABORT ) ) )
			{
		        // Update job done or canceled.
				if ( _nNewMessages )
				{
					CntUpdateResult* pResult = new CntUpdateResult;

					pResult->aTargetURL = _aTargetURL;
					pResult->nNewMessages = _nNewMessages;
					pResult->aTitle = ITEMSET_VALUE( _xAnchor,
												     CntStringItem,
												     WID_TITLE );

					CNT_RNM()->Broadcast( CntUpdateHint( pResult ) );

					delete pResult;

					_nNewMessages = 0;
				}

				EndListening( *&_xAnchor );
				_xAnchor = NULL;

				// Restart...
				ULONG nTimeOut = GetTimeout();
				if ( nTimeOut )
				{
					stop();
					setRemainingTime( nTimeOut );
					start();
				}
			}

			return;
		}

		// CntUpdateHint?
		const CntUpdateHint *pUpdateHint = PTR_CAST( CntUpdateHint, &rHint );
		if ( pUpdateHint )
		{
			const CntUpdateResult& rResult = pUpdateHint->GetResult();

			CntUpdateResult* pResult = new CntUpdateResult;

			String aTargetURL( rResult.aTargetURL );
			GetViewURL_Impl( _xAnchor, aTargetURL );

			pResult->aTargetURL = aTargetURL;
			pResult->nNewMessages = rResult.nNewMessages;
			CntAnchorRef xAnchor = new CntAnchor( NULL, aTargetURL );
			xAnchor->Put( SfxVoidItem( WID_GETDATA ) );
			pResult->aTitle =
						ITEMSET_VALUE( xAnchor, CntStringItem, WID_TITLE );

			CNT_RNM()->Broadcast( CntUpdateHint( pResult ) );

			delete pResult;
			return;
		}
	}
}

/*========================================================================
 *
 * CntUpdateInitTimer Implementation.
 *
 *======================================================================*/

CntUpdateInitTimer::CntUpdateInitTimer( CntUpdateList *pList )
: NAMESPACE_VOS( OTimer )( LAZY_UPDATETIMER_INIT_DELAY * 1000 ),
  _pList( pList )
{
}

//----------------------------------------------------------------------------
//virtual
CntUpdateInitTimer::~CntUpdateInitTimer()
{
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL CntUpdateInitTimer::onShot()
{
#ifdef USE_JOB_DISPATCHER
	StartAutoUpdate();
#else
	SwitchToMain();
#endif
}

#ifndef USE_JOB_DISPATCHER
//----------------------------------------------------------------------------
// virtual
void CntUpdateInitTimer::SwitchedToMain()
{
	StartAutoUpdate();
}
#endif

//----------------------------------------------------------------------------
void CntUpdateInitTimer::StartAutoUpdate()
{
	CntRootNodeMgr* pRNM = CNT_RNM();

	ULONG nCount = _pList->Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntUpdateEntry* pEntry = _pList->GetObject( n );
		NAMESPACE_VOS( ORef )< CntUpdateTimer > xTimer = pEntry->_xTimer;
		if ( xTimer->GetTimeout() && pRNM->UpdateAllowed_Impl( pEntry ) )
		{
			// Already started manually?
			if ( !xTimer->isTicking() )
			{
				// Immediately do first update!
				xTimer->setRemainingTime( 0 );
				xTimer->start();
			}
		}
	}

	if ( !pRNM->_bLazyInitDone )
	{
		// Calling this static methods enables service nodes to do "something".
		CntRootNodeMgr::LazyInitialize();
		pRNM->_bLazyInitDone = TRUE;
	}
}

