/*************************************************************************
 *
 *  $RCSfile: cntthrd.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _DATETIMEITEM_HXX //autogen
#include <svtools/dateitem.hxx>
#endif

#include <ctype.h>

#include <cntthrd.hxx>

#ifndef _CNTIDS_HRC
#include <cntids.hrc>
#endif
#ifndef _CNTRULES_HXX //autogen
#define ITEMID_RULESET WID_RULES
#include <cntrules.hxx>
#endif
#ifndef _CNTRIDS_HRC
#include <cntrids.hrc>
#endif

#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CNTSITEM_HXX
#include <cntsitem.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef _OUTITEMS_HXX
#include <outitems.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _ALSTITEM_HXX
#include <alstitem.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CNTANCHR_HXX
#include <cntanchr.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

using namespace chaos;

#define COLLECT_INITIAL		   50
#define COLLECT_FIRST_WAIT	  250
#define COLLECT_WAIT		 3000
#define COLLECT_MAX_WAIT	10000


static BOOL Cnt_CompareItems( USHORT nWID, const CntAnchor *pAnchor, const SfxPoolItem *pCompare );

// ranges array
USHORT __READONLY_DATA aVirtualMsgFolderRanges_Impl[] =
{
	WID_MARK_THREAD_READ,		WID_MARK_THREAD_READ,
	WID_HIDE_SUBJECT,			WID_HIDE_SUBJECT,
	WID_MARK_THREAD_UNREAD,		WID_MARK_THREAD_UNREAD,
	WID_SEEN_STATUS, 			WID_SEEN_STATUS,
	WID_TITLE, 					WID_TITLE,
	WID_DELETE, 				WID_DELETE,
	WID_OWN_URL,				WID_OWN_URL,
	WID_FLAG_IS_FOLDER,			WID_FLAG_HAS_MESSAGES,
	WID_DATE_CREATED,			WID_IS_READ,
	0
};

// ranges array
USHORT __READONLY_DATA aVirtualFldFolderRanges_Impl[] =
{
	WID_TITLE, 				WID_TITLE,
	WID_OWN_URL,			WID_OWN_URL,
	WID_FLAG_IS_FOLDER,		WID_FLAG_HAS_MESSAGES,
	0
};

//---------------------------------------------------------------------------

ItemListData::ItemListData( const String &rValue )

/*      [Beschreibung]

    Konstruktor der Klasse ItemListData.

    Letzte Aenderung  DV 13.02.97
*/
{
	bIsReal         = FALSE;
	bIsVirtual      = FALSE;
	bIsCopy         = FALSE;
	sValue          = rValue;
	pAnchor         = NULL;
	pParent         = NULL;
	pChild          = NULL;
}

BOOL ItemListData::SetParent( ItemListData *pNewParent )
{
	ItemListData *pData = pNewParent;

	while ( pData )
	{
		if ( pData != this )
		{
			pData = pData->pParent;
		}
		else
		{
#ifdef CHECK_ANCHORS
			DBG_ERRORFILE( "SetParent erzeugt einen Zyklus" );
#endif
			break;
		}
	}
	if ( !pData )
		pParent = pNewParent;

	return ( pData == 0 );
}

//---------------------------------------------------------------------------
CntThreadData::CntThreadData()

/*      [Beschreibung]

    Konstruktor der Klasse CntThreadData.

    Letzte Aenderung  DV 02.02.97
*/
{
	nAnzTypes = 0;
	for ( int i = 0; i < THREADITEM_ANZ; i++ )
		pItemLists[ i ] = NULL;
}

//---------------------------------------------------------------------------
CntThreadData::~CntThreadData()

/*      [Beschreibung]

    Destruktor der Klasse CntThreadData.

    Letzte Aenderung  DV 02.02.97
*/
{
	for ( int i = 0; i < THREADITEM_ANZ; i++ )
		delete pItemLists[ i ];
}

//---------------------------------------------------------------------------
CntThreadList::~CntThreadList()
/*      [Beschreibung]

    Destruktor der Klasse CntThreadList.

    Letzte Aenderung  DV 02.02.97
*/
{
    ItemListData* pData = (ItemListData*)List::First();
    while ( pData )
    {
	delete pData;
	pData = (ItemListData*)List::Next();
    }
}

//---------------------------------------------------------------------------
void CntThreadList::SetRoot( CntAnchor *pAnchor, const CntThreadingInfo& rInfo )

/*      [Beschreibung]

    Setzt den Root CntAnchor und den ThreadType.

    Letzte Aenderung  DV 02.02.97
*/
{
	pRoot = pAnchor;
	nIsEnabledWID = rInfo.GetIsEnabledWID();
	nParentWID = rInfo.GetParentWID();
	nChildWID = rInfo.GetChildWID();
	nTitleWID = rInfo.GetTitleWID();
	eType = rInfo.GetType();
    cDelimiter = rInfo.GetDelimiter();
}

//---------------------------------------------------------------------------
ItemListData* CntThreadList::FindEntry( const String &rData, ULONG &rPos )

/*      [Beschreibung]

    Sucht in der Liste den Eintrag mit dem Wert rData. Wenn die Liste
    sortiert ist, kann man auch binaer suchen. rPos enthaelt die Postion
    in der Liste, an der ein neuer Eintrag eingefuegt werden muesste.

    Letzte Aenderung  DV 02.02.97
*/
{
	ULONG           nAnz;
	long            nStart, nEnd, nMid;
	ItemListData   *pData;
	StringCompare   eCompVal;

	nAnz = List::Count();

	if ( nAnz == 0 )
	{
		pData = 0;
		rPos = 0;
	}
	else
	{
		nStart = 0;
		nEnd = nAnz - 1;
		while ( nStart <= nEnd )
		{
			nMid = ( nEnd - nStart ) / 2 + nStart;
			pData = (ItemListData*) List::GetObject( nMid );
			eCompVal = rData.CompareTo( pData->sValue );

			if ( eCompVal == COMPARE_EQUAL )
				break;
			else if ( eCompVal == COMPARE_GREATER )                    // Array.str < rData
				nStart = nMid + 1;
			else
				nEnd = nMid - 1;
		}

		if ( eCompVal == COMPARE_GREATER )                             // Array.str < rData
		{
			pData = NULL;
			rPos = nMid + 1;
		}
		else if ( eCompVal == COMPARE_LESS )                     // Array.str > rData
		{
			pData = NULL;
			rPos = nMid;
		}
	}

#ifdef DBG_UTIL
/*      ItemListData *pOne, *pTwo;
	pOne = (ItemListData*) List::GetObject( 0 );
	for ( long i=1; i < (long) nAnz; i++ )
	{
		pTwo = (ItemListData*) List::GetObject( i );
		if ( pTwo->sValue < pOne->sValue )
			DBG_ERRORFILE( "Sortierung ist falsch" );
		pOne = pTwo;
	}
*/
#endif

	return pData;
}

//---------------------------------------------------------------------------
ItemListData* CntThreadList::FindAnchor( CntAnchor *pAnchor )

/*      [Beschreibung]

    Sucht in der Liste den Eintrag mit dem Anker pAnchor.

    Letzte Aenderung  DV 14.04.99
*/
{
	ULONG           nAnz = List::Count();
	ItemListData   *pData = NULL;

	for ( ULONG i=0; i<nAnz; i++ )
	{
		pData = (ItemListData*) List::GetObject( i );

		if ( pData && ( pData->pAnchor == pAnchor ) )
			return pData;
	}

	return pData;
}

//---------------------------------------------------------------------------
CntAnchor* CntThreadList::FindFirstParent( ItemListData *pStart )

/*      [Beschreibung]

    Sucht in der verketteten Liste den ersten Parent, der einen CntAnchor
    hat. Wenn kein Parent gefunden wird, dann wird der Root CntAnchor
    zurueckgeliefert.

    Letzte Aenderung  DV 02.02.97
*/
{
	ItemListData *pData = pStart;

	while ( pData->pParent )
	{
		pData = pData->pParent;

		if ( pData->pAnchor )
			return pData->pAnchor;

		if ( pData->pParent == pData )
		{
			DBG_ERRORFILE( "FindFirstParent: Child hat sich selbst als Parent !!!" );
			pData->pParent = NULL;
		}
	}

	return pRoot;
}

//---------------------------------------------------------------------------
CntAnchor* CntThreadList::FindFirstChild( ItemListData *pStart )

/*      [Beschreibung]

    Sucht in der verketteten Liste das erste Child, das einen CntAnchor
    hat. Es muss immer ein solches Child geben.

    Letzte Aenderung  DV 13.02.97
*/
{
	ItemListData *pData = pStart;

	while ( pData )
	{
		if ( pData->pAnchor )
			return pData->pAnchor;
		pData = pData->pChild;
	}

	return NULL;
}

//---------------------------------------------------------------------------
String CntThreadList::CutFirstParent( String &rParents )

/*      [Beschreibung]

    Schneidet aus dem String rParents den ersten Parent String heraus.

    Letzte Aenderung  DV 11.02.97
*/
{
	xub_StrLen nLen = rParents.Len();
	String aRet = rParents;

	if ( nLen )
	{
		if ( eType == CNT_THREADING_BY_PARENTPATH )
		{
			--nLen;
			while ( nLen && ( rParents.GetChar( nLen ) != cDelimiter ) )
				nLen--;
			aRet.Erase( nLen );
			rParents = aRet;
		}
		else if ( eType == CNT_THREADING_BY_PARENTCHAIN )
		{
			// da die References manchmal durch Leerzeichen getrennt sind und
			// manchmal nicht, nehmen wir die '<' als Trennzeichen. In diesem
			// Fall muss das Trennzeichen mit kopiert werden und trailing blanks
			// muessen entfernt werden.
			--nLen;
			while ( nLen && ( rParents.GetChar( nLen ) != cDelimiter ) )
				nLen--;
			aRet = rParents.Copy( nLen );                   // < als trenner
			rParents.Erase( nLen );
			rParents.EraseTrailingChars();
		}
		else
		{
			rParents.Erase();
		}
	}
	return aRet;
}

//---------------------------------------------------------------------------
void CntThreadList::CutReply( String& rStr )

/*      [Beschreibung]

    Schneidet aus dem String rStr 'Re:' etc. raus.

    Letzte Aenderung  DV 05.02.97
*/
{
	Cnt_CutReply( rStr );
}

//---------------------------------------------------------------------------
void CntThreadList::CleanUpLists( CntAnchor *pAnchor )
/*      [Beschreibung]

	Diese Funktion raeumt nach dem erweitern einer Liste die anderen Listen auf.
    Letzte Aenderung  DV 11.03.97
*/
{
	CntThreadList   *pList;

	for ( int i = 0; i < THREADITEM_ANZ; i++ )
	{
		pList = pRoot->_pCntThreadData->pItemLists[ i ];

		if ( pList && ( pList->eType == CNT_THREADING_BY_PROPVALUE ) )
		{
			ULONG         nPos;
			ItemListData *pData;
			String        aValue = ((const CntStringItem&)pAnchor->Get( pList->nChildWID )).GetValue();

			Cnt_CutReply( aValue );
			pData = pList->FindEntry( aValue, nPos );

			if ( pData && pData->bIsVirtual )
			{
				if ( pData->pAnchor->SubAnchorCount() == 1 )
				{
					pAnchor = pData->pAnchor->GetSubAnchor( 0 );
					pAnchor->ChangeParent( pRoot );
					pRoot->RemoveSubAnchor( pData->pAnchor );
					pData->bIsVirtual = FALSE;
					pData->bIsReal = TRUE;
					pData->pAnchor = pAnchor;
				}
				else if ( pData->pAnchor->SubAnchorCount() == 0 )
				{
					pRoot->RemoveSubAnchor( pData->pAnchor );
					pList->Remove( (void*) pData );
					delete pData;
				}
			}
		}
	}
}

//---------------------------------------------------------------------------
void CntThreadList::CheckLists( CntAnchor *pOld, CntAnchor *pNew )
/*      [Beschreibung]

	Diese Funktion prueft, ob der Anker noch in anderen Listen auftaucht.
    Letzte Aenderung  DV 12.08.98
*/
{
	CntThreadList   *pList;

	for ( int i = 0; i < THREADITEM_ANZ; i++ )
	{
		pList = pRoot->_pCntThreadData->pItemLists[ i ];

		if ( pList && ( pList != this ) &&
			 ( pList->eType == CNT_THREADING_BY_PROPVALUE ) )
		{
			ULONG         nPos;
			ItemListData *pData;
			String        aValue = ((const CntStringItem&)pOld->Get( pList->nChildWID )).GetValue();

			Cnt_CutReply( aValue );
			pData = pList->FindEntry( aValue, nPos );

			if ( pData && pData->pAnchor == pOld )
			{
				if ( pOld->SubAnchorCount() == 0 )
				{
					pList->Remove( (void*) pData );
					delete pData;
				}
			}
		}
	}
}

void CntThreadList::CheckParents( String &rParents,
								  ItemListData* pFirstParent,
								  CntNodeJob* pJob )
/*      [Beschreibung]

	Diese Funktion prueft, ob die Parent Chain stimmt und erweitert diese ggfs.
    Letzte Aenderung  DV 11.03.97
*/
{
	ItemListData    *pLast = pFirstParent;
	ItemListData    *pCheckMe = pFirstParent->pParent;
	String                  sNextParent = CutFirstParent( rParents );
	ULONG                   nPos;

	while ( sNextParent.Len() )
	{
		if ( ! pCheckMe )
		{
			pCheckMe = FindEntry( sNextParent, nPos );
			if ( pCheckMe )
			{
				if ( pCheckMe == pLast )
				{
#ifdef CHECK_ANCHORS
					DBG_ERRORFILE( "Doppelte Referenzen!!!" );
#endif
					break;
				}
				else
				{
					BOOL             bCycleFound = FALSE;
					ItemListData *pTemp = pCheckMe->pParent;
					while ( pTemp && ! bCycleFound )
					{
						if ( pTemp == pLast )
						{
#ifdef CHECK_ANCHORS
							DBG_ERRORFILE( "Zyklische Referenzen!!!" );
#endif
							bCycleFound = TRUE;
						}
						else
							pTemp = pTemp->pParent;
					}
					if ( bCycleFound )
						break;
				}
				if ( ! pCheckMe->pChild )
					pCheckMe->pChild = pLast;

				if ( ! pCheckMe->pAnchor )
					InsertInBetween( pCheckMe, NULL, NULL, pJob );

				// Wenn InsertInBetween keinen neuen Anker erzeugen kann, dann
				// hoeren wir hier auf
				if ( ! pCheckMe->pAnchor )
					break;

				CntAnchor *pFirstChild = FindFirstChild( pLast );
				if ( pFirstChild )
				{
					pFirstChild->ChangeParent( pCheckMe->pAnchor, pRoot );
					CleanUpLists( pFirstChild );
				}
			}
			else
			{
				pCheckMe = new ItemListData( sNextParent );
				pCheckMe->pChild = pLast;
				List::Insert( pCheckMe, nPos );
			}
			if ( pLast != pCheckMe )
				pLast->SetParent( pCheckMe );
			else
				DBG_ERRORFILE( "Kann mich nicht selbst als Parent Setzen!!!" );
		}

		pLast = pCheckMe;
		pCheckMe = pCheckMe->pParent;
		sNextParent = CutFirstParent( rParents );
	}
}

BOOL CntThreadList::InsertInList( const String &rSelf,
								  const String &rParents,
								  ItemListData** pItem,
								  ItemListData** pItemParent,
								  CntNodeJob* pJob )
/*      [Beschreibung]

    Fuegt einen Knoten und seine Parents in die Liste ein. Wenn der Eintrag
    schon in der Liste war, liefert die Funktion den Wert TRUE zurueck.

    Letzte Aenderung  DV 10.03.97
*/
{
	ULONG   nPos;
	BOOL    bRet;

	*pItem = FindEntry( rSelf, nPos );
	*pItemParent = NULL;

	if ( *pItem )
		bRet = TRUE;
	else
	{
		*pItem = new ItemListData( rSelf );
		List::Insert( *pItem, nPos );
		bRet = FALSE;
	}

	if ( rParents.Len() && ! (*pItem)->pParent )
	{
		if ( IsUniqueType( eType ) )
		{
			ItemListData    *pParent = NULL;
			ItemListData    *pLast = *pItem;
			String          sParents = rParents;
			String          sNextParent = CutFirstParent( sParents );

			while ( sNextParent.Len() )
			{
				pParent = FindEntry( sNextParent, nPos );
				if ( pParent )
				{
					if ( pLast != pParent )
					{
						// Wenn der parent nicht gesetzt werden konnte, weil dann ein
						// Zyklus aufgetreten waere, duerfen wir auch keinen parent setzen
						if ( pLast->SetParent( pParent ) )
						{
							*pItemParent = pParent;
							CheckParents( sParents, pParent, pJob );
						}
					}
					break;
				}
				else
				{
					pParent = new ItemListData( sNextParent );
					pLast->SetParent( pParent );
					pParent->pChild = pLast;
					List::Insert( pParent, nPos );
					pLast = pParent;
				}
				sNextParent = CutFirstParent( sParents );
			}
		}
		else
		{
			*pItemParent = FindEntry( rParents, nPos );
			if ( *pItemParent == *pItem )
				*pItemParent = NULL;
		}
	}

	if ( (*pItem)->bIsCopy )
	{
		if ( ! (*pItem)->pAnchor )
		{
			DBG_ERRORFILE( "ThreadItem ist Kopie, aber hat keinen Anker?" );
			bRet = FALSE;
		}
		else if( (*pItem)->pAnchor->GetParent() != FindFirstParent( *pItem ) )
			bRet = FALSE;
	}

	return bRet;
}

//---------------------------------------------------------------------------
void CntThreadList::InsertInBetween( ItemListData *pSelf,
									 CntAnchor *pUsedAnchor,
									 CntAnchor *pNewAnchor,
									 CntNodeJob* pJob )
/*      [Beschreibung]

    Fuegt einen neuen CntAnchor zwischen zwei bereits existierende Knoten
    ein. pSelf->pAnchor sollte erst am Schluss gesetzt werden, weil
    FindFirstChild auch sich selbst finden koennen soll.

    Letzte Aenderung  DV 05.03.97
*/
{
	CntAnchor       *pChildAnchor, *pParentAnchor;
	CntAnchorRef    xAnchorRef;
	BOOL            bIsMessage = FALSE;

	pChildAnchor = FindFirstChild( pSelf );
	pParentAnchor = FindFirstParent( pSelf );

	if ( pChildAnchor && pChildAnchor->GetParent() &&
		 ( pChildAnchor->GetParent() != pParentAnchor ) &&
		 ( pChildAnchor->GetParent()->GetParent() == pParentAnchor ) )
	{
		// Hier kommen wir hoffentlich nur hin, wenn wir Anker per Title
		// zusammengefasst haben und nun durch das Threaden diese Struktur
		// zerrissen wird.
		pParentAnchor = pChildAnchor->GetParent();
	}

	if ( pUsedAnchor )
	{
		pNewAnchor = pUsedAnchor;
		xAnchorRef = pNewAnchor;
		pUsedAnchor->GetParent()->RemoveSubAnchor( pUsedAnchor );
		pSelf->bIsReal = TRUE;
		bIsMessage = pUsedAnchor->_bIsDocument;
	}
	else if ( pNewAnchor )
	{
		xAnchorRef = pNewAnchor;
		pSelf->bIsReal = TRUE;
		bIsMessage = pNewAnchor->_bIsDocument;
	}
	else
	{
		pNewAnchor = new CntAnchor( pParentAnchor, NULL );
		xAnchorRef = pNewAnchor;

		if ( pChildAnchor )
		{
			bIsMessage = pChildAnchor->_bIsDocument;
			pNewAnchor->_bUsesNewView = pChildAnchor->_bUsesNewView;
		}

		pNewAnchor->_bIsDocument = bIsMessage;
		if ( bIsMessage )
		{
			pNewAnchor->SetRanges( aVirtualMsgFolderRanges_Impl );

			if ( pChildAnchor )
			{
				SfxItemState eState = pChildAnchor->GetItemState( WID_DELETE, TRUE );
				if( eState <= SFX_ITEM_DISABLED )
				{
					pNewAnchor->DisableItem( WID_DELETE );
				}
			}
		}
		else
			pNewAnchor->SetRanges( aVirtualFldFolderRanges_Impl );

		if ( pChildAnchor && ( eType == CNT_THREADING_BY_PARENTCHAIN ) )
		{
			String aTitle = ((const CntStringItem &)(pChildAnchor->Get( nTitleWID ))).GetValue();
			Cnt_CutReply( aTitle );
			pNewAnchor->Put( CntStringItem( nTitleWID, aTitle ), nTitleWID );
		}
		else
			pNewAnchor->Put( CntStringItem( nChildWID, pSelf->sValue ), nChildWID );

		if ( bIsMessage )
		{
			pNewAnchor->Put( pChildAnchor->Get( WID_DATE_CREATED ), WID_DATE_CREATED );
			// Messages muessen wir jetzt selber festhalten !
			pNewAnchor->AddRef();
			pNewAnchor->_bNeedRelease = TRUE;
		}

		pNewAnchor->Put( CntBoolItem( WID_FLAG_IS_DOCUMENT, bIsMessage ), WID_FLAG_IS_DOCUMENT );

		pSelf->bIsVirtual = TRUE;
		pSelf->bIsReal = FALSE;
		pSelf->bIsCopy = FALSE;
	}

	pNewAnchor->_bIsThreaded = TRUE;

	if ( !bIsMessage )
		pNewAnchor->CntInterface::Put(
						CntBoolItem( WID_FLAG_HAS_FOLDER, TRUE ), WID_FLAG_HAS_FOLDER );

	pNewAnchor->CntInterface::Put(
					CntBoolItem( WID_FLAG_HAS_MESSAGES, TRUE ), WID_FLAG_HAS_MESSAGES );

	if ( pChildAnchor )
	{
		pParentAnchor->InsertSubAnchor( pNewAnchor, pRoot, pJob );

		CntAnchor *pOldParent = pChildAnchor->GetParent();
		pChildAnchor->ChangeParent( pNewAnchor, pRoot );

		if ( pOldParent && ! pOldParent->SubAnchorCount() )
		{
			pOldParent->RemoveFromLists();
			pParentAnchor = pOldParent->GetParent();
			if ( pParentAnchor )
				pParentAnchor->RemoveSubAnchor( pOldParent );
		}
	}
	else
		pParentAnchor->InsertSubAnchor( pNewAnchor, pRoot, pJob );

	if ( pNewAnchor->GetRefCount() > 1 )
		pSelf->pAnchor = pNewAnchor;
	else
	{
		DBG_ERRORFILE( "InsertInBetween: Keiner haelt den Anker fest!" );
		pSelf->bIsVirtual = FALSE;
		pSelf->bIsReal = FALSE;
		pSelf->bIsCopy = FALSE;
	}
}

//---------------------------------------------------------------------------
BOOL CntThreadList::InsertAnchor( CntAnchor **pAnchor,
								  CntAnchor *pNewAnchor,
								  ItemListData **pLastNode,
								  BOOL &bIsInserted,
								  CntNodeJob* pJob )
/*      [Beschreibung]

    Fuegt einen neuen CntAnchor in den Baum ein.

    Letzte Aenderung  DV 23.03.2000
*/
{
	ItemListData    *pSelf, *pParent;
	String          sParentData;
	String          sChildData;

	// Wenn ein Knoten bereits einsortiert wurde, dann wird er jetzt ignoriert.
	if ( *pLastNode &&
		 ( ( (*pLastNode)->pAnchor->GetParent() != pRoot ) ||
		   ( (*pLastNode)->bIsVirtual ) ) )
		return TRUE;

	BOOL bThreadIt = ((const CntBoolItem &) pNewAnchor->Get( nIsEnabledWID )).GetValue();

	// Wenn das Item nicht gethreaded werden soll, dann wird das Item einfach ignoriert.
	if ( ! bThreadIt )
		return FALSE;

	// Wenn wir nach PropValue threaden, dann sollten wir die ueberfluessigen Re's am
	// Anfang wegschneiden. Dafuer brauchen wir in diesem Fall den ParentString nicht.
	sChildData = ((const CntStringItem &)(pNewAnchor->Get( nChildWID ))).GetValue();

	if ( eType == CNT_THREADING_BY_PROPVALUE )
		Cnt_CutReply( sChildData );
	else
	{
		sParentData = ((const CntStringItem &)(pNewAnchor->Get( nParentWID ))).GetValue();
		// Da manche Server im InReplyTo Feld hinter der MsgID noch mehr senden, werden
		// hier die Daten zurechtgestutzt
		if ( ( nParentWID == WID_IN_REPLY_TO ) && sParentData.Len() )
		{
			xub_StrLen nLen = sParentData.Len() -1;
			while ( nLen && ( sParentData.GetChar( nLen ) != '>' ) )        // MsgID hoert mit '>' auf
				nLen--;
			sParentData.Erase( nLen + 1 );
		}
	}

	// Wenn wir keine Daten haben, dann sollten wir auch nicht threaden, es sei denn
	// wir fassen nach Subject zusammen
	if ( ( eType != CNT_THREADING_BY_PROPVALUE ) && !sChildData.Len() )
		return TRUE;

	bIsInserted = TRUE;

	if ( InsertInList( sChildData, sParentData, &pSelf, &pParent, pJob ) )
	{
		// Wenn die Daten schon in der Liste sind, unterscheiden wir die Faelle, dass
		// die Daten eindeutig sind (z.B. message ids) oder eben nicht (z.B. subjects).
		// Grundsaetzlich gibt es drei Faelle, die unterschieden werden muessen, wenn
		// die Daten schon in der Liste sind:
		//              1. Es gibt bereits einen Anker,
		//              2. die Daten verweisen auf einen Virtuellen Knoten
		//              3. die Daten verweisen auf einen Knoten, der referenziert wird, aber
		//                      der noch nicht existiert.

		if ( IsUniqueType( eType ) )
		{
			// sollte eigentlich nicht vorkommen, aber im IMAP Bereich gibt es wohl doppelte
			// MsgIDs !!!
			if ( pSelf->bIsReal )
			{
				if ( *pLastNode && (*pLastNode)->pAnchor )
				{
					(*pLastNode)->pAnchor->ChangeParent( pSelf->pAnchor->GetParent(), pRoot );
					pSelf->pAnchor = (*pLastNode)->pAnchor;
				}
				else if ( *pAnchor )
				{
					(*pAnchor)->ChangeParent( pSelf->pAnchor->GetParent(), pRoot );
					(*pAnchor)->_bIsThreaded = TRUE;
					pSelf->pAnchor = (*pAnchor);
				}
				else
				{
					pSelf->pAnchor->GetParent()->InsertSubAnchor( pNewAnchor, pRoot, pJob );
					pNewAnchor->_bIsThreaded = TRUE;
					pSelf->pAnchor = pNewAnchor;
				}
			}
			else if ( pSelf->bIsVirtual )                                   // zu einem virtuellen Knoten trudelt
			{                                                               // der wirkliche Knoten ein
				CntAnchor *pMyParent = pSelf->pAnchor->GetParent();
				if ( *pLastNode && (*pLastNode)->pAnchor )
				{
					(*pLastNode)->pAnchor->ChangeParent( pMyParent, pRoot );
					pNewAnchor = (*pLastNode)->pAnchor;
				}
				else if ( *pAnchor )
				{
					(*pAnchor)->ChangeParent( pMyParent, pRoot );
					pNewAnchor = (*pAnchor);
				}
				else
				{
					pMyParent->InsertSubAnchor( pNewAnchor, pRoot, pJob );
				}
				pNewAnchor->_bIsThreaded = TRUE;
				pNewAnchor->CopyChildren( pSelf->pAnchor );
				CheckLists( pSelf->pAnchor, pNewAnchor );
				pMyParent->RemoveSubAnchor( pSelf->pAnchor );
				pSelf->pAnchor = pNewAnchor;
				pSelf->bIsVirtual = FALSE;
				pSelf->bIsReal = TRUE;
				pSelf = NULL;
			}
			else
			{
				// Wenn wir den Knoten schon mal eingefuegt hatten, dann wirds kompliziert:
				// ....
				if ( *pLastNode )
				{
					CntAnchor *pTmpAnchor = FindFirstParent( *pLastNode );
					if ( pTmpAnchor != pRoot )
						(*pLastNode)->pAnchor->ChangeParent( pTmpAnchor, pRoot );

					pTmpAnchor = FindFirstChild( pSelf );
					if ( pTmpAnchor && ( pTmpAnchor->GetParent() == pRoot ) )
						pTmpAnchor->ChangeParent( (*pLastNode)->pAnchor, pRoot );

					pSelf->pAnchor = (*pLastNode)->pAnchor;
					pSelf->bIsCopy = TRUE;
					pSelf->bIsReal = TRUE;
				}
				else
					InsertInBetween( pSelf, (*pAnchor),     // der Knoten existierte bis jetzt nur
									 pNewAnchor, pJob );    // in der Liste und wird jetzt real
			}
		}
		else
		{
			if ( ! pSelf->bIsReal && ! pSelf->bIsVirtual )  // Kann das ueberhaupt sein?
				InsertInBetween( pSelf, (*pAnchor), pNewAnchor, pJob );
			else
			{
				// Es gibt bereits einen Eintrag mit diesen Daten und wir muessen noch einen
				// mit den gleichen Daten einfuegen. Wenn pSelf auf einen echten Anker
				// verweist, dann muss noch ein virtueller Anker dazwischen geschoben werden,
				// ansonsten haengen wir uns einfach mit an den virtuellen Anker ran.
				// pSelf sollte immer auf den obersten Knoten zeigen.

				// Check for recursion first
				CntAnchor* pTest = pSelf->pAnchor;
				while ( pTest )
				{
					if ( pTest == pNewAnchor )
						return TRUE;
					else
						pTest = pTest->GetParent();
				}
				if ( pSelf->bIsReal )
					InsertInBetween( pSelf, NULL, NULL, pJob );

				// Wenn InsertInBetween keinen neuen Anker erzeugen konnte, dann
				// hoeren wir hier auf
				if ( ! pSelf->pAnchor )
					return TRUE;

				if ( *pLastNode && (*pLastNode)->pAnchor )
				{
					(*pLastNode)->pAnchor->ChangeParent( pSelf->pAnchor, pRoot );
				}
				else if ( *pAnchor )
				{
					(*pAnchor)->ChangeParent( pSelf->pAnchor, pRoot );
					(*pAnchor)->_bIsThreaded = TRUE;
				}
				else
				{
					pSelf->pAnchor->InsertSubAnchor( pNewAnchor, pRoot, pJob );
					pNewAnchor->_bIsThreaded = TRUE;
					pSelf = NULL;
				}
			}
		}
	}
	else
	{
		// Der Knoten war noch nicht in der Liste und ist auch noch nicht nach einem
		// anderem Threading Kriterium einsortiert worden. Wenn zu diesem Knoten ein
		// Parent gefunden wurde, dann wird der Knoten unter diesem Parent einsortiert.
		if ( pParent )
		{
			// Wenn der Parent bis jetzt nur als Platzhalter existiert, dann wird
			// jetzt ein echter Knoten angelegt, damit der neue Knoten angehaengt werden
			// kann.
			if ( ! pParent->pAnchor )
				InsertInBetween( pParent, NULL, NULL, pJob );

			if ( ! pParent->pAnchor )
				return TRUE;

			if ( *pLastNode && (*pLastNode)->pAnchor )
			{       // Wenn der Knoten schon bearbeitet wurde, dann wird er jetzt umgehaengt.
				(*pLastNode)->pAnchor->ChangeParent( pParent->pAnchor, pRoot );
				pNewAnchor = (*pLastNode)->pAnchor;
				pSelf->bIsCopy = TRUE;
			}
			else if ( *pAnchor )
			{       // Wenn wir von not threaded auf threaded umschalten, dann wird der Anker
				// vom Root Anker an den Parent gehaengt.
				(*pAnchor)->ChangeParent( pParent->pAnchor, pRoot );
			}
			else
			{       // Ansonsten wird ein neuer Anker erzeugt und an den Parent gehaengt.
				pParent->pAnchor->InsertSubAnchor( pNewAnchor, pRoot, pJob );
			}

			pParent->pAnchor->CntInterface::Put( CntBoolItem( WID_FLAG_HAS_FOLDER, TRUE ),
												 WID_FLAG_HAS_FOLDER );
		}
		else
		{
			// Wenn es keinen Parent zu diesem Knoten gibt, dann wird der Knoten an
			// die Root angebunden. Natuerlich nur, wenn der Knoten noch nicht angebunden
			// ist.
			if ( *pLastNode )
			{
				pSelf->pAnchor = (*pLastNode)->pAnchor;
				pSelf->bIsCopy = TRUE;
				pSelf->bIsReal = TRUE;
				*pLastNode = pSelf;
				return TRUE;
			}
			if ( ! *pAnchor )
			{
				pRoot->InsertSubAnchor( pNewAnchor, pRoot, pJob );
			}
		}

		if ( *pAnchor )
			pSelf->pAnchor = *pAnchor;
		else
			pSelf->pAnchor = pNewAnchor;

		pSelf->pAnchor->_bIsThreaded = TRUE;
		pSelf->bIsReal = TRUE;
	}

	*pLastNode = pSelf;
	*pAnchor = NULL;
	return ( pSelf != NULL );
}

//---------------------------------------------------------------------------
void CntAnchor::InsertThreaded( CntAnchor *pOldAnchor,
								CntAnchor *pNewAnchor,
								CntNodeJob* pJob,
								BOOL	  *pThreadIt )

/*      [Beschreibung]

    Fuegt einen neuen CntAnchor in den Baum ein.

    Letzte Aenderung  DV 19.01.98
*/
{
	if ( pNewAnchor && _pOpenData && _pOpenData->InsertAnchor( pNewAnchor ) )
		return;

	const CntThreadingItem &rItem = (const CntThreadingItem &) Get( WID_THREADING );
	USHORT                  nThreadItems = rItem.Count();
	BOOL                    bDoThreading;

	if ( pThreadIt )
		bDoThreading = *pThreadIt;
	else
	{
		const CntBoolItem &rThreading = (const CntBoolItem &) Get( WID_THREADED );
		bDoThreading = rThreading.GetValue();
	}

	// Wir halten unsere Kinder fest!
	if ( pNewAnchor )
	{
		if ( IsVisible() )
		{
			pNewAnchor->AddRef();
			pNewAnchor->_bNeedRelease = TRUE;
			pNewAnchor->_bUsesNewView = TRUE;
		}
		else
		{
			// Im Explorer wird auch gethreaded, wenn IsVisible() FALSE liefert.
			bDoThreading &= ! pNewAnchor->_bIsDocument;
		}
	}
    if ( ! pOldAnchor )
    {
        InsertSubAnchor( pNewAnchor, NULL, pJob );
    }
}

//---------------------------------------------------------------------------
CntThreadList* CntAnchor::GetItemList( const CntThreadingItem& rItem, ULONG nIndex )

/*      [Beschreibung]

    Liefert die zu einem ThreadType gehoerende Liste der ThreadItems zurueck.

    Letzte Aenderung  DV 11.03.97
*/
{
	CntThreadList   *pList;

	if ( nIndex >= THREADITEM_ANZ )
	{
		DBG_ERRORFILE( "nIndex out of bounds" );
		nIndex = 0;
	}

	if ( ! _pCntThreadData )
		_pCntThreadData = new CntThreadData;

	if ( ! _pCntThreadData->pItemLists[ nIndex ] )
	{
		const CntThreadingInfo& rInfo = rItem[ (USHORT) nIndex ];
		_pCntThreadData->pItemLists[ nIndex ] = new CntThreadList;
		pList = _pCntThreadData->pItemLists[ nIndex ];
		pList->SetRoot( this, rInfo );
	}
	else
		pList = _pCntThreadData->pItemLists[ nIndex ];

	return pList;
}

//---------------------------------------------------------------------------
void CntAnchor::ChangeThreadingMode( CntAnchor *pParent, BOOL bThreadIt )

/*      [Beschreibung]

    Liefert die zu einem ThreadType gehoerende Liste der ThreadItems zurueck.

    Letzte Aenderung  DV 08.04.98
*/
{
	ULONG           nCount, nProgCount, nDiv;
	CntAnchor       *pAnchor;
	BOOL            bFinished = FALSE;

	if ( !SubAnchorCount() )
		return;

	if ( bThreadIt )
	{
		const CntThreadingItem  &rItem = (const CntThreadingItem &) Get( WID_THREADING );
		CntThreadList           *pList = GetItemList( rItem, 0 );

		if ( !pList ) return;

		USHORT                   nIsEnabledWID = pList->GetEnabledWID();

		if ( !nIsEnabledWID ) return;

		_bLocked = TRUE;

		while ( !bFinished )
		{
			nCount          = 0;
			nProgCount      = 0;
			bFinished       = TRUE;
			pAnchor         = GetSubAnchor( nCount++ );
			nDiv            = SubAnchorCount() / 20;

			if ( nDiv == 0 )
				nDiv = 1;

			while ( pAnchor )
			{
				CntAnchorRef aXRef1 = pAnchor;
				if ( ! pAnchor->_bIsThreaded &&
					 ((const CntBoolItem &) pAnchor->Get( nIsEnabledWID )).GetValue() )
				{
					InsertThreaded( pAnchor, NULL, NULL, &bThreadIt );
					pAnchor->_bIsThreaded = TRUE;
					nCount--;
					bFinished = FALSE;
					nProgCount++;
				}
				pAnchor = GetSubAnchor( nCount++ );
			}
		}

		_bLocked = FALSE;
	}
	else
	{
// KSO - CHAOS-DLL!
//		SfxProgress     *pProg2 = NULL;

		_bLocked = TRUE;

		if ( pParent == this )
		{
			nProgCount      = 0;
		}

		while ( !bFinished )
		{
			nCount          = 0;
			bFinished       = TRUE;
			pAnchor         = GetSubAnchor( nCount++ );

			while ( pAnchor )
			{
				CntAnchorRef aXRef2 = pAnchor;
// KSO - CHAOS-DLL!
/*
				if ( pProg2 && pAnchor->_bIsThreaded )
				{
					nProgCount++;
					pProg2->SetState( nProgCount );
				}
*/
				if ( pAnchor->SubAnchorCount() )
				{
					pAnchor->CntInterface::Put( CntBoolItem( WID_FLAG_HAS_FOLDER, FALSE ),
											WID_FLAG_HAS_FOLDER );
					if ( pAnchor->_bIsDocument )
						pAnchor->CntInterface::Put( CntBoolItem( WID_FLAG_HAS_MESSAGES, FALSE ),
											WID_FLAG_HAS_MESSAGES );
					pAnchor->ChangeThreadingMode( pParent, bThreadIt );
				}
				if ( pAnchor->_bIsThreaded && ( pAnchor->GetTParent() == pParent ) )
				{
					if ( ! pAnchor->GetNode() )             // virtueller Knoten muss entfernt werden
					{
						RemoveSubAnchor( pAnchor );
						nCount--;                           // damit wir kein Element ueberspringen!
					}
					else
					{
						if ( this != pParent )
						{
							bFinished = FALSE;
							pAnchor->ChangeParent( pParent );
							nCount--;                       // damit wir kein Element ueberspringen!
						}
						pAnchor->_bIsThreaded = FALSE;
					}
				}
				pAnchor = GetSubAnchor( nCount++ );
			}
		}

// KSO - CHAOS-DLL!
//		if ( pProg2 )
//			delete pProg2;

		// Zum Schluss werfen wir noch die alten Threading Listen weg, damit wir spaeter
		// nicht durcheinander kommen, wenn wir wieder threaden sollen.
		if ( ( this == pParent ) &&  _pCntThreadData )
		{
			delete _pCntThreadData;
			_pCntThreadData = NULL;
		}
		_bLocked = FALSE;
	}
	CheckChildList();
}

//---------------------------------------------------------------------------
void CntAnchor::CreateAndApplyRule( USHORT nWID )

/*      [Beschreibung]

	Diese Funktion erzeugt entsprechend der uebergebenen WhichID eine Regel und
	wendet diese dann auf alle Kinder des Root Ankers an.

    Letzte Aenderung  DV 20.02.98
*/
{
	CntAnchor       *pRoot;
	CntNodeRuleTerm *pTerm;
	CntNodeRule     *pRule;

	if ( ! _bIsDocument )
		return;

	pRoot = GetTParent();
	if ( !pRoot )
		return;

	CntNodeRuleSet aRuleSet = ((CntRuleSetItem &)pRoot->Get( WID_RULES )).GetRuleSet();

	if ( nWID == WID_HIDE_AUTHOR )
	{
		pTerm = new CntNodeRuleTerm( NULL, WID_FROM, CNT_NODE_RULE_OPERATOR_EQUAL,
									 ((const CntStringItem &)Get( WID_FROM )).GetValue(),
									 TRUE );
	}
	else if ( nWID == WID_HIDE_SUBJECT )
	{
		String aSubject = ((const CntStringItem &)Get( WID_TITLE )).GetValue();
		Cnt_CutReply( aSubject );
		pTerm = new CntNodeRuleTerm( NULL, WID_TITLE, CNT_NODE_RULE_OPERATOR_CONTAINS,
									 aSubject, TRUE );
	}
	else if ( nWID == WID_HIDE_THREAD )
	{
		String aFirstRef = ((const CntStringItem &)Get( WID_REFERENCES )).GetValue();

		// Da die Root Msg vom Thread keine References hat, muss diese Msg ueber
		// MsgID geloescht werden, dazu suchen wir uns die erste referenzierte
		// MsgID oder wir nehmen unsere eigene MsgID, wenn wir keine Referenzen
		// haben (dann sind wir naemlich die Root)
		if ( aFirstRef.Len() )
		{
			xub_StrLen nLen = 0;
			while ( (nLen < aFirstRef.Len()) && ( aFirstRef.GetChar( nLen ) != '>' ) )
				nLen++;
			aFirstRef.Erase( nLen + 1 );
		}
		else
		{
			aFirstRef = ((const CntStringItem &)Get( WID_MESSAGE_ID )).GetValue();
		}

		// erst alle Referenzen loeschen
		pTerm = new CntNodeRuleTerm( NULL, WID_REFERENCES,
									 CNT_NODE_RULE_OPERATOR_CONTAINS,
									 aFirstRef, TRUE );
		pRule = new CntNodeRule( NULL, CNT_NODE_ACTION_HIDE );
		pRule->InsertTerm( pTerm );
		pRoot->ApplyOneRule( *pRule );
		aRuleSet.InsertRule( pRule );

		// und dann die Root
		pTerm = new CntNodeRuleTerm( NULL, WID_MESSAGE_ID,
									 CNT_NODE_RULE_OPERATOR_EQUAL,
									 aFirstRef, TRUE );
	}
/*      else if ( nWID == WID_HIDE_MESSAGE )
	{
		pTerm = new CntNodeRuleTerm( NULL, WID_MESSAGE_ID,
									 CNT_NODE_RULE_OPERATOR_EQUAL,
									 ((const CntStringItem &)Get( WID_MESSAGE_ID )).GetValue(),
									 TRUE );
	}
*/

	pRule = new CntNodeRule( NULL, CNT_NODE_ACTION_HIDE );

	pRule->InsertTerm( pTerm );
	pRoot->ApplyOneRule( *pRule );
	aRuleSet.InsertRule( pRule );

	// Neues ItemSet anlegen, die Regeln einpacken und das ItemSet am ROOT Anker
	// putten. Vorsichtshalber schalten wir das Filtern auch noch mal ein.
	CntRuleSetItem aItem( WID_RULES );
	aItem.SetRuleSet( aRuleSet );

	pRoot->_bIgnoreFilterdMsg = TRUE;
	pRoot->Put( aItem );
	pRoot->_bIgnoreFilterdMsg = FALSE;
}

//---------------------------------------------------------------------------
void CntAnchor::ApplyOneRule( const CntNodeRule& rRule )

/*      [Beschreibung]

	Diese Funktion prueft fuer alle Kinder eines Ankers, ob es sich um eine
	Nachricht handelt und wenn ja, ob diese Nachricht durch die uebergebene
	Regel rausgefiltert werden soll.

    Letzte Aenderung  DV 23.02.97
*/
{
	ULONG      nIndex = 0;
	CntAnchor *pChild = GetSubAnchor( nIndex );

	while ( pChild )
	{
		if ( pChild->_bIsDocument )
		{
			CntNodeAction   eAction;
			BOOL            bDelChild;
			ULONG           nCount = pChild->SubAnchorCount();

			if ( pChild->GetNode() )
			{
				eAction = rRule.queryAction(*pChild->GetNode(),
											CntRootNodeMgr::GetIniManager()->
                                             getIntlWrapper(),
											0);
				bDelChild = CNT_NODE_ACTION_HIDE == eAction;
			}
			else
				bDelChild = TRUE;

			if ( nCount )
			{
				pChild->ApplyOneRule( rRule );
				nCount = pChild->SubAnchorCount();
			}
			if ( bDelChild && ( nCount == 1 ) )
			{
				CntAnchor *pChildChild = pChild->GetSubAnchor( 0 );
				pChildChild->ChangeParent( this );
				nCount = 0;
			}
			if ( bDelChild && ( nCount == 0 ) )
				RemoveSubAnchor( pChild );
			else
				nIndex++;
		}
		else
			nIndex++;
		pChild = GetSubAnchor( nIndex );
	}
}

//---------------------------------------------------------------------------
BOOL CntAnchor::FilterOldMsgs( CntNode *pChildNode )

/*      [Beschreibung]


    Letzte Aenderung  DV 28.04.97
*/
{
	BOOL     bShowNode = TRUE;
	DateTime aCurDate;
	DateTime aNodeDate = ((const SfxDateTimeItem&)(pChildNode->Get( WID_DATE_CREATED )))
						.GetDateTime();
	USHORT   nTimeLimit = ((const CntUInt16Item&) Get( WID_SHOW_MSGS_TIMELIMIT )).GetValue();

	aCurDate -= (long)nTimeLimit;

	if ( aNodeDate < aCurDate )
		bShowNode = FALSE;

	return bShowNode;
}

//---------------------------------------------------------------------------
BOOL CntAnchor::ApplyRules( CntAnchor *pNewAnchor, BOOL &bChecked )

/*      [Beschreibung]

    Diese Funktion prueft, ob an diesem Anker Regeln ausgefuehrt werden sollen.
    Wenn die Regeln ausgewertet werden sollen, dann wird zuerst der Root Anker
    und anschliessend dieser Anker nach den Regeln gefragt.
    Es werden nur Messages auf Regeln ueberprueft.
    Der Rueckgabewert gibt an, ob dieser Knoten noch gethreadet werden soll.

    Letzte Aenderung  DV 06.05.97
*/
{
	BOOL bShowIt = TRUE;

	bChecked = FALSE;

	if ( ((const CntBoolItem &) Get( WID_FILTERED )).GetValue() )
	{
		if ( !_pOpenData )
			_pOpenData = new ImplOpenData( this, FALSE );

		CntAnchorRef xParent = _pOpenData->GetRoot();

		if ( _bHasRules || ( xParent.Is() && xParent->_bHasRules ) )
		{
			CntNodeActionSet	aOwnActionSet;
			CntNodeActionSet	aActionSet;
			ULONG				nActions;
			USHORT				i;
			USHORT              nDefaultAction = CNT_NODE_ACTION_SHOW;
			bool                bNeitherNor = true;
			BOOL                bRet;
			BOOL				bHandleFolder, bParentHandleFolder;

			bParentHandleFolder = FALSE;

			// Wenn es eine Root gibt und bei der Root die Regeln eingeschaltet sind,
			// dann wird die Root nach ihren Regeln befragt
			if ( xParent.Is() && ((const CntBoolItem &) xParent->Get( WID_FILTERED )).GetValue() )
			{
				const CntNodeRuleSet &rParentRules = ((const CntRuleSetItem &)
															xParent->Get( WID_RULES )).GetRuleSet();
				bParentHandleFolder = rParentRules.GetHandleFolder();

				if ( rParentRules.RuleCount() == 0 )
					xParent->_bHasRules = FALSE;
				else
				{
					if ( bParentHandleFolder || pNewAnchor->_bIsDocument )
					{
						rParentRules.execute(*pNewAnchor, aActionSet,
											 CntRootNodeMgr::GetIniManager()->
                                              getIntlWrapper(),
											 0);
						nDefaultAction = rParentRules.GetDefaultAction( bNeitherNor );
					}
				}
			}
			else if ( xParent.Is() )
				xParent->_bHasRules = FALSE;

			SfxItemState eState = GetItemState( WID_RULES );
			if ( eState & SFX_ITEM_DISABLED )
			{
				_bHasRules = FALSE;
				return bShowIt;
			}

			const CntNodeRuleSet &rRules = ((const CntRuleSetItem &)Get( WID_RULES )).GetRuleSet();
			bHandleFolder = rRules.GetHandleFolder();

			if ( !bHandleFolder && !bParentHandleFolder &&
				 ITEMSET_VALUE( pNewAnchor, CntBoolItem, WID_FLAG_IS_FOLDER ) )
				return bShowIt;

			if ( rRules.RuleCount() == 0 )
				_bHasRules = FALSE;
			else
				rRules.execute(*pNewAnchor, aOwnActionSet,
							   CntRootNodeMgr::GetIniManager()->
                                getIntlWrapper(),
							   0);

			if ( bNeitherNor )
				nDefaultAction = rRules.GetDefaultAction( bNeitherNor );

			nActions = aOwnActionSet.Count();
			if ( nActions )
			{
				for ( i=0; i<nActions; i++ )
					aActionSet.Insert( aOwnActionSet.Get( i ), TRUE );
			}

			if ( nDefaultAction == CNT_NODE_ACTION_SHOW )
				bShowIt = TRUE;
			else
				bShowIt = FALSE;

			bChecked = !bNeitherNor;

			nActions = aActionSet.Count();

			for ( i=0; i<nActions; i++ )
			{
				CntSaverAction	  eSaverAction;
				const CntNodeActionRec * pAction = aActionSet.Get(i);
				CntNodeAction	  eAction = pAction->GetAction();
				BOOL			  bHasSaverAction = FALSE;

				switch ( eAction ) {
					case CNT_NODE_ACTION_NONE:
							break;
					case CNT_NODE_ACTION_SHOW:
							bShowIt = TRUE;
							break;
					case CNT_NODE_ACTION_HIDE:
							if ( nDefaultAction == CNT_NODE_ACTION_SHOW )
								bShowIt = FALSE;
							break;
					case CNT_NODE_ACTION_MARK:
					case CNT_NODE_ACTION_UNMARK:
					case CNT_NODE_ACTION_MARKREAD:
					case CNT_NODE_ACTION_MARKUNREAD:
							bRet = HandleAction( eAction, pNewAnchor );
							if ( bNeitherNor )
								if ( !bChecked )
									bShowIt = bRet;
								else
									bShowIt |= bRet;
							bChecked = TRUE;
							break;

					case CNT_NODE_ACTION_COPY:
							eSaverAction = CNT_ACTION_COPY;
							bHasSaverAction = TRUE;
							break;

					case CNT_NODE_ACTION_MOVE:
                            eSaverAction = CNT_ACTION_MOVE;
                            bShowIt = FALSE;
							bHasSaverAction = TRUE;
							break;

					case CNT_NODE_ACTION_LINK:
							eSaverAction = CNT_ACTION_LINK;
							bHasSaverAction = TRUE;
							break;

					case CNT_NODE_ACTION_DELETE:
                            eSaverAction = CNT_ACTION_DELETE;
                            bShowIt = FALSE;
                            bHasSaverAction = TRUE;
							break;

					case CNT_NODE_ACTION_FORWARD:
							eSaverAction = CNT_ACTION_FORWARD;
							bHasSaverAction = TRUE;
							break;

					default:
							bShowIt = TRUE;
							DBG_ERRORFILE( "Unknown Action" );
							break;
				}
				if ( bHasSaverAction )
				{
					BOOL bBroadcast = TRUE;

					if ( eSaverAction != CNT_ACTION_DELETE )
					{
						pNewAnchor->Put( SfxVoidItem( WID_GETDATA ) );
						const CntActionListItem &rItem = (const CntActionListItem &)
															pNewAnchor->Get( WID_ACTION_LIST );

						bBroadcast = ! rItem.Check( eAction, pAction->GetParameter() );
					}

					if ( bBroadcast )
						Broadcast( CntAnchorSaverHint( pNewAnchor, eSaverAction,
													   pAction->GetParameter() ) );
				}
			}
		}
	}

	return bShowIt;
}

//---------------------------------------------------------------------------
BOOL CntAnchor::HandleAction( CntNodeAction eAction, CntAnchor *pNewAnchor )

/*      [Beschreibung]

    Schickt eine Action an den Node.

    Letzte Aenderung  DV 01.08.97
*/
{
	USHORT  nWID, nViewWID;
	BOOL    bValue  = TRUE;

	switch ( eAction )
	{
		case CNT_NODE_ACTION_MARK:
				nWID = WID_IS_MARKED;
				break;
		case CNT_NODE_ACTION_UNMARK:
				nWID = WID_IS_MARKED;
				bValue = FALSE;
				break;
		case CNT_NODE_ACTION_MARKREAD:
				nWID = WID_IS_READ;
				break;
		case CNT_NODE_ACTION_MARKUNREAD:
				nWID = WID_IS_READ;
				bValue = FALSE;
				break;
		default:
				DBG_ERRORFILE( "Unsupported Action" );
				return TRUE;
	}

	CntBoolItem aItem( nWID, bValue );

	// beim referenzierten Node als Job enqueuen (ggf. synch exec)
	pNewAnchor->GetNode()->InsertJob(
								new CntNodeJob( 0, this, pNewAnchor->GetNode(), aItem ) );

	BOOL            bNegate, bShowIt;
	BOOL            bUseOr = FALSE;
	BOOL            bTwoItems = FALSE;
	SfxPoolItem     *pCompareItem;

	bNegate = GetViewProperties( pNewAnchor, nViewWID, bTwoItems, bUseOr, &pCompareItem );

	if ( nViewWID == 0 )
	{
		// nViewWID == 0 heisst alles anzeigen
		bShowIt = TRUE;
	}
	else
	{
		if ( nWID == nViewWID )
		{
			bShowIt = ( *pCompareItem == aItem );
			if ( bNegate )
				bShowIt = ! bShowIt;
		}
		if ( bTwoItems && ( bShowIt != bUseOr ) )
		{
			delete pCompareItem;
			bNegate = GetViewProperties( pNewAnchor, nViewWID, bTwoItems, bUseOr, &pCompareItem );

			if ( nWID == nViewWID )
			{
				bShowIt = ( *pCompareItem == aItem );
				if ( bNegate )
					bShowIt = ! bShowIt;
			}
		}
	}
	delete pCompareItem;
	return bShowIt;
}

//---------------------------------------------------------------------------
BOOL CntAnchor::GetViewProperties( const CntAnchor *pNewAnchor, USHORT &rWID,
								   BOOL &rTwoItems, BOOL &rUseOr,
								   SfxPoolItem **pCompare )
{
	ULONG   nValue;
	BOOL    bValue;
	BOOL    bNegate = FALSE;
	BOOL    bIsUInt = FALSE;
	BOOL    bIsMessage = pNewAnchor->_bIsDocument;

	rWID = 0;

	if ( bIsMessage )
	{
		if ( GetItemState( WID_MESSAGEVIEW_MODE ) > SFX_ITEM_DISABLED )
		{
			CntMsgViewMode eMsgView;
			eMsgView = (CntMsgViewMode)((const CntMsgViewModeItem &)Get( WID_MESSAGEVIEW_MODE )).GetValue();

			switch ( eMsgView ) {
				case CNT_VIEW_ALL_ARTICLES:
						// rWID = 0; ist default!
						break;
				case CNT_VIEW_UNREAD_ARTICLES:
						rWID = WID_IS_READ;
						bValue = FALSE;
						break;
				case CNT_VIEW_READ_ARTICLES:
						rWID = WID_IS_READ;
						bValue = TRUE;
						break;
				case CNT_VIEW_MARKED_ARTICLES:
						rWID = WID_IS_MARKED;
						bValue = TRUE;
						break;
				case CNT_VIEW_MARKED_AND_UNREAD_ARTICLES:
					if ( ! rTwoItems )
					{
						rUseOr = TRUE;
						rTwoItems = TRUE;
						rWID = WID_IS_READ;
						bValue = FALSE;
					}
					else
					{
						rWID = WID_IS_MARKED;
						bValue = TRUE;
					}
					break;
				default:
						// rWID = 0; ist default!
						DBG_ERRORFILE( "Unknown CntMsgViewMode" );
						break;
			}
		}
		else
		{
			if ( GetItemState( WID_FOLDERVIEW_MODE ) > SFX_ITEM_DISABLED )
			{
				CntSentMsgViewMode eSentMsgView;
				eSentMsgView = (CntSentMsgViewMode)((const CntSentMsgViewModeItem &)Get( WID_SENTMESSAGEVIEW_MODE )).GetValue();

				switch ( eSentMsgView ) {
					case CNT_SENT_VIEW_ALL_ARTICLES:
							// rWID = 0; ist default!
							break;
					case CNT_SENT_VIEW_SENT_ARTICLES:
							rWID = WID_OUTMSGINTERNALSTATE;
							bValue = TRUE;
							break;
					case CNT_SENT_VIEW_UNSENT_ARTICLES:
							rWID = WID_OUTMSGINTERNALSTATE;
							bValue = FALSE;
							break;
					case CNT_SENT_VIEW_MARKED_ARTICLES:
							rWID = WID_IS_MARKED;
							bValue = TRUE;
							break;
					default:
							// rWID = 0; ist default!
							DBG_ERRORFILE( "Unknown CntSentMsgViewMode" );
							break;
				}
			}
		}
	}
	else
	{
		if ( GetItemState( WID_FOLDERVIEW_MODE ) > SFX_ITEM_DISABLED )
		{
			CntFolderViewMode eFldView;
			eFldView = (CntFolderViewMode)
				((const CntFolderViewModeItem &)
				 Get( WID_FOLDERVIEW_MODE )).GetValue();
			switch ( eFldView ) {
				case CNT_VIEW_ALL_FOLDERS:
					// rWID = 0; ist default!
					break;
				case CNT_VIEW_SUBSCRIBED_FOLDERS:
					rWID = WID_FLAG_SUBSCRIBED;
					bValue = TRUE;
					break;
				case CNT_VIEW_ACTIVE_FOLDERS:
					if ( ! rTwoItems )
					{
						rTwoItems = TRUE;
						rWID = WID_FLAG_SUBSCRIBED;
						bValue = TRUE;
					}
					else
					{
						rWID = WID_UNREAD_ARTICLECOUNT;
						nValue = 0;
						bIsUInt = TRUE;
						bNegate = TRUE;
					}
					break;
				case CNT_VIEW_NEW_FOLDERS:
					// rWID = 0; ist default!
					break;
				default:
					// rWID = 0; ist default!
					DBG_ERRORFILE( "Unknown CntFolderViewMode" );
					break;
			}
		}
	}

	if ( rWID )
		if ( bIsUInt )
			*pCompare = (SfxPoolItem*) new CntUInt32Item( rWID, nValue );
		else
			*pCompare = (SfxPoolItem*) new CntBoolItem( rWID, bValue );
	else
		*pCompare = NULL;

	return bNegate;
}

//---------------------------------------------------------------------------
BOOL CntAnchor::CheckViewMode( CntAnchor *pNewAnchor )

/*      [Beschreibung]


    Letzte Aenderung  DV 06.05.97
*/
{
	SfxPoolItem     *pCompareItem;
	USHORT          nViewWID;
	BOOL            bNegate;
	BOOL            bShowIt = TRUE;
	BOOL            bUseOr = FALSE;
	BOOL            bTwoItems = FALSE;

	bNegate = GetViewProperties( pNewAnchor, nViewWID, bTwoItems, bUseOr, &pCompareItem );
	bShowIt = Cnt_CompareItems( nViewWID, pNewAnchor, pCompareItem );

	if ( bNegate )
		bShowIt = ! bShowIt;

	if ( bTwoItems && ( bShowIt != bUseOr ) )
	{
		delete pCompareItem;
		bNegate = GetViewProperties( pNewAnchor, nViewWID, bTwoItems, bUseOr, &pCompareItem );
		bShowIt = Cnt_CompareItems( nViewWID, pNewAnchor, pCompareItem );
		if ( bNegate )
			bShowIt = ! bShowIt;
	}

	delete pCompareItem;

	return bShowIt;
}

//---------------------------------------------------------------------------
void CntAnchor::ChangeParent( CntAnchor *pNewParent, CntAnchor *pThreader )

/*      [Beschreibung]

    Setzt den Parent um.

    Letzte Aenderung  DV 10.03.97
*/
{
	CntAnchor      *pOldParent = GetParent();
	CntAnchorRef    xAnchor = this;

	if ( pOldParent != pNewParent )
	{
		BOOL bWasExpanded = _bIsExpanded;
		DBG_ASSERT( this != pNewParent, "Kann nicht mich selbst als Parent eintragen" );

		if ( bWasExpanded )
			Collapse();

		pOldParent->RemoveSubAnchor( this );
		pNewParent->InsertSubAnchor( this, pThreader, NULL );

		if ( bWasExpanded )
			Expand();
	}
}

//---------------------------------------------------------------------------
void CntAnchor::CopyChildren( CntAnchor *pOldParent )

/*      [Beschreibung]

    Diese Funktion kopiert die Kinder vom Anker pOldParent zu diesem Anker.

    Letzte Aenderung  DV 20.02.97
*/
{
	CntAnchor  *pChild = pOldParent->GetSubAnchor( 0 );
	CntAnchor  *pThreader = GetTParent();

	while ( pChild )
	{
		CntAnchorRef xAnchor = pChild;

		pOldParent->RemoveSubAnchor( pChild );
		InsertSubAnchor( pChild, pThreader, NULL );

		pChild = pOldParent->GetSubAnchor( 0 );
	}
}

//---------------------------------------------------------------------------
BOOL CntAnchor::DeleteChildren( CntItemListItem* pListItem )

/*      [Beschreibung]

    Diese Funktion loescht alle Kinder vom Anker, wenn ... .

    Letzte Aenderung  DV 12.03.97
*/
{
	USHORT          nItems = 0;
	BOOL            bAllOtherKind = TRUE;
	BOOL            bDelMsg;
	if( (pListItem->Which() == WID_MESSAGEVIEW_MODE) ||
		(pListItem->Which() == WID_SENTMESSAGEVIEW_MODE) )
		bDelMsg = TRUE;
	else
		bDelMsg = FALSE;

	for ( nItems=0; nItems < pListItem->Count(); nItems++ )
	{
		const SfxPoolItem &nItem = (*pListItem)[ nItems ];
		USHORT          nWID = nItem.Which();
		ULONG           nIndex = 0;
		CntAnchor      *pChild = GetSubAnchor( nIndex );

		while ( pChild )
		{
			if ( bDelMsg == pChild->_bIsDocument )
			{
				BOOL   bDelChild;
				ULONG  nCount = pChild->SubAnchorCount();

				if ( pChild->GetNode() )
				{
					bDelChild = (pChild->Get( nWID ) == nItem);
				}
				else
					bDelChild = TRUE;

				if ( nCount )
				{
					bAllOtherKind = pChild->DeleteChildren( pListItem );
					nCount = pChild->SubAnchorCount();
				}
				if ( bDelChild && ( nCount == 1 ) )
				{
					CntAnchor *pChildChild = pChild->GetSubAnchor( 0 );
					pChildChild->ChangeParent( this );
					nCount = 0;
				}
				if ( bDelChild && ( ( nCount == 0 ) || bAllOtherKind ) )
					RemoveSubAnchor( pChild );
				else
				{
					nIndex++;
					bAllOtherKind = FALSE;
				}
			}
			else
				nIndex++;
			pChild = GetSubAnchor( nIndex );
		}
	}

	return bAllOtherKind;
}

//---------------------------------------------------------------------------
void CntAnchor::DeleteAllChildren( BOOL bDelMsg )

/*      [Beschreibung]

    Diese Funktion loescht alle Kinder vom Anker, wenn ... .

    Letzte Aenderung  DV 25.02.97
*/
{
	if ( ( ( bDelMsg && !_bShowFolders ) ||
		   ( !bDelMsg && !_bShowDocuments ) ) &&
		 IsExpanded() && _bIsVisible )
	{
		BOOL bOld = _bIsVisible;
		RemoveSubAnchors( TRUE );
		_bIsVisible = TRUE;
	}
	else
	{
		ULONG       nIndex = 0;
		CntAnchor  *pChild = GetSubAnchor( nIndex );

		while ( pChild )
		{
			BOOL bChildIsDoc = ! ITEMSET_VALUE( pChild, CntBoolItem, WID_FLAG_IS_FOLDER );

//			if ( bDelMsg == pChild->_bIsDocument )
			if ( bDelMsg == bChildIsDoc )
			{
				if ( pChild->SubAnchorCount() )
					pChild->DeleteAllChildren( bDelMsg );

				RemoveSubAnchor( pChild );
			}
			else
				nIndex++;
			pChild = GetSubAnchor( nIndex );
		}
	}
}

//---------------------------------------------------------------------------
CntSeenStatus CntAnchor::GetSeenStatus() const
{
	// Der Seen-Status wird nur fuer Msgs verwaltet
	if ( ! _bIsDocument )
		return CNT_NONE_SEEN;

	CntSeenStatus eStatus;

	// Wenn wir selber ein Knoten sind ( und kein virtueller Anker ) dann haengt
	// unser Status von uns und unseren Kindern ab ( wenn wir denn welche haben )
	if ( GetNode() )
	{
		SfxItemState eState = GetItemState( WID_IS_READ );
		if ( eState & SFX_ITEM_DISABLED )
			return CNT_NONE_SEEN;

		BOOL bSeen = ((const CntBoolItem &) Get( WID_IS_READ )).GetValue();

		if ( SubAnchorCount() )
		{
			if ( bSeen )
				if ( _nSeenCount == ( SubAnchorCount() * 2 ) )
					eStatus = CNT_ALL_SEEN;
				else
					eStatus = CNT_SOME_SEEN;
			else
				if ( ! _nSeenCount )
					eStatus = CNT_NONE_SEEN;
				else
					eStatus = CNT_SOME_SEEN;
		}
		else if ( bSeen )
			eStatus = CNT_ALL_SEEN;
		else
			eStatus = CNT_NONE_SEEN;
	}
	else
	{
		if ( SubAnchorCount() && ( _nSeenCount == ( SubAnchorCount() * 2 ) ) )
			eStatus = CNT_ALL_SEEN;
		else if ( _nSeenCount )
			eStatus = CNT_SOME_SEEN;
		else
			eStatus = CNT_NONE_SEEN;
	}

	return eStatus;
}
//---------------------------------------------------------------------------
void CntAnchor::CheckSeenStatus( BOOL bForceUpdate )

/*      [Beschreibung]

    Diese Funktion ueberprueft, ob Ordner auf gelesen oder ungelesen zu setzen
    sind.

    Letzte Aenderung  DV 21.04.97
*/
{
	// Der Seen-Status wird nur fuer Msgs verwaltet
	if ( ! _bIsDocument )
		return;

	CntSeenStatus eNewStatus;
	CntSeenStatus eOldStatus;

	eNewStatus = GetSeenStatus();
	eOldStatus = (CntSeenStatus) ((const CntSeenStatusItem &) Get( WID_SEEN_STATUS )).GetValue();

	// Wenn sich der Status geaendert hat, dann aendert sich evtl auch der Status
	// des Vaters.
	if ( eOldStatus != eNewStatus )
	{
		CntInterface::Put( CntSeenStatusItem( WID_SEEN_STATUS, eNewStatus ), WID_SEEN_STATUS );
		bForceUpdate = TRUE;
	}

	if ( bForceUpdate )
	{
		// Bei PseudoParents aendert sich nicht das Icon sondern nur die Schreibweise
		if ( !GetNode() )
		{
			if ( eNewStatus == CNT_ALL_SEEN )
				CntInterface::Put( CntBoolItem( WID_IS_READ, TRUE ), WID_IS_READ );
			else
				CntInterface::Put( CntBoolItem( WID_IS_READ, FALSE ), WID_IS_READ );
		}

		CntAnchor *pParent = GetParent();
		if ( pParent && ( pParent != GetThreader() ) )
		{
			short nSeenCount = 0;

			if ( eNewStatus == CNT_ALL_SEEN )
				nSeenCount = 2;
			else if ( eNewStatus == CNT_SOME_SEEN )
				nSeenCount = 1;

			// Wenn sich der Status nicht geaendert hat, dann kam das bForceUpdate
			// von einem InsertAnchor und wir duerfen den alten Status nicht beachten
			if ( eOldStatus != eNewStatus )
			{
				if ( eOldStatus == CNT_ALL_SEEN )
					nSeenCount -= 2;
				else if ( eOldStatus == CNT_SOME_SEEN )
					nSeenCount -= 1;
			}

			pParent->_nSeenCount += nSeenCount;
			pParent->CheckSeenStatus();
		}
	}
}

//---------------------------------------------------------------------------
int CntAnchor::Compare( const CntAnchor *pAnchor, BOOL bPtrs ) const

/*      [Beschreibung]

    Diese Funktion prueft, ob pAnchor kleiner als dieses Objekt ist.
    Wenn pAnchor kleiner ist, dann wird ein negativer Wert zurueckgegeben,
    sind die beiden Objekte gleich, dann wird Null zurueckgegeben, ansonsten
    ein positiver Wert
?????  ( oder umgekehrt ??? )
    Letzte Aenderung  DV 14.07.98
*/
{
	const CntAnchor *pParent;
	USHORT			 nSortingWID;
	int				 nRetVal = 0;
	BOOL			 bAscending;

	if ( this == pAnchor )
		return 0;

	pParent = GetTParent();

	if ( !pParent )
		return 0;

	if ( pParent->GetFolderFirst() )
	{
		BOOL bLower;
		BOOL bUpper;

		if ( GetChangedItem() &&
			 ( GetChangedItem()->Which() == WID_FLAG_IS_FOLDER ) )
			bLower = ((const CntBoolItem*) GetChangedItem())->GetValue();
		else
			bLower = THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_IS_FOLDER );

		if ( pAnchor->GetChangedItem() &&
				  ( pAnchor->GetChangedItem()->Which() == WID_FLAG_IS_FOLDER ) )
			bUpper = ((const CntBoolItem*) pAnchor->GetChangedItem())->GetValue();
		else
			bUpper = ITEMSET_VALUE( pAnchor, CntBoolItem, WID_FLAG_IS_FOLDER );

		if ( bLower != bUpper )
		{
			if ( bLower )
				nRetVal = -1;
			else
				nRetVal = 1;
			return nRetVal;
		}
	}

	pParent = pParent->GetSortParent();

	const SfxPoolItem &rTmp = pParent->Get( WID_SORTING );

	if ( ! rTmp.ISA( CntSortingItem ) )
	{
		if ( _nSortingInfo < pAnchor->_nSortingInfo )
			return -1;
		else
			return 1;
	}

	const CntSortingItem &rItem = (const CntSortingItem &) rTmp;
	USHORT               nSortitems = rItem.Count();

	if ( nSortitems == 0 )
	{
		if ( _nSortingInfo < pAnchor->_nSortingInfo )
			nRetVal = -1;
		else
			nRetVal = 1;
	}

    const IntlWrapper& rIntlWrapper = CNT_RNM()->GetIniManager()->getIntlWrapper();

	for ( USHORT i=0; i < nSortitems; i++ )
	{
		const CntSortingInfo& rInfo = rItem[ i ];
		nSortingWID = rInfo.GetSortingWID();
		bAscending = rInfo.GetAscending();

		const SfxPoolItem* pLower = &(const SfxPoolItem&) Get( nSortingWID );
		const SfxPoolItem* pUpper = &(const SfxPoolItem&) pAnchor->Get( nSortingWID );

		if ( GetChangedItem() &&
			 ( GetChangedItem()->Which() == pLower->Which() ) )
			pLower = (const SfxPoolItem*) GetChangedItem();
		else if ( pAnchor->GetChangedItem() &&
				  ( pAnchor->GetChangedItem()->Which() == pUpper->Which() ) )
			pUpper = (const SfxPoolItem*) pAnchor->GetChangedItem();

		if ( pLower->Which() == pUpper->Which() )
            nRetVal = pUpper->Compare( *pLower, rIntlWrapper );

		if ( ! bAscending )
			nRetVal = - nRetVal;

		if ( nRetVal )
			break;
	}

	if ( bPtrs && !nRetVal )
		if ( this < pAnchor )
			nRetVal = -1;
		else
			nRetVal = 1;

	return nRetVal;
}

//---------------------------------------------------------------------------
void CntAnchor::RemoveFromLists()

/*      [Beschreibung]

	Diese Funktion entfernt einen Anker aus allen Threading Listen.
    Letzte Aenderung  DV 21.04.97
*/
{
	CntAnchor       *pRoot = GetTParent();
	CntThreadList   *pList;

	if ( !pRoot || !pRoot->_pCntThreadData )
		return;

	for ( int i = 0; i < THREADITEM_ANZ; i++ )
	{
		pList = pRoot->_pCntThreadData->pItemLists[ i ];

		if ( pList )
		{
			ULONG         nPos;
			ItemListData *pData;
			String        aValue = ((const CntStringItem&)Get( pList->GetChildWID() )).GetValue();

			if ( pList->GetType() == CNT_THREADING_BY_PROPVALUE )
				Cnt_CutReply( aValue );

			if ( aValue.Len() )
				pData = pList->FindEntry( aValue, nPos );
			else
				pData = pList->FindAnchor( this );

			if ( pData && ( pData->pAnchor == this ) )
			{
				if ( ! pData->pChild )
				{
					// Wenn wir keine Kinder haben, dann koennen wir den Eintrag
					// aus der Liste entfernen
					nPos = LIST_ENTRY_NOTFOUND;
					ItemListData *pTemp = (ItemListData*) pList->First();
					while ( pTemp )
					{
						if ( pTemp->pParent == pData )
							pTemp->pParent = pData->pParent;
						if ( pTemp->pChild == pData )
							pTemp->pChild = NULL;
						if ( pTemp == pData )
							nPos = pList->GetCurPos();
						pTemp = (ItemListData*) pList->Next();
					}
					if ( nPos != LIST_ENTRY_NOTFOUND )
						pList->Remove( nPos );
					else
						pList->Remove( (void*) pData );
					delete pData;
				}
				else
				{
					// Wenn man versucht, den Eintrag zu loeschen, gibt es Probleme, da es
					// nur einen Zeiger auf ein Kind gibt, aber durchaus mehrere Kinder auf
					// diesen Eintrag zeigen koennen. Durch das Loeschen hat man dann
					// ungueltige Zeiger.
					pData->bIsVirtual = FALSE;
					pData->bIsReal = FALSE;
					pData->bIsCopy = FALSE;
					pData->pAnchor = NULL;
				}
			}
		}
	}
}

//----------------------------------------------------------------------------
void CntAnchor::HandleUnsubscribe()
{
	CntAnchor  *pRoot = GetTParent();

	CntFolderViewMode eFldView;
	eFldView = (CntFolderViewMode)((const CntFolderViewModeItem &)pRoot->Get( WID_FOLDERVIEW_MODE )).GetValue();

	if ( eFldView == CNT_VIEW_ALL_FOLDERS )
		return;

	BOOL		 bIsSubscribed = THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_SUBSCRIBED );
	CntAnchor	*pParent = GetParent();

	if ( bIsSubscribed || !pParent )
		return;

	if ( SubAnchorCount() )
	{
		ULONG nCount = SubAnchorCount();
		CntAnchor *pChild;

		if ( nCount == 1 )
		{
			pChild = GetSubAnchor( 0 );
			pChild->ChangeParent( pParent, pRoot );
		}
		else
		{
			String	aTitle( THIS_ITEM_VALUE( CntStringItem, WID_TITLE ) );
			BOOL	bWasExpanded = IsExpanded();
			CntAnchor *pNewParent = new CntAnchor( pParent, NULL );

			if ( bWasExpanded )
				Collapse();

			pNewParent->SetRanges( aVirtualMsgFolderRanges_Impl );
			pNewParent->Put( CntStringItem( WID_TITLE, aTitle ) );
			pNewParent->Put( CntBoolItem( WID_FLAG_IS_FOLDER, TRUE ) );
			pNewParent->Put( CntBoolItem( WID_FLAG_HAS_FOLDER, TRUE ) );
			pNewParent->AddRef();
			pNewParent->_bNeedRelease = TRUE;
			pNewParent->_bUsesNewView = TRUE;

			SfxItemState eState = GetItemState( WID_DELETE, TRUE );
			if( eState <= SFX_ITEM_DISABLED )
				pNewParent->DisableItem( WID_DELETE );

			pParent->InsertSubAnchor( pNewParent, NULL, NULL );
			pChild = GetSubAnchor( 0 );
			while ( pChild )
			{
				pChild->ChangeParent( pNewParent, pRoot );
				pChild = GetSubAnchor( 0 );
			}

			if ( bWasExpanded )
				pNewParent->Expand();
		}
	}
	else
	{
		// Wenn wir einen Pseudoparent haben und das letzte Kind von diesem
		// Parent sind, dann muessen wir nach dem loeschen noch aufraeumen.
		if ( pParent->SubAnchorCount() == 1 )
			_bCleanupParents = TRUE;
	}
	RemoveFromLists();
}

//---------------------------------------------------------------------------
CntAnchor* CntAnchor::GetTParent() const
{
	CntAnchor *pParent = GetParent();
	CntAnchor *pThreader = GetThreader();

	// sometimes an anchor has an already destroyed threading parent.
	// In that case we won't reach the parent via the parent chain.
	if ( pThreader )
	{
		while ( pParent && ( pParent != pThreader ) )
			pParent = pParent->GetParent();
	}

	return pParent;
}

//---------------------------------------------------------------------------
void chaos::Cnt_CutReply( String& rStr )
/*      [Beschreibung]

    Schneidet aus dem String rStr 'Re:' etc. raus.

    Letzte Aenderung  DV 23.02.97
*/
{
	BOOL bReply;
	do
	{
		bReply = FALSE;
		if( rStr.Len() < 3 )
			return;

		xub_StrLen i;
		sal_Unicode cCh  = rStr.GetChar( 0 );
		if( cCh == 'R' || cCh == 'r' )
		{
			cCh  = rStr.GetChar( 1 );
			if( cCh == 'e' || cCh == 'E' )
			{
				cCh  = rStr.GetChar( 2 );
				if( cCh == ':' )                                                 // "Re:" raus
				{
					rStr.Erase( 0, 3 );
					rStr.EraseLeadingChars( ' ' );
					bReply = TRUE;
				}
				else if( cCh == '^' && rStr.Len() >= 5)  // "Re^4:" raus
				{
					i = 3;
					while ( isdigit( rStr.GetChar(i) ) && ( i < (rStr.Len() - 1) ) )
						i++;
					if( rStr.GetChar(i) == ':' )
					{
						rStr.Erase( 0, i+1 );
						rStr.EraseLeadingChars( ' ' );
						bReply = TRUE;
					}
				}
				else if( cCh == '[' && rStr.Len() >= 6 ) // "Re[4]:" raus
				{
					i = 3;
					while ( isdigit( rStr.GetChar(i) ) && ( i < (rStr.Len() - 2) ) )
						i++;
					if( ( rStr.GetChar(i) == ']' ) && ( rStr.GetChar(i+1) == ':' ) )
					{
						rStr.Erase( 0, i+2 );
						rStr.EraseLeadingChars( ' ' );
						bReply = TRUE;
					}
				}
			}
		}
		else
		{
			BOOL bHadBracket = FALSE;

			if( rStr.Len() < 4 )
				return;

			if ( cCh == '[' )
			{
				if( rStr.Len() < 5 )
					return;
				bHadBracket = TRUE;
				rStr.Erase( 0, 1 );
				cCh  = rStr.GetChar( 0 );
			}

			if( cCh == 'F' || cCh == 'f' )
			{
				cCh  = rStr.GetChar( 1 );
				if( cCh == 'w' || cCh == 'W' )
				{
					cCh  = rStr.GetChar( 2 );
					if( cCh == 'd' || cCh == 'D' )
					{
						cCh  = rStr.GetChar( 3 );
						if( cCh == ':' )                                         // "Fwd:" raus
						{
							rStr.Erase( 0, 4 );
							rStr.EraseLeadingChars( ' ' );
							bReply = TRUE;
						}
					}
				}
			}
			if ( bHadBracket && bReply && ( ']' == rStr.GetChar( rStr.Len() - 1 ) ) )
				rStr.Erase( rStr.Len() - 1, 1 );
			else if ( bHadBracket && ! bReply )
				rStr.Insert( '[', 0 );
		}
	} while( bReply );
}

//---------------------------------------------------------------------------
static
BOOL Cnt_CompareItems( USHORT nWID, const CntAnchor *pAnchor, const SfxPoolItem *pCompare )
{
	BOOL bEqual = TRUE;

	if ( nWID == WID_SEENCONTENTCOUNT )
	{
		ULONG   nSeen, nTotal, nUnseen;

		nSeen = ((const CntUInt32Item&)pAnchor->Get( WID_SEENCONTENTCOUNT )).GetValue();
		nTotal = ((const CntUInt32Item&)pAnchor->Get( WID_TOTALCONTENTCOUNT )).GetValue();
		nUnseen = nTotal - nSeen;
		bEqual = nUnseen == ((CntUInt32Item*)pCompare)->GetValue();
	}
	else if( nWID == WID_OUTMSGINTERNALSTATE )
	{
		const CntOutMsgInternalStateItem& rItm = (const CntOutMsgInternalStateItem&)
			pAnchor->Get( nWID );
		BOOL bShowSent = ((const CntBoolItem*)pCompare)->GetValue();
		CntOutMsgInternalState eState = (CntOutMsgInternalState)rItm.GetValue();
		switch( eState )
		{
			case CNT_OUTMSG_INTERNALSTATE_WRITTEN:
			case CNT_OUTMSG_INTERNALSTATE_PARTIALLY_LOCALLY_SENT:
			case CNT_OUTMSG_INTERNALSTATE_RECOVERABLE_LOCAL_ERROR:
			case CNT_OUTMSG_INTERNALSTATE_NONRECOVERABLE_LOCAL_ERROR:
			case CNT_OUTMSG_INTERNALSTATE_EXTERNAL_ERROR:
				bEqual = !bShowSent;
				break;

			default:
				bEqual = bShowSent;
		}
	}
	else if ( nWID )
	{
		const SfxPoolItem &rItem = pAnchor->Get( nWID );

		// Pruefen, ob Item uebehaupt gueltig ist ( WhichID != 0 )
		if ( rItem.Which() )
			bEqual = *pCompare == rItem;
		else
			bEqual = FALSE;
	}
	return bEqual;
}

ImplOpenData::ImplOpenData( CntAnchor *pAnchor, BOOL bOpen )
{
	String	aParentURL = pAnchor->GetRootViewURL( TRUE );

	if ( aParentURL.Len() )
		xViewRoot = new CntAnchor( NULL, aParentURL, FALSE );

	if ( bOpen && pAnchor->GetCollectAnchors() )
	{
		xParent	= pAnchor;
		bCollectAnchors = TRUE;
	}
	else
		bCollectAnchors = FALSE;

	pOpenJob	= NULL;
	pChildList	= NULL;
	nTicks		= 0;
	bLocked		= FALSE;
	bFirst		= TRUE;
}

ImplOpenData::~ImplOpenData()
{
	if ( pChildList )
	{
		ProcessList();
		delete pChildList;
	}
}

BOOL ImplOpenData::InsertAnchor( CntAnchor *pNew )
{
	if ( ! bCollectAnchors || bLocked || ! xParent.Is() )
		return FALSE;

	if ( nTicks == 0 )
		if ( bFirst )
		{
			nTicks = Time::GetSystemTicks() + COLLECT_FIRST_WAIT;
			bFirst = FALSE;
		}
		else
			nTicks = Time::GetSystemTicks() + COLLECT_WAIT;

	if ( ! pChildList )
		pChildList = new List( 128, 128 );

	pNew->AddRef();
	pChildList->Insert( (void*) pNew, LIST_APPEND );

	if ( ( bFirst && ( pChildList->Count() > COLLECT_INITIAL ) ) ||
		 ( nTicks < Time::GetSystemTicks() ) )
		ProcessList();

	return TRUE;
}

void ImplOpenData::ProcessList()
{
	if ( bLocked || !pChildList || !xParent.Is() )
		return;
	else
		bLocked = TRUE;

	CntAnchor *pChild = (CntAnchor*) pChildList->First();

	while ( pChild )
	{
		xParent->InsertThreaded( NULL, pChild, NULL );
		pChild->ReleaseRef();
		pChild = (CntAnchor*) pChildList->Next();
	}

	if ( pChildList->Count() )
	{
		CntAnchor *pAbsParent = xParent->GetAbsParent();
		if ( pAbsParent )
			pAbsParent->Broadcast( CntAnchorViewHint( CNT_ACTION_SHOW_SELECTION,
													  0, 0, WID_OPEN ) );
	}

	pChildList->Clear();
	nTicks = 0;
	bLocked = FALSE;
}

BOOL ImplOpenData::CheckOpenData()
{
	if ( bLocked || ! nTicks ||
		 ( nTicks + COLLECT_MAX_WAIT > Time::GetSystemTicks() ) )
		return FALSE;
	else
		return TRUE;
}

