/*************************************************************************
 *
 *  $RCSfile: srchmtch.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UCB_SEARCHCRITERIUM_HPP_
#include <com/sun/star/ucb/SearchCriterium.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif

#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTRULES_HXX
#include <cntrules.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

#ifndef CHAOS_SRCHMTCH_HXX
#include <srchmtch.hxx>
#endif

using namespace com::sun::star::container;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using rtl::OUString;

using namespace chaos;

//============================================================================
struct SearchTerm_Impl
{
	OUString m_sPropertyName;
  	CntNodeRuleTerm * m_pTerm;

  	SearchTerm_Impl(): m_pTerm(0) {}

  	~SearchTerm_Impl() { delete m_pTerm; }
};

//============================================================================
//
//  class PropertyMatcherFactory
//
//============================================================================

PropertyMatcherFactory::PropertyMatcherFactory(
							const Reference< XMultiServiceFactory >& rXSMgr )
: m_xSMgr( rXSMgr )
{
}

//============================================================================
// virtual
PropertyMatcherFactory::~PropertyMatcherFactory()
{
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_3( PropertyMatcherFactory,
				   XTypeProvider,
				   XServiceInfo,
				   XPropertyMatcherFactory );

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_IMPL_3( PropertyMatcherFactory,
				   	  XTypeProvider,
				   	  XServiceInfo,
					  XPropertyMatcherFactory );

//=========================================================================
//
// XServiceInfo methods.
//
//=========================================================================

XSERVICEINFO_IMPL_1( PropertyMatcherFactory,
					 OUString::createFromAscii(
						"com.sun.star.comp.chaos.PropertyMatcherFactory" ),
					 OUString::createFromAscii(
						PROPERTYMATCHER_FACTORY_SERVICE_NAME ) );

//=========================================================================
//
// Service factory implementation.
//
//=========================================================================

SINGLE_SERVICE_FACTORY_IMPL( PropertyMatcherFactory );

//=========================================================================
//
// XPropertyMatcherFactory methods.
//
//=========================================================================

// virtual
Reference< XPropertyMatcher > SAL_CALL
PropertyMatcherFactory::createPropertyMatcher(
							const Sequence< SearchCriterium > &	Criteria )
	throw ( RuntimeException )
{
	return new PropertyMatcher( Criteria );
}

//============================================================================
//
//  class PropertyMatcher
//
//============================================================================

PropertyMatcher::PropertyMatcher(
	    const com::sun::star::uno::Sequence< SearchCriterium > & rTheCriteria):
	m_aCriteria(rTheCriteria.getLength())
{
	for (sal_Int32 i = 0; i < rTheCriteria.getLength(); ++i)
	{
		const com::sun::star::uno::Sequence<
			      com::sun::star::ucb::RuleTerm > &
			rTerms = rTheCriteria[i].Terms;
		m_aCriteria[i].resize(rTerms.getLength());
		for (sal_Int32 j = 0; j < rTerms.getLength(); ++j)
		{
			m_aCriteria[i][j].m_sPropertyName = rTerms[i].Property;
			m_aCriteria[i][j].m_pTerm
				= CntNodeRuleTerm::translate(rTerms[i], 0);

			DBG_ASSERT(m_aCriteria[i][j].m_pTerm != 0,
					   "PropertyMatcher::PropertyMatcher():"
			               " Bad criteria");
		}
	}
}

//============================================================================
// virtual
Any SAL_CALL
PropertyMatcher::queryInterface(const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
				   static_cast< XPropertyMatcher * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
sal_Bool SAL_CALL
PropertyMatcher::matches(const Reference< XCommandProcessor > & rProperties,
						 const Reference< XCommandEnvironment > &
							       rEnvironment)
	throw (com::sun::star::uno::RuntimeException)
{
	DBG_ASSERT(rProperties.is(),
			   "PropertyMatcher::matches(): Bad properties");
	if (!rProperties.is())
		return false;

	Date aReferenceDate;
	for (std::vector< std::vector< SearchTerm_Impl > >::const_iterator
			 aRuleIter = m_aCriteria.begin();
		 aRuleIter != m_aCriteria.end(); ++aRuleIter)
	{
		for (std::vector< SearchTerm_Impl >::const_iterator aTermIter
				 = aRuleIter->begin();
			 aTermIter != aRuleIter->end(); ++aTermIter)
		{
			if (aTermIter->m_pTerm == 0)
				goto no_match;

			Sequence< Property > aProperty(1);
			aProperty[0].Name   = aTermIter->m_sPropertyName;
			aProperty[0].Handle = -1;

			Command aCommand;
			aCommand.Name     = OUString::createFromAscii("getPropertyValues");
			aCommand.Handle   = -1; /* unknown */
			aCommand.Argument <<= aProperty;

			Any aResult;
			try
			{
				aResult = rProperties->execute( aCommand, 0, rEnvironment );
			}
			catch ( CommandAbortedException )
			{
				goto no_match;
			}
			catch ( Exception )
			{
				goto no_match;
			}

			Reference< XRow > xValues;
			if ( !( aResult >>= xValues ) )
				goto no_match;

			Any aValue = xValues->getObject( 1, Reference< XNameAccess>() );
			if ( !aValue.hasValue() )
				goto no_match;

			SfxPoolItem * pItem
				= CntItemPool::Get()->GetDefaultItem(aTermIter->m_pTerm->
													     GetPropertySID()).
				      Clone();
			//@@@ The International should rather be provided by rEnvironment:
			if (!(pItem->PutValue(aValue)
				  && aTermIter->m_pTerm->
				         matches(*pItem,
								 CntRootNodeMgr::GetIniManager()->
                                     getIntlWrapper(),
								 &aReferenceDate)))
			{
				delete pItem;
				goto no_match;
			}

			delete pItem;
		}
		return true;
	no_match:;
	}
	return false;
}

