/*************************************************************************
 *
 *  $RCSfile: imapacnt.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPACNT_HXX
#define CHAOS_IMAPACNT_HXX

#ifndef _INET_IMAPCLNT_HXX
#include <inet/imapclnt.hxx>
#endif

#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif

#ifndef CHAOS_IMAPFLDR_HXX
#include <imapfldr.hxx>
#endif

namespace inet { class INetCoreMailer; }

namespace chaos {

class CntExport;
class CntNodeItem;
class CntIMAPAcntNode;
class CntIMAPMbox;
class CntIMAPMesgNode;

//============================================================================
class CntIMAPAcnt: public CntIMAPFldr, public SfxListener
{
private:
	INetIMAPClientRef m_xClient;
	CntNodeJobList m_aForwardSubJobs;
	CntIMAPMbox * m_pBaseMbox;
	inet::INetCoreMailer * m_pMailer;
	CntItemListItem * m_pMboxNoInferiorsFactoryList;
	sal_uInt32 m_nOpenCount;
	bool m_bHasUserIDAndAuthType;
	bool m_bHasBase;
	bool m_bAddBaseInbox;
	bool m_bCopyBaseData;
	bool m_bClientLocked;
	bool m_bOnline;

	void setBase(CntNodeJob & rJob, String const & rBase);

	void setBaseProperty(USHORT nWhich, SfxPoolItem const * pItem = 0);

	DECL_LINK(unilateralClientCallback, INetIMAPResponse const *);

public:
	TYPEINFO();

	CntIMAPAcnt(CntIMAPAcntNode & rAcntNode);

	virtual ~CntIMAPAcnt();

	CntIMAPAcntNode const & getNode() const;

	CntIMAPAcntNode & getNode();

	void initialize(CntNodeJob & rJob);

	/** Change various parameters of the account (process a WID_PUTDATA job).

		@param rJob A WID_PUTDATA job for the account.
	*/
	void changeData(CntNodeJob & rJob);

	/** Change the account's user ID and/or host and port.

		@param rJob A job for the account.

		@param pUserID A new user ID in IMAP <userid> format, or null (don't
		change user ID).

		@param pHostPort A new host and (optinal) port in IMAP URL <hostport>
		format, or null (don't change host and port).
	*/
	void changeUserIDOrHostPort(CntNodeJob & rJob, String const * pUserID,
								String const * pHostPort) const;

	/** Change the account's base.

		@param rJob  A job for the account.

		@param rBase  A new base in (non-canonic) IMAP <mailbox> format.
	*/
	void changeBase(CntNodeJob & rJob, String const & rBase);

	ErrCode getHostAndPort(String & rHost, sal_uInt16 & rPort) const;

	void getUserIDAndPassword(bool & rHasUserIDAndAuthType, String & rUserID,
							  String & rPassword) const;

	bool hasBase() const { return m_bHasBase; }

	String getBaseFldrURL() const;

	CntNodeRef instantiateBaseMboxNode(CntNodeJob & rJob);

	bool doAddBaseInbox() const { return m_bAddBaseInbox; }

	void storeProperty(SfxPoolItem const & rItem, CntNodeJob & rJob);

	virtual CntStorageNode * getDirNode(CntNodeJob & rJob);

	virtual void changeMboxCounts(CntNodeJob & rJob,
								  CountChange eMboxCountChange,
								  CountChange eSubscribedMboxCountChange);

	inet::INetCoreMailer * getINetMailer();

	inline bool acquireClient();

	void releaseClient() { m_bClientLocked = false; }

	bool initializeClient(bool bToClose);

	INetIMAPClient * getClient() { return m_xClient; }

	Link getUnilateralClientCallback()
	{ return LINK(this, CntIMAPAcnt, unilateralClientCallback); }

	void * getUnilateralClientResponseData() { return this; }

	void setOnline(bool bTheOnline) { m_bOnline = bTheOnline; }

	bool isOnline() const { return m_bOnline; }

	bool checkNextJob(CntNode const & rSubject, USHORT nWhich);

	void addForwardSubJob(CntNodeJob & rJob)
	{ m_aForwardSubJobs.Insert(&rJob, LIST_APPEND); }

	bool removeForwardSubJob(CntNodeJob & rJob)
	{ return m_aForwardSubJobs.Remove(&rJob) != 0; }

	CntNodeItem const * createNewNode(CntNodeJob & rJob);

	ErrCode exportMesg(CntNodeJob & rJob, CntExport & rExport,
					   CntIMAPMesgNode & rMesgNode);

	void notifyMboxConstruction(CntIMAPMbox & rMbox);

	void notifyMboxDestruction(CntIMAPMbox & rMbox);

	virtual void Notify(SfxBroadcaster & rBroadcaster, SfxHint const & rHint);

	CntItemListItem const & getMboxNoInferiorsFactoryList(SfxItemSet const &
														      rDefaults);

	void incrementOpenCount();

	bool decrementOpenCount(SfxPoolItem const & rRequest);

	bool isOpen() const { return m_nOpenCount > 0; }
};

inline bool CntIMAPAcnt::acquireClient()
{
	if (m_bClientLocked)
		return false;
	m_bClientLocked = true;
	return true;
}

}

#endif // CHAOS_IMAPACNT_HXX

