/*************************************************************************
 *
 *  $RCSfile: imaplist.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif

#ifndef CHAOS_IMAPLIST_HXX
#include <imaplist.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntIMAPMboxList
//
//============================================================================

CntIMAPMboxList::~CntIMAPMboxList()
{
	while (m_aList.Count() != 0)
		delete static_cast< Entry * >(m_aList.Remove(m_aList.Count() - 1));
}

//============================================================================
void CntIMAPMboxList::add(String const & rMboxURL, bool bHidden)
{
	bool bDone = false;
	ULONG i = 0;
	while (!bDone && i < m_aList.Count())
	{
		Entry * pEntry = static_cast< Entry * >(m_aList.GetObject(i));
		switch (rMboxURL.CompareTo(pEntry->m_aMboxURL))
		{
			case COMPARE_LESS:
				bDone = true;
				break;

			case COMPARE_EQUAL:
				if (bHidden)
					pEntry->m_bHidden = true;
				return;

			case COMPARE_GREATER:
				++i;
				break;
		}
	}
	m_aList.Insert(new Entry(rMboxURL, bHidden), i);
}

//============================================================================
void CntIMAPMboxList::remove(String const & rMboxURL)
{
	for (ULONG i = 0; i < m_aList.Count(); ++i)
	{
		Entry * pEntry = static_cast< Entry * >(m_aList.GetObject(i));
		switch (rMboxURL.CompareTo(pEntry->m_aMboxURL))
		{
			case COMPARE_LESS:
				return;

			case COMPARE_EQUAL:
				delete static_cast< Entry * >(m_aList.Remove(i));
				return;
		}
	}
}

//============================================================================
bool CntIMAPMboxList::iter(String & rMboxURL)
{
	bool bFound = false;
	while (!bFound && m_aList.Count() != 0)
	{
		Entry * pEntry
			= static_cast< Entry * >(m_aList.Remove(m_aList.Count() - 1));
		bFound = !pEntry->m_bHidden;
		if (bFound)
			rMboxURL = pEntry->m_aMboxURL;
		delete pEntry;
	}
	return bFound;
}

//============================================================================
//
//  CntIMAPMboxHierList
//
//============================================================================

CntIMAPMboxHierList::Entry & CntIMAPMboxHierList::insert(Entry ** pEntry,
														 ByteString const &
														     rLiteralLastName)
{
	while (*pEntry)
	{
		switch ((*pEntry)->m_aLiteralLastName.CompareTo(rLiteralLastName))
		{
			case COMPARE_EQUAL:
				return **pEntry;

			case COMPARE_LESS:
				pEntry = &(*pEntry)->m_pLeft;
				break;

			case COMPARE_GREATER:
				pEntry = &(*pEntry)->m_pRight;
				break;
		}
	}
	*pEntry = new Entry;
	return **pEntry;
}

//============================================================================
void CntIMAPMboxHierList::chain(Entry & rEntry)
{
	if (!rEntry.m_bDeleted)
	{
		if (!rEntry.m_bSubscribed)
			++m_nUnsubscribed;
		if (!rEntry.m_bSubscribed || rEntry.m_pParent)
		{
			if (m_pChain[rEntry.m_bSubscribed])
				m_pChain[rEntry.m_bSubscribed]->m_pPrev = &rEntry;
			rEntry.m_pNext = m_pChain[rEntry.m_bSubscribed];
			m_pChain[rEntry.m_bSubscribed] = &rEntry;
		}
	}
}

//============================================================================
void CntIMAPMboxHierList::unchain(Entry & rEntry)
{
	if (!rEntry.m_bDeleted)
	{
		if (!rEntry.m_bSubscribed)
			--m_nUnsubscribed;
		if (!rEntry.m_bSubscribed || rEntry.m_pParent)
		{
			if (rEntry.m_pPrev)
				rEntry.m_pPrev->m_pNext = rEntry.m_pNext;
			else
			{
				DBG_ASSERT(m_pChain[rEntry.m_bSubscribed] == &rEntry,
						   "CntIMAPMboxHierList::unchain(): Bad chains");
				m_pChain[rEntry.m_bSubscribed] = rEntry.m_pNext;
			}
			if (rEntry.m_pNext)
				rEntry.m_pNext->m_pPrev = rEntry.m_pPrev;
			rEntry.m_pPrev = 0;
			rEntry.m_pNext = 0;
		}
	}
}

//============================================================================
void CntIMAPMboxHierList::remove(Entry * pEntry)
{
	if (pEntry)
	{
		remove(pEntry->m_pChildren);
		pEntry->m_pChildren = 0;
		remove(pEntry->m_pLeft);
		pEntry->m_pLeft = 0;
		remove(pEntry->m_pRight);
		pEntry->m_pRight = 0;
		unchain(*pEntry);
		delete pEntry;
	}
}

//============================================================================
void CntIMAPMboxHierList::add(CntNodeJob & rJob, CntNode & rFldrNode,
							  ByteString const & rFldrLiteralFullName,
							  ByteString const & rSubMboxLiteralFullName,
							  sal_Char cHierarchySeparator, bool bSubscribed)
{
	DBG_ASSERT(rSubMboxLiteralFullName.Len() > rFldrLiteralFullName.Len()
			   && rFldrLiteralFullName.Match(rSubMboxLiteralFullName)
			          == STRING_MATCH
			   && (rFldrLiteralFullName.Len() == 0
				   || cHierarchySeparator != '\0'
				      && rSubMboxLiteralFullName.GetChar(rFldrLiteralFullName.
														     Len())
				             == cHierarchySeparator),
			   "CntIMAPMboxHierList::add(): Bad names");

	String aURL(OWN_URL(&rFldrNode));
	Entry * pParent = 0;
	Entry ** pChildren = &m_pRoot;
	for (xub_StrLen nSegmentBegin = rFldrLiteralFullName.Len() == 0 ?
			 0 : rFldrLiteralFullName.Len() + 1;
		 nSegmentBegin < rSubMboxLiteralFullName.Len();)
	{
		xub_StrLen nSegmentEnd;
		xub_StrLen nNextSegmentBegin;
		if (cHierarchySeparator == '\0')
		{
			nSegmentEnd = rSubMboxLiteralFullName.Len();
			nNextSegmentBegin = nSegmentEnd;
		}
		else
		{
			nSegmentEnd = rSubMboxLiteralFullName.Search(cHierarchySeparator,
														 nSegmentBegin + 1);
			if (nSegmentEnd == STRING_NOTFOUND)
			{
				nSegmentEnd = rSubMboxLiteralFullName.Len();
				nNextSegmentBegin = nSegmentEnd;
			}
			else
				nNextSegmentBegin = nSegmentEnd + 1;
		}
		ByteString aName(rSubMboxLiteralFullName, nSegmentBegin,
						 nSegmentEnd - nSegmentBegin);
		nSegmentBegin = nNextSegmentBegin;

		aURL = CntIMAPURL::createSubMboxURL(aURL, aName);

		Entry & rEntry = insert(pChildren, aName);
		rEntry.m_cHierarchySeparator = cHierarchySeparator;
		if (rEntry.m_aLiteralLastName.Len() == 0)
		{
			if (pParent)
				++pParent->m_nChildCount;
			rEntry.m_aLiteralLastName = aName;
			rEntry.m_pParent = pParent;
			rEntry.m_bSubscribed = bSubscribed
				                   && nSegmentBegin
				                          >= rSubMboxLiteralFullName.Len();
			CntNodeRef xSubMboxNode = rFldrNode.Query(aURL);
			if (xSubMboxNode.Is())
			{
				static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
					getMbox().initialize(rJob);
				if (static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
					    getMbox().isDeleted())
					rEntry.m_bDeleted = true;
			}
			chain(rEntry);
		}
		else if (bSubscribed && !rEntry.m_bSubscribed
				 && nSegmentBegin >= rSubMboxLiteralFullName.Len())
		{
			unchain(rEntry);
			rEntry.m_bSubscribed = true;
			chain(rEntry);
		}

		if (rEntry.m_bDeleted)
			break;

		pParent = &rEntry;
		pChildren = &rEntry.m_pChildren;
	}
}

//============================================================================
bool CntIMAPMboxHierList::iter(bool bSubscribed,
							   ByteString const & rFldrLiteralFullName,
							   ByteString & rSubMboxLiteralFullName,
							   sal_Char & rHierarchySeparator)
{
	Entry * pHead = m_pChain[bSubscribed];
	if (!pHead)
		return false;

	DBG_ASSERT(!pHead->m_bDeleted && pHead->m_bSubscribed == bSubscribed,
			   "CntIMAPMboxHierList::iter(): Bad chain");

	rSubMboxLiteralFullName = pHead->m_aLiteralLastName;
	for (const Entry * p = pHead->m_pParent; p; p = p->m_pParent)
	{
		DBG_ASSERT(pHead->m_cHierarchySeparator != '\0',
				   "CntIMAPMboxHierList::iter(): Bad separator");
		rSubMboxLiteralFullName.Insert(pHead->m_cHierarchySeparator, 0);
		rSubMboxLiteralFullName.Insert(p->m_aLiteralLastName, 0);
	}
	if (rFldrLiteralFullName.Len() != 0)
	{
		DBG_ASSERT(pHead->m_cHierarchySeparator != '\0',
				   "CntIMAPMboxHierList::iter(): Bad separator");
		rSubMboxLiteralFullName.Insert(pHead->m_cHierarchySeparator, 0);
		rSubMboxLiteralFullName.Insert(rFldrLiteralFullName, 0);
	}
	rHierarchySeparator = pHead->m_cHierarchySeparator;
	if (bSubscribed)
		m_pSubscribed = m_pChain[true];
	unchain(*pHead);
	pHead->m_bDeleted = true;
	return true;
}

//============================================================================
void CntIMAPMboxHierList::removeSubscribed()
{
	if (m_pSubscribed)
	{
		while (m_pSubscribed->m_pParent
			   && m_pSubscribed->m_pParent->m_nChildCount == 1)
			m_pSubscribed = m_pSubscribed->m_pParent;
		remove(m_pSubscribed->m_pChildren);
		m_pSubscribed->m_pChildren = 0;
		unchain(*m_pSubscribed);
		m_pSubscribed->m_bDeleted;
		if (m_pSubscribed->m_pParent)
			--m_pSubscribed->m_pParent->m_nChildCount;
		m_pSubscribed = 0;
	}
}

//============================================================================
//
//  CntIMAPMboxNodeListEntry
//
//============================================================================

CntIMAPMboxNodeListEntry::CntIMAPMboxNodeListEntry(CntIMAPMboxNode &
												    rTheMboxNode):
	m_xMboxNode(&rTheMboxNode),
	m_bFresh(true)
{}

//============================================================================
CntIMAPMboxNode & CntIMAPMboxNodeListEntry::getMboxNode()
{
	return *static_cast< CntIMAPMboxNode * >(&m_xMboxNode);
}

//============================================================================
//
//  CntIMAPMboxNodeList
//
//============================================================================

CntIMAPMboxNodeList::~CntIMAPMboxNodeList()
{
	while (m_aList.Count() != 0)
		delete static_cast< CntIMAPMboxNodeListEntry * >(
			       m_aList.Remove(m_aList.Count() - 1));
}

//============================================================================
void CntIMAPMboxNodeList::push(CntIMAPMboxNode & rMboxNode)
{
	for (ULONG i = 0; i < m_aList.Count(); ++i)
		if (&static_cast< CntIMAPMboxNodeListEntry * >(m_aList.GetObject(i))->
			         getMboxNode()
			    == &rMboxNode)
			return;
	m_aList.Insert(new CntIMAPMboxNodeListEntry(rMboxNode), LIST_APPEND);
}

//============================================================================
//
//  CntIMAPMesgList
//
//============================================================================

CntIMAPMesgList::~CntIMAPMesgList()
{
	while (m_aList.Count() != 0)
		delete static_cast< Entry * >(m_aList.Remove(m_aList.Count() - 1));
}

//============================================================================
void CntIMAPMesgList::add(sal_uInt32 nUIDValidity, sal_uInt32 nMesgUID)
{
	m_aList.Insert(new Entry(nUIDValidity, nMesgUID), LIST_APPEND);
}

//============================================================================
bool CntIMAPMesgList::iter(sal_uInt32 & rUIDValidity, sal_uInt32 & rMesgUID)
{
	if (m_aList.Count() == 0)
		return false;
	Entry * pEntry
		= static_cast< Entry * >(m_aList.Remove(m_aList.Count() - 1));
	rUIDValidity = pEntry->m_nUIDValidity;
	rMesgUID = pEntry->m_nMesgUID;
	delete pEntry;
	return true;
}

//============================================================================
//
//  CntIMAPMesgNodeList
//
//============================================================================

CntIMAPMesgNodeList::~CntIMAPMesgNodeList()
{
	while (m_aList.Count() != 0)
		static_cast< CntIMAPMesgNode * >(m_aList.Remove(m_aList.Count()
														    - 1))->
			ReleaseRef();
}

//============================================================================
void CntIMAPMesgNodeList::add(CntNodeRef & rMesgNode)
{
	DBG_ASSERT(PTR_CAST(CntIMAPMesgNode, &rMesgNode),
			   "CntIMAPMesgNodeList::add(): Invalid node");

	rMesgNode->AddRef();
	m_aList.Insert(static_cast< CntIMAPMesgNode * >(&rMesgNode), LIST_APPEND);
}

//============================================================================
bool CntIMAPMesgNodeList::iter(CntNodeRef & rMesgNode)
{
	if (m_aList.Count() == 0)
		return false;
	rMesgNode = static_cast< CntIMAPMesgNode * >(
		            m_aList.Remove(m_aList.Count() - 1));
	rMesgNode->ReleaseRef();
	return true;
}

//============================================================================
//
//  CntIMAPMesgURLList
//
//============================================================================

CntIMAPMesgURLList::~CntIMAPMesgURLList()
{
	while (m_aList.Count() != 0)
		delete static_cast< String * >(m_aList.Remove(m_aList.Count() - 1));
}

//============================================================================
void CntIMAPMesgURLList::remove(String const & rMesgURL)
{
	for (ULONG i = 0; i < m_aList.Count(); ++i)
		if (*static_cast< String * >(m_aList.GetObject(i)) == rMesgURL)
		{
			delete static_cast< String * >(m_aList.Remove(i));
			break;
		}
}

//============================================================================
bool CntIMAPMesgURLList::iter(String & rMesgURL)
{
	if (m_aList.Count() == 0)
		return false;
	String * pTheMesgURL
		= static_cast< String * >(m_aList.Remove(m_aList.Count() - 1));
	rMesgURL = *pTheMesgURL;
	delete pTheMesgURL;
	return true;
}

//============================================================================
//
//  CntIMAPMesgUIDList
//
//============================================================================

void CntIMAPMesgUIDList::add(sal_uInt32 nMesgUID)
{
	DBG_ASSERT(nMesgUID != 0, "CntIMAPMesgUIDList::add(): Bad UID");
	m_aList.Insert(reinterpret_cast< void * >(nMesgUID), LIST_APPEND);
}

//============================================================================
sal_uInt32 CntIMAPMesgUIDList::iter()
{
	return m_aList.Count() == 0 ?
		       0 :
		       reinterpret_cast< sal_uInt32 >(m_aList.Remove(m_aList.Count()
															     - 1));
}

//============================================================================
//
//  CntIMAPSubJobList
//
//============================================================================

CntIMAPSubJobList::~CntIMAPSubJobList()
{
	while (m_aList.Count() != 0)
		delete static_cast< CntIMAPSubJobListEntry * >(
			       m_aList.Remove(m_aList.Count() - 1));
}

