/*************************************************************************
 *
 *  $RCSfile: imapmbx1.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <limits>

#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _CNTMBXITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef CHAOS_FLSTITEM_HXX
#include <flstitem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMBXT_HXX
#include <imapmbxt.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntIMAPMboxOpenTask
//
//============================================================================

bool CntIMAPMboxOpenTask::listSubMbox(CntNode & rSubMboxNode)
{
	if (static_cast< CntIMAPMboxNode * >(&rSubMboxNode)->
		    getMbox().isDeleted())
		return false;

	switch (m_eListSubMboxsMode)
	{
		case CNT_VIEW_ALL_FOLDERS:
			return true;

		case CNT_VIEW_SUBSCRIBED_FOLDERS:
			return ITEMSET_VALUE(&rSubMboxNode, CntBoolItem,
								 WID_FLAG_SUBSCRIBED)
				       != false;

		default: // CNT_VIEW_ACTIVE_FOLDERS
			return ITEMSET_VALUE(&rSubMboxNode, CntBoolItem,
								 WID_FLAG_SUBSCRIBED)
				   && !ITEMSET_VALUE(&rSubMboxNode, CntBoolItem, WID_IS_READ);
	}
}

//============================================================================
void CntIMAPMboxOpenTask::removeMesgDataCacheStream()
{
	if (m_bHasMesgDataCacheStream)
	{
		if (CntStorageNode * pCacheNode = getJob().GetCacheNode())
		{
			pCacheNode->
				remove(CntIMAPMesgNode::createDataStreamID(m_aMboxURL, 0,
														   m_nMesgUID));
			m_bHasMesgDataCacheStream = false;
		}
	}
}

//============================================================================
IMPL_LINK(CntIMAPMboxOpenTask, streamCallback,
		  INetIMAPFetchResponseBodySection const *, pSection)
{
	DBG_ASSERT(pSection,
			   "CntIMAPMboxOpenTask::streamCallback(): Null section");

	vos::ORef< ThreadTask > xThis(this);
	SvStream * pMesgDataCacheStream = 0;
	if (wakeUp())
	{
		if (!m_bHasMesgDataCacheStream
			&& ((pSection->getSectionText()
				         == INetIMAPBodySectionDescriptor::SECTION_TEXT_NO
			         && !pSection->getSectionNumberSequence().getCount()
			         && !pSection->isPartial())
				|| pSection->getSectionText()
				       == INetIMAPBodySectionDescriptor::RFC822))
		{
			if (CntStorageNode * pCacheNode = getJob().GetCacheNode())
			{
				String aDataStreamID(CntIMAPMesgNode::createDataStreamID(
					                     m_aMboxURL, 0, m_nMesgUID));
				if (pMesgDataCacheStream
					    = pCacheNode->openStream(aDataStreamID,
												 STREAM_STD_WRITE
												     | STREAM_TRUNC))
				{
					m_bHasMesgDataCacheStream = true;
					pCacheNode->attrib(aDataStreamID, 0,
									   CNTDIRENTRY_ATTRIB_HIDDEN);
				}
			}
		}
		sleep();
	}
	return reinterpret_cast< long >(pMesgDataCacheStream);
}

//============================================================================
// virtual
void CntIMAPMboxOpenTask::beingCanceled()
{
	removeMesgDataCacheStream();
	delete m_pMboxDirIter;
	delete m_pMesgUIDSet;
	super::beingCanceled();
}

//============================================================================
// virtual
bool CntIMAPMboxOpenTask::initialize()
{
	// Each putting a WID_TRANSFER job into some mbox node results in an extra
	// WID_UPDATE job for that mbox node inserted into the acnt node's job
	// queue; to avoid unnecessary multiple WID_UPDATEs, if in the acnt node's
	// job queue a WID_UPDATE job for an mbox node is directly followed by a
	// WID_TRANSFER job for the same mbox node, the WID_UPDATE job is
	// discarded:
#if !defined USE_JOB_DISPATCHER
	if (initialReschedule())
		return false;
#endif // USE_JOB_DISPATCHER
	if (getJob().GetRequest()->Which() == WID_UPDATE
		&& getAcnt().checkNextJob(*getJob().GetSubject(), WID_TRANSFER))
	{
		cancel();
		return false;
	}

	if (CntOpenModeItem const * pMode = PTR_CAST(CntOpenModeItem,
												 getJob().GetRequest()))
		switch (pMode->GetValue())
		{
			case CNT_OPEN_ALL:
				m_bListMesgs = true;
				m_bListSubMboxs = true;
				break;

			case CNT_OPEN_FOLDERS:
				m_bListMesgs = false;
				m_bListSubMboxs = true;
				break;

			case CNT_OPEN_MESSAGES:
				m_bListMesgs = true;
				m_bListSubMboxs = false;
				break;

			default:
				done();
				return false;
		}
	else
	{
		m_bListMesgs = true;
		m_bListSubMboxs = true;
	}

	if (getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
		forceDetermination();
	if (!m_bListMesgs)
		skipSelect();

	if (m_bListMesgs)
		switch (getJob().GetRequest()->Which())
		{
			case WID_OPEN:
			case WID_SEARCH:
				m_eListMesgsMode
					= CntMsgViewMode(ITEMSET_VALUE(getJob().GetClient(),
												   CntMsgViewModeItem,
												   WID_MESSAGEVIEW_MODE));
				break;

			default:
				m_eListMesgsMode = CNT_VIEW_ALL_ARTICLES;
				break;
		}

	if (m_bListSubMboxs)
		switch (getJob().GetRequest()->Which())
		{
			case WID_OPEN:
			case WID_SEARCH:
				m_eListSubMboxsMode
					= CntFolderViewMode(ITEMSET_VALUE(getJob().GetClient(),
													  CntFolderViewModeItem,
													  WID_FOLDERVIEW_MODE));
				break;

			default:
				m_eListSubMboxsMode = CNT_VIEW_ALL_FOLDERS;
				break;
		}

	m_aAcntURL = OWN_URL(&getAcnt().getNode());
	m_aMboxURL = OWN_URL(&getMbox().getNode());
	m_xMboxDirNode = getMbox().getDirNode(getJob());

	sal_uInt32 nMboxDirAttribs = 0;
	if (m_xMboxDirNode.Is())
		static_cast< CntStorageNode * >(m_xMboxDirNode->GetParent())->
			attrib(m_aMboxURL, 0, 0, nMboxDirAttribs);

	m_bCompleteMesgs
		= !m_bListMesgs
		  || nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_MESGS;
	m_bCompleteSubscribedSubMboxs
		= !m_bListSubMboxs
		  || nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD_MBOXS;
	m_bCompleteSubMboxs
		= !m_bListSubMboxs || m_eListSubMboxsMode != CNT_VIEW_ALL_FOLDERS
		  || nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_MBOXS;
	m_bAutoSubscribeChecked
		= (nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_AUTO_CHECKED) != 0;

	m_bUpdate = getJob().GetRequest()->Which() == WID_UPDATE
	            || getJob().GetRequest()->Which() == WID_SYNCHRONIZE
	            || ITEMSET_VALUE(getJob().GetClient(), CntBoolItem,
								 WID_FLAG_UPDATE_ON_OPEN);

	if (getAcnt().getBaseFldrURL() == m_aMboxURL)
		m_bAutoSubscribe = !m_bAutoSubscribeChecked
			               || getJob().GetRequest()->Which()
			                      == WID_SYNCHRONIZE;
	else
	{
		m_bAutoSubscribeChecked = true;
		m_bAutoSubscribe = false;
	}

	if (m_xMboxDirNode.Is())
		if (getJob().GetRequest()->Which() == WID_UPDATE)
			m_pMboxDirIter
			 = new CntStorageIterator(CNTDIRENTRY_ATTRIB_IMAP_MBOX,
									  CNTDIRENTRY_ATTRIB_NOTITER
									   | CNTSTORE_ATTRIB_ISDIR);
		else
		{
			sal_uInt32 nIncludeMask;
			sal_uInt32 nExcludeMask;
			if (m_bListSubMboxs)
			{
				nIncludeMask = m_bListMesgs ? 0 :
				                              CNTDIRENTRY_ATTRIB_IMAP_MBOX;
				nExcludeMask = CNTDIRENTRY_ATTRIB_NOTITER
				                | CNTSTORE_ATTRIB_ISDIR;
			}
			else
				switch (m_eListMesgsMode)
				{
					case CNT_VIEW_UNREAD_ARTICLES:
						nIncludeMask = 0;
						nExcludeMask
						 = CNTDIRENTRY_ATTRIB_NOTITER | CNTSTORE_ATTRIB_ISDIR
						    | CNTDIRENTRY_ATTRIB_IMAP_MESG_READ
						    | CNTDIRENTRY_ATTRIB_IMAP_MBOX;
						break;

					case CNT_VIEW_READ_ARTICLES:
						nIncludeMask = CNTDIRENTRY_ATTRIB_IMAP_MESG_READ;
						nExcludeMask
						 = CNTDIRENTRY_ATTRIB_NOTITER | CNTSTORE_ATTRIB_ISDIR
						    | CNTDIRENTRY_ATTRIB_IMAP_MBOX;
						break;

					case CNT_VIEW_MARKED_ARTICLES:
						nIncludeMask = CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED;
						nExcludeMask
						 = CNTDIRENTRY_ATTRIB_NOTITER | CNTSTORE_ATTRIB_ISDIR
						    | CNTDIRENTRY_ATTRIB_IMAP_MBOX;
						break;

					default:
						nIncludeMask = 0;
						nExcludeMask
						 = CNTDIRENTRY_ATTRIB_NOTITER | CNTSTORE_ATTRIB_ISDIR
						    | CNTDIRENTRY_ATTRIB_IMAP_MBOX;
						break;
				}
			m_pMboxDirIter
			 = new CntStorageIterator(nIncludeMask, nExcludeMask);
		}

	m_bOfflineDone = false;

	m_nProgressMax = 0;
	if (m_bListMesgs)
		switch (m_eListMesgsMode)
		{
			case CNT_VIEW_UNREAD_ARTICLES:
				m_nProgressMax
				 += getMbox().getLMesgCount() + getMbox().getLSMesgCount()
				     - ITEMSET_VALUE(&getMbox().getNode(), CntUInt32Item,
									 WID_IMAP_READ_MESG_COUNT);
				break;

			case CNT_VIEW_READ_ARTICLES:
				m_nProgressMax
				 += ITEMSET_VALUE(&getMbox().getNode(), CntUInt32Item,
								  WID_IMAP_READ_MESG_COUNT);
				break;

			case CNT_VIEW_MARKED_ARTICLES:
				m_nProgressMax
				 += ITEMSET_VALUE(&getMbox().getNode(), CntUInt32Item,
								  WID_IMAP_MARKED_MESG_COUNT);
				break;

			default:
				m_nProgressMax
				 += getMbox().getLMesgCount() + getMbox().getLSMesgCount();
				break;
		}
	if (m_bListSubMboxs)
		m_nProgressMax
		 += ITEMSET_VALUE(&getMbox().getNode(), CntUInt32Item,
						  m_eListSubMboxsMode == CNT_VIEW_ALL_FOLDERS ?
						   WID_IMAP_MBOX_COUNT : WID_IMAP_SSCRBD_MBOX_COUNT);
	m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;
	m_nMesgBodyProgress = CntIMAPStatusInformation::NO_PROGRESS;

	m_nLMesgCount = 0;
	m_nLSMesgCount = 0;
	m_nReadMesgCount = 0;
	m_nMarkedMesgCount = 0;
	m_nSubMboxCount = 0;
	m_nSscrbdSubMboxCount = 0;
	m_nNewSubMboxCount = 0;
	m_nRemovedSubMboxCount = 0;
	m_bModifiedSubscribed = false;

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxOpenTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_SEARCH:
		{
			if (!(m_bListMesgs && getMbox().getSelect()))
			{
				m_nState = STATE_SEND_LSUB;
				return EXEC_CONTINUE;
			}

			if (getMesgCount() != 0
				&& (!m_bCompleteMesgs || hasBadRecentMesgCount()
					|| getJob().GetRequest()->Which() == WID_SYNCHRONIZE))
			{
				m_pMesgUIDSet
					= getAcnt().getClient()->createMessageNumberSet();
				m_pMesgUIDSet->addHalfOpen(1);

				m_nState = STATE_SEND_FETCH;
				return EXEC_CONTINUE;
			}

			if (getRecentMesgCount() == 0)
			{
				if (m_xMboxDirNode.Is())
					static_cast< CntStorageNode * >(m_xMboxDirNode->
													    GetParent())->
						attrib(m_aMboxURL, 0,
							   CNTDIRENTRY_ATTRIB_IMAP_MBOX_MESGS);

				m_nState = STATE_SEND_LSUB;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_MESSAGES),
								  CntIMAPStatusInformation::TAG_NONE, true);

			INetIMAPSearchKeyList * pSearchKeys
				= getAcnt().getClient()->
			          createSearchKeyList(
						  getAcnt().getClient()->
						      createSimpleSearchKey(
								  INetIMAPSimpleSearchKey::CRITERIUM_RECENT));

			++m_nState;
			ErrCode nError
				= clientCommandSearch(true, RTL_TEXTENCODING_DONTKNOW,
									  *pSearchKeys);
			delete pSearchKeys;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_SEARCH:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_pMesgUIDSet)
							return handleCommandFailure(
								       *new StringErrorInfo(
										        ERRCODE_CHAOS_IMAP_BAD_SERVER,
												ITEMSET_VALUE(
													&getMbox().getNode(),
													CntStringItem,
													WID_SERVERNAME)));

						popStatusInformation();

						if (m_pMesgUIDSet->isEmpty())
						{
							delete m_pMesgUIDSet;
							m_pMesgUIDSet = 0;

							m_nState = STATE_SEND_LSUB;
							return EXEC_CONTINUE;
						}
						else
						{
							m_nState = STATE_SEND_FETCH;
							return EXEC_CONTINUE;
						}
					}
					break;
				}

				case INetIMAPResponse::TYPE_SEARCH:
				{
					INetIMAPMessageNumberSetBase const & rOriginalMesgUIDSet
						= static_cast< INetIMAPSearchResponse const * >(
							      pResponse)->
					          getMessageNumberSet();
					delete m_pMesgUIDSet;
					m_pMesgUIDSet = rOriginalMesgUIDSet.clone();
					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_FETCH:
		{
			pushStatusInformation(CntResId(RID_READING_MESSAGES),
								  CntIMAPStatusInformation::TAG_NONE, true);

			++m_nState;
			Execution eExecution
				= handleCommandFailure(
					  clientCommandFetch(true, *m_pMesgUIDSet,
										 INetIMAPClient::FetchAttributes(
											 INetIMAPClient::FETCH_ALL
											     | INetIMAPClient::FETCH_UID),
										 0, 0, Link()));
			if (m_nState != STATE_SEND_FETCH)
			{
				delete m_pMesgUIDSet;
				m_pMesgUIDSet = 0;
			}
			return eExecution;
		}

		case STATE_RECV_FETCH:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (m_xMboxDirNode.Is())
							static_cast< CntStorageNode * >(m_xMboxDirNode->
															    GetParent())->
								attrib(m_aMboxURL, 0,
									   CNTDIRENTRY_ATTRIB_IMAP_MBOX_MESGS);
						m_bListMesgs = false;

						popStatusInformation();

						m_nState = STATE_SEND_FETCH_BODY;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_FETCH:
				{
					INetIMAPFetchResponse const & rFetchResponse
						= *static_cast< INetIMAPFetchResponse const * >(
							   pResponse);

					if (rFetchResponse.getPresentParts()
						 & INetIMAPFetchResponse::PART_UID)
					{
						String
						 aMesgURL(CntIMAPURL::createMesgURL(m_aMboxURL, 0,
															rFetchResponse.
															 getUID()));
						CntNodeRef
						 xMesgNode(getMbox().getNode().Query(aMesgURL));
						if (xMesgNode.Is())
						{
							bool bNew = static_cast< CntIMAPMesgNode * >(
								                &xMesgNode)->
								            initialize(getJob(), true,
													   &rFetchResponse, 0);

							bool bList = !static_cast< CntIMAPMesgNode * >(
								                  &xMesgNode)->
								              isDeleted();
							if (bList)
								switch (m_eListMesgsMode)
								{
									case CNT_VIEW_UNREAD_ARTICLES:
										bList = !ITEMSET_VALUE(xMesgNode,
															   CntBoolItem,
															   WID_IS_READ);
										break;

									case CNT_VIEW_READ_ARTICLES:
										bList = ITEMSET_VALUE(xMesgNode,
															  CntBoolItem,
															  WID_IS_READ)
											        != false;
										break;

									case CNT_VIEW_MARKED_ARTICLES:
										bList = ITEMSET_VALUE(xMesgNode,
															  CntBoolItem,
															  WID_IS_MARKED)
											        != false;
										break;

									case CNT_VIEW_MARKED_AND_UNREAD_ARTICLES:
										bList
										 = !ITEMSET_VALUE(xMesgNode,
														  CntBoolItem,
														  WID_IS_READ)
										   || ITEMSET_VALUE(xMesgNode,
															CntBoolItem,
															WID_IS_MARKED);
										break;
								}

							if (bList)
							{
								switch (getJob().GetRequest()->Which())
								{
									case WID_OPEN:
										getJob().Result(xMesgNode);
										break;

									case WID_SEARCH:
										getJob().Result(xMesgNode);
										getJob().
										 ResultSearchMatch(xMesgNode);
										break;

									case WID_UPDATE:
										if (bNew)
											getJob().Result(xMesgNode);
										break;

									case WID_SYNCHRONIZE:
										getJob().Result(xMesgNode);
										++m_nLSMesgCount;
										if (ITEMSET_VALUE(xMesgNode,
														  CntBoolItem,
														  WID_IS_READ))
											++m_nReadMesgCount;
										if (ITEMSET_VALUE(xMesgNode,
														  CntBoolItem,
														  WID_IS_MARKED))
											++m_nMarkedMesgCount;
										m_aSyncMesgList.remove(aMesgURL);
										break;
								}

								if (static_cast< CntIMAPMesgNode * >(
									        &xMesgNode)->
									    mustDownloadBody(getJob()))
									m_aMesgUIDs.add(rFetchResponse.getUID());
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_FETCH_BODY:
		{
			m_nMesgUID = m_aMesgUIDs.iter();
			if (!m_nMesgUID)
			{
				if (m_nMesgBodyProgress
					    != CntIMAPStatusInformation::NO_PROGRESS)
					popStatusInformation();

				m_nState = STATE_SEND_LSUB;
				return EXEC_CONTINUE;
			}

			if (m_nMesgBodyProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_PROT_LOADING_MESSAGES), 0,
									  m_aMesgUIDs.getCount() + 1);
				m_nMesgBodyProgress = 0;
			}

			bool bIMAP4Rev1 = (getAcnt().getClient()->getCapabilities()
							           & INetIMAPClient::CAPABILITY_IMAP4REV1)
				                  != 0;

			INetIMAPMessageNumberSet * pSet
				= getAcnt().getClient()->createMessageNumberSet();
			pSet->add(m_nMesgUID);

			INetIMAPArgumentBodySectionList * pSections;
			if (bIMAP4Rev1)
			{
				INetIMAPArgumentBodySection * pSection
					= getAcnt().getClient()->createArgumentBodySection();
				pSection->setPeek();
				pSections
					= getAcnt().getClient()->createArgumentBodySectionList();
				pSections->append(pSection);
			}
			else
				pSections = 0;

			++m_nState;
			ErrCode nError
				= clientCommandFetch(true, *pSet,
									 bIMAP4Rev1 ?
									     INetIMAPClient::FetchAttributes(0) :
									     INetIMAPClient::FETCH_RFC822_PEEK,
									 pSections, 0,
									 LINK(this, CntIMAPMboxOpenTask,
										  streamCallback));
			delete pSet;
			delete pSections;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_FETCH_BODY:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						    == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
						 = handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						removeMesgDataCacheStream();
						progressStatusInformation(++m_nMesgBodyProgress);

						m_nState = STATE_SEND_FETCH_BODY;
						return EXEC_RESCHEDULE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_FETCH:
				{
					INetIMAPFetchResponse const & rFetchResponse
						= *static_cast< INetIMAPFetchResponse const * >(
							   pResponse);

					if (rFetchResponse.getPresentParts()
						    & INetIMAPFetchResponse::PART_UID
						&& rFetchResponse.getUID() == m_nMesgUID)
					{
						INetIMAPFetchResponseBodySectionList const & rSections
							= rFetchResponse.getBodySections();
						for (ULONG i = 0; i < rSections.getCount(); ++i)
						{
							INetIMAPFetchResponseBodySection const & rSection
								= rSections.get(i);

							if (rSection.getSectionText()
							 == INetIMAPBodySectionDescriptor::SECTION_TEXT_NO
								    && !rSection.getSectionNumberSequence().
								            getCount()
								    && !rSection.isPartial()
								|| rSection.getSectionText()
								     == INetIMAPBodySectionDescriptor::RFC822)
							{
								INetCoreNewsMessage const * pMessage
									= rSection.getData();
								if (pMessage)
									if (CntStorageNode * pCacheNode
										    = getJob().GetCacheNode())
									{
										String
											aBodyStreamID(
										  CntIMAPMesgNode::createBodyStreamID(
													m_aMboxURL, 0,
													m_nMesgUID));
										SvStream * pMesgBodyCacheStream
											= pCacheNode->
											      openStream(
													  aBodyStreamID,
													  STREAM_STD_WRITE);
										if (pMesgBodyCacheStream)
										{
											*pMesgBodyCacheStream
												<< CNT_MESSAGEBODY_NEWS_DATA;
											pMesgBodyCacheStream->
												WriteByteString(
										  CntIMAPMesgNode::createDataStreamID(
														m_aMboxURL, 0,
														m_nMesgUID),
													RTL_TEXTENCODING_UTF8);
											*pMesgBodyCacheStream
												<< *pMessage;
											delete pMesgBodyCacheStream;

											CntMessageBodyItem
												aMesgBody(WID_MESSAGEBODY,
														  aBodyStreamID);
											aMesgBody.Get(pCacheNode,
														  getAcnt().
														      getINetMailer(),
														  true);

											removeMesgDataCacheStream();
											pCacheNode->
												attrib(
													aBodyStreamID, 0,
												   CNTDIRENTRY_ATTRIB_HIDDEN);

											CntNodeRef
												xMesgNode(
													getMbox().getNode().Query(
													CntIMAPURL::createMesgURL(
															m_aMboxURL, 0,
															m_nMesgUID),
														false));
											if (xMesgNode.Is()
												&& xMesgNode->
												           GetItemState(
															  WID_MESSAGEBODY,
															   false)
												       == SFX_ITEM_DISABLED)
												xMesgNode->
													ClearItem(
														WID_MESSAGEBODY);
										}
									}
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_LSUB:
		{
			if (!(m_bListSubMboxs && getMbox().getInferiors()
				  && getHierarchySeparator()))
			{
				m_nState = STATE_SYNC_MESGS;
				return EXEC_CONTINUE;
			}

			if (m_bCompleteSubscribedSubMboxs && !m_bUpdate
				&& !m_bAutoSubscribe)
			{
				m_nState = STATE_SEND_LIST;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			ByteString aPattern(getMboxLiteralFullName());
			aPattern += getHierarchySeparator();
			if (m_bAutoSubscribe)
				aPattern += INET_IMAP_LIST_WILDCARD_SEPARATOR;
			else
				aPattern += INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandLSub(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LSUB:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						    == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
						 = handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bCompleteSubscribedSubMboxs)
						{
							if (m_xMboxDirNode.Is())
								static_cast< CntStorageNode * >(
									    m_xMboxDirNode->GetParent())->
									attrib(
										m_aMboxURL, 0,
								   CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD_MBOXS);
							if (getMbox().getNode().
								        GetItemState(
											WID_IMAP_SSCRBD_MBOX_COUNT, false)
								    != SFX_ITEM_SET)
								getMbox().storeProperty(
									          getJob(),
											  CntUInt32Item(
												  WID_IMAP_SSCRBD_MBOX_COUNT,
												  0));
						}

						popStatusInformation();

						m_nState = STATE_UNSUBSCRIBE;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rSubMbox
							= rListResponse.getMailbox(i);
						ByteString aSubMboxLiteralFullName;
						if (isDirectSubMbox(getMboxLiteralFullName(),
											rSubMbox,
											aSubMboxLiteralFullName))
						{
							String
								aSubMboxURL(CntIMAPURL::createMboxURL(
									            m_aAcntURL,
												aSubMboxLiteralFullName,
												rSubMbox.
												    getHierarchySeparator()));
							CntNodeRef xSubMboxNode(getMbox().getNode().
													    Query(aSubMboxURL));
							if (xSubMboxNode.Is())
							{
								bool bSubscribedChanged;
								if (static_cast< CntIMAPMboxNode * >(
									        &xSubMboxNode)->
									    getMbox().
									        initialize(
												getJob(), true, &rSubMbox,
												true,
												m_bCompleteSubscribedSubMboxs
												&& m_bCompleteSubMboxs,
												&bSubscribedChanged))
									++m_nNewSubMboxCount;
								++m_nSscrbdSubMboxCount;
								if (bSubscribedChanged)
									m_bModifiedSubscribed = true;

								if (listSubMbox(*xSubMboxNode))
								{
									if (m_bUpdate)
									{
										m_aSelectSubMboxList.
											add(aSubMboxURL,
												static_cast
												    < CntIMAPMboxNode * >(
														&xSubMboxNode)->
												    getMbox().getSelect());
										m_aSscrbdSubMboxList.
										 remove(aSubMboxURL);
									}

									getJob().Result(xSubMboxNode);
									switch (getJob().GetRequest()->Which())
									{
										case WID_SEARCH:
											getJob().ResultSearchMatch(
												         xSubMboxNode);
											break;

										case WID_SYNCHRONIZE:
											m_aSyncSubMboxList.
												remove(aSubMboxURL);
											break;
									}
								}
							}

							if (m_bAutoSubscribe)
								m_aAutoSscrbMboxList.
									add(getJob(), getMbox().getNode(),
										getMboxLiteralFullName(),
										aSubMboxLiteralFullName,
										rSubMbox.getHierarchySeparator(),
										true);
						}
						else if (m_bAutoSubscribe
								 && isSubMbox(getMboxLiteralFullName(),
											  rSubMbox,
											  aSubMboxLiteralFullName))
							m_aAutoSscrbMboxList.
								add(getJob(), getMbox().getNode(),
									getMboxLiteralFullName(),
									aSubMboxLiteralFullName,
									rSubMbox.getHierarchySeparator(), true);
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_UNSUBSCRIBE:
			if (m_bUpdate)
			{
				startTimeSlice();

				String aSubMboxURL;
				while (m_aSscrbdSubMboxList.iter(aSubMboxURL))
				{
					CntNodeRef xSubMboxNode(getMbox().getNode().
											 Query(aSubMboxURL));
					if (xSubMboxNode.Is())
					{
						static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
							getMbox().initialize(getJob());
						static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
							getMbox().
							    storeProperty(getJob(),
											  CntBoolItem(WID_FLAG_SUBSCRIBED,
														  false));
						m_bModifiedSubscribed = true;
						if (!listSubMbox(*xSubMboxNode))
							getJob().Result(xSubMboxNode, CNT_ACTION_REMOVED);

						if (checkTimeSliceExhausted())
							return EXEC_RESCHEDULE;
					}
				}
			}

			m_nState = STATE_SEND_LIST;
			return EXEC_CONTINUE;

		case STATE_SEND_LIST:
		{
			if (m_bCompleteSubMboxs && !m_bUpdate)
			{
				m_nState = STATE_SEND_SELECT;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			ByteString aPattern = getMboxLiteralFullName();
			aPattern += getHierarchySeparator();
			aPattern += INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandList(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bCompleteSubMboxs)
						{
							if (m_xMboxDirNode.Is())
								static_cast< CntStorageNode * >(
									    m_xMboxDirNode->GetParent())->
									attrib(
										m_aMboxURL, 0,
										CNTDIRENTRY_ATTRIB_IMAP_MBOX_MBOXS);
							if (getMbox().getNode().
								        GetItemState(WID_IMAP_MBOX_COUNT,
													 false)
								    != SFX_ITEM_SET)
								getMbox().
									storeProperty(
										getJob(),
										CntUInt32Item(WID_IMAP_MBOX_COUNT,
													  0));
						}

						popStatusInformation();

						m_nState = STATE_SEND_SELECT;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rSubMbox
						 = rListResponse.getMailbox(i);
						ByteString aSubMboxLiteralFullName;
						if (isDirectSubMbox(getMboxLiteralFullName(),
											rSubMbox,
											aSubMboxLiteralFullName))
						{
							String
								aSubMboxURL(CntIMAPURL::createMboxURL(
									            m_aAcntURL,
												aSubMboxLiteralFullName,
												rSubMbox.
												    getHierarchySeparator()));
							CntNodeRef xSubMboxNode(getMbox().getNode().
													    Query(aSubMboxURL));
							if (xSubMboxNode.Is())
							{
								if (static_cast< CntIMAPMboxNode * >(
									        &xSubMboxNode)->
									    getMbox().
									        initialize(
												getJob(), true, &rSubMbox,
												false,
												m_bCompleteSubscribedSubMboxs
												&& m_bCompleteSubMboxs))
									++m_nNewSubMboxCount;
								++m_nSubMboxCount;

								if (listSubMbox(*xSubMboxNode))
								{
									if (m_bUpdate)
										if (static_cast< CntIMAPMboxNode * >(
											        &xSubMboxNode)->
											    getMbox().getSelect())
											m_aSelectSubMboxList.
												add(aSubMboxURL);
										else
											m_aSelectSubMboxList.
												remove(aSubMboxURL);

									getJob().Result(xSubMboxNode);
									switch (getJob().GetRequest()->Which())
									{
										case WID_SEARCH:
											getJob().ResultSearchMatch(
												         xSubMboxNode);
											break;

										case WID_SYNCHRONIZE:
											m_aSyncSubMboxList.
												remove(aSubMboxURL);
											break;
									}
								}
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_SELECT:
		{
			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_UPDATING_SUBFOLDERS), 0,
									  m_aSelectSubMboxList.getCount());
				m_nProgress = 0;
			}

			if (!m_aSelectSubMboxList.iter(m_aSubMboxURL))
			{
				popStatusInformation();
				m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

				m_nState = STATE_SYNC_MESGS;
				return EXEC_CONTINUE;
			}

			m_bSubMboxHasMesgCount = false;

			ByteString aSubMboxLiteralFullName;
			CntIMAPURL::getMboxLiteralFullName(m_aSubMboxURL,
											   getHierarchySeparator(),
											   aSubMboxLiteralFullName);

			++m_nState;
			return handleCommandFailure(clientCommandSelect(
				                            aSubMboxLiteralFullName));
		}

		case STATE_RECV_SELECT:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							case INetIMAPStateResponse::STATE_NO:
							{
								// At least the 'Solstice (tm) Internet Mail
								// Server (tm) IMAP4 service @ 2.0' in some
								// cases sends tagged NO responses when
								// requested to SELECT a mailbox it advertised
								// as *not* being marked \NoSelect.

								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								if (rStateResponse.getState()
									    == INetIMAPStateResponse::STATE_OK
									&& m_bSubMboxHasMesgCount)
								{
									CntNodeRef xSubMboxNode
										= getMbox().getNode().
										      Query(m_aSubMboxURL);
									if (xSubMboxNode.Is())
									{
										static_cast< CntIMAPMboxNode * >(
											    &xSubMboxNode)->
											getMbox().initialize(getJob());

										static_cast< CntIMAPMboxNode * >(
											    &xSubMboxNode)->
											getMbox().
											    setServerMesgCount(
													getJob(),
													m_nSubMboxMesgCount);
									}
								}

								progressStatusInformation(++m_nProgress);

								--m_nState;
								return EXEC_RESCHEDULE;
							}
						}
					break;
				}

				case INetIMAPResponse::TYPE_EXISTS:
					m_bSubMboxHasMesgCount = true;
					m_nSubMboxMesgCount
						= static_cast< INetIMAPExistsResponse const * >(
							      pResponse)->
					          getMessageCount();
					return EXEC_DONE;
			}
			break;

		case STATE_SYNC_MESGS:
			if (getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
			{
				if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
				{
					pushStatusInformation(CntResId(RID_SYNCHRONIZING_FOLDER),
										  0, m_aSyncMesgList.getCount());
					m_nProgress = 0;
				}

				startTimeSlice();

				String aMesgURL;
				while (m_aSyncMesgList.iter(aMesgURL))
				{
					CntNodeRef xMesgNode(getMbox().getNode().Query(aMesgURL));
					if (xMesgNode.Is())
					{
						static_cast< CntIMAPMesgNode * >(&xMesgNode)->
							initialize(getJob());

						if (static_cast< CntIMAPMesgNode * >(&xMesgNode)->
							    isDeleted()
							|| !ITEMSET_VALUE(xMesgNode, CntBoolItem,
											  WID_IS_MARKED))
						{
							if (!static_cast< CntIMAPMesgNode * >(
								         &xMesgNode)->
								     isDeleted())
							{
								getMbox().changeMesgCounts(
									          getJob(),
											  CntIMAPFldr::COUNT_DEC,
											  CntIMAPFldr::COUNT_STAY,
											  CntIMAPFldr::COUNT_STAY,
											  CntIMAPFldr::COUNT_STAY,
											  ITEMSET_VALUE(xMesgNode,
															CntBoolItem,
															WID_IS_READ) ?
											      CntIMAPFldr::COUNT_DEC :
											      CntIMAPFldr::COUNT_STAY,
											  ITEMSET_VALUE(xMesgNode,
															CntBoolItem,
															WID_IS_MARKED) ?
											      CntIMAPFldr::COUNT_DEC :
											      CntIMAPFldr::COUNT_STAY);
								static_cast< CntIMAPMesgNode * >(&xMesgNode)->
									setDeleted(true);
							}

							if (m_xMboxDirNode.Is())
							{
								String aTheMboxURL;
								sal_uInt32 nUIDValidity;
								sal_uInt32 nMesgUID;
								CntIMAPURL::decomposeMesgURL(aMesgURL,
															 aTheMboxURL,
															 nUIDValidity,
															 nMesgUID);
								static_cast< CntStorageNode * >(
									    &m_xMboxDirNode)->
									remove(CntIMAPMesgNode::createMesgDirID(
										       nUIDValidity, nMesgUID));
							}
							CntStorageNode * pCacheNode
								= getJob().GetCacheNode();
							if (pCacheNode)
							{
								pCacheNode->
									remove(static_cast< CntIMAPMesgNode * >(
										           &xMesgNode)->
										       getDataStreamID());
								pCacheNode->
									remove(static_cast< CntIMAPMesgNode * >(
										           &xMesgNode)->
										       getBodyStreamID());
							}

							getJob().Result(xMesgNode, CNT_ACTION_DELETED);
						}
						else
						{
							++m_nLMesgCount;
							if (ITEMSET_VALUE(xMesgNode, CntBoolItem,
											  WID_IS_READ))
								++m_nReadMesgCount;
							if (ITEMSET_VALUE(xMesgNode, CntBoolItem,
											  WID_IS_MARKED))
								++m_nMarkedMesgCount;
						}
					}

					++m_nProgress;

					if (checkTimeSliceExhausted())
					{
						progressStatusInformation(m_nProgress);
						return EXEC_RESCHEDULE;
					}
				}

				popStatusInformation();
				m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

				getMbox().setMesgCounts(getJob(), m_nLMesgCount, 0,
										m_nLSMesgCount,
										getMbox().getLSDMesgCount(),
										m_nReadMesgCount, m_nMarkedMesgCount);
			}

			m_nState = STATE_SYNC_SUB_MBOXS;
			return EXEC_CONTINUE;

		case STATE_SYNC_SUB_MBOXS:
			if (getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
			{
				if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
				{
					m_nRemovedSubMboxCount = m_aSyncSubMboxList.getCount();

					pushStatusInformation(CntResId(RID_SYNCHRONIZING_FOLDER),
										  0, m_nRemovedSubMboxCount);
					m_nProgress = 0;
				}

				startTimeSlice();

				while (m_aSyncSubMboxList.iter(m_aSubMboxURL))
				{
					CntNodeRef xSubMboxNode
						= getMbox().getNode().Query(m_aSubMboxURL);
					if (xSubMboxNode.Is())
					{
						static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
							getMbox().initialize(getJob());

						if (!static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
							     getMbox().isDeleted())
						{
							getMbox().changeMboxCounts(
								          getJob(), CntIMAPFldr::COUNT_DEC,
										  ITEMSET_VALUE(xSubMboxNode,
														CntBoolItem,
														WID_FLAG_SUBSCRIBED) ?
										      CntIMAPFldr::COUNT_DEC :
										      CntIMAPFldr::COUNT_STAY);
							static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
								getMbox().setDeleted(true);
						}

						if (m_xMboxDirNode.Is())
							static_cast< CntStorageNode * >(&m_xMboxDirNode)->
								remove(m_aSubMboxURL);

						getJob().Result(xSubMboxNode, CNT_ACTION_DELETED);
					}

					++m_nProgress;

					if (checkTimeSliceExhausted())
					{
						progressStatusInformation(m_nProgress);
						return EXEC_RESCHEDULE;
					}
				}

				popStatusInformation();

				getMbox().storeProperty(getJob(),
										CntUInt32Item(WID_IMAP_MBOX_COUNT,
													  m_nSubMboxCount));
				getMbox().
					storeProperty(getJob(),
								  CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT,
												m_nSscrbdSubMboxCount));
			}

			m_nState = m_bAutoSubscribe ? STATE_SEND_CHECK_LIST : STATE_DONE;
			return EXEC_CONTINUE;

		case STATE_SEND_CHECK_LIST:
		{
			sal_Char cHierarchySeparator;
			if (!m_aAutoSscrbMboxList.iter(true, getMboxLiteralFullName(),
										   m_aSubMboxLiteralFullName,
										   cHierarchySeparator))
			{
				m_nState = STATE_ASK_AUTO_SUBSCRIBE;
				return EXEC_CONTINUE;
			}
			m_bFound = false;

			++m_nState;
			return handleCommandFailure(clientCommandList(
				                            ByteString(),
											m_aSubMboxLiteralFullName));
		}

		case STATE_RECV_CHECK_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						if (!m_bFound)
							m_aAutoSscrbMboxList.removeSubscribed();

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						--m_nState;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0;
						 !m_bFound && i < rListResponse.getMailboxCount();
						 ++i)
					{
						ByteString aRecvdMboxLiteralFullName;
						if (isSubMbox(getMboxLiteralFullName(),
									  rListResponse.getMailbox(i),
									  aRecvdMboxLiteralFullName)
							&& aRecvdMboxLiteralFullName
							       == m_aSubMboxLiteralFullName)
							m_bFound = true;
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_ASK_AUTO_SUBSCRIBE:
			m_bSubscribeInbox = false;
			if (m_bAutoSubscribe && getAcnt().doAddBaseInbox())
			{
				CntNodeRef
					xInboxNode(
						getAcnt().getNode().
						    Query(
								CntIMAPURL::createMboxURL(
									m_aAcntURL,
									String::CreateFromAscii(
										RTL_CONSTASCII_STRINGPARAM(
											INET_IMAP_CANONIC_INBOX_NAME)))));
				if (xInboxNode.Is())
				{
					static_cast< CntIMAPMboxNode * >(&xInboxNode)->
						getMbox().initialize(getJob());
					if (!ITEMSET_VALUE(xInboxNode, CntBoolItem,
									   WID_FLAG_SUBSCRIBED))
						m_bSubscribeInbox = true;
				}
			}

			m_bAutoSubscribe = m_bAutoSubscribe
				               && (m_aAutoSscrbMboxList.hasEntries()
								   || m_bSubscribeInbox);

			if (m_bAutoSubscribe)
				switch (handleError(
					        *new StringErrorInfo(
								     ERRCODE_CHAOS_IMAP_AUTO_SUBSCRIBE,
									 ITEMSET_VALUE(&getAcnt().getNode(),
												   CntStringItem,
												   WID_SERVERNAME)),
							false))
				{
					case ERROR_RESPONSE_ABORT:
						cancel();
					case ERROR_RESPONSE_CANCELED:
						return EXEC_DONE;

					default:
						m_bAutoSubscribe = false;
					case ERROR_RESPONSE_RETRY:
							//@@@ i.e., yes, see ThreadTask::handleError()
						break;
				}

			m_nState = m_bAutoSubscribe ? STATE_SEND_SUBSCRIBE : STATE_DONE;
			return EXEC_CONTINUE;

		case STATE_SEND_SUBSCRIBE:
		{
			sal_Char cHierarchySeparator;
			if (m_bSubscribeInbox)
			{
				m_aSubMboxLiteralFullName = INET_IMAP_CANONIC_INBOX_NAME;
				cHierarchySeparator = '\0';
				m_bSubscribeInbox = false;
			}
			else if (!m_aAutoSscrbMboxList.iter(false,
												getMboxLiteralFullName(),
												m_aSubMboxLiteralFullName,
												cHierarchySeparator))
			{
				m_nState = STATE_DONE;
				return EXEC_CONTINUE;
			}

			m_aSubMboxURL
				= CntIMAPURL::createMboxURL(m_aAcntURL,
											m_aSubMboxLiteralFullName,
											cHierarchySeparator);

			++m_nState;
			return handleCommandFailure(clientCommandSubscribe(
				                            m_aSubMboxLiteralFullName));
		}

		case STATE_RECV_SUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							{
								CntNodeRef xSubMboxNode
									= getAcnt().getNode().
									      Query(m_aSubMboxURL);
									// query at acnt because of INBOX
								if (xSubMboxNode.Is())
								{
									static_cast< CntIMAPMboxNode * >(
										    &xSubMboxNode)->
										getMbox().initialize(getJob());
									static_cast< CntIMAPMboxNode * >(
										    &xSubMboxNode)->
										getMbox().storeProperty(
											          getJob(),
													  CntBoolItem(
														  WID_FLAG_SUBSCRIBED,
														  true));
									if (xSubMboxNode->GetParent()
										    == &getMbox().getNode())
									{
										m_bModifiedSubscribed = true;
										if (listSubMbox(*xSubMboxNode))
											getJob().
												Result(xSubMboxNode,
													   CNT_ACTION_INSERTED);
									}
								}
							}
							case INetIMAPStateResponse::STATE_NO:
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								--m_nState;
								return EXEC_CONTINUE;
						}
					break;
				}
			}
			break;

		case STATE_DONE:
			if (!m_bAutoSubscribeChecked && m_xMboxDirNode.Is())
				static_cast< CntStorageNode * >(m_xMboxDirNode->GetParent())->
					attrib(m_aMboxURL, 0,
						   CNTDIRENTRY_ATTRIB_IMAP_MBOX_AUTO_CHECKED);

			if (getJob().GetClient())
			{
				if (getJob().GetRequest()->Which() == WID_UPDATE
					|| getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
				{
					if (m_bModifiedSubscribed)
						getJob().GetClient()->
							Broadcast(CntFolderStateHint(
								          std::numeric_limits< ULONG >::max(),
										  CNTFOLDER_SUBSCR));
					getJob().GetClient()->
						Broadcast(CntFolderStateHint(m_nNewSubMboxCount,
													 CNTFOLDER_NEW));
				}
				if (getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
					getJob().GetClient()->
						Broadcast(CntFolderStateHint(m_nRemovedSubMboxCount,
													 CNTFOLDER_REMOVED));
			}

			done();
			return EXEC_DONE;

		case STATE_START_OFFLINE:
			if (m_bOfflineDone)
			{
				cancel();
				return EXEC_DONE;
			}

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_OPENING_FOLDER), 0,
									  m_nProgressMax);
				m_nProgress = 0;
			}

			startTimeSlice();

			while (m_pMboxDirIter)
			{
				String aIterID
					= static_cast< CntStorageNode * >(&m_xMboxDirNode)->
					      iter(*m_pMboxDirIter);
				if (m_pMboxDirIter->eof())
				{
					delete m_pMboxDirIter;
					m_pMboxDirIter = 0;
					break;
				}

				if ((**m_pMboxDirIter).m_nAttrib
					    & CNTDIRENTRY_ATTRIB_IMAP_MBOX)
				{
					if (m_bListSubMboxs
						&& (m_eListSubMboxsMode == CNT_VIEW_ALL_FOLDERS
							|| (**m_pMboxDirIter).m_nAttrib
							       & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD)
						&& CntIMAPURL::isDirectSubMboxURL(m_aMboxURL,
														  aIterID))
					{
						CntNodeRef xSubMboxNode
							= getMbox().getNode().Query(aIterID);
						if (xSubMboxNode.Is())
						{
							static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
								getMbox().initialize(getJob());

							if (listSubMbox(*xSubMboxNode))
							{
								if (m_bUpdate
									&& ITEMSET_VALUE(xSubMboxNode,
													 CntBoolItem,
													 WID_FLAG_SUBSCRIBED))
									m_aSscrbdSubMboxList.add(aIterID);

								switch (getJob().GetRequest()->Which())
								{
									case WID_OPEN:
									case WID_SEARCH:
										if (m_bUpdate
											&& static_cast
											           < CntIMAPMboxNode * >(
														   &xSubMboxNode)->
											       getMbox().getSelect())
											m_aSelectSubMboxList.add(aIterID);

										getJob().Result(xSubMboxNode);
										if (getJob().GetRequest()->Which()
											    == WID_SEARCH)
											getJob().ResultSearchMatch(
												         xSubMboxNode);
										break;

									case WID_SYNCHRONIZE:
										m_aSyncSubMboxList.add(aIterID);
										break;
								}
							}
						}

						++m_nProgress;
					}
				}
				else if (getJob().GetRequest()->Which() != WID_UPDATE)
				{
					sal_uInt32 nUIDValidity;
					sal_uInt32 nMesgUID;
					if (m_bListMesgs
						&& CntIMAPMesgNode::isMesgDirID(aIterID, nUIDValidity,
														nMesgUID))
					{
						bool bList;
						switch (m_eListMesgsMode)
						{
							case CNT_VIEW_ALL_ARTICLES:
								bList = true;
								++m_nProgress;
								break;

							case CNT_VIEW_UNREAD_ARTICLES:
								bList
									= !((**m_pMboxDirIter).m_nAttrib
										 & CNTDIRENTRY_ATTRIB_IMAP_MESG_READ);
								if (bList)
									++m_nProgress;
								break;

							case CNT_VIEW_READ_ARTICLES:
								bList
									= ((**m_pMboxDirIter).m_nAttrib
									      & CNTDIRENTRY_ATTRIB_IMAP_MESG_READ)
									      != 0;
								if (bList)
									++m_nProgress;
								break;

							case CNT_VIEW_MARKED_ARTICLES:
								bList
									= ((**m_pMboxDirIter).m_nAttrib
									    & CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED)
									      != false;
								if (bList)
									++m_nProgress;
								break;

							case CNT_VIEW_MARKED_AND_UNREAD_ARTICLES:
								bList
									= ((**m_pMboxDirIter).m_nAttrib
									      & (CNTDIRENTRY_ATTRIB_IMAP_MESG_READ
									   | CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED))
								         != CNTDIRENTRY_ATTRIB_IMAP_MESG_READ;
								++m_nProgress;
								break;
						}

						if (bList)
						{
							String aMesgURL
								= CntIMAPURL::createMesgURL(m_aMboxURL,
															nUIDValidity,
															nMesgUID);
							CntNodeRef xMesgNode
								= getMbox().getNode().Query(aMesgURL);
							if (xMesgNode.Is())
							{
								static_cast< CntIMAPMesgNode * >(&xMesgNode)->
									initialize(getJob());

								switch (getJob().GetRequest()->Which())
								{
									case WID_OPEN:
										getJob().Result(xMesgNode);
										break;

									case WID_SEARCH:
										getJob().Result(xMesgNode);
										getJob().ResultSearchMatch(xMesgNode);
										break;

									case WID_SYNCHRONIZE:
										m_aSyncMesgList.add(aMesgURL);
										break;
								}
							}
						}
					}
				}

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			popStatusInformation();
			m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

			m_bOfflineDone = true;

			if (m_bUpdate || !m_bCompleteMesgs
				|| !m_bCompleteSubscribedSubMboxs || !m_bCompleteSubMboxs
				|| m_bAutoSubscribe)
			{
				m_nState = STATE_GO_ONLINE;
				return EXEC_CONTINUE;
			}
			else
			{
				done();
				return EXEC_DONE;
			}

		case STATE_GO_ONLINE:
			if (CntIMAPSelectTask::initialize())
			{
				m_nState = STATE_RESTART_ONLINE;
				return EXEC_CONTINUE;
			}

			if ((getJob().GetRequest()->Which() == WID_OPEN
				 || getJob().GetRequest()->Which() == WID_SEARCH)
				/*&& m_bCompleteMesgs && m_bCompleteSubscribedSubMboxs
				&& m_bCompleteSubMboxs*/)
			{
				done();
				return EXEC_DONE;
			}

			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;

				default:
					done();
					return EXEC_DONE;
			}

		default:
			return CntIMAPSelectTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPMboxGetSubMboxsTask
//
//============================================================================

void CntIMAPMboxGetSubMboxsTask::finish()
{
	getMbox().getNode().Put(CntFolderListItem(WID_NEWS_GROUPLIST,
											  m_pSubMboxList));
	m_pSubMboxList = 0;
	done();
}

//============================================================================
// virtual
void CntIMAPMboxGetSubMboxsTask::beingCanceled()
{
	delete m_pMboxDirIter;
	if (m_pSubMboxList)
	{
		while (m_pSubMboxList->Count())
			delete m_pSubMboxList->Remove(m_pSubMboxList->Count() - 1);
		delete m_pSubMboxList;
	}
	super::beingCanceled();
}

//============================================================================
// virtual
bool CntIMAPMboxGetSubMboxsTask::initialize()
{
	m_aAcntURL = OWN_URL(&getAcnt().getNode());
	m_aMboxURL = OWN_URL(&getMbox().getNode());
	m_xMboxDirNode = getMbox().getDirNode(getJob());

	m_bSubscribedSubMboxsOnly
		= static_cast< CntFolderListItem const * >(getJob().GetRequest())->
		          getCommand()
		      == CntFolderListItem::GET_SUBSCRIBED;

	sal_uInt32 nMboxDirAttribs = 0;
	if (m_xMboxDirNode.Is())
		static_cast< CntStorageNode * >(m_xMboxDirNode->GetParent())->
			attrib(m_aMboxURL, 0, 0, nMboxDirAttribs);

	m_bCompleteSubscribedSubMboxs
		= (nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD_MBOXS) != 0;
	m_bCompleteSubMboxs
		= (nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_MBOXS) != 0;

	if (m_xMboxDirNode.Is())
		m_pMboxDirIter = new CntStorageIterator(CNTDIRENTRY_ATTRIB_IMAP_MBOX);
	m_pSubMboxList = new CntFolderList;

	m_bOfflineDone = false;
	m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxGetSubMboxsTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_LSUB:
		{
			if (m_bCompleteSubscribedSubMboxs)
			{
				m_nState = STATE_SEND_LIST;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			ByteString aPattern(getMboxLiteralFullName());
			aPattern += getHierarchySeparator();
			aPattern += INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandLSub(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LSUB:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (m_xMboxDirNode.Is())
							static_cast< CntStorageNode * >(m_xMboxDirNode->
															    GetParent())->
								attrib(
									m_aMboxURL, 0,
								   CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD_MBOXS);
						if (getMbox().getNode().
							        GetItemState(WID_IMAP_SSCRBD_MBOX_COUNT,
												 false)
							    != SFX_ITEM_SET)
							getMbox().
								storeProperty(getJob(),
											  CntUInt32Item(
												  WID_IMAP_SSCRBD_MBOX_COUNT,
												  0));

						popStatusInformation();

						m_nState = STATE_SEND_LIST;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rSubMbox
							= rListResponse.getMailbox(i);
						ByteString aSubMboxLiteralFullName;
						if (isDirectSubMbox(getMboxLiteralFullName(),
											rSubMbox,
											aSubMboxLiteralFullName))
						{
							String
								aSubMboxURL(CntIMAPURL::createMboxURL(
									            m_aAcntURL,
												aSubMboxLiteralFullName,
												rSubMbox.
												    getHierarchySeparator()));
							CntNodeRef xSubMboxNode(getMbox().getNode().
													    Query(aSubMboxURL));
							if (xSubMboxNode.Is())
							{
								static_cast< CntIMAPMboxNode * >(
									    &xSubMboxNode)->
									getMbox().initialize(getJob(), true,
														 &rSubMbox, true,
														 false);

								ByteString
									aSubMboxLiteralLastName(
										CntIMAPURL::getMboxLiteralLastName(
											aSubMboxURL));
								String aSubMboxTitle(
									       CntIMAPUTF7::translateFromUTF7(
											   aSubMboxLiteralLastName,
											   false));
								String
									aSubMboxID(aSubMboxLiteralLastName,
											   RTL_TEXTENCODING_ISO_8859_1);
								ULONG nIndex;
								if (m_pSubMboxList->find(aSubMboxTitle,
														 aSubMboxID, nIndex))
									m_pSubMboxList->
										GetObject(nIndex)->Subscribe();
								else
									m_pSubMboxList->
										Insert(new CntFolderEntry(
											           aSubMboxTitle,
													   aSubMboxID, sal_True));
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_LIST:
		{
			if (m_bSubscribedSubMboxsOnly || m_bCompleteSubMboxs)
			{
				finish();
				return EXEC_DONE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			ByteString aPattern(getMboxLiteralFullName());
			aPattern += getHierarchySeparator();
			aPattern += INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandList(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (m_xMboxDirNode.Is())
							static_cast< CntStorageNode * >(m_xMboxDirNode->
															    GetParent())->
								attrib(m_aMboxURL, 0,
									   CNTDIRENTRY_ATTRIB_IMAP_MBOX_MBOXS);
						if (getMbox().getNode().
							        GetItemState(WID_IMAP_MBOX_COUNT, false)
							    != SFX_ITEM_SET)
							getMbox().storeProperty(getJob(),
													CntUInt32Item(
														WID_IMAP_MBOX_COUNT,
														0));

						popStatusInformation();

						finish();
						return EXEC_DONE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rSubMbox
							= rListResponse.getMailbox(i);
						ByteString aSubMboxLiteralFullName;
						if (isDirectSubMbox(getMboxLiteralFullName(),
											rSubMbox,
											aSubMboxLiteralFullName))
						{
							String
								aSubMboxURL(CntIMAPURL::createMboxURL(
									            m_aAcntURL,
												aSubMboxLiteralFullName,
												rSubMbox.
												    getHierarchySeparator()));
							CntNodeRef xSubMboxNode(getMbox().getNode().
													    Query(aSubMboxURL));
							if (xSubMboxNode.Is())
							{
								static_cast< CntIMAPMboxNode * >(
									    &xSubMboxNode)->
									getMbox().initialize(getJob(), true,
														 &rSubMbox, false,
														 false);

								ByteString
									aSubMboxLiteralLastName(
										CntIMAPURL::getMboxLiteralLastName(
											aSubMboxURL));
								m_pSubMboxList->
									Insert(
										new CntFolderEntry(
											   CntIMAPUTF7::translateFromUTF7(
													aSubMboxLiteralLastName,
													false),
												String(
													aSubMboxLiteralLastName,
											   RTL_TEXTENCODING_ISO_8859_1)));
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_START_OFFLINE:
			if (m_bOfflineDone)
			{
				cancel();
				return EXEC_DONE;
			}

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_OPENING_FOLDER), 0,
									  ITEMSET_VALUE(&getMbox().getNode(),
													CntUInt32Item,
													WID_IMAP_MBOX_COUNT));
				m_nProgress = 0;
			}

			startTimeSlice();

			while (m_pMboxDirIter)
			{
				String
					aIterID(static_cast< CntStorageNode * >(&m_xMboxDirNode)->
							    iter(*m_pMboxDirIter));
				if (m_pMboxDirIter->eof())
				{
					delete m_pMboxDirIter;
					m_pMboxDirIter = 0;
					break;
				}

				if (CntIMAPURL::isDirectSubMboxURL(m_aMboxURL, aIterID))
				{
					bool bSubscribed
						= ((**m_pMboxDirIter).m_nAttrib
						           & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD)
					          != 0;
					if (bSubscribed || !m_bSubscribedSubMboxsOnly)
					{
						ByteString
							aSubMboxLiteralLastName(
								CntIMAPURL::getMboxLiteralLastName(aIterID));
						CntFolderEntry * pEntry
							= new CntFolderEntry(
								      CntIMAPUTF7::translateFromUTF7(
										  aSubMboxLiteralLastName, false),
									  String(aSubMboxLiteralLastName,
											 RTL_TEXTENCODING_ISO_8859_1));
						USHORT nFlags = bSubscribed ? CNTFOLDER_SUBSCR : 0;
						if ((**m_pMboxDirIter).m_nAttrib
							    & CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW)
							nFlags |= CNTFOLDER_NEW;
						if ((**m_pMboxDirIter).m_nAttrib
							    & CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED)
							nFlags |= CNTFOLDER_REMOVED;
						pEntry->SetFlags(nFlags);
						m_pSubMboxList->Insert(pEntry);
					}

					++m_nProgress;
				}

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			m_bOfflineDone = true;

			if (!(m_bCompleteSubscribedSubMboxs && m_bCompleteSubMboxs)
				&& getMbox().getInferiors() && getHierarchySeparator())
			{
				m_nState = STATE_GO_ONLINE;
				return EXEC_CONTINUE;
			}

			finish();
			return EXEC_DONE;

		case STATE_GO_ONLINE:
			if (CntIMAPSeparatorTask::initialize())
			{
				m_nState = STATE_RESTART_ONLINE;
				return EXEC_CONTINUE;
			}

			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;

				default:
					finish();
					return EXEC_DONE;
			}

		default:
			return CntIMAPSeparatorTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPMboxSetSubMboxsTask
//
//============================================================================

// virtual
void CntIMAPMboxSetSubMboxsTask::end()
{
	if (m_pSubMboxList)
	{
		while (m_pSubMboxList->Count() != 0)
			delete m_pSubMboxList->Remove(m_pSubMboxList->Count() - 1);
		delete m_pSubMboxList;
	}
	super::end();
}

//============================================================================
// virtual
bool CntIMAPMboxSetSubMboxsTask::initialize()
{
	m_pSubMboxList
		= static_cast< CntFolderListItem const * >(getJob().GetRequest())->
		      takeList();
	if (!m_pSubMboxList || m_pSubMboxList->Count() == 0)
	{
		done();
		return false;
	}

	m_aMboxURL = OWN_URL(&getMbox().getNode());
	m_xMboxDirNode = getMbox().getDirNode(getJob());

	m_bOnlineProlog = false;
	m_bGoOnline = true;
	m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxSetSubMboxsTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_SUBSCRIBE:
		{
			m_bOnlineProlog = false;

			ByteString aSubMboxLiteralFullName;
			if (!(getHierarchySeparator()
				  && CntIMAPURL::getMboxLiteralFullName(
					     m_aSubMboxURL, getHierarchySeparator(),
						 aSubMboxLiteralFullName)))
			{
				m_nState = STATE_START_OFFLINE;
				return EXEC_CONTINUE;
			}

			++m_nState;
			return handleCommandFailure(m_bSubscribe ?
										    clientCommandSubscribe(
												aSubMboxLiteralFullName) :
										    clientCommandUnSubscribe(
												aSubMboxLiteralFullName));
		}

		case STATE_RECV_SUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						static_cast< CntIMAPMboxNode * >(&m_xSubMboxNode)->
							getMbox().storeProperty(getJob(),
													CntBoolItem(
														WID_FLAG_SUBSCRIBED,
														m_bSubscribe));

						progressStatusInformation(m_nProgress);

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_START_OFFLINE;
						return EXEC_RESCHEDULE;
					}
					break;
				}
			}
			break;

		case STATE_START_OFFLINE:
			if (m_bOnlineProlog)
			{
				m_bOnlineProlog = false;
				m_bGoOnline = false;
			}

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_UPDATING_SUBFOLDERS), 0,
									  m_pSubMboxList ?
									      m_pSubMboxList->Count() : 0);
				m_nProgress = 0;
			}

			startTimeSlice();

			while (m_pSubMboxList->Count() != 0)
			{
				CntFolderEntry * pEntry
					= m_pSubMboxList->Remove(m_pSubMboxList->Count() - 1);
				m_aSubMboxURL = CntIMAPURL::createSubMboxURL(
					                m_aMboxURL,
									ByteString(pEntry->getID(),
											   RTL_TEXTENCODING_ISO_8859_1));
				m_bSubscribe = pEntry->IsSubscribed() != false;
				USHORT nFlags = pEntry->GetFlags();
				delete pEntry;

				m_xSubMboxNode = getMbox().getNode().Query(m_aSubMboxURL);
				if (m_xSubMboxNode.Is())
				{
					static_cast< CntIMAPMboxNode * >(&m_xSubMboxNode)->
						getMbox().initialize(getJob());

					if (m_xMboxDirNode.Is())
					{
						sal_uInt32 nClearMask = 0;
						sal_uInt32 nSetMask = 0;
						if (nFlags & CNTFOLDER_NEW)
							nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW;
						else
							nClearMask |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW;
//						if (nFlags & CNTFOLDER_REMOVED)
//							nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED;
//						else
//							nClearMask
//						        |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED;
						static_cast< CntStorageNode * >(&m_xMboxDirNode)->
							attrib(m_aSubMboxURL, nClearMask, nSetMask);
					}

					if (m_bGoOnline
						&& m_bSubscribe
						       != (ITEMSET_VALUE(m_xSubMboxNode, CntBoolItem,
												 WID_FLAG_SUBSCRIBED)
								       != false))
					{
						m_nState = STATE_GO_ONLINE;
						return EXEC_CONTINUE;
					}
				}

				++m_nProgress;

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			done();
			return EXEC_DONE;

		case STATE_GO_ONLINE:
			m_bOnlineProlog = true;

			if (CntIMAPSeparatorTask::initialize())
			{
				m_nState = STATE_RESTART_ONLINE;
				return EXEC_CONTINUE;
			}

			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;

				default:
					progressStatusInformation(++m_nProgress);
					return EXEC_RESCHEDULE;
			}

		default:
			return CntIMAPSeparatorTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

