/*************************************************************************
 *
 *  $RCSfile: imapmbxt.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPMBXT_HXX
#define CHAOS_IMAPMBXT_HXX

#include <set>

#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif

#ifndef CHAOS_IMAPTASK_HXX
#include <imaptask.hxx>
#endif

namespace chaos {

class CntFolderList;

//============================================================================
class CntIMAPMboxOpenTask: public CntIMAPSelectTask
{
	typedef CntIMAPSelectTask super;

	enum { STATE_SEND_SEARCH = STATE_START_ONLINE, STATE_RECV_SEARCH,
		   STATE_SEND_FETCH, STATE_RECV_FETCH, STATE_SEND_FETCH_BODY,
		   STATE_RECV_FETCH_BODY, STATE_SEND_LSUB, STATE_RECV_LSUB,
		   STATE_UNSUBSCRIBE, STATE_SEND_LIST, STATE_RECV_LIST,
		   STATE_SEND_SELECT, STATE_RECV_SELECT, STATE_SYNC_MESGS,
		   STATE_SYNC_SUB_MBOXS, STATE_SEND_CHECK_LIST, STATE_RECV_CHECK_LIST,
		   STATE_ASK_AUTO_SUBSCRIBE, STATE_SEND_SUBSCRIBE,
		   STATE_RECV_SUBSCRIBE, STATE_DONE, STATE_GO_ONLINE };

	String m_aAcntURL;
	String m_aMboxURL;
	CntIMAPMboxList m_aSelectSubMboxList;
	CntIMAPMboxList m_aSscrbdSubMboxList;
	CntIMAPMesgURLList m_aSyncMesgList;
	CntIMAPMboxList m_aSyncSubMboxList;
	CntIMAPMboxHierList m_aAutoSscrbMboxList;
	String m_aSubMboxURL;
	ByteString m_aSubMboxLiteralFullName;
	CntIMAPMesgUIDList m_aMesgUIDs;
	CntNodeRef m_xMboxDirNode;
	CntStorageIterator * m_pMboxDirIter;
	INetIMAPMessageNumberSet * m_pMesgUIDSet;
	ULONG m_nProgressMax;
	ULONG m_nProgress;
	ULONG m_nMesgBodyProgress;
	sal_uInt32 m_nSubMboxMesgCount;
	sal_uInt32 m_nMesgUID;
	sal_uInt32 m_nLMesgCount;
	sal_uInt32 m_nLSMesgCount;
	sal_uInt32 m_nReadMesgCount;
	sal_uInt32 m_nMarkedMesgCount;
	sal_uInt32 m_nSubMboxCount;
	sal_uInt32 m_nSscrbdSubMboxCount;
	sal_uInt32 m_nNewSubMboxCount;
	sal_uInt32 m_nRemovedSubMboxCount;
	CntMsgViewMode m_eListMesgsMode;
	CntFolderViewMode m_eListSubMboxsMode;
	bool m_bListMesgs;
	bool m_bListSubMboxs;
	bool m_bCompleteMesgs;
	bool m_bCompleteSubscribedSubMboxs;
	bool m_bCompleteSubMboxs;
	bool m_bUpdate;
	bool m_bOfflineDone;
	bool m_bSubMboxHasMesgCount;
	bool m_bHasMesgDataCacheStream;
	bool m_bModifiedSubscribed;
	bool m_bAutoSubscribeChecked;
	bool m_bAutoSubscribe;
	bool m_bSubscribeInbox;
	bool m_bFound;

	bool listSubMbox(CntNode & rSubMboxNode);

	void removeMesgDataCacheStream();

	DECL_LINK(streamCallback, INetIMAPFetchResponseBodySection const *);

	virtual void beingCanceled();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	inline CntIMAPMboxOpenTask(CntNodeJob & rJob, CntIMAPMbox & rMbox);
};

inline CntIMAPMboxOpenTask::CntIMAPMboxOpenTask(CntNodeJob & rJob,
												CntIMAPMbox & rMbox):
	CntIMAPSelectTask(rJob, rMbox, true),
	m_pMboxDirIter(0),
	m_pMesgUIDSet(0),
	m_bHasMesgDataCacheStream(false)
{}

//============================================================================
class CntIMAPMboxGetSubMboxsTask: public CntIMAPSeparatorTask
{
	typedef CntIMAPSeparatorTask super;

	enum { STATE_SEND_LSUB = STATE_START_ONLINE, STATE_RECV_LSUB,
		   STATE_SEND_LIST, STATE_RECV_LIST, STATE_GO_ONLINE };

	String m_aAcntURL;
	String m_aMboxURL;
	CntNodeRef m_xMboxDirNode;
	CntStorageIterator * m_pMboxDirIter;
	CntFolderList * m_pSubMboxList;
	ULONG m_nProgress;
	bool m_bSubscribedSubMboxsOnly;
	bool m_bCompleteSubscribedSubMboxs;
	bool m_bCompleteSubMboxs;
	bool m_bOfflineDone;

	void finish();

	virtual void beingCanceled();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	inline CntIMAPMboxGetSubMboxsTask(CntNodeJob & rJob, CntIMAPMbox & rMbox);
};

inline
CntIMAPMboxGetSubMboxsTask::CntIMAPMboxGetSubMboxsTask(CntNodeJob & rJob,
													   CntIMAPMbox & rMbox):
	CntIMAPSeparatorTask(rJob, rMbox),
	m_pMboxDirIter(0),
	m_pSubMboxList(0)
{}

//============================================================================
class CntIMAPMboxSetSubMboxsTask: public CntIMAPSeparatorTask
{
	typedef CntIMAPSeparatorTask super;

	enum { STATE_SEND_SUBSCRIBE = STATE_START_ONLINE, STATE_RECV_SUBSCRIBE,
		   STATE_GO_ONLINE };

	String m_aMboxURL;
	CntNodeRef m_xMboxDirNode;
	String m_aSubMboxURL;
	CntNodeRef m_xSubMboxNode;
	CntFolderList * m_pSubMboxList;
	ULONG m_nProgress;
	bool m_bOnlineProlog;
	bool m_bGoOnline;
	bool m_bSubscribe;

	virtual void end();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMboxSetSubMboxsTask(CntNodeJob & rJob, CntIMAPMbox & rMbox):
		CntIMAPSeparatorTask(rJob, rMbox), m_pSubMboxList(0) {}
};

//============================================================================
class CntIMAPMboxRenameTask: public CntIMAPSeparatorTask
{
	typedef CntIMAPSeparatorTask super;

	enum { STATE_SEND_CLOSE = STATE_START_ONLINE, STATE_RECV_CLOSE,
		   STATE_SEND_RENAME, STATE_RECV_RENAME, STATE_SEND_LSUB,
		   STATE_RECV_LSUB, STATE_SEND_LIST, STATE_RECV_LIST,
		   STATE_SEND_UNSUBSCRIBE, STATE_RECV_UNSUBSCRIBE,
		   STATE_SEND_SUBSCRIBE, STATE_RECV_SUBSCRIBE };

	std::set< ByteString > m_aSscrbdMboxs;
	std::set< ByteString >::const_iterator m_aSscrbdMboxIter;
	String m_aAcntURL;
	String m_aNewMboxURL;
	ByteString m_aNewMboxLiteralFullName;
	sal_Char m_cNewHierarchySeparator;
	bool m_bNewHierarchySeparatorDetermined;

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMboxRenameTask(CntNodeJob & rJob, CntIMAPMbox & rMbox):
		CntIMAPSeparatorTask(rJob, rMbox) {}
};

//============================================================================
class CntIMAPMboxCreateTask: public CntIMAPOnlineTask
{
	typedef CntIMAPOnlineTask super;

	enum { STATE_SEND_LIST_ROOT = STATE_START_ONLINE, STATE_RECV_LIST_ROOT,
		   STATE_SEND_CREATE, STATE_RECV_CREATE, STATE_SEND_LIST_CREATED,
		   STATE_RECV_LIST_CREATED };

	String m_aMboxURL;
	ByteString m_aMboxLiteralLastName;
	ByteString m_aPattern;
	CntNodeRef m_xExchangedMbox;
	CntIMAPMbox * m_pMbox;
	sal_Char m_cHierarchySeparator;
	bool m_bHierarchySeparatorDetermined;
	bool m_bFound;

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMboxCreateTask(CntNodeJob & rJob, CntIMAPMbox & rTheMbox);
};

//============================================================================
class CntIMAPMboxTransferTask: public CntIMAPSelectTask
{
	typedef CntIMAPSelectTask super;

	enum { STATE_SWITCH = STATE_START_ONLINE, STATE_SEND_APPEND,
		   STATE_RECV_APPEND, STATE_SEND_TARGET_LIST, STATE_RECV_TARGET_LIST,
		   STATE_SEND_COPY, STATE_RECV_COPY, STATE_UPDATE };

	String m_aTargetMboxURL;
	ByteString m_aTargetRootLiteralName;
	CntNodeRef m_xSourceMboxNode;
	CntIMAPMbox & m_rTargetMbox;
	sal_uInt32 m_nSourceMesgUID;
	INetIMAPListResponseMailbox::Flags m_eTargetRootMboxFlags;
	sal_Char m_cTargetHierarchySeparator;
	bool m_bAppend;
	bool m_bTargetHierarchySeparatorDetermined;

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMboxTransferTask(CntNodeJob & rJob, CntIMAPMbox & rMbox):
		CntIMAPSelectTask(rJob, rMbox), m_rTargetMbox(rMbox) {}
};

//============================================================================
class CntIMAPMboxDeleteTask: public CntIMAPSeparatorTask
{
	typedef CntIMAPSeparatorTask super;

	enum { STATE_SEND_LIST = STATE_START_ONLINE, STATE_RECV_LIST,
		   STATE_SEND_CLOSE, STATE_RECV_CLOSE, STATE_SEND_UNSUBSCRIBE,
		   STATE_RECV_UNSUBSCRIBE, STATE_SEND_DELETE, STATE_RECV_DELETE,
		   STATE_REMOVE_BODIES, STATE_GO_ONLINE };

	String m_aAcntURL;
	CntIMAPMboxNodeList m_aMboxNodes;
	CntNodeRef m_xCurrentMboxNode;
	String m_aCurrentMboxURL;
	ByteString m_aCurrentMboxLiteralFullName;
	CntNodeRef m_xCurrentMboxDirNode;
	CntIMAPMboxNodeListEntry * m_pCurrentMbox;
	CntStorageIterator * m_pCurrentMboxDirIter;
	ULONG m_nProgress;
	bool m_bGoOnline;
	bool m_bOnline;

	virtual void beingCanceled();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMboxDeleteTask(CntNodeJob & rJob, CntIMAPMbox & rMbox):
		CntIMAPSeparatorTask(rJob, rMbox), m_pCurrentMboxDirIter(0) {}
};

//============================================================================
class CntIMAPMboxUnDeleteTask: public CntIMAPOfflineTask
{
	typedef CntIMAPOfflineTask super;

	CntIMAPMbox & m_rMbox;

	virtual bool executeTimeSlice(bool);

public:
	CntIMAPMboxUnDeleteTask(CntNodeJob & rJob, CntIMAPMbox & rTheMbox);
};

//============================================================================
class CntIMAPMboxFlagMesgsTask: public CntIMAPSelectTask
{
	typedef CntIMAPSelectTask super;

	enum { STATE_SEND_FETCH = STATE_START_ONLINE, STATE_RECV_FETCH,
		   STATE_SEND_STORE, STATE_RECV_STORE, STATE_FLAG };

	String m_aMboxURL;
	CntNodeRef m_xMboxDirNode;
	bool m_bOfflineDone;

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMboxFlagMesgsTask(CntNodeJob & rJob, CntIMAPMbox & rMbox):
		CntIMAPSelectTask(rJob, rMbox), m_bOfflineDone(false) {}
};

//============================================================================
class CntIMAPMboxSubscribeTask: public CntIMAPSeparatorTask
{
	typedef CntIMAPSeparatorTask super;

	enum { STATE_SEND_SUBSCRIBE = STATE_START_ONLINE, STATE_RECV_SUBSCRIBE };

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPMboxSubscribeTask(CntNodeJob & rJob, CntIMAPMbox & rMbox):
		CntIMAPSeparatorTask(rJob, rMbox) {}
};

//============================================================================
class CntIMAPMboxStoreMesgBodiesTask: public CntIMAPOfflineTask
{
	typedef CntIMAPOfflineTask super;

	CntNodeJobRef m_xSubJob;
	ULONG m_nIndex;

	virtual bool executeTimeSlice(bool bFirst);

	virtual void notification(SfxBroadcaster & rBroadcaster,
							  SfxHint const & rHint);

public:
	CntIMAPMboxStoreMesgBodiesTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt):
		CntIMAPOfflineTask(rJob, *rJob.GetSubject(), rAcnt) {}
};

}

#endif // CHAOS_IMAPMBXT_HXX

