/*************************************************************************
 *
 *  $RCSfile: imaptask.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_IMAPCLNT_HXX
#include <inet/imapclnt.hxx>
#endif
#ifndef _INET_CONFIG_HXX
#include <inet/inetcfg.hxx>
#endif
#ifndef _EINF_HXX
#include <tools/errinf.hxx>
#endif
#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _CNTINET_HXX
#include <cntinet.hxx>
#endif
#ifndef _CNTRESIS_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef CHAOS_IMAPMITM_HXX
#include <imapmitm.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPTASK_HXX
#include <imaptask.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntIMAPStatusInformation
//
//============================================================================

CntIMAPStatusInformation::CntIMAPStatusInformation(SfxBroadcaster &
												    rBroadcaster,
												   String const & rTheText,
												   Tag eTheTag,
												   bool bThePopOnError,
												   CntIMAPStatusInformation *
												    pTheNext):
	m_aText(rTheText),
	m_nID(0),
	m_eTag(eTheTag),
	m_bPopOnError(bThePopOnError),
	m_eState(STATE_ENABLED),
	m_pNext(pTheNext)
{
	rBroadcaster.Broadcast(CntStatusBarHint(m_aText));
}

//============================================================================
CntIMAPStatusInformation::CntIMAPStatusInformation(SfxBroadcaster &
												    rBroadcaster,
												   String const & rTheText,
												   ULONG nTheProgressMin,
												   ULONG nTheProgressMax,
												   Tag eTheTag,
												   bool bThePopOnError,
												   CntIMAPStatusInformation *
												    pTheNext):
	m_aText(rTheText),
	m_eTag(eTheTag),
	m_bPopOnError(bThePopOnError),
	m_eState(STATE_ENABLED),
	m_pNext(pTheNext)
{
	DBG_ASSERT
	 (nTheProgressMin <= nTheProgressMax,
	  "CntIMAPStatusInformation::CntIMAPStatusInformation(): min > max");

	// Avoid problems with status bars with progress range [0..0]:
	if (nTheProgressMax)
	{
		m_nID = CntStatusBarHint::CreateHintId();
		m_nProgressMin = nTheProgressMin;
		m_nProgressMax = nTheProgressMax;
		m_nProgress = nTheProgressMin;
		rBroadcaster.Broadcast(CntStatusBarHint(m_nID, m_nProgressMin,
												m_nProgressMax, m_aText));
	}
	else
	{
		m_nID = 0;
		rBroadcaster.Broadcast(CntStatusBarHint(m_aText));
	}
}

//============================================================================
void CntIMAPStatusInformation::disable(SfxBroadcaster & rBroadcaster)
{
	if (m_eState == STATE_ENABLED)
	{
		if (m_nID)
			rBroadcaster.Broadcast(CntStatusBarHint(m_nID));
		m_eState = STATE_DISABLED;
	}
}

//============================================================================
void CntIMAPStatusInformation::enable(SfxBroadcaster & rBroadcaster)
{
	if (m_eState == STATE_DISABLED)
	{
		if (m_nID)
		{
			m_nID = CntStatusBarHint::CreateHintId();
			rBroadcaster.Broadcast(CntStatusBarHint(m_nID, m_nProgressMin,
													m_nProgressMax, m_aText));
			rBroadcaster.Broadcast(CntStatusBarHint(m_nID, m_nProgress));
		}
		else
			rBroadcaster.Broadcast(CntStatusBarHint(m_aText));
		m_eState = STATE_ENABLED;
	}
}

//============================================================================
void CntIMAPStatusInformation::changeText(SfxBroadcaster & rBroadcaster,
										  String const & rTheText)
{
	if (m_eState != STATE_CLEARED && rTheText != m_aText)
	{
		m_aText = rTheText;
		if (m_eState == STATE_ENABLED)
			if (m_nID)
			{
				rBroadcaster.Broadcast(CntStatusBarHint(m_nID));
				m_nID = CntStatusBarHint::CreateHintId();
				rBroadcaster.Broadcast(CntStatusBarHint(m_nID, m_nProgressMin,
														m_nProgressMax,
														m_aText));
				rBroadcaster.Broadcast(CntStatusBarHint(m_nID, m_nProgress));
			}
			else
				rBroadcaster.Broadcast(CntStatusBarHint(m_aText));
	}
}

//============================================================================
void CntIMAPStatusInformation::progress(SfxBroadcaster & rBroadcaster,
										ULONG nTheProgress)
{
	if (m_eState != STATE_CLEARED && m_nID)
	{
		if (nTheProgress > m_nProgressMax)
			nTheProgress = m_nProgressMax;
		if (nTheProgress > m_nProgress)
		{
			m_nProgress = nTheProgress;
			if (m_eState == STATE_ENABLED)
				rBroadcaster.Broadcast(CntStatusBarHint(m_nID, m_nProgress));
		}
	}
}

//============================================================================
void CntIMAPStatusInformation::clear(SfxBroadcaster & rBroadcaster)
{
	if (m_eState == STATE_ENABLED)
		if (m_nID)
			rBroadcaster.Broadcast(CntStatusBarHint(m_nID));
		else
			rBroadcaster.Broadcast(CntStatusBarHint(String()));
	m_eState = STATE_CLEARED;
}

//============================================================================
//
//  CntIMAPTask
//
//============================================================================

void CntIMAPTask::finished(bool bCanceled)
{
	if (bCanceled)
		beingCanceled();
	end();
	clearStatusInformation();
}

//============================================================================
void CntIMAPTask::pushStatusInformation(String const & rText,
										CntIMAPStatusInformation::Tag eTag,
										bool bPopOnError)
{
	if (m_pStatusInformations)
		m_pStatusInformations->disable(getJob());
	m_pStatusInformations
	 = new CntIMAPStatusInformation(getJob(), rText, eTag, bPopOnError,
									m_pStatusInformations);
}

//============================================================================
void CntIMAPTask::pushStatusInformation(String const & rText,
										ULONG nProgressMin,
										ULONG nProgressMax,
										CntIMAPStatusInformation::Tag eTag,
										bool bPopOnError)
{
	if (m_pStatusInformations)
		m_pStatusInformations->disable(getJob());
	m_pStatusInformations
	 = new CntIMAPStatusInformation(getJob(), rText, nProgressMin,
									nProgressMax, eTag, bPopOnError,
									m_pStatusInformations);
}

//============================================================================
void CntIMAPTask::setStatusInformation(String const & rText,
									   CntIMAPStatusInformation::Tag eTag)
{
	if (m_pStatusInformations && m_pStatusInformations->getTag() == eTag)
		m_pStatusInformations->changeText(getJob(), rText);
	else
		pushStatusInformation(rText, eTag);
}

//============================================================================
void CntIMAPTask::changeStatusInformation(String const & rText)
{
	if (m_pStatusInformations)
		m_pStatusInformations->changeText(getJob(), rText);
}

//============================================================================
void CntIMAPTask::progressStatusInformation(ULONG nProgress)
{
	if (m_pStatusInformations)
		m_pStatusInformations->progress(getJob(), nProgress);
}

//============================================================================
void CntIMAPTask::popStatusInformation(CntIMAPStatusInformation::Tag eTag)
{
	if (m_pStatusInformations
		&& (eTag == CntIMAPStatusInformation::TAG_NONE
			|| m_pStatusInformations->getTag() == eTag))
	{
		CntIMAPStatusInformation * pInformation = m_pStatusInformations;
		m_pStatusInformations = pInformation->getNext();
		pInformation->clear(getJob());
		delete pInformation;

		if (m_pStatusInformations)
			m_pStatusInformations->enable(getJob());
	}
}

//============================================================================
void CntIMAPTask::popStatusInformationOnError()
{
	if (m_pStatusInformations && m_pStatusInformations->doPopOnError())
		popStatusInformation();
}

//============================================================================
void CntIMAPTask::clearStatusInformation()
{
	if (m_pStatusInformations)
	{
		CntIMAPStatusInformation * pInformation = m_pStatusInformations;
		m_pStatusInformations = pInformation->getNext();
		pInformation->clear(getJob());
		delete pInformation;

		while (m_pStatusInformations)
		{
			pInformation = m_pStatusInformations;
			m_pStatusInformations = pInformation->getNext();
			delete pInformation;
		}
		m_pStatusInformations = 0;
	}
}

//============================================================================
// static
CntIMAPTask::ErrorResponse CntIMAPTask::handleErrorNoTask(ErrCode nError)
{
	switch (nError)
	{
		case ERRCODE_NONE:
		case ERRCODE_IO_PENDING:
			return ERROR_RESPONSE_NONE;

		case ERRCODE_ABORT:
			return ERROR_RESPONSE_CANCELED;

		default:
			switch (CntRootNodeMgr::Get()->HandleError(nError, 0))
			{
				case ERRCODE_BUTTON_OK:
				case ERRCODE_BUTTON_NO: //@@@ is this ok?
					return ERROR_RESPONSE_IGNORE;

				default:
					DBG_ERROR("CntIMAPOnlineTask::handleErrorNoTask():"
							      " Invalid button");
				case ERRCODE_BUTTON_CANCEL:
					return ERROR_RESPONSE_ABORT;

				case ERRCODE_BUTTON_RETRY:
				case ERRCODE_BUTTON_YES: //@@@ is this ok?
					return ERROR_RESPONSE_RETRY;
			}
	}
}

//============================================================================
//
//  CntIMAPOfflineTask
//
//============================================================================

// virtual
SfxPoolItem const * CntIMAPOfflineTask::execute()
{
	startTimeSlice();
	bool bFirst = m_bInitial;
	m_bInitial = false;
	if (executeTimeSlice(bFirst))
		reschedule();
	return 0;
}

//============================================================================
//
//  CntIMAPOnlineTask
//
//============================================================================

IMPL_LINK(CntIMAPOnlineTask, clientCallback, INetIMAPResponse const *,
		  pResponse)
{
	vos::ORef< ThreadTask > xThis(this);
	SfxPoolItem const * pItem = 0;
	if (wakeUp())
	{
		pItem = executeCallback(pResponse);
		sleep();
	}
	return reinterpret_cast< long >(pItem);
}

//============================================================================
SfxPoolItem const *
CntIMAPOnlineTask::executeCallback(INetIMAPResponse const * pResponse)
{
	bool bCallBase = false;
	for (;;)
	{
		Execution eExecution = executeState(pResponse);
		if (pResponse && !(eExecution & EXEC_BIT_HANDLED))
			eExecution = Execution(eExecution | defaultCallback(*pResponse));
		pResponse = 0;
		if (eExecution & EXEC_BIT_BASE)
			bCallBase = true;
		if (eExecution & EXEC_BIT_RESCHEDULE)
			reschedule();
		if (eExecution & EXEC_BIT_DONE)
			break;
	}
	return bCallBase ? getJob().GetSubject()->CntNode::ExecuteJob(&getJob()) :
		               0;
}

//============================================================================
CntIMAPOnlineTask::Execution
CntIMAPOnlineTask::defaultCallback(INetIMAPResponse const & rResponse)
{
	switch (rResponse.getType())
	{
		case INetIMAPResponse::TYPE_CLOSED:
			if (m_bToClose)
			{
				cancel();
				return EXEC_DONE;
			}
			else
				switch (handleError(
					        *new StringErrorInfo(
								     ERRCODE_CHAOS_IMAP_CONNECTION_CLOSED,
									 ITEMSET_VALUE(&getAcnt().getNode(),
												   CntStringItem,
												   WID_SERVERNAME))))
				{
					case ERROR_RESPONSE_ABORT:
						cancel();
					case ERROR_RESPONSE_CANCELED:
						return EXEC_DONE;

					case ERROR_RESPONSE_RETRY:
						m_nState = STATE_RESTART_ONLINE;
						return EXEC_CONTINUE;

					default:
						m_nState = STATE_START_OFFLINE;
						return EXEC_CONTINUE;
				}

		case INetIMAPResponse::TYPE_ERROR:
			switch (handleError(static_cast< INetIMAPErrorResponse const * >(
				                        &rResponse)->
								    getError()))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					m_nState = STATE_RESTART_ONLINE;
					return EXEC_CONTINUE;

				default:
					m_nState = STATE_START_OFFLINE;
					return EXEC_CONTINUE;
			}

		case INetIMAPResponse::TYPE_INVALID:
		case INetIMAPResponse::TYPE_CONTINUE_CODE:
			switch (handleError(
				        *new TwoStringErrorInfo(
							     ERRCODE_CHAOS_IMAP_BAD_RESPONSE,
								 ITEMSET_VALUE(&getAcnt().getNode(),
											   CntStringItem, WID_SERVERNAME),
								 static_cast< INetIMAPTextResponse const * >(
									     &rResponse)->
								     getText(),
								 ERRCODE_BUTTON_OK_CANCEL
								     | ERRCODE_MSG_ERROR)))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				default:
					m_nState = STATE_START_OFFLINE;
					return EXEC_CONTINUE;
			}

		case INetIMAPResponse::TYPE_STATE:
		{
			INetIMAPStateResponse const & rStateResponse
				= *static_cast< INetIMAPStateResponse const * >(&rResponse);

			// At least the 'mail.footprint.de IMAP4rev1 v11.240 server' keeps
			// sending response lines like "* NO [UIDNOTSTICKY] ...", so don't
			// raise error boxes for untaged NO responses:
			if (rStateResponse.getState() == INetIMAPStateResponse::STATE_OK
				|| m_bToClose
				   && rStateResponse.getState()
				          == INetIMAPStateResponse::STATE_BYE
				|| rStateResponse.getState()
				       == INetIMAPStateResponse::STATE_NO
				   && !rStateResponse.isFinal())
			{
				Execution eExecution = handleAlertResponse(rStateResponse);
				return eExecution == EXEC_NOTHING ? EXEC_DONE : eExecution;
			}
			else
				switch (handleError(
					        *new TwoStringErrorInfo(
								     ERRCODE_CHAOS_IMAP_SERVER_MSG,
									 ITEMSET_VALUE(&getAcnt().getNode(),
												   CntStringItem,
												   WID_SERVERNAME),
									 rStateResponse.getText(),
									 rStateResponse.isFinal() ?
									     ERRCODE_BUTTON_OK_RETRY_CANCEL
									         | ERRCODE_MSG_ERROR :
									     ERRCODE_BUTTON_OK_CANCEL
									         | ERRCODE_MSG_ERROR)))
				{
					case ERROR_RESPONSE_ABORT:
						cancel();
					case ERROR_RESPONSE_CANCELED:
						return EXEC_DONE;

					case ERROR_RESPONSE_RETRY:
						if (rStateResponse.isFinal())
						{
							if (getAcnt().getClient()->hasClosedConnection())
								m_nState = STATE_RESTART_ONLINE;
							else
								--m_nState;
							return EXEC_CONTINUE;
						}
						else
							return EXEC_DONE;

					default:
						if (rStateResponse.isFinal())
						{
							m_nState = STATE_START_OFFLINE;
							return EXEC_CONTINUE;
						}
						else
							return EXEC_DONE;
				}
		}

		default:
			return EXEC_DONE;
	}
}

//============================================================================
CntIMAPOnlineTask::CntIMAPOnlineTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt,
									 bool bTheToClose):
	CntIMAPTask(rJob, rAcnt.getNode(), rAcnt),
#if !defined USE_JOB_DISPATCHER
	m_nInitialReschedule(0),
#endif // USE_JOB_DISPATCHER
	m_bToClose(bTheToClose),
	m_bClientAcquired(false),
	m_nState(STATE_INITIALIZE)
{}

//============================================================================
// virtual
void CntIMAPOnlineTask::beingCanceled()
{
	if (m_bClientAcquired && getAcnt().getClient())
		getAcnt().getClient()->cancelCommand();
	super::beingCanceled();
}

//============================================================================
// virtual
void CntIMAPOnlineTask::end()
{
	if (m_bClientAcquired)
		getAcnt().releaseClient();
	super::end();
}

//============================================================================
void CntIMAPOnlineTask::done()
{
	if (m_bClientAcquired)
	{
		getAcnt().releaseClient();
		m_bClientAcquired = false;
	}
	ThreadTask::done();
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandCapability()
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandCapability(getClientCallback(),
												   getClientResponseData());
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandNoOp()
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandNoOp(getClientCallback(),
											 getClientResponseData());
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandLogOut()
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandLogOut(getClientCallback(),
											   getClientResponseData());
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandLogIn(String const & rUserID,
											  String const & rPassword)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandLogIn(getClientCallback(),
											  getClientResponseData(),
											  rUserID, rPassword);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandSelect(ByteString const &
											       rMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandSelect(getClientCallback(),
											   getClientResponseData(),
											   rMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandExamine(ByteString const &
												    rMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandExamine(getClientCallback(),
												getClientResponseData(),
												rMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandCreate(ByteString const &
											       rMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandCreate(getClientCallback(),
											   getClientResponseData(),
											   rMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandDelete(ByteString const &
											       rMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandDelete(getClientCallback(),
											   getClientResponseData(),
											   rMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandRename(ByteString const &
											       rOldMailboxName,
											   ByteString const &
											       rNewMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandRename(getClientCallback(),
											   getClientResponseData(),
											   rOldMailboxName,
											   rNewMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandSubscribe(ByteString const &
												      rMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandSubscribe(getClientCallback(),
												  getClientResponseData(),
												  rMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandUnSubscribe(ByteString const &
													    rMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandUnSubscribe(getClientCallback(),
													getClientResponseData(),
													rMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandList(ByteString const & rReference,
											 ByteString const & rPattern)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandList(getClientCallback(),
											 getClientResponseData(),
											 rReference, rPattern);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandLSub(ByteString const & rReference,
											 ByteString const & rPattern)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandLSub(getClientCallback(),
											 getClientResponseData(),
											 rReference, rPattern);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandStatus(ByteString const &
											       rMailboxName,
											   INetIMAPStatusAttributes
											       eAttributes)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandStatus(getClientCallback(),
											   getClientResponseData(),
											   rMailboxName, eAttributes);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandAppend(ByteString const &
											       rMailboxName,
											   ByteString const &
											       rRFC822Header,
											   ByteString const & rMediaType,
											   SvStream * pBody)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandAppend(getClientCallback(),
											   getClientResponseData(),
											   rMailboxName, rRFC822Header,
											   rMediaType, pBody);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandAppend(ByteString const &
											       rMailboxName,
											   SvStream * pMessage)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandAppend(getClientCallback(),
											   getClientResponseData(),
											   rMailboxName, pMessage);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandCheck()
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandCheck(getClientCallback(),
											  getClientResponseData());
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandClose()
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandClose(getClientCallback(),
											  getClientResponseData());
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandExpunge()
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandExpunge(getClientCallback(),
												getClientResponseData());
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandSearch(bool bUIDCommand,
											   rtl_TextEncoding eCharset,
											   INetIMAPSearchKeyList const &
											       rKeys)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandSearch(getClientCallback(),
											   getClientResponseData(),
											   bUIDCommand, eCharset, rKeys);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode
CntIMAPOnlineTask::clientCommandFetch(bool bUIDCommand,
									  INetIMAPMessageNumberSet const &
									      rMessageNumberSet,
									  INetIMAPClient::FetchAttributes
									      eAttributes,
									  INetIMAPArgumentBodySectionList const *
									      pBodySections,
									  INetIMAPHeaderFieldListList const *
									      pRFC822HeaderLines,
									  Link const & rStreamCallback)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandFetch(getClientCallback(),
											  getClientResponseData(),
											  bUIDCommand, rMessageNumberSet,
											  eAttributes, pBodySections,
											  pRFC822HeaderLines,
											  rStreamCallback);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandStore(bool bUIDCommand,
											  INetIMAPMessageNumberSet const &
											      rMessageNumberSet,
											  INetIMAPClient::StoreAttribute
											      eAttribute,
											  INetIMAPFlags eFlags,
											  INetIMAPFlagKeywordList const *
											      pFlagKeywords)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandStore(getClientCallback(),
											  getClientResponseData(),
											  bUIDCommand, rMessageNumberSet,
											  eAttribute, eFlags,
											  pFlagKeywords);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandCopy(bool bUIDCommand,
											 INetIMAPMessageNumberSet const &
											     rMessageNumberSet,
											 ByteString const & rMailboxName)
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandCopy(getClientCallback(),
											 getClientResponseData(),
											 bUIDCommand, rMessageNumberSet,
											 rMailboxName);
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
ErrCode CntIMAPOnlineTask::clientCommandNamespace()
{
	if (!sleep())
		return ERRCODE_ABORT;
	ErrCode nError
		= getAcnt().getClient()->commandNamespace(getClientCallback(),
												  getClientResponseData());
	if (!wakeUp())
	{
		getAcnt().getClient()->cancelCommand();
		return ERRCODE_ABORT;
	}
	return nError;
}

//============================================================================
CntIMAPOnlineTask::ErrorResponse CntIMAPOnlineTask::handleError(ErrCode
																    nError,
																bool bCancel)
{
	switch (nError)
	{
		case ERRCODE_NONE:
		case ERRCODE_IO_PENDING:
			return ERROR_RESPONSE_NONE;

		case ERRCODE_ABORT:
			return ERROR_RESPONSE_CANCELED;

		default:
			return ErrorResponse(ThreadTask::handleError(nError, 0, 0,
														 bCancel));
	}
}

//============================================================================
CntIMAPOnlineTask::ErrorResponse
CntIMAPOnlineTask::handleLogInError(String const * pMessage)
{
	return ErrorResponse(ThreadTask::handleError(
		                     ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE, pMessage,
							 &getAcnt().getNode()));
}

//============================================================================
CntIMAPOnlineTask::Execution
CntIMAPOnlineTask::handleCommandFailure(ErrCode nError)
{
	switch (handleError(nError))
	{
		case ERROR_RESPONSE_ABORT:
			cancel();
		default:
			return EXEC_DONE;

		case ERROR_RESPONSE_RETRY:
			if (getAcnt().getClient()->hasClosedConnection())
			{
				clearStatusInformation();
				m_nState = STATE_RESTART_ONLINE;
			}
			else
			{
				popStatusInformationOnError();
				--m_nState;
			}
			return EXEC_CONTINUE;

		case ERROR_RESPONSE_IGNORE:
			clearStatusInformation();
			m_nState = STATE_START_OFFLINE;
			return EXEC_CONTINUE;
	}
}

//============================================================================
CntIMAPOnlineTask::Execution
CntIMAPOnlineTask::handleAlertResponse(INetIMAPCodeResponse const & rResponse)
{
	if (rResponse.getCode() == INetIMAPCodeResponse::CODE_ALERT)
		switch (handleError(
			        *new TwoStringErrorInfo(
						     ERRCODE_CHAOS_IMAP_SERVER_MSG,
							 ITEMSET_VALUE(&getAcnt().getNode(),
										   CntStringItem, WID_SERVERNAME),
							 rResponse.getText(),
							 rResponse.getType()
							     == INetIMAPResponse::TYPE_STATE
							 && static_cast< INetIMAPStateResponse const * >(
								        &rResponse)->
							        isFinal() ?
							     ERRCODE_BUTTON_OK_RETRY_CANCEL
							         | ERRCODE_MSG_ERROR :
							     ERRCODE_BUTTON_OK_CANCEL
							         | ERRCODE_MSG_ERROR)))
		{
			case ERROR_RESPONSE_ABORT:
				cancel();
			case ERROR_RESPONSE_CANCELED:
				return EXEC_DONE;

			case ERROR_RESPONSE_RETRY:
				if (getAcnt().getClient()->hasClosedConnection())
				{
					clearStatusInformation();
					m_nState = STATE_RESTART_ONLINE;
				}
				else
				{
					popStatusInformationOnError();
					--m_nState;
				}
				return EXEC_CONTINUE;
		}
	return EXEC_NOTHING;
}

//============================================================================
// virtual
bool CntIMAPOnlineTask::initialize()
{
	return getAcnt().isOnline();
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPOnlineTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_INITIALIZE:
		{
			bool bOnline = initialize();
			if (isFinished())
				return EXEC_DONE;
#if !defined USE_JOB_DISPATCHER
			else if (m_nInitialReschedule == 1)
				return EXEC_RESCHEDULE;
#endif // USE_JOB_DISPATCHER
			else
			{
				m_nState = bOnline ? STATE_ONLINE : STATE_OFFLINE;
				return EXEC_CONTINUE;
			}
		}

		case STATE_ONLINE:
		{
			//@@@ Using busy waiting via reschedule instead of waiting on a
			// condition seems to avoid deadlocks; has to be investigated
			// carefully...
			if (!m_bClientAcquired)
			{
				if (!getAcnt().acquireClient())
					return EXEC_RESCHEDULE;
				m_bClientAcquired = true;
			}

			if (!getAcnt().initializeClient(m_bToClose))
				if (m_bToClose)
				{
					cancel();
					return EXEC_DONE;
				}
				else
					switch (handleError(ERRCODE_CHAOS_BAD_INET))
					{
						case ERROR_RESPONSE_ABORT:
							cancel();
						case ERROR_RESPONSE_CANCELED:
							return EXEC_DONE;

						default:
							m_nState = STATE_START_OFFLINE;
						case ERROR_RESPONSE_RETRY:
							return EXEC_CONTINUE;
					}

			DBG_ASSERT(!getAcnt().getClient()->hasClosedConnection(),
					   "CntIMAPOnlineTask::executeState(): Invalid client");

			if (getAcnt().getClient()->hasOpenConnection())
			{
				m_nState = m_bToClose ? FURTHER_STATES :
					                    STATE_SEND_CAPABILITY;
				return EXEC_CONTINUE;
			}

			if (m_bToClose)
			{
				getAcnt().getClient()->abortConnection();
				cancel();
				return EXEC_DONE;
			}

			String aInfo(CntResId(RID_PROT_CONNECTING_TO_SERVER));
			aInfo.SearchAndReplaceAscii("$(ARG1)",
										ITEMSET_VALUE(&getAcnt().getNode(),
													  CntStringItem,
													  WID_SERVERNAME));
			setStatusInformation(aInfo,
								 CntIMAPStatusInformation::TAG_OPENING);

			String aHost;
			sal_uInt16 nPort;
			switch (handleError(getAcnt().getHostAndPort(aHost, nPort)))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				case ERROR_RESPONSE_IGNORE:
					m_nState = STATE_START_OFFLINE;
				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;
			}

			String aSocksProxyHost;
			sal_uInt16 nSocksProxyPort = 0;
			inet::INetWrapper * pWrapper;
			CntRootNodeMgr::Get()->getINetWrapper(pWrapper);
			CntINetConfig::load(pWrapper,
								CntRootNodeMgr::Get()->GetIniManager());
			inet::INetProxyConfig aProxyConfig;
			if (CntINetConfig::shouldUseProxy(
				    pWrapper, CntIMAPURL::createHostAndPortURL(aHost, nPort),
					aProxyConfig)
				&& aProxyConfig.hasSocksProxy())
			{
				aSocksProxyHost = String(aProxyConfig.getSocksProxyName());
				nSocksProxyPort = aProxyConfig.getSocksProxyPort();
			}

			m_nState = STATE_OPENING;
			if (!sleep())
				return EXEC_DONE;
			ErrCode nError
				= getAcnt().getClient()->
				      openConnection(aHost, nPort, aSocksProxyHost,
									 nSocksProxyPort,
									 getAcnt().getUnilateralClientCallback(),
									 getAcnt().
									     getUnilateralClientResponseData(),
									 getClientCallback(),
									 getClientResponseData());
			if (!wakeUp())
			{
				getAcnt().getClient()->cancelCommand();
				return EXEC_DONE;
			}
			switch (handleError(nError))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				default:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					m_nState = STATE_RESTART_ONLINE;
					return EXEC_CONTINUE;

				case ERROR_RESPONSE_IGNORE:
					m_nState = STATE_START_OFFLINE;
					return EXEC_CONTINUE;
			}
		}

		case STATE_OPENING:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_OPENING:
				{
					INetIMAPOpeningResponse const & rOpeningResponse
						= *static_cast< INetIMAPOpeningResponse const * >(
							   pResponse);

					switch (rOpeningResponse.getStatus())
					{
				 case INetIMAPOpeningResponse::STATUS_NAME_RESOLUTION_PENDING:
					case INetIMAPOpeningResponse::STATUS_NAME_RESOLUTION_DONE:
						case INetIMAPOpeningResponse::STATUS_CONNECT_PENDING:
						case INetIMAPOpeningResponse::STATUS_CONNECTED:
							return EXEC_DONE;

						case INetIMAPOpeningResponse::STATUS_READ_FAILED:
							getAcnt().getClient()->abortConnection();
				  case INetIMAPOpeningResponse::STATUS_NAME_RESOLUTION_FAILED:
						case INetIMAPOpeningResponse::STATUS_CONNECT_FAILED:
							switch (handleError(
								        *new TwoStringErrorInfo(
										 ERRCODE_CHAOS_SERVER_CONNECT_FAILURE,
												 String::CreateFromAscii(
												   RTL_CONSTASCII_STRINGPARAM(
														 "IMAP")),
												 ITEMSET_VALUE(
													 &getAcnt().getNode(),
													 CntUnencodedStringItem,
													 WID_SERVERNAME))))
							{
								case ERROR_RESPONSE_ABORT:
									cancel();
								case ERROR_RESPONSE_CANCELED:
									return EXEC_DONE;

								case ERROR_RESPONSE_RETRY:
									m_nState = STATE_RESTART_ONLINE;
									return EXEC_CONTINUE;

								default:
									m_nState = STATE_START_OFFLINE;
									return EXEC_CONTINUE;
							}
					}
					break;
				}

				case INetIMAPResponse::TYPE_INVALID:
				case INetIMAPResponse::TYPE_CONTINUE_CODE:
					getAcnt().getClient()->abortConnection();
					switch (handleError(
						        *new TwoStringErrorInfo(
									     ERRCODE_CHAOS_IMAP_BAD_RESPONSE,
										 ITEMSET_VALUE(&getAcnt().getNode(),
													   CntStringItem,
													   WID_SERVERNAME),
										 static_cast
										     < INetIMAPTextResponse const * >(
												 pResponse)->
										     getText(),
										 ERRCODE_BUTTON_OK_CANCEL
										     | ERRCODE_MSG_ERROR)))
					{
						case ERROR_RESPONSE_ABORT:
							cancel();
						case ERROR_RESPONSE_CANCELED:
							return EXEC_DONE;

						case ERROR_RESPONSE_RETRY:
							m_nState = STATE_RESTART_ONLINE;
							return EXEC_CONTINUE;

						default:
							m_nState = STATE_START_OFFLINE;
							return EXEC_CONTINUE;
					}

				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					switch (rStateResponse.getState())
					{
						case INetIMAPStateResponse::STATE_OK:
						case INetIMAPStateResponse::STATE_PREAUTH:
						{
							if (rStateResponse.getCode()
								    == INetIMAPCodeResponse::CODE_ALERT)
								switch (handleError(
									        *new TwoStringErrorInfo(
												ERRCODE_CHAOS_IMAP_SERVER_MSG,
													 ITEMSET_VALUE(
														 &getAcnt().getNode(),
														 CntStringItem,
														 WID_SERVERNAME),
													 rStateResponse.getText(),
												ERRCODE_BUTTON_OK_RETRY_CANCEL
													    | ERRCODE_MSG_ERROR)))
								{
									case ERROR_RESPONSE_CANCELED:
										getAcnt().getClient()->
											abortConnection();
										return EXEC_DONE;

									case ERROR_RESPONSE_ABORT:
										getAcnt().getClient()->
											abortConnection();
										cancel();
										return EXEC_DONE;

									case ERROR_RESPONSE_RETRY:
										getAcnt().getClient()->
											abortConnection();
										m_nState = STATE_RESTART_ONLINE;
										return EXEC_CONTINUE;
								}

							m_nState = STATE_SEND_CAPABILITY;
							return EXEC_CONTINUE;
						}

						default:
							getAcnt().getClient()->abortConnection();
							switch (handleError(
								        *new TwoStringErrorInfo(
											    ERRCODE_CHAOS_IMAP_SERVER_MSG,
												 ITEMSET_VALUE(
													 &getAcnt().getNode(),
													 CntStringItem,
													 WID_SERVERNAME),
												 rStateResponse.getText(),
												ERRCODE_BUTTON_OK_RETRY_CANCEL
												     | ERRCODE_MSG_ERROR)))
							{
								case ERROR_RESPONSE_ABORT:
									cancel();
								case ERROR_RESPONSE_CANCELED:
									return EXEC_DONE;

								case ERROR_RESPONSE_RETRY:
									m_nState = STATE_RESTART_ONLINE;
									return EXEC_CONTINUE;

								default:
									m_nState = STATE_START_OFFLINE;
									return EXEC_CONTINUE;
							}
					}
				}
			}
			break;

		case STATE_SEND_CAPABILITY:
			if (getAcnt().getClient()->hasDeterminedCapabilities())
			{
				m_nState = STATE_AUTHENTICATE;
				return EXEC_CONTINUE;
			}

			setStatusInformation(CntResId(RID_IMAP_CAPABILITY_CHECK),
								 CntIMAPStatusInformation::TAG_OPENING);

			++m_nState;
			switch (handleError(clientCommandCapability()))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				default:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					if (getAcnt().getClient()->hasClosedConnection())
						m_nState = STATE_RESTART_ONLINE;
					else
						--m_nState;
					return EXEC_CONTINUE;

				case ERROR_RESPONSE_IGNORE:
					m_nState = STATE_AUTHENTICATE;
					return EXEC_CONTINUE;
			}

		case STATE_RECV_CAPABILITY:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							{
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								m_nState = STATE_AUTHENTICATE;
								return EXEC_CONTINUE;
							}

							case INetIMAPStateResponse::STATE_NO:
							case INetIMAPStateResponse::STATE_BAD:
								switch (handleError(
									        *new TwoStringErrorInfo(
												ERRCODE_CHAOS_IMAP_SERVER_MSG,
													 ITEMSET_VALUE(
														 &getAcnt().getNode(),
														 CntStringItem,
														 WID_SERVERNAME),
													 rStateResponse.getText(),
												ERRCODE_BUTTON_OK_RETRY_CANCEL
													    | ERRCODE_MSG_ERROR)))
								{
									case ERROR_RESPONSE_ABORT:
										cancel();
									case ERROR_RESPONSE_CANCELED:
										return EXEC_DONE;

									case ERROR_RESPONSE_RETRY:
										if (getAcnt().getClient()->
											    hasClosedConnection())
											m_nState = STATE_RESTART_ONLINE;
										else
											--m_nState;
										return EXEC_CONTINUE;

									default:
										m_nState = STATE_AUTHENTICATE;
										return EXEC_CONTINUE;
								}
						}
					break;
				}
			}
			break;

		case STATE_AUTHENTICATE:
		{
			if (!getAcnt().getClient()->hasDeterminedCapabilities()
				|| !(getAcnt().getClient()->getCapabilities()
					  & (INetIMAPClient::CAPABILITY_IMAP4
						  | INetIMAPClient::CAPABILITY_IMAP4REV1)))
				switch (handleError(*new StringErrorInfo(
					                         ERRCODE_CHAOS_IMAP_NOT_IMAP4,
											 ITEMSET_VALUE(&getAcnt().
														        getNode(),
														   CntStringItem,
														   WID_SERVERNAME))))
				{
					case ERROR_RESPONSE_ABORT:
						cancel();
					case ERROR_RESPONSE_CANCELED:
						return EXEC_DONE;

					case ERROR_RESPONSE_RETRY:
						getAcnt().getClient()->abortConnection();
						m_nState = STATE_RESTART_ONLINE;
						return EXEC_CONTINUE;

					case ERROR_RESPONSE_IGNORE:
						m_nState = STATE_START_OFFLINE;
						return EXEC_CONTINUE;
				}

			if (getAcnt().getClient()->isAuthenticated())
			{
				popStatusInformation(CntIMAPStatusInformation::TAG_OPENING);

				m_nState = FURTHER_STATES;
				return EXEC_CONTINUE;
			}

			setStatusInformation(CntResId(RID_PROT_SENDING_LOGIN_INFORMATION),
								 CntIMAPStatusInformation::TAG_OPENING);

			bool bHasUserIDAndAuthType;
			String aUserID;
			String aPassword;
			getAcnt().getUserIDAndPassword(bHasUserIDAndAuthType, aUserID,
										   aPassword);
			if (!bHasUserIDAndAuthType || aPassword.Len() == 0)
				switch (handleLogInError())
				{
					case ERROR_RESPONSE_ABORT:
						cancel();
					case ERROR_RESPONSE_CANCELED:
						return EXEC_DONE;

					case ERROR_RESPONSE_RETRY:
						if (getAcnt().getClient()->hasClosedConnection())
							m_nState = STATE_RESTART_ONLINE;
						else
							m_nState = STATE_SEND_LOGIN;
						return EXEC_CONTINUE;

					case ERROR_RESPONSE_IGNORE:
						m_nState = STATE_START_OFFLINE;
						return EXEC_CONTINUE;
				}

			m_nState = STATE_SEND_LOGIN;
			return EXEC_CONTINUE;
		}

		case STATE_SEND_LOGIN:
		{
			bool bHasUserIDAndAuthType;
			String aUserID;
			String aPassword;
			getAcnt().getUserIDAndPassword(bHasUserIDAndAuthType, aUserID,
										   aPassword);

			++m_nState;
			return handleCommandFailure(clientCommandLogIn(aUserID,
														   aPassword));
		}

		case STATE_RECV_LOGIN:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							{
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								popStatusInformation(
									CntIMAPStatusInformation::TAG_OPENING);

								m_nState = FURTHER_STATES;
								return EXEC_CONTINUE;
							}

							case INetIMAPStateResponse::STATE_NO:
							case INetIMAPStateResponse::STATE_BAD:
							{
								String aText(rStateResponse.getText());
								switch (handleLogInError(&aText))
								{
									case ERROR_RESPONSE_ABORT:
										cancel();
									case ERROR_RESPONSE_CANCELED:
										return EXEC_DONE;

									case ERROR_RESPONSE_RETRY:
										if (getAcnt().getClient()->
											    hasClosedConnection())
											m_nState = STATE_RESTART_ONLINE;
										else
											--m_nState;
										return EXEC_CONTINUE;

									default:
										m_nState = STATE_START_OFFLINE;
										return EXEC_CONTINUE;
								}
							}
						}
					break;
				}
			}
			break;

		default:
			done();
			return EXEC_DONE;
	}

	return EXEC_UNHANDLED;
}

//============================================================================
// static
bool CntIMAPOnlineTask::isRootMbox(INetIMAPListResponseMailbox const & rMbox,
								   ByteString & rMboxCanonicLiteralFullName)
{
	if (rMbox.getMailboxName().Len() > 0)
	{
		xub_StrLen nSeparator
			= rMbox.getHierarchySeparator() == '\0' ?
			      STRING_NOTFOUND :
			      rMbox.getMailboxName().Search(rMbox.getHierarchySeparator(),
												1);
		if (nSeparator >= rMbox.getMailboxName().Len() - 1)
		{
			rMboxCanonicLiteralFullName
				= rMbox.getMailboxName().Copy(0,
											  nSeparator == 0 ?
											      1 : nSeparator);
			if (INetMIME::equalIgnoreCase(rMboxCanonicLiteralFullName,
										  INET_IMAP_CANONIC_INBOX_NAME))
				rMboxCanonicLiteralFullName = INET_IMAP_CANONIC_INBOX_NAME;
			return true;
		}
	}
	return false;
}

//============================================================================
// static
bool CntIMAPOnlineTask::isDirectSubMbox(ByteString const &
										    rMboxCanonicLiteralFullName,
										INetIMAPListResponseMailbox const &
										    rSubMbox,
										ByteString &
										    rSubMboxCanonicLiteralFullName)
{
	if (rSubMbox.getHierarchySeparator() != '\0'
		&& rSubMbox.getMailboxName().Len()
		       >= rMboxCanonicLiteralFullName.Len() + 2
		&& rSubMbox.getMailboxName().GetChar(rMboxCanonicLiteralFullName.
											     Len())
		       == rSubMbox.getHierarchySeparator()
		&& rMboxCanonicLiteralFullName.Match(rSubMbox.getMailboxName())
		       == STRING_MATCH)
	{
		xub_StrLen nSeparator
			= rSubMbox.getMailboxName().Search(rSubMbox.
											       getHierarchySeparator(),
											   rMboxCanonicLiteralFullName.
											           Len()
											       + 1);
		if (nSeparator == STRING_NOTFOUND
			|| nSeparator == rSubMbox.getMailboxName().Len() - 1
			   && rSubMbox.getMailboxName().Len()
			          > rMboxCanonicLiteralFullName.Len() + 2)
		{
			rSubMboxCanonicLiteralFullName = rMboxCanonicLiteralFullName;
			rSubMboxCanonicLiteralFullName
				+= rSubMbox.getMailboxName().
				       Copy(rMboxCanonicLiteralFullName.Len(),
							nSeparator == STRING_NOTFOUND ?
							    STRING_LEN :
							    nSeparator
							        - rMboxCanonicLiteralFullName.Len());
			return true;
		}
	}
	return false;
}

//============================================================================
// static
bool CntIMAPOnlineTask::isSubMbox(ByteString const &
								      rFldrCanonicLiteralFullName,
								  INetIMAPListResponseMailbox const &
								      rSubMbox,
								  ByteString & rSubMboxCanonicLiteralFullName)
{
	if (rFldrCanonicLiteralFullName.Len() == 0)
	{
		if (rSubMbox.getMailboxName().Len() > 0)
		{
			xub_StrLen nFirstSeparator
				= rSubMbox.getHierarchySeparator() == '\0' ?
				      STRING_NOTFOUND :
				      rSubMbox.getMailboxName().
				          Search(rSubMbox.getHierarchySeparator(), 1);
			rSubMboxCanonicLiteralFullName
				= rSubMbox.getMailboxName().Copy(0, nFirstSeparator);
			if (INetMIME::equalIgnoreCase(rSubMboxCanonicLiteralFullName,
										  INET_IMAP_CANONIC_INBOX_NAME))
				rSubMboxCanonicLiteralFullName = INET_IMAP_CANONIC_INBOX_NAME;
			xub_StrLen nFinalSeparator
				= rSubMbox.getHierarchySeparator() == '\0'
				  || rSubMbox.getMailboxName().Len() == 1 ?
				      rSubMbox.getMailboxName().Len() :
				  rSubMbox.getMailboxName().GetChar(rSubMbox.getMailboxName().
													        Len()
													    - 1)
				          == rSubMbox.getHierarchySeparator() ?
				      rSubMbox.getMailboxName().Len() - 1 :
				      rSubMbox.getMailboxName().Len();
			rSubMboxCanonicLiteralFullName
				+= rSubMbox.getMailboxName().Copy(nFirstSeparator,
												  nFinalSeparator
												      - nFirstSeparator);
			return true;
		}
	}
	else if (rSubMbox.getHierarchySeparator() != '\0'
			 && rSubMbox.getMailboxName().Len()
			        >= rFldrCanonicLiteralFullName.Len() + 2
			 && rSubMbox.getMailboxName().GetChar(rFldrCanonicLiteralFullName.
												      Len())
			        == rSubMbox.getHierarchySeparator()
			 && rFldrCanonicLiteralFullName.Match(rSubMbox.getMailboxName())
			        == STRING_MATCH)
	{
		rSubMboxCanonicLiteralFullName = rFldrCanonicLiteralFullName;
		rSubMboxCanonicLiteralFullName
			+= rSubMbox.getMailboxName().
			       Copy(rFldrCanonicLiteralFullName.Len(),
						(rSubMbox.getMailboxName().
						                 GetChar(rSubMbox.getMailboxName().
												         Len()
												     - 1)
						             == rSubMbox.getHierarchySeparator() ?
						         rSubMbox.getMailboxName().Len() - 1 :
						         rSubMbox.getMailboxName().Len())
						    - rFldrCanonicLiteralFullName.Len());
		return true;
	}
	return false;
}

//============================================================================
//
//  CntIMAPSeparatorTask
//
//============================================================================

CntIMAPSeparatorTask::CntIMAPSeparatorTask(CntNodeJob & rJob,
										   CntIMAPMbox & rTheMbox):
	CntIMAPOnlineTask(rJob, rTheMbox.getAcnt()),
	m_pMbox(&rTheMbox),
	m_bForceDetermination(false)
{}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPSeparatorTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_LIST:
			m_bHierarchySeparatorDetermined
				= !m_bForceDetermination
				  && getMbox().hasDeterminedHierarchySeparator(
					               m_cHierarchySeparator);
			if (m_bHierarchySeparatorDetermined)
			{
				m_nState = STATE_MBOX_NAME;
				return EXEC_CONTINUE;
			}

			m_aRootLiteralName
				= CntIMAPURL::getRootLiteralName(OWN_URL(&getMbox().
														      getNode()));

			++m_nState;
			return
				handleCommandFailure(clientCommandList(ByteString(),
													   m_aRootLiteralName));

		case STATE_RECV_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						if (m_bHierarchySeparatorDetermined)
							getMbox().
								setHierarchySeparator(
									getJob(),
									!(m_eRootMboxFlags
							 & INetIMAPListResponseMailbox::FLAG_NOINFERIORS),
									!(m_eRootMboxFlags
								& INetIMAPListResponseMailbox::FLAG_NOSELECT),
									getHierarchySeparator());

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bHierarchySeparatorDetermined)
							return handleCommandFailure(
								       *new StringErrorInfo(
										        ERRCODE_CHAOS_IMAP_BAD_SERVER,
												ITEMSET_VALUE(
													&getAcnt().getNode(),
													CntStringItem,
													WID_SERVERNAME)));

						m_nState = STATE_MBOX_NAME;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rMbox
							= rListResponse.getMailbox(i);
						ByteString aMboxLiteralFullName;
						if (isRootMbox(rMbox, aMboxLiteralFullName)
							&& aMboxLiteralFullName == m_aRootLiteralName)
						{
							m_bHierarchySeparatorDetermined = true;
							m_cHierarchySeparator
								= rMbox.getHierarchySeparator();
							m_eRootMboxFlags = rMbox.getFlags();
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_MBOX_NAME:
		{
			if (!CntIMAPURL::getMboxLiteralFullName(OWN_URL(&getMbox().
															     getNode()),
													getHierarchySeparator(),
													m_aMboxLiteralFullName))
			{
				m_nState = STATE_START_OFFLINE;
				return EXEC_CONTINUE;
			}

			m_nState = FURTHER_STATES;
			return EXEC_CONTINUE;
		}

		default:
			return CntIMAPOnlineTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPSelectTask
//
//============================================================================

// virtual
void CntIMAPSelectTask::beingCanceled()
{
	delete m_pMboxDirIter;
	super::beingCanceled();
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPSelectTask::executeState(INetIMAPResponse const * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_SELECT:
			m_nUIDValidity = 0;
			m_bHasMesgCount = false;
			m_bHasRecentMesgCount = false;

			if (m_eMode == SELECT_NO
				|| m_eMode == SELECT_YES
				   && getMboxLiteralFullName()
				          == getAcnt().getClient()->getSelectedMailbox())
			{
				m_nState = FURTHER_STATES;
				return EXEC_CONTINUE;
			}

			if (!getMbox().getSelect())
			{
				m_nState = STATE_START_OFFLINE;
				return EXEC_CONTINUE;
			}

			++m_nState;
			return handleCommandFailure(clientCommandSelect(
				                            getMboxLiteralFullName()));

		case STATE_RECV_SELECT:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.getCode()
						    == INetIMAPCodeResponse::CODE_UIDVALIDITY)
						m_nUIDValidity = rStateResponse.getNumber();

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						// Some IMAP servers wrongfully send an "OK
						// [UIDVALIDITY 0]" response for initially empty
						// mailboxes, so we silently ignore a combination of
						// zero UIDValidity and zero message count:
						if (!(m_bHasMesgCount && m_bHasRecentMesgCount)
							|| !m_nUIDValidity && m_nMesgCount)
							return handleCommandFailure(
								       *new StringErrorInfo(
										        ERRCODE_CHAOS_IMAP_BAD_SERVER,
												ITEMSET_VALUE(
													&getAcnt().getNode(),
													CntStringItem,
													WID_SERVERNAME)));

						m_bBadRecentMesgCount
							= getMbox().setServerMesgCount(getJob(),
														   m_nMesgCount)
							      != m_nRecentMesgCount;

						CntIMAPMboxDataItem const & rMboxData
							= static_cast< CntIMAPMboxDataItem const & >(
								  getMbox().
								      getNode().Get(WID_IMAPFOLDERINFO));
						if (m_nUIDValidity != 0
							&& rMboxData.getUIDValidity() == 0)
						{
							CntIMAPMboxDataItem aNewMboxData = rMboxData;
							aNewMboxData.setUIDValidity(m_nUIDValidity);
							getMbox().storeProperty(getJob(), aNewMboxData);

							m_nState = FURTHER_STATES;
							return EXEC_CONTINUE;
						}
						if (m_nUIDValidity == 0
							|| m_nUIDValidity == rMboxData.getUIDValidity())
						{
							m_nState = FURTHER_STATES;
							return EXEC_CONTINUE;
						}

						m_xMboxDirNode = getMbox().getDirNode(getJob());
						if (m_xMboxDirNode.Is())
							m_pMboxDirIter
								= new CntStorageIterator(
									      0,
										  CNTDIRENTRY_ATTRIB_NOTITER
										      | CNTSTORE_ATTRIB_ISDIR
										      | CNTDIRENTRY_ATTRIB_IMAP_MBOX);

						m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

						m_nState = STATE_UIDVALIDITY_COLLECT;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_EXISTS:
					m_bHasMesgCount = true;
					m_nMesgCount
						= static_cast< INetIMAPExistsResponse const * >(
							      pResponse)->
					          getMessageCount();
					return EXEC_DONE;

				case INetIMAPResponse::TYPE_RECENT:
					m_bHasRecentMesgCount = true;
					m_nRecentMesgCount
						= static_cast< INetIMAPRecentResponse const * >(
							      pResponse)->
					          getRecentMessageCount();
					return EXEC_DONE;
			}
			break;

		case STATE_UIDVALIDITY_COLLECT:
		{
			startTimeSlice();

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_UPDATING_FOLDER), 0,
									  getMbox().getLMesgCount()
									   + getMbox().getLSMesgCount());
				m_nProgress = 0;
			}

			while (m_pMboxDirIter)
			{
				String aID(static_cast< CntStorageNode * >(&m_xMboxDirNode)->
						       iter(*m_pMboxDirIter));
				if (m_pMboxDirIter->eof())
				{
					delete m_pMboxDirIter;
					m_pMboxDirIter = 0;
					break;
				}

				sal_uInt32 nUIDValidity;
				sal_uInt32 nMesgUID;
				if (CntIMAPMesgNode::isMesgDirID(aID, nUIDValidity, nMesgUID))
				{
					if (!nUIDValidity || nUIDValidity == m_nUIDValidity)
						m_aMesgs.add(nUIDValidity, nMesgUID);

					++m_nProgress;
				}

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			popStatusInformation();
			m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

			m_nState = STATE_UIDVALIDITY_CHANGE;
			return EXEC_CONTINUE;
		}

		case STATE_UIDVALIDITY_CHANGE:
		{
			startTimeSlice();

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_UPDATING_FOLDER), 0,
									  m_aMesgs.getCount());
				m_nProgress = 0;
			}

			CntStorageNode * pCacheNode = getJob().GetCacheNode(false);
			CntIMAPMboxDataItem const & rMboxData
				= *static_cast< CntIMAPMboxDataItem const * >(
					   &getMbox().getNode().Get(WID_IMAPFOLDERINFO));
			String aMboxURL(OWN_URL(&getMbox().getNode()));

			sal_uInt32 nUIDValidity;
			sal_uInt32 nMesgUID;
			while (m_aMesgs.iter(nUIDValidity, nMesgUID))
			{
				sal_uInt32 nNewUIDValidity
					= nUIDValidity == 0 ? rMboxData.getUIDValidity() : 0;

				String aOldMesgURL(CntIMAPURL::createMesgURL(aMboxURL,
															 nUIDValidity,
															 nMesgUID));
				String aNewMesgURL(CntIMAPURL::createMesgURL(aMboxURL,
															 nNewUIDValidity,
															 nMesgUID));

				CntNodeRef xOldMesgNode(getMbox().getNode().Query(aOldMesgURL,
																  false));
				if (xOldMesgNode.Is())
				{
					getJob().Result(xOldMesgNode, CNT_ACTION_DELETED);
					xOldMesgNode = 0;
				}

				if (pCacheNode)
				{
					String aOldBodyStreamID(aOldMesgURL);
					aOldBodyStreamID.
						AppendAscii(RTL_CONSTASCII_STRINGPARAM(
							            CNT_IMAP_MESG_BODY_STREAM_ID_SUFFIX));
					String aNewBodyStreamID(aNewMesgURL);
					aNewBodyStreamID.
						AppendAscii(RTL_CONSTASCII_STRINGPARAM(
							            CNT_IMAP_MESG_BODY_STREAM_ID_SUFFIX));
					pCacheNode->rename(aOldBodyStreamID, aNewBodyStreamID);
				}

				static_cast< CntStorageNode * >(&m_xMboxDirNode)->
					rename(CntIMAPMesgNode::createMesgDirID(nUIDValidity,
															nMesgUID),
						   CntIMAPMesgNode::createMesgDirID(nNewUIDValidity,
															nMesgUID));

				CntNodeRef
					xNewMesgNode(getMbox().getNode().Query(aNewMesgURL));
				if (xNewMesgNode.Is())
				{
					static_cast< CntIMAPMesgNode * >(&xNewMesgNode)->
						initialize(getJob());
					getJob().Result(xNewMesgNode);
				}

				++m_nProgress;

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			CntIMAPMboxDataItem aNewMboxData(rMboxData);
			aNewMboxData.setUIDValidity(m_nUIDValidity);
			getMbox().storeProperty(getJob(), aNewMboxData);

			popStatusInformation();

			m_nState = FURTHER_STATES;
			return EXEC_CONTINUE;
		}

		default:
			return CntIMAPSeparatorTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPForwardTask
//
//============================================================================

// virtual
SfxPoolItem const * CntIMAPForwardTask::execute()
{
	if (m_bCancel)
		cancel();
	else
		startSubJob();
	return 0;
}

//============================================================================
// virtual
void CntIMAPForwardTask::notification(SfxBroadcaster & rBroadcaster,
									  SfxHint const & rHint)
{
	CntIMAPSubJobListEntry * pEntry = m_aSubJobs.getFirst();
	if (pEntry && &rBroadcaster == &pEntry->getSubJob())
	{
		if (pEntry->doForwardResults())
		{
			if (rHint.ISA(CntNodeHint))
			{
				switch (static_cast< CntNodeHint const * >(&rHint)->
						    GetAction())
				{
					case CNT_ACTION_RESULT:
					case CNT_ACTION_REMOVED:
						getJob().Broadcast(rHint);
						break;
				}
				return;
			}
			if (rHint.ISA(CntSearchMatchedURLHint))
			{
				getJob().Broadcast(rHint);
				return;
			}
		}
		if (rHint.ISA(CntStatusHint))
			switch (static_cast< CntStatusHint const * >(&rHint)->GetStatus())
			{
				case CNT_STATUS_DONE:
					EndListening(pEntry->getSubJob());
					m_aSubJobs.removeFirst();
					reschedule();
					break;

				case CNT_STATUS_ERROR:
					if (static_cast< CntStatusHint const * >(&rHint)->
						        GetError()
						    == ERRCODE_ABORT)
					{
						EndListening(pEntry->getSubJob());
						cancel();
					}
					break;
			}
	}
	else
		super::notification(rBroadcaster, rHint);
}

//============================================================================
void CntIMAPForwardTask::startSubJob()
{
	CntIMAPSubJobListEntry * pEntry = m_aSubJobs.getFirst();
	if (pEntry)
	{
		CntNodeJob & rSubJob = pEntry->getSubJob();
		StartListening(rSubJob);
		rSubJob.GetSubject()->InsertJob(&rSubJob);
	}
	else
	{
		finish();
		done();
	}
}

//============================================================================
void CntIMAPForwardTask::appendSubJob(CntNode & rSubject,
									  SfxPoolItem const & rRequest,
									  bool bForwardResults)
{
	m_aSubJobs.append(new CntNodeJob(&getJob(), getJob().GetClient(),
									 &rSubject, rRequest),
					  bForwardResults);
}

