/*************************************************************************
 *
 *  $RCSfile: mbx.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mhu $ $Date: 2002/06/03 19:47:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2001 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_INTERLCK_H_
#include <osl/interlck.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SOT_STORAGE_HXX
#include <sot/storage.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif

#ifndef _INETCOREMAIL_HXX
#include <inet/inetmail.hxx>
#endif

#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif

#ifndef _CNTSYS_HXX
#include "cntsys.hxx"
#endif
#ifndef _CNTMBITM_HXX
#include "cntmbitm.hxx"
#endif

#ifndef _CHAOS_EXPORT_HXX
#include "export.hxx"
#endif

#ifndef _COM_SUN_STAR_UCB_UNSUPPORTEDCOMMANDEXCEPTION_HPP_
#include <com/sun/star/ucb/UnsupportedCommandException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandProcessor.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef INCLUDED_MBX_HXX
#include "mbx.hxx"
#endif

using namespace com::sun::star;

using com::sun::star::ucb::CommandInfo;
using com::sun::star::ucb::XCommandInfo;
using com::sun::star::ucb::XCommandProcessor;
using com::sun::star::ucb::UnsupportedCommandException;

using chaos::CntSystem;
using chaos::CntExport;
using chaos::CntMessageBodyItem;

using inet::INetCoreMailer;
using rtl::OUString;

namespace chaos
{

/*========================================================================
 *
 * Mbx... internals.
 *
 *======================================================================*/
#define MSGDOC_HEADER_SIZE   4
#define NEW_MAILFILE_VERSION 2

/*
 * __getGlobalMutex_Impl.
 */
static osl::Mutex & __getGlobalMutex_Impl (void)
{
	static osl::Mutex *g_pMutex = 0;
	if (!g_pMutex)
	{
		osl::MutexGuard aGuard (osl::Mutex::getGlobalMutex());
		if (!g_pMutex)
		{
			static osl::Mutex g_aMutex;
			g_pMutex = &g_aMutex;
		}
	}
	return (*g_pMutex);
}

/*========================================================================
 *
 * MbxContext_Impl.
 *
 *======================================================================*/
class MbxContext_Impl
{
public:
	static sal_Bool get (rtl::Reference<MbxContext_Impl> & rxThis);

	oslInterlockedCount acquire (void);
	oslInterlockedCount release (void);

	sal_Bool createMessage (
		INetCoreMailer      *&rpMailer,
		INetCoreNewsMessage *&rpMessage);

	SfxItemPool & getItemPool (void)
	{
		OSL_ASSERT(m_pItemPool);
		return *m_pItemPool;
	}

protected:
	/** Construction, Destruction.
	 */
	MbxContext_Impl (void);
	virtual ~MbxContext_Impl (void);

private:
	/** The single instance.
	 */
	static MbxContext_Impl      *m_pThis;

	/** Representation.
	 */
	oslInterlockedCount          m_nRefCount;
	SfxItemPool                 *m_pItemPool;

	NAMESPACE_INET(INetWrapper)  m_aWrapper;
	INetCoreMailer              *m_pMailer;
};

/*
 * The single instance.
 */
MbxContext_Impl* MbxContext_Impl::m_pThis = 0;

/*
 * MbxContext_Impl.
 */
MbxContext_Impl::MbxContext_Impl (void)
	: m_nRefCount (0),
	  m_pItemPool (0),
	  m_pMailer   (0)
{
	m_pItemPool = CntSystem::GetItemPool();
	OSL_PRECOND(m_pItemPool, "MbxContext_Impl: No ItemPool");
}

/*
 * ~MbxContext_Impl.
 */
MbxContext_Impl::~MbxContext_Impl (void)
{
	delete m_pMailer;
	CntSystem::ReleaseItemPool();
}

/*
 * get.
 */
sal_Bool MbxContext_Impl::get (
	rtl::Reference<MbxContext_Impl> & rxThis)
{
	osl::MutexGuard aGuard (__getGlobalMutex_Impl());

	rxThis = m_pThis;
	if (!rxThis.is())
	{
		m_pThis = new MbxContext_Impl();
		rxThis  = m_pThis;
	}
	return rxThis.is();
}

/*
 * acquire.
 */
oslInterlockedCount MbxContext_Impl::acquire (void)
{
	return osl_incrementInterlockedCount (&m_nRefCount);
}

/*
 * release.
 */
oslInterlockedCount MbxContext_Impl::release (void)
{
	oslInterlockedCount result;

	result = osl_decrementInterlockedCount (&m_nRefCount);
	if (result == 0)
	{
		osl::MutexGuard aGuard (__getGlobalMutex_Impl());
		if (m_nRefCount == 0)
		{
			m_pThis = 0;
			delete this;
		}
	}
	return (result);
}

/*
 * createMessage.
 */
sal_Bool MbxContext_Impl::createMessage (
	INetCoreMailer *&rpMailer, INetCoreNewsMessage *&rpMessage)
{
	rpMailer = 0, rpMessage = 0;
	if (!m_pMailer)
	{
		osl::MutexGuard aGuard (__getGlobalMutex_Impl());
		if (!m_pMailer)
		{
			// Create Mailer instance.
			m_aWrapper.newINetCoreMailer (m_pMailer);
			OSL_POSTCOND(m_pMailer, "MbxContext_Impl: No INetMailer");
		}
	}
	if (m_pMailer)
	{
		rpMailer  = m_pMailer;
		rpMessage = m_pMailer->CreateINetCoreNewsMessage();
	}
	return (rpMailer && rpMessage);
}

/*========================================================================
 *
 * DocumentContext_Impl.
 *
 *======================================================================*/
class DocumentContext_Impl
{
public:
	inline DocumentContext_Impl (MbxContext_Impl & rContext)
		: m_rContext (rContext)
	{}

	inline ~DocumentContext_Impl (void)
	{}

	int convert (CntExport & rExport, const OUString & rUrl);

private:
	/** Representation.
	 */
	MbxContext_Impl & m_rContext;

	/** Import document as ItemSet.
	 */
	int import_Impl (SvStream & rStrm, SfxItemSet & rProps);
};

/*
 * convert.
 */
int DocumentContext_Impl::convert (
	CntExport & rExport, const OUString & rUrl)
{
	sal_Int32 k = rUrl.lastIndexOf (sal_Unicode ('.'));
	if (k > 0)
	{
		OUString aExt (rUrl.copy(k).toAsciiLowerCase());
		if (aExt.equalsAsciiL (".sdm", 4))
		{
			// Try Storage format (5.x).
			SotStorageRef xStg (new SotStorage (rUrl, STREAM_STD_READ));
			if (xStg.Is())
			{
				SotStorageStreamRef xStrm (
					xStg->OpenSotStream (
						String::CreateFromAscii("MailDocument"),
						STREAM_STD_READ));
				if (xStrm.Is())
				{
					SfxItemSet aProps (
						m_rContext.getItemPool(),
						WID_MSG_START,    WID_MSG_END,
						WID_DATE_CREATED, WID_DATE_CREATED, 0);

					if (import_Impl (*xStrm, aProps))
					{
						ErrCode eErrCode = rExport.writeMessage (aProps);
						return (eErrCode == ERRCODE_NONE);
					}
				}
			}
		}
		else if (aExt.equalsAsciiL (".smd", 4))
		{
			// Try Stream format (5.0).
			SvFileStream aStrm (rUrl, STREAM_STD_READ);
			if (aStrm.IsOpen())
			{
				SfxItemSet aProps (
					m_rContext.getItemPool(),
					WID_MSG_START,    WID_MSG_END,
					WID_DATE_CREATED, WID_DATE_CREATED, 0);

				if (import_Impl (aStrm, aProps))
				{
					ErrCode eErrCode = rExport.writeMessage (aProps);
					return (eErrCode == ERRCODE_NONE);
				}
			}
		}
	}
	return 0;
}

/*
 * import_Impl.
 */
int DocumentContext_Impl::import_Impl (SvStream & rStrm, SfxItemSet & rProps)
{
	int result = 0;

	rStrm.SetVersion (rProps.GetPool()->GetFileFormatVersion());
	rStrm.SetNumberFormatInt (NUMBERFORMAT_INT_LITTLEENDIAN);

	char cHead[MSGDOC_HEADER_SIZE];
	rStrm.Read (cHead, sizeof(cHead));

	result = ((cHead[0] == 'A') &&
			  (cHead[1] == 'N') &&
			  (cHead[2] == 'C') &&
			  (cHead[3] == 'H')    );

	if (result)
	{
		ULONG nFlags = 0, nLen = 0;
		rStrm >> nFlags;

		BOOL bNewVersion = (nFlags == NEW_MAILFILE_VERSION);
		if (bNewVersion)
		{
			rStrm >> nFlags;
			rStrm >> nLen;
		}

		String aTitle;
        rStrm.ReadByteString (aTitle);

		if (bNewVersion)
		{
			String aMsgId;
            rStrm.ReadByteString (aMsgId);

			if (nLen > rStrm.Tell())
				rStrm.Seek (nLen);
		}

		rProps.Load (rStrm, TRUE);

		INetCoreMailer *pMailer = 0; INetCoreNewsMessage *pMessage = 0;
		if (m_rContext.createMessage (pMailer, pMessage))
		{
			CntMessageBodyItem aBody (WID_MESSAGEBODY, String());
			aBody.LoadMessage (rStrm, *pMessage, pMailer);
			aBody.Set (pMessage);
			rProps.Put (aBody, aBody.Which());
		}
	}

	return (result);
}

/*========================================================================
 *
 * FolderContext_Impl.
 *
 *======================================================================*/
class FolderContext_Impl
{
public:
	inline FolderContext_Impl (MbxContext_Impl & rContext)
		: m_rContext (rContext)
	{}

	inline ~FolderContext_Impl (void)
	{}

	int convert (CntExport & rExport, const OUString & rUrl);

private:
	/** Representation.
	 */
	MbxContext_Impl & m_rContext;
};

/*
 * convert.
 */
int FolderContext_Impl::convert (
	CntExport & rExport, const OUString & rUrl)
{
	int result = 0;

	osl::Directory aDir (rUrl);
	if (aDir.open() == osl::FileBase::E_None)
	{
		osl::DirectoryItem aItem;
		while (aDir.getNextItem (aItem, 8) == osl::FileBase::E_None)
		{
			osl::FileStatus aStatus (
				FileStatusMask_Type | FileStatusMask_FileURL);

			if (!(aItem.getFileStatus (aStatus) == osl::FileBase::E_None))
				continue;
			if (!(aStatus.getFileType() == osl::FileStatus::Regular))
				continue;

			DocumentContext_Impl aContext (m_rContext);
			result += aContext.convert (rExport, aStatus.getFileURL());
		}

		aDir.close();
	}

	return (result);
}

/*========================================================================
 *
 * MbxCommandInfo_Impl implementation.
 *
 *======================================================================*/
/*
 * MbxCommandInfo_Impl.
 */
MbxCommandInfo_Impl::MbxCommandInfo_Impl (void)
	: m_aCommands (3)
{
	CommandInfo *pArray = m_aCommands.getArray();

	pArray[0].Name    = OUString::createFromAscii ("getCommandInfo");
	pArray[0].Handle  = 1;
	pArray[0].ArgType = getCppuVoidType();

	pArray[1].Name    = OUString::createFromAscii ("convertDocument");
	pArray[1].Handle  = 2;
	pArray[1].ArgType = getCppuType (
		static_cast< uno::Sequence<rtl::OUString>* >(0));

	pArray[2].Name    = OUString::createFromAscii ("convertFolder");
	pArray[2].Handle  = 3;
	pArray[2].ArgType = getCppuType (
		static_cast< uno::Sequence<rtl::OUString>* >(0));
}

/*
 * ~MbxCommandInfo_Impl.
 */
MbxCommandInfo_Impl::~MbxCommandInfo_Impl (void)
{
}

//========================================================================
// XInterface methods.
//========================================================================
/*
 * queryInterface.
 */
uno::Any SAL_CALL
MbxCommandInfo_Impl::queryInterface (const uno::Type & rType)
	throw (uno::RuntimeException)
{
	uno::Any result (cppu::queryInterface (
		rType,
		static_cast<lang::XTypeProvider*>(this),
		static_cast<XCommandInfo*>(this)));
	if (!result.hasValue())
		result = OWeakObject::queryInterface (rType);
	return (result);
}

/*
 * acquire.
 */
void SAL_CALL MbxCommandInfo_Impl::acquire (void) throw()
{
	OWeakObject::acquire();
}

/*
 * release.
 */
void SAL_CALL MbxCommandInfo_Impl::release (void) throw()
{
	OWeakObject::release();
}

//========================================================================
// XTypeProvider methods.
//========================================================================
/*
 * getTypes.
 */
uno::Sequence<uno::Type> SAL_CALL
MbxCommandInfo_Impl::getTypes (void)
	throw (uno::RuntimeException)
{
	static cppu::OTypeCollection * g_pCollection = 0;
	if (!g_pCollection)
	{
		osl::MutexGuard aGuard (__getGlobalMutex_Impl());
		if (!g_pCollection)
		{
			static cppu::OTypeCollection g_aCollection (
				getCppuType (
					static_cast<uno::Reference<lang::XTypeProvider>* >(0)),
				getCppuType (
					static_cast< uno::Reference<XCommandInfo>* >(0))
			);
			g_pCollection = &g_aCollection;
		}
	}
	return (*g_pCollection).getTypes();
}

/*
 * getImplementationId.
 */
uno::Sequence<sal_Int8> SAL_CALL
MbxCommandInfo_Impl::getImplementationId (void)
	throw (uno::RuntimeException)
{
	static cppu::OImplementationId * g_pId = 0;
	if (!g_pId)
	{
		osl::MutexGuard aGuard (__getGlobalMutex_Impl());
		if (!g_pId)
		{
			static cppu::OImplementationId g_aId (sal_False);
			g_pId = &g_aId;
		}
	}
	return (*g_pId).getImplementationId();
}

//========================================================================
// XCommandInfo methods.
//========================================================================
/*
 * getCommands.
 */
uno::Sequence<CommandInfo> SAL_CALL
MbxCommandInfo_Impl::getCommands (void)
	throw (uno::RuntimeException)
{
	return uno::Sequence<CommandInfo>(m_aCommands);
}

/*
 * getCommandInfoByName.
 */
CommandInfo SAL_CALL
MbxCommandInfo_Impl::getCommandInfoByName (const rtl::OUString & rName)
	throw (UnsupportedCommandException, uno::RuntimeException)
{
	sal_Int32 nHandle = 0;

	if (rName.compareToAscii ("getCommandInfo") == 0)
		nHandle = 1;
	else if (rName.compareToAscii ("convertDocument") == 0)
		nHandle = 2;
	else if (rName.compareToAscii ("convertFolder") == 0)
		nHandle = 3;

	if (!((0 < nHandle) && (nHandle <= m_aCommands.getLength())))
	{
		// Unknown command.
		throw UnsupportedCommandException();
	}
	return (m_aCommands.getConstArray()[nHandle - 1]);
}

/*
 * getCommandInfoByHandle.
 */
CommandInfo SAL_CALL
MbxCommandInfo_Impl::getCommandInfoByHandle (sal_Int32 nHandle)
	throw (UnsupportedCommandException, uno::RuntimeException)
{
	if (!((0 < nHandle) && (nHandle <= m_aCommands.getLength())))
	{
		// Unknown command.
		throw UnsupportedCommandException();
	}
	return (m_aCommands.getConstArray()[nHandle - 1]);
}

/*
 * hasCommandByName.
 */
sal_Bool SAL_CALL
MbxCommandInfo_Impl::hasCommandByName (const rtl::OUString & rName)
	throw (uno::RuntimeException)
{
	return ((rName.compareToAscii ("getCommandInfo")  == 0) ||
			(rName.compareToAscii ("convertDocument") == 0) ||
			(rName.compareToAscii ("convertFolder")   == 0)    );
}

/*
 * hasCommandByHandle.
 */
sal_Bool SAL_CALL
MbxCommandInfo_Impl::hasCommandByHandle (sal_Int32 nHandle)
	throw (uno::RuntimeException)
{
	return ((0 < nHandle) && (nHandle <= m_aCommands.getLength()));
}

/*========================================================================
 *
 * MbxService_Impl implementation.
 *
 *======================================================================*/
/*
 * MbxService_Impl.
 */
MbxService_Impl::MbxService_Impl (void)
	: m_xCommands (new MbxCommandInfo_Impl())
{
	MbxContext_Impl::get (m_xContext);
}

/*
 * ~MbxService_Impl.
 */
MbxService_Impl::~MbxService_Impl (void)
{
}

//========================================================================
// Factory methods.
//========================================================================
/*
 * MbxService_Impl_CreateInstance.
 */
static uno::Reference<uno::XInterface>
SAL_CALL MbxService_Impl_CreateInstance (
	const uno::Reference<lang::XMultiServiceFactory> & rxFactory)
{
	return uno::Reference<uno::XInterface> (
		static_cast<cppu::OWeakObject*>(new MbxService_Impl()));
}

/*
 * createServiceFactory.
 */
uno::Reference<lang::XSingleServiceFactory>
MbxService_Impl::createServiceFactory (
	const uno::Reference<lang::XMultiServiceFactory> & rxFactory)
{
	return uno::Reference<lang::XSingleServiceFactory>(
		cppu::createSingleFactory (
			rxFactory,
			MbxService_Impl::getImplementationName_Static(),
			MbxService_Impl_CreateInstance,
			MbxService_Impl::getSupportedServiceNames_Static()));
}

//========================================================================
// XInterface methods.
//========================================================================
/*
 * queryInterface.
 */
uno::Any SAL_CALL MbxService_Impl::queryInterface (const uno::Type & rType)
	throw (uno::RuntimeException)
{
	uno::Any result (cppu::queryInterface (
		rType,
		static_cast<lang::XTypeProvider*>(this),
		static_cast<lang::XServiceInfo*>(this),
		static_cast<XCommandProcessor*>(this)));
	if (!result.hasValue())
		result = OWeakObject::queryInterface (rType);
	return (result);
}

/*
 * acquire.
 */
void SAL_CALL MbxService_Impl::acquire (void) throw()
{
	OWeakObject::acquire();
}

/*
 * release.
 */
void SAL_CALL MbxService_Impl::release (void) throw()
{
	OWeakObject::release();
}

//========================================================================
// XTypeProvider methods.
//========================================================================
/*
 * getTypes.
 */
uno::Sequence<uno::Type> SAL_CALL MbxService_Impl::getTypes (void)
	throw (uno::RuntimeException)
{
	static cppu::OTypeCollection * g_pCollection = 0;
	if (!g_pCollection)
	{
		osl::MutexGuard aGuard (__getGlobalMutex_Impl());
		if (!g_pCollection)
		{
			static cppu::OTypeCollection g_aCollection (
				getCppuType (
					static_cast< uno::Reference<lang::XTypeProvider>* >(0)),
				getCppuType (
					static_cast< uno::Reference<lang::XServiceInfo>* >(0)),
				getCppuType (
					static_cast< uno::Reference<XCommandProcessor>* >(0))
			);
			g_pCollection = &g_aCollection;
		}
	}
	return (*g_pCollection).getTypes();
}

/*
 * getImplementationId.
 */
uno::Sequence<sal_Int8> SAL_CALL MbxService_Impl::getImplementationId (void)
	throw (uno::RuntimeException)
{
	static cppu::OImplementationId * g_pId = 0;
	if (!g_pId)
	{
		osl::MutexGuard aGuard (__getGlobalMutex_Impl());
		if (!g_pId)
		{
			static cppu::OImplementationId g_aId (sal_False);
			g_pId = &g_aId;
		}
	}
	return (*g_pId).getImplementationId();
}

//========================================================================
// XServiceInfo methods.
//========================================================================
/*
 * getImplementationName.
 */
OUString SAL_CALL MbxService_Impl::getImplementationName_Static (void)
	SAL_THROW(())
{
	return OUString (RTL_CONSTASCII_USTRINGPARAM(
		"com.sun.star.comp.chaos.MailDocumentConverter"));
}

OUString SAL_CALL MbxService_Impl::getImplementationName (void)
	throw (uno::RuntimeException)
{
	return getImplementationName_Static();
}

/*
 * getSupportedServiceNames.
 */
uno::Sequence<OUString>
SAL_CALL MbxService_Impl::getSupportedServiceNames_Static (void)
	SAL_THROW(())
{
	OUString aServiceName (RTL_CONSTASCII_USTRINGPARAM(
		"com.sun.star.chaos.MailDocumentConverter"));
	return uno::Sequence<OUString>(&aServiceName, 1);
}

uno::Sequence<OUString>
SAL_CALL MbxService_Impl::getSupportedServiceNames (void)
	throw (uno::RuntimeException)
{
	return getSupportedServiceNames_Static();
}

/*
 * supportsService.
 */
sal_Bool SAL_CALL MbxService_Impl::supportsService (
	const OUString & rServiceName)
	throw (uno::RuntimeException)
{
	uno::Sequence<OUString> aNameSeq (getSupportedServiceNames_Static());

	const OUString *pNames = aNameSeq.getConstArray();
	sal_Int32 i, n = aNameSeq.getLength();

	for (i = 0; i < n; i++)
		if (pNames[i] == rServiceName)
			return sal_True;
	return sal_False;
}

//========================================================================
// XCommandProcessor methods.
//========================================================================
/*
 * createCommandIdentifier.
 */
sal_Int32 SAL_CALL MbxService_Impl::createCommandIdentifier (void)
	throw (uno::RuntimeException)
{
	return sal_Int32(1);
}

/*
 * execute.
 */
uno::Any SAL_CALL MbxService_Impl::execute (
	const com::sun::star::ucb::Command & rCommand,
	sal_Int32                            nCommandId,
	const uno::Reference<com::sun::star::ucb::XCommandEnvironment>&)
	throw (
		uno::Exception,
		com::sun::star::ucb::CommandAbortedException,
		uno::RuntimeException)
{
	// Check command.
	sal_Int32 nCommand = rCommand.Handle;
	if (!m_xCommands->hasCommandByHandle (nCommand))
	{
		OUString aCommand (rCommand.Name);
		if (!m_xCommands->hasCommandByName (aCommand))
		{
			// Unknown command.
			throw UnsupportedCommandException();
		}
		nCommand = (m_xCommands->getCommandInfoByName (aCommand)).Handle;
	}

	uno::Any aResult;
	if (nCommand == 1)
	{
		// Deliver CommandInfo.
		aResult <<= uno::Reference<XCommandInfo>(&*m_xCommands);
		return (aResult);
	}

	// Check arguments.
	uno::Sequence<OUString> aArgs;
	if (!(rCommand.Argument >>= aArgs))
	{
		// Wrong argument type.
		throw lang::IllegalArgumentException();
	}

	sal_Int32 i, n = aArgs.getLength();
	if (!(n >= 2))
	{
		// Insufficient number of arguments.
		throw lang::IllegalArgumentException();
	}

	// Execute command.
	sal_Int32 result = 0;
	if (m_xContext.is())
	{
		String aExportName (aArgs.getConstArray()[0]);
		SvFileStream aOut (aExportName, STREAM_READWRITE | STREAM_TRUNC);
		if (aOut.IsOpen())
		{
			CntExport aExport (aOut);
			if (nCommand == 2)
			{
				// Convert document(s).
				DocumentContext_Impl aContext (*m_xContext);
				for (i = 1; i < n; i++)
				{
					OUString aEntry (aArgs.getConstArray()[i]);
					result += aContext.convert (aExport, aEntry);
				}
			}
			else
			{
				// Convert folder(s).
				FolderContext_Impl aContext (*m_xContext);
				for (i = 1; i < n; i++)
				{
					OUString aEntry (aArgs.getConstArray()[i]);
					result += aContext.convert (aExport, aEntry);
				}
			}
		}
	}

	aResult <<= result;
	return (aResult);
}

/*
 * abort.
 */
void SAL_CALL MbxService_Impl::abort (sal_Int32 nCommandId)
	throw (uno::RuntimeException)
{
	// Not implemented.
}

} // namespace chaos

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
