/*************************************************************************
 *
 *  $RCSfile: cntccitm.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTCCITM_HXX
#define _CNTCCITM_HXX

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif

namespace chaos {

//=========================================================================

class CntCmpCommandItem : public SfxPoolItem
{
private:
	rtl::OUString _aCommand;
	com::sun::star::uno::Any _aArgs;

	// Interimsloesung fuer Multiselektion
	SfxAnchorListRef _xSelection;

public:
	TYPEINFO();

	CntCmpCommandItem( USHORT nWhich = 0 )
	: SfxPoolItem( nWhich ) {}

	CntCmpCommandItem( USHORT nWhich, const rtl::OUString& rCommand )
	: SfxPoolItem( nWhich ), _aCommand( rCommand ) {}

	CntCmpCommandItem( USHORT nWhich,
					   const rtl::OUString& rCommand,
					   const com::sun::star::uno::Any& rArgs )
	: SfxPoolItem( nWhich ), _aCommand( rCommand ), _aArgs( rArgs ) {}

	inline CntCmpCommandItem( const CntCmpCommandItem& rOther );

	virtual int operator==( const SfxPoolItem& rItem ) const;
	virtual SfxPoolItem* Clone( SfxItemPool *pPool = NULL ) const;

	const rtl::OUString& GetCommand() const { return _aCommand; }
	const com::sun::star::uno::Any& GetArguments() const { return _aArgs; }

	// For compatibility only.
	CntCmpCommandItem( USHORT nWhich, const String& rCommand );

	SfxAnchorList* GetSelection() const { return &_xSelection; }
	void 		   SetSelection( SfxAnchorList* pSel ) { _xSelection = pSel; }

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
					   		 BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

//=========================================================================
inline CntCmpCommandItem::CntCmpCommandItem( const CntCmpCommandItem& rOther )
: SfxPoolItem( rOther.Which() ),
  _aCommand( rOther._aCommand ),
  _aArgs( rOther._aArgs ),
  _xSelection( rOther._xSelection )
{
}

}

#endif
