/*************************************************************************
 *
 *  $RCSfile: cntcook.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTCOOK_HXX
#define _CNTCOOK_HXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef SVTOOLS_HTTPCOOK_HXX
#include <svtools/httpcook.hxx>
#endif

namespace chaos {

class CntHTTPCookieList;

/*=======================================================================
 *
 * CntHTTPCookieList.
 *
 *=====================================================================*/
class CntHTTPCookieList : public SvRefBase, private List
{
public:
	CntHTTPCookieList (void) : List() {}
	virtual ~CntHTTPCookieList (void);

	void  Clear (void);
	ULONG Count (void) const
	{
		return List::Count();
	}

	CntHTTPCookie* GetObject (ULONG nIndex) const
	{
		return (CntHTTPCookie *)(List::GetObject (nIndex));
	}

	void Insert (CntHTTPCookie *pCookie, ULONG nIndex)
	{
		List::Insert (pCookie, nIndex);
	}

	CntHTTPCookie* Remove (ULONG nIndex)
	{
		return (CntHTTPCookie *)(List::Remove (nIndex));
	}

	BOOL operator== (const CntHTTPCookieList& rOther);

	void write (SvStream& rStrm) const;

	void read (SvStream& rStrm, bool bUnicode);
};

SV_DECL_IMPL_REF(CntHTTPCookieList);

/*=======================================================================
 *
 * CntHTTPCookiePolicy.
 *
 *=====================================================================*/
class CntHTTPCookiePolicy : public virtual SvRefBase
{
public:
	virtual BOOL shouldAcceptCookie (
		const String& rUrl,
		List&         rCookieList) = 0;

	virtual BOOL shouldUseCookie (
		const String& rUrl,
		List&         rCookieList) = 0;
};

SV_DECL_IMPL_REF(CntHTTPCookiePolicy);

/*=======================================================================
 *
 * CntHTTPCookieHint.
 *
 *=====================================================================*/
class CntHTTPCookieHint : public SfxHint
{
private:
	CntHTTPCookieRequest* m_pCookieReq;

	// Forbidden and not implemented.
	CntHTTPCookieHint (const CntHTTPCookieHint&);
	// Forbidden and not implemented.
    CntHTTPCookieHint& operator= (const CntHTTPCookieHint&);

public:
	TYPEINFO ();

    CntHTTPCookieHint (CntHTTPCookieRequest* pCookieReq)
		: m_pCookieReq (pCookieReq) {}

	CntHTTPCookieRequest* GetCookieRequest () const
	{
		return m_pCookieReq;
	}
};

/*=======================================================================
 *
 * CntHTTPCookieManager.
 *
 *=====================================================================*/
class CntHTTPCookieManager : public SvRefBase
{
private:
	USHORT                 m_nGeneralPolicy;
	CntHTTPCookieListRef   m_xCookieList;

public:
	CntHTTPCookieManager (void)
		: m_nGeneralPolicy (CNTHTTP_COOKIE_POLICY_ACCEPTED),
		  m_xCookieList    (new CntHTTPCookieList()) {}
	virtual ~CntHTTPCookieManager (void) {}

	void getCookie (
		CntHTTPCookiePolicy& rPolicy,
		const String&        rUrl,
		List&                rCookieList);

	void setCookie (
		CntHTTPCookiePolicy& rPolicy,
		const String&        rUrl,
		List&                rCookieList);

	USHORT getGeneralPolicy (void) const
	{
		return m_nGeneralPolicy;
	}
	void setGeneralPolicy (USHORT nGeneralPolicy)
	{
		m_nGeneralPolicy = nGeneralPolicy;
	}

	CntHTTPCookieList* getCookieList (void) const
	{
		return m_xCookieList;
	}
	void setCookieList (CntHTTPCookieList *pCookieList)
	{
		m_xCookieList = pCookieList;
	}

	BOOL operator== (const CntHTTPCookieManager& rOther)
	{
		return ((m_nGeneralPolicy == rOther.m_nGeneralPolicy) &&
				(*m_xCookieList   == *rOther.m_xCookieList  )    );
	}

	void write (SvStream& rStrm) const
	{
		rStrm << m_nGeneralPolicy;
		m_xCookieList->write(rStrm);
	}

	void read (SvStream& rStrm, bool bUnicode)
	{
		rStrm >> m_nGeneralPolicy;
		m_xCookieList->read(rStrm, bUnicode);
	}
};

SV_DECL_IMPL_REF(CntHTTPCookieManager);

/*=======================================================================
 *
 * CntHTTPCookieManagerItem.
 *
 *=====================================================================*/
class CntHTTPCookieManagerItem : public SfxPoolItem
{
private:
	CntHTTPCookieManagerRef m_xCookieMgr;

public:
	TYPEINFO();

	CntHTTPCookieManagerItem (
		USHORT nId = 0, CntHTTPCookieManager *pCookieMgr = NULL);

	CntHTTPCookieManagerItem (USHORT nId, SvStream& rStrm, USHORT nVersion);

	CntHTTPCookieManagerItem (const CntHTTPCookieManagerItem& rOther)
		: SfxPoolItem  (rOther.Which()),
		  m_xCookieMgr (rOther.m_xCookieMgr) {}

	virtual int operator== (const SfxPoolItem& rItem) const;

	virtual USHORT GetVersion (USHORT) const;

	virtual SfxPoolItem* Clone  (SfxItemPool *pPool = NULL) const;
	virtual SfxPoolItem* Create (SvStream& rStrm, USHORT nVersion) const;
	virtual SvStream&    Store  (SvStream& rStrm, USHORT nVersion) const;

	CntHTTPCookieManager* GetValue (void) const
	{
		return m_xCookieMgr;
	}

	void SetValue (CntHTTPCookieManager *pCookieMgr)
	{
		m_xCookieMgr = pCookieMgr;
	}
};

}

#endif /* !_CNTCOOK_HXX */

