/*************************************************************************
 *
 *  $RCSfile: cntnode.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTNODE_HXX
#define _CNTNODE_HXX 1

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _WLDCRD_HXX //autogen
#include <tools/wldcrd.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef _CNTDEFS_HXX
#include <cntdefs.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif

namespace chaos {

class CntAnchor;
class CntNodeFactoryList;
class CntNodeJobList;
class CntDefaults;
class CntItemListItem;
class CntJobDispatcher;

#if _SOLAR__PRIVATE
DECLARE_LIST( CntNodeList, CntNode* )
DECLARE_LIST( CntNodeJobQueue, CntNodeJobList* )
DECLARE_LIST( CntNodeFactoryListList, CntNodeFactoryList** )
#else
typedef List CntNodeList;
typedef List CntNodeJobQueue;
typedef List CntNodeFactoryListList;
#endif

//=========================================================================

class CntNodeFactory
{
private:
	String 			_aName;
	WildCard		_aURLPattern;
	String			_aChildDelims;
	TypeId			_aTypeId;
	INetContentType	_eType;
	USHORT      	_nFlags;
	ULONG			_nHelpId;
	CntNodeFactory* _pParent;
	String*    		_pInternalScheme;
	String*    		_pExternalScheme;

public:
	CntNodeFactory(
			const String& rURLPattern,
			const String& rChildDelims,
			TypeId aTypeId,
			const INetContentType eType = CONTENT_TYPE_UNKNOWN,
	 		USHORT nFlags = CNT_CREATION_FLAG_STANDARD,
			ULONG nHelpId = 0,
			CntNodeFactory* pParent = NULL );
	~CntNodeFactory();

	CntNode*		CreateInstance( CntNode *pParent, const String& rURL );
	BOOL			Matches( const String& rURL,
							 CntNodeFactory* pParent = NULL );

	String			GetWildCard() const
	                { return _aURLPattern.GetWildCard(); }
	const USHORT	GetFlags() const
	 			    { return _nFlags; }
	const String&	GetChildDelims() const
					{ return _aChildDelims; }
	const INetContentType GetId() const
	 			    { return _eType; }
	const ULONG		GetHelpId() const
					{ return _nHelpId; }
	const CntNodeFactory* GetParent() const
	 			    { return _pParent; }

	const String&	GetUIFactoryName() const
					{ return _aName; }

	const String&   GetInternalScheme() const;
	const String&   GetExternalScheme() const;
};

//=========================================================================

class CntNodeFactoryList : private List
{
private:
	CntNodeFactoryList();

public:
	static CntNodeFactoryList* Get( CntNodeFactoryList** ppList );
	~CntNodeFactoryList();

	ULONG 			Count() const { return List::Count(); }
    void        	Insert( CntNodeFactory* pFactory );
    void        	Remove( CntNodeFactory* pFactory );
    CntNodeFactory* GetObject( ULONG nIndex ) const
                    { return (CntNodeFactory*)List::GetObject( nIndex ); }
};

//=========================================================================

struct CntNodeUserData
{
	CntAnchor		*_pAnchor;
	CntNodeUserData	*_pNextData;
};

//=========================================================================

class CntNode : public CntInterface
{
friend class CntNodeFactory;

private:
	CntNodeJobQueue*			_pJobQueue;
	CntNodeJob*                 _pCurrentJob;
	CntNodeList*   				_pSubNodeList;
	CntNodeRef	  				_xParent;
	CntNodeRef	  				_xRefered;
	CntNodeRef	  				_xCreator;
	NAMESPACE_VOS( OMutex ) 	_aMutex;
	BOOL						_bIsInserted  : 1;
	BOOL						_bDeleteDone  : 1;
	BOOL						_bIsDead	  : 1;
	BOOL						_bInitialized : 1;
	BOOL						_bGetDataDone : 1;
protected:
	BOOL						_bIsDummy 	  : 1;
private:
	CntNodeFactory*				_pCreator;
	String						_aChildDelims;
	CntNodeUserData*			_pUserData;

								CntNode(); // n.i.
                    			CntNode( const CntNode& ); // n.i.
    CntNode&					operator=( const CntNode& ); // n.i.

	CntNode* 					DoInitialize( CntNodeFactory* pCreator,
											  CntNode* pParent,
											  const String& rNodeURL );
	const SfxPoolItem* 			StoreItem_Impl( CntNodeJob *pJob,
									   	        const SfxPoolItem &rItem );
	BOOL						EraseItem_Impl( CntNodeJob *pJob, USHORT nWhich );

	CntNode* 					QueryChildren_Impl( const String& rNodeURL,
													BOOL  bCreate );
	BOOL						IsChildDelim_Impl ( const String& rNodeURL,
											        USHORT nPos );
	void						InsertChild_Impl  ( CntNode *pNewChild );
	CntNode* 					CreateChild_Impl  ( CntNodeFactory* pFac,
													const String& rNodeURL,
													BOOL bReleaseMutex = FALSE );
	CntNode* 					CreateChild_Impl  ( const String& rNodeURL,
													BOOL bReleaseMutex = FALSE );
	void 						UpdateChildItems_Impl(
													const SfxPoolItem& rItem );
	static const SfxPoolItem* 	SetProperty_Impl( CntInterface* pTarget,
									 		  	  const SfxPoolItem& rItem,
                                     		  	  BOOL bIsViewProp );

	BOOL 						CancelAllJobs_Impl();

	void 						CompletePutDataRequest_Impl(
												CntNodeJob* pJob );

	void 						SwitchMessageViewMode_Impl(
												CntNodeJob *pJob,
												const SfxPoolItem &rNewMode );
	void 						SwitchSentMessageViewMode_Impl(
												CntNodeJob *pJob,
												const SfxPoolItem &rNewMode );
	void 						SwitchFolderViewMode_Impl(
												CntNodeJob *pJob,
										 		const SfxPoolItem &rNewMode );
	void 						SwitchFilter_Impl( CntNodeJob *pJob,
										 		const SfxPoolItem &rNewMode );
	void 						SwitchThreading_Impl( CntNodeJob *pJob,
										 		const SfxPoolItem &rNewMode );
	ULONG						Dump_Impl( SvStream &rStream,
									  	   USHORT nLevel,
										   BOOL bHTML ) const;

protected:
								CntNode( const USHORT *pRanges );
	virtual 					~CntNode();

	// SvRefBase overload
	virtual void                QueryDelete();

	void						SetInserted_Impl()
								{ _bIsInserted = TRUE; }

	void						ConstructOwnURL_Impl( String& rOwnURL );
	BOOL 						IsDummyURL_Impl( const String& rURL );

	static BOOL 				TransferJobsToDo_Impl( CntNode* pOld,
	                                                   CntNode* pNew );
	static void 				SetClassDefaults( CntDefaults** ppDefs,
												  CntDefaults* pNewDefs );

public:
								TYPEINFO();

	virtual CntNode*			Initialize( CntNode* pParent,
											const String& rNodeURL );
	virtual void				GetOwnURL( String& rOwnURL );

	CntNode* 					Query( const String& rNodeURL,
									   BOOL bCreate = TRUE );

	String						CreateInterimURL(
											CntNodeFactory* pFac = NULL );

	virtual com::sun::star::uno::Reference<
				com::sun::star::uno::XInterface > getInterface() const;

	// Refered node
	CntNode*					GetReferedNode() const { return _xRefered; }
	virtual void				SetReferedNode( CntNode* pNode );
	CntNode*					GetMostReferedNode() const;

	// Parent node
	CntNode*					GetParent() const { return _xParent; }
	void 						SetParent_Impl( CntNode* pNode )
								{ _xParent = pNode;	}

	// Root node
	CntNode*					GetRootNode() const;
	BOOL						IsRootNode() const;

	// Children
	virtual void				Inserted( CntNode *pNewNode,
										  CntNodeJob* pJob,
										  BOOL bBroadcast = TRUE );
	BOOL						IsInserted() const { return _bIsInserted; }
	void 						Removed( CntNode *pNode );
    const ULONG					SubNodeCount() const
								{
									return ( _pSubNodeList
										     ? _pSubNodeList->Count()
											 : 0 );
								}
    CntNode*   					GetSubNode( ULONG nPos ) const
								{
									return ( _pSubNodeList
										     ? _pSubNodeList->GetObject( nPos )
											 : NULL );
								}
    CntNode*   					operator[]( ULONG nPos ) const
								{ return GetSubNode( nPos ); }

	// Job management
	CntNodeJobQueue*			GetJobQueue();
	void 						EnqueueJob( CntNodeJob* pJob );
	CntNodeJob*					DequeueJob( CntNodeJob* pJob );
	virtual const SfxPoolItem*	JobArrived ( CntNodeJob *pJob );
	virtual BOOL				JobFinished( CntNodeJob *pJob );

	virtual const SfxPoolItem*	InsertJob    ( CntNodeJob *pJob );
	const SfxPoolItem*			DoInsertJob  ( CntNodeJob *pJob );
	BOOL						RemoveJob    ( CntNodeJob *pJob );
	const SfxPoolItem*			DoExecuteJob ( CntNodeJob *pJob );
	virtual const SfxPoolItem*	ExecuteJob   ( CntNodeJob *pJob );
	void						RescheduleJob( CntNodeJob *pJob );
    const ULONG					JobCount     () const;
    CntNodeJob*					GetJob       ( ULONG nPos ) const;
	CntNodeJob*			        GetCurrentJob() const
								{ return _pCurrentJob; }
	virtual FASTBOOL 			IsItemFlag( USHORT nWID, USHORT nFlag ) const;

	// -- obsolete -- does not work for multiple job lists.
	CntNodeJob*                 GetNextJob() const
								{ return GetJob( 1 ); }

	// SfxListener-Interface
	virtual void				Notify( SfxBroadcaster& rBC,
										const SfxHint& rHint );

	// ...
	virtual void				Flush();

	// connection mode
	virtual void				SetConnMode( CntConnMode eConnMode );

	// creator factory
	CntNodeFactory*				GetCreator() const { return _pCreator; }

	// creator node
	CntNode*					GetCreatorNode() const { return _xCreator; }
	void						SetCreatorNode( CntNode* pCreator )
								{ _xCreator = pCreator; }

	// factories for children
    virtual ULONG				FactoryCount() const = 0;
    virtual CntNodeFactory*		GetFactory( ULONG nPos ) = 0;
	const String&				GetChildDelims() const
								{ return _aChildDelims; }
	void						SetChildDelims( const String& rDelims )
								{ _aChildDelims = rDelims; }

	// class defaults
	virtual CntDefaults*		GetDefaults() const = 0;
	virtual void				SetDefaults( CntDefaults *pDefs ) const = 0;

	// persistent properties
	BOOL 						IsItemSticky( CntNodeJob *pJob,
											  USHORT nWhich,
											  SfxPoolItem** ppItem = NULL );
	const String				GetPropertyKey( BOOL bOwnProps = FALSE );

	// inherited properties.
	const SfxPoolItem* 			GetInheritedItem( USHORT nWhich ) const;
	const CntItemListItem* 		GetChildDefaultsItem() const;

	// user data
	CntNodeUserData*			GetUserData() const	{ return _pUserData; }
	void						SetUserData( CntNodeUserData* pData )
								{ _pUserData = pData; }

	// Flags
	BOOL						IsDummy() const	{ return _bIsDummy;	}

	void						Dead() { _bIsDead = TRUE; }
	BOOL						IsDead() const { return _bIsDead;}

	BOOL						DeleteDone() const { return _bDeleteDone; }
	void						ResetDeleteDone() { _bDeleteDone = FALSE;	}

	// Job dispatcher
	virtual CntJobDispatcher*	getJobDispatcher() const;

	// Mutex
	NAMESPACE_VOS( OMutex )&    getMutex() { return _aMutex; }

	// Debug util
	ULONG						Dump( SvStream &rStream,
									  USHORT nLevel = 0 ) const;
};

SV_IMPL_REF( CntNode );

//=========================================================================

#define CNT_NODE_SUBCLASS_DECL()											\
private:																	\
	/* Klassenspezifisches Defaults-ItemSet */                              \
	static CntDefaults*  	_pDefs;       					 				\
																			\
	/* Liste der Factories, die ein Node zum Erzeugen anderer Nodes */		\
	/* einsetzen kann - fuer jede Sub-Klasse */ 							\
	static CntNodeFactoryList* _pFactoryList;				 				\
																			\
public: 																	\
	virtual CntDefaults*	GetDefaults() const;							\
	virtual void        	SetDefaults( CntDefaults *pDefs ) const;		\
																			\
	/* Zugriff auf klassenspezifische Node-Factories */ 					\
	virtual ULONG			FactoryCount() const;							\
	virtual CntNodeFactory* GetFactory( ULONG nPos );						\
    static void             InsertFactory( CntNodeFactory* pFactory );      \
	static void				Register()

//=========================================================================

#define CNT_NODE_SUBCLASS_IMPL_DEFAULTS(Class)								\
	CntDefaults* Class::_pDefs = NULL;										\
																			\
	CntDefaults* Class::GetDefaults() const									\
	{ return _pDefs; }                                                 		\
																			\
	void Class::SetDefaults( CntDefaults* pDefs ) const				 		\
	{ SetClassDefaults( &_pDefs, pDefs ); }

#define CNT_NODE_SUBCLASS_IMPL_FACTORIES(Class)								\
	CntNodeFactoryList* Class::_pFactoryList = NULL;						\
																			\
	ULONG Class::FactoryCount() const										\
	{ return _pFactoryList ? _pFactoryList->Count() : 0; }	 				\
																			\
	CntNodeFactory* Class::GetFactory( ULONG nPos ) 						\
	{ return _pFactoryList ? _pFactoryList->GetObject( nPos ) : NULL; }		\
																			\
	void Class::InsertFactory( CntNodeFactory* pFactory )					\
	{																		\
		if ( !_pFactoryList )												\
			CntNodeFactoryList::Get( &_pFactoryList );						\
																			\
		_pFactoryList->Insert( pFactory );									\
	}																		\
																			\
	void Class::Register()

#define CNT_NODE_SUBCLASS_IMPL(Class)										\
	CNT_NODE_SUBCLASS_IMPL_DEFAULTS(Class)									\
	CNT_NODE_SUBCLASS_IMPL_FACTORIES(Class)

//=========================================================================

class CntNodeHint : public SfxHint
{
private:
	CntNodeRef		_xNode;
	CntAction		_eAction;
	CntNodeJobRef   _xJob;

                    CntNodeHint( const CntNodeHint& ); // n.i.
    CntNodeHint&	operator=( const CntNodeHint& ); // n.i.

public:
			 		TYPEINFO();

                    CntNodeHint( CntNode* pNode,
								 CntAction eAction,
								 CntNodeJob* pJob );

	CntNode* 		GetNode() const   { return _xNode; }
	const CntAction	GetAction() const { return _eAction; }
	CntNodeJob* 	GetJob() const    { return _xJob; }
};

//=========================================================================

class CntNodeItem : public SfxPoolItem
{
private:
	CntNodeRef					_xNode;

								CntNodeItem( const CntNodeItem &rOrig );
public:
								TYPEINFO();

								CntNodeItem( USHORT nID, CntNode * pNode );

	CntNode*  					GetValue() const { return _xNode; }

	virtual int 				operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*		Clone( SfxItemPool *pPool = 0 ) const;
};

//=========================================================================
class CntURLTransformer
{
public:
	static BOOL NormalizeURL ( String& rURL );
	static BOOL ToExternalURL( String& rURL );
	static BOOL ToInternalURL( String& rURL );
};

}

#endif /* !_CNTNODE_HXX */
