/*************************************************************************
 *
 *  $RCSfile: cntstg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 13:04:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTSTG_HXX
#define _CNTSTG_HXX

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

class String;
class SfxItemPool;

namespace store { class OStoreFile; }

namespace chaos
{

class CntLongNamesList;
class CntStoreItemSet;
class CntStorageIterator;

//===========================================================================
//
// class CntStorage
//
//===========================================================================

class CntStorage
{
private:
	CntLongNamesList*	 	m_pLongNamesList;

protected:
	vos::OMutex				m_aMutex;
	String				 	m_aPath;
	String				 	m_aName;
	String				 	m_aFullName;
	CntStorage*	 		 	m_pParent;
	store::OStoreFile* 		m_pStore;
	USHORT				 	m_nFlags;

private:
	CntLongNamesList* 	getLongNamesList();
	void 				saveLongNamesList();
	const String&		getLongName ( const String& rShortName );
	String 				getShortName( const String& rLongName, BOOL bStore );
	void 				removeName  ( const String& rName );

protected:
	virtual ErrCode initStorage( BOOL bCreate );

public:
	CntStorage();
	virtual ~CntStorage();

	virtual ErrCode initialize( CntStorage* pParent,
								const String& rURL,
								USHORT nInitFlags = 0  );

	const String& getName()   const { return m_aName; };
	CntStorage*   getParent() const { return m_pParent; };

	virtual ErrCode	closeStorage();
	virtual ErrCode destroyStorage();

	CntStoreItemSet* openItemSet( const String& rName,
								  SfxItemPool& rPool,
                                  StreamMode eMode,
								  const USHORT* pWhichPairTable );
	SvStream* openStream( const String& rName, StreamMode eMode );

	ErrCode rename( const String& rName, const String& rNewName );
	ErrCode remove( const String& rName );
	ErrCode link  ( const String& rName, const String& rNewName );
	ErrCode attrib( const String& rName,
					UINT32 nClearMask,
					UINT32 nSetMask,
					UINT32& nAttrib );

	const String iter( CntStorageIterator& rIter );

	static String makeShortName( const String &rLongName );
};

//===========================================================================
//
// class CntRootStorage
//
//===========================================================================

class CntRootStorage : public CntStorage
{
protected:
	virtual ErrCode initStorage( BOOL bCreate );

public:
	CntRootStorage();
	virtual ~CntRootStorage();

	virtual ErrCode initialize( CntStorage* pParent,
								const String& rURL,
								USHORT nInitFlags = 0  );

	static ErrCode create( const String& rURL );

	virtual ErrCode	closeStorage();
	virtual ErrCode destroyStorage();

	ErrCode	size( UINT32& rSize );
	ErrCode rebuild();
	ErrCode	flush();
};

//===========================================================================
//
// class CntLazyRootStorage
//
//===========================================================================

class CntStorageCloser_Impl;

class CntLazyRootStorage : public CntRootStorage
{
	friend class CntStorageCloser_Impl;

	vos::ORef< CntStorageCloser_Impl > m_xCloseTimer;
	oslInterlockedCount    			   m_nLocks;

private:
	oslInterlockedCount releaseStorage_Impl( BOOL bAutoClose );

public:
	CntLazyRootStorage();
	virtual ~CntLazyRootStorage();

	virtual ErrCode	closeStorage();
	virtual ErrCode destroyStorage();

	oslInterlockedCount acquireStorage();
	oslInterlockedCount releaseStorage();
	oslInterlockedCount	storageLocks() const { return m_nLocks; }
	BOOL isStorageLocked() const { return m_nLocks > 0; }
};

} // namespace chaos

#endif /* !_CNTSTG_HXX */
