/*************************************************************************
 *
 *  $RCSfile: cntstore.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 13:04:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTSTORE_HXX
#define _CNTSTORE_HXX

#ifndef _STORE_STORE_HXX_
#include <store/store.hxx>
#endif

namespace chaos
{

//=========================================================================
//
// Misc definitions
//
//=========================================================================

// Storage file initialization flags
#define STG_INIT_FLAG_NORMAL		0x0000
#define STG_INIT_FLAG_BACKUP		0x0001  // create/use backup of storage file

// Storage entry attributes
#define CNTDIRENTRY_ATTRIB_HIDDEN   0x0001
#define CNTDIRENTRY_ATTRIB_SUBDIR   0x0002
#define CNTDIRENTRY_ATTRIB_CREATE   0x0004
#define CNTDIRENTRY_ATTRIB_MARKEDFORDELETE  0x0008
#define CNTDIRENTRY_ATTRIB_MARKED   0x0010
#define CNTDIRENTRY_ATTRIB_USER1    0x0020
#define CNTDIRENTRY_ATTRIB_USER2    0x0040
#define CNTDIRENTRY_ATTRIB_USER3    0x0080
#define CNTDIRENTRY_ATTRIB_USER4    0x0100
#define CNTDIRENTRY_ATTRIB_USER5    0x0200
#define CNTDIRENTRY_ATTRIB_USER6    0x0400
#define CNTDIRENTRY_ATTRIB_USER7    0x0800
#define CNTDIRENTRY_ATTRIB_USER8    0x1000
#define CNTDIRENTRY_ATTRIB_USER9    0x2000
#define CNTDIRENTRY_ATTRIB_USER10   0x4000
#define CNTDIRENTRY_ATTRIB_USER11   0x8000

#define CNTDIRENTRY_ATTRIB_NOTITER  0x000B /* HIDDEN, SUBDIR, MFDEL */

//=========================================================================

#ifndef CNTSTORE_ATTRIB_ISLINK
#define CNTSTORE_ATTRIB_ISLINK STORE_ATTRIB_ISLINK
#endif
#ifndef CNTSTORE_ATTRIB_ISDIR
#define CNTSTORE_ATTRIB_ISDIR  STORE_ATTRIB_ISDIR
#endif

//===========================================================================
//
// class CntStorageIterator
//
// For an include mask of zero, return only those entries that have non of the
// bits of the exclude mask set.
// For an include mask other than zero, return only those entries that have
// (A) at least one of the bits of the include mask set, and (B) none of the
// bits of the exclude mask set.
//
//===========================================================================

class CntStorageIterator
{
	friend class CntStorage;

	enum State { STATE_FIRST, STATE_NEXT, STATE_EOF };

	storeFindData 		   m_aData;
	store::OStoreDirectory m_aStore;
	UINT32 		  		   m_nIncludeMask;
	UINT32 		  		   m_nExcludeMask;
	State		  		   m_eState;

private:
	inline BOOL matches() const;

public:
	inline CntStorageIterator( UINT32 nIncludeMask = 0,
				    		   UINT32 nExcludeMask =
					  				CNTDIRENTRY_ATTRIB_NOTITER |
							   		STORE_ATTRIB_ISDIR );

	storeFindData& operator*() { return m_aData; }
	const storeFindData& operator*() const { return m_aData; }
	BOOL eof() const { return m_eState == STATE_EOF; }
};

inline CntStorageIterator::CntStorageIterator( UINT32 nIncludeMask,
									    	   UINT32 nExcludeMask )
: m_nIncludeMask( nIncludeMask ),
  m_nExcludeMask( nExcludeMask ),
  m_eState( STATE_FIRST )
{
	// storeFindData has no ctor!
	m_aData.m_nAttrib   = 0;
	m_aData.m_nSize     = 0;
//	m_aData.m_pszName   = ;
	m_aData.m_nReserved = 0;
}

inline BOOL CntStorageIterator::matches() const
{
	return ( !m_nIncludeMask || m_aData.m_nAttrib & m_nIncludeMask )
	         && !( m_aData.m_nAttrib & m_nExcludeMask );
}

} // namespace chaos

#endif /* !_CNTSTORE_HXX */
