/*************************************************************************
 *
 *  $RCSfile: cntsys.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTSYS_HXX
#define _CNTSYS_HXX

#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXBRDCST_HXX //autogen
#include <svtools/brdcst.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _INETTYPE_HXX
#include <svtools/inettype.hxx>
#endif

class SfxCancelManager;
class SimpleResMgr;

namespace chaos {

class CntIniManager;
class CntViewList;
class CntExplorerList;

DECLARE_LIST( CntTypesList, INetContentType* )

//=========================================================================

#define CNT_SYS() CntSystem::GetMgr()

//=========================================================================
class CntSystem: public SvRefBase, public SfxListener, public SfxBroadcaster
{
private:
	static CntSystem* _pSystem;


	CntSystem();
	virtual	~CntSystem();

	static const String ViewExists_Impl( const String& rDirURL,
	                                     INetContentType eType,
										 BOOL bDeep );
	static const String CreateView_Impl( const String& rDirURL,
	                                     INetContentType eType );

public:
	// Get the "one and only" CHAOS system object
	static CntSystem* GetMgr( BOOL bCreate = TRUE );

	// Initialization / Deinitialization
	static BOOL	Initialize();
	static BOOL	Deinitialize();

	// SfxItemSet interface
    static const SfxPoolItem* Put( const SfxPoolItem& rProp );
	static const SfxPoolItem& Get( USHORT nWhich,
								   BOOL bSrchInParent = TRUE );

	// SfxListener-Interface
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	// CHAOS item pool
	static SfxItemPool*	GetItemPool();
	static USHORT		ReleaseItemPool();

	// Flush CHAOS data now!
	static void	 Flush();

	// Cancel Manager
	static void	SetCancelManager( SfxCancelManager* pCancelMgr );

	// Resource manager
	static SimpleResMgr* GetResManager();

	// View Types list.
	static CntTypesList* GetViewTypes();

	// Persistent CHAOS Object Views
	static BOOL			ViewExists( const String& rDirURL,
	                                INetContentType eType,
									BOOL bDeep = FALSE );
	static CntViewList* GetViews  ( const String& rDirURL,
	                                INetContentType eType,
									BOOL bDeep = TRUE );
	static CntViewList* GetViews  ( const String& rDirURL,
	                                const String& rServiceURL,
									BOOL bDeep = TRUE );
	static const String	GetView   ( const String& rDirURL,
	                                INetContentType eType,
									BOOL bCreate );
	static const String	GetView   ( BOOL& rbCreated,
									const String& rDirURL,
	                                INetContentType eType );

	// CHAOS Explorer directories
    static const CntExplorerList* GetExplorers();
    static void		  			  AddExplorer   ( const String& rDirURL );
    static void		  			  RemoveExplorer( const String& rDirURL );

    // First start of the system?
    static BOOL	IsInitialStartup();

	// Debug utils
	static void Dump( SvStream &rStream, USHORT nLevel = 0 );
};

SV_DECL_IMPL_REF( CntSystem );

}

#endif
