/*************************************************************************
 *
 *  $RCSfile: cnttritm.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTTRITM_HXX
#define _CNTTRITM_HXX 1

#ifndef _INETTYPE_HXX //autogen
#include <svtools/inettype.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

namespace chaos {

/* forwards */
class CntTransferItemImp;

class CntTransferItem : public SfxPoolItem
{
public:
	enum ReplaceType { REPLACE_ERROR, REPLACE_OVERWRITE, REPLACE_RENAME,
					   REPLACE_KEEP };
	enum SpecType    { SPEC_URL, SPEC_URL_TITLE, SPEC_DATA_TITLE };

private:
	CntTransferItemImp* m_pImp;
	String              m_aSourceURL;
	ReplaceType			m_eReplaceType;
	BOOL				m_bMoveOperation : 1;

	// Not implemented
	CntTransferItem& operator= (const CntTransferItem& rItem);

public:
	TYPEINFO();
	CntTransferItem(void);
	CntTransferItem(USHORT nWhich, const String & rTheSourceURL,
					BOOL  bMoveOperation = FALSE,
					ReplaceType eReplaceMode = REPLACE_ERROR);
	CntTransferItem(USHORT nWhich, const String & rTheSourceURL,
					const String & rTargetTitle,
					BOOL bMoveOperation = FALSE,
					ReplaceType eReplaceMode = REPLACE_ERROR);
	CntTransferItem(USHORT nWhich, SvLockBytes * pSourceData,
					const String & rTargetTitle,
					ReplaceType eReplaceMode = REPLACE_ERROR);
	CntTransferItem(USHORT nWhich, SvLockBytes * pSourceData,
					INetContentType eSourceType, const String & rTargetTitle,
					ReplaceType eReplaceMode = REPLACE_ERROR);
	CntTransferItem(const CntTransferItem& rItem);
	CntTransferItem(USHORT nWhich, SvStream &rStream, USHORT nVersion);
	virtual ~CntTransferItem(void);

	virtual int operator== (const SfxPoolItem& rItem) const;

	virtual USHORT GetVersion(USHORT) const;

	virtual SfxPoolItem *Clone(SfxItemPool *pPool = NULL) const;
	virtual SfxPoolItem *Create(SvStream& rStream, USHORT nVersion) const;
	virtual SvStream&    Store(SvStream& rStream, USHORT nVersion) const;

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;

	inline SpecType getSpec() const;
	const String & getSourceURL() const { return m_aSourceURL; }
	SvLockBytes * getSourceData() const;
	INetContentType getSourceType() const;
	const String & getTargetTitle() const;
	BOOL isMoveOperation() const { return m_bMoveOperation; }
	ReplaceType getReplaceMode() const { return m_eReplaceType; }
};

inline CntTransferItem::SpecType CntTransferItem::getSpec() const
{
	return m_aSourceURL.Len() ? m_pImp ? SPEC_URL_TITLE : SPEC_URL :
	                            SPEC_DATA_TITLE;
}

}

#endif /* !_CNTTRITM_HXX */

