/*************************************************************************
 *
 *  $RCSfile: cntvnode.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTVNODE_HXX
#define _CNTVNODE_HXX

#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif

namespace chaos {

#define CNT_VIEW_URL_DELIMITER '#'

//=========================================================================
class CntViewBase
{
public:
	static BOOL	  	IsViewURL     ( const String& rURL );
	static BOOL	  	IsViewURL     ( BOOL& bRoot, const String& rURL );
	static BOOL	  	IsRootViewURL ( const String& rURL );
	static BOOL	  	IsSubViewURL  ( const String& rURL );
	static BOOL	  	IsValidViewURL( const String& rURL );

	static String 	GetRootViewURL( const String& rViewURL );
	static String 	GetServiceURL ( const String& rViewURL );
	static BOOL	  	ViewFileExists( const String& rURL );

	static String 	MakeViewURL   ( const String& rRootViewURL,
                                    const String& rServiceURL,
									BOOL bValidate = FALSE );
	static CntNode* MakeViewNode  ( CntNode* pResultedNode,
								    CntNode* pHintReceiver );
};

//=========================================================================

class CntViewNode : public CntNode
{
private:
	BOOL m_bGetDataDone : 1;

	// Forbidden and nor implemented.
	CntViewNode( const CntViewNode& );
	// Forbidden and nor implemented.
	CntViewNode& operator=( const CntViewNode& );

public:
	TYPEINFO();
	CNT_NODE_SUBCLASS_DECL();

	CntViewNode();
	virtual ~CntViewNode();

	virtual	CntNode* Initialize( CntNode* pParent, const String& rNodeURL );
	virtual void SetReferedNode( CntNode* pNode );

	virtual void GetOwnURL( String& rOwnURL );

	virtual const SfxPoolItem* InsertJob( CntNodeJob *pJob );
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	// Auto-Inheritence stuff...
	static void PutChildViewDefaults ( CntNode* pTarget,
									   const CntItemListItem& rDefs,
									   BOOL bInitialized = TRUE );
	static void SyncChildViewDefaults( CntNode* pSource,
									   const SfxPoolItem& rItem );
};

}

#endif /* !_CNTVNODE_HXX */
