/*************************************************************************
 *
 *  $RCSfile: cntvwitm.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTVWITM_HXX
#define _CNTVWITM_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif

#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif
#ifndef _SVTOOLS_CUSTRITM_HXX
#include <svtools/custritm.hxx>
#endif

#ifndef _CHAOS_WIDSITEM_HXX
#include <widsitem.hxx>
#endif

namespace chaos {

//============================================================================
enum CntMsgViewMode
{
	CNT_VIEW_ALL_ARTICLES = 0,
	CNT_VIEW_UNREAD_ARTICLES,
	CNT_VIEW_READ_ARTICLES,
	CNT_VIEW_MARKED_ARTICLES,
	CNT_VIEW_MARKED_AND_UNREAD_ARTICLES
};

class CntMsgViewModeItem : public CntEnumItem
{
public:
								TYPEINFO();

								CntMsgViewModeItem(
									USHORT nWhich = WID_MESSAGEVIEW_MODE,
									CntMsgViewMode eMode=CNT_VIEW_ALL_ARTICLES );

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual USHORT			 	GetValueCount() const;
	virtual String			 	GetValueTextByPos( USHORT nPos ) const;

	CntMsgViewModeItem& 		operator=(const CntMsgViewModeItem& rStyle)
	{
        SetValue( rStyle.GetValue() );
        return *this;
    }

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;

};

//============================================================================

enum CntFolderViewMode
{
	CNT_VIEW_ALL_FOLDERS = 0,
	CNT_VIEW_SUBSCRIBED_FOLDERS,
	CNT_VIEW_ACTIVE_FOLDERS
};

// damit die Sourcen durchgehen
#define CNT_VIEW_NEW_FOLDERS 0xffff

class CntFolderViewModeItem : public CntEnumItem
{
public:
								TYPEINFO();

								CntFolderViewModeItem(
									USHORT nWhich=WID_FOLDERVIEW_MODE,
									CntFolderViewMode eMode=CNT_VIEW_ALL_FOLDERS );

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual USHORT			 	GetValueCount() const;
	virtual String			 	GetValueTextByPos( USHORT nPos ) const;

	CntFolderViewModeItem& 		operator=(const CntFolderViewModeItem& rStyle)
	{
        SetValue( rStyle.GetValue() );
        return *this;
    }

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

//============================================================================

class CntViewDescriptionItem : public SfxPoolItem
{
private:
	String						_aIconLocator;
	BOOL						_aIsLocator;
	BOOL						_aInterface;
	BOOL						_aUseType;

public:
								TYPEINFO();

								CntViewDescriptionItem();
								CntViewDescriptionItem(	USHORT nWhich)
									: SfxPoolItem( nWhich )
									 {	_aIsLocator = FALSE;
									 	_aInterface = FALSE;
									 	_aUseType = FALSE; }
								CntViewDescriptionItem(
									USHORT nWhich,
									const String& rIconLocation
								);
								CntViewDescriptionItem( USHORT nWhich,
														BOOL bIsInterface,
														BOOL bUseType = FALSE )
									: SfxPoolItem( nWhich )
									 {	_aIsLocator = FALSE;
									 	_aInterface = bIsInterface;
									 	_aUseType = bUseType; }

								CntViewDescriptionItem( const CntViewDescriptionItem& );

	BOOL						HasIconLocation() const
								{
									return _aIsLocator;
								}
	String						GetIconLocation() const
								{
									return _aIconLocator;
								}
	BOOL						UseInterface() const
								{
									return _aInterface;
								}
	BOOL						UseType() const
								{
									return _aUseType;
								}

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	CntViewDescriptionItem& 	operator=(const CntViewDescriptionItem& rItem);
	virtual int 			 	operator==( const SfxPoolItem& ) const;

	virtual USHORT				GetVersion(USHORT) const;

	virtual SfxPoolItem*	 	Create( SvStream&, USHORT nVersion ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;
};

//============================================================================

enum CntOpenMode
{
	CNT_OPEN_ALL,     	// result all children
	CNT_OPEN_FOLDERS, 	// result only folders
	CNT_OPEN_DOCUMENT, 	// open document content
						// 	-> fill WID_[MESSAGE|DOCUMENT]BODY item (obsolete)
						//  -> fill a given data sink interface implementation
	CNT_OPEN_DOCUMENTS, // result only documents */
	CNT_OPEN_CLOSE_ALL,
	CNT_OPEN_RENOTIFY_GRANDCHILDREN,
	CNT_OPEN_CANCEL_OPEN,
	CNT_OPEN_MODE_COUNT
};

// Compatibility.
#define CNT_OPEN_MESSAGE	CNT_OPEN_DOCUMENT
#define CNT_OPEN_MESSAGES	CNT_OPEN_DOCUMENTS

class CntOpenModeItem: public CntWIDSetItem
{
public:
	enum { LOWEST_PRIO = 0xFFFF };

private:
	CntOpenMode m_eMode;
	sal_uInt16 m_nPriority;
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface > m_xSink;

	CntOpenModeItem(const CntWIDSetItem & rItem, CntOpenMode eTheMode):
		CntWIDSetItem(rItem), m_eMode(eTheMode), m_nPriority(LOWEST_PRIO) {}

public:
	TYPEINFO();

	CntOpenModeItem(USHORT nWhich = WID_OPEN,
					CntOpenMode eTheMode = CNT_OPEN_ALL,
					sal_uInt16 nThePriority = LOWEST_PRIO):
		CntWIDSetItem(nWhich), m_eMode(eTheMode), m_nPriority(nThePriority) {}

	inline CntOpenModeItem(USHORT nWhich, CntOpenMode eTheMode,
						   sal_uInt16 nThePriority,
						   const com::sun::star::uno::Reference<
						   	com::sun::star::uno::XInterface > & rTheSink);

	virtual	BOOL QueryValue(com::sun::star::uno::Any& rVal,
							BYTE nMemberId = 0) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any& rVal,
						  BYTE nMemberId = 0);

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT nItemVersion)
		const;

	virtual SvStream & Store(SvStream & rStream, USHORT nItemVersion) const;

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;

	CntOpenMode GetValue() const { return m_eMode; }

	void SetValue(CntOpenMode eTheMode) { m_eMode = eTheMode; }

	USHORT GetValueCount() const { return CNT_OPEN_MODE_COUNT; }

	sal_uInt16 GetPriority() const { return m_nPriority; }

	void SetPriority(sal_uInt16 nThePriority) { m_nPriority = nThePriority; }

	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	getDataSink() const { return m_xSink; }

	void clearDataSink() { m_xSink = 0; }
};

inline CntOpenModeItem::CntOpenModeItem(USHORT nWhich, CntOpenMode eTheMode,
										sal_uInt16 nThePriority,
									    const com::sun::star::uno::Reference<
						   				  com::sun::star::uno::XInterface > &
										   rTheSink):
	CntWIDSetItem(nWhich),
	m_eMode(eTheMode),
	m_nPriority(nThePriority),
	m_xSink(rTheSink)
{}

//============================================================================

enum CntSentMsgViewMode
{
	CNT_SENT_VIEW_ALL_ARTICLES = 0,
	CNT_SENT_VIEW_SENT_ARTICLES,
	CNT_SENT_VIEW_UNSENT_ARTICLES,
	CNT_SENT_VIEW_MARKED_ARTICLES,
	CNT_SENT_VIEW_END
};

class CntSentMsgViewModeItem : public CntEnumItem
{
public:
								TYPEINFO();

								CntSentMsgViewModeItem(
									USHORT nWhich = WID_SENTMESSAGEVIEW_MODE,
									CntSentMsgViewMode eMode=CNT_SENT_VIEW_ALL_ARTICLES );

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual USHORT			 	GetValueCount() const;
	virtual String			 	GetValueTextByPos( USHORT nPos ) const;

	CntSentMsgViewModeItem& 	operator=(const CntSentMsgViewModeItem& rStyle)
	{
        SetValue( rStyle.GetValue() );
        return *this;
    }

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

//============================================================================

class CntNameItem : public CntUnencodedStringItem
{
private:
	String 						aRealName;

public:

								TYPEINFO();

								CntNameItem()
									: CntUnencodedStringItem() {}
								CntNameItem( USHORT nWhich, const String& rStr )
									: CntUnencodedStringItem( nWhich, rStr ) {}
								CntNameItem( const CntNameItem& rItm )
									: CntUnencodedStringItem( rItm )
								{
									aRealName = rItm.aRealName;
								}

	void			 			SetValue( const String& rNewVal )
								{
									CntUnencodedStringItem::SetValue( rNewVal );
									aRealName.Erase();
								}

	const String&				GetRealName() const;

	virtual int 			 	operator==( const SfxPoolItem& ) const;
	virtual int					Compare( const SfxPoolItem &rWith ) const;

	virtual USHORT				GetVersion(USHORT) const;

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;
};

//============================================================================

enum CntPriority
{
	CNT_PRIO_HIGHEST = 1,
	CNT_PRIO_HIGH	 = 2,
	CNT_PRIO_NORMAL  = 3,
	CNT_PRIO_LOW 	 = 4,
	CNT_PRIO_LOWEST  = 5
};

class CntPriorityItem : public CntEnumItem
{
public:
								TYPEINFO();

								CntPriorityItem(
									USHORT nWhich = WID_PRIORITY,
									CntPriority ePrio = CNT_PRIO_NORMAL );

								CntPriorityItem(
									USHORT nWhich,
									const String& rValue );

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual USHORT			 	GetValueCount() const;
	virtual String			 	GetValueTextByPos( USHORT nPos ) const;

	String						GetValueText() const;

	CntPriorityItem& 			operator=(const CntPriorityItem& rPrio )
	{
        SetValue( rPrio.GetValue() );
        return *this;
    }
	virtual int					Compare( const SfxPoolItem &rWith ) const;

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

//============================================================================

enum CntValueAddedMode
{
	CNT_VALUE_ADDED_NONE = 0,
	CNT_VALUE_ADDED_DOCINFO,
	CNT_VALUE_ADDED_FULL
};
#define VALUE_ADDED_MODE_COUNT 3

class CntValueAddedModeItem : public CntEnumItem
{
public:
								TYPEINFO();

	CntValueAddedModeItem( USHORT nWhich = WID_VALUE_ADDED_MODE,
						   CntValueAddedMode eMode = CNT_VALUE_ADDED_NONE );

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual USHORT			 	GetValueCount() const;
	virtual String			 	GetValueTextByPos( USHORT nPos ) const;

	CntValueAddedModeItem& 		operator=(const CntValueAddedModeItem& rStyle)
	{
        SetValue( rStyle.GetValue() );
        return *this;
    }

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

//============================================================================

class CntUpdateItem: public SfxVoidItem
{
public:
	TYPEINFO();

	CntUpdateItem(USHORT nWhich): SfxVoidItem(nWhich) {}

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;
};

}

#endif
