/*************************************************************************
 *
 *  $RCSfile: import.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 19:39:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_IMPORT_HXX
#define _CHAOS_IMPORT_HXX

#ifndef _CHAOS_MBXFORMT_HXX
#include <mbxformt.hxx>
#endif

class DateTime;
class SfxItemSet;
namespace inet { class INetCoreMailer; }

namespace chaos
{

class CntMBXMessage;
class CntRecipientListItem;
class CntStorageNode;

//============================================================================
/** A magic error number that is set in CntRecipientInfo's _nProtocolError for
	a CntRecipientListItem(WID_RECIPIENTLIST) that is build from an imported
	X-Mozilla-Status header field.
 */
enum { CNT_IMPORT_PARTIAL_RECIPIENT_INFO_ERROR = 0x600D };

//============================================================================
class CntMessageCachingPolicy
{
public:
	virtual ~CntMessageCachingPolicy() {}

	virtual BOOL doCache(CntMBXVersion const * pVersion, SfxItemSet & rItems,
						 UniString & rName) = 0;

	virtual CntStorageNode * getCacheNode() = 0;
};

//============================================================================
class CntImport
{
	enum BoundaryType
	{
		NO_BOUNDARY,
		NEXT_BOUNDARY,
		END_BOUNDARY
	};

	CntMBXStreamScanner m_aScanner;
	CntMBXAtomTable m_aAtomTable;
	sal_uInt8 const * m_pCharsRFC822;
	sal_uInt8 const * m_pCharsMIME;
	sal_uInt8 const * m_pCharsBoundary;
	sal_uInt8 const * m_pCharsBody;
	sal_uInt8 const * m_pCharsText;
	sal_uInt8 const * m_pCharsSText;
	sal_uInt8 const * m_pCharsEToken;
	sal_uInt8 const * m_pCharsEText;
	inet::INetCoreMailer * m_pMessageFactory;
	CntMBXBodyScanner * m_pBodyScanner;
	CntMBXScanner::SourceFormat m_eSourceFormat;
	bool m_bSourceFormatDetermined;
	bool m_bBodyScannerAvailable;

	ErrCode determineSourceFormat();

	CntMBXMessage * createMessage();

	ErrCode skipToCRLF(CntMBXToken & rToken);

	ErrCode parseDateTimeFieldBody(DateTime & rDateTime, bool & rValid);

	ErrCode parseXrefFieldBody(UniString & rHost, CntItemListItem & rList);

	ErrCode parseNumericFieldBody(bool bHex, bool bLeadingZeroes,
								  sal_uInt32 & rValue, bool & rValid);

	ErrCode parseBooleanFieldBody(bool & rValue, bool & rValid);

	ErrCode parseXCHAOSRecipientsFieldBody(CntRecipientListItem & rList);

	ErrCode readHeaderFieldBody(ByteString & rBody);

	ErrCode readBodyLine(bool bHasBoundary, ByteString const & rBoundary,
						 bool & rFound, ByteString & rLine,
						 bool & rTerminated, BoundaryType & rBoundaryType);

	ErrCode parseMessage(CntMessageCachingPolicy & rPolicy,
						 CntMBXVersion const * pVersion, bool bHasBoundary,
						 ByteString const & rBoundary, bool bHasNewsHost,
						 UniString const & rNewsHost, SfxItemSet * pItems,
						 CntMBXMessage * pMessage,
						 BoundaryType & rBoundaryType, bool bHeader);

public:
	inline CntImport(SvStream & rStream);

	~CntImport();

	inline ErrCode determineSourceFormat(CntMBXScanner::SourceFormat &
										     rFormat);

	sal_uInt32 getProgressMax() { return m_aScanner.getInputSize(); }

	ErrCode getMessage(CntMessageCachingPolicy & rPolicy, BOOL & rFound,
					   CntMBXVersion *& rVersion, SfxItemSet & rItems,
					   ULONG & rProgress, UniString const * pNewsHost = 0);

	CntMBXBodyScanner * aquireBodyScanner();

	void releaseBodyScanner();
};

inline CntImport::CntImport(SvStream & rStream):
	m_aScanner(rStream),
	m_bSourceFormatDetermined(false),
	m_pMessageFactory(0),
	m_bBodyScannerAvailable(false),
	m_pBodyScanner(0)
{}

inline ErrCode CntImport::determineSourceFormat(CntMBXScanner::SourceFormat &
												    rFormat)
{
	ErrCode nError = determineSourceFormat();
	if (nError != ERRCODE_NONE)
		return nError;
	rFormat = m_eSourceFormat;
	return ERRCODE_NONE;
}

} // namespace chaos

#endif // _CHAOS_IMPORT_HXX

