/*************************************************************************
 *
 *  $RCSfile: sortitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SORTITEM_HXX
#define _SORTITEM_HXX


#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

namespace chaos {

class CntSortingInfo;

SvStream& operator>>( SvStream &rStream, CntSortingInfo &rInfo );
SvStream& operator<<( SvStream &rStream, const CntSortingInfo &rInfo );

// -----------------------------------------------------------------------

class CntSortingInfo

/**	[Description]

	Contains a single sorting criteria normally collected in
	<CntSortingInfoItem>'s.
*/

{
friend SvStream& operator>>( SvStream &rStream, CntSortingInfo &rInfo );
friend SvStream& operator<<( SvStream &rStream, const CntSortingInfo &rInfo );

	USHORT						_nSortingWID;
	BOOL						_bAscending;

public:
								CntSortingInfo()
								:	_nSortingWID(0),
									_bAscending(TRUE)
								{}
								CntSortingInfo( USHORT nSortingWID,
												BOOL bAscending = TRUE )
								:	_nSortingWID(nSortingWID),
									_bAscending(bAscending)
								{}

	BOOL						operator==( const CntSortingInfo &rOther ) const;
	BOOL						operator!=( const CntSortingInfo &rOther ) const
								{ return !operator==(rOther); }

	USHORT              		GetSortingWID() const { return _nSortingWID; }
	BOOL              			GetAscending() const { return _bAscending; }
};

// -----------------------------------------------------------------------

SV_DECL_OBJARR( CntSortingInfoArr, CntSortingInfo, 1, 3 )

// -----------------------------------------------------------------------

class CntSortingItem: public SfxPoolItem

/**	[Description]

	Collects <CntSortingInfo>'s to a complete desctiption how to
	sort the contents of a container.
*/

{
	CntSortingInfoArr		_aInfos;

public:
							TYPEINFO();
							CntSortingItem( USHORT nWhich = 0 );
							CntSortingItem( USHORT nWhich, SvStream & );
							CntSortingItem( const CntSortingItem& );
							~CntSortingItem();

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*    Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nItemVersion) const;
	virtual SvStream&		Store(SvStream &, USHORT nItemVersion ) const;

	USHORT					Count() const { return _aInfos.Count(); }
	const CntSortingInfo& 	operator[]( USHORT n ) const { return _aInfos[n]; }

	void					Append( const CntSortingInfo &rInfo )
							{ _aInfos.Insert( rInfo, _aInfos.Count() ); }
	void					Push( const CntSortingInfo& rInfo, USHORT nMaxCount = 5 );
	void					Clear() { _aInfos.Remove( 0, _aInfos.Count()); }
	BOOL					Contains( USHORT nWhich ) const;
	BOOL					Contains( USHORT nWhich, BOOL &rAscending ) const;

	virtual	BOOL 			PutValue  ( const com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 );
	virtual	BOOL 			QueryValue( com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 ) const;
};

}

#endif

