/*************************************************************************
 *
 *  $RCSfile: thrdtask.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_THRDTASK_HXX
#define CHAOS_THRDTASK_HXX

#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_
#include <vos/refernce.hxx>
#endif

#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif

namespace chaos {

//============================================================================
class ThreadTask: public vos::OReference, private SfxListener
{
public:
	enum Response
	{
		RESPONSE_CANCELED,
		RESPONSE_ABORT,
		RESPONSE_RETRY,
		RESPONSE_IGNORE
	};

private:
	enum { TICKS = 250 };

	enum { INITIAL = 0, SLEEPING, AWAKE_FOREVER = 0xFFFFFFFE, FINISHED };

	CntNodeJobRef m_xJob;
	CntNode & m_rExecNode;
	ULONG m_nTicks;
	vos::OMutex m_aMutex;
	sal_uInt32 m_nState;
	bool m_bPendingCancel;
	bool m_bPendingDone;
	bool m_bPendingReschedule;
	bool m_bAwaitingReschedule;

	ThreadTask(const ThreadTask &);

	void operator =(const ThreadTask &);

	bool wakeUp(bool bStarting);

	virtual void Notify(SfxBroadcaster & rBroadcaster, const SfxHint & rHint);

protected:
	inline ThreadTask(CntNodeJob & rTheJob, CntNode & rTheExecNode);

	virtual ~ThreadTask() {}

	using SfxListener::StartListening;

	using SfxListener::EndListening;

	CntNodeJob & getJob() { return *m_xJob; }

	CntNode & getExecNode() { return m_rExecNode; }

	bool isFinished()
	{ return m_nState == FINISHED || m_bPendingCancel || m_bPendingDone; }

	bool wakeUp() { return wakeUp(false); }

	bool sleep();

	void startTimeSlice();

	bool checkTimeSliceExhausted();

	void reschedule();

	void cancel() { m_xJob->Cancel(); }

	void done() { m_xJob->Done(); }

	Response handleError(ErrCode nError, const String * pText = 0,
						 void * pData = 0, bool bCancelJob = true);

	virtual const SfxPoolItem * execute() = 0;

	virtual void notification(SfxBroadcaster & rBroadcaster,
							  const SfxHint & rHint);

	virtual void finished(bool bCanceled);

public:
	const SfxPoolItem * run();
};

inline ThreadTask::ThreadTask(CntNodeJob & rTheJob, CntNode & rTheExecNode):
	m_xJob(&rTheJob),
	m_rExecNode(rTheExecNode),
	m_nState(INITIAL),
	m_bPendingCancel(false),
	m_bPendingDone(false),
	m_bPendingReschedule(false),
	m_bAwaitingReschedule(false)
{}

}

#endif // CHAOS_THRDTASK_HXX

