/*************************************************************************
 *
 *  $RCSfile: cntsditm.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:18:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UCB_SEARCHINFO_HPP_
#include <com/sun/star/ucb/SearchInfo.hpp>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#ifndef _CNTRULES_HXX
#include <cntrules.hxx>
#endif
#ifndef _CNTSDITM_HXX
#include <cntsditm.hxx>
#endif

using namespace chaos;
using namespace com::sun::star;

//============================================================================
//
//  class CntSearchData
//
//============================================================================

bool CntSearchData::Matches(SfxItemSet const & aItems,
                            IntlWrapper const & rIntlWrapper) const
{
	if (m_pCriteria)
	{
		sal_uInt32 nCount = m_pCriteria->RuleCount();
		if (nCount != 0)
		{
			for (sal_uInt32 i = 0; i < nCount; ++i)
			{
				CntNodeRule const * pCriterium = m_pCriteria->GetRule(i);
                if (pCriterium->queryAction(aItems, rIntlWrapper, 0)
					    == CNT_NODE_ACTION_SHOW)
					return true;
			}
			return false;
		}
	}
	return true;
}

//============================================================================
CntSearchMatchMode CntSearchData::MatchesIncomplete(SfxItemSet const & aItems,
                                                    IntlWrapper const &
                                                        rIntlWrapper) const
{
	if (!m_pCriteria)
		return CNT_SEARCH_MATCH_YES;

	sal_uInt32 nCriteriaCount = m_pCriteria->RuleCount();
	if (nCriteriaCount == 0)
		return CNT_SEARCH_MATCH_YES;

	CntSearchMatchMode eMode = CNT_SEARCH_MATCH_NO;
	for (sal_uInt32 i = 0; i < nCriteriaCount; ++i)
	{
		CntNodeRule const * pCriterium = m_pCriteria->GetRule(i);
		CntSearchMatchMode eCriteriumMode = CNT_SEARCH_MATCH_YES;
		sal_uInt32 nTermCount = pCriterium->TermCount();
		for (sal_uInt32 j = 0; j < nTermCount; ++j)
		{
			CntNodeRuleTerm const * pTerm = pCriterium->GetTerm(j);
			USHORT nWhich = pTerm->GetPropertySID();
			if (aItems.GetItemState(nWhich) >= SFX_ITEM_SET)
			{
				if (!pTerm->matches(aItems.Get(pTerm->GetPropertySID()),
                                    rIntlWrapper, 0))
				{
					eCriteriumMode = CNT_SEARCH_MATCH_NO;
					break;
				}
			}
			else
				eCriteriumMode = CNT_SEARCH_MATCH_UNKNOWN;
		}
		if (eCriteriumMode == CNT_SEARCH_MATCH_YES)
			return CNT_SEARCH_MATCH_YES;
		else if (eCriteriumMode == CNT_SEARCH_MATCH_UNKNOWN)
			eMode = CNT_SEARCH_MATCH_UNKNOWN;
	}
	return eMode;
}

//============================================================================
bool CntSearchData::HasSingleStringConstraint(USHORT nWhich,
											  StringRelType * pRelation,
											  String * pString,
											  bool * pCaseSensitive,
											  bool * pRegexp) const
{
	if (!m_pCriteria || m_pCriteria->RuleCount() != 1)
		return false;

	StringRelType eTheRelation;
	String aTheString;
	bool bTheCaseSensitive;
	bool bTheRegexp;
	bool bSingleConstraint = false;

	CntNodeRule const * pCriterium = m_pCriteria->GetRule(0);
	sal_uInt32 nCount = pCriterium->TermCount();
	for (sal_uInt32 i = 0; i < nCount; ++i)
	{
		CntNodeRuleTerm const * pTerm = pCriterium->GetTerm(i);
		if (pTerm->GetPropertySID() == nWhich)
		{
			DBG_ASSERT(pTerm->GetOperandType()
					       == CNT_NODE_RULE_OPERANDTYPE_STRING,
					   "CntSearchData::HasSingleStringConstraint():"
					       " Bad operand type");
			DBG_ASSERT(!pTerm->IsRegularExpression(),
					   "CntSearchData::HasSingleStringConstraint():"
					       " Bad regexp");

			CntNodeRuleOperator eOperator = pTerm->GetOperator();
			DBG_ASSERT(eOperator >= CNT_NODE_RULE_OPERATOR_CONTAINS
					   && eOperator <= CNT_NODE_RULE_OPERATOR_NOTEQUAL,
					   "CntSearchData::HasSingleStringConstraint():"
					       " Bad operator");

			if (bSingleConstraint)
				return false;
			else
			{
				switch (eOperator)
				{
					case CNT_NODE_RULE_OPERATOR_CONTAINS:
						eTheRelation = STRING_CONTAINS;
						break;

					case CNT_NODE_RULE_OPERATOR_CONTAINSNOT:
						eTheRelation = STRING_NOT_CONTAINS;
						break;

					case CNT_NODE_RULE_OPERATOR_GREATEREQUAL:
						eTheRelation = STRING_GREATER_EQUAL;
						break;

					case CNT_NODE_RULE_OPERATOR_LESSEQUAL:
						eTheRelation = STRING_LESS_EQUAL;
						break;

					case CNT_NODE_RULE_OPERATOR_EQUAL:
						eTheRelation = STRING_EQUAL;
						break;

					default: // CNT_NODE_RULE_OPERATOR_NOTEQUAL
						eTheRelation = STRING_NOT_EQUAL;
						break;
				}
				aTheString = pTerm->GetStringOperand();
				bTheCaseSensitive = pTerm->IsCaseSensitive();
				bTheRegexp = pTerm->IsRegularExpression();
				bSingleConstraint = true;
			}
		}
	}

	if (bSingleConstraint)
	{
		if (pRelation)
			*pRelation = eTheRelation;
		if (pString)
			*pString = aTheString;
		if (pCaseSensitive)
			*pCaseSensitive = bTheCaseSensitive;
		if (pRegexp)
			*pRegexp = bTheRegexp;
	}
	return bSingleConstraint;
}

//============================================================================
bool CntSearchData::HasSingleDateConstraint(USHORT nWhich,
											DateRelType * pRelation,
											Date * pDate) const
{
	if (!m_pCriteria || m_pCriteria->RuleCount() != 1)
		return false;

	DateRelType eTheRelation;
	Date aTheDate;
	bool bSingleConstraint = false;

	CntNodeRule const * pCriterium = m_pCriteria->GetRule(0);
	sal_uInt32 nCount = pCriterium->TermCount();
	for (sal_uInt32 i = 0; i < nCount; ++i)
	{
		CntNodeRuleTerm const * pTerm = pCriterium->GetTerm(i);
		if (pTerm->GetPropertySID() == nWhich)
		{
			DBG_ASSERT(pTerm->GetOperandType()
					       == CNT_NODE_RULE_OPERANDTYPE_DATE,
					   "CntSearchData::HasSingleDateConstraint():"
					       " Bad operand type");

			CntNodeRuleOperator eOperator = pTerm->GetOperator();
			DBG_ASSERT(eOperator >= CNT_NODE_RULE_OPERATOR_GREATEREQUAL
					   && eOperator <= CNT_NODE_RULE_OPERATOR_NOTEQUAL,
					   "CntSearchData::HasDateStringConstraint():"
					       " Bad operator");

			if (bSingleConstraint)
				return false;
			else
			{
				switch (eOperator)
				{
					case CNT_NODE_RULE_OPERATOR_GREATEREQUAL:
						eTheRelation = DATE_GREATER_EQUAL;
						break;

					case CNT_NODE_RULE_OPERATOR_LESSEQUAL:
						eTheRelation = DATE_LESS_EQUAL;
						break;

					case CNT_NODE_RULE_OPERATOR_EQUAL:
						eTheRelation = DATE_EQUAL;
						break;

					default: // CNT_NODE_RULE_OPERATOR_NOTEQUAL
						eTheRelation = DATE_NOT_EQUAL;
						break;
				}
				aTheDate = pTerm->GetDateOperand();
				bSingleConstraint = true;
			}
		}
	}

	if (bSingleConstraint)
	{
		if (pRelation)
			*pRelation = eTheRelation;
		if (pDate)
			*pDate = aTheDate;
	}
	return bSingleConstraint;
}

//============================================================================
bool CntSearchData::queryValue(ucb::SearchInfo & rInfo) const
{
	if (m_pCriteria)
	{
		sal_uInt32 nCount = m_pCriteria->RuleCount();
		rInfo.Criteria.realloc(nCount);
		ucb::SearchCriterium * pList = rInfo.Criteria.getArray();
		for (sal_uInt32 i = 0; i < nCount; ++i)
		{
			CntNodeRule const * pCriterium = m_pCriteria->GetRule(i);
			if (pCriterium && !pCriterium->getTerms(pList->Terms))
				return false;
			++pList;
		}
	}
	rInfo.Recursion = ucb::SearchRecursion(m_eRecursion);
	rInfo.IncludeBase = m_bIncludeBase;
	rInfo.RespectFolderViewRestrictions = m_bRespectFolderViewRestrictions;
	rInfo.RespectDocViewRestrictions = m_bRespectDocViewRestrictions;
	rInfo.FollowIndirections = m_bFollowIndirections;
	return true;
}

//============================================================================
bool CntSearchData::putValue(ucb::SearchInfo const & rInfo)
{
	CntNodeRuleSet * pNewCriteria;
	sal_Int32 nCount = rInfo.Criteria.getLength();
	if (nCount)
	{
		pNewCriteria = new CntNodeRuleSet;
		for (ucb::SearchCriterium const * pList = rInfo.Criteria.getConstArray();
			 nCount-- != 0; ++pList)
		{
			CntNodeRule * pCriterium = new CntNodeRule(pNewCriteria,
													   CNT_NODE_ACTION_SHOW);
			if (!pCriterium->addTerms(pList->Terms))
			{
				delete pNewCriteria;
				return false;
			}
			pNewCriteria->InsertRule(pCriterium);
		}
	}
	else
		pNewCriteria = 0;

	delete m_pCriteria;
	m_pCriteria = pNewCriteria;
	m_eRecursion = RecursionType(rInfo.Recursion);
	m_bIncludeBase = rInfo.IncludeBase != false;
	m_bRespectFolderViewRestrictions = rInfo.RespectFolderViewRestrictions
		                                   != false;
	m_bRespectDocViewRestrictions = rInfo.RespectDocViewRestrictions != false;
	m_bFollowIndirections = rInfo.FollowIndirections != false;
	return true;
}

//============================================================================
//
//  class CntSearchDataItem
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntSearchDataItem, SfxPoolItem)

//============================================================================
// virtual
int CntSearchDataItem::operator ==(SfxPoolItem const & rItem) const
{
	CntSearchDataItem * pSearchDataItem = PTR_CAST(CntSearchDataItem, &rItem);
	return pSearchDataItem && Which() == pSearchDataItem->Which()
		   && GetValue() == pSearchDataItem->GetValue();
}

//----------------------------------------------------------------------------
// virtual
BOOL CntSearchDataItem::QueryValue(uno::Any & rVal, BYTE) const
{
	ucb::SearchInfo aInfo;
	if (!m_aData.queryValue(aInfo))
		return false;
	rVal <<= aInfo;
	return true;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntSearchDataItem::PutValue(uno::Any const & rVal, BYTE)
{
	ucb::SearchInfo aInfo;
	if (rVal >>= aInfo)
	{
		m_aData.putValue(aInfo);
		return true;
	}
	return false;
}

