/*************************************************************************
 *
 *  $RCSfile: cstritem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _INETMSG_HXX
#include <svtools/inetmsg.hxx>
#endif
#ifndef _SVTOOLS_STRCRYPT_HXX_
#include <svtools/strcrypt.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif

#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif

#include <cstritem.hxx>

using namespace chaos;

//============================================================================
//
// CntStringItem Implementation.
//
//============================================================================

#define CNTSTRINGITEM_STREAM_MAGIC   ( (UINT32)0xfefefefe )
#define CNTSTRINGITEM_STREAM_SEEKREL (-( (long)( sizeof( UINT32 ) ) ) )

//----------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY( CntStringItem, CntUnencodedStringItem );

//----------------------------------------------------------------------------
static
BOOL IsToGarble_Impl( USHORT nWhich )
{
	// Note: CntStringItem's are created before the pool is created! ( static
	//       defaults ).
	CntItemPool* pPool = CNT_POOL();
	if ( pPool )
		return pPool->IsItemFlag( nWhich, CNT_ITEM_AUTO_GARBLE );

	return FALSE;
}

//----------------------------------------------------------------------------
USHORT CntStringItem::GetVersion(USHORT) const
{
	return 2;
		// 1, since it uses SfxPoolItem::read/writeUnicodeString()
		// 2, since it uses new string en-/decode
}

//----------------------------------------------------------------------------
SfxPoolItem* CntStringItem::Create( SvStream& rStream, USHORT nItemVersion )
	const
{
	UniString aValue;

	if (nItemVersion >= 1)
	{
		sal_uInt8 nDecode = false;
		rStream >> nDecode;
		if (nDecode)
		{
			ByteString aEncoded;
			rStream.ReadByteString(aEncoded);
			aValue = UniString(CntStringDecode(nItemVersion >= 2, aEncoded),
							   RTL_TEXTENCODING_UTF8);
		}
		else
			readUnicodeString(rStream, aValue, true);
	}
	else
	{
		ByteString aByteValue;
		rStream.ReadByteString(aByteValue);

		sal_uInt8 nDecode = false;
		sal_uInt32 nMagic = 0;
		rStream >> nMagic;
		if (nMagic == CNTSTRINGITEM_STREAM_MAGIC)
			rStream >> nDecode;
		else
		{
			// Compatibility: Formerly ( SUPD<370 ) all string items were
			// stored as SfxStringItems. Then CHAOS was switched to
			// strictly use of CntStringItem's.

			// Did read an item stored as CntUnencodedStringItem...
			rStream.SeekRel( CNTSTRINGITEM_STREAM_SEEKREL );

			switch ( Which() )
			{
				// Special handling for items which were flagged AUTO_GARBLE
				// after CHAOS was switched to stricly use of CntStringItem:
				case WID_TO:
					// No decode nessecary.
					break;

				// Special handling for items which were unflagged AUTO_GARBLE
				// after CHAOS was switched to stricly use of CntStringItem
//				case ... :
//					// Decode nessecary.
//					nDecode = true;
//					break;

				default:
					// Handle the item according to pool flag
					nDecode = IsToGarble_Impl(Which());
					break;
			}
		}

		if (nDecode)
			aValue = UniString(CntStringDecode(false, aByteValue),
							   rStream.GetStreamCharSet());
		else
			aValue = UniString(aByteValue, rStream.GetStreamCharSet());
	}

	return new CntStringItem( Which(), aValue );
}

//----------------------------------------------------------------------------
SvStream& CntStringItem::Store( SvStream& rStream, USHORT ) const
{
	BOOL bEncode = IsToGarble_Impl(Which());
	rStream << sal_uInt8(bEncode);
	if (bEncode)
		rStream.WriteByteString(SvStringEncode(ByteString(
			                                       GetValue(),
												   RTL_TEXTENCODING_UTF8)));
	else
		writeUnicodeString(rStream, GetValue());
	return rStream;
}

//----------------------------------------------------------------------------
SfxPoolItem* CntStringItem::Clone( SfxItemPool* ) const
{
	return new CntStringItem( *this );
}

//----------------------------------------------------------------------------
BOOL CntStringItem::IsEncrypted() const
{
	return IsToGarble_Impl( Which() );
}

