/*************************************************************************
 *
 *  $RCSfile: dhdritem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_DOUMENTHEADERFIELD_HPP_
#include <com/sun/star/ucb/DocumentHeaderField.hpp>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _DHDRITEM_HXX
#include <dhdritem.hxx>
#endif

using namespace chaos;

//----------------------------------------------------------------------------
//
BOOL CntDocHeader::IsEqual( const CntDocHeader& rOther ) const
{
	ULONG nCount = GetHeaderCount();

	if ( nCount != rOther.GetHeaderCount() )
		return FALSE;

	while ( nCount )
	{
		--nCount;
		if ( GetHeaderName( nCount ) != rOther.GetHeaderName( nCount ) )
			return FALSE;
		if ( GetHeaderValue( nCount ) != rOther.GetHeaderValue( nCount ) )
			return FALSE;
	}

	return TRUE;
}

//============================================================================
//
// CntDocHeaderItem Implementation.
//
//============================================================================

TYPEINIT1_AUTOFACTORY (CntDocHeaderItem, SfxPoolItem);

//----------------------------------------------------------------------------
CntDocHeaderItem::CntDocHeaderItem (USHORT nWhich, CntDocHeader* pHeader)
	: SfxPoolItem (nWhich),
	  _xHeader    (pHeader)
{
}

//-------------------------------------------------------------------------
CntDocHeaderItem::~CntDocHeaderItem (void)
{
	_xHeader = NULL;
}

//-------------------------------------------------------------------------
CntDocHeaderItem::CntDocHeaderItem (const CntDocHeaderItem &rOrig)
	: SfxPoolItem (rOrig)
{
	SetValue (rOrig.GetValue());
}

//----------------------------------------------------------------------------
CntDocHeaderItem::CntDocHeaderItem (USHORT nWhich, SvStream& rStrm)
	: SfxPoolItem (nWhich)
{
	_xHeader = new CntDocHeader();
	rStrm >> *_xHeader;
}

//----------------------------------------------------------------------------
int	CntDocHeaderItem::operator== (const SfxPoolItem& rItem) const
{
	const CntDocHeaderItem& rOther = (const CntDocHeaderItem&)rItem;
	return (&_xHeader == &(rOther._xHeader));
}

//----------------------------------------------------------------------------
SfxPoolItem* CntDocHeaderItem::Clone (SfxItemPool* pPool) const
{
	return new CntDocHeaderItem (*this);
}

//----------------------------------------------------------------------------
SfxPoolItem* CntDocHeaderItem::Create (SvStream& rStrm, USHORT nVersion) const
{
	return new CntDocHeaderItem (Which(), rStrm);
}

//----------------------------------------------------------------------------
SvStream& CntDocHeaderItem::Store (SvStream& rStrm, USHORT nVersion) const
{
	if (!_xHeader.Is())
	{
		// We must write something, even if header is empty!
		const_cast< CntDocHeaderItem * >( this )->_xHeader = new CntDocHeader();
	}
	rStrm << *_xHeader;
	return rStrm;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntDocHeaderItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		 BYTE nMemberId )
{
	com::sun::star::uno::Sequence<
				com::sun::star::ucb::DocumentHeaderField > aValue;
	if ( rVal >>= aValue )
	{
		// Destroy old/create new header.
		_xHeader = new CntDocHeader();

		// Fill new header.
		const com::sun::star::ucb::DocumentHeaderField* pHeaders =
													aValue.getConstArray();
		sal_uInt32 nCount = aValue.getLength();
		for ( sal_uInt32 n = 0; n < nCount; ++n )
		{
			const com::sun::star::ucb::DocumentHeaderField& rHeader =
													pHeaders[ n ];
			_xHeader->SetHeaderField( rHeader.Name, rHeader.Value,
									  LIST_APPEND );
		}

		return TRUE;
	}

	DBG_ERROR( "CntDocHeaderItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntDocHeaderItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	   BYTE nMemberId ) const
{
	if ( !_xHeader.Is() )
	{
		com::sun::star::uno::Sequence<
				com::sun::star::ucb::DocumentHeaderField > aValue( 0 );
		rVal <<= aValue;
		return TRUE;
	}

	sal_uInt32 nCount = _xHeader->GetHeaderCount();
	com::sun::star::uno::Sequence<
			com::sun::star::ucb::DocumentHeaderField > aValue( nCount );
	com::sun::star::ucb::DocumentHeaderField* pHeaders = aValue.getArray();
	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		com::sun::star::ucb::DocumentHeaderField& rHeader = pHeaders[ n ];

		rHeader.Name  = _xHeader->GetHeaderName( n );
		rHeader.Value = _xHeader->GetHeaderValue( n );
	}

	rVal <<= aValue;
	return TRUE;
}
