/*************************************************************************
 *
 *  $RCSfile: outitems.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#define _OUTITEMS_CXX
#include <outitems.hxx>

using namespace chaos;

//-------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY(CntOutMsgInternalStateItem, CntEnumItem);
TYPEINIT1_AUTOFACTORY(CntOutMsgExternalStateItem, CntEnumItem);

//=========================================================================

CntOutMsgInternalStateItem::CntOutMsgInternalStateItem( USHORT nWhich )
: CntEnumItem( nWhich )
{
	SetValue( CNT_OUTMSG_INTERNALSTATE_WRITTEN );
}

//-------------------------------------------------------------------------

CntOutMsgInternalStateItem::CntOutMsgInternalStateItem( USHORT nWhich,
  CntOutMsgInternalState eState  )
: CntEnumItem( nWhich )
{
	SetValue( (USHORT)eState );
}

//-------------------------------------------------------------------------

CntOutMsgInternalStateItem::CntOutMsgInternalStateItem( USHORT nWhich, SvStream &rStream )
:	CntEnumItem( nWhich )
{
	USHORT eState;
	rStream >> eState;
	SetValue( eState );
}

//-------------------------------------------------------------------------

CntOutMsgInternalStateItem::CntOutMsgInternalStateItem( const CntOutMsgInternalStateItem &rOrig )
:	CntEnumItem( rOrig )
{
	SetValue( rOrig.GetValue() );
}

//-------------------------------------------------------------------------

SfxPoolItem* CntOutMsgInternalStateItem::Clone( SfxItemPool * ) const
{
	return new CntOutMsgInternalStateItem( *this );
}

//-------------------------------------------------------------------------

SfxPoolItem* CntOutMsgInternalStateItem::Create(SvStream &rStream, USHORT nItemVersion) const
{
	return new CntOutMsgInternalStateItem( Which(), rStream );
}

//-------------------------------------------------------------------------

SvStream& CntOutMsgInternalStateItem::Store(SvStream &rStream, USHORT nItemVersion ) const
{
	USHORT nValue = GetValue();
	rStream << nValue;

	return rStream;
}

void CntOutMsgInternalStateItem::SetEnumValue( USHORT nNewVal )
{
	SetValue( nNewVal );
}

USHORT CntOutMsgInternalStateItem::GetEnumValue() const
{
	return GetValue();
}

USHORT CntOutMsgInternalStateItem::GetValueCount() const
{
	return CNTOUTMSGINTERNALSTATECOUNT;
}

// virtual
BOOL CntOutMsgInternalStateItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		   		   BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntOutMsgInternalStateItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntOutMsgInternalStateItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	 		 BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

//=========================================================================

CntOutMsgExternalStateItem::CntOutMsgExternalStateItem( USHORT nWhich )
: CntEnumItem( nWhich )
{
	SetValue( CNT_OUTMSG_EXTERNALSTATE_WHITE );
}


//-------------------------------------------------------------------------

CntOutMsgExternalStateItem::CntOutMsgExternalStateItem( USHORT nWhich, SvStream &rStream )
:	CntEnumItem( nWhich )
{
	USHORT eState;
	rStream >> eState;
	SetValue( eState );
}

//-------------------------------------------------------------------------

CntOutMsgExternalStateItem::CntOutMsgExternalStateItem( const CntOutMsgExternalStateItem &rOrig )
:	CntEnumItem( rOrig )
{
	SetValue( rOrig.GetValue() );
}

//-------------------------------------------------------------------------

SfxPoolItem* CntOutMsgExternalStateItem::Clone( SfxItemPool * ) const
{
	return new CntOutMsgExternalStateItem( *this );
}

//-------------------------------------------------------------------------

SfxPoolItem* CntOutMsgExternalStateItem::Create(SvStream &rStream, USHORT nItemVersion) const
{
	return new CntOutMsgExternalStateItem( Which(), rStream );
}

//-------------------------------------------------------------------------

SvStream& CntOutMsgExternalStateItem::Store(SvStream &rStream, USHORT nItemVersion ) const
{
	USHORT nValue = GetValue();
	rStream << nValue;

	return rStream;
}

void CntOutMsgExternalStateItem::SetEnumValue( USHORT nNewVal )
{
	SetValue( nNewVal );
}

USHORT CntOutMsgExternalStateItem::GetEnumValue() const
{
	return GetValue();
}

USHORT CntOutMsgExternalStateItem::GetValueCount() const
{
	return CNTOUTMSGEXTERNALSTATECOUNT;
}

// virtual
BOOL CntOutMsgExternalStateItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		   		   BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntOutMsgInternalStateItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntOutMsgExternalStateItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	 		 BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

