/*************************************************************************
 *
 *  $RCSfile: cnftpimp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_CNFTPIMP_HXX
#define CHAOS_CNFTPIMP_HXX

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef CHAOS_THRDTASK_HXX
#include <thrdtask.hxx>
#endif

#ifndef CHAOS_CNFTPRED_HXX
#include <cnftpred.hxx>
#endif

namespace inet { class INetFTPConnection; }

namespace chaos
{

class CntFTPBoxNode;
class CntFTPDocNode;
class CntFTPFolderNode;
class CntStorageIterator;
class CntStorageNode;
class CntStoreItemSetRef;

//============================================================================
// The name of FTP box directory entries:
#define CNT_FTP_BOX_DIRECTORY_ENTRY_NAME "DATA"

// The prefix for FTP document contents cache entries, and its length:
#define CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX "contents:"
#define CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX_LEN 9

// The prefix for FTP folder directory and user data entries, and its length:
#define CNT_FTP_FOLDER_ENTRY_PREFIX "folder:"
#define CNT_FTP_FOLDER_ENTRY_PREFIX_LEN 7

// The prefix for FTP document directory and user data entries, and its
// length:
#define CNT_FTP_DOC_ENTRY_PREFIX "file:"
#define CNT_FTP_DOC_ENTRY_PREFIX_LEN 5

// The prefix for FTP document refcount cache entries:
#define CNT_FTP_DOC_REFCOUNT_CACHE_ENTRY_PREFIX "refcount:"

// Attributes used for FTP folder and document directory entries:
#define CNTDIRENTRY_ATTRIB_FTP_READONLY CNTDIRENTRY_ATTRIB_USER2
#define CNTDIRENTRY_ATTRIB_FTP_LINK CNTDIRENTRY_ATTRIB_USER3

// An attribute used for FTP folder directory entries:
#define CNTDIRENTRY_ATTRIB_FTP_COMPLETE_LIST CNTDIRENTRY_ATTRIB_MARKED

// An attribute used for FTP document user data entries:
#define CNTDIRENTRY_ATTRIB_FTP_READ CNTDIRENTRY_ATTRIB_USER1

// Attributes used for FTP document contents cache entries:
#define CNTDIRENTRY_ATTRIB_FTP_PERSISTENT CNTDIRENTRY_ATTRIB_USER1
#define CNTDIRENTRY_ATTRIB_FTP_PARTIAL CNTDIRENTRY_ATTRIB_USER2

// An item used in FTP box nodes and directory entries:
#define WID_FTP_SERVERSYSTEM WID_SEND_PUBLIC_PROT_ID

// An item used in FTP box directory entries:
#define WID_FTP_LASTCACHENAME WID_LOCALBASE

// An item used in FTP folder nodes and directory entries:
#define WID_FTP_TARGET_FOLDER WID_REPLY_TO

// An item used in FTP document directory entries:
#define WID_FTP_CACHENAME WID_LOCALBASE
#define WID_FTP_RETR_DATE_CREATED WID_DATE_MODIFIED
#define WID_FTP_RETR_DOCUMENT_SIZE WID_REFERER_COUNT

// An item used in FTP document refcount cache entries:
#define WID_FTP_CACHEREFS WID_SEENCONTENTCOUNT

//============================================================================
class CntFTPURL
{
public:
	/** Return an URL <fsegment> part encoded.

		@ATT  This method no longer encodes '*'.  The consequences are
		detailed in the corresponding IMAP URL code.

		@param rFSegment  Any String.

		@return  Like rFSegment, but with any character not from <uchar
		/ ":" / "@" / "&" / "=" / "~"> replaced by it's (upper case) escape
		sequence.
	 */
	static inline String encodeFSegment(String const & rFSegment);

	/** Return an URL <fsegment> part decoded.

		@param rFSegment  Any string.

		@return  Like rFSegment, but any sequence of "%" followed by two hex
		digits replaced by the character represented by the digits.
	 */
	static inline String decodeFSegment(String const & rFSegment);

	/** Return the <*1("/" fpath)> part of an FTP URL.

		@param rURL  Must be a valid FTP URL.

		@return  Empty string if rURL is of the form <"ftp://" login>, and
		<"/" fpath> part otherwise.
	 */
	static String getSlashFPath(const String & rURL);

	/** Get the <*1("/" fpath)> part and its position within an FTP URL.

		@param rURL  Must be a valid FTP URL.

		@param rSlashFPath  Empty string if rURL is of the form <"ftp://"
		login>, and <"/" fpath> part otherwise.

		@param rSlash  STRING_NOTFOUND if rURL is of the form <"ftp://"
		login>, and starting position of <"/" fpath> part otherwise.
	 */
	static void getSlashFPath(const String & rURL, String & rSlashFPath,
							  xub_StrLen & rSlash);

	/** Return the <fpath> part of an FTP URL.

		@param rURL  Must be a valid FTP URL.

		@return  Empty string if rURL is of the form <"ftp://" login *"/">,
		and <fpath> part otherwise.
	 */
	static String getFPath(const String & rURL);

	/** Return FTP URL with <fpath> part replaced.

		@param rURL  Must be a valid FTP URL.

		@param rSlashFPath  Must be of the form <"/" fpath>.

		@return  URL like rURL, but with <"/" fpath> part (if any) replaced by
		rSlashFPath.
	 */
	static String replaceSlashFPath(const String & rURL,
									const String & rSlashFPath);

	/** Return FTP URL with base prepended to <fpath> part.

		@param rURL  Must be a valid FTP URL.

		@param rBase  Must be of the form <"/" *(fsegment "/")>.

		@return  URL like rURL, but with <"/"> before <fpath> part (if any)
		replaced by rBase.
	 */
	static String prependBaseToFPath(const String & rURL,
									 const String & rBase);
};

// static
inline String CntFTPURL::encodeFSegment(String const & rFSegment)
{
	return INetURLObject::encode(rFSegment, INetURLObject::PART_PCHAR, '%',
								 INetURLObject::ENCODE_ALL);
}

//============================================================================
class CntFTPImp
{
public:
	enum ServerSystem
	{
		SYSTEM_UNKNOWN,
		SYSTEM_UNIX,
		SYSTEM_DOS,
		SYSTEM_VMS,
		SYSTEM_NONHIER,
		SYSTEM_END
	};

	enum LinkMode
	{
		LINK_NO,
		LINK_THRU,
		LINK_REFRESH
	};

	enum ConnectionState
	{
		CONNECTION_DOWN,
		CONNECTION_INITIALIZED,
		CONNECTION_SEND_USER,
		CONNECTION_SEND_PASS,
		CONNECTION_SEND_ACCT,
		CONNECTION_SEND_PWD,
		CONNECTION_AVAILABLE,
		CONNECTION_CLOSE
	};

private:
	CntFTPBoxNode & rFTPBoxNode;
	bool bInitialized;
	CntFTPRedirectionManager aRedirectionManager;
	CntConnMode eConnMode;
	bool m_bConnectionLocked;
	ConnectionState m_eConnectionState;
	vos::ORef< inet::INetFTPConnection  > m_xConnection;
	bool m_bConnectionTerminated;
	bool m_bLoginAccount;

	static sal_Bool terminationCallback(inet::INetFTPConnection * pConnection,
										sal_Int32, const sal_Char *,
										void * pData);

	static void getFolderStorageSets(CntNode & rFolderNode, bool bGetDirSet,
									 CntStoreItemSetRef & rFolderDirSet,
									 bool bGetUserSet,
									 CntStoreItemSetRef & rFolderUserSet);

public:
	CntFTPImp(CntFTPBoxNode & rTheFTPBoxNode);

	~CntFTPImp();

	void initialize(CntNodeJob & rJob);

	void checkAnonymous();

	bool changeUserHost(CntNodeJob & rJob, const String * pUser,
						const String * pHost);

	void changeBase(CntNodeJob & rJob, const String & rExternalBase);

	void SetConnMode(CntConnMode eTheConnMode) { eConnMode = eTheConnMode; }

	CntConnMode GetConnMode() const { return eConnMode; }

	inline bool acquireConnection();

	void releaseConnection() { m_bConnectionLocked = false; }

	ConnectionState getConnectionState() { return m_eConnectionState; }

	void setConnectionState(ConnectionState eTheConnectionState)
	{ m_eConnectionState = eTheConnectionState; }

	bool initializeConnection(bool bToClose);

	inet::INetFTPConnection * getConnection()
	{ return m_xConnection.getBodyPtr(); }

	void clearTransferCallback();

	void abortConnection(bool bTransfering);

	bool connectionTerminated() { return m_bConnectionTerminated; }

	bool getLoginAccount() { return m_bLoginAccount; }

	void setLoginAccount(bool bTheLoginAccount)
	{ m_bLoginAccount = bTheLoginAccount; }

	void GetFolderNodeData(CntFTPFolderNode * pNode);

	void GetDocNodeData(CntFTPDocNode * pNode);

	void CopyFolderData(CntNode * pSource, CntNode * pDestination);

	static void updateFolderCountsInit(CntNode & rFolderNode,
									   bool bStore = false);

	static void updateFolderCountsAddFolder(CntNode & rFolderNode,
											bool bStore = false);

	static void updateFolderCountsRemoveFolder(CntNode & rFolderNode,
											   bool bStore = false);

	static void updateFolderCountsAddDoc(CntNode & rFolderNode,
										 bool bDocRead, bool bDocMarked,
										 bool bStore = false);

	static void updateFolderCountsRemoveDoc(CntNode & rFolderNode,
											const CntNode & rDocNode,
											bool bStore = false);

	static void updateFolderCountsFlagDoc(CntNode & rFolderNode,
										  bool bFlagRead, bool bFlagState,
										  bool bStore = false);

	static void updateFolderCountsStore(CntNode & rFolderNode);

	void FlagFolder(CntNode * pNode, const SfxPoolItem * pRequest);

	void FlagDoc(CntNode * pNode, const SfxPoolItem * pRequest);

	void SetDocNodePersistence(CntNodeJob * pJob);

	bool KeepDocPersistent(CntNode * pNode);

	CntFTPBoxNode & GetFTPBoxNode() const { return rFTPBoxNode; }

	String GetUserName() const;

	String GetPassword() const;

	String GetAccount() const;

	String GetServerNameAndPort() const;

	void GetServerNameAndPort(String & rServerName, USHORT & rPort) const;

	String GetServerBase() const;

	void SetServerBase(CntNodeJob & rJob, const String & rBase);

	/** Check a node's URL to see if it is a 'proxy' node.

		@param pFolder  Non-null pointer to CntFTPBoxNode or CntFTPFolderNode.

		@return  False if SYSTEM_UNKNOWN or SYSTEM_NONHIER case, or the URL's
		<fpath> starts with <fsegment "/"> where that fsegment is of the form
		SYSTEM_UNIX case: "%2F"
		SYSTEM_DOS case: "\" / ((lowalpha / hialpha) "%3A")
		SYSTEM_VMS case: 1*uchar ":%5B000000%5D"
	 */
	bool IsProxyFolder(const CntNode * pFolder) const;

	/** Get URL of the folder a 'proxy' folder points to.

		@param rProxy  Some CntFTPFolderNode.

		@return  URL like that of rProxy, but with the fpath prepended with
		the hirarchical base path.
	 */
	String getProxyTargetURL(const CntNode & rProxy);

	CntNode * GetProxyTarget(const CntNode * pProxy);
		// if GetServerBase() returns non-empty base, return CntFTPFolderNode
		// with URL of pProxyNode but with URL path prefixed by base;
		// otherwise, return 0

	void ChaseRedirection(CntNode * pStartNode, CntNode * pCurrentNode,
						  LinkMode eLinkMode, CntNodeRef & rTargetPointer,
						  CntNodeRef & rTargetNode);

	String FindUnusedCacheName(CntNodeJob * pJob, CntStorageNode * pCache);

	/** Translate directory path as returned by FTP server into URL path.
		In SYSTEM_UNKNOWN case, determine a system type and store it.

		@param pJob  Non-null job pointer (needed when storing guessed
		system).

		@param rSystemPath  The directory path as returned by FTP server
		(PWD).

		@return  The absolute URL path in the form <"/" 1*(fsegment "/")
		fsegment>.
	 */
	String MapToInternalPath(CntNodeJob * pJob, const String & rSystemPath);

	bool ParseNodeURL(const String & rExternalURL, String & rNodeURL,
					  String * pFTPPath = 0, String * pFTPName = 0,
					  bool bSplit = false);
		// rExternalURL: the input URL (external or internal format)
		// rNodeURL: the output URL (internal format)
		// pFTPPath: if non-0, extract path from rNodeURL into it
		// pFTPName: if non-0, extract name from rNodeURL into it
		// bSplit: if false, keep pFTPName as part of pFTPPath
		// returns false if base required but GetServerBase() doesn't supply
		// one

	String MapToExternalURL(const String & rNodeURL);

	static String GetName(const CntNode * pNode);

	void forceDirectoryStorage() const;

	void forceUserDataStorage() const;

	static CntNode * GetDirectory(const CntNode * pNode);

	static CntNode * GetUserData(const CntNode * pNode);

	static bool ParseID(const String & rID, String & rName, bool & rDocument);

	static const USHORT * GetFolderDirectoryEntryRanges();

	static const USHORT * GetFolderUserDataEntryRanges();

	static const USHORT * GetDocDirectoryEntryRanges();

	static const USHORT * GetDocRefcountCacheEntryRanges();

	void AddRedirection(const String & rPointerURL,
						const String & rTargetURL)
	{ aRedirectionManager.Add(rPointerURL, rTargetURL); }

	void RemoveRedirection(const String & rPointerURL,
						   const String & rTargetURL)
	{ aRedirectionManager.Remove(rPointerURL, rTargetURL); }

	const CntFTPRedirectionPointer * GetRedirectionPointers(const String &
															    rTargetURL)
		const
	{ return aRedirectionManager.GetPointers(rTargetURL); }

	bool getUpdateOnOpenMode(const CntNodeJob & rJob) const;
};

inline bool CntFTPImp::acquireConnection()
{
	if (m_bConnectionLocked)
		return false;
	m_bConnectionLocked = true;
	return true;
}

//============================================================================
class CntFTPCleanCacheTask: public chaos::ThreadTask
{
	CntFTPImp & m_rImp;
	CntStorageNode * m_pCache;
	CntStorageIterator * m_pIterator;
	bool m_bStatus;

	virtual ~CntFTPCleanCacheTask();

	virtual const SfxPoolItem * execute();

	virtual void finished(bool);

public:
	inline CntFTPCleanCacheTask(CntNodeJob & rJob, CntFTPImp & rTheImp);
};

inline CntFTPCleanCacheTask::CntFTPCleanCacheTask(CntNodeJob & rJob,
												  CntFTPImp & rTheImp):
	ThreadTask(rJob, *rJob.GetSubject()),
	m_rImp(rTheImp),
	m_pCache(0),
	m_pIterator(0),
	m_bStatus(false)
{}

} // namespace chaos

#endif // CHAOS_CNFTPIMP_HXX

