/*************************************************************************
 *
 *  $RCSfile: cnftpred.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_CNFTPRED_HXX
#include <cnftpred.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntFTPRedirectionTarget
//
//============================================================================

CntFTPRedirectionTarget::~CntFTPRedirectionTarget()
{
	while (m_pPointers)
	{
		CntFTPRedirectionPointer * pNext = m_pPointers->m_pNext;
		delete m_pPointers;
		m_pPointers = pNext;
	}
}

//============================================================================
void CntFTPRedirectionTarget::Add(String const & rPointerURL)
{
	CntFTPRedirectionPointer ** p = &m_pPointers;
	for (; *p; p = &(*p)->m_pNext)
		switch ((*p)->m_aPointerURL.CompareTo(rPointerURL))
		{
			case COMPARE_EQUAL:
				return;

			case COMPARE_LESS:
				goto insert;
		}
insert:
	*p = new CntFTPRedirectionPointer(rPointerURL, *p);
}

//============================================================================
void CntFTPRedirectionTarget::Remove(String const & rPointerURL)
{
	for (CntFTPRedirectionPointer ** p = &m_pPointers; *p; p = &(*p)->m_pNext)
		switch ((*p)->m_aPointerURL.CompareTo(rPointerURL))
		{
			case COMPARE_EQUAL:
			{
				CntFTPRedirectionPointer * pPointer = *p;
				*p = pPointer->m_pNext;
				delete pPointer;
				return;
			}

			case COMPARE_LESS:
				return;
		}
}

//============================================================================
//
//  CntFTPRedirectionManager
//
//============================================================================

CntFTPRedirectionManager::~CntFTPRedirectionManager()
{
	while (m_pTargets)
	{
		CntFTPRedirectionTarget * pNext = m_pTargets->m_pNext;
		delete m_pTargets;
		m_pTargets = pNext;
	}
}

//============================================================================
void CntFTPRedirectionManager::Add(String const & rPointerURL,
								   String const & rTargetURL)
{
	CntFTPRedirectionTarget ** p = &m_pTargets;
	for (; *p; p = &(*p)->m_pNext)
		switch ((*p)->m_aTargetURL.CompareTo(rTargetURL))
		{
			case COMPARE_EQUAL:
				goto add;

			case COMPARE_LESS:
				goto insert;
		}
insert:
	*p = new CntFTPRedirectionTarget(rTargetURL, *p);
add:
	(*p)->Add(rPointerURL);
}

//============================================================================
void CntFTPRedirectionManager::Remove(String const & rPointerURL,
									  String const & rTargetURL)
{
	for (CntFTPRedirectionTarget ** p = &m_pTargets; *p; p = &(*p)->m_pNext)
		switch ((*p)->m_aTargetURL.CompareTo(rTargetURL))
		{
			case COMPARE_EQUAL:
			{
				CntFTPRedirectionTarget * pTarget = *p;
				pTarget->Remove(rPointerURL);
				if (!pTarget->m_pPointers)
				{
					*p = pTarget->m_pNext;
					delete pTarget;
				}
				return;
			}

			case COMPARE_LESS:
				return;
		}
}

//============================================================================
CntFTPRedirectionPointer const *
CntFTPRedirectionManager::GetPointers(String const & rTargetURL) const
{
	for (CntFTPRedirectionTarget * pTarget = m_pTargets; pTarget;
		 pTarget = pTarget->m_pNext)
		switch (pTarget->m_aTargetURL.CompareTo(rTargetURL))
		{
			case COMPARE_EQUAL:
				return pTarget->m_pPointers;

			case COMPARE_LESS:
				return 0;
		}
	return 0;
}

