/*************************************************************************
 *
 *  $RCSfile: cnftptsk.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_CNFTPTSK_HXX
#define CHAOS_CNFTPTSK_HXX

#ifndef _INETFTP_HXX
#include <inet/inetftp.hxx>
#endif

#ifndef CHAOS_CNFTPIMP_HXX
#include <cnftpimp.hxx>
#endif

namespace chaos
{

//============================================================================
class CntFTPTask: public chaos::ThreadTask
{
	enum { STATE_INITIALIZE, STATE_OPEN, STATE_OPEN_DONE, STATE_USER,
		   STATE_USER_DONE, STATE_PASS, STATE_PASS_DONE, STATE_ACCT,
		   STATE_ACCT_DONE, STATE_INIT_PWD, STATE_INIT_PWD_DONE, STATE_CWD,
		   STATE_CWD_DONE, STATE_PWD, STATE_PWD_DONE, STATE_SPLIT_CWD,
		   STATE_SPLIT_CWD_DONE, STATE_TYPE, STATE_TYPE_DONE, STATE_CLOSE,
		   STATE_CLOSE_DONE, EXTRA_STATES };

	enum CallbackState { CALLBACK_IDLE, CALLBACK_WAITING, CALLBACK_TRANSFER };

protected:
	enum { FURTHER_STATES = EXTRA_STATES };

private:
	CntFTPImp & m_rImp;
	CntFTPImp::LinkMode m_eLinkMode;
	bool m_bCWDFullPath;
	inet::INetFTPConnection::DataType m_eDataType;
	bool m_bToClose;
	sal_uInt32 m_nCommandID;
	CallbackState m_eCallbackState;
	bool m_bStatusText;
	String m_aPath;
	bool m_bConnectionAcquired;

protected:
	CntNodeRef xTargetPointer;
	CntNodeRef xTargetNode;
	bool bConnModeDetermined;
	CntConnMode eConnMode;
	int m_nState;
	String aNodeURL;
	String aName;

private:
	virtual const SfxPoolItem * execute();

	virtual void finished(bool bCanceled);

	static sal_Bool callback(inet::INetFTPConnection * pConnection,
							 sal_Int32 nReplyCode,
							 const sal_Char * pReplyText, void * pData);

	static sal_Bool transferCallback(inet::INetFTPConnection * pConnection,
									 sal_Int32, const sal_Char *,
									 void * pData);

	void executeCallback(sal_Int32 nReplyCode, const sal_Char * pReplyText);

	bool activateTransferCallback();

	inline sal_uInt32 startCommand(bool bTransfering);

	void callbackOccured() { ++m_nCommandID; }

	bool wasCalledBack(sal_uInt32 nID) const { return nID != m_nCommandID; }

	void commandFailed() { m_eCallbackState = CALLBACK_IDLE; }

protected:
	CntFTPTask(CntNodeJob & rJob, CntFTPImp & rTheImp,
			   CntFTPImp::LinkMode eTheLinkMode = CntFTPImp::LINK_NO,
			   bool bTheCWDFullPath = false,
			   inet::INetFTPConnection::DataType eTheDataType
			       = inet::INetFTPConnection::DATA_TYPE_UNKNOWN,
			   bool bTheToClose = false);

	CntFTPImp & getImp() { return m_rImp; }

	String getFullPath();

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * pReplyText);

	virtual void handleTransferCallback();

	virtual void handleReschedule();

	virtual void handleCancel();

	inline void setStatusText(const String & rText);

	inline void clearStatusText();

	bool error(ErrCode nError, const String * pText = 0, void * pData = 0);
		// returns true if the underlying job is not canceled

	bool error(sal_Int32 nReplyCode, const sal_Char * pReplyText);
		// returns true if the underlying job is not canceled

	void errorRestart() { executeCallback(0, 0); }

	void done();

	bool connectionLoginUsername(const String & rUsername);

	bool connectionLoginPassword(const String & rPassword);

	bool connectionLoginAccount(const String & rAccount);

	bool connectionClose();

	bool connectionNoop();

	bool connectionSetCurDir(const String & rPathname);

	bool connectionGetCurDir();

	bool connectionMakeDir(const String & rPathname);

	bool connectionRemoveDir(const String & rPathname);

	bool connectionRemove(const String & rPathname);

	bool connectionRenameFrom(const String & rFromPath);

	bool connectionRenameTo(const String & rToPath);

	bool connectionSetTypeAscii();

	bool connectionSetTypeImage();

	bool connectionGetNameList(const String & rPathname, List & rNameList);

	bool connectionRetrieve(const String & rFromPath,
							SvOpenLockBytes * pToPath,
							sal_uInt32 nRestartOffset);

	bool connectionStore(SvLockBytes * pFromPath, const String & rToPath,
						 sal_uInt32 nRestartOffset);
};

inline sal_uInt32 CntFTPTask::startCommand(bool bTransfering)
{
	m_eCallbackState = bTransfering ? CALLBACK_TRANSFER : CALLBACK_WAITING;
	return ++m_nCommandID;
}

inline void CntFTPTask::setStatusText(const String & rText)
{
	m_bStatusText = true;
	getJob().Broadcast(CntStatusBarHint(rText));
}

inline void CntFTPTask::clearStatusText()
{
	if (m_bStatusText)
	{
		getJob().Broadcast(CntStatusBarHint(String()));
		m_bStatusText = false;
	}
}

//============================================================================
class CntFTPCloseConnectionTask: public CntFTPTask
{
	virtual bool initialize();

	virtual void handleCallback(sal_Int32, const sal_Char *);

public:
	inline CntFTPCloseConnectionTask(CntNodeJob & rJob, CntFTPImp & rImp);
};

CntFTPCloseConnectionTask::CntFTPCloseConnectionTask(CntNodeJob & rJob,
													 CntFTPImp & rImp):
	CntFTPTask(rJob, rImp, CntFTPImp::LINK_NO, false,
			   inet::INetFTPConnection::DATA_TYPE_UNKNOWN, true)
{}

} // namespace chaos

#endif // CHAOS_CNFTPTSK_HXX

