/*************************************************************************
 *
 *  $RCSfile: coutimp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 17:42:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _COUTIMP_CXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif
#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef SVTOOLS_TRESITEM_HXX
#include <svtools/tresitem.hxx>
#endif

#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _INETCOREMAIL_HXX
#include <inet/inetmail.hxx>
#endif
#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif

#ifndef _CNTOUTIMP_HXX
#include <coutimp.hxx>
#endif
#ifndef _CNTINET_HXX
#include <cntinet.hxx>
#endif
#ifndef _CNTMSGNODE_HXX
#include <cntmsgnd.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

using namespace com::sun::star;

using namespace chaos;

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF(CntStoreItemSet);
#endif

/*========================================================================
 *
 * CntOut... internals.
 *
 *======================================================================*/
/*
 * CntStoreItemSet Ranges.
 */
COUTBOX_DIR_RANGES_IMPL (aBoxDirRanges_Impl);
COUTMSG_DIR_RANGES_IMPL (aMsgDirRanges_Impl);

/*========================================================================
 *
 * CntOutTrayNode_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutTrayNode_Impl.
 */
CntOutTrayNode_Impl::CntOutTrayNode_Impl (
	CntNode *pParent, CntConnMode eConnMode)
	: m_pParent      (pParent),
	  m_pMailer      (NULL),
	  m_eConnMode    (eConnMode),
	  m_bInitialized (FALSE)
{
}

/*
 * ~CntOutTrayNode_Impl.
 */
CntOutTrayNode_Impl::~CntOutTrayNode_Impl (void)
{
	delete m_pMailer;
}

/*
 * Initialize.
 */
BOOL CntOutTrayNode_Impl::Initialize (CntNodeJob *pJob)
{
	if (!m_bInitialized)
	{
		// Obtain cache node.
		CntStorageNode *pCache = pJob->GetCacheNode();
		DBG_ASSERT (pCache, "CntOutTrayNode_Impl::Initialize(): no Cache");
		if (pCache == NULL)
			return FALSE;

		// Restore own properties.
		const SfxPoolItem *pItem = NULL;
		if (pCache->GetItemState (WID_SEND_SERVERNAME, TRUE, &pItem)
			> SFX_ITEM_DEFAULT)
			m_pParent->Put (*pItem);

		pItem = NULL;
		if (pCache->GetItemState (WID_SEND_USERNAME, TRUE, &pItem)
			> SFX_ITEM_DEFAULT)
			m_pParent->Put (*pItem);

		pItem = NULL;
		if (pCache->GetItemState (WID_SEND_PASSWORD, TRUE, &pItem)
			> SFX_ITEM_DEFAULT)
			m_pParent->Put (*pItem);

		pItem = NULL;
		if (pCache->GetItemState (WID_SEND_VIM_POPATH, TRUE, &pItem)
			> SFX_ITEM_DEFAULT)
			m_pParent->Put (*pItem);

		// Restore Box itemset.
		CntStoreItemSetRef xBoxSet (GetBoxItemSet (pCache));
		if (xBoxSet.Is())
		{
			m_pParent->Put (*xBoxSet);
			xBoxSet.Clear();
		}

		// Done.
		m_bInitialized = TRUE;
	}
	return m_bInitialized;
}

/*
 * GetBoxItemSet.
 */
CntStoreItemSet* CntOutTrayNode_Impl::GetBoxItemSet (CntStorageNode *pCache)
{
	// Check context.
	if ((pCache == NULL) || pCache->IsDummy())
		return NULL;

	// Open Box itemset.
	CntStoreItemSet *pBoxSet = pCache->openItemSet (
		aBoxDirRanges_Impl, S2U ("OUTBOXDATA"),
		STREAM_READWRITE | STREAM_NOCREATE);
	if (pBoxSet == NULL)
	{
		// Backward compatibility.
		UniString aName (S2U ("OUTBOXDATA"));

		UniString aUrl  (OWN_URL (m_pParent));
		aUrl.AppendAscii ("/OUTBOXDATA");

		if (pCache->attrib (aUrl, 0, 0) == ERRCODE_NONE)
		{
			// Rename into OUTBOXDATA itemset.
			pCache->rename (aUrl, aName);

			// Open itemset.
			pBoxSet = pCache->openItemSet (
				aBoxDirRanges_Impl, aName,
				STREAM_READWRITE | STREAM_NOCREATE);
		}
		else
		{
			// Create new OUTBOXDATA itemset.
			pCache->attrib (aName, 0,
				CNTDIRENTRY_ATTRIB_HIDDEN | CNTDIRENTRY_ATTRIB_CREATE);
			pBoxSet = pCache->openItemSet (
				aBoxDirRanges_Impl, aName,
				STREAM_READWRITE | STREAM_NOCREATE);

			// Initialize itemset.
			if (pBoxSet)
			{
				pBoxSet->Put (CntUInt32Item (WID_TOTALCONTENTCOUNT, 0));
				pBoxSet->Put (CntUInt32Item (WID_SENTCONTENTCOUNT, 0));
			}
		}
	}
	return pBoxSet;
}

/*
 * SetConnMode.
 */
void CntOutTrayNode_Impl::SetConnMode (CntConnMode eConnMode)
{
	if (m_eConnMode != eConnMode)
	{
		// Accept new connection mode.
		m_eConnMode = eConnMode;

		// Check for 'Session' begin.
		if (m_eConnMode == CNT_CONN_MODE_ONLINE)
		{
			// Initialize CntOutBoxSendJob_Impl execution.
			CntNodeJob *pJob = new CntNodeJob (
				NULL, m_pParent, m_pParent,
				SfxVoidItem (WID_UPDATE));

			CntOutJob_Impl *pJobImpl =
				new CntOutBoxSendJob_Impl (pJob, this);
			pJob->SetRequestData (pJobImpl);

			// Insert job at parent.
			m_pParent->InsertJob (pJob);
			return;
		}

		// Check for 'Session' end.
		if ((m_eConnMode == CNT_CONN_MODE_OFFLINE) && (m_pMailer != NULL))
		{
			// Initialize CntOutCloseJob_Impl execution.
			CntNodeJob *pJob = new CntNodeJob (
				NULL, m_pParent, m_pParent,
				CntConnModeItem (WID_CONNECTION_MODE, m_eConnMode));

			CntOutJob_Impl *pJobImpl =
				new CntOutCloseJob_Impl (pJob, this);
			pJob->SetRequestData (pJobImpl);

			// Insert job at parent.
			m_pParent->InsertJob (pJob);
			return;
		}
	}
}

/*
 * GetMailer.
 */
INetCoreMailer* CntOutTrayNode_Impl::GetMailer (void)
{
	NAMESPACE_VOS(OGuard) aGuard (m_pParent->getMutex());
	if (m_pMailer == NULL)
	{
		NAMESPACE_INET(INetWrapper) *pWrapper;
		if (CNT_RNM()->getINetWrapper (pWrapper))
		{
			CntINetConfig::load (pWrapper, CNT_RNM()->GetIniManager());

			pWrapper->newINetCoreMailer (m_pMailer);
			DBG_ASSERT(
				m_pMailer, "CntOutTrayNode_Impl::GetMailer(): no Mailer");
		}
	}
	return m_pMailer;
}

/*
 * PutMailer.
 */
void CntOutTrayNode_Impl::PutMailer (INetCoreMailer *pMailer)
{
	NAMESPACE_VOS(OGuard) aGuard (m_pParent->getMutex());
	if ((pMailer == m_pMailer) && (m_pMailer != NULL))
	{
		// Disconnect and release Mailer.
		m_pMailer->NewsCloseConnection (NULL, NULL);
		m_pMailer->SendCloseConnection (NULL, NULL);
		DELETEZ (m_pMailer);
	}
}

/*
 * setMessageCopyResult.
 */
void CntOutTrayNode_Impl::setMessageCopyResult(CntNodeJob & rJob)
{
	if (rJob.GetCacheNode())
	{
		CntNode * pSubject = rJob.GetSubject();
		ucb::TransferResult const & rResult
			= ITEM_VALUE(CntTransferResultItem, *rJob.GetRequest());
		DBG_ASSERT(
			rResult.Source.equals (OWN_URL (pSubject)),
			"CntOutTrayNode_Impl::setMessageCopyResult(): Bad source");

		CntRecipientListItem aRcptList
			= *static_cast< CntRecipientListItem const * >(
				&pSubject->Get(WID_RECIPIENTLIST));
		for (USHORT i = 0; i < aRcptList.Count(); ++i)
			if (aRcptList[i]->GetProtocol() == CNT_OUTMSG_PROTOCOL_COPY
				&& rResult.Target.equals (aRcptList[i]->GetToRecipient()))
			{
				bool bModified = false;
				if (rResult.Result.hasValue()) // i.e., contains an exception
					switch (aRcptList[i]->GetState())
					{
						case CNTOUT_ISTATE_WRITTEN:
						case CNTOUT_ISTATE_WAITCONFIRMED:
						case CNTOUT_ISTATE_ERROR:
							aRcptList[i]->IncSendTries();
							aRcptList[i]->
								SetState(aRcptList[i]->GetSendTries()
										         < COUTIMP_SENDTRIES_LIMIT ?
								             CNTOUT_ISTATE_ERROR :
										     CNTOUT_ISTATE_FATALERROR);
							bModified = true;
							break;
					}
				else
					switch (aRcptList[i]->GetState())
					{
						case CNTOUT_ISTATE_WRITTEN:
						case CNTOUT_ISTATE_WAITCONFIRMED:
						case CNTOUT_ISTATE_ERROR:
						case CNTOUT_ISTATE_FATALERROR:
						case CNTOUT_ISTATE_EXTERNALERROR:
							aRcptList[i]->SetState(CNTOUT_ISTATE_SENT);
							bModified = true;
							break;
					}
				if (bModified)
				{
					pSubject->Put(aRcptList);

					String aID (OWN_URL (pSubject));
					aID.AppendAscii (".node");

					CntStoreItemSetRef xDirSet (
						rJob.GetCacheNode()->openItemSet (
							aMsgDirRanges_Impl, aID,
							STREAM_READWRITE | STREAM_NOCREATE));
					if (xDirSet.Is())
					{
						xDirSet->Put(aRcptList);
						xDirSet.Clear();
					}

					updateMessageStatus(rJob);
				}
				break;
			}
	}
}

/*
 * updateMessageStatus.
 */
void CntOutTrayNode_Impl::updateMessageStatus(CntNodeJob & rJob)
{
	CntNode *pSubject = rJob.GetSubject();
	String aNodeURL = OWN_URL (pSubject);
	aNodeURL.AppendAscii (".node");

	CntRecipientListItem const & rRcptList
		= *static_cast< CntRecipientListItem const * >(
			&pSubject->Get(WID_RECIPIENTLIST));

	// Check send result.
	CntOutMsgInternalState eState;
	if (rRcptList.IsCompletelySent())
	{
		// Mark as sent.
		eState = CNTOUT_ISTATE_SENT;

		// Remove unsent attribute.
		ErrCode eErrCode = rJob.GetCacheNode()->attrib (
			aNodeURL, CNTDIRENTRY_ATTRIB_UNSENT, 0);
		if (eErrCode == ERRCODE_NONE)
		{
			// Obtain SentContentCount.
			ULONG nSent = ITEMSET_VALUE_UINT32(
				GetParent(), WID_SENTCONTENTCOUNT);
			CntStoreItemSetRef xBoxSet (
				GetBoxItemSet (rJob.GetCacheNode()));
			if (xBoxSet.Is())
			{
				nSent = ITEMSET_VALUE_UINT32(
					GetParent(), WID_SENTCONTENTCOUNT);
			}
			nSent += 1;

			// Update Box: SentContentCount.
			CntUInt32Item aSentCount (WID_SENTCONTENTCOUNT, nSent);
			GetParent()->Put (aSentCount);
			if (xBoxSet.Is())
				xBoxSet->Put (aSentCount);
		}
	}
	else
	{
		// Setup InternalState as partially sent.
		eState = CNTOUT_ISTATE_PARTSENT;
		if (!rRcptList.IsPartiallySent())
		{
			// Not even partially sent. Determine worst state.
			eState = CNTOUT_ISTATE_WRITTEN;
			for (USHORT i = 0; i < rRcptList.Count(); i++)
			{
				const CntRecipientInfo *pInfo = rRcptList[i];
				if (eState != CNTOUT_ISTATE_ERROR)
					eState = pInfo->GetState();
				if (eState == CNTOUT_ISTATE_FATALERROR)
					break;
			}
		}

	}

	// Set InternalState.
	CntOutMsgInternalStateItem aState (WID_OUTMSGINTERNALSTATE, eState);
	pSubject->Put (aState);

	CntStoreItemSetRef xDirSet (rJob.GetCacheNode()->openItemSet (
		aMsgDirRanges_Impl, aNodeURL, STREAM_READWRITE | STREAM_NOCREATE));
	if (xDirSet.Is())
		xDirSet->Put (aState);
}

/*========================================================================
 *
 * CntOutMessage_Impl implementation.
 *
 *======================================================================*/
/*
 * setRecipientList.
 */
void CntOutMessage_Impl::setRecipientList (
	CntInterface       &rMessage,
	const CntInterface &rPropSet)
{
	// Setup RecipientList.
	CntRecipientListItem aRcptList (WID_RECIPIENTLIST);

	const CntStringItem& rTo =
		(const CntStringItem&)(rMessage.Get(WID_TO));
	CntOutMessage_Impl::parseRecipient (aRcptList, rTo, rPropSet);

	const CntStringItem& rCopy =
		(const CntStringItem&)(rMessage.Get(WID_CC));
	CntOutMessage_Impl::parseRecipient (aRcptList, rCopy, rPropSet);

	const CntStringItem& rBlind =
		(const CntStringItem&)(rMessage.Get(WID_BCC));
	CntOutMessage_Impl::parseRecipient (aRcptList, rBlind, rPropSet);

	const CntStringItem& rGroups =
		(const CntStringItem&)(rMessage.Get(WID_NEWSGROUPS));
	CntOutMessage_Impl::parseRecipient (aRcptList, rGroups, rPropSet);

	aRcptList.CleanUpAndPromoteAddresses_Impl();
	rMessage.Put (aRcptList);

	// Cleanup sensitive information (e.g. passwords).
	rMessage.Put (CntStringItem (
		WID_TO, aRcptList.GetToString()));
	rMessage.Put (CntStringItem (
		WID_CC, aRcptList.GetCcString()));
	rMessage.Put (CntStringItem (
		WID_BCC, aRcptList.GetBccString()));
	rMessage.Put (CntStringItem (
		WID_NEWSGROUPS, aRcptList.GetNewsgroupString()));
}

/*
 * parseRecipient.
 */
void CntOutMessage_Impl::parseRecipient (
	CntRecipientListItem &rRcptList,
	const CntStringItem  &rAddrList,
	const CntInterface   &rPropSet)
{
	// Format von AddrList:
	// Addr1, Addr2, ...

	// Format einer einzelnen Adresse:
	// {"mailto"|"news"}://user:password@server:port:protocol/recipient
	// oder:
	// "copy:"url
	//
	// For protocol 'vim', the server part in the above format
	// in fact is a (quoted) 'server base' path.

	// Aeussere Schleife: alle einzelnen Adressaten herausholen.
	String aAddr (rAddrList.GetValue()), aQuote (S2U(COUTIMP_ADDRESS_QUOTE));

	xub_StrLen nCount = aAddr.GetQuotedTokenCount (aQuote, ',');
	for (xub_StrLen nCurAdr = 0; nCurAdr < nCount; nCurAdr++)
	{
		// verarbeite einen Adressaten
		String aCurAdr (aAddr.GetQuotedToken (nCurAdr, aQuote, ','));
		if (aCurAdr.CompareIgnoreCaseToAscii("copy:", 5) == COMPARE_EQUAL)
		{
			String aURL = INetURLObject::decode(
				aCurAdr.Copy(5), '=', INetURLObject::DECODE_WITH_CHARSET);
			bool bFound = false;
			for (USHORT i = 0; i < rRcptList.Count(); ++i)
				if (rRcptList[i]->GetProtocol() == CNT_OUTMSG_PROTOCOL_COPY
					&& rRcptList[i]->GetToRecipient() == aURL)
				{
					bFound = true;
					break;
				}
			if (!bFound)
				rRcptList.Append (new CntRecipientInfo (
					aURL, String(), String(),
					String(), String(), String(),
					CNT_OUTMSG_PROTOCOL_COPY,
					CNTOUT_ISTATE_WRITTEN,
					0, 0,
					String(), String(), String()));
		}
		else
		{
			xub_StrLen nPos = 0;
			BOOL bNews = FALSE; // FALSE = mailto, TRUE = news

			String aServer;
			String aVIMPOPath;
			String aUser;
			String aPassword;
			String aProtocol (S2U ("smtp"));
			String aRecipient;

			// suche mailto oder news
			nPos = aCurAdr.SearchAscii ("://");
			if( nPos != STRING_NOTFOUND )
			{
				// mailto oder news protocol specifier vorhanden
				// skip ://
				String aProtSpec (COUTIMP_CUT_STRING (aCurAdr, 0, nPos + 3));

				///////////////////////////////////////////////////////////
				// aCurAdr now: user:password@server:port:protocol/recipient
				///////////////////////////////////////////////////////////

				if (aProtSpec.EqualsAscii ("mailto://"))
					bNews = FALSE;
				else if (aProtSpec.EqualsAscii ("news://"))
					bNews = TRUE;
				else
				{
#if 0
					DBG_ERROR2(
						"Protocol for %s is neither mailto nor news, but %s",
						aCurAdr.GetStr(), aProtSpec.GetStr() );
#endif // 0
					bNews = FALSE;
				}
			}

#ifdef DEBUG
			// Zusammenhang mit WID ueberpruefen
			if( bNews && rAddrList.Which() != WID_NEWSGROUPS )
			{
				DBG_ERROR(
					"news address ausserhalb von WID_NEWSGROUPS angegeben" );
			}
			if( !bNews && rAddrList.Which() == WID_NEWSGROUPS )
			{
				DBG_ERROR( "mail address in WID_NEWSGROUPS angegeben" );
			}
#endif /* DEBUG */

			// suche server/protocol
			nPos = aCurAdr.Search( '/' );
			if( nPos != STRING_NOTFOUND )
			{
				// server (and possibly protocol specifier) present
				String aServProt (COUTIMP_CUT_STRING (aCurAdr, 0, nPos));

				//////////////////////////////////////////////////
				// aServProt now : user:password@server:port:protocol
				//////////////////////////////////////////////////

				aCurAdr = aCurAdr.Copy( 1 ); // cut '/'

				//////////////////////////////////////////////////
				// aCurAdr now: recipient
				//////////////////////////////////////////////////

				nPos = aServProt.Search( '@' );
				if ( nPos != STRING_NOTFOUND )
				{
					// user (and possibly password) present
					aUser = COUTIMP_CUT_STRING (aServProt, 0, nPos);

					///////////////////////////////////////////////
					// aUser now: user:password
					///////////////////////////////////////////////

					aServProt = aServProt.Copy( 1 ); // '@' abschneiden

					///////////////////////////////////////////////
					// aServProt now : server:port:protocol
					///////////////////////////////////////////////

					nPos = aUser.Search( ':' );
					if ( nPos != STRING_NOTFOUND )
					{
						// password present
						aPassword = aUser.Copy (nPos + 1);
						aUser.Erase (nPos);
					}
				}

				nPos = aServProt.Search( ':' );
				if( nPos != STRING_NOTFOUND )
				{
#ifdef DEBUG
					BOOL bProtocolPresent = FALSE;
#endif /* DEBUG */
					xub_StrLen nPos2 = aServProt.Search(':', nPos + 1);
					if (nPos2 == STRING_NOTFOUND)
					{
						const sal_Unicode *pBegin =
							aServProt.GetBuffer() + nPos + 1;
						const sal_Unicode *pEnd =
							aServProt.GetBuffer() + aServProt.Len();
						sal_uInt32 nValue = 0;

						if (INetMIME::scanUnsigned (
							pBegin, pEnd, true, nValue) && (pBegin == pEnd))
						{
							aServer = aServProt.Copy(0, nPos);
							aProtocol = aServProt.Copy(nPos + 1);
#ifdef DEBUG
							bProtocolPresent = TRUE;
#endif /* DEBUG */
						}
					}
					else
					{
						aServer = aServProt.Copy(0, nPos2);
						aProtocol = aServProt.Copy(nPos2 + 1);
#ifdef DEBUG
						bProtocolPresent = TRUE;
#endif /* DEBUG */
					}

#ifdef DEBUG
					if (bProtocolPresent)
					{
						// pruefe ob Protokoll, und mailto/news zusammenpassen
						if( aProtocol.EqualsAscii("nntp"))
						{
							if( !bNews )
							{
								DBG_ERROR( "mailto is incompatible with nntp" );
							}
						}
						else if( aProtocol.EqualsAscii("smtp") ||
								 aProtocol.EqualsAscii("vim")  ||
								 aProtocol.EqualsAscii("mapi") ||
								 aProtocol.EqualsAscii("mbox") ||
								 aProtocol.EqualsAscii("unix") )
						{
							if( bNews )
							{
#if 0
								DBG_ERROR1( "news is incompatible with %s",
											aProtocol.GetStr() );
#endif // 0
							}
						}
						else
						{
#if 0
							DBG_ERROR1( "protocol not recognized: %s",
										aProtocol.GetStr() );
#endif // 0
						}

						// pruefe, ob Protokoll und WID zusammenpassen
						if( aProtocol.EqualsAscii("nntp") &&
							rAddrList.Which() != WID_NEWSGROUPS )
						{
							DBG_ERROR(
								"nntp ausserhalb von WID_NEWSGROUPS angegeben" );
						}
						if( !aProtocol.EqualsAscii("nntp") &&
							rAddrList.Which() == WID_NEWSGROUPS )
						{
							DBG_ERROR(
								"Wrong protocol in WID_NEWSGROUPS angegeben" );
						}
					}
#endif /* DEBUG */
				}
				else
				{
					// kein Protokoll angegeben, default ist SMTP fuer mail,
					// NNTP fuer News
					if ( bNews )
						aProtocol.AssignAscii ("nntp");
					else
						aProtocol.AssignAscii ("smtp");

					aServer = aServProt;
				}

				// Unquote username and password:
				aUser = INetURLObject::decode (
					aUser, '=', INetURLObject::DECODE_WITH_CHARSET);
				aPassword = INetURLObject::decode (
					aPassword, '=', INetURLObject::DECODE_WITH_CHARSET);

				// If the protocol is VIM, turn a possible server into a
				// (unquoted) 'server base' path:
				if (aProtocol.EqualsAscii("vim") && aServer.Len())
				{
					aVIMPOPath = INetURLObject::decode (
						aServer, '=', INetURLObject::DECODE_WITH_CHARSET);
					aServer.Erase();
				}
			}

			if (!aServer.Len() && !aProtocol.EqualsAscii("vim"))
			{
				// vim w/o server is ok
				aUser.Erase();
				aPassword.Erase();

				if (aProtocol.EqualsAscii("smtp"))
				{
					// get server only (no user/password!)
					aServer = querySendInfo (
						rPropSet,
						WID_SEND_SERVERNAME, CNT_OUTMSG_PROTOCOL_SMTP);
					if (aServer.Len() == 0)
					{
						// last choice - Ini value
						CntIniManager* pIniMgr = CNT_RNM()->GetIniManager();
						aServer = pIniMgr->getEntry(CNT_KEY_INET_SMTPSERVER);
					}
				}
				else
				{
					// get server/user/password.
					aServer = querySendInfo (
						rPropSet,
						WID_SEND_SERVERNAME, CNT_OUTMSG_PROTOCOL_NNTP);
					if (aServer.Len())
					{
						aUser = querySendInfo (
							rPropSet,
							WID_SEND_USERNAME, CNT_OUTMSG_PROTOCOL_NNTP);
						aPassword = querySendInfo (
							rPropSet,
							WID_SEND_PASSWORD, CNT_OUTMSG_PROTOCOL_NNTP);
					}
					else
					{
						// last choice - Ini values
						CntIniManager* pIniMgr = CNT_RNM()->GetIniManager();
						aServer = pIniMgr->getEntry(CNT_KEY_INET_NNTPSERVER);

						// no Ini values for username/password available.
						aUser.Erase();
						aPassword.Erase();
					}
				}
			}

#ifdef DEBUG
			if (!aServer.Len() && !aProtocol.EqualsAscii("vim"))
			{
				// vim w/o server is ok
				DBG_ASSERT(
					!aUser.Len() && !aPassword.Len(),
					"Kein Servername, aber Username und/oder Password!");
			}

			if ( !aUser.Len() )
			{
				DBG_ASSERT( !aPassword.Len(),
							"Kein Username, aber Password!" );
			}
#endif /* DEBUG */

			// was uebrig bleibt, ist der Empfaenger
			aRecipient = aCurAdr;

			// RecipientInfo-Struktur an Item anhaengen
			DBG_ASSERT(
				aProtocol.Len(), "Kein Protokoll bekannt" );
			DBG_ASSERT(
				aServer.Len() > 0 || aProtocol.EqualsAscii("vim"),
				"Kein Server bekannt"); // vim w/o server is ok
			DBG_ASSERT(
				aRecipient.Len(), "Kein Empfaenger bekannt" );

			CntOutMsgProtocolType eProt;
			if (aProtocol.EqualsAscii("smtp"))
				eProt = CNT_OUTMSG_PROTOCOL_SMTP;
			else if (aProtocol.EqualsAscii("vim"))
				eProt = CNT_OUTMSG_PROTOCOL_VIM;
			else if (aProtocol.EqualsAscii("mapi"))
				eProt = CNT_OUTMSG_PROTOCOL_MAPI;
			else if (aProtocol.EqualsAscii("mbox"))
				eProt = CNT_OUTMSG_PROTOCOL_MBOX;
			else if (aProtocol.EqualsAscii("nntp"))
				eProt = CNT_OUTMSG_PROTOCOL_NNTP;
			else
			{
				DBG_ERROR ("Kein gueltiges Protokoll, defaulte auf smtp");
				eProt = CNT_OUTMSG_PROTOCOL_SMTP;
			}


			// und noch schnell die Rolle des Empfaengers festhalten
			CntOutMsgRoleType eRole;
			switch (rAddrList.Which())
			{
				case WID_TO:
					eRole = CNT_OUTMSG_ROLE_TO;
					break;

				case WID_CC:
					eRole = CNT_OUTMSG_ROLE_CC;
					break;

				case WID_BCC:
					eRole = CNT_OUTMSG_ROLE_BCC;
					break;

				case WID_NEWSGROUPS:
					eRole = CNT_OUTMSG_ROLE_NEWSGROUP;
					break;

				default:
					DBG_ERROR("CntOutMessage_Impl::parseRecipient(): unknown WID");
					eRole = CNT_OUTMSG_ROLE_TO;
					break;
			}

			String aToRecipients;
			String aCcRecipients;
			String aBccRecipients;
			String aNewsRecipients;

			// nachschauen, ob wir einen alten Eintrag weiterverwenden koennen
			CntRecipientInfo *pOldInfo = rRcptList.Find (
				eProt, aUser, aPassword, aServer, aVIMPOPath);
			if (pOldInfo)
			{
				// yep, so einen gibt es schon
				aToRecipients   = pOldInfo->GetToRecipient();
				aCcRecipients   = pOldInfo->GetCcRecipient();
				aBccRecipients  = pOldInfo->GetBccRecipient();
				aNewsRecipients = pOldInfo->GetNewsRecipient();

				switch( eRole )
				{
					case CNT_OUTMSG_ROLE_TO:
						if( aToRecipients.Len() )
							aToRecipients += sal_Unicode(',');
						aToRecipients += aRecipient;
						break;

					case CNT_OUTMSG_ROLE_CC:
						if( aCcRecipients.Len() )
							aCcRecipients += sal_Unicode(',');
						aCcRecipients += aRecipient;
						break;

					case CNT_OUTMSG_ROLE_BCC:
						if( aBccRecipients.Len() )
							aBccRecipients += sal_Unicode(',');
						aBccRecipients += aRecipient;
						break;

					case CNT_OUTMSG_ROLE_NEWSGROUP:
						if( aNewsRecipients.Len() )
							aNewsRecipients += sal_Unicode(',');
						aNewsRecipients += aRecipient;
						break;

					default:
						// sollte nicht vorkommen
						break;
				}

				// alte Info wegschmeissen
				rRcptList.Delete (pOldInfo);
			}
			else
			{
				// so einen gibt's noch nicht, also nur ein Feld fuellen
				switch( eRole )
				{
					case CNT_OUTMSG_ROLE_TO:
						aToRecipients = aRecipient;
						break;

					case CNT_OUTMSG_ROLE_CC:
						aCcRecipients = aRecipient;
						break;

					case CNT_OUTMSG_ROLE_BCC:
						aBccRecipients = aRecipient;
						break;

					case CNT_OUTMSG_ROLE_NEWSGROUP:
						aNewsRecipients = aRecipient;
						break;

					default:
						// sollte nicht vorkommen
						break;
				}
			}

			rRcptList.Append (new CntRecipientInfo (
				aToRecipients,
				aCcRecipients,
				aBccRecipients,
				aNewsRecipients,
				aServer,
				CntResId(RID_CNTOUT_MAILSTATE_NOT_SENT),
				eProt,
				CNTOUT_ISTATE_WRITTEN,
				0,
				0,
				aUser,
				aPassword,
				aVIMPOPath));
		}
	}
}

/*
 * querySendInfo.
 */
String CntOutMessage_Impl::querySendInfo (
	const CntInterface &rPropSet, USHORT nWhich, CntOutMsgProtocolType eProto)
{
	const String *pInfo =
	 ((const CntSendInfoListItem&)(rPropSet.Get(nWhich))).findEntry(eProto);
	if (pInfo)
		return *pInfo;
	else
		return String();
}

/*========================================================================
 *
 * CntOutJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutJob_Impl.
 */
CntOutJob_Impl::CntOutJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: SfxListener (),
	  m_xJob      (pJob),
	  m_pParent   (pParent)
{
	if (m_xJob.Is())
	{
		AddRef();
		m_xJob->SetRequestData (this);
		StartListening (*m_xJob);
	}
}

/*
 * ~CntOutJob_Impl.
 */
CntOutJob_Impl::~CntOutJob_Impl (void)
{
	if (m_xJob.Is())
	{
		EndListening (*m_xJob);
		m_xJob->SetRequestData (NULL);
	}
}

/*
 * Broadcast.
 */
void CntOutJob_Impl::Broadcast (const SfxHint& rHint)
{
	if (m_xJob.Is())
	{
		CntNodeJob *pJob = m_xJob;
		while (pJob->GetParent())
			pJob = pJob->GetParent();
		pJob->Broadcast (rHint);
	}
}

/*
 * Notify.
 */
void CntOutJob_Impl::Notify (SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntNodeJob *pJob = PTR_CAST (CntNodeJob, &rBC);
	if ((pJob != NULL) && (pJob == &m_xJob))
	{
		if (m_xJob->IsCancelled() || m_xJob->IsDone())
		{
			// Our job is finished here.
			EndListening (*m_xJob);
			ReleaseRef();
		}
	}
}

/*========================================================================
 *
 * CntOutBoxOpenJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutBoxOpenJob_Impl.
 */
CntOutBoxOpenJob_Impl::CntOutBoxOpenJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pCache       (NULL),
	  m_pIter        (NULL),
	  m_nIter        (0),
	  m_nSent        (0),
	  m_eViewMode    (CNT_SENT_VIEW_ALL_ARTICLES),
	  m_eState       (STATE_NONE)
{
}

/*
 * ~CntOutBoxOpenJob_Impl.
 */
CntOutBoxOpenJob_Impl::~CntOutBoxOpenJob_Impl (void)
{
	delete m_pIter;
}

/*
 * queryResult.
 */
CntNode* CntOutBoxOpenJob_Impl::queryResult (
	const String &rUrl, UINT32 nAttrib)
{
	// Query a CntMessageNode.
	String aMsgURL (rUrl, 0, rUrl.Len() - 5);

	CntNode *pNode = GetRootNode()->Query (aMsgURL);
	if ((pNode == NULL) || pNode->IsInserted())
		return pNode;

	// Obtain message itemset.
	CntStoreItemSetRef xDirSet (m_pCache->openItemSet (
		aMsgDirRanges_Impl, rUrl, STREAM_STD_READ));
	if (xDirSet.Is())
	{
		pNode->Put (*xDirSet);
		xDirSet.Clear();
	}

	// Set attributes.
	BOOL bMarked = (nAttrib & CNTDIRENTRY_ATTRIB_MARKED) ? 1 : 0;
	pNode->Put (CntBoolItem (WID_IS_MARKED, bMarked));

	// Set state indicators.
	const CntRecipientListItem *pRcptList = NULL;
	pNode->GetItemState (
		WID_RECIPIENTLIST, FALSE, (const SfxPoolItem**)&pRcptList);
	if (pRcptList)
	{
		BOOL bLocked = ((CntMessageNode *)pNode)->GetIsLocked();
		pNode->Put (CntBoolItem (
			WID_FLAG_READONLY, (bLocked || pRcptList->IsPartiallySent())));

		if (!bLocked && pRcptList->IsCompletelyProcessed())
			pNode->ClearItem (WID_RESEND_MSG);
	}

	// Backward compatibility.
	const SfxPoolItem *pItem = NULL;
	pNode->GetItemState (WID_SIZE, FALSE, &pItem);
	if (pItem == NULL)
	{
		// Open message body.
		String aBodyURL (aMsgURL);
		aBodyURL.AppendAscii (".body");

		SvStream *pStrm = m_pCache->openStream (aBodyURL, STREAM_STD_READ);
		if (pStrm)
		{
			// Determine message size.
			ULONG nSize = pStrm->Seek (STREAM_SEEK_TO_END);
			delete pStrm;

			// Store message size.
			CntUInt32Item aSize (WID_SIZE, nSize);
			pNode->Put (aSize);

			xDirSet = m_pCache->openItemSet (
				aMsgDirRanges_Impl, rUrl, STREAM_READWRITE | STREAM_NOCREATE);
			if (xDirSet.Is())
				xDirSet->Put (aSize);
		}
	}

	// Done.
	return pNode;
}

/*
 * querySent.
 */
BOOL CntOutBoxOpenJob_Impl::querySent (
	CntNode *pNode, const String &rUrl, UINT32 nAttrib)
{
	// Check context.
	if (!(m_eViewMode == CNT_SENT_VIEW_ALL_ARTICLES))
		return FALSE;

	// Check arguments.
	if ((pNode == NULL) || (rUrl.Len() == 0))
		return FALSE;

	// Obtain RecipientList.
	const CntRecipientListItem *pRcptList = NULL;
	pNode->GetItemState (
		WID_RECIPIENTLIST, FALSE, (const SfxPoolItem**)&pRcptList);
	if (pRcptList)
	{
		// Check for completely sent.
		if (pRcptList->IsCompletelySent())
		{
			// Verify unsent attribute is not set.
			if (nAttrib & CNTDIRENTRY_ATTRIB_UNSENT)
			{
				// Repair (i.e. remove) unsent attribute.
				m_pCache->attrib (rUrl, CNTDIRENTRY_ATTRIB_UNSENT, 0);
			}
			return TRUE;
		}
	}

	// Verify unsent attribute is set.
	if (!(nAttrib & CNTDIRENTRY_ATTRIB_UNSENT))
	{
		// Repair (i.e. set) unsent attribute.
		m_pCache->attrib (rUrl, 0, CNTDIRENTRY_ATTRIB_UNSENT);
	}
	return FALSE;
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutBoxOpenJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutBoxOpenJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Check request.
	const SfxPoolItem *pReq = pJob->GetRequest();
	DBG_ASSERT (pReq, "CntOutBoxOpenJob_Impl::Execute(): no Request");
	if (pReq == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Initialize.
	ULONG nStartTicks = Time::GetSystemTicks();
	if (m_eState == STATE_NONE)
	{
		// Obtain cache node.
		m_pCache = pJob->GetCacheNode();
		DBG_ASSERT(
			m_pCache, "CntOutBoxOpenJob_Impl::Execute(): no Cache");
		if (m_pCache == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain client.
		CntInterface *pClient = pJob->GetClient();
		DBG_ASSERT(
			pClient, "CntOutBoxOpenJob_Impl::Execute(): no Client");
		if (pClient == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Determine (view mode dependent) iteration mask.
		UINT32 nInclMask = 0;
		UINT32 nExclMask = 0;

		m_eViewMode = ITEMSET_VALUE(
			pClient, CntSentMsgViewModeItem, WID_SENTMESSAGEVIEW_MODE);
		switch (m_eViewMode)
		{
			case CNT_SENT_VIEW_SENT_ARTICLES:
				nExclMask |= CNTDIRENTRY_ATTRIB_UNSENT;
				break;

			case CNT_SENT_VIEW_UNSENT_ARTICLES:
				nInclMask |= CNTDIRENTRY_ATTRIB_UNSENT;
				break;

			case CNT_SENT_VIEW_MARKED_ARTICLES:
				nInclMask |= CNTDIRENTRY_ATTRIB_MARKED;
				break;

			default: // CNT_SENT_VIEW_ALL_ARTICLES
				break;
		}

		// Complete exclude mask.
		nExclMask |= CNTDIRENTRY_ATTRIB_HIDDEN;
		nExclMask |= CNTDIRENTRY_ATTRIB_MARKEDFORDELETE;

		// Initialize cache node iteration.
		m_pIter = new CntStorageIterator (nInclMask, nExclMask);
		m_nIter = 0;

		// Next state.
		m_eState = STATE_OPEN;
	}

	if (m_eState == STATE_OPEN)
	{
		m_pCache->iter (*m_pIter);
		while (!m_pIter->eof())
		{
			// Process current message.
			CntNodeRef xNode (queryResult (
				(**m_pIter).m_pszName, (**m_pIter).m_nAttrib));
			if (xNode.Is())
			{
				// Check for sent message.
				if (querySent (
					xNode, (**m_pIter).m_pszName, (**m_pIter).m_nAttrib))
					m_nSent++;

				// Notify caller.
				pJob->Result (xNode);
				if (pReq->Which() == WID_SEARCH)
					pJob->ResultSearchMatch (xNode);
			}
			m_nIter++;

			// Check elapsed time.
			ULONG nTicks = Time::GetSystemTicks();
			if ((nTicks - nStartTicks) > COUTJOB_RESCHEDULE_TIMELIMIT)
			{
				// Notify caller.
				// Be nice.
				GetRootNode()->RescheduleJob (pJob);
				return NULL;
			}

			// Next.
			m_pCache->iter (*m_pIter);
		}

		// Check view mode.
		if (m_eViewMode == CNT_SENT_VIEW_ALL_ARTICLES)
		{
			// Obtain Known/Sent ContentCount.
			CntStoreItemSetRef xBoxSet (
				GetParent()->GetBoxItemSet (m_pCache));
			if (xBoxSet.Is())
			{
				// Check KnownContentCount.
				ULONG nKnown = ITEMSET_VALUE_UINT32(
					xBoxSet, WID_TOTALCONTENTCOUNT);
				DBG_ASSERTWARNING(
					nKnown == m_nIter,
					"CntOutBoxOpenJob_Impl::Execute(): repairing KnownCount");
				if (!(nKnown == m_nIter))
				{
					// Repair KnownContentCount.
					CntUInt32Item aKnownCount (
						WID_TOTALCONTENTCOUNT, m_nIter);
					xBoxSet->Put (aKnownCount);
					GetRootNode()->Put (aKnownCount);
				}

				// Check SentContentCount.
				ULONG nSent = ITEMSET_VALUE_UINT32(
					xBoxSet, WID_SENTCONTENTCOUNT);
				DBG_ASSERTWARNING(
					nSent == m_nSent,
					"CntOutBoxOpenJob_Impl::Execute(): repairing SentCount");
				if (!(nSent == m_nSent))
				{
					// Repair SentContentCount.
					CntUInt32Item aSentCount (
						WID_SENTCONTENTCOUNT, m_nSent);
					xBoxSet->Put (aSentCount);
					GetRootNode()->Put (aSentCount);
				}
			}
		}

		// Next state.
		DELETEZ (m_pIter);
		m_eState = STATE_DONE;
	}

	if (m_eState == STATE_DONE)
	{
		// Done.
		pJob->Done();
	}

	// Leave.
	return NULL;
}

/*
 * Notify.
 */
void CntOutBoxOpenJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutBoxSendJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutBoxSendJob_Impl.
 */
CntOutBoxSendJob_Impl::CntOutBoxSendJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_xSubJob      (NULL),
	  m_pCache       (NULL),
	  m_pIter        (NULL),
	  m_eState       (STATE_NONE)
{
}

/*
 * CntOutBoxSendJob_Impl.
 */
CntOutBoxSendJob_Impl::~CntOutBoxSendJob_Impl (void)
{
	delete m_pIter;
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutBoxSendJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutBoxSendJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Initialize.
	ULONG nStartTicks = Time::GetSystemTicks();
	if (m_eState == STATE_NONE)
	{
		// Obtain cache node.
		m_pCache = pJob->GetCacheNode();
		DBG_ASSERT(
			m_pCache, "CntOutBoxSendJob_Impl::Execute(): no Cache");
		if (m_pCache == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain Known/Sent ContentCount.
		CntStoreItemSetRef xBoxSet (GetParent()->GetBoxItemSet (m_pCache));

		ULONG nKnown = ITEMSET_VALUE_UINT32(
			GetRootNode(), WID_TOTALCONTENTCOUNT);
		if (xBoxSet.Is())
			nKnown = ITEMSET_VALUE_UINT32(xBoxSet, WID_TOTALCONTENTCOUNT);

		ULONG nSent = ITEMSET_VALUE_UINT32(
			GetRootNode(), WID_SENTCONTENTCOUNT);
		if (xBoxSet.Is())
			nSent = ITEMSET_VALUE_UINT32(xBoxSet, WID_SENTCONTENTCOUNT);

		// Check for unsent messages.
		if (!(nSent < nKnown))
		{
			// Nothing to do.
			pJob->Done();
			return NULL;
		}

		// Check for Offline mode.
		CntConnMode eConnMode = GetParent()->GetConnMode();
		if (eConnMode == CNT_CONN_MODE_OFFLINE)
		{
			if (pJob->SetError (ERRCODE_CHAOS_OFFLINE))
			{
				// Job cancelled.
				return NULL;
			}
			eConnMode = GetParent()->GetConnMode();
		}

		// Check for transacted mode.
		if (eConnMode == CNT_CONN_MODE_OFFLINE_TRANSACTED)
		{
			// Insert into log and finish.
			pJob->Log();
			pJob->Done();
			return NULL;
		}

		// Initialize cache iteration.
		UINT32 nInclMask = 0;
		nInclMask |= CNTDIRENTRY_ATTRIB_UNSENT;

		UINT32 nExclMask = 0;
		nExclMask |= CNTDIRENTRY_ATTRIB_HIDDEN;
		nExclMask |= CNTDIRENTRY_ATTRIB_MARKEDFORDELETE;

		m_pIter = new CntStorageIterator (nInclMask, nExclMask);

		// Next state.
		m_eState = STATE_SEND;
	}

	if (m_eState == STATE_SEND)
	{
		m_pCache->iter (*m_pIter);
		while (!m_pIter->eof())
		{
			// Obtain message node.
			String aName ((**m_pIter).m_pszName);
			String aUrl (aName, 0, aName.Len() - 5);
			CntNodeRef xNode (GetRootNode()->Query (aUrl));
			if (xNode.Is())
			{
				// Load message (immediate execution).
				CntNodeJobRef xLoadJob (new CntNodeJob (
					pJob, xNode, xNode,
					CntOpenModeItem (WID_OPEN, CNT_OPEN_MESSAGE)));

				xNode->InsertJob (xLoadJob);
				if (!xLoadJob->IsCancelled())
				{
					// Cleanup LoadJob.
					xLoadJob.Clear();

					// Setup SubJob.
					m_xSubJob = new CntNodeJob (
						pJob, xNode, xNode, SfxVoidItem (WID_INSERT));
					CntOutJob_Impl *pJobImpl =
						new CntOutMsgSendJob_Impl (m_xSubJob, GetParent());

					// Start SubJob.
					StartListening (*m_xSubJob);
					GetRootNode()->RescheduleJob (m_xSubJob);
					return NULL;
				}
			}

			// Check elapsed time.
			ULONG nTicks = Time::GetSystemTicks();
			if ((nTicks - nStartTicks) > COUTJOB_RESCHEDULE_TIMELIMIT)
			{
				// Be nice.
				GetRootNode()->RescheduleJob (pJob);
				return NULL;
			}

			// Next.
			m_pCache->iter (*m_pIter);
		}

		// Next state.
		DELETEZ (m_pIter);
		m_eState = STATE_DONE;
	}

	// Done.
	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutBoxSendJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntNodeJob *pJob = PTR_CAST (CntNodeJob, &rBC);
	if ((pJob != NULL) && (pJob == &m_xSubJob))
	{
		if (pJob->IsCancelled() || pJob->IsDone())
		{
			// SubJob finished.
			EndListening (*m_xSubJob);

			// Restart parent job.
			GetRootNode()->RescheduleJob (GetJob());
		}
		return;
	}
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutCloseJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutCloseJob_Impl.
 */
CntOutCloseJob_Impl::CntOutCloseJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pMailer      (NULL),
	  m_eState       (STATE_NONE)
{
}

/*
 * ~CntOutCloseJob_Impl.
 */
CntOutCloseJob_Impl::~CntOutCloseJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutCloseJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutCloseJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Initialize.
	if (m_eState == STATE_NONE)
	{
		// Check mailer.
		if (!GetParent()->HasMailer())
		{
			// Nothing to do.
			pJob->Done();
			return NULL;
		}

		// Obtain mailer.
		m_pMailer = GetParent()->GetMailer();
		DBG_ASSERT(
			m_pMailer, "CntOutCloseJob_Impl::Execute(): no Mailer");
		if (m_pMailer == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Jump into state machine.
		m_eState = STATE_NNTP;
		ExecuteHandler (m_pMailer, 200, NULL);

		// Finished asynchronously.
		return NULL;
	}

	if (m_eState == STATE_DONE)
	{
		// Release mailer and finish.
		GetParent()->PutMailer (m_pMailer);
		pJob->Done();
	}

	// Leave.
	return NULL;
}

/*
 * ExecuteCallback.
 */
sal_Bool CntOutCloseJob_Impl::ExecuteCallback (
	INetCoreMailer *pMailer,
	sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData)
{
	// Check context.
	CntOutCloseJob_Impl *pThis = (CntOutCloseJob_Impl *)pData;
	DBG_ASSERT (pThis, "CntOutCloseJob_Impl::ExecuteCallback(): no pThis");
	if (pThis == NULL)
		return sal_False;

	// Handle callback reason.
	pThis->AddRef();
	pThis->ExecuteHandler (pMailer, nReplyCode, pReplyText);
	pThis->ReleaseRef();

	// Wait for next callback.
	return sal_True;
}

/*
 * ExecuteHandler.
 */
void CntOutCloseJob_Impl::ExecuteHandler (
	INetCoreMailer *pMailer,
	sal_Int32 nReplyCode, const sal_Char *pReplyText)
{
	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutCloseJob_Impl::ExecuteHandler(): no Job");
	if (pJob == NULL)
		return;

	// Jump into state machine.
	while (1)
	{
		switch (m_eState)
		{
			case STATE_NNTP:
				// Close NNTP connection gracefully.
				m_eState = STATE_SMTP;
				if (m_pMailer->NewsCloseConnection (
					ExecuteCallback, this))
				{
					// Wait for next callback.
					return;
				}
				break;

			case STATE_SMTP:
				// Close SMTP connection gracefully.
				m_eState = STATE_CLOSE;
				if (m_pMailer->SendCloseConnection (
					ExecuteCallback, this))
				{
					// Wait for next callback.
					return;
				}
				break;

			default: // STATE_CLOSE.
				// Finish asynchronously.
				m_eState = STATE_DONE;
				GetRootNode()->RescheduleJob (pJob);
				return;
		}
	}
}

/*
 * Notify.
 */
void CntOutCloseJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntOutJob_Impl::Notify (rBC, rHint);
}

