/*************************************************************************
 *
 *  $RCSfile: cntstgnd.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 13:04:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _CNTSTGND_CXX

#ifndef _VOS_THREAD_HXX
#include <vos/thread.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _FSYS_HXX //autogen
#include <tools/fsys.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _DATETIMEITEM_HXX //autogen
#include <svtools/dateitem.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFXSMPLHINT_HXX
#include <svtools/smplhint.hxx>
#endif
#ifndef _SFXNRANGES_HXX
#include <svtools/nranges.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _UNOTOOLS_INTLWRAPPER_HXX
#include <unotools/intlwrapper.hxx>
#endif

#ifndef _CNTSTG_HXX
#include <cntstg.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CNTSYS_HXX
#include <cntsys.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif

using namespace chaos;

//===========================================================================
//
// class CntStorageRebuildTask
//
//===========================================================================
class CntStorageRebuildTask : public CntTask, public NAMESPACE_VOS( OThread )
{
	// Working method.
	virtual void SAL_CALL run();

	CntStorageRebuildTask( const CntStorageRebuildTask& );
	CntStorageRebuildTask& operator=( const CntStorageRebuildTask& );

	void Rebuild_Impl	 ( CntNode* pStore );
	void HandleError_Impl( ErrCode nError, CntRootStorageNode* pStore );

public:
	CntStorageRebuildTask( CntNodeJob *pJob );
	virtual ~CntStorageRebuildTask();

	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	virtual const SfxPoolItem* Execute();
};

//============================================================================

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF( CntStoreItemSet );
#endif

#ifdef _TOOLS_STORDIR_REF
SV_IMPL_REF( CntStoreDirectory );
#endif

#ifdef MACOSX
#define CNT_FSYS_ROOT_CACHE_URL STG_PROTOCOL_CACHE"file:///"
#else
#define CNT_FSYS_ROOT_CACHE_URL STG_PROTOCOL_CACHE##"file:///"
#endif

#define STG_NEVER_DELETE 0x80000000

BOOL TransferOwnProperties_Impl ( CntNode* pOld, CntNode* pNew );
BOOL TransferViewProperties_Impl( CntNodeJob* pJob, CntNode* pNode );

//============================================================================

TYPEINIT1_AUTOFACTORY( CntStorageNode, CntNode );
TYPEINIT1_AUTOFACTORY( CntRootStorageNode, CntStorageNode );
TYPEINIT1_AUTOFACTORY( CntViewStorageNode, CntRootStorageNode );

//============================================================================
//
// CntStorageNode Implementation.
//
//============================================================================

//============================================================================
// Ranges array
USHORT __READONLY_DATA aCntStorageNodeRanges_Impl[] =
{
	WID_HAS_DATA,  	     	WID_HAS_DATA,
	WID_REFERED_URL,      	WID_REFERER_COUNT,
	WID_FLAG_SUPPORTMODE, 	WID_FLAG_SUPPORTMODE,
	0
};

//============================================================================
CNT_NODE_SUBCLASS_IMPL( CntStorageNode )
{
	// register possible children
	CntNodeFactory* pFac =
				new CntNodeFactory( UniString::CreateFromAscii(
										RTL_CONSTASCII_STRINGPARAM( "/*" ) ),
									'/',
									TYPE( CntStorageNode ) );
	InsertFactory( pFac );
}

//============================================================================
CntStorageNode::CntStorageNode()
: CntNode( NULL ),
  m_pStore( NULL ),
  _bIsRestored( FALSE )
{
}

//============================================================================
// virtual
CntStorageNode::~CntStorageNode()
{
	delete m_pStore;
}

//============================================================================
// static
void CntStorageNode::Own2FileURL( String& rOwnURL,
								  CntStorageNode* pNode /* = NULL */,
								  BOOL bMustExist /* = FALSE */ )
{
	if ( rOwnURL.Len() < 3 )
		return;

	// Is there one of our own protocol prefixes in URL?
	if ( rOwnURL.GetChar( 0 ) != '.' )
		return;

	xub_StrLen nPos = rOwnURL.Search( ':' );
	if ( nPos == STRING_NOTFOUND )
	{
		DBG_ERROR( "Own2FileURL only translates .cache: and .user: URL's!" );
		return;
	}

	nPos++;

	BOOL   bUserData = FALSE;
	String aProtocol( rOwnURL.Copy( 0, nPos ) );

	String aFileURL;

	// Check special protocol.
	if ( aProtocol.EqualsAscii(	STG_PROTOCOL_CACHE ) )
	{
		// cache/directory node
		aFileURL = CNT_RNM()->GetCacheDirectory();
	}
	else if ( aProtocol.EqualsAscii( STG_PROTOCOL_USER ) )
	{
		// user data node
		aFileURL = CNT_RNM()->GetUserDataDirectory();
		bUserData = TRUE;
	}
	else
	{
		// unknown protocol
		DBG_ERROR( "Own2FileURL only translates .cache: and .user: URL's!" );
		rOwnURL.Erase();
		return;
	}

	if ( !aFileURL.Len() )
	{
		// Error - Got no Cache/Userdata directory.
		rOwnURL.Erase();
		return;
	}

	//////////////////////////////////////////////////////////////////////
	// Remember URL of refered node....
	//////////////////////////////////////////////////////////////////////

	String aReferedURL( rOwnURL.Copy( nPos ) );

	// User data nodes never have refered nodes...
	if ( !bUserData && pNode )
		pNode->CntNode::Put( CntStringItem( WID_REFERED_URL, aReferedURL ),
		                     WID_REFERED_URL );

	//////////////////////////////////////////////////////////////////////
	// Check for Dummy-URL
	//////////////////////////////////////////////////////////////////////

	xub_StrLen nLen = aReferedURL.Len();
	if ( ( nLen > 2 ) &&
		 ( aReferedURL.GetChar( nLen - 3 ) == ':' ) &&
		 ( aReferedURL.GetChar( nLen - 2 ) == '/' ) &&
		 ( aReferedURL.GetChar( nLen - 1 ) == '/' ) )
	{
		// Dummy-URL.
		aFileURL += '.';
		aFileURL.AppendAscii(
			RTL_CONSTASCII_STRINGPARAM( STG_NOTVIEW_FILE_EXTENSION ) );

		rOwnURL = aFileURL;
		return;
	}

	//////////////////////////////////////////////////////////////////////
	// Construct a file name from URL of refered node....
	//////////////////////////////////////////////////////////////////////

	INetURLObject aURLObject( aReferedURL );

	String aFileName;

	// Next part of file name: "username"
	String aUser( aURLObject.GetUser() );
	nLen = aUser.Len();
	if ( nLen )
	{
		xub_StrLen nPos = aUser.Search( '.' );
		while ( nPos != STRING_NOTFOUND )
		{
			aUser.Erase( nPos, 1 );
			nPos = aUser.Search( '.', nPos );
		}

#ifdef CASE_SENSITIVE_USERNAMES
		// User names are generally case sensitive. So any upper-case
		// letters in name will be encoded here into storage filename.
		//
		// Conversion-scheme:
		// <uppercase letter> -> !<uppercase_letter>
		// !                  -> !!
		String aTemp;

		nLen = aUser.Len();
		for ( xub_StrLen n = 0; n < nLen; n++ )
		{
			String aTmp( aUser.GetChar( n ) );
			if ( aTmp == '%' )
			{
				// Skip escape sequences.
				aTemp += '%';
				aTemp += aUser.GetChar( n + 1 );
				aTemp += aUser.GetChar( n + 2 );
				n += 2;
			}
			else
			{
				if ( aTmp == '!' )
					aTemp += '!';
				else
				{
					String aTmpLow( aTmp );
					aTmpLow.ToLowerAscii();
			 		if ( aTmpLow != aTmp )
					{
						aTemp += '!';
						aTmp = aTmpLow;
					}
				}
				aTemp += aTmp;
			}
		}

		aUser = aTemp;
#endif
		aFileName += aUser;
	}

	// Next part of file name: "servername"
	String aHost( aURLObject.GetHost() );
	if ( aHost.Len() )
	{
		xub_StrLen nPos = aHost.Search( '.' );
		while ( nPos != STRING_NOTFOUND )
		{
			aHost.Erase( nPos, 1 );
			nPos = aHost.Search( '.', nPos );
		}

 		aFileName += aHost;

		// Next part of file name: "serverport"
		if ( aURLObject.HasPort() )
	 		aFileName += aURLObject.GetPort();

	}

	// Next part of file name: "protocol-tag"

	String aPrivatePath; // helper
	INetProtocol eProt = aURLObject.GetProtocol();

	// "private:" and ".component:" protocol need special handling.
	BOOL bSpecialProt = ( ( eProt == INET_PROT_PRIVATE ) ||
						  ( eProt == INET_PROT_COMPONENT ) );
	if ( bSpecialProt )
	{
		String aPath(
				aURLObject.GetURLPath( INetURLObject::DECODE_WITH_CHARSET ) );

		DBG_ASSERT( aPath.Len(),
					"Own2FileURL: Invalid private URL (no path)!" );

		xub_StrLen nPos = 0;
		if ( eProt == INET_PROT_PRIVATE )
		{
			nPos = aPath.SearchAscii( "://" );
			if ( nPos != STRING_NOTFOUND )
				nPos += 3; // now after "://"
		}

		if ( nPos != STRING_NOTFOUND )
		{
			nPos = aPath.Search( '/', nPos );
			if ( nPos != STRING_NOTFOUND )
			{
				aPrivatePath = aPath.Copy( nPos + 1 );
				aPath.Erase( nPos + 1 );
			}
		}

		// Remove anwanted characters from path...

		// Note: URL Object does not escape slashes - so remove it manually.
		nPos = aPath.Search( '/' );
		while ( nPos != STRING_NOTFOUND )
		{
			aPath.Erase( nPos, 1 );
			nPos = aPath.Search( '/', nPos );
		}

		// Remove any ':' (cosmetic).
		nPos = aPath.Search( ':' );
		while ( nPos != STRING_NOTFOUND )
		{
			aPath.Erase( nPos, 1 );
			nPos = aPath.Search( ':', nPos );
		}

		aFileName += aPath;
	}
	else
	{
		String aProt( aURLObject.GetScheme( eProt ) );
		aProt.Erase( aProt.Search( ':' ) );
 		aFileName += aProt;
	}

	// Next part of file name: "file extension"
	aFileName += '.';
	aFileName.AppendAscii(
			RTL_CONSTASCII_STRINGPARAM( STG_NOTVIEW_FILE_EXTENSION ) );

	//////////////////////////////////////////////////////////////////////
	// Construct a mark from URL of refered node....
	//////////////////////////////////////////////////////////////////////

	String aMark;
	if ( bSpecialProt )
	{
		if ( aPrivatePath.Len() )
			aMark = aPrivatePath;
		else
			aMark = aURLObject.GetMark();
	}
	else
	{
		String aPath( aURLObject.GetURLPath() );
		if ( aPath.Len() > 1 ) // URL-object returns '/' for root
		{
			if ( aPath.GetChar( 1 ) != '~' ) // i.e. OutTray: "/~"
				aMark = aPath;
		}
	}

	// Trim mark.
	if ( aMark.Len() )
	{
		// Any slashes contained in URL's contained in private URL's
		// path must be removed. FASTSTOR interpretes them as delimiters!
		xub_StrLen nPos = aMark.SearchAscii( "://" );
		if ( nPos != STRING_NOTFOUND )
		{
			aMark.Erase( nPos + 1, 2 );

			nPos = aMark.Search( '/', nPos + 1 );
			while ( nPos != STRING_NOTFOUND )
			{
				aMark.Erase( nPos, 1 );
				nPos = aMark.Search( '/', nPos );
			}
		}

		// Remove leading '/'.
		while ( aMark.GetChar( 0 ) == '/' )
			aMark.Erase( 0, 1 );
	}

	//////////////////////////////////////////////////////////////////////
	// Get/Create short name, if needed....
	//////////////////////////////////////////////////////////////////////

	if ( bMustExist )
	{
		String aShortName;
		CNT_RNM()->GetFileEntry( aFileName, aShortName );
		if ( aShortName.Len() )
			aFileName = aShortName;
	}
	else
	{
		String aTmpURL( aFileURL );
		aTmpURL += aFileName;

		// If the file already exists we can use it...
		DirEntry aDirEntry( aTmpURL, FSYS_STYLE_URL );
		if ( !aDirEntry.Exists() )
		{
			// Already a short name available?
			String aShortName;
			BOOL   bSaved = CNT_RNM()->GetFileEntry( aFileName, aShortName );
			if ( !aShortName.Len() )
			{
				DirEntry aDir( aDirEntry.GetPath() );
				if ( aDir.MakeShortName( aFileName ) )
					aShortName = aDir.GetName();
				else
				{
					DBG_ERROR( "Own2FileURL: MakeShortName failed!" );
					aShortName = aFileName;
				}
       		}

			if ( aShortName != aFileName )
			{
				if ( !aDirEntry.IsCaseSensitive() )
					aShortName.ToLowerAscii();

				// Still different?
				if ( !bMustExist && !bSaved && ( aShortName != aFileName ) )
					CNT_RNM()->AddFileEntry( aFileName, aShortName );
			}

			aFileName = aShortName;
		}
	}

	//////////////////////////////////////////////////////////////////////
	// Complete file URL....
	//////////////////////////////////////////////////////////////////////

	INetURLObject aURLObj( aFileURL );
	aURLObj.Append( aFileName, INetURLObject::ENCODE_ALL );

	if ( aMark.Len() )
	{
		aMark.Insert( '/', 0 );
		aURLObj.SetMark( aMark );
	}

	// Done.
	rOwnURL = aURLObj.GetMainURL( INetURLObject::NO_DECODE );
}

//============================================================================
// static
String CntStorageNode::OwnURL2FileName( const String& rOwnURL )
{
	if ( rOwnURL.Len() < 3 )
		return String();

	// Is there one of our own protocol prefixes in URL?
	if ( rOwnURL.GetChar( 0 ) != '.' )
		return String();

	xub_StrLen nPos = rOwnURL.Search( ':' );
	if ( nPos == STRING_NOTFOUND )
	{
		DBG_ERROR( "OwnURL2FileName only translates .cache: and .user: URL's!" );
		return String();
	}

	nPos++;

	String aProtocol( rOwnURL.Copy( 0, nPos ) );

	// Check special protocol.
	if ( !aProtocol.EqualsAscii( STG_PROTOCOL_CACHE ) &&
		 !aProtocol.EqualsAscii( STG_PROTOCOL_USER ) )
	{
		// unknown protocol
		DBG_ERROR( "OwnURL2FileName only translates .cache: and .user: URL's!" );
		return String();
	}

	String aReferedURL( rOwnURL.Copy( nPos ) );

	//////////////////////////////////////////////////////////////////////
	// Check for Dummy-URL
	//////////////////////////////////////////////////////////////////////

	xub_StrLen nLen = aReferedURL.Len();
	if ( ( nLen > 2 ) &&
		 ( aReferedURL.GetChar( nLen - 3 ) == ':' ) &&
		 ( aReferedURL.GetChar( nLen - 2 ) == '/' ) &&
		 ( aReferedURL.GetChar( nLen - 1 ) == '/' ) )
	{
		return String();
	}

	//////////////////////////////////////////////////////////////////////
	// Construct a file name from URL of refered node....
	//////////////////////////////////////////////////////////////////////

	INetURLObject aURLObject( aReferedURL );

	String aFileName;

	// Next part of file name: "username"
	String aUser( aURLObject.GetUser() );
	nLen = aUser.Len();
	if ( nLen )
	{
		xub_StrLen nPos = aUser.Search( '.' );
		while ( nPos != STRING_NOTFOUND )
		{
			aUser.Erase( nPos, 1 );
			nPos = aUser.Search( '.', nPos );
		}

#ifdef CASE_SENSITIVE_USERNAMES
		// User names are generally case sensitive. So any upper-case
		// letters in name will be encoded here into storage filename.
		//
		// Conversion-scheme:
		// <uppercase letter> -> !<uppercase_letter>
		// !                  -> !!
		String aTemp;

		nLen = aUser.Len();
		for ( xub_StrLen n = 0; n < nLen; n++ )
		{
			String aTmp( aUser.GetChar( n ) );
			if ( aTmp == '%' )
			{
				// Skip escape sequences.
				aTemp += '%';
				aTemp += aUser.GetChar( n + 1 );
				aTemp += aUser.GetChar( n + 2 );
				n += 2;
			}
			else
			{
				if ( aTmp == '!' )
					aTemp += '!';
				else
				{
					String aTmpLow( aTmp );
					aTmpLow.ToLowerAscii();
			 		if ( aTmpLow != aTmp )
					{
						aTemp += '!';
						aTmp = aTmpLow;
					}
				}
				aTemp += aTmp;
			}
		}

		aUser = aTemp;
#endif
		aFileName += aUser;
	}

	// Next part of file name: "servername"
	String aHost( aURLObject.GetHost() );
	if ( aHost.Len() )
	{
		xub_StrLen nPos = aHost.Search( '.' );
		while ( nPos != STRING_NOTFOUND )
		{
			aHost.Erase( nPos, 1 );
			nPos = aHost.Search( '.', nPos );
		}

 		aFileName += aHost;

		// Next part of file name: "serverport"
		if ( aURLObject.HasPort() )
	 		aFileName += aURLObject.GetPort();

	}

	// Next part of file name: "protocol-tag"

	String aPrivatePath; // helper
	INetProtocol eProt = aURLObject.GetProtocol();

	// "private:" and ".component:" protocol need special handling.
	BOOL bSpecialProt = ( ( eProt == INET_PROT_PRIVATE ) ||
						  ( eProt == INET_PROT_COMPONENT ) );
	if ( bSpecialProt )
	{
		String aPath(
				aURLObject.GetURLPath( INetURLObject::DECODE_WITH_CHARSET ) );

		DBG_ASSERT( aPath.Len(),
					"OwnURL2FileName: Invalid private URL (no path)!" );

		xub_StrLen nPos = 0;
		if ( eProt == INET_PROT_PRIVATE )
		{
			nPos = aPath.SearchAscii( "://" );
			if ( nPos != STRING_NOTFOUND )
				nPos += 3; // now after "://"
		}

		if ( nPos != STRING_NOTFOUND )
		{
			nPos = aPath.Search( '/', nPos );
			if ( nPos != STRING_NOTFOUND )
			{
				aPrivatePath = aPath.Copy( nPos + 1 );
				aPath.Erase( nPos + 1 );
			}
		}

		// Remove anwanted characters from path...

		// Note: URL Object does not escape slashes - so remove it manually.
		nPos = aPath.Search( '/' );
		while ( nPos != STRING_NOTFOUND )
		{
			aPath.Erase( nPos, 1 );
			nPos = aPath.Search( '/', nPos );
		}

		// Remove any ':' (cosmetic).
		nPos = aPath.Search( ':' );
		while ( nPos != STRING_NOTFOUND )
		{
			aPath.Erase( nPos, 1 );
			nPos = aPath.Search( ':', nPos );
		}

//		INetURLObject::Escape( aPath );

		aFileName += aPath;
	}
	else
	{
		String aProt( aURLObject.GetScheme( eProt ) );
		aProt.Erase( aProt.Search( ':' ) );
 		aFileName += aProt;
	}

	// Next part of file name: "file extension"
	aFileName += '.';
	aFileName.AppendAscii(
				RTL_CONSTASCII_STRINGPARAM( STG_NOTVIEW_FILE_EXTENSION ) );

	// Done.
	return aFileName;
}

//============================================================================
// static
BOOL CntStorageNode::StorageFileExists( const String& rURL )
{
	if ( rURL.Len() == 0 )
		return FALSE;

	String aFileURL( rURL );
	Own2FileURL( aFileURL, NULL, TRUE );

	xub_StrLen nPos = aFileURL.Search( '#' );
	if ( nPos != STRING_NOTFOUND )
		aFileURL.Erase( nPos );

	DirEntry aDirEntry( aFileURL, FSYS_STYLE_URL );
	if ( !aDirEntry.Exists() )
		return FALSE;

	return TRUE;
}

//============================================================================
CntNode* CntStorageNode::Initialize_Impl( CntNode* pParent,
							              const String& rNodeURL,
							              ErrCode& nError )
{
	// Note: The storage must be initialized before calling the base class.
	//       The base class recursively initializes all children described
	//       by rNodeURL, but to initialize a sub-storage node, it's parent
	//       storage must be initialized!

	SetParent_Impl( pParent );

	String aOwnURL( rNodeURL );
	ConstructOwnURL_Impl( aOwnURL );

	nError = InitStorage( aOwnURL );
	if ( nError != ERRCODE_NONE )
		return NULL;

	// Remember own URL
	CntNode::Put( CntStringItem( WID_OWN_URL, aOwnURL ), WID_OWN_URL );

	// Restore persistent own properties from storage file
	if ( !IsDummy() )
		RestoreOwnProperties();

	String aReferedURL( REFERED_URL( this ) );
	if ( aReferedURL.Len() )
	{
		// Get a node for the refered URL and "connect" to it
		CntNodeRef xRefNode( CNT_RNM()->Query( aReferedURL ) );
		if ( !xRefNode.Is() )
		{
			nError = ERRCODE_IO_NOTEXISTS;
			return NULL;
		}

		SetReferedNode( xRefNode );

		if ( CntViewBase::IsRootViewURL( aOwnURL ) )
		{
			// Restore view properties.
			String aPropsName(
						xRefNode->GetMostReferedNode()->GetPropertyKey() );

			CntStoreItemSetRef xViewSet(
								openItemSet( aPropsName, STREAM_STD_READ ) );
			if ( xViewSet.Is() )
				CntNode::Put( *xViewSet );
		}
	}

	// Node: This constructs any possibly missing sub nodes.
	return CntNode::Initialize( pParent, rNodeURL );
}

//============================================================================
// virtual
CntNode* CntStorageNode::Initialize( CntNode* pParent, const String& rNodeURL )
{
	ErrCode nError = ERRCODE_NONE;
	return Initialize_Impl( pParent, rNodeURL, nError );
}

//============================================================================
// virtual
CntNode* CntStorageNode::Initialize( CntNode* pParent,
									 const String& rNodeURL,
									 ErrCode& nError )
{
	return Initialize_Impl( pParent, rNodeURL, nError );
}

//============================================================================
CntStorage* CntStorageNode::GetStorage()
{
	if ( !m_pStore )
	{
		// Call virtual ctor for implementation object.
		m_pStore = CreateImplementation();
	}
	return m_pStore;
}

//============================================================================
// virtual
CntStorage* CntStorageNode::CreateImplementation()
{
	return new CntStorage();
}

//============================================================================
//virtual
const SfxPoolItem* CntStorageNode::Put( const SfxPoolItem& rProp,
										USHORT nWhich )
{
	if ( rProp.ISA( SfxVoidItem ) )
		return NULL;

	if ( IsDummy() || IsDead() )
	{
		return CntNode::Put( rProp, nWhich );
	}

	String aPropsName( UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM( STG_OWN_PROPERTY_SET ) ) );
	aPropsName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_PROPS_EXTENSION ) );

	attrib(	aPropsName, 0,
			CNTDIRENTRY_ATTRIB_HIDDEN | CNTDIRENTRY_ATTRIB_CREATE );

	CntStoreItemSetRef xSet( openItemSet( aPropsName, STREAM_STD_READWRITE ) );
	if ( xSet.Is() )
	{
		DBG_ASSERT( !( IsItemFlag( nWhich, CNT_ITEM_AUTO_GARBLE ) &&
		     		 rProp.ISA( CntUnencodedStringItem ) &&
					 !rProp.ISA( CntStringItem ) ),
					"CntStorageNode::Put - wrong item type!" );

		xSet->Put( rProp );
	}

	return CntNode::Put( rProp, nWhich );
}

//============================================================================
// virtual
void CntStorageNode::SetReferedNode( CntNode* pNode )
{
	if ( pNode && ( pNode != GetReferedNode() ) )
	{
		// Set own ranges to ranges of refered node...
		if ( pNode->ISA( CntStorageNode ) )
			SetRanges( pNode->GetRanges() );
		else
		{
			// ... but merge with my own first.
			SfxUShortRanges aRanges( pNode->GetRanges() );
			aRanges += aCntStorageNodeRanges_Impl;
			SetRanges( aRanges );
		}
	}

	// Connect to refered node
	CntNode::SetReferedNode( pNode );

	if ( pNode )
	{
		String aURL( UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM( STG_PROTOCOL_CACHE ) ) );
		aURL += OWN_URL( pNode );
		if ( aURL != OWN_URL( this ) )
		{
			// Save refered URL in storage...
			Put( CntStringItem( WID_REFERED_URL, OWN_URL( pNode ) ) );
		}
	}

	DBG_ASSERT( GetItemState( WID_HAS_DATA, FALSE ) > SFX_ITEM_DISABLED,
				"WID_HAS_DATA missing in ranges!" );
	DBG_ASSERT( GetItemState( WID_REFERED_URL, FALSE ) > SFX_ITEM_DISABLED,
				"WID_REFERED_URL missing in ranges!" );
	DBG_ASSERT( GetItemState( WID_REFERER_COUNT, FALSE ) > SFX_ITEM_DISABLED,
				"WID_REFERER_COUNT missing in ranges!" );
}

//============================================================================
//virtual
const SfxPoolItem* CntStorageNode::InsertJob( CntNodeJob *pJob )
{
	const SfxPoolItem* pReq = pJob->GetRequest();
	USHORT nWhich = pReq->Which();

	if ( IsDummy() )
	{
		// view props can always be stored...
		if ( !IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP ) )
		{
			switch ( nWhich )
			{
				// These jobs are allowed for dummy nodes...
				case WID_GETDATA:
				case WID_PUTDATA:
				case WID_DELETE:
				case WID_NEWS_GROUPLIST:
				case WID_REFERED_URL:
				case WID_CREATE_NEW:
					break;

				// All others are invalid...
				default:
					DBG_ERROR(
						"Invalid job inserted into dummy storage node!" );
					pJob->Done();
					return NULL;
			}
		}
	}

	return CntNode::InsertJob( pJob );
}

//============================================================================
//virtual
const SfxPoolItem* CntStorageNode::ExecuteJob( CntNodeJob *pJob )
{
	const SfxPoolItem* pReq = pJob->GetRequest();
	switch ( pReq->Which() )
	{
		case WID_GETDATA:
		{
			// storage nodes never retrieve their data via WID_GETDATA!
			pJob->Done();
			return 0;
		}

		case WID_DELETE:
		{
			ULONG nRefs = ( (const CntUInt32Item&)
							Get( WID_REFERER_COUNT, FALSE ) ).GetValue();

			if ( ( nRefs <= 1 ) && !IsDummy() )
			{
				// Physically destroy or move to "trash" ?
				BOOL    bTrashOnly = !ITEM_VALUE( CntBoolItem, *pReq );
				ErrCode nError     = ERRCODE_NONE;

				// Am I a cache node?
				if ( ( (CntBoolItem&)Get( WID_HAS_DATA, FALSE ) ).GetValue() )
				{
					if ( bTrashOnly )
					{
						// Leave cache AND user node where they are...
						break;
					}

					// Note: bTrashOnly is always FALSE here...

#if 0
					// Ask user whether cache data shall be deleted.
				    nError = *new StringErrorInfo(
											ERRCODE_CHAOS_QUERY_DELETE,
											OWN_URL( GetMostReferedNode() ) );
					if ( CNT_RNM()->HandleError( nError, pJob )
													!= ERRCODE_BUTTON_YES )
					{
						// Adjust persistent refcount - must be zero now.
	                    Put( CntUInt32Item( WID_REFERER_COUNT, 0 ) );

						// Leave cache AND user node where they are...
						break;
					}
#endif

					// Destroy my own (cache) storage...
					nError = destroy();
					if ( nError != ERRCODE_NONE )
					{
						// Cancel the entire delete operation...
						pJob->SetError( nError );
						pJob->Cancel();
						return NULL;
					}

					// Destroy my user data storage...
					CntStorageNode* pUser =
							(CntStorageNode*)pJob->GetUserDataNode( FALSE );

					if ( pUser )
					{
						nError = pUser->destroy();
						if ( nError != ERRCODE_NONE )
						{
							// Cancel the entire delete operation...
							pJob->SetError( nError );
							pJob->Cancel();
							return NULL;
						}

						pUser->Dead(); // (R.I.P.)
					}

					// Remove entry from RNM's file name conversion table.
					INetURLObject aURLObject( _aStorageName );
					String aShortName( aURLObject.GetLastName() );
					CNT_RNM()->RemoveFileEntry( aShortName );
				}
				else
				{
					if ( !bTrashOnly || IsRootNode() )
					{
						// Destroy my own storage...
						nError = destroy();
						if ( nError != ERRCODE_NONE )
						{
							// Cancel the entire delete operation...
							pJob->SetError( nError );
							pJob->Cancel();
							return NULL;
						}
					}
				}
			}

			// Base class must be called!!!
			break;
		}

		default:
			break;
	}

	return CntNode::ExecuteJob( pJob );
}

//============================================================================
// virtual
void CntStorageNode::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	//////////////////////////////////////////////////////////////////////
	// CntNodeHint handling.
	//////////////////////////////////////////////////////////////////////

	const CntNodeHint *pNodeHint = NULL;
	if ( rHint.ISA( CntNodeHint ) )
		pNodeHint = (const CntNodeHint*)&rHint;

	if ( pNodeHint )
	{
		CntAction eAction = pNodeHint->GetAction();
		switch ( eAction )
		{
			case CNT_ACTION_EXCHANGED:
			{
				if ( !GetReferedNode() )
					return;

				CntNode *pBC = NULL;
				if ( rBC.ISA( CntNode ) )
					pBC = (CntNode*)&rBC;

				if ( pBC != GetReferedNode() )
					return;

				String aNewURL( UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM(	STG_PROTOCOL_CACHE ) ) );
				aNewURL += OWN_URL( pNodeHint->GetNode() );

				CntNodeRef xNew = CNT_RNM()->Query( aNewURL );

				// Transfer own properties to new node.
				TransferOwnProperties_Impl( this, xNew );

				// Decrement my own refcount.
				ULONG nRef = ( (const CntUInt32Item&)
							   Get( WID_REFERER_COUNT, FALSE ) ).GetValue();

				// Destroy my storage medium, if last referer is gone.
				if ( ( nRef <= 1 ) && !IsDummy() )
				{
				    ErrCode nError = destroy();
					if ( nError == ERRCODE_NONE )
						Dead(); // (R.I.P.)
				}

				CntNodeRef xOld( this );

				// Transfer outstanding jobs to pNew
				TransferJobsToDo_Impl( xOld, xNew );

				Broadcast( CntNodeHint( xNew, eAction, pNodeHint->GetJob() ) );
				return;
			}

			default:
				break;
		}
	}

	CntNode::Notify( rBC, rHint );
}

//============================================================================
CntNode* CntStorageNode::Initialize( CntNode* pParent, CntNode* pReferedNode )
{
	// remember our parent
	SetParent_Impl( pParent );

	// construct own URL...
	String aParentURL( OWN_URL( pParent ) );
	String aParentRefURL( REFERED_URL( pParent ) );
	String aRefOwnURL( OWN_URL( pReferedNode ) );

	String aOwnURL( aParentURL );

	// file-URL ?
	if ( aOwnURL.GetChar( 0 ) != '.' )
	{
		if ( aParentURL.Search( '#' ) == STRING_NOTFOUND )
			aOwnURL += '#';
	}

	String aMyURLPart( aRefOwnURL.Copy( aRefOwnURL.Match( aParentRefURL ) ) );
	aOwnURL += aMyURLPart;

	if ( InitStorage( aOwnURL ) != ERRCODE_NONE )
		return NULL;

	// Remember own URL
	CntNode::Put( CntStringItem( WID_OWN_URL, aOwnURL ), WID_OWN_URL );

	// restore persistent props from storage file
	if ( !IsDummy() )
		RestoreOwnProperties();

	// Connect to refered node
	SetReferedNode( pReferedNode );
	return this;
}

//============================================================================
ErrCode CntStorageNode::InitStorage( String& rOwnURL )
{
	String aFileURL( rOwnURL );

	// Convert own URL ( maybe .cache:... etc to file: URL )
	BOOL bRoot = ( IsRootNode() || !GetParent() );
	Own2FileURL( aFileURL, this, !bRoot );

	if ( !aFileURL.Len() )
	{
		// Error.
		return ERRCODE_IO_INVALIDPARAMETER;
	}

	// Dummy nodes never have a storage medium.
	if ( IsDummy() )
	{
		// Continue in this case, but do not initialize a storage.
		return ERRCODE_NONE;
	}

	// Note: Cut mark, if any. URL-object does not recognize our special mark
	//       beginning with "#/" - Maybe the '/' confuses it
	//       (GetURLNoMark and others return wrong values).

	xub_StrLen nMark = aFileURL.SearchAscii( "#/" );
	String aMark;
	if ( nMark != STRING_NOTFOUND )
	{
		aMark = aFileURL.Copy( nMark );
		aFileURL.Erase( nMark );
	}

	if ( !bRoot )
	{
		CntStorageNode* pParent = (CntStorageNode*)GetParent();
		aFileURL = pParent->_aStorageName;
	}
	else
	{
		//////////////////////////////////////////////////////////////////
		// "Renaming of view storage" stuff...
		//////////////////////////////////////////////////////////////////
		if ( _aStorageName.Len() && ( aFileURL != _aStorageName ) )
		{
			// Rename old storage.
			DirEntry aOldEntry( _aStorageName, FSYS_STYLE_URL );
			DirEntry aNewEntry( aFileURL, FSYS_STYLE_URL );

			FSysError nErr = aOldEntry.MoveTo( aNewEntry );
		    if ( nErr != ERRCODE_NONE )
			   return nErr;
		}
 	}

	// remember path/file name
	_aStorageName = aFileURL;

	// cat mark
	aFileURL += aMark;

	USHORT nInitFlags = STG_INIT_FLAG_NORMAL;
	if ( !GetParent() ) // rootstg.scs
		nInitFlags |= STG_INIT_FLAG_BACKUP;

	ErrCode nError = GetStorage()->initialize(
					 	!GetParent() || IsRootNode()
					 		? NULL
					 		: ( (CntStorageNode*)GetParent() )->GetStorage(),
					 	aFileURL,
					 	nInitFlags );
	switch ( nError )
	{
		case ERRCODE_NONE:
		{
			// #69651# - Access medium to ensure it is valid.
			String aPropsName( UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM(	STG_OWN_PROPERTY_SET ) ) );
			aPropsName.AppendAscii(
					RTL_CONSTASCII_STRINGPARAM(	STG_PROPS_EXTENSION ) );
			UINT32 nAttr = 0;
			nError = attrib( aPropsName, 0, 0, nAttr );

			if ( nError == ERRCODE_IO_NOTEXISTS )
				nError = ERRCODE_NONE;

			DBG_ASSERT( ( nError == ERRCODE_NONE ) ||
			            ( nError == ERRCODE_IO_WRONGVERSION ),
						"InitStorage: unknown error!" );

			if ( nError != ERRCODE_NONE )
				_bIsDummy = TRUE;

			return nError;
		}

		case ERRCODE_IO_WRONGVERSION:
			// #49841# - Do not display error message in this case.
			_bIsDummy = TRUE;
			return nError;

		case ERRCODE_IO_NOTEXISTS:
			// file open problem
		case ERRCODE_IO_CANTREAD:
			// file/stream read problem
		case ERRCODE_IO_LOCKVIOLATION:
			// locking violation
		case ERRCODE_IO_NOTEXISTSPATH:
			// path/file name invalid
		case ERRCODE_IO_ACCESSDENIED:
			// disable all read/write requests...
			_bIsDummy = TRUE;
			break;

		default:
//			_bIsDummy = TRUE;
  			DBG_ERROR( "InitStorage: unknown error code!" );
  			break;
	}

	_aStorageName.Erase();
	if( !( nInitFlags & STG_INIT_FLAG_BACKUP ) )
		CNT_RNM()->HandleError( nError, NULL );

	return nError;
}

//============================================================================
BOOL CntStorageNode::RestoreOwnProperties()
{
	String aPropsName( UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM(	STG_OWN_PROPERTY_SET ) ) );
	aPropsName.AppendAscii( RTL_CONSTASCII_STRINGPARAM(	STG_PROPS_EXTENSION ) );

	CntStoreItemSetRef xSet( openItemSet( aPropsName, STREAM_STD_READ ) );
	if ( !xSet.Is() )
		return FALSE;

	SfxItemIter aIter( *xSet );
	for ( const SfxPoolItem *pItem = aIter.FirstItem();
 		  pItem;
		  pItem = aIter.NextItem() )
	{
		USHORT nWhich = pItem->Which();
		switch ( nWhich )
		{
			case WID_OWN_URL:
			case WID_REFERED_URL:
			case WID_REAL_URL:
				if ( GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
					continue;

				break;

			default:
				break;
		}

	    CntNode::Put( *pItem, nWhich );
	}

	_bIsRestored = TRUE;
	return TRUE;
}

//============================================================================
ErrCode	CntStorageNode::CloseStorage()
{
	ULONG nCount = SubNodeCount();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntNode* pChild = GetSubNode( n );
		if ( pChild->ISA( CntStorageNode ) )
		{
			CntStorageNode* pStg = (CntStorageNode*)pChild;
			ErrCode nError = pStg->CloseStorage();

			if ( nError != ERRCODE_NONE )
				return nError;
		}
	}

	return GetStorage()->closeStorage();
}

//============================================================================
ErrCode CntStorageNode::destroy()
{
	// Dummy nodes have no storage!
	if ( IsDummy() )
		return ERRCODE_NONE;

	// Close storage...
	ErrCode nError = CloseStorage();

	if ( nError != ERRCODE_NONE )
		return nError;

	// Destroy storage...
	nError = GetStorage()->destroyStorage();

	if ( nError != ERRCODE_NONE )
		return nError;

	// All possible subsequent "Query"-calls must create a new node...
	CntNode* pParent = GetParent();
	if ( pParent )
		pParent->Removed( this );

	return ERRCODE_NONE;
}

//-----------------------------------------------------------------------------
CntStoreItemSet* CntStorageNode::openItemSet( const String &rName,
                             	              StreamMode eOpenMode )
{
    return openItemSet( NULL, rName, eOpenMode );
}

//-----------------------------------------------------------------------------
CntStoreItemSet* CntStorageNode::openItemSet( const USHORT *nWhichPairTable,
			                               	  const String &rName,
                             	              StreamMode eOpenMode )
{
	return GetStorage()->openItemSet(
						rName, *GetPool(), eOpenMode, nWhichPairTable );
}

//-----------------------------------------------------------------------------
SvStream* CntStorageNode::openStream( const String &rName,
									  StreamMode eOpenMode )
{
	return GetStorage()->openStream( rName, eOpenMode );
}

//-----------------------------------------------------------------------------
ErrCode CntStorageNode::rename( const String &rName, const String &rNewName )
{
	return GetStorage()->rename( rName, rNewName );
}

//-----------------------------------------------------------------------------
ErrCode CntStorageNode::remove( const String &rName )
{
	return GetStorage()->remove( rName );
}

//-----------------------------------------------------------------------------
ErrCode CntStorageNode::link( const String &rName, const String &rNewName )
{
	return GetStorage()->link( rName, rNewName );
}

//-----------------------------------------------------------------------------
ErrCode CntStorageNode::attrib( const String &rName, UINT32 nClearMask,
								UINT32 nSetMask, UINT32& nAttrib )
{
	return GetStorage()->attrib( rName, nClearMask, nSetMask, nAttrib );
}

//-----------------------------------------------------------------------------
ErrCode CntStorageNode::attrib( const String &rName,
								UINT32 nClearMask, UINT32 nSetMask )
{
	UINT32 nAttrib = 0;
	return attrib( rName, nClearMask, nSetMask, nAttrib );
}

//-----------------------------------------------------------------------------
const String CntStorageNode::iter( CntStorageIterator &rIter )
{
	return GetStorage()->iter( rIter );
}

//-----------------------------------------------------------------------------
// static
String CntStorageNode::makeShortName( const String &rLongName )
{
	return CntStorage::makeShortName( rLongName );
}

//============================================================================
//
// CntRootStorageNode Implementation.
//
//============================================================================

CNT_NODE_SUBCLASS_IMPL( CntRootStorageNode )
{
	// Register ourself at root node manager.
	CntNodeFactory* pFac =
	   new CntNodeFactory( UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( "file:///*.scs" ) ),
						   '#',
						   StaticType() );
	CntRootNodeMgr::InsertFactory( pFac );
	pFac = new CntNodeFactory( UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( ".cache:*" ) ),
							   '/',
							   StaticType() );
	CntRootNodeMgr::InsertFactory( pFac );
	pFac = new CntNodeFactory( UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( ".user:*" ) ),
							   '/',
							   StaticType() );
	CntRootNodeMgr::InsertFactory( pFac );

	// Register children.
	pFac = new CntNodeFactory( '*', '/', TYPE( CntStorageNode ) );
	InsertFactory( pFac );
}

//============================================================================
CntRootStorageNode::CntRootStorageNode()
: _bKillInDtor( FALSE )
{
}

//============================================================================
// virtual
CntRootStorageNode::~CntRootStorageNode()
{
	if ( _bKillInDtor )
		destroy();

	// release user data node
	_xUserNode = NULL;

	// Send dying hint before we're really dead.
	Broadcast( SfxSimpleHint( SFX_HINT_DYING ) );
}

//============================================================================
CntNode* CntRootStorageNode::Initialize_Impl( CntNode* pParent,
							                  const String& rNodeURL,
							                  ErrCode& nError )
{
	// Note: This initializes the storage (in case rNodeURL does not
	//		 describe a dummy-node)
	CntNode* pResult = CntStorageNode::Initialize( pParent, rNodeURL, nError );

	if ( !pResult )
		return NULL;

	// Put initial defaults into node...
	Put( CntBoolItem( WID_FLAG_SUPPORTMODE, FALSE ) );

	CntNode::Put( CntBoolItem( WID_HAS_DATA, TRUE ), WID_HAS_DATA );

	// Special handling for file sytem cache, which never(!) shall
	// ( and can ) be deleted!
	if ( OWN_URL( this ).EqualsAscii( CNT_FSYS_ROOT_CACHE_URL ) )
	{
		ULONG nRefs = THIS_ITEM_VALUE( CntUInt32Item, WID_REFERER_COUNT );
		if ( nRefs != STG_NEVER_DELETE )
			Put( CntUInt32Item( WID_REFERER_COUNT, STG_NEVER_DELETE ) );
	}

	if ( !IsDummy() )
	{
		// Error handling:
		// Make sure values given in WID_OWN_URL match the corresponding
		// WID's. This code also will restore WID_SERVERNAME +
		// WID_USERNAME if the cache storage file was deleted for some
		// reasons (corrupted file, delete from outside office, etc.).

		const String aProtocol( UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM( STG_PROTOCOL_CACHE ) ) );
		String aURL( OWN_URL( this ) );
		xub_StrLen nPos = aURL.Match( aProtocol );
		if ( nPos == aProtocol.Len() )
		{
			// cache node!
			aURL.Erase( 0, nPos );
			INetURLObject aURLObj( aURL );

			// server name (incl. server port)
			if ( GetItemState( WID_SERVERNAME, FALSE ) != SFX_ITEM_SET )
			{
				String aServer( aURLObj.GetHost(
									INetURLObject::DECODE_WITH_CHARSET ) );
				if ( aServer.Len() )
				{
					if ( aURLObj.HasPort() )
					{
						aServer += ':';
						aServer += aURLObj.GetPort();
					}

					Put( CntStringItem( WID_SERVERNAME, aServer ) );
				}
			}

			// user name
			if ( GetItemState( WID_USERNAME, FALSE ) != SFX_ITEM_SET )
			{
				String aUser( aURLObj.GetUser(
								INetURLObject::DECODE_WITH_CHARSET ) );
				if ( aUser.Len() )
					Put( CntStringItem( WID_USERNAME, aUser ) );

			}

			// ??? password ???

		}
	}

	return pResult;
}

//============================================================================
// virtual
CntNode* CntRootStorageNode::Initialize( CntNode* pParent,
                                         const String& rNodeURL )
{
	ErrCode nError = ERRCODE_NONE;
	return Initialize_Impl( pParent, rNodeURL, nError );
}

//============================================================================
// virtual
CntNode* CntRootStorageNode::Initialize( CntNode* pParent,
									     const String& rNodeURL,
									     ErrCode& nError )
{
	return Initialize_Impl( pParent, rNodeURL, nError );
}

//============================================================================
// virtual
CntStorage* CntRootStorageNode::CreateImplementation()
{
	return new CntRootStorage();
}

//============================================================================
void CntRootStorageNode::SetUserNode( CntNode* pUser )
{
	if ( pUser && !pUser->IsDummy() )
		_xUserNode = pUser;
}

//============================================================================
//virtual
void CntRootStorageNode::GetOwnURL( String& rOwnURL )
{
	if ( rOwnURL.GetChar( 0 ) == '.' )
	{
		xub_StrLen nPos = rOwnURL.Search( ':' );
		if ( nPos != STRING_NOTFOUND )
		{
			nPos++;

			String aProtocol( rOwnURL.Copy( 0, nPos ) );

			// Check special protocol.
			if ( ( aProtocol.EqualsAscii( STG_PROTOCOL_CACHE ) ) ||
				 ( aProtocol.EqualsAscii( STG_PROTOCOL_USER ) ) )
			{
				// Get URL of refered node.
				String aReferedURL( rOwnURL.Copy( nPos ) );

				// Node described by refered URL must be an anchestor
				// of "this". So we can search at our parent for a factory
				// for the refered node and use it's delimiters to cut
				// rOwnURL.

				CntRootNodeMgr* pRNM = CNT_RNM();
   				CntNodeFactory* pFac = NULL;

			    ULONG nCount = pRNM->FactoryCount();
			    for ( ULONG n = 0; n < nCount; n++ )
		    	{
    				pFac = pRNM->GetFactory( n );
    				if ( pFac->Matches( aReferedURL ) )
	    			{
						const String aWild = pFac->GetWildCard();
						if ( aReferedURL.Len() > aWild.Len() )
							nPos = aReferedURL.Match( aWild );
						else
							nPos = aWild.Match( aReferedURL );

						if ( aReferedURL.SearchAscii( "///" ) == ( nPos - 3 ) )
							--nPos;

	    				break;
    				}
    				else
    					pFac = NULL;
				}

				if ( pFac )
				{
   					const String& rDelims = pFac->GetChildDelims();
				   	xub_StrLen nDelims = rDelims.Len();
				   	for ( xub_StrLen n = 0; n < nDelims; ++n )
				   	{
				   		sal_Unicode cCurrDel = rDelims.GetChar( n );

				   		xub_StrLen nCurr = aReferedURL.Search( cCurrDel, nPos );
				   		if ( nCurr != STRING_NOTFOUND )
				   		{
				   			// Do not cut a final '/'!
				   			if ( aReferedURL.GetChar( nCurr ) != '/' )
				   				nCurr--;
							else if ( nCurr &&
								      ( aReferedURL.GetChar( nCurr - 1 )
								        == ':' ) )
							{
								// Another URL scheme in URL - ignore!
								continue;
							}

	   						// Gotcha!
							if ( nCurr < ( aReferedURL.Len() - 1 ) )
							{
		   						aReferedURL.Erase( nCurr + 1 );

								rOwnURL = aProtocol;
								rOwnURL += aReferedURL;
			   				}

			   				return;
				   		}
   					}

   					return;
				}
				else
				{
					// No factory for referred node found!
					// CHAOS cannot create a node for referred URL!
					rOwnURL.Erase();
					return;
				}
			}
		}
	}
	else if ( rOwnURL.SearchAscii( "file:" ) == 0 )
	{
		xub_StrLen nPos = rOwnURL.Search( '#' );
		if ( nPos != STRING_NOTFOUND )
			rOwnURL.Erase( nPos );

		return;
	}
}

//============================================================================
//virtual
const SfxPoolItem* CntRootStorageNode::InsertJob( CntNodeJob *pJob )
{
	const SfxPoolItem* pReq = pJob->GetRequest();
	switch ( pReq->Which() )
	{
		case WID_DELETE:
			if ( ITEM_VALUE( CntBoolItem, *pReq ) )
				break;

			pJob->Done();
			return NULL;

		case WID_UNDELETE:
		case WID_PREPARE_MOVE:
			pJob->Done();
			return NULL;

		case WID_REOPEN:
		{
			// re-insert at RNM...
			if ( !GetParent() )
			{
				CntNode* pParent = CNT_RNM();
				SetParent_Impl( pParent );
				pParent->Inserted( this, pJob );
			}

			pJob->Done();
			return NULL;
		}

		case WID_PURGE:
			// Shrink view, cache und user data node.
			return Rebuild_Impl( pJob );

		default:
			break;
	}

	return CntStorageNode::InsertJob( pJob );
}

//============================================================================
ErrCode	CntRootStorageNode::rebuild()
{
	ErrCode nError = CloseStorage();
	if ( nError != ERRCODE_NONE )
		return nError;

	return ( (CntRootStorage*)GetStorage() )->rebuild();
}

//-----------------------------------------------------------------------------
//virtual
void CntRootStorageNode::Flush()
{
	( (CntRootStorage*)GetStorage() )->flush();
}

//-----------------------------------------------------------------------------
ErrCode CntRootStorageNode::size( UINT32& rSize )
{
	return ( (CntRootStorage*)GetStorage() )->size( rSize );
}

//-----------------------------------------------------------------------------
// static
ErrCode CntRootStorageNode::create( const String &rURL )
{
	return CntRootStorage::create( rURL );
}

//============================================================================
const SfxPoolItem* CntRootStorageNode::Rebuild_Impl( CntNodeJob* pJob )
{
	CntStorageRebuildTask* pTask =
							(CntStorageRebuildTask*)pJob->GetRequestData();
	if ( !pTask )
	{
		// First, release all children!
		Broadcast( CntNodeHint( this, CNT_ACTION_KILL_ALL, pJob ) );

		pTask =	new CntStorageRebuildTask( pJob );
		pJob->SetRequestData( pTask );
	}

	return pTask->Execute();
}

//============================================================================
//
// CntViewStorageNode Implementation.
//
//============================================================================

CNT_NODE_SUBCLASS_IMPL( CntViewStorageNode )
{
	// Register ourself at root node manager.
	CntNodeFactory* pFac =
	   new CntNodeFactory( UniString::CreateFromAscii(
	   						RTL_CONSTASCII_STRINGPARAM( "file:///*.scc" ) ),
						   '#',
						   StaticType() );
	CntRootNodeMgr::InsertFactory( pFac );

	// Register children.
	pFac = new CntNodeFactory( UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( "#*" ) ),
							   '/',
							   TYPE( CntViewNode ) );
	InsertFactory( pFac );
}

//============================================================================
CntViewStorageNode::CntViewStorageNode()
{
}

//============================================================================
// virtual
CntViewStorageNode::~CntViewStorageNode()
{
	if ( _bKillInDtor )
	{
		CNT_RNM()->RemoveView( OWN_URL( this ) );

		if ( GetReferedNode() )
		{
			CntRootStorageNode* pRef =
							PTR_CAST( CntRootStorageNode, GetReferedNode() );
			if ( pRef )
			{
				ULONG nRefs =
						ITEMSET_VALUE( pRef, CntUInt32Item, WID_REFERER_COUNT );
				if ( nRefs )
				{
					nRefs--;
					pRef->Put( CntUInt32Item( WID_REFERER_COUNT, nRefs ) );
				}

				if ( nRefs == 0 )
					pRef->SetDestroyStorageInDtor( TRUE );
			}

			// Note: dtor of base class kills my storage file...
		}
	}
}

//============================================================================
CntNode* CntViewStorageNode::Initialize_Impl( CntNode* pParent,
							                  const String& rNodeURL,
							                  ErrCode& nError )
{
	acquireStorage();

	String aOwnURL;
	if ( GetItemState( WID_OWN_URL, FALSE ) != SFX_ITEM_SET )
	{
		aOwnURL = rNodeURL;
		GetOwnURL( aOwnURL );
	}
	else
		aOwnURL = OWN_URL( this );

	if ( !StorageFileExists( aOwnURL ) )
	{
		// View Storage Files can only be created by calling
		// CntViewStorageNode::create(...)!
		nError = ERRCODE_IO_NOTEXISTS;
		releaseStorage();
		return NULL;
	}

	// Note: This initializes the storage.
	CntNode* pResult =
				CntRootStorageNode::Initialize( pParent, rNodeURL, nError );

	if ( !pResult )
	{
		releaseStorage();
		return NULL;
	}

	if ( !IsRestored() )
	{
		// Just created, no Props stored yet. Kill the file in dtor,
		// if no WID_INSERT is called during lifetime.
		_bKillInDtor = TRUE;
	}
	else if ( REFERED_URL( this ).Len() == 0 )
	{
		// Restored, but no Target URL! This file is damaged ( Maybe due
		// to a crash during creation of a view ). We must kill it in dtor.
		_bIsRestored = FALSE;
		_bKillInDtor = TRUE;
	}

	CntNode::Put( CntBoolItem( WID_HAS_DATA, FALSE ), WID_HAS_DATA );

#if 1
	if ( GetItemState( WID_DATE_CREATED, FALSE ) != SFX_ITEM_SET )
	{
		// Set and store(!) "date created/modified" for new created node.
		DateTime aDateTime; // now.
		Put( SfxDateTimeItem( WID_DATE_CREATED,  aDateTime ) );
		Put( SfxDateTimeItem( WID_DATE_MODIFIED, aDateTime ) );
	}
#else
	// Get and set "date created/modified" via file system API.
	const DirEntry aDirEntry( OWN_URL( this ), FSYS_STYLE_URL );
	const FileStat aStat( aDirEntry );

	DateTime aCreated( aStat.DateCreated(), aStat.TimeCreated() );
	CntNode::Put(
		SfxDateTimeItem( WID_DATE_CREATED,  aCreated ), WID_DATE_CREATED );

	DateTime aModified( aStat.DateModified(), aStat.TimeModified() );
	CntNode::Put(
		SfxDateTimeItem( WID_DATE_MODIFIED, aModified ), WID_DATE_MODIFIED );
#endif

    ///////////////////////////////////////////////////////////////////////////
    // #62661# The default title defined for an object type will never be
	//         stored to enable change of title when switching UI language.
	//         So set default title manually here.
    ///////////////////////////////////////////////////////////////////////////

	if ( IsRestored() && ( GetItemState( WID_TITLE ) != SFX_ITEM_SET ) )
	{
		const CntContentTypeItem& rTypeItem =
						(const CntContentTypeItem&)Get( WID_CONTENT_TYPE );
  		INetContentType eType = rTypeItem.GetEnumValue();
		const String aTitle( INetContentTypes::GetPresentation
							  (eType,
							   CntRootNodeMgr::GetIniManager()->
                                getIntlWrapper().getLanguage()));
		CntNode::Put( CntStringItem( WID_TITLE, aTitle ), WID_TITLE );
	}

	CntViewNode::PutChildViewDefaults(
			this, (const CntItemListItem&)Get( WID_CHILD_DEFAULTS ), FALSE );

	releaseStorage();

	return pResult;
}

//============================================================================
// virtual
CntNode* CntViewStorageNode::Initialize( CntNode* pParent,
                                         const String& rNodeURL )
{
	ErrCode nError = ERRCODE_NONE;
	return Initialize_Impl( pParent, rNodeURL, nError );
}

//============================================================================
// virtual
CntNode* CntViewStorageNode::Initialize( CntNode* pParent,
									     const String& rNodeURL,
									     ErrCode& nError )
{
	return Initialize_Impl( pParent, rNodeURL, nError );
}

//============================================================================
// virtual
CntStorage* CntViewStorageNode::CreateImplementation()
{
	return new CntLazyRootStorage();
}

//============================================================================
// virtual
void CntViewStorageNode::SetReferedNode( CntNode* pNode )
{
	if ( pNode )
	{
		//////////////////////////////////////////////////////////////
		// Merge WID's supported by all View Nodes into ranges.
		//////////////////////////////////////////////////////////////

		pNode->MergeRange( WID_DATE_CREATED,  WID_DATE_CREATED );
		pNode->MergeRange( WID_DATE_MODIFIED, WID_DATE_MODIFIED );
		pNode->MergeRange( WID_INSERT,   	  WID_INSERT );
		pNode->MergeRange( WID_UNDELETE, 	  WID_UNDELETE );
		pNode->MergeRange( WID_PURGE, 	  	  WID_PURGE );

		//////////////////////////////////////////////////////////////
		// Adjust persistent refcounts of old/new cache.
		//////////////////////////////////////////////////////////////

		CntNode* pOld = GetReferedNode();
		if ( pOld )
		{
			if ( ( pOld == pNode ) || !pOld->ISA( CntRootStorageNode ) )
				pOld = NULL;
		}

		if ( pNode->ISA( CntRootStorageNode ) )
		{
			ULONG nRefs =
					ITEMSET_VALUE( pNode, CntUInt32Item, WID_REFERER_COUNT );

			if ( pOld )
				++nRefs;
			else
			{
				if ( !IsRestored() )
					++nRefs;
				else
				{
					// Error handling: A cache node refered by a view
					// storage node must at least have a refcount of 1.
					// The refcount may be wrong, if the cache file was
					// deleted/destroyed from outside CHAOS or because
					// it was damaged...
					if ( !nRefs )
					{
						nRefs = 1;

						// Note: Putting the refcount of 1 BEFORE calling
						//       CntSystem::GetViews(...) is important to
						//       avoid recursions. Rememebr that "this" is
						//       under construction here...

						CntUInt32Item aRefItem( WID_REFERER_COUNT, nRefs );
						pNode->Put( aRefItem );
						pNode->GetReferedNode()->Put( aRefItem );

						const String& rServiceURL =
									OWN_URL( pNode->GetMostReferedNode() );
						const CntContentTypeItem& rTypeItem =
											(const CntContentTypeItem&)
												pNode->Get( WID_CONTENT_TYPE );
					  	INetContentType eType = rTypeItem.GetEnumValue();

						// First, get all known views of given type...
						CntViewList* pViews =
										CntSystem::GetViews( String(), eType );
						if ( pViews )
						{
							// ... then filter out all views pointing to
							// other objects.

							ULONG nCount = pViews->Count();
							for ( ULONG n = 0; n < nCount; ++n )
							{
								CntViewEntry* pEntry = pViews->GetObject( n );
								if ( pEntry->aViewURL == OWN_URL( this ) )
								{
									// Avoid recursion - see above...
									continue;
								}

								CntNodeRef xView(
										CNT_RNM()->Query( pEntry->aViewURL ) );
								if ( xView.Is() )
								{
									const String& rCurrServiceURL =
										OWN_URL( xView->GetMostReferedNode() );
									if ( rServiceURL == rCurrServiceURL )
										nRefs++;
								}
							}
							delete pViews;
						}
					}
				}
			}

			CntUInt32Item aItem( WID_REFERER_COUNT, nRefs );
			pNode->Put( aItem );
			pNode->GetReferedNode()->Put( aItem );
		}

		if ( pOld )
		{
			ULONG nRefs =
					ITEMSET_VALUE( pOld, CntUInt32Item, WID_REFERER_COUNT );
			if ( nRefs )
				--nRefs;

			CntUInt32Item aItem( WID_REFERER_COUNT, nRefs );
			pOld->Put( aItem );
			pOld->GetReferedNode()->Put( aItem );
		}
	}

	CntRootStorageNode::SetReferedNode( pNode );
}

//============================================================================
//virtual
const SfxPoolItem* CntViewStorageNode::InsertJob( CntNodeJob *pJob )
{
	const SfxPoolItem* pReq = pJob->GetRequest();
	switch ( pReq->Which() )
	{
		case WID_REFERED_URL:
			Exchange_Impl( pJob );
			pJob->Done();
			return NULL;

		case WID_INSERT:
			// Caller wants a persistent view now.
			_bKillInDtor = FALSE;

			if ( GetItemState( WID_TITLE ) != SFX_ITEM_SET )
			{
				// Make sure, we have a title here. Rename storage file
				// according to it.
				const CntContentTypeItem& rTypeItem =
						(const CntContentTypeItem&)Get( WID_CONTENT_TYPE );
  				INetContentType eType = rTypeItem.GetEnumValue();
				const String aTitle(
							INetContentTypes::GetPresentation
							 (eType,
							  CntRootNodeMgr::GetIniManager()->
                               getIntlWrapper().getLanguage()));
				CntStringItem aItem( WID_TITLE, aTitle );
				RenameStorage_Impl( pJob, aItem );
				CntNode::Put( aItem , WID_TITLE );
			}

			pJob->Result( this, CNT_ACTION_INSERTED );
			pJob->Done();
			return NULL;

		case WID_PUTDATA:
		{
			CntItemListItem *pListItem = (CntItemListItem *)pReq;
			USHORT nCount = pListItem->Count();
			for ( USHORT n = 0; n < nCount; n++ )
			{
				if ( (*pListItem)[n].Which() == WID_TITLE )
				{
					if ( !RenameStorage_Impl( pJob, (*pListItem)[n] ) )
				   		pListItem->Remove( n );

					break;
				}
			}
			break;
		}

		case WID_TITLE:
			if ( !RenameStorage_Impl( pJob, *pReq ) )
			{
				pJob->Cancel();
				return NULL;
			}
			break;

		case WID_DELETE:
			if ( _bKillInDtor )
			{
				pJob->Cancel();
				return NULL;
			}

			if ( ITEM_VALUE( CntBoolItem, *pReq ) )
				break;

			// Note: fall-thru is okay.

		case WID_UNDELETE:
		case WID_PREPARE_MOVE:
			// First, release all children!
			Broadcast( CntNodeHint( this, CNT_ACTION_KILL_ALL, pJob ) );

			// release storage file - i.e. to allow moving a server
			GetStorage()->closeStorage();
			break;

		default:
			break;
	}

	return CntRootStorageNode::InsertJob( pJob );
}

//============================================================================
// virtual
void CntViewStorageNode::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	CntRootStorageNode::Notify( rBC, rHint );
}

//============================================================================
// static
BOOL CntViewStorageNode::IsRootViewURL( const String& rURL )
{
	String aURL( rURL );
	aURL.ToLowerAscii();

	 // aURL must be at least "file:///.scc"
	if ( aURL.Len() < 12 )
		return FALSE;

	// aURL must start with "file://"
	if ( aURL.SearchAscii( "file://" ) != 0 )
		return FALSE;

	// aURL must end with ".scc"
	String aExt( '.' );
	aExt.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_FILE_EXTENSION ) );

	if ( aURL.Search( aExt ) != ( aURL.Len() - aExt.Len() ) )
		return FALSE;

	return TRUE;
}

//============================================================================
// static
BOOL CntViewStorageNode::IsSubViewURL ( const String& rURL )
{
	String aURL( rURL );
	aURL.ToLowerAscii();

	// aURL must be at least "file:///.scc#"
	if ( aURL.Len() < 13 )
		return FALSE;

	// aURL must start with "file://"
	if ( aURL.SearchAscii( "file://" ) != 0 )
		return FALSE;

	// aURL must contain ".scc#".
	String aTag( '.' );
	aTag.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_FILE_EXTENSION ) );
	aTag += '#';

	if ( aURL.Search( aTag ) == STRING_NOTFOUND )
		return FALSE;

	return TRUE;
}

//-----------------------------------------------------------------------------
oslInterlockedCount CntViewStorageNode::acquireStorage()
{
	return ( (CntLazyRootStorage*)GetStorage() )->acquireStorage();
}

//-----------------------------------------------------------------------------
oslInterlockedCount CntViewStorageNode::releaseStorage()
{
	return ( (CntLazyRootStorage*)GetStorage() )->releaseStorage();
}

//============================================================================
BOOL CntViewStorageNode::RenameStorage_Impl( CntNodeJob *pJob,
									 		 const SfxPoolItem &rReq )
{
	if ( rReq.Which() != WID_TITLE )
	{
		DBG_ERRORFILE( "RenameStorage: pReq != WID_TITLE" );
		return FALSE;
	}

	String aNew( ITEM_VALUE( CntStringItem, rReq ) );
	if ( !aNew.Len() )
		return FALSE;

	const String& rOldURL = OWN_URL( this );
	INetURLObject aURLObject( rOldURL );
	const String aExt = aURLObject.GetExtension();
	if ( aExt.EqualsAscii( STG_FILE_EXTENSION ) )
	{
		///////////////////////////////////////////////////////////////////
		// Remove any invalid chars from new filename...
		///////////////////////////////////////////////////////////////////

		// Chars taken from Windows NT 4.0 error message given after
		// trying to create a folder with an invalid char in it's name.
		static const String aInvalidChars( UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( "\\/:*?\"<>|#." ) ) );
		xub_StrLen nCount = aInvalidChars.Len();
		for ( xub_StrLen n = 0; n < nCount; n++ )
		{
			const sal_Unicode aChar = aInvalidChars.GetChar( n );
			xub_StrLen nPos = aNew.Search( aChar );
			while ( nPos != STRING_NOTFOUND )
			{
				aNew.Erase( nPos, 1 );
				nPos = aNew.Search( aChar );
			}
		}

		String aNewFileName( aNew );
		aNewFileName += '.' ;
		aNewFileName += aExt;

		// Make sure we have valid file name.
		DirEntry aParentDirEntry( aURLObject.GetPartBeforeLastName() );
		BOOL bOK = aParentDirEntry.MakeShortName( aNewFileName,
												  FSYS_KIND_NONE, FALSE );
		aURLObject.SetName( aParentDirEntry.GetName() );

		if ( !bOK &&
		     ( aParentDirEntry.GetError() != ERRCODE_IO_ALREADYEXISTS ) )
		{
			DBG_ERROR( "CntRootStorageNode::RenameStorage - !MakeShortName!" );
			return FALSE;
		}

		// Lower-case file names pointing to files on non-case-sensitive
		// file systems.
		DirEntry aDirEntry( aURLObject.PathToFileName() );
		if ( !aDirEntry.IsCaseSensitive() )
		{
			String aPath( aURLObject.GetURLPath() );
			aURLObject.SetURLPath( aPath.ToLowerAscii() );
		}

		if ( _aStorageName == aURLObject.GetMainURL() )
			return TRUE;

		// Does a file with the name just calculated already exist?
		DirEntry aNewFile( aURLObject.GetMainURL(), FSYS_STYLE_URL );
		if ( aNewFile.Exists() )
		{
			DirEntry aNewEntry( aURLObject.GetPartBeforeLastName() );
			aNewEntry.MakeShortName( aNewFile.GetName() );
			aURLObject.SetName( aNewEntry.GetName() );
		}

		CNT_RNM()->RemoveView( this );

		// close old storage medium
		if ( GetStorage()->closeStorage() != ERRCODE_NONE )
			return FALSE;

		if ( !Initialize( GetParent(), aURLObject.GetMainURL() ) )
		{
			// Re-Initialize with old name
			Initialize( GetParent(), rOldURL );
			CNT_RNM()->AddView( this );
			return TRUE;

		}

		pJob->Result( this, CNT_ACTION_FILENAME_CHANGED );
		return TRUE;
	}

	return FALSE;
}

//============================================================================
void CntViewStorageNode::Exchange_Impl( CntNodeJob* pJob )
{
	String aURL( ITEM_VALUE( CntStringItem, *pJob->GetRequest() ) );

	///////////////////////////////////////////////////////
	// Transfer possibly stored view props.
	///////////////////////////////////////////////////////
	TransferViewProperties_Impl( pJob, this );

	// Hold old refered node.
	CntNodeRef xOld = GetReferedNode();

	// Old refered node does not exist in case a new account is just to be
	// created. First, a view storage node without a refered node will
	// be created. Into it then will be putted a WID_REFERED_URL job, which
	// calls this method.

	ULONG nRefCount = 0;

	if ( xOld.Is() )
	{
		// Make sure, my old refered node is a storage node.
		// GetDirectoryNode() creates and sets it into my node chain,
		// if not already there. Note that directory nodes will only
		// be created on demand!
		pJob->GetDirectoryNode( FALSE );

		// Determine whether a new cache node shall be constructed for the
		// new node. The URL passed thru this method in most cases is the
		// one of the service node which "triggered" the exchange.
		if ( xOld->ISA( CntRootStorageNode ) &&
		     ( aURL.SearchAscii( STG_PROTOCOL_CACHE ) == STRING_NOTFOUND ) )
			aURL.Insert( UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( STG_PROTOCOL_CACHE ) ),
						 0 );
	}

	if ( StorageFileExists( aURL ) )
	{
		CntNodeRef xOldCache( CNT_RNM()->Query( aURL ) );

		if ( xOldCache.Is() )
		{
			ULONG nTmpRefs =
				ITEMSET_VALUE( xOldCache, CntUInt32Item, WID_REFERER_COUNT );
			if ( nTmpRefs && ( nTmpRefs != STG_NEVER_DELETE ))
			{
				CntViewList* pViews = CntSystem::GetViews( String(), aURL );
				if ( !pViews || !pViews->Count() )
				{
					// Cache file exists, but no views to it...

					// Ask user whether old cache data shall be used or deleted.
		    		ErrCode nError = *new StringErrorInfo(
								ERRCODE_CHAOS_QUERY_DELETE_CACHE,
								OWN_URL( xOldCache->GetMostReferedNode() ) );
					USHORT nResponse = CNT_RNM()->HandleError( nError, pJob );

					if ( nResponse == ERRCODE_BUTTON_YES )
					{
						// Destroy existing cache file...

		    			nError =
							( (CntStorageNode*)&xOldCache )->destroy();
						if ( nError == ERRCODE_NONE )
						{
							xOldCache->Dead(); // (R.I.P.)

							// Physically destroy xOld's user storage.
							CntStorageNode* pUser =
								(CntStorageNode*)pJob->GetUserDataNode( FALSE );
							if ( pUser )
							{
								nError = pUser->destroy();
								if ( nError == ERRCODE_NONE )
									pUser->Dead(); // (R.I.P.)
							}

							// Remove entry from RNM's file name table.
							INetURLObject aURLObject( ( (CntStorageNode*)
											&xOldCache )->GetStorageName() );
							String aShortName( aURLObject.GetLastName() );
							CNT_RNM()->RemoveFileEntry( aShortName );

							nRefCount = nTmpRefs;
						}
					}
				}
				delete pViews;
			}
		}
	}

	// Get the new node.
	CntNodeRef xNew = CNT_RNM()->Query( aURL );

	if ( xNew.Is() )
	{
		if ( nRefCount )
		{
			ULONG nRefs =
				ITEMSET_VALUE( xNew, CntUInt32Item, WID_REFERER_COUNT );
			xNew->Put( CntUInt32Item( WID_REFERER_COUNT, nRefCount + nRefs ) );
		}
	}
	else
	{
		DBG_ERROR( "CntNode::Exchange - Unable to get new node!" );
		return;
	}

	if ( &xOld == &xNew )
	{
		DBG_ERROR( "CntNode::Exchange - new node == old node!" );
		return;
	}

	if ( xOld.Is() )
	{
		// Get refcount of new refered node.
		ULONG nNewRef =
				ITEMSET_VALUE( xNew, CntUInt32Item, WID_REFERER_COUNT );

		// Was new node just created?
		if ( !nNewRef )
		{
			///////////////////////////////////////////////////////
			// Transfer "own props" from old node to new node
			///////////////////////////////////////////////////////
			TransferOwnProperties_Impl( xOld, xNew );
		}

		// Get refcount of old refered node.
		ULONG nOldRef =
				ITEMSET_VALUE( xOld, CntUInt32Item, WID_REFERER_COUNT );

		// Destroy xOld's storage medium, if last referer is gone.
		if ( ( nOldRef <= 1 ) && !xOld->IsDummy() )
		{
			// Is old node a cache node?
			if ( ( (CntBoolItem&)xOld->Get( WID_HAS_DATA, FALSE ) )
				 .GetValue() )
			{
				CntNode* pOldMostRef = xOld->GetMostReferedNode();
				INetURLObject aOldURLObj( OWN_URL( pOldMostRef ) );

				//////////////////////////////////////////////////////
				// #45875#
				// Do not query the user whether the cache data shall
				// be deleted in case he only added ( not changed! )
				// the user name for an account.
				//////////////////////////////////////////////////////

				BOOL bAskUser = TRUE;

				// No user name in old URL?
				if ( aOldURLObj.GetUser().Len() == 0 )
				{
					// User name in new URL?
					CntNode* pNewMostRef = xNew->GetMostReferedNode();
					INetURLObject aNewURLObj( OWN_URL( pNewMostRef ) );

					if ( aNewURLObj.GetUser().Len() > 0 )
					{
						if ( aNewURLObj.GetHost() == aOldURLObj.GetHost() )
							bAskUser = FALSE;
					}
				}

				//////////////////////////////////////////////////////
				// End: #45875#
				//////////////////////////////////////////////////////

				USHORT  nResponse = ERRCODE_BUTTON_YES;
				ErrCode nError    = ERRCODE_NONE;

				if ( bAskUser )
				{
					// Ask user whether old cache data shall be deleted.
				    nError = *new StringErrorInfo(
											ERRCODE_CHAOS_QUERY_DELETE,
											aOldURLObj.GetMainURL() );
					nResponse =	CNT_RNM()->HandleError( nError, pJob );
				}

				if ( nResponse == ERRCODE_BUTTON_YES )
				{
				    // Physically destroy xOld's storage.
				    nError = ( (CntStorageNode*)&xOld )->destroy();
					if ( nError == ERRCODE_NONE )
					{
						xOld->Dead(); // (R.I.P.)

						// Physically destroy xOld's user storage.
						CntStorageNode* pUser =	(CntStorageNode*)
										pJob->GetUserDataNode( FALSE );
						if ( pUser )
						{
							nError = pUser->destroy();
							if ( nError == ERRCODE_NONE )
								pUser->Dead(); // (R.I.P.)
						}

						// Remove entry from RNM's file name conversion table.
						INetURLObject aURLObject(
							( (CntStorageNode*)&xOld )->GetStorageName() );
						String aShortName( aURLObject.GetLastName() );
						CNT_RNM()->RemoveFileEntry( aShortName );
					}
				}
			}
		}
	}

	// Connect to new node.
	SetReferedNode( xNew );

	if ( xOld.Is() )
	{
		// Transfer outstanding jobs to pNew
		TransferJobsToDo_Impl( xOld, xNew );

		// Inform all views...
		Broadcast( CntNodeHint( this, CNT_ACTION_EXCHANGED, pJob ) );
	}
}

//============================================================================
// Helpers.
//============================================================================

BOOL TransferOwnProperties_Impl( CntNode* pOld, CntNode* pNew )
{
	if ( pOld->IsDummy() || pNew->IsDummy() )
		return FALSE;

	CntStorageNode* pOldStg = PTR_CAST( CntStorageNode, pOld );
	if ( !pOldStg )
		return FALSE;

	CntStorageNode* pNewStg = PTR_CAST( CntStorageNode, pNew );
	if ( !pNewStg )
		return FALSE;

	// assemble name of property stream
	String aPropsName( UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM( STG_OWN_PROPERTY_SET ) ) );
	aPropsName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_PROPS_EXTENSION ) );

	CntStoreItemSetRef xOldSet(
					pOldStg->openItemSet( aPropsName, STREAM_STD_READ ) );
	if ( !xOldSet.Is() )
		return FALSE;

	pNewStg->attrib( aPropsName, 0,
				   	 CNTDIRENTRY_ATTRIB_HIDDEN | CNTDIRENTRY_ATTRIB_CREATE );

	CntStoreItemSetRef xNewSet(
			 		pNewStg->openItemSet( aPropsName, STREAM_STD_READWRITE ) );
	if ( !xNewSet.Is() )
		return FALSE;

	SfxItemIter aIter( *xOldSet );
	for ( const SfxPoolItem *pItem = aIter.FirstItem();
	  	  pItem;
	      pItem = aIter.NextItem() )
	{
		//////////////////////////////////////////////////////////////////
		// Transfer old items to new node...
		//////////////////////////////////////////////////////////////////
		USHORT nWhich = pItem->Which();

		// Do not take over the refered URL of the old node!!!
		if ( nWhich == WID_REFERED_URL )
		{
			// Overwrite the old refered URL instead.
			xNewSet->Put( pNew->Get( WID_REFERED_URL, FALSE ) );
			continue;
		}

		// Do not take over the referer count of the old node!!!
		if ( nWhich == WID_REFERER_COUNT )
			continue;

		// Do not touch items already set in pNew!
		if ( pNew->GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
			continue;

		pNew->CntNode::Put( *pItem,	nWhich );

		if ( pNew->GetReferedNode() )
			pNew->GetReferedNode()->CntNode::Put( *pItem, nWhich );

		//////////////////////////////////////////////////////////////////
		// ...and store them permanently in new node.
		//////////////////////////////////////////////////////////////////
		xNewSet->Put( *pItem );
	}

	return TRUE;
}

//============================================================================
BOOL TransferViewProperties_Impl( CntNodeJob* pJob, CntNode* pNode )
{
	CntStorageNode* pView = pJob->GetViewDataNode();
	if ( !pView )
		return FALSE;

	CntNode* pMostRef = pNode->GetMostReferedNode();
	if ( pMostRef == pView )
		return FALSE;

	// take over any possible stored view data...
	String aNewName( ITEM_VALUE( CntStringItem, *( pJob->GetRequest() ) ) );
	xub_StrLen nLast = aNewName.Len() - 1;
	if ( ( aNewName.GetChar( nLast ) == '/' ) &&
		 ( aNewName.GetChar( nLast - 1 ) != '/' ) )
		aNewName.Erase( nLast );

	String aOldName( OWN_URL( pMostRef ) );
	nLast = aOldName.Len() - 1;
	if ( ( aOldName.GetChar( nLast ) == '/' ) &&
		 ( aOldName.GetChar( nLast - 1 ) != '/' ) )
		aOldName.Erase( nLast );

	String aWild( aOldName );
	aWild += '*';
	aWild.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_PROPS_EXTENSION ) );

	WildCard aPattern( aWild );

	// Iteration over all hidden entries
	CntStorageIterator aIter( CNTDIRENTRY_ATTRIB_HIDDEN, 0 );
	String aEntry( pView->iter( aIter ) );

	while ( aEntry.Len() )
	{
		if ( aPattern.Matches( aEntry ) )
		{
			xub_StrLen nPos = aEntry.Match( aOldName );
			String aTemp( aEntry.Copy( nPos ) );
			if ( ( aEntry.GetChar( nPos ) == '/' ) ||
				 aTemp.EqualsAscii( STG_PROPS_EXTENSION ) )
			{
				// Rename entry
				String aNewEntry( aNewName );
				aNewEntry += aTemp;
				pView->rename( aEntry, aNewEntry );
			}
		}

		aEntry = pView->iter( aIter );
	}

	return TRUE;
}

//===========================================================================
//
// CntStorageRebuildTask implementation.
//
//===========================================================================

CntStorageRebuildTask::CntStorageRebuildTask( CntNodeJob *pJob )
: CntTask( pJob )
{
}

//-----------------------------------------------------------------------------
//virtual
CntStorageRebuildTask::~CntStorageRebuildTask()
{
}

//-----------------------------------------------------------------------------
//virtual
void SAL_CALL CntStorageRebuildTask::run()
{
	if ( !_xJob->IsCanceled() )
	{
	//	while ( !m_CacheIter.eof() && schedule() )
		if ( schedule() )
			Rebuild_Impl( _xJob->GetCacheNode( FALSE ) );
	}

	if ( !_xJob->IsCanceled() )
	{
	//	while ( !m_UserIter.eof() && schedule() )
		if ( schedule() )
			Rebuild_Impl( _xJob->GetUserDataNode( FALSE ) );
	}

	if ( !_xJob->IsCanceled() )
	{
	//	while ( !m_ViewIter.eof() && schedule() )
		if ( schedule() )
			Rebuild_Impl( _xJob->GetViewDataNode( FALSE ) );
	}

	if ( schedule() )
	{
		// Reschedule job (trigger completion).
		_xJob->GetSubject()->RescheduleJob( _xJob );
	}
}

//-----------------------------------------------------------------------------
//virtual
const SfxPoolItem* CntStorageRebuildTask::Execute()
{
	// Check context.
	if ( !_xJob.Is() )
		return NULL;

	const SfxPoolItem *pReq = _xJob->GetRequest();
	if ( pReq == NULL )
	{
		_xJob->Cancel();
		return NULL;
	}

	// Initialize.
	if ( !_xJob->IsRescheduled() )
	{
		// Notify caller.
		_xJob->Started();

		// Create worker thread (reschedules job when complete).
		if ( !create() )
		{
			// Failure.
			_xJob->Cancel();
		}
		return NULL;
	}

	// Done.
	_xJob->Done();
	return NULL;
}

//-----------------------------------------------------------------------------
//virtual
void CntStorageRebuildTask::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	CntNodeJob *pJob = PTR_CAST( CntNodeJob, &rBC );
	if ( ( pJob != NULL ) && ( pJob == &_xJob ) )
	{
		if ( pJob->IsCancelled() || pJob->IsDone() )
		{
			// Job finished. Terminate thread.
			terminate();
			if ( getIdentifier() != getCurrentIdentifier() )
				join();
		}
	}
	CntTask::Notify( rBC, rHint );
}

//-----------------------------------------------------------------------------
void CntStorageRebuildTask::Rebuild_Impl( CntNode* pStore )
{
	if ( !pStore )
		return;

	if ( !pStore->ISA( CntRootStorageNode ) )
		return;

	ErrCode nError = ERRCODE_NONE;
	CntRootStorageNode* pStorage = (CntRootStorageNode*)pStore;

	if ( pStorage )
		nError = pStorage->rebuild();

	HandleError_Impl( nError, pStorage );
}

//-----------------------------------------------------------------------------
void CntStorageRebuildTask::HandleError_Impl( ErrCode nError,
											  CntRootStorageNode* pStore )
{
	switch ( nError )
	{
		case ERRCODE_NONE:
			return;

		case ERRCODE_CHAOS_REORGANIZE_NO_DISKSPACE:
		{
			String aName;
			UINT32 nMissing = 0;

			if ( pStore )
			{
				aName = OWN_URL( pStore );
				CntStorageNode::Own2FileURL( aName );

				aName = DirEntry(
							aName, FSYS_STYLE_URL ).GetFull( FSYS_STYLE_HOST );

				pStore->size( nMissing );
				nMissing /= 1024; // KBytes...
			}

    		nError = *new TwoStringErrorInfo(
					ERRCODE_CHAOS_REORGANIZE_NO_DISKSPACE, aName, nMissing );
			break;
		}

		case ERRCODE_CHAOS_REORGANIZE_FILE_LOCKED:
		{
			String aName;
			if ( pStore )
			{
				aName = OWN_URL( pStore );
				CntStorageNode::Own2FileURL( aName );

				aName = DirEntry(
							aName, FSYS_STYLE_URL ).GetFull( FSYS_STYLE_HOST );
			}

    		nError = *new StringErrorInfo(
							ERRCODE_CHAOS_REORGANIZE_FILE_LOCKED, aName );
			break;
		}

		default:
			break;
	}

	_xJob->SetError( nError );
}

