/*************************************************************************
 *
 *  $RCSfile: encodename.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jb $ $Date: 2001/07/05 17:05:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "encodename.hxx"

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

namespace configmgr
{

	using ::rtl::OUString;

	void escaped_name::validateName(const OUString& aString, uno::XInterface* pSource, sal_Int16 index)
		throw(lang::IllegalArgumentException, uno::RuntimeException)
	{
		if ( !encodename::validate(aString) )
		{
			OUString
			sMessage  = OUString::createFromAscii("The string \"");
			sMessage += aString;
			sMessage += OUString::createFromAscii("\" is not a valid name for this service");

			throw lang::IllegalArgumentException(sMessage, pSource,index);
		}
	}

	OUString escaped_name::escapeString( const OUString& aString, util::XStringEscape* pSource, sal_Int16 index ) 
		throw(lang::IllegalArgumentException, uno::RuntimeException)
	{
		OUString aRet = encodename::encode(aString);
		OSL_ASSERT(encodename::validate(aRet));
		return aRet;
	}

	OUString escaped_name::unescapeString( const OUString& aString, util::XStringEscape* pSource, sal_Int16 index ) 
		throw(lang::IllegalArgumentException, uno::RuntimeException)
	{
		bool bValid = false;
		OUString aRet = encodename::decode(aString,bValid);

		if (!bValid) 
		{
			OUString
			sMessage  = OUString::createFromAscii("The string \"");
			sMessage += aString;
			sMessage += OUString::createFromAscii("\" is not a name escaped by this service");

			throw lang::IllegalArgumentException(sMessage, pSource,index);
		}
		OSL_ASSERT(encodename::validate(aString));

		return aRet;
	}

//============================================================================
//
//  encode
//
//============================================================================

namespace encodename {

class ModifiedUTF7Buffer
{
	rtl::OUStringBuffer & m_rBuffer;
	sal_uInt32 m_nValue;
	int m_nFilled;

public:
	ModifiedUTF7Buffer(rtl::OUStringBuffer * pTheBuffer):
		m_rBuffer(*pTheBuffer), m_nFilled(0) {}

	inline void write(sal_Unicode c);

	void flush();
};

inline void ModifiedUTF7Buffer::write(sal_Unicode c)
{
	switch (m_nFilled)
	{
		case 0:
			m_nValue = sal_uInt32(c) << 8;
			m_nFilled = 2;
			break;

		case 1:
			m_nValue |= sal_uInt32(c);
			m_nFilled = 3;
			flush();
			break;

		case 2:
			m_nValue |= sal_uInt32(c) >> 8;
			m_nFilled = 3;
			flush();
			m_nValue = (sal_uInt32(c) & 0xFF) << 16;
			m_nFilled = 1;
			break;
	}
}

void ModifiedUTF7Buffer::flush()
{
	static sal_Unicode const aModifiedBase64[64]
		= { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
			'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
			'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
			'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
			'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '.' };
	switch (m_nFilled)
	{
		case 1:
			m_rBuffer.append(aModifiedBase64[m_nValue >> 18]);
			m_rBuffer.append(aModifiedBase64[m_nValue >> 12 & 63]);
			break;

		case 2:
			m_rBuffer.append(aModifiedBase64[m_nValue >> 18]);
			m_rBuffer.append(aModifiedBase64[m_nValue >> 12 & 63]);
			m_rBuffer.append(aModifiedBase64[m_nValue >> 6 & 63]);
			break;

		case 3:
			m_rBuffer.append(aModifiedBase64[m_nValue >> 18]);
			m_rBuffer.append(aModifiedBase64[m_nValue >> 12 & 63]);
			m_rBuffer.append(aModifiedBase64[m_nValue >> 6 & 63]);
			m_rBuffer.append(aModifiedBase64[m_nValue & 63]);
			break;
	}
	m_nFilled = 0;
	m_nValue = 0;
}


inline bool isUsAsciiAlphaDigit(sal_Unicode c, bool bDigitAllowed = true)
{
	return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z'
		   || bDigitAllowed && c >= '0' && c <= '9';
}

rtl::OUString encode(rtl::OUString const & rSource)
{
    return encode_pair(rSource, OUString());
}

rtl::OUString encode_pair(rtl::OUString const & rSource, rtl::OUString const&)
{
	rtl::OUStringBuffer aTarget;

	sal_Unicode const * pBegin = rSource.getStr();
	sal_Unicode const * pEnd = pBegin + rSource.getLength();
	sal_Unicode const * pCopyEnd = pBegin;
	sal_Unicode const * p = pBegin;
	while (p != pEnd)
	{
		sal_Unicode c = *p;
		if (!isUsAsciiAlphaDigit(c,p != pBegin))
			switch (c)
			{
				case '-':
				case '.':
					if (p != pBegin)
						break;
				default:
					aTarget.append(pCopyEnd, p - pCopyEnd);
					aTarget.append(sal_Unicode('_'));
					ModifiedUTF7Buffer aBuffer(&aTarget);
					for (;;)
					{
						aBuffer.write(c);
						++p;
						if (p == pEnd)
							break;
						c = *p;
						if (isUsAsciiAlphaDigit(c) || c == '-' || c == '.')
							break;
					}
					aBuffer.flush();
					aTarget.append(sal_Unicode('_'));
					pCopyEnd = p;
					continue;
			}
		++p;
	}

	if (pCopyEnd == pBegin)
		return rSource;
	else
	{
		aTarget.append(pCopyEnd, pEnd - pCopyEnd);
		return aTarget.makeStringAndClear();
	}
}
//============================================================================
//
//  decode
//
//============================================================================

bool decodeModifiedUTF7(sal_Unicode const ** pBegin,
							   sal_Unicode const * pEnd,
							   bool bInitial,
							   rtl::OUStringBuffer * pBuffer)
{
	sal_Unicode cUTF16Char;
	int nFilled = 0;
	for (sal_Unicode const * p = *pBegin; p != pEnd;)
	{
		static sal_uInt8 const aModifiedBase64[128]
			= { 65, 65, 65, 65, 65, 65, 65, 65,
				65, 65, 65, 65, 65, 65, 65, 65,
				65, 65, 65, 65, 65, 65, 65, 65,
				65, 65, 65, 65, 65, 65, 65, 65,
				65, 65, 65, 65, 65, 65, 65, 65, //  !"#$%&'
				65, 65, 65, 65, 65, 62, 63, 65, // ()*+,-./
				52, 53, 54, 55, 56, 57, 58, 59, // 01234567
				60, 61, 65, 65, 65, 65, 65, 65, // 89:;<=>?
				65,  0,  1,  2,  3,  4,  5,  6, // @ABCDEFG
				 7,  8,  9, 10, 11, 12, 13, 14, // HIJKLMNO
				15, 16, 17, 18, 19, 20, 21, 22, // PQRSTUVW
				23, 24, 25, 65, 65, 65, 65, 64, // XYZ[\]^_
				65, 26, 27, 28, 29, 30, 31, 32, // `abcdefg
				33, 34, 35, 36, 37, 38, 39, 40, // hijklmno
				41, 42, 43, 44, 45, 46, 47, 48, // pqrstuvw
				49, 50, 51, 65, 65, 65, 65, 65 }; // xyz{|}~

		sal_Unicode c = *p++;
		int nDigit = c < 128 ? aModifiedBase64[c] : 65;
		switch (nDigit)
		{
			default: // valid character
				switch (nFilled)
				{
					case 2:
						cUTF16Char |= nDigit >> 2;
						goto write;

					case 5:
						cUTF16Char |= nDigit >> 4;
						goto write;

					case 7:
						cUTF16Char |= nDigit;
				write:
						if (isUsAsciiAlphaDigit(cUTF16Char, !bInitial)
							|| !bInitial
							   && (cUTF16Char == '-' || cUTF16Char == '.'))
							return false;
						pBuffer->append(cUTF16Char);
						bInitial = false;
						break;
				}
				switch (nFilled)
				{
					case 0:
						cUTF16Char = nDigit << 10;
						++nFilled;
						break;

					case 1:
						cUTF16Char |= nDigit << 4;
						++nFilled;
						break;

					case 2:
						cUTF16Char = (nDigit & 3) << 14;
						++nFilled;
						break;

					case 3:
						cUTF16Char |= nDigit << 8;
						++nFilled;
						break;

					case 4:
						cUTF16Char |= nDigit << 2;
						++nFilled;
						break;

					case 5:
						cUTF16Char = (nDigit & 15) << 12;
						++nFilled;
						break;

					case 6:
						cUTF16Char |= nDigit << 6;
						++nFilled;
						break;

					case 7:
						nFilled = 0;
						break;
				}
				break;

			case 64: // terminating '_'
				switch (nFilled)
				{
					case 3:
					case 6:
						if (cUTF16Char != '\0')
							break;
					case 0:
						*pBegin = p;
						return true;
				}
			case 65: // invalid character
				return false;
		}
	}
	return false;
}

rtl::OUString decode(rtl::OUString const & rSource, bool& rbValid)
{
    rtl::OUString sResult, sSecondary;

    if (decode_pair(rSource, sResult, sSecondary,rbValid))
    {
        OSL_ASSERT(rbValid);
        if (sSecondary.getLength() != 0)
        {
            rbValid = false;
            //return rSource; // (?)
        }
    }

    return sResult;
}


bool decode_pair(rtl::OUString const & rSource, rtl::OUString& rPrimary, rtl::OUString& rSecondary,bool& rbValid)
{
    rPrimary = rSource;
    rSecondary = OUString();
	rbValid = false;

	rtl::OUStringBuffer aTarget;

	sal_Unicode const * pBegin = rSource.getStr();
	sal_Unicode const * pEnd = pBegin + rSource.getLength();
	sal_Unicode const * pCopyEnd = pBegin;
	for (sal_Unicode const * p = pBegin; p != pEnd;)
	{
		sal_Unicode c = *p;
		if (!isUsAsciiAlphaDigit(c, p!=pBegin))
			switch (c)
			{
				case '_':
					aTarget.append(pCopyEnd, p - pCopyEnd);
					++p;
					if (!decodeModifiedUTF7(&p, pEnd, p - pBegin == 1,
											&aTarget))
						return false;
					pCopyEnd = p;
					continue;

				case '-':
				case '.':
					if (p != pBegin)
						break;
				default:
					return false;
			}
		++p;
	}
	rbValid = true;

	if (pCopyEnd == pBegin)
		return false;
	else
	{
		aTarget.append(pCopyEnd, pEnd - pCopyEnd);
		rPrimary = aTarget.makeStringAndClear();
        return true;
	}
}

uno::Sequence< ::rtl::OUString > decode(uno::Sequence< ::rtl::OUString >const& rSource)
{
	sal_Int32 nLen = rSource.getLength();
	uno::Sequence< ::rtl::OUString > rResult(rSource.getLength());	
	bool bSuccess;

	for (sal_Int32 i = 0; i != nLen; ++i)
		rResult[i] = decode(rSource[i], bSuccess);

	return rResult;
}





//============================================================================
//
//  validate
//
//============================================================================

bool validate(const rtl::OUString& rSource)
{
	sal_Unicode const * const pBegin = rSource.getStr();
	sal_Unicode const * const pEnd = pBegin + rSource.getLength();

	if (pBegin == pEnd) return false; // no empty names

	for (sal_Unicode const * p = pBegin; p != pEnd; ++p)
	{
		sal_Unicode c = *p;
		if (!isUsAsciiAlphaDigit(c, p != pBegin))
			switch (c)
			{
				case '_':
					break;

				case '-':
				case '.':
					if (p != pBegin)
						break;
					//else:
				default:
					return false;
			}
	}
	return true;
}

} // namespace unnamed_encodename
} // namespace configmgr

