/*************************************************************************
 *
 *  $RCSfile: adminimpl.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dg $ $Date: 2001/10/11 14:19:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "adminimpl.hxx"

#ifndef _COM_SUN_STAR_CONTAINER_XHIERARCHICALNAMEACCESS_HPP_
#include <com/sun/star/container/XHierarchicalNameAccess.hpp>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif
#ifndef CONFIGMGR_CONFIGSET_HXX_
#include "configset.hxx"
#endif
#ifndef CONFIGMGR_API_NODEACCESS_HXX_
#include "apinodeaccess.hxx"
#endif
#ifndef CONFIGMGR_API_FACTORY_HXX_
#include "apifactory.hxx"
#endif
#ifndef _CONFIGMGR_TREEACTIONS_HXX_
#include "treeactions.hxx"
#endif
#ifndef _CONFIGMGR_TREECACHE_HXX_
#include "treecache.hxx"
#endif
#ifndef _CONFIGMGR_XMLFORMATER_HXX
#include "xmlformater.hxx"
#endif
#ifndef CONFIGMGR_API_ADMINPROVIDERIMPL_HXX_
#include "adminproviderimpl.hxx"
#endif
#ifndef CONFIGMGR_API_ENCODENAME_HXX_
#include "encodename.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef _CONFIGMGR_STRDECL_HXX_
#include <strdecl.hxx>
#endif


namespace configmgr
{
	namespace css  = ::com::sun::star;
	namespace uno  = css::uno;
	namespace lang = css::lang;	
	using ::rtl::OUString;
	using ::vos::ORef;
	using namespace osl;
	using namespace configuration;
	using namespace configapi;	

	//-----------------------------------------------------------------------------
    static inline Name makeElementName(rtl::OUString const& _sName)
    {
        return makeName(_sName,Name::NoValidate());
    }
	
	//-----------------------------------------------------------------------------
	static inline AbsolutePath getProfilePath()
    {
        return AbsolutePath::makeModulePath(NODE_USERPROFILE, AbsolutePath::NoValidate());
    }
	
	//-----------------------------------------------------------------------------
    static inline Path::Component makeFullName(rtl::OUString const& _sName)
    {
        return Path::wrapSafeName(_sName);
    }	
	
	//=============================================================================
	//= OAdminAccess
	//=============================================================================	
	//-----------------------------------------------------------------------------
	OAdminAccess::OAdminAccess(OAdminProviderImpl* _pProviderImpl, ServiceInfo const* pInfo)
			     :ServiceComponentImpl(pInfo)
				 ,m_pProviderImpl(_pProviderImpl)	
	{
		m_pProviderImpl->acquire();
	}

	//-----------------------------------------------------------------------------
	void SAL_CALL OAdminAccess::disposing()
	{		
		if (m_pProviderImpl)
		{
			MutexGuard aGuard(m_aMutex);
			if (m_pProviderImpl)
			{
				m_pProviderImpl->release();
				m_pProviderImpl = NULL;
			}
		}		
		ServiceComponentImpl::disposing();
	}

	// XInterface
	//------------------------------------------------------------------------
	void SAL_CALL OAdminAccess::acquire() throw() { ServiceComponentImpl::acquire(); }
	void SAL_CALL OAdminAccess::release() throw() { ServiceComponentImpl::release(); }

	//------------------------------------------------------------------------
	uno::Any SAL_CALL OAdminAccess::queryInterface(uno::Type const& _rType) throw (uno::RuntimeException)
	{
		uno::Any aReturn = OAdminAccess_Base::queryInterface(_rType);
		if (!aReturn.hasValue())
			aReturn = ServiceComponentImpl::queryInterface(_rType);
		return aReturn;
	}

	// XTypeProvider
	//------------------------------------------------------------------------
	uno::Sequence< uno::Type > SAL_CALL OAdminAccess::getTypes() throw (uno::RuntimeException)
	{
		return ::comphelper::concatSequences(
			OAdminAccess_Base::getTypes(),
			ServiceComponentImpl::getTypes()
		);
	}		

	// XElementAccess		
	//-----------------------------------------------------------------------------
	uno::Type SAL_CALL OAdminAccess::getElementType( ) throw(uno::RuntimeException)
	{
		return ::getCppuType( static_cast< uno::Reference< uno::XInterface > *>(0) );		
	}

	//-----------------------------------------------------------------------------
	sal_Bool SAL_CALL OAdminAccess::hasElements(  ) throw(uno::RuntimeException)
	{
		return static_cast< container::XNameAccess *>(this)->getElementNames().getLength() != 0;
	}

	// XNameAccess		
	//-----------------------------------------------------------------------------
	sal_Bool SAL_CALL OAdminAccess::hasByName( const ::rtl::OUString& aName ) throw(uno::RuntimeException)
	{
		sal_Bool bFound = sal_False;
		try
		{
			bFound = getByName(aName).hasValue();
		}
		catch (uno::Exception&)
		{
		}
		return bFound;
	}

	// XNameReplace
	//-----------------------------------------------------------------------------
	void SAL_CALL OAdminAccess::replaceByName( const ::rtl::OUString& _rName, const uno::Any& _rElement ) throw (lang::IllegalArgumentException, container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException)
	{
		CFG_TRACE_WARNING_NI("admin access: replacing of entries not allowed!");
		OSL_ENSURE(false,"ERROR: replacing of entries not allowed, will be ignored!");
	}

		//-----------------------------------------------------------------------------
	// Helper class for managing a temporary transfer of ownership
	namespace
	{
		class TemporaryAddNode
		{
			SubtreeChange			m_aTemporaryChange;
			ElementTree& 			m_rOwningTree;
			AddNode*				m_pInsertOp;

		public:
			TemporaryAddNode(ElementTree& _rElementTree)
			: m_aTemporaryChange(OUString(), configuration::Attributes())
			, m_rOwningTree(_rElementTree)
			, m_pInsertOp(NULL)
			{}

			//-----------------------------------------------------------------------------
			~TemporaryAddNode()
			{
				restoreOwnership();
			}

			//-----------------------------------------------------------------------------
			SubtreeChange* makeAddNodeChange(OUString const& _sName)
			{
				restoreOwnership();
				
				std::auto_ptr<INode> aOwnedNode;
				ElementTree::releaseOwnedElement( aOwnedNode, m_rOwningTree);
				
				OSL_ENSURE(aOwnedNode.get(), "Unexpected: Trying to make temporary AddNode from non-owning ElementTree");
				if (!aOwnedNode.get())
					return NULL;

				aOwnedNode->setName(_sName);				

#if SUPD > 638
				m_pInsertOp = new AddNode( aOwnedNode, _sName, false );
#else
				m_pInsertOp = new AddNode( aOwnedNode, _sName );
#endif
				m_aTemporaryChange.addChange( std::auto_ptr<Change>(m_pInsertOp) );

				return &m_aTemporaryChange;
			}
			
			//-----------------------------------------------------------------------------
			void restoreOwnership()
			{
				if (m_pInsertOp)
				{
					std::auto_ptr<INode> aOwnedNode = m_pInsertOp->releaseAddedNode();
					m_pInsertOp = NULL;

					OSL_ENSURE(aOwnedNode.get(), "Unexpected: Use of temporary AddNode grabbed ownership");
					if (aOwnedNode.get())
						ElementTree::takeElementOwnership(aOwnedNode,m_rOwningTree);
				}
			}
		};
	}	

	// XNameContainer
	//-----------------------------------------------------------------------------
	void SAL_CALL OAdminAccess::insertByName( const ::rtl::OUString& _rName, const uno::Any& _rElement ) 
		throw (lang::IllegalArgumentException, container::ElementExistException, lang::WrappedTargetException, uno::RuntimeException)
	{
		::rtl::OUString sName(_rName.trim());
		CFG_TRACE_INFO("admin access: inserting a new element (named %s)", OUSTRING2ASCII(sName));		

		// check the arguments
		if (!sName.getLength())
		{
			CFG_TRACE_WARNING_NI("admin access: nserting element with no name");
			throw lang::IllegalArgumentException(rtl::OUString::createFromAscii("The name must not be empty."), static_cast< lang::XSingleServiceFactory* >(this), 1);
		}

		// extract the parentName
		uno::Reference< beans::XPropertySet > xSet(extractDataNode( _rElement ));
		rtl::OUString sParentName;			
		xSet->getPropertyValue(NODE_USERPROFILE_GROUP_FIELD) >>= sParentName;	

		// start inserting the object
		MutexGuard aGuard(m_aMutex);
		checkAlive();	

		try
		{			
			// create the template object
			TemplateHolder aHolder = configuration::makeTreeTemplate(NODE_USERTEMPLATE_NAME, NODE_USERTEMPLATE_MODULE, m_pProviderImpl->getSpecialTemplateProvider());
			ElementTree aElementTree = configapi::extractElementTree(m_pProviderImpl->getWriterFactory(), _rElement, SetElementInfo(aHolder) );
			if (!aElementTree.isValid())
				throw lang::IllegalArgumentException(rtl::OUString::createFromAscii("illegal type inserted!."), static_cast< lang::XSingleServiceFactory* >(this), 1);

			// lock it
			configapi::SetElement* pElementAccess = configapi::findSetElement(m_pProviderImpl->getWriterFactory(), aElementTree);
			if (pElementAccess == 0) 
				throw lang::IllegalArgumentException(rtl::OUString::createFromAscii("object is not accessible!."), static_cast< lang::XSingleServiceFactory* >(this), 1);			
			OWriteSynchronized aElementLock(aElementTree.getTreeLock());						

			vos::ORef< OOptions > xOptions = new OOptions(m_pProviderImpl->getDefaultOptions());
			vos::ORef< OUpdateCallback > xDataReqCb = new OUpdateCallback(getProfilePath().compose( makeFullName( sName ) ), xOptions);
						
			// make a temporary change tree that takes the ownership of the node during the transaction
			TemporaryAddNode aInsertHelper(aElementTree);
			if (SubtreeChange* pDummyRoot = aInsertHelper.makeAddNodeChange(sName))
			{
				ORemoteUpdateXMLAttributeHandler aAttributeHandler;
				XMLFormater aInterpreter(pDummyRoot, xOptions, aAttributeHandler);

				// adding the element
				insertElement( makeElementName(sName), makeElementName(sParentName), &aInterpreter, xDataReqCb.getBodyPtr());			
			}
			else
				throw lang::IllegalArgumentException(rtl::OUString::createFromAscii("object is not accessible!."), static_cast< lang::XSingleServiceFactory* >(this), 1);

			CFG_TRACE_INFO_NI("user access: adding element: waiting for the server response");			
			if (!xDataReqCb->waitForUpdate())		
			{
				CFG_TRACE_ERROR("user access: an error occured ...");				
				StatusInfo aStatus = xDataReqCb->getStatus();
				if (0 == aStatus.nCode)
				{
					aStatus.sMessage = ::rtl::OUString::createFromAscii("an error occured while inserting an element. code(");
					aStatus.sMessage += ::rtl::OUString::valueOf(xDataReqCb->getConnError());
					aStatus.sMessage += ::rtl::OUString::createFromAscii(").");
				}				
				throw lang::WrappedTargetException(aStatus.sMessage, static_cast< lang::XSingleServiceFactory* >(this), uno::Any());
			}			
		}
		catch (configuration::Exception& e)
		{
			throw lang::WrappedTargetException(e.message(),static_cast< lang::XSingleServiceFactory* >(this), uno::Any());
		}		
	}

	//-----------------------------------------------------------------------------
	void SAL_CALL OAdminAccess::removeByName( const ::rtl::OUString& _sName ) throw (container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException)
	{
		CFG_TRACE_INFO("element access: removing an existing element (named %s)", OUSTRING2ASCII(_sName));		

		// check the arguments
		if (!_sName.getLength())
		{
			CFG_TRACE_WARNING_NI("element access: removing a element with no name");
			throw lang::IllegalArgumentException(rtl::OUString::createFromAscii("The name must not be empty."), static_cast< lang::XSingleServiceFactory* >(this), 1);
		}

		MutexGuard aGuard(m_aMutex);
		checkAlive();

		try
		{
			::vos::ORef< TreeBuilderCallback > xBuilder = 
				new TreeBuilderCallback(TreeBuilderCallback::NoModule(), new OOptions(m_pProviderImpl->getDefaultOptions()));

			deleteElement(makeElementName(_sName), xBuilder.getBodyPtr());
			CFG_TRACE_INFO_NI("admin access: removing element: waiting for the server response");			
			xBuilder->waitToResponse(m_pProviderImpl->getSession()->getMasterTimeout());
			
			StatusInfo aStatus = xBuilder->getCallResult();						
			
			if (0 == aStatus.nCode)
			{
				vos::ORef< OOptions > xElement( new OOptions(0) );
				xElement->setUser(_sName);
				OSL_ASSERT(xElement->getLocale().getLength() == 0); // Must identify a user, not an option set
				m_pProviderImpl->disposeData(xElement);
			}
			else
			{
				CFG_TRACE_ERROR("admin access: an error occured ...");									
				throw lang::WrappedTargetException(aStatus.sMessage, NULL, uno::Any());
			}			
		}
		catch (configuration::Exception& e)
		{
			throw lang::WrappedTargetException(e.message(),NULL, uno::Any());
		}
	}	

	// XSingleServiceFactory
	//-----------------------------------------------------------------------------
	uno::Reference< uno::XInterface > SAL_CALL OAdminAccess::createInstance(  ) throw(uno::Exception, uno::RuntimeException)
	{
		return createInstanceWithArguments(uno::Sequence< uno::Any >());
	}

	//-----------------------------------------------------------------------------
	uno::Reference< uno::XInterface > SAL_CALL OAdminAccess::createInstanceWithArguments( const uno::Sequence< uno::Any >& _rArgs ) throw(uno::Exception, uno::RuntimeException)
	{
		MutexGuard aGuard(m_aMutex);
		checkAlive();

		try
		{			
			rtl::OUString sParentName;			
			// do we have a parent to use to ?
			if (_rArgs.getLength() == 1)
			{
				beans::PropertyValue aGroupSetting;		
				if (_rArgs[0] >>= aGroupSetting)
				{
					if (aGroupSetting.Name.equalsIgnoreAsciiCase(PARAM_GROUP))
						aGroupSetting.Value >>= sParentName;
					else						
					{
						throw lang::IllegalArgumentException(
										(OUString(RTL_CONSTASCII_USTRINGPARAM("The argument ")) += aGroupSetting.Name) += OUString(RTL_CONSTASCII_USTRINGPARAM(" could not be extracted.")),
										uno::Reference< uno::XInterface >(),0);
					}
				}
			}
			
			
			CFG_TRACE_INFO("admin access: providing template for element");			

			// create the template object
			ORef <OOptions> xOptions = new OOptions(m_pProviderImpl->getDefaultOptions());			
			TemplateHolder aHolder = configuration::makeTreeTemplate(NODE_USERTEMPLATE_NAME, NODE_USERTEMPLATE_MODULE, m_pProviderImpl->getSpecialTemplateProvider());			
			
			// get the element factory
			configuration::SetElementFactory aFactory = configuration::SetElementFactory( m_pProviderImpl->getTemplateInstanceProvider(xOptions) );			
			
			// create thre tree
			ElementTree aTree(aFactory.instantiateTemplate(aHolder));
			uno::Reference< uno::XInterface > xObj = m_pProviderImpl->getWriterFactory().makeUnoSetElement(aTree);				

			// set the parentName
			uno::Any aProfile;
			aProfile <<= xObj;
			uno::Reference< beans::XPropertySet > xSet(extractDataNode( aProfile ));			
			
			uno::Any aParent;
			aParent <<= sParentName;
			xSet->setPropertyValue(NODE_USERPROFILE_GROUP_FIELD, aParent);			

			return xObj;
		}
		catch (configuration::Exception& e)
		{
			throw uno::RuntimeException(e.message(), static_cast< lang::XSingleServiceFactory* >(this));
		}		
		catch (uno::Exception& e)
		{
			throw uno::RuntimeException(e.Message, static_cast< lang::XSingleServiceFactory* >(this));
		}		

		return uno::Reference< uno::XInterface >();
	}


	// helper methods
	//-----------------------------------------------------------------------------
	uno::Any OAdminAccess::getElement( uno::Sequence< uno::Any > const& _rArgs ) throw(container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException)
	{
		// requesting a certain user node
		MutexGuard aGuard(m_aMutex);
		checkAlive();						

		uno::Reference < uno::XInterface > xElement;
		try
		{
			xElement = m_pProviderImpl->createUpdateAccess(_rArgs);
		}
		catch ( uno::RuntimeException& )
		{
			throw;
		}		
		catch ( lang::WrappedTargetException&  )
		{
			throw;
		}
		catch ( uno::Exception& e )
		{
			uno::Any aException;
			aException <<= e;
			throw lang::WrappedTargetException(e.Message, static_cast< uno::XWeak* >(this), aException);
		}

		uno::Any aReturn;
		aReturn <<= xElement;		
		return aReturn;
	}

	//-----------------------------------------------------------------------------
	uno::Sequence< ::rtl::OUString > OAdminAccess::getElementNames( const AbsolutePath& _rPath ) throw(uno::RuntimeException)
	{
		// requesting all nodes from the userprofile toplevel
        MutexGuard aGuard(m_aMutex);
		checkAlive();

		CFG_TRACE_INFO("admin access: reading all user names");
		::vos::ORef<OOptions> xOptions(new OOptions(m_pProviderImpl->getDefaultOptions()));
		xOptions->setUser(NODE_TOPLEVEL);

		::vos::ORef< TreeBuilderCallback > xBuilder = 
				new TreeBuilderCallback(TreeBuilderCallback::NoModule(), xOptions);	

		IConfigSession*	pSession = m_pProviderImpl->getSession();
		pSession->asIUpdateProvider()->openNode(_rPath, xOptions, 1, xBuilder.getBodyPtr());

		std::auto_ptr<ISubtree> pReturn = xBuilder->waitToResponse(pSession->getMasterTimeout());
		StatusInfo aStatus = xBuilder->getCallResult();

		uno::Sequence< ::rtl::OUString > aResult;
		
		if (0 == aStatus.nCode)
		{
			// Iterate over the childs of the tree
			CollectNames aCollect;
			pReturn->forEachChild(aCollect);
			aResult = encodename::decode(configmgr::makeSequence( aCollect.list() ));			
		}
		return aResult;		
	}		

	//-----------------------------------------------------------------------------
	uno::Reference< beans::XPropertySet > OAdminAccess::extractDataNode( const uno::Any& _rElement )
		throw (lang::IllegalArgumentException, lang::WrappedTargetException, uno::RuntimeException)
	{
		uno::Reference< container::XHierarchicalNameAccess > xProfile;
		_rElement >>= xProfile;
		if (!xProfile.is())
			throw lang::IllegalArgumentException(rtl::OUString::createFromAscii("object is not accessible!."), static_cast< lang::XSingleServiceFactory* >(this), 1);		

		uno::Reference< beans::XPropertySet > xSet;		
		try
		{			
			xProfile->getByHierarchicalName(NODE_USERPROFILE_GROUP_PATH) >>= xSet;						
		}
		catch (container::NoSuchElementException& e)
		{
			uno::Any aException;
			aException <<= e;
			throw lang::WrappedTargetException(e.Message, static_cast< uno::XWeak* >(this), aException);			
		}												   

		OSL_ENSURE(xSet.is(), "element access: an error occured, not able to read the elements parent");
		if (!xSet.is())
			throw lang::IllegalArgumentException(rtl::OUString::createFromAscii("illegal object!."), static_cast< lang::XSingleServiceFactory* >(this), 1);
		
		return xSet;
	}
} // namespace configmgr


